/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.GridBagAdder;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.CommonTableModel;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SummitTransmitterPanel
extends JPanel
implements DeviceErrorCodes,
CssConstants {
    private static final long serialVersionUID = 1L;
    private static final String FILE = "SummitTransmitterPanel";
    private final int NUM_ROWS = 3;
    private static final String TRANSMITTER_TEST_SUCCESSFUL = "Current Status: Transmitter Test Was Successful In The Station";
    private static final String TRANSMITTER_TEST_FAIL = "Current Status: Transmitter Test Failed In The Station";
    private static final String TRANSMITTER_TEST_UNKNOWN = "No Such Response for transmitter test";
    private static final String TRANSMITTER_TEST_IN_PROGRESS = "Current Status: Transmitter Test In Progress";
    public JButton m_transmitterTestBtn;
    private final String[] m_fields = new String[]{"Current Measured Forward Power (Watts)", "Current Measured Reflected Power (Watts)", "Current Measured VSWR", "Current Stored Measured Forward Power (Watts)", "Current Stored Measured Reflected Power (Watts)", "Current Stored Measured VSWR"};
    private final String[] m_columnNames = new String[]{"Item", "Current"};
    private String[] m_current = new String[]{"Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"};
    private final Object[][] m_data = new Object[][]{{this.m_fields[0], this.m_current[0]}, {this.m_fields[1], this.m_current[1]}, {this.m_fields[2], this.m_current[2]}, {this.m_fields[3], this.m_current[3]}, {this.m_fields[4], this.m_current[4]}, {this.m_fields[5], this.m_current[5]}};
    private JLabel m_currentStatus;
    private ErrorPopup m_errorPopup;
    private JTable m_table;
    private UIInternalFrame m_window;
    private boolean m_realtimeUpdateCalled = false;
    private boolean m_updateTransmitterTestCalled = false;

    public SummitTransmitterPanel() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter SummitTransmitterPanel Constructor");
        this.m_errorPopup = new ErrorPopup();
        this.m_table = new JTable();
        Audit.audit((int)1010, (String)FILE, (String)"Exit SummitTransmitterPanel Constructor");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        Audit.audit((int)1009, (String)FILE, (String)"Enter buildScreen");
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        CommonTableModel commonTableModel = new CommonTableModel();
        commonTableModel.setDataVector(this.m_data, this.m_columnNames);
        this.m_table.setModel(commonTableModel);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(50);
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(350, 150));
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)0, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        JLabel jLabel = new JLabel();
        jPanel.add(jLabel);
        this.m_transmitterTestBtn = new JButton("Transmitter Test");
        this.m_transmitterTestBtn.setToolTipText("Perform Transmitter Test");
        jPanel.add(this.m_transmitterTestBtn);
        JLabel jLabel2 = new JLabel();
        jPanel.add(jLabel2);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)4, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)10, (int)0, (int)10, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 0, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.m_currentStatus = new JLabel("         ");
        jPanel2.add(this.m_currentStatus);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)6, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_transmitterTestBtn, "Click this button to perform Transmitter Test");
        this.m_window.setCursor(new Cursor(3));
        Audit.audit((int)1010, (String)FILE, (String)"Exit buildScreen");
    }

    public synchronized void initialize() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter initialize");
        for (int i = 0; i < 3; ++i) {
            this.m_current[i] = "Unknown";
        }
        this.m_currentStatus.setText(" ");
        this.setTransmitterTestButtonEnabled(true);
        this.m_realtimeUpdateCalled = false;
        this.m_updateTransmitterTestCalled = false;
        Audit.audit((int)1010, (String)FILE, (String)"Exit initialize");
    }

    public synchronized boolean realTimeUpdate(RealTimeDataObject realTimeDataObject) {
        String string = new String("");
        boolean bl = false;
        Audit.audit((int)1009, (String)FILE, (String)"Enter realTimeUpdate.");
        RealTimeDataObject realTimeDataObject2 = realTimeDataObject;
        for (int i = 0; i < realTimeDataObject2.getSize(); ++i) {
            try {
                byte[] byArray;
                string = realTimeDataObject2.getName(i);
                if (string.equals("forwardPower")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[0] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[0], 0, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("reflectedPower")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[1] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[1], 1, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("stationVswr")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[2] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[2], 2, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("storedForwardPower")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[3] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[3], 3, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("storedReflectedPower")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[4] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[4], 4, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("storedStationVswr")) {
                    byArray = (byte[])realTimeDataObject2.getValue(i);
                    this.m_current[5] = this.convertValueUnsigned(byArray);
                    this.m_table.setValueAt(this.m_current[5], 5, 1);
                    bl = true;
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterTest")) {
                    byArray = (byte[])realTimeDataObject2.getValue(string);
                    int n = Convert.toInteger((byte[])byArray);
                    this.setTransmitterTestButtonEnabled(true);
                    if (n == 1) {
                        this.m_currentStatus.setText(TRANSMITTER_TEST_SUCCESSFUL);
                    } else if (n == 2) {
                        this.m_currentStatus.setText(TRANSMITTER_TEST_FAIL);
                    } else {
                        this.m_errorPopup.display(TRANSMITTER_TEST_UNKNOWN);
                        this.m_currentStatus.setText(" ");
                    }
                    bl = true;
                    continue;
                }
                if (!string.equalsIgnoreCase("ErrorMessage")) continue;
                byArray = (byte[])realTimeDataObject2.getValue(string);
                int n = Convert.toInteger((byte[])byArray);
                if (!this.m_updateTransmitterTestCalled) {
                    this.m_realtimeUpdateCalled = true;
                }
                this.setTransmitterTestButtonEnabled(true);
                switch (n) {
                    case 2: {
                        this.m_errorPopup.display(-327834);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 3: {
                        this.m_errorPopup.display(-327835);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 4: {
                        this.m_errorPopup.display(-327836);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 5: {
                        this.m_errorPopup.display(-327837);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 6: {
                        this.m_errorPopup.display(-620001);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 7: {
                        this.m_errorPopup.display(-327839);
                        break;
                    }
                    case 8: {
                        this.m_errorPopup.display(-327861);
                        this.m_currentStatus.setText(" ");
                        break;
                    }
                    case 9: {
                        this.m_errorPopup.display(-327862);
                        this.m_currentStatus.setText(" ");
                    }
                }
                bl = true;
                continue;
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)1001, (String)FILE, (String)"realTimeUpdate: Received unexpected field name which is not in the table");
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit realTimeUpdate");
        return bl;
    }

    private String convertValueUnsigned(byte[] byArray) {
        int n = 0;
        String string = null;
        for (int i = 0; i < byArray.length; ++i) {
            n += 0xFF & byArray[i];
            if (i >= byArray.length - 1) continue;
            n <<= 8;
        }
        string = n > 150 ? "" : Integer.toString(n);
        return string;
    }

    public synchronized void updateTransmitterTest(int n) {
        if (n == 0) {
            if (!this.m_realtimeUpdateCalled) {
                this.setTransmitterTestButtonEnabled(false);
                this.m_currentStatus.setText(TRANSMITTER_TEST_IN_PROGRESS);
                this.m_updateTransmitterTestCalled = true;
            }
        } else {
            this.setTransmitterTestButtonEnabled(true);
            this.m_currentStatus.setText(TRANSMITTER_TEST_FAIL);
        }
    }

    public void handleStartExciterMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStartExciterMetering Error:" + n));
        this.m_window.unlockWindow();
        this.m_window.setCursor(new Cursor(0));
        if (n != 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.m_current.length) {
                this.m_current[n2] = "Unknown";
                this.m_table.setValueAt(this.m_current[n2], n3, 1);
                ++n2;
                ++n3;
            }
            this.m_errorPopup.display(-327831);
            Audit.audit((int)1002, (String)FILE, (String)"Transmiter Metering Command Error");
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStartExciterMetering");
    }

    public void handleStopMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStopMetering(): g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)FILE, (String)("Received error " + n + " while trying to stop transmitter metering"));
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStopMetering()");
    }

    private void setTransmitterTestButtonEnabled(boolean bl) {
        this.m_transmitterTestBtn.setEnabled(bl);
    }
}

