/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.NotFoundException;
import css.core.util.CssConstants;
import css.device.common.protocol.cmdmgr.CmdMgrConstants;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.protocol.cmdmgr.SessionInfo;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.util.Vector;
import pnm.util.Audit;

class DeviceSessions
implements CssConstants,
CmdMgrConstants,
DeviceConstants,
DeviceErrorCodes {
    private Vector m_sessionList;

    public DeviceSessions() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DeviceSessions Constructor");
        this.m_sessionList = new Vector();
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit DeviceSessions Constructor");
    }

    public Vector getSessions() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter DeviceSessions.getSessions");
        return this.m_sessionList;
    }

    public int addEntry(int n, String string, int n2, Protocol protocol) {
        SessionInfo sessionInfo;
        int n3 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.addEntry.  ID=" + n + " Name=" + string + " Port=" + n2));
        for (int i = 0; i < this.m_sessionList.size() && n3 == 0; ++i) {
            sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (sessionInfo.getID() != n) continue;
            n3 = -1;
        }
        if (n3 == 0) {
            sessionInfo = new SessionInfo(n, string, n2, protocol);
            this.m_sessionList.addElement(sessionInfo);
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DeviceSessions.addentry. Status=" + n3));
        return n3;
    }

    public int deletePort(int n) {
        int n2 = -20;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.deletePort. Port=" + n));
        for (int i = this.m_sessionList.size() - 1; i >= 0; --i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (n != sessionInfo.getPortNumber() || sessionInfo.getID() == 0) continue;
            this.m_sessionList.removeElementAt(i);
            n2 = 0;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DeviceSessions.deletePort. Status=" + n2));
        return n2;
    }

    public int deleteEntry(int n) {
        boolean bl = false;
        int n2 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.deleteEntry. ID=" + n));
        for (int i = 0; i < this.m_sessionList.size() && !bl; ++i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (n != sessionInfo.getID()) continue;
            bl = true;
            this.m_sessionList.removeElementAt(i);
        }
        if (!bl) {
            n2 = -20;
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit DeviceSessions.deleteEntry.  Status=" + n2));
        return n2;
    }

    public Vector getProtocolHandlesFromPort(int n) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandlesFromPort. Port=" + n));
        Vector<Protocol> vector = new Vector<Protocol>();
        for (int i = 0; i < this.m_sessionList.size(); ++i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (n != sessionInfo.getPortNumber()) continue;
            vector.addElement(sessionInfo.getHandle());
        }
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandleFromPort.");
        return vector;
    }

    public Protocol getProtocolHandle(int n) throws NotFoundException {
        Protocol protocol = null;
        boolean bl = false;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandle. ID" + n));
        for (int i = 0; i < this.m_sessionList.size() && !bl; ++i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (n != sessionInfo.getID()) continue;
            bl = true;
            protocol = sessionInfo.getHandle();
        }
        if (!bl) {
            throw new NotFoundException("No handle found in getProcotolHandle");
        }
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandle");
        return protocol;
    }

    public Protocol getProtocolHandleFromName(String string) throws NotFoundException {
        Protocol protocol = null;
        boolean bl = false;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter DeviceSessions.getProtocolHandleFromName. Name=" + string));
        for (int i = 0; i < this.m_sessionList.size() && !bl; ++i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (!sessionInfo.getName().equalsIgnoreCase(string)) continue;
            bl = true;
            protocol = sessionInfo.getHandle();
        }
        if (!bl) {
            throw new NotFoundException("Protocol not found in getProtocolHandleFromName");
        }
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit DeviceSessions.getProtocolHandleFromName.");
        return protocol;
    }

    public int getPort(int n) {
        boolean bl = false;
        int n2 = -1;
        for (int i = 0; i < this.m_sessionList.size() && !bl; ++i) {
            SessionInfo sessionInfo = (SessionInfo)this.m_sessionList.elementAt(i);
            if (n != sessionInfo.getID()) continue;
            bl = true;
            n2 = sessionInfo.getPortNumber();
        }
        return n2;
    }

    public String dumpDeviceSessions() {
        Vector vector = this.getSessions();
        String string = new String();
        for (int i = 0; i < vector.size(); ++i) {
            SessionInfo sessionInfo = (SessionInfo)vector.elementAt(i);
            string = string + new String("Session Name = " + sessionInfo.getName() + " Session ID = " + sessionInfo.getID() + " Port Number = " + sessionInfo.getPortNumber());
        }
        return string;
    }
}

