/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.appservices.cs.ConnectionInfoObject;
import css.core.appservices.cs.ConnectionService;
import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.protocol.ProtocolListener;
import css.core.screens.tools.StatusBarListener;
import css.core.service.CmdHandler;
import css.core.service.DataObject;
import css.core.util.CSSException;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.DateAndTimeConversion;
import css.core.util.ErrorLogUtilities;
import css.core.util.InformationScreen;
import css.core.util.component.CustomizedRowHeightTable;
import css.core.util.component.FilterableTableComponent;
import css.core.util.component.FilterableTableModel;
import css.core.util.component.GenericListener;
import css.core.util.component.MultiLineTextRenderer;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.util.ErrorLogsDataHandler;
import css.device.common.util.StatusReportTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.EngineUtilities;
import pnm.util.ValidatePath;
import pnm.util.path.PathConstants;

public class CommonStatusReportPanel
extends GenericScreen {
    private static final CssLogger LOG = CssLogger.getCssLogger(CommonStatusReportPanel.class);
    private static final String SAVE_BUTTON_NAME = "Save Report";
    private static final String SAVE_BUTTON_STATUSMSG = "Click this button to save the report to a file";
    private static final String SAVE_BUTTON_TOOLTIP = "Saves the report to the file specified by the user.";
    private static final String SAVE_FILTERED_BUTTON_NAME = "Save Filtered Report";
    private static final String SAVE_FILTERED_BUTTON_TOOLTIP = "Saves the filtered report to the file specified by the user.";
    private static final String FILTER_TEXT_STATUSMSG = "Text used to filter data on the table";
    private static final long serialVersionUID = -1L;
    private static final String TIMEOUT_HAS_OCCURRED_WHILE_CSS_WAS_WAITING_FOR_THE_DEVICE_TO_BECOME_READY = "Timeout has occurred while CSS was waiting for the device to become ready.";
    private static final String DO_YOU_WANT_TO_RETRY_OPERATION = "Do you want to retry operation?";
    private final String LOCAL_ERRORLOG_FILE = PathConstants.CSS_TEMPDIR_CHAIN.toString() + "errorlog.xml";
    private final int FTP_TRANSFER_PROTOCOL = 1;
    private final int SFTP_TRANSFER_PROTOCOL = 2;
    private final int PULL_PROTOCOL_DIRECTION = 1;
    private final int COMPRESSION_TYPE_NONE = 1;
    private final int INTERNAL = 1;
    private final int EXTERNAL = 2;
    private final int IDLE = 1;
    private final int BUILDCOMPLETE = 4;
    private final int TRANSFERING = 8;
    private final int TRANSFERCOMPLETE = 16;
    private final int CLEARED = 64;
    private final int FAILURE = 128;
    private final int DTD_DOWNLOAD_FAIL = 999;
    private final int OCCURRENCE_TIME_COL_WIDTH = 115;
    private final int OCCURRENCE_TIME_COL_WIDTH_MAX = 115;
    private final int OCCURRENCE_TIME_COL_WIDTH_MIN = 115;
    private final int DESCRIPTION_COL_WIDTH = 200;
    private final int DESCRIPTION_COL_WIDTH_MAX = 450;
    private final int DESCRIPTION_COL_WIDTH_MIN = 100;
    private final int OTHER_COL_WIDTH = 70;
    private final int OTHER_COL_WIDTH_MAX = 300;
    private final int OTHER_COL_WIDTH_MIN = 50;
    private final int DEVICE_AGENT_STATE_IDLE = 1;
    private final int DEVICE_AGENT_STATE_BUILDING = 2;
    private final int DEVICE_AGENT_STATE_BUILDCOMPLETE = 3;
    private final int DEVICE_AGENT_STATE_TRANSFERING = 4;
    private final int DEVICE_AGENT_STATE_CLEARING = 6;
    private final int DEVICE_AGENT_STATE_FAILURE = 8;
    private final int CHECKING_DEVICE_STATE_MAX_ATTEMPTS = 20;
    private final int DEVICE_ERRORLOG_BUILD_CMD = 1;
    private final int DEVICE_ERRORLOG_TRANSFER_CMD = 2;
    private final int DEVICE_ERRORLOG_CLEAR_CMD = 3;
    private final int DEVICE_ERRORLOG_IDLE_CMD = 4;
    private final String TABLE_TITLE = " ";
    private final String INT_REPORT_MSG = "Selected Report Type Is Not Viewable. Click Save Report Button To Save To File";
    private static ErrorPopup m_errorPopup = new ErrorPopup();
    InformationScreen m_oInformationScreen = new InformationScreen();
    private Object m_actionListener;
    public GenericListener m_genericListener;
    public String m_userLogFileName;
    private boolean m_protocolSupported = false;
    private int m_protocolXferIndex;
    private int m_currSelectedLog = 0;
    private String[] m_fileName;
    private Integer[] m_fileParseType;
    private Integer[] m_fileCompression;
    private Integer[] m_fileProtocolXferIndex;
    private int m_downLoadFileIndex;
    private boolean m_errorLogProcessStatus = true;
    private JPanel m_reportInfoPanel = new JPanel();
    private JPanel m_centerPanel = new JPanel();
    private JScrollPane m_scrollPane = new JScrollPane();
    private JPanel m_reportBtnPanel = new JPanel();
    private JLabel m_dateTimeLbl = new JLabel();
    private JLabel m_dateTimeLblValue = new JLabel();
    private JLabel m_typeOfStatusReportLbl = new JLabel();
    private JComboBox m_typeOfStatusReportCbBox = new JComboBox();
    private JLabel m_tableTitleLbl = new JLabel();
    private ActionListener m_reportTypeHandlerAction = new ReportTypeHandler();
    private FilterableTableComponent m_voReportTableComponent = null;
    private CustomizedRowHeightTable m_voReportTable = null;
    private FilterableTableModel m_statusReportTblMdl = null;
    public JButton m_refreshBtn = new JButton();
    public JButton m_saveLogBtn = new JButton();
    public JButton m_clearLogBtn = new JButton();
    public JButton m_clearIntLogBtn = new JButton();
    public JButton m_clearExtLogBtn = new JButton();
    public JButton m_saveIntLogBtn = new JButton();
    public JButton m_saveExtLogBtn = new JButton();
    private ProgressMonitor m_statusReportProgressMonitor;
    private int m_progress = 0;
    private boolean m_bSetIdleState = false;
    private FilteringChangedHandler m_oFilteringStateChangeHandler = new FilteringChangedHandler();
    private StatusBarListener m_oStatusBarListener = null;

    public CommonStatusReportPanel() {
        LOG.enter("CommonStatusReportPanel");
        LOG.exit("CommonStatusReportPanel");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_oStatusBarListener = statusBarListener;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonStatusReportPanel.this);
                CommonStatusReportPanel.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        this.m_window.getContentPane().add("Center", this);
        this.m_reportInfoPanel.setLayout(new GridBagLayout());
        this.m_dateTimeLbl.setText("Report Date/Time");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_dateTimeLbl, gridBagConstraints);
        this.m_dateTimeLblValue.setText("N/A");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_dateTimeLblValue, gridBagConstraints);
        this.m_typeOfStatusReportLbl.setText("Report Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 10, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_typeOfStatusReportLbl, gridBagConstraints);
        this.m_typeOfStatusReportCbBox.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.0;
        this.m_reportInfoPanel.add((Component)this.m_typeOfStatusReportCbBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_reportInfoPanel, gridBagConstraints);
        this.m_centerPanel.setLayout(new GridBagLayout());
        this.m_tableTitleLbl.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_centerPanel.add((Component)this.m_tableTitleLbl, gridBagConstraints);
        this.m_statusReportTblMdl = null;
        this.m_voReportTable = new CustomizedRowHeightTable((TableModel)new FilterableTableModel((AbstractTableModel)new StatusReportTableModel()));
        this.m_voReportTable.setShowHeaderToolTip(true);
        this.m_voReportTable.setAutoscrolls(true);
        this.m_voReportTable.setAutoResizeMode(2);
        this.m_voReportTable.setShowHorizontalLines(true);
        this.m_voReportTable.setShowVerticalLines(true);
        this.m_voReportTable.setDefaultRenderer(Object.class, (TableCellRenderer)new MultiLineTextRenderer());
        this.m_voReportTableComponent = new FilterableTableComponent();
        this.m_voReportTableComponent.initComponent((JTable)this.m_voReportTable);
        this.m_voReportTableComponent.addEnableFilteringItemListener((ItemListener)this.m_oFilteringStateChangeHandler);
        this.m_voReportTableComponent.addFocusListener(this.m_oStatusBarListener, FILTER_TEXT_STATUSMSG);
        this.m_scrollPane.setViewportView((Component)this.m_voReportTableComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.m_centerPanel.add((Component)this.m_voReportTableComponent, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.m_centerPanel, gridBagConstraints);
        this.m_reportBtnPanel.setLayout(new GridBagLayout());
        this.m_saveLogBtn.setText(SAVE_FILTERED_BUTTON_NAME);
        this.m_saveLogBtn.setActionCommand(SAVE_BUTTON_NAME);
        this.m_saveLogBtn.setMinimumSize(new Dimension(133, 25));
        this.m_saveLogBtn.setPreferredSize(new Dimension(133, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_saveLogBtn, gridBagConstraints);
        this.m_refreshBtn.setText("Refresh");
        this.m_refreshBtn.setActionCommand("Refresh");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_refreshBtn, gridBagConstraints);
        this.m_clearLogBtn.setText("Clear Report");
        this.m_clearLogBtn.setActionCommand("Clear Report");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.m_reportBtnPanel.add((Component)this.m_clearLogBtn, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.m_reportBtnPanel, gridBagConstraints);
        this.m_genericListener = new GenericListener();
        this.m_dateTimeLbl.setToolTipText("Date/Time the current report was received from the station.");
        this.m_typeOfStatusReportLbl.setToolTipText("Type of status report to be displayed.");
        this.m_saveLogBtn.setToolTipText(SAVE_FILTERED_BUTTON_TOOLTIP);
        this.m_refreshBtn.setToolTipText("Rereads the report.");
        this.m_clearLogBtn.setToolTipText("Deletes this report log from the station.");
        statusBarListener.registerComponent((Component)this.m_saveLogBtn, SAVE_BUTTON_STATUSMSG);
        statusBarListener.registerComponent((Component)this.m_refreshBtn, "Click this button to get the same type of report again");
        statusBarListener.registerComponent((Component)this.m_clearLogBtn, "Click this button to delete this report log from the station");
        this.m_typeOfStatusReportCbBox.setNextFocusableComponent((Component)this.m_voReportTableComponent);
        this.m_voReportTableComponent.setNextFocusableComponent((Component)this.m_saveLogBtn);
        this.m_saveLogBtn.setNextFocusableComponent(this.m_refreshBtn);
        this.m_refreshBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_clearLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_saveIntLogBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_saveExtLogBtn.setNextFocusableComponent(this.m_clearLogBtn);
        this.m_clearIntLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_clearExtLogBtn.setNextFocusableComponent(this.m_typeOfStatusReportCbBox);
        this.m_typeOfStatusReportCbBox.requestFocus();
        LOG.exit("buildScreen");
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.m_typeOfStatusReportCbBox.removeActionListener(this.m_reportTypeHandlerAction);
        this.m_typeOfStatusReportCbBox.removeAllItems();
        this.enableReportTable();
        LOG.exit("initialize");
    }

    public void updateScreenDateTime(int n, Integer n2) {
        LOG.enter("updateScreenDateTime", new Object[]{Integer.toString(n), n2});
        if (n == 0) {
            int n3 = n2;
            this.m_dateTimeLblValue.setText(DateAndTimeConversion.getDate((int)n3) + " " + DateAndTimeConversion.getTime((int)n3));
        } else {
            this.m_dateTimeLblValue.setText("N/A");
        }
        LOG.exit("updateScreenDateTime");
    }

    void abortProcess(int n) {
        LOG.enter("abortProcess", new Object[]{Integer.toString(n)});
        this.m_errorLogProcessStatus = false;
        if (n == -196708) {
            m_errorPopup.display(-262166);
        } else if (n == -262180) {
            m_errorPopup.display(-262180);
        } else if (n >= -131071 && n <= -65536) {
            m_errorPopup.display(-262176);
        } else if (n >= -262182 && n <= -262166) {
            m_errorPopup.display(n);
        } else if (n >= -196608 && n <= -196708) {
            m_errorPopup.display(-262181);
        } else if (n == 999) {
            m_errorPopup.display(-262176);
        } else {
            m_errorPopup.display(-262182);
            LOG.warn((Object)("Unknown Error Received: g_error #" + n));
        }
        this.m_statusReportProgressMonitor.close();
        this.enableActionComponents();
        LOG.exit("abortProcess");
    }

    void disableActionComponents() {
        LOG.enter("disableActionComponents");
        this.m_typeOfStatusReportCbBox.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        this.m_saveLogBtn.setEnabled(false);
        this.m_clearLogBtn.setEnabled(false);
        LOG.exit("disableActionComponents");
    }

    void enableActionComponents() {
        LOG.enter("enableActionComponents");
        this.m_typeOfStatusReportCbBox.setEnabled(true);
        this.m_saveLogBtn.setEnabled(true);
        this.m_clearLogBtn.setEnabled(true);
        if (this.m_voReportTableComponent.isEnabled()) {
            this.m_refreshBtn.setEnabled(true);
        }
        LOG.exit("enableActionComponents");
    }

    private void updateProgress(int n) {
        LOG.enter("updateProgress", new Object[]{Integer.toString(n)});
        if (this.m_errorLogProcessStatus) {
            this.m_statusReportProgressMonitor.setProgress(n);
        }
        LOG.exit("updateProgress");
    }

    private void updateProgress(int n, String string) {
        LOG.enter("updateProgress", new Object[]{Integer.toString(n), string});
        if (this.m_errorLogProcessStatus) {
            this.m_statusReportProgressMonitor.setProgress(n);
            this.m_statusReportProgressMonitor.setNote(string);
        }
        LOG.exit("updateProgress");
    }

    private void disableEntireScreen() {
        LOG.enter("disableEntireScreen");
        this.m_typeOfStatusReportCbBox.setEnabled(false);
        this.m_voReportTableComponent.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        this.m_saveLogBtn.setEnabled(false);
        this.m_clearLogBtn.setEnabled(false);
        LOG.exit("disableEntireScreen");
    }

    private void disableReportTable() {
        LOG.enter("disableReportTable");
        this.m_voReportTableComponent.setEnabled(false);
        this.m_refreshBtn.setEnabled(false);
        LOG.exit("disableReportTable");
    }

    private void enableReportTable() {
        LOG.enter("enableReportTable");
        if (!this.m_voReportTableComponent.isEnabled()) {
            this.m_voReportTableComponent.setEnabled(true);
        }
        this.m_refreshBtn.setEnabled(true);
        LOG.exit("enableReportTable");
    }

    private void clearTable() {
        LOG.enter("clearTable");
        if (this.isReportTypeExternal()) {
            this.m_tableTitleLbl.setText(" ");
        }
        try {
            StatusReportTableModel statusReportTableModel = StatusReportTableModel.clearTable((StatusReportTableModel)this.m_statusReportTblMdl.getNonFilteredTableModel());
            this.m_statusReportTblMdl = new FilterableTableModel((AbstractTableModel)statusReportTableModel);
            this.m_voReportTableComponent.setModel(this.m_statusReportTblMdl);
            this.m_voReportTableComponent.addEnableFilteringItemListener((ItemListener)this.m_oFilteringStateChangeHandler);
            this.m_voReportTableComponent.addFocusListener(this.m_oStatusBarListener, FILTER_TEXT_STATUSMSG);
            this.setupTableComponent(statusReportTableModel);
            this.m_voReportTableComponent.setFilteringState(false);
        }
        catch (Exception exception) {
            LOG.error((Object)"clearTable - exception thrown: ", (Throwable)exception);
        }
        LOG.exit("clearTable");
    }

    private void setupTableComponent(StatusReportTableModel statusReportTableModel) {
        Serializable serializable;
        LOG.enter("setupTableComponent", new Object[]{statusReportTableModel});
        int n = statusReportTableModel.getColumnCount();
        String[] stringArray = statusReportTableModel.getColumsArray();
        for (int i = 0; i < n; ++i) {
            String string;
            serializable = this.m_voReportTable.getColumnModel().getColumn(i);
            TableCellRenderer tableCellRenderer = ((TableColumn)serializable).getHeaderRenderer();
            if (tableCellRenderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText(stringArray[i]);
            }
            if ((string = ((TableColumn)serializable).getHeaderValue().toString()).equals("Occurrence Time")) {
                ((TableColumn)serializable).setMinWidth(115);
                ((TableColumn)serializable).setPreferredWidth(115);
                ((TableColumn)serializable).setMaxWidth(115);
                continue;
            }
            if (string.equals("Description")) {
                ((TableColumn)serializable).setMinWidth(100);
                ((TableColumn)serializable).setPreferredWidth(200);
                ((TableColumn)serializable).setMaxWidth(450);
                continue;
            }
            ((TableColumn)serializable).setMinWidth(50);
            ((TableColumn)serializable).setPreferredWidth(70);
            ((TableColumn)serializable).setMaxWidth(300);
        }
        JTableHeader jTableHeader = this.m_voReportTable.getTableHeader();
        jTableHeader.setReorderingAllowed(true);
        serializable = new Dimension(this.m_voReportTableComponent.getPreferredSize());
        this.m_voReportTable.setPreferredScrollableViewportSize((Dimension)serializable);
        this.m_scrollPane.setPreferredSize(new Dimension(((Dimension)serializable).width, 160));
        this.m_voReportTableComponent.revalidate();
        LOG.exit("setupTableComponent");
    }

    private int getScreenSelectedErrorLog() {
        LOG.enter("getScreenSelectedErrorLog");
        int n = this.m_typeOfStatusReportCbBox.getSelectedIndex();
        LOG.exit("getScreenSelectedErrorLog", (Object)Integer.toString(n));
        return n;
    }

    private boolean isAgentStateEqualsTo(int n) {
        LOG.enter("isAgentStateEqualsTo", new Object[]{Integer.toString(n)});
        int n2 = 0;
        int n3 = -1;
        DataObject dataObject = null;
        int n4 = -1;
        Object[] objectArray = new Object[2];
        objectArray[0] = "." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex);
        block7: while (!this.m_statusReportProgressMonitor.isCanceled() && this.m_errorLogProcessStatus) {
            try {
                CmdHandler cmdHandler = this.m_screenMaker.getCmdHandler();
                dataObject = cmdHandler.processSyncRequest(4, objectArray);
                if (dataObject.getError() == 0) {
                    dataObject.convertAllTypeToDefault();
                    if (dataObject.getError() == 0) {
                        int n5;
                        n4 = Integer.parseInt((String)dataObject.getParameterValue(1));
                        if (n4 > 0 && ((n5 = 1 << n4 - 1) & n) > 0) break;
                        if (n4 == 8) {
                            this.deviceAgentStateFailure(n4);
                            continue;
                        }
                        if (n4 >= 1 || n4 <= 8) {
                            if (n2 >= 20) {
                                String string = "Timeout has occurred while CSS was waiting for the device to become ready.\n\nDo you want to retry operation?";
                                int n6 = 12;
                                n3 = this.m_oInformationScreen.displayErrorPopup(string, n6);
                                switch (n3) {
                                    case 4: {
                                        n2 = 0;
                                        break;
                                    }
                                    case 8: {
                                        this.m_statusReportProgressMonitor.close();
                                        this.enableActionComponents();
                                        this.m_errorLogProcessStatus = false;
                                        if (this.m_voReportTable.getRowCount() != 0) continue block7;
                                        this.m_clearLogBtn.setEnabled(false);
                                        this.m_saveLogBtn.setEnabled(false);
                                        break;
                                    }
                                    default: {
                                        LOG.error((Object)"isAgentStateEqualsTo - Unexpected condition invalid result");
                                        break;
                                    }
                                }
                                continue;
                            }
                            ++n2;
                            Thread.sleep(1500L);
                            continue;
                        }
                        this.abortProcess(-262179);
                        continue;
                    }
                    this.abortProcess(-262177);
                    continue;
                }
                LOG.error((Object)("isAgentStateEqualsTo - error in Data object " + dataObject));
                this.abortProcess(dataObject.getError());
            }
            catch (NumberFormatException numberFormatException) {
                LOG.error((Object)"isAgentStateEqualsTo - NumberFormatException", (Throwable)numberFormatException);
                this.abortProcess(-262177);
            }
            catch (Exception exception) {
                LOG.error((Object)"isAgentStateEqualsTo - Exception", (Throwable)exception);
                this.abortProcess(-262177);
            }
        }
        if (this.m_statusReportProgressMonitor.isCanceled() && this.m_typeOfStatusReportCbBox.getSelectedItem().toString().equalsIgnoreCase("Technician")) {
            this.m_refreshBtn.setEnabled(true);
        }
        if (this.m_bSetIdleState && (this.m_statusReportProgressMonitor.isCanceled() || !this.m_errorLogProcessStatus)) {
            this.m_genericListener.notifyGuiListener();
        }
        boolean bl = this.m_errorLogProcessStatus && !this.m_statusReportProgressMonitor.isCanceled();
        LOG.exit("isAgentStateEqualsTo", (Object)Boolean.toString(bl));
        return bl;
    }

    private void deviceAgentStateFailure(int n) {
        LOG.enter("deviceAgentStateFailure", new Object[]{Integer.toString(n)});
        if (n == 8) {
            this.abortProcess(-262170);
        } else if (n == 3) {
            this.abortProcess(-262178);
        } else if (n == 4) {
            this.abortProcess(-262172);
        }
        LOG.exit("deviceAgentStateFailure");
    }

    public boolean isAgentStateIdle() {
        LOG.enter("isAgentStateIdle");
        boolean bl = false;
        this.m_bSetIdleState = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 100, "Checking if device is ready...");
            bl = this.isAgentStateEqualsTo(213);
        }
        LOG.exit("isAgentStateIdle", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean startProcessStatus() {
        LOG.enter("startProcessStatus");
        this.m_window.unlockWindow();
        this.initialize();
        this.m_statusReportProgressMonitor = new ProgressMonitor(this, "Report Processing Status", "", 0, 2500);
        this.m_statusReportProgressMonitor.setMillisToDecideToPopup(0);
        this.m_statusReportProgressMonitor.setMillisToPopup(0);
        this.m_statusReportProgressMonitor.setNote("Getting Report Information from device..");
        this.m_progress = 5;
        this.m_statusReportProgressMonitor.setProgress(this.m_progress);
        this.disableActionComponents();
        LOG.exit("startProcessStatus", (Object)Boolean.toString(true));
        this.m_errorLogProcessStatus = true;
        return true;
    }

    public Object[] getIdleCmdArguments() {
        LOG.enter("getIdleCmdArguments");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), String.valueOf(4)};
        LOG.exit("getIdleCmdArguments", objectArray);
        return objectArray;
    }

    public void idleCmdUpdate(int n) {
        LOG.enter("idleCmdUpdate", new Object[]{Integer.toString(n)});
        if (n != 0) {
            this.abortProcess(-262175);
        }
        LOG.exit("idleCmdUpdate");
    }

    public void updateScreenDeviceXferTypeTable(int n, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3) {
        LOG.enter("updateScreenDeviceXferTypeTable", new Object[]{Integer.toString(n), integerArray, integerArray2, integerArray3});
        this.m_protocolSupported = false;
        if (n == 0) {
            try {
                for (int i = 0; i < integerArray2.length; ++i) {
                    if (integerArray2[i] != 1 && integerArray2[i] != 2 || integerArray3[i] != 1) continue;
                    this.m_protocolXferIndex = integerArray[i];
                    this.m_protocolSupported = true;
                    break;
                }
                this.m_errorLogProcessStatus = this.m_protocolSupported;
                if (!this.m_protocolSupported) {
                    LOG.error((Object)"updateScreenDeviceXferTypeTable - Device does not support FTP/SFTP and Pull protocol");
                    this.abortProcess(-262168);
                }
            }
            catch (Exception exception) {
                LOG.error((Object)("updateScreenDeviceXferTypeTable - Encountered " + exception.toString() + " when trying to process the Log File Transfer Type Table"));
                this.m_errorLogProcessStatus = false;
                this.m_protocolSupported = false;
                this.abortProcess(-262167);
            }
        } else {
            LOG.error((Object)("updateScreenDeviceXferTypeTable - Received error code " + n + " while trying to get the Log File Transfer Type Table information"));
            this.m_errorLogProcessStatus = false;
            this.abortProcess(n);
        }
        if (!this.m_protocolSupported) {
            this.disableEntireScreen();
        }
        LOG.exit("updateScreenDeviceXferTypeTable");
    }

    public boolean isDeviceFtpPullProtocolSupported() {
        LOG.enter("isDeviceFtpPullProtocolSupported");
        this.updateProgress(this.m_progress += 100);
        LOG.exit("isDeviceFtpPullProtocolSupported", (Object)Boolean.toString(this.m_protocolSupported));
        return this.m_protocolSupported;
    }

    public void updateDeviceSupportedErrorLogs(int n, Integer[] integerArray, String[] stringArray, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, Integer[] integerArray5, String[] stringArray2, Integer n2) {
        LOG.enter("updateDeviceSupportedErrorLogs", new Object[]{Integer.toString(n), integerArray, stringArray, integerArray2, integerArray3, integerArray4, integerArray5, stringArray2, n2});
        if (n == 0) {
            int n3;
            int n4 = 1;
            for (n3 = 1; n3 < integerArray5.length && integerArray5[n3].equals(integerArray5[n3 - 1]); ++n3) {
                ++n4;
            }
            this.m_fileName = new String[n4];
            this.m_fileParseType = new Integer[n4];
            this.m_fileCompression = new Integer[n4];
            this.m_fileProtocolXferIndex = new Integer[n4];
            System.arraycopy(stringArray, 0, this.m_fileName, 0, n4);
            System.arraycopy(integerArray2, 0, this.m_fileParseType, 0, n4);
            System.arraycopy(integerArray4, 0, this.m_fileCompression, 0, n4);
            System.arraycopy(integerArray5, 0, this.m_fileProtocolXferIndex, 0, n4);
            this.m_downLoadFileIndex = integerArray[0];
            try {
                int n5;
                n3 = -1;
                for (n5 = 0; n5 < this.m_fileParseType.length; ++n5) {
                    if (this.m_fileParseType[n5] != 2 || this.m_fileProtocolXferIndex[n5] != this.m_protocolXferIndex) continue;
                    n3 = n5;
                    this.m_currSelectedLog = n5;
                    break;
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    this.m_typeOfStatusReportCbBox.addItem(stringArray2[n5]);
                }
                if (n3 == -1) {
                    LOG.error((Object)"updateDeviceSupportedErrorLogs - Unable to find an External log type with supported protocol");
                    this.abortProcess(-262168);
                    this.disableReportTable();
                    this.m_currSelectedLog = 1;
                    this.m_typeOfStatusReportCbBox.setSelectedIndex(0);
                } else {
                    this.m_typeOfStatusReportCbBox.setSelectedIndex(n3);
                    this.m_tableTitleLbl.setText(" ");
                }
                this.m_typeOfStatusReportCbBox.addActionListener(this.m_reportTypeHandlerAction);
            }
            catch (Exception exception) {
                LOG.error((Object)"updateDeviceSupportedErrorLogs - exception", (Throwable)exception);
                this.abortProcess(-262167);
            }
        } else {
            LOG.error((Object)("updateDeviceSupportedErrorLogs - Get Log File Download Table return error " + n));
            this.abortProcess(n);
        }
        this.updateProgress(this.m_progress += 100);
        LOG.exit("updateDeviceSupportedErrorLogs");
    }

    public Object[] getBuildCmdArguments() {
        LOG.enter("getBuildCmdArguments");
        this.updateProgress(this.m_progress += 100, "Building report. Please wait..");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), String.valueOf(1)};
        LOG.exit("getBuildCmdArguments", objectArray);
        return objectArray;
    }

    public void buildCmdUpdate(int n) {
        LOG.enter("buildCmdUpdate", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.m_bSetIdleState = true;
            this.updateProgress(this.m_progress += 100);
        } else {
            LOG.error((Object)("buildCmdUpdate - Send build command returned error " + n));
            this.abortProcess(n);
        }
        LOG.exit("buildCmdUpdate");
    }

    public Object[] getTransferCmdArguments() {
        LOG.enter("getTransferCmdArguments");
        this.updateProgress(this.m_progress += 100, "Initialize file transfer. Please Wait..");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), String.valueOf(2)};
        LOG.exit("getTransferCmdArguments", objectArray);
        return objectArray;
    }

    public void transferCmdUpdate(int n) {
        LOG.enter("transferCmdUpdate", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.updateProgress(this.m_progress += 200);
        } else {
            LOG.error((Object)("transferCmdUpdate - Send transfer command returned error " + n));
            this.abortProcess(n);
            this.m_genericListener.notifyGuiListener();
        }
        LOG.exit("transferCmdUpdate");
    }

    public boolean isAgentStateBuildComplete() {
        LOG.enter("isAgentStateBuildComplete");
        this.updateProgress(this.m_progress += 100);
        boolean bl = this.isAgentStateEqualsTo(4);
        if (bl) {
            this.updateProgress(this.m_progress += 100, "Build process completed...");
        }
        LOG.exit("isAgentStateBuildComplete", (Object)Boolean.toString(bl));
        return bl;
    }

    private void processError(int n) {
        LOG.enter("processError", new Object[]{Integer.toString(n)});
        ProtocolListener protocolListener = null;
        boolean bl = false;
        protocolListener = ConnectionService.getProtocolListener();
        if (protocolListener != null) {
            if (protocolListener.isCancelButtonPressed() != null) {
                bl = protocolListener.isCancelButtonPressed();
                if (bl) {
                    this.m_statusReportProgressMonitor.close();
                    this.enableActionComponents();
                } else if (ConnectionInfoObject.getFtpCredentials() == null) {
                    PnmDialog.error((Object)EngineUtilities.getMainApplicationWindow(), (String)"unable_to_login_to_device");
                    this.m_statusReportProgressMonitor.close();
                    this.enableActionComponents();
                } else {
                    this.abortProcess(999);
                }
                protocolListener.setCancelButtonStatus(null);
            } else {
                this.abortProcess(999);
            }
        } else {
            LOG.error((Object)"processError - Unexpected condition protocol listener is null.");
        }
        if (this.m_voReportTable.getRowCount() == 0) {
            this.m_clearLogBtn.setEnabled(false);
            this.m_saveLogBtn.setEnabled(false);
        }
        LOG.exit("processError");
    }

    public boolean isAgentStateTransfering() {
        Integer n;
        LOG.enter("isAgentStateTransfering");
        boolean bl = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 100);
            bl = this.isAgentStateEqualsTo(8);
        }
        if (bl && (n = CSSUtilities.getComponentMajorVersion((String)MetadataAcquisitionService.getMetadataVersion())) != null && n > 11) {
            try {
                this.updateProgress(this.m_progress += 200, "Downloading DTD file...");
                ErrorLogUtilities.getDtdFile();
            }
            catch (CSSException cSSException) {
                bl = false;
                this.processError(999);
                this.m_genericListener.notifyGuiListener();
                LOG.error((Object)"isAgentStateTransfering - CSS is unable to download the DTD file from the device.");
            }
        }
        LOG.exit("isAgentStateTransfering", (Object)Boolean.toString(bl));
        return bl;
    }

    public Object[] getDeviceFilePath() {
        LOG.enter("getDeviceFilePath");
        Object[] objectArray = null;
        int n = this.getScreenSelectedErrorLog();
        this.updateProgress(this.m_progress += 700, "Transferring report...");
        objectArray = new Object[]{this.isReportTypeExternal() ? this.LOCAL_ERRORLOG_FILE : this.m_userLogFileName, this.m_fileName[n]};
        LOG.exit("getDeviceFilePath", objectArray);
        return objectArray;
    }

    public void ftpGetErrorLogUpdate(int n) {
        LOG.enter("ftpGetErrorLogUpdate", new Object[]{Integer.toString(n)});
        int n2 = 0;
        if (n == 0) {
            this.updateProgress(this.m_progress + 600, "Transfer complete...");
            if (this.isReportTypeExternal()) {
                n2 = this.populateErrorLogTable(this.LOCAL_ERRORLOG_FILE);
                if (n2 != 0) {
                    if (n2 == -100) {
                        while (n2 == -100) {
                            n2 = this.populateErrorLogTable(this.LOCAL_ERRORLOG_FILE);
                        }
                        m_errorPopup.display("Some entries not translated. Update DTD file.");
                    } else {
                        this.abortProcess(-262174);
                        this.m_tableTitleLbl.setText(" ");
                    }
                } else {
                    this.m_tableTitleLbl.setText(" ");
                }
            }
            this.updateProgress(this.m_progress + 2000);
            this.enableActionComponents();
        } else {
            LOG.error((Object)("ftpGetErrorLogUpdate - FTP Get command returned error " + n));
            this.processError(n);
            this.m_genericListener.notifyGuiListener();
        }
        LOG.exit("ftpGetErrorLogUpdate");
    }

    public boolean confirmClearLogs() {
        LOG.enter("confirmClearLogs");
        boolean bl = false;
        ConfirmationPopup confirmationPopup = new ConfirmationPopup();
        confirmationPopup.display("Do You Really Wish To Clear This Log From The Device?");
        bl = confirmationPopup.getStatus();
        LOG.exit("confirmClearLogs", (Object)Boolean.toString(bl));
        return bl;
    }

    void resetProgressBar() {
        LOG.enter("resetProgressBar");
        this.m_statusReportProgressMonitor = new ProgressMonitor(this, "Report Processing Status", "", 0, 2500);
        this.m_statusReportProgressMonitor.setMillisToDecideToPopup(30);
        this.m_statusReportProgressMonitor.setMillisToPopup(0);
        this.m_statusReportProgressMonitor.setNote("Getting Report Information from device..");
        this.m_progress = 20;
        this.updateProgress(20);
        this.m_errorLogProcessStatus = true;
        this.disableActionComponents();
        LOG.exit("resetProgressBar");
    }

    public Object[] startLogProcess() {
        LOG.enter("startLogProcess");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), null};
        this.resetProgressBar();
        LOG.exit("startLogProcess", objectArray);
        return objectArray;
    }

    public Object[] startLogProcessNoProgressBar() {
        LOG.enter("startLogProcessNoProgressBar");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), null};
        LOG.exit("startLogProcessNoProgressBar", objectArray);
        return objectArray;
    }

    public Object[] getClearLogCmdArguments() {
        LOG.enter("getClearLogCmdArguments");
        Object[] objectArray = new Object[]{"." + (this.getScreenSelectedErrorLog() + this.m_downLoadFileIndex), String.valueOf(3)};
        this.updateProgress(this.m_progress += 300, "Clearing report from device..");
        LOG.exit("getClearLogCmdArguments", objectArray);
        return objectArray;
    }

    public void clearCommandUpdate(int n) {
        LOG.enter("clearCommandUpdate", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.updateProgress(this.m_progress += 500);
        } else {
            LOG.error((Object)("clearCommandUpdate - Send clear command returned error " + n));
            this.abortProcess(n);
        }
        LOG.exit("clearCommandUpdate");
    }

    public boolean isAgentStateCleared() {
        LOG.enter("isAgentStateCleared");
        boolean bl = false;
        if (this.m_errorLogProcessStatus) {
            this.updateProgress(this.m_progress += 300, "Clearing Log ...");
            bl = this.isAgentStateEqualsTo(64);
            this.updateProgress(this.m_progress += 800, "Clearing Log ...");
            this.clearTable();
        }
        this.enableActionComponents();
        LOG.exit("isAgentStateCleared", (Object)Boolean.toString(bl));
        return bl;
    }

    public void clearLogIdleCmdUpdate(int n) {
        LOG.enter("clearLogIdleCmdUpdate", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.updateProgress(this.m_progress += 2000);
        } else {
            this.abortProcess(n);
        }
        LOG.exit("clearLogIdleCmdUpdate");
    }

    public void startProcessUpdate(int n, Integer n2) {
        LOG.enter("startProcessUpdate", new Object[]{Integer.toString(n), n2});
        if (n == 0) {
            int n3 = n2;
            if (n3 == 2 || n3 == 6 || n3 == 4) {
                this.abortProcess(-262173);
            }
        } else {
            this.abortProcess(n);
        }
        LOG.exit("startProcessUpdate");
    }

    public boolean isFileNameSelected() {
        LOG.enter("isFileNameSelected");
        JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
        int n = jFileChooser.showSaveDialog((Component)this.m_window);
        if (n == 0) {
            this.m_userLogFileName = jFileChooser.getSelectedFile().getPath();
            File file = new File(this.m_userLogFileName);
            if (!CSSUtilities.isValidLogFile((File)file, (ErrorPopup)m_errorPopup)) {
                return false;
            }
        }
        LOG.exit("isFileNameSelected", (Object)Integer.toString(n));
        return n == 0;
    }

    public boolean writeLogToFile() {
        File file;
        LOG.enter("writeLogToFile");
        JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
        int n = jFileChooser.showSaveDialog((Component)this.m_window);
        if (n == 0 && CSSUtilities.isValidLogFile((File)(file = new File(jFileChooser.getSelectedFile().getPath())), (ErrorPopup)m_errorPopup)) {
            try {
                FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile());
                fileWriter.write("Report Date/Time: " + this.m_dateTimeLblValue.getText() + "\n");
                this.m_statusReportTblMdl.writeTableTofile(fileWriter);
                fileWriter.close();
            }
            catch (Exception exception) {
                LOG.error((Object)"writeLogToFile - Exception", (Throwable)exception);
                this.abortProcess(-262180);
            }
        }
        LOG.exit("writeLogToFile", (Object)Boolean.toString(false));
        return false;
    }

    public boolean setSaveBtnType() {
        LOG.enter("setSaveBtnType");
        if (this.isReportTypeInternal()) {
            this.m_saveIntLogBtn.doClick();
        } else if (this.isReportTypeExternal()) {
            this.m_saveExtLogBtn.doClick();
        }
        LOG.exit("setSaveBtnType", (Object)Boolean.toString(true));
        return true;
    }

    public boolean isReportTypeInternal() {
        LOG.enter("isReportTypeInternal");
        boolean bl = false;
        int n = this.getScreenSelectedErrorLog();
        try {
            if (this.m_fileParseType[n] == 1) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"isReportTypeInternal - NumberFormatException", (Throwable)numberFormatException);
        }
        LOG.exit("isReportTypeInternal", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isReportTypeExternal() {
        LOG.enter("isReportTypeExternal");
        boolean bl = false;
        int n = this.getScreenSelectedErrorLog();
        try {
            if (this.m_fileParseType[n] == 2) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            LOG.error((Object)"isReportTypeExternal - NumberFormatException", (Throwable)numberFormatException);
        }
        LOG.exit("isReportTypeExternal", (Object)Boolean.toString(bl));
        return bl;
    }

    public int populateErrorLogTable(String string) {
        Object object;
        LOG.enter("populateErrorLogTable", new Object[]{string});
        int n = 0;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        ErrorLogsDataHandler errorLogsDataHandler = new ErrorLogsDataHandler();
        string2 = ErrorLogUtilities.getDtdFileName();
        string3 = errorLogsDataHandler.getDtdFileNameFromErrorLog(string);
        if (!string3.equalsIgnoreCase(new File(string2).getName())) {
            if (null != string) {
                object = new File(string).getParent();
                string4 = null != object ? (String)object + File.separator + string3 : string3;
                if (ValidatePath.isValid((String)string2) && ValidatePath.isValid((String)string4)) {
                    ErrorLogUtilities.renameDtdFile((String)string2, (String)string4);
                } else {
                    LOG.error((Object)"populateErrorLogTable - file path is not validated.");
                }
            } else {
                LOG.error((Object)"populateErrorLogTable - Null pointer: g_filename");
            }
        }
        try {
            n = errorLogsDataHandler.parseErrorLogFile(string);
            if (n == 0) {
                object = errorLogsDataHandler.getParsedTableData();
                StatusReportTableModel statusReportTableModel = StatusReportTableModel.setTableNewValues((Vector)object);
                this.m_statusReportTblMdl = new FilterableTableModel((AbstractTableModel)statusReportTableModel);
                this.m_voReportTableComponent.setModel(this.m_statusReportTblMdl);
                this.m_voReportTableComponent.addEnableFilteringItemListener((ItemListener)this.m_oFilteringStateChangeHandler);
                this.m_voReportTableComponent.addFocusListener(this.m_oStatusBarListener, FILTER_TEXT_STATUSMSG);
                statusReportTableModel.setHeaderInfo(errorLogsDataHandler.getHeaderInfo());
                this.setupTableComponent(statusReportTableModel);
            } else {
                LOG.error((Object)("populateErrorLogTable - Parse error log file return error = " + n));
                if (n == -1) {
                    n = errorLogsDataHandler.recoverDtdFile();
                }
                this.enableActionComponents();
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"populateErrorLogTable - Exception", (Throwable)exception);
            this.enableActionComponents();
            n = -1;
        }
        LOG.exit("populateErrorLogTable", (Object)Integer.toString(n));
        return n;
    }

    public void notifyGuiListener() {
        LOG.enter("notifyGuiListener");
        ActionEvent actionEvent = new ActionEvent(this, 0, "");
        if (this.m_actionListener != null) {
            ((ActionListener)this.m_actionListener).actionPerformed(actionEvent);
        }
        this.enableActionComponents();
        LOG.exit("notifyGuiListener");
    }

    protected void setSaveButtonProperties(boolean bl) {
        LOG.enter("setSaveButtonProperties");
        if (bl) {
            this.m_saveLogBtn.setText(SAVE_FILTERED_BUTTON_NAME);
            this.m_saveLogBtn.setToolTipText(SAVE_FILTERED_BUTTON_TOOLTIP);
        } else {
            this.m_saveLogBtn.setText(SAVE_BUTTON_NAME);
            this.m_saveLogBtn.setToolTipText(SAVE_BUTTON_TOOLTIP);
        }
        LOG.exit("setSaveButtonProperties");
    }

    protected class FilteringChangedHandler
    implements ItemListener {
        private final CssLogger LOG = CssLogger.getCssLogger(FilteringChangedHandler.class);

        protected FilteringChangedHandler() {
        }

        protected void applyFilteringEnabled() {
            this.LOG.enter("applyFilteringEnabled");
            this.LOG.exit("applyFilteringEnabled");
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.LOG.enter("itemStateChanged", new Object[]{itemEvent});
            CommonStatusReportPanel.this.setSaveButtonProperties(1 == itemEvent.getStateChange());
            this.LOG.exit("itemStateChanged");
        }
    }

    class ReportTypeHandler
    implements ActionListener {
        ReportTypeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            LOG.enter("actionPerformed");
            if (actionEvent.getSource() == CommonStatusReportPanel.this.m_typeOfStatusReportCbBox && (n = CommonStatusReportPanel.this.getScreenSelectedErrorLog()) != CommonStatusReportPanel.this.m_currSelectedLog) {
                CommonStatusReportPanel.this.m_currSelectedLog = n;
                if (CommonStatusReportPanel.this.isReportTypeInternal()) {
                    CommonStatusReportPanel.this.clearTable();
                    CommonStatusReportPanel.this.disableReportTable();
                    CommonStatusReportPanel.this.m_tableTitleLbl.setText("Selected Report Type Is Not Viewable. Click Save Report Button To Save To File");
                } else if (CommonStatusReportPanel.this.m_fileProtocolXferIndex[n] == CommonStatusReportPanel.this.m_protocolXferIndex && CommonStatusReportPanel.this.m_fileCompression[n] == 1) {
                    CommonStatusReportPanel.this.enableReportTable();
                    CommonStatusReportPanel.this.m_refreshBtn.doClick();
                } else {
                    if (CommonStatusReportPanel.this.m_voReportTableComponent.isEnabled()) {
                        CommonStatusReportPanel.this.clearTable();
                    }
                    CommonStatusReportPanel.this.disableReportTable();
                    CommonStatusReportPanel.this.abortProcess(-262168);
                }
            }
            LOG.exit("actionPerformed");
        }
    }
}

