/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.ScreenMaker;
import css.core.screens.tools.StatusBarListener;
import css.core.service.CmdHandler;
import css.core.service.CmdHandlerRules;
import css.core.service.GuiListener;
import css.core.service.GuiListenerRules;
import css.core.service.GuiUpdater;
import css.core.service.GuiUpdaterRules;
import css.core.service.ProtocolMultiplexer;
import css.core.service.RealTimeUpdaterIfc;
import css.core.service.SessionManager;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.component.CssUIInternalFrame;
import css.device.common.screens.ScreenInterface;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceProtocolMultiplexer;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Component;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pnm.util.EngineUtilities;

public abstract class GenericScreenMaker
extends ScreenMaker
implements DeviceConstants,
DeviceErrorCodes,
CssConstants {
    private static final CssLogger LOG = CssLogger.getCssLogger(GenericScreenMaker.class);
    protected ScreenInterface m_gui;
    protected GenericScreenMaker m_handle;
    protected CssUIInternalFrame m_window;
    protected GuiListener m_guiListener = null;
    protected CmdHandler m_cmdHandler = null;
    protected String m_screenName = "Service Screen";
    protected String m_sessionType = "command";
    protected int m_screenSize_X = 430;
    protected int m_screenSize_Y = 400;

    public void initialize() {
        LOG.enter("initialize");
        if (!this.m_window.isShowing()) {
            this.m_gui.initialize();
            ScreenManager.registerScreen(this.m_gui);
            this.m_window.lockWindow();
            this.m_window.setVisible(true);
            EngineUtilities.getMainApplicationNavigator().updateWorkspace((Object)this.m_window, this.m_screenName);
            if (null != this.m_guiListener) {
                this.m_guiListener.startProcess();
            }
            if (null != this.m_oSessionManager) {
                this.m_oSessionManager.startProcess();
            }
        } else {
            EngineUtilities.getMainApplicationNavigator().updateWorkspace((Object)this.m_window, this.m_screenName);
        }
        LOG.exit("initialize");
    }

    public void buildService() {
        LOG.enter("buildService");
        this.m_window = new CssUIInternalFrame(this.m_screenName);
        this.m_window.setDefaultCloseOperation(0);
        EngineUtilities.getMainApplicationNavigator().updateWorkspace((Object)this.m_window, this.m_screenName);
        StatusBarListener statusBarListener = new StatusBarListener(this.getStatusBar());
        this.m_window.setSize(this.m_screenSize_X, this.m_screenSize_Y);
        this.m_gui.buildScreen(this.m_window, statusBarListener, this.m_handle);
        JScrollPane jScrollPane = new JScrollPane((JPanel)((Object)this.m_gui));
        this.m_window.getContentPane().add((Component)jScrollPane, "Center");
        this.m_window.getContentPane().add((Component)this.m_statusBar, "South");
        ServiceProtocolMultiplexer serviceProtocolMultiplexer = ServiceProtocolMultiplexer.getServiceProtocolMultiplexer();
        this.m_oSessionManager = this.m_gui instanceof RealTimeUpdaterIfc ? new SessionManager((JInternalFrame)this.m_window, (ProtocolMultiplexer)serviceProtocolMultiplexer, this.m_sessionType, (RealTimeUpdaterIfc)this.m_gui) : new SessionManager((JInternalFrame)this.m_window, (ProtocolMultiplexer)serviceProtocolMultiplexer, this.m_sessionType);
        if (null != this.m_cmdHandlerRulesTable && null != this.m_guiListenerRulesTable && null != this.m_guiUpdaterRulesTable) {
            CmdHandlerRules cmdHandlerRules = new CmdHandlerRules(this.m_cmdHandlerRulesTable);
            this.m_cmdHandler = new CmdHandler(cmdHandlerRules, this.m_sessionType, (ProtocolMultiplexer)serviceProtocolMultiplexer);
            GuiListenerRules guiListenerRules = new GuiListenerRules(this.m_guiListenerRulesTable);
            this.m_guiListener = new GuiListener((Object)this.m_gui, (Object)this.m_window, this.m_cmdHandler, guiListenerRules);
            GuiUpdaterRules guiUpdaterRules = new GuiUpdaterRules(this.m_guiUpdaterRulesTable);
            GuiUpdater guiUpdater = new GuiUpdater(guiUpdaterRules, (Object)this.m_gui, this.m_guiListener);
            this.m_cmdHandler.setGuiUpdater(guiUpdater);
        }
        if (null != this.m_oSessionManager) {
            this.registerAllRules(this.m_oSessionManager);
            this.m_oSessionManager.registerAllComponents();
        }
        ScreenManager.registerScreen(this.m_gui);
        this.m_window.lockWindow();
        this.m_window.setVisible(true);
        if (null != this.m_guiListener) {
            this.m_guiListener.startProcess();
        }
        if (null != this.m_oSessionManager) {
            this.m_oSessionManager.startProcess();
        }
        LOG.exit("buildService");
    }

    protected void registerAllRules(SessionManager sessionManager) {
        LOG.enter("registerAllRules", new Object[]{sessionManager});
        LOG.info((Object)"registerAllRules: empty");
        LOG.exit("registerAllRules");
    }

    public GuiListener getGuiListener() {
        LOG.enter("getGuiListener");
        LOG.exit("getGuiListener");
        return this.m_guiListener;
    }

    public CmdHandler getCmdHandler() {
        LOG.enter("getCmdHandler");
        LOG.exit("getCmdHandler");
        return this.m_cmdHandler;
    }

    public String getSessionType() {
        LOG.enter("getSessionType");
        LOG.exit("getSessionType");
        return this.m_sessionType;
    }
}

