/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.GridBagAdder;
import css.core.util.popup.ErrorPopup;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.tables.CssTranslationInfoRules;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;
import pnm.util.EngineUtilities;

public class CommonModeScreen
extends GenericScreen {
    private final String FILE = "CommonModeScreen";
    private ErrorPopup m_errorPopup = new ErrorPopup();
    public JButton m_normalModeBtn = new JButton("Change To Normal Mode");
    public JLabel m_deviceModeTFld;
    private String m_instanceId;
    private Boolean m_cancel = false;

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)1011, (String)"CommonModeScreen", (String)("Enter buildScreen() arguments: g_window = " + object + ", g_statusBar = " + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonModeScreen.this);
                CommonModeScreen.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setText("  Current Station Mode");
        jLabel.setToolTipText("Station's Current Operational Mode");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(50, 10));
        jPanel3.add(jLabel2);
        this.m_deviceModeTFld = new JLabel("N/A");
        this.m_deviceModeTFld.setBackground(this.getBackground());
        this.m_deviceModeTFld.setPreferredSize(new Dimension(90, 20));
        jPanel3.add(this.m_deviceModeTFld);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.m_normalModeBtn.setToolTipText("Set the Station in Normal Mode");
        this.m_normalModeBtn.setEnabled(false);
        jPanel4.add(this.m_normalModeBtn);
        jPanel2.add(jPanel4);
        statusBarListener.registerComponent((Component)this.m_normalModeBtn, "Click this button to set the station from configuration mode to Normal Mode");
        Audit.audit((int)1012, (String)"CommonModeScreen", (String)"Exit buildScreen() ");
    }

    @Override
    public void initialize() {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)"Enter initialize()");
        this.m_deviceModeTFld.setText("N/A");
        this.m_normalModeBtn.setEnabled(false);
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit initialize()");
    }

    public Object[] getNormalMode() {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)"Enter getNormalMode");
        boolean bl = PnmDialog.confirm((Object)this.m_window, (String)"Device Will Be Reset.\nAll Service Screens Will Be Closed");
        if (bl) {
            this.m_cancel = false;
            ScreenManager.suspend();
            Object[] objectArray = new Object[]{"2", this.m_instanceId};
            Audit.audit((int)1010, (String)"CommonModeScreen", (String)("Exit getNormalMode " + objectArray));
            return objectArray;
        }
        this.m_cancel = true;
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit getNormalMode, do nothing");
        return null;
    }

    public void updateDeviceMode(int n, Integer[] integerArray, Integer[] integerArray2) {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)("Enter updateDeviceMode(), arguments: g_error = " + n + "g_deviceMode " + integerArray + "g_instanceId " + integerArray2));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)"CommonModeScreen", (String)"Unable to get device mode ");
            if (this.m_window.isVisible()) {
                this.m_errorPopup.display("Unable to get device Mode from the device");
            }
        } else {
            this.m_instanceId = "." + integerArray2[0];
            switch (integerArray[0]) {
                case 2: {
                    this.m_deviceModeTFld.setText("Normal");
                    break;
                }
                case 4: {
                    this.m_deviceModeTFld.setText("Configuration");
                    this.m_normalModeBtn.setEnabled(true);
                    break;
                }
                case 5: {
                    this.m_deviceModeTFld.setText("Service");
                    break;
                }
                case 6: {
                    this.m_deviceModeTFld.setText("Reset");
                    break;
                }
                case 7: {
                    this.m_deviceModeTFld.setText("Normal");
                    break;
                }
                case 8: {
                    this.m_deviceModeTFld.setText("Initialization");
                    break;
                }
                default: {
                    this.m_deviceModeTFld.setText("Unknown");
                }
            }
        }
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit updateDeviceMode()");
    }

    public void updateNormalMode(int n) {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)("Enter updateNormalmode(), arguments: g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)"CommonModeScreen", (String)"Unable to set the station in Normal Mode");
            ScreenManager.update();
            if (!this.m_cancel.booleanValue()) {
                PnmDialog.error((Object)EngineUtilities.getMainApplicationWindow(), (String)"Unable To Change Station To Normal Mode");
            }
        } else {
            CmdManager cmdManager = new CmdManager(CssTranslationInfoRules.cssCommandManagerRules);
            cmdManager.handleRestart();
        }
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit updateNormalmode()");
    }
}

