/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.DateAndTimeConversion;
import css.core.util.component.CSSComboItem;
import css.core.util.component.GenericListener;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.WarningPopup;
import css.device.common.util.FileLogger;
import css.device.platform.common.screens.statuspanel.BrStatusPanelScreen;
import css.device.platform.common.screens.statuspanel.DiagnosticMessagePanel;
import java.awt.Component;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFileChooser;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import pnm.util.path.PathConstants;

public class DiagnosticMessageTab
extends DiagnosticMessagePanel {
    private static final CssLogger LOG = CssLogger.getCssLogger(DiagnosticMessageTab.class);
    private BrStatusPanelScreen m_statusPanelScreen;
    public GenericListener m_oGenericListener = new GenericListener();
    private static final long serialVersionUID = -4172284787275287178L;
    private FileLogger fileLogger = null;
    private boolean capturing = false;
    protected ErrorPopup m_errorPopup = new ErrorPopup();
    protected WarningPopup m_warningPopup = new WarningPopup();
    private static DefaultComboBoxModel typeModel = new DefaultComboBoxModel();

    protected void initialize() {
        this.capturing = false;
        this.setStartCapturing();
    }

    public boolean closeLogIfCan() {
        LOG.enter("isLogClosed");
        boolean bl = true;
        if (this.capturing) {
            ConfirmationPopup confirmationPopup = new ConfirmationPopup();
            confirmationPopup.display("Diagnostic messages log file needs to be closed.\nClose diagnostic messages log file?");
            bl = confirmationPopup.getStatus();
            if (bl) {
                this.closeLogging();
                this.capturing = false;
            }
        }
        LOG.exit("isLogClosed", (Object)bl);
        return bl;
    }

    public boolean closeLogging() {
        LOG.enter("closeLogging");
        boolean bl = true;
        if (this.capturing && null != this.fileLogger) {
            bl = this.fileLogger.stopLogging();
        }
        LOG.exit("closeLogging", (Object)bl);
        return bl;
    }

    public DiagnosticMessageTab(BrStatusPanelScreen brStatusPanelScreen) {
        this.m_statusPanelScreen = brStatusPanelScreen;
    }

    @Override
    public ComboBoxModel getTypesModel() {
        return typeModel;
    }

    @Override
    public TableModel getTableModel() {
        return this.m_table.getModel();
    }

    private void addRow(String string, String string2, String string3) {
        LOG.enter("addRow", new Object[]{string, string2, string3});
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.m_table.getModel();
        defaultTableModel.addRow(new Object[]{string + " " + string2, string3});
        LOG.exit("updateRealTimeData");
    }

    public boolean updateRealTimeData(Object object) {
        boolean bl = true;
        String string = null;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        LOG.enter("updateRealTimeData", new Object[]{object});
        try {
            this.setDecoderMessageTypeDisabledInServiceMode();
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase("DiagnosticMessage")) {
                    String string2;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    byte[] byArray2 = new byte[4];
                    StringBuffer stringBuffer = new StringBuffer();
                    int n = 0;
                    while (n < 50 && byArray[n] != 0) {
                        stringBuffer.append((char)byArray[n++]);
                    }
                    for (n = 0; n < 4; ++n) {
                        byArray2[n] = byArray[50 + n];
                    }
                    int n2 = Convert.toInteger((byte[])byArray2);
                    String string3 = DateAndTimeConversion.getDate((int)n2);
                    String string4 = DateAndTimeConversion.getTime((int)n2);
                    this.addRow(string3, string4, stringBuffer.toString());
                    if (!this.capturing || this.fileLogger.appendString(string2 = "" + string3 + " " + string4 + "::" + stringBuffer.toString() + "\n")) continue;
                    this.m_errorPopup.display(this.fileLogger.getStatusMessage());
                    continue;
                }
                bl = false;
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateRealTimeData - exception ", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData", (Object)bl);
        return bl;
    }

    public void setDecoderMessageTypeDisabledInServiceMode() {
        LOG.enter("setDecoderMessageTypeDisabledInServiceMode");
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            if (this.m_statusPanelScreen.isServiceMode()) {
                if (this.m_cmbTypes.isEnabled()) {
                    this.m_oGenericListener.notifyGuiListener();
                }
                this.m_cmbTypes.setEnabled(false);
                this.jLabel1.setEnabled(false);
            } else {
                this.m_cmbTypes.setEnabled(true);
                this.jLabel1.setEnabled(true);
            }
        }
        LOG.exit("setDecoderMessageTypeDisabledInServiceMode");
    }

    static {
        typeModel.addElement(new CSSComboItem(Integer.valueOf(0), "DISABLED"));
        typeModel.addElement(new CSSComboItem(Integer.valueOf(1), "TRC decodes"));
        typeModel.addElement(new CSSComboItem(Integer.valueOf(2), "Repeater access decodes"));
    }

    public class Capture_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            block7: {
                if (!DiagnosticMessageTab.this.capturing) {
                    try {
                        JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
                        int n = jFileChooser.showSaveDialog((Component)DiagnosticMessageTab.this.m_window);
                        if (n != 0) break block7;
                        File file = jFileChooser.getSelectedFile();
                        DiagnosticMessageTab.this.fileLogger = new FileLogger(file);
                        if (!DiagnosticMessageTab.this.fileLogger.startLogging()) {
                            DiagnosticMessageTab.this.m_errorPopup.display(DiagnosticMessageTab.this.fileLogger.getStatusMessage());
                            break block7;
                        }
                        DiagnosticMessageTab.this.capturing = true;
                        DiagnosticMessageTab.this.setStopCapturing();
                    }
                    catch (Exception exception) {
                        DiagnosticMessageTab.this.m_errorPopup.display("Cannot start capturing diagnostic messages.");
                    }
                } else if (null != DiagnosticMessageTab.this.fileLogger) {
                    if (!DiagnosticMessageTab.this.fileLogger.stopLogging()) {
                        DiagnosticMessageTab.this.m_errorPopup.display(DiagnosticMessageTab.this.fileLogger.getStatusMessage());
                    }
                    DiagnosticMessageTab.this.capturing = false;
                    DiagnosticMessageTab.this.setStartCapturing();
                }
            }
            return null;
        }
    }

    public class SetDiagnosticTypeToDisabled_Rule
    extends Rule {
        private final String sDiagnosticType = "sDiagnosticType";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            Integer n;
            LOG.enter("getMessage");
            Message message = null;
            CSSComboItem cSSComboItem = (CSSComboItem)DiagnosticMessageTab.this.m_cmbTypes.getItemAt(0);
            if (null != cSSComboItem && null != (n = cSSComboItem.getCode())) {
                message = new Message();
                message.addParameter("sDiagnosticType", Byte.class, (Object)n.byteValue());
                message.setProtocolKey(5405);
            }
            return message;
        }
    }

    public class SetDiagnosticType_Rule
    extends Rule {
        private final String sDiagnosticType = "sDiagnosticType";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            Integer n;
            LOG.enter("getMessage");
            Message message = null;
            CSSComboItem cSSComboItem = (CSSComboItem)DiagnosticMessageTab.this.m_cmbTypes.getSelectedItem();
            if (null != cSSComboItem && null != (n = cSSComboItem.getCode())) {
                message = new Message();
                message.addParameter("sDiagnosticType", Byte.class, (Object)n.byteValue());
                message.setProtocolKey(5405);
            }
            return message;
        }
    }
}

