/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.component.GenericListener;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.WarningPopup;
import css.device.common.screens.GenericScreen;
import css.device.platform.common.screens.statuspanel.BrStationStatusPanel;
import css.device.platform.common.screens.statuspanel.StationCommandPanel;
import java.awt.Cursor;

public class StationCommandTab
extends StationCommandPanel {
    private static final CssLogger LOG = CssLogger.getCssLogger(StationCommandTab.class);
    private static final long serialVersionUID = -4172284787275287178L;
    protected ErrorPopup m_errorPopup = new ErrorPopup();
    protected WarningPopup m_warningPopup = new WarningPopup();
    private GenericScreen m_screen = null;
    public GenericListener m_oGenericListener = new GenericListener();
    private GenericListener m_o1kHzTimerListener = new GenericListener();
    private GenericListener m_o3TestTonesTimerListener = new GenericListener();
    private BrStationStatusPanel m_StationStatusPanel = null;
    public boolean m_toneActive;

    protected void initialize() {
    }

    public GenericListener get1kHzTimerListener() {
        return this.m_o1kHzTimerListener;
    }

    public GenericListener get3TestTonesTimerListener() {
        return this.m_o3TestTonesTimerListener;
    }

    public StationCommandTab(GenericScreen genericScreen, BrStationStatusPanel brStationStatusPanel) {
        this.m_screen = genericScreen;
        this.m_StationStatusPanel = brStationStatusPanel;
        this.m_toneActive = false;
    }

    public boolean updateRealTimeData(Object object) {
        boolean bl = true;
        String string = null;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        LOG.enter("updateRealTimeData", new Object[]{object});
        try {
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase("SelectiveAlarm")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateSelectiveAlarm(Convert.toInteger((byte[])byArray));
                }
                if (string.equalsIgnoreCase("sCommandsGetTXPL")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTXPL(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (!string.equalsIgnoreCase("RepeaterState")) continue;
                byArray = (byte[])realTimeDataObject.getValue(string);
                if (this.m_StationStatusPanel == null) continue;
                this.m_StationStatusPanel.updateRepeaterState(Convert.toInteger((byte[])byArray));
            }
        }
        catch (NotFoundException notFoundException) {
            bl = false;
            LOG.error((Object)"updateRealTimeData - exception ", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData", (Object)bl);
        return bl;
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public void updateStationCommand(int n, int n2) {
        LOG.enter("updateStationCommand", new Object[]{n, n2});
        this.updateTXPL(n);
        this.updateSelectiveAlarm(n2);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateStationCommand");
    }

    private void updateTXPL(int n) {
        this.setTXPL(n);
    }

    private void updateSelectiveAlarm(int n) {
        this.setSelectiveAlarms(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockScreenWhenToneIsOn() {
        StationCommandTab stationCommandTab = this;
        synchronized (stationCommandTab) {
            if (this.m_toneActive) {
                this.m_screen.m_window.lockWindow();
            }
        }
    }

    public class SetRepeatMode_RS_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = StationCommandTab.this.isRepeatMode_RK();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5461);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                StationCommandTab.this.m_errorPopup.display("Unable to set Repeat Mode to SETUP.");
            } else if (null != messageIfc) {
                StationCommandTab.this.setRepeatMode(1);
            } else {
                LOG.error((Object)"update - Set Repeat Mode to SETUP - null packet received");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetRepeatMode_RK_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !StationCommandTab.this.isRepeatMode_RK();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5460);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                StationCommandTab.this.m_errorPopup.display("Unable to set Repeat Mode to KNOCKDOWN.");
            } else if (null != messageIfc) {
                StationCommandTab.this.setRepeatMode(0);
            } else {
                LOG.error((Object)"update - Set Repeat Mode to KNOCKDOWN - null packet received");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetSelectiveAlarms_ON_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !StationCommandTab.this.isSelectiveAlarms_ON();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5462);
            LOG.exit("getMessage");
            return message;
        }
    }

    public class SetSelectiveAlarms_OFF_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = StationCommandTab.this.isSelectiveAlarms_ON();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5463);
            LOG.exit("getMessage");
            return message;
        }
    }

    public class Set1KHzTones_Rule
    extends Rule {
        private final String sCommandsSet1KHzTones = "sCommandsSet1KHzTones";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (Integer.valueOf(StationCommandTab.this.get1KHzToneValueComponent().getText()) < 1 || Integer.valueOf(StationCommandTab.this.get1KHzToneValueComponent().getText()) > 65535) {
                LOG.error((Object)"invalid value for 1khz tone rule! ");
                StationCommandTab.this.m_screen.popupError("Only values from [1, 65535] are allowed!");
                return null;
            }
            if (StationCommandTab.this.is1KHzTones_ON()) {
                message.addParameter("sCommandsSet1KHzTones", Short.class, (Object)Integer.valueOf(StationCommandTab.this.get1KHzToneValueComponent().getText()).shortValue());
                message.setProtocolKey(5458);
                StationCommandTab.this.set1KHzTones(0);
                StationCommandTab.this.get1KHzToneValueComponent().setEnabled(false);
                StationCommandTab.this.get1kHzTimerListener().notifyGuiListener();
            } else {
                message.addParameter("sCommandsSet1KHzTones", Short.class, (Object)Integer.valueOf(StationCommandTab.this.get1KHzToneValueComponent().getText()).shortValue());
                message.setProtocolKey(5459);
                StationCommandTab.this.set1KHzTones(1);
                StationCommandTab.this.get1KHzToneValueComponent().setEnabled(true);
            }
            LOG.exit("getMessage");
            return message;
        }
    }

    public class Sleep_1KHz_Rule
    extends Rule {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            Message message = new Message();
            message.setProtocolKey(65535);
            String string = StationCommandTab.this.get1KHzToneValue();
            int n = new Integer(string);
            try {
                ((StationCommandTab)StationCommandTab.this).m_screen.m_window.lockWindow();
                Sleep_1KHz_Rule sleep_1KHz_Rule = this;
                synchronized (sleep_1KHz_Rule) {
                    StationCommandTab.this.m_toneActive = true;
                }
                Thread.sleep(n);
            }
            catch (Exception exception) {
                LOG.error((Object)"1KHz sleep rule - time exception");
            }
            finally {
                Sleep_1KHz_Rule sleep_1KHz_Rule = this;
                synchronized (sleep_1KHz_Rule) {
                    StationCommandTab.this.m_toneActive = false;
                }
                ((StationCommandTab)StationCommandTab.this).m_screen.m_window.unlockWindow();
            }
            return message;
        }
    }

    public class Set3TestTones_Rule
    extends Rule {
        private final String sCommandsSet3TestTones = "sCommandsSet3TestTones";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (Integer.valueOf(StationCommandTab.this.getTransmit3TestToneValue()) < 1 || Integer.valueOf(StationCommandTab.this.getTransmit3TestToneValue()) > 65535) {
                LOG.error((Object)"invalid value for 3 test tone rule! ");
                StationCommandTab.this.m_screen.popupError("Only values from [1, 65535] are allowed!");
                return null;
            }
            if (StationCommandTab.this.is3TestTones_ON()) {
                message.addParameter("sCommandsSet3TestTones", Short.class, (Object)Integer.valueOf(StationCommandTab.this.getTransmit3TestToneValue()).shortValue());
                message.setProtocolKey(5457);
                StationCommandTab.this.set3TestTones(0);
                StationCommandTab.this.getTransmit3TestToneValueComponent().setEnabled(false);
                StationCommandTab.this.get3TestTonesTimerListener().notifyGuiListener();
            } else {
                message.addParameter("sCommandsSet3TestTones", Short.class, (Object)Integer.valueOf(StationCommandTab.this.getTransmit3TestToneValue()).shortValue());
                message.setProtocolKey(5456);
                StationCommandTab.this.set3TestTones(1);
                StationCommandTab.this.getTransmit3TestToneValueComponent().setEnabled(true);
            }
            LOG.exit("getMessage");
            return message;
        }
    }

    public class Sleep_3TestTones_Rule
    extends Rule {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            Message message = new Message();
            message.setProtocolKey(65535);
            String string = StationCommandTab.this.getTransmit3TestToneValue();
            if (Integer.valueOf(string) < 1 || Integer.valueOf(string) > 65535) {
                LOG.error((Object)"invalid value for 3 test tone rule! ");
                StationCommandTab.this.m_screen.popupError("Only values from [1, 65535] are allowed!");
                return null;
            }
            int n = new Integer(string) * 3;
            try {
                ((StationCommandTab)StationCommandTab.this).m_screen.m_window.lockWindow();
                Sleep_3TestTones_Rule sleep_3TestTones_Rule = this;
                synchronized (sleep_3TestTones_Rule) {
                    StationCommandTab.this.m_toneActive = true;
                }
                Thread.sleep(n);
            }
            catch (Exception exception) {
                LOG.error((Object)"3 Test Tones rule - time exception");
            }
            finally {
                Sleep_3TestTones_Rule sleep_3TestTones_Rule = this;
                synchronized (sleep_3TestTones_Rule) {
                    StationCommandTab.this.m_toneActive = false;
                }
                ((StationCommandTab)StationCommandTab.this).m_screen.m_window.unlockWindow();
            }
            return message;
        }
    }

    public class SetTXPL_OFF_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = StationCommandTab.this.isTXPL_ON();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5455);
            LOG.exit("getMessage");
            return message;
        }
    }

    public class SetTXPL_ON_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !StationCommandTab.this.isTXPL_ON();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5454);
            LOG.exit("getMessage");
            return message;
        }
    }
}

