/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.testandmeasurement;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.GenericListener;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.common.screens.testandmeasurement.BrTestMeasurementScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pnm.ui.UIInternalFrame;

public class BrAstroTestPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes,
DeviceConstants {
    private static final long serialVersionUID = 1L;
    public JLabel m_transmitFreqValueLbl;
    public JComboBox m_selectedTxPatternCbBox;
    private static String[] m_sInitialTxPatternCbBoxList;
    public JButton m_startPatternTransmissionBtn;
    private String c_startPatternTx = "Start Pattern Transmission";
    private String c_stopPatternTx = "Stop Pattern Transmission";
    private int m_currentMode = 0;
    private static final int V52 = 1;
    private static final int SYMBOL_RATE = 2;
    private static final int TEST_TONE = 3;
    private static final int C4FM = 4;
    private static final int SIMULCAST_TEST = 5;
    private static final int LOW_DEVIATION = 6;
    private static final int F2_TEST_TONE_1031_HZ = 11;
    private static final int P2_TEST_TONE_1031_HZ = 12;
    private static final int TONE_AT_60_DEVIATION_WITHOUT_PL_DPL = 13;
    private static final int TONE_AT_60_DEVIATION_WITH_PL_DPL = 14;
    private static final String V52_TEXT = "V.52 (FDMA)";
    private static final String SYMBOL_RATE_TEXT = "Symbol Rate (FDMA)";
    private static final String TEST_TONE_TEXT = "Standard Test Tone (FDMA)";
    private static final String C4FM_TEXT = "C4FM Modulation Fidelity (FDMA)";
    private static final String SIMULCAST_TEST_TEXT = "Simulcast Test Pattern (FDMA)";
    private static final String LOW_DEVIATION_TEXT = "Low Deviation (FDMA)";
    private static final String TONE_AT_60_DEVIATION_WITHOUT_PL_DPL_TEXT = "1 kHz Tone at 60% deviation without PL/DPL";
    private static final String TONE_AT_60_DEVIATION_WITH_PL_DPL_TEXT = "1 kHz Tone at 60% deviation with PL/DPL";
    private static final String F2_TEST_TONE_1031_HZ_TEXT = "1031 Hz test tone (TDMA logical channel 0)";
    private static final String P2_TEST_TONE_1031_HZ_TEXT = "1031 Hz test tone (TDMA logical channel 0 and 1)";
    private BrTestMeasurementScreen m_testMeasurement;
    private UIInternalFrame m_window;
    public GenericListener m_oGenericListener = new GenericListener();
    String appHWCombination = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
    String[] m_sFdmaTypePatterns = new String[]{"V.52 (FDMA)", "Symbol Rate (FDMA)", "Standard Test Tone (FDMA)", "C4FM Modulation Fidelity (FDMA)", "Simulcast Test Pattern (FDMA)", "Low Deviation (FDMA)"};
    String[] c_msbrPatternSelection = new String[]{"V.52 (FDMA)", "Symbol Rate (FDMA)", "Standard Test Tone (FDMA)", "C4FM Modulation Fidelity (FDMA)", "Simulcast Test Pattern (FDMA)", "Low Deviation (FDMA)"};
    String[] c_siteRptrPatternSelection = new String[]{"V.52 (FDMA)", "Symbol Rate (FDMA)", "Standard Test Tone (FDMA)", "C4FM Modulation Fidelity (FDMA)", "Low Deviation (FDMA)"};
    String[] c_sConvRptrPatternSelection = new String[]{"V.52 (FDMA)", "Symbol Rate (FDMA)", "Standard Test Tone (FDMA)", "C4FM Modulation Fidelity (FDMA)", "Low Deviation (FDMA)", "1 kHz Tone at 60% deviation without PL/DPL", "1 kHz Tone at 60% deviation with PL/DPL"};
    private static final int F2_TDMA = 1;
    private static final int P2_TDMA = 2;
    private static final int NORMAL_MODE = 1;
    private static final int SERVICE_MODE = 2;
    private final String TX_PROBLEM_ON_BER = "Transmitter problem ocurred on the device. Currently running BER Measurement Test will be stopped.";
    private static final CssLogger LOG;

    public BrAstroTestPanel(BrTestMeasurementScreen brTestMeasurementScreen) {
        this.m_testMeasurement = brTestMeasurementScreen;
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public int buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.m_window = uIInternalFrame;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Transmit Frequency (MHz)");
        GridBagAdder.add((Container)jPanel, (Component)jLabel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        this.m_transmitFreqValueLbl = new JLabel("N/A");
        GridBagAdder.add((Container)jPanel, (Component)this.m_transmitFreqValueLbl, (int)1, (int)0, (double)50.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)50, (int)1, (int)10, (int)0);
        JLabel jLabel2 = new JLabel("Select Pattern to Transmit");
        GridBagAdder.add((Container)jPanel, (Component)jLabel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        if (this.appHWCombination.indexOf("STR 3000 Simulcast Radio") >= 0) {
            this.m_selectedTxPatternCbBox = new JComboBox<String>(this.c_msbrPatternSelection);
            m_sInitialTxPatternCbBoxList = this.c_msbrPatternSelection;
            this.m_selectedTxPatternCbBox.setEnabled(false);
        } else if (this.appHWCombination.indexOf("ISR") >= 0) {
            this.m_selectedTxPatternCbBox = new JComboBox<String>(this.c_siteRptrPatternSelection);
            m_sInitialTxPatternCbBoxList = this.c_siteRptrPatternSelection;
            this.m_selectedTxPatternCbBox.setEnabled(false);
        } else if (this.appHWCombination.indexOf("CONVBR") >= 0) {
            this.m_selectedTxPatternCbBox = new JComboBox<String>(this.c_sConvRptrPatternSelection);
        }
        GridBagAdder.add((Container)jPanel, (Component)this.m_selectedTxPatternCbBox, (int)1, (int)1, (double)70.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)50, (int)1, (int)10, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)3, (int)1, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.m_startPatternTransmissionBtn = new JButton(this.c_startPatternTx);
        GridBagAdder.add((Container)jPanel2, (Component)this.m_startPatternTransmissionBtn, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)20, (int)0, (int)20, (int)0, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)10, (int)3, (int)1, (int)3, (int)0);
        jLabel.setToolTipText("Transmit frequency value.");
        statusBarListener.registerComponent((Component)this.m_selectedTxPatternCbBox, "Choose one of the patterns from the given choices.");
        jLabel2.setToolTipText("Select a pattern to be transmitted.");
        statusBarListener.registerComponent((Component)this.m_startPatternTransmissionBtn, "Click the button to initiate/terminate the pattern transmission.");
        this.m_startPatternTransmissionBtn.setToolTipText("Initiates/terminates the pattern transmission.");
        LOG.exit("buildScreen");
        return 1;
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_selectedTxPatternCbBox.setSelectedIndex(0);
        LOG.exit("initialize");
    }

    void updateGuiToServiceMode() {
        LOG.enter("updateGuiToServiceMode");
        if (this.m_startPatternTransmissionBtn.getText().equals(this.c_startPatternTx)) {
            this.m_selectedTxPatternCbBox.setEnabled(true);
        } else {
            this.m_selectedTxPatternCbBox.setEnabled(false);
        }
        this.m_startPatternTransmissionBtn.setEnabled(true);
        this.m_currentMode = 2;
        LOG.exit("updateGuiToServiceMode");
    }

    void updateGuiToNormalMode() {
        LOG.enter("updateGuiToNormalMode");
        this.m_currentMode = 1;
        this.m_selectedTxPatternCbBox.setEnabled(false);
        this.m_startPatternTransmissionBtn.setEnabled(false);
        LOG.exit("updateGuiToNormalMode");
    }

    public void updateTxFreq(int n, Integer[] integerArray) {
        LOG.enter("updateTxFreq", new Object[]{n, integerArray});
        this.m_transmitFreqValueLbl.setText("N/A");
        if (n == 0) {
            try {
                int n2 = integerArray[0];
                double d = (double)n2 / 1000000.0;
                this.m_transmitFreqValueLbl.setText(String.valueOf(d));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn((Object)"Floating point conversion Exception in method updateTxFreq", (Throwable)numberFormatException);
            }
        } else {
            LOG.warn((Object)("Got Error g_error = " + n));
            this.m_transmitFreqValueLbl.setText("Error!");
        }
        LOG.exit("updateTxFreq");
    }

    public void updatePatternSelection(int n, int n2) {
        LOG.enter("updatePatternSelection", new Object[]{n, n2});
        this.m_window.unlockWindow();
        if (n == 0) {
            if (n2 == 0) {
                LOG.warn((Object)"No Pattern Currently Running");
                this.patternStopUpdate();
            } else if (n2 > 0) {
                switch (n2) {
                    case 1: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(V52_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 2: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(SYMBOL_RATE_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 3: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(TEST_TONE_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 4: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(C4FM_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 5: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(SIMULCAST_TEST_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 6: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(LOW_DEVIATION_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 11: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(F2_TEST_TONE_1031_HZ_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 12: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(P2_TEST_TONE_1031_HZ_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 13: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(TONE_AT_60_DEVIATION_WITHOUT_PL_DPL_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 14: {
                        this.m_selectedTxPatternCbBox.setSelectedItem(TONE_AT_60_DEVIATION_WITH_PL_DPL_TEXT);
                        this.patternStartedUpdate();
                        break;
                    }
                    default: {
                        LOG.warn((Object)"Pattern test not supported");
                        this.m_testMeasurement.popupError(-327845);
                        break;
                    }
                }
            } else {
                LOG.warn((Object)"Pattern test not supported");
                this.m_testMeasurement.popupError(-327845);
            }
        } else if (n == -393271) {
            this.m_testMeasurement.popupError(-327846);
        } else {
            this.m_testMeasurement.popupError(-327847);
        }
        LOG.exit("updatePatternSelection");
    }

    public boolean isPatternsRunning() {
        boolean bl = true;
        LOG.enter("isPatternsRunning");
        bl = this.m_startPatternTransmissionBtn.getText().equals(this.c_stopPatternTx);
        LOG.exit("isPatternsRunning", (Object)bl);
        return bl;
    }

    public Object[] getTransmitPatternSelection() {
        Object[] objectArray = new Object[1];
        LOG.enter("getTransmitPatternSelection");
        this.m_window.lockWindow();
        int n = 1;
        Object object = this.m_selectedTxPatternCbBox.getSelectedItem();
        String string = object.toString();
        if (string.equalsIgnoreCase(V52_TEXT)) {
            n = 1;
        } else if (string.equalsIgnoreCase(SYMBOL_RATE_TEXT)) {
            n = 2;
        } else if (string.equalsIgnoreCase(TEST_TONE_TEXT)) {
            n = 3;
        } else if (string.equalsIgnoreCase(C4FM_TEXT)) {
            n = 4;
        } else if (string.equalsIgnoreCase(SIMULCAST_TEST_TEXT)) {
            n = 5;
        } else if (string.equalsIgnoreCase(LOW_DEVIATION_TEXT)) {
            n = 6;
        } else if (string.equalsIgnoreCase(F2_TEST_TONE_1031_HZ_TEXT)) {
            n = 11;
        } else if (string.equalsIgnoreCase(P2_TEST_TONE_1031_HZ_TEXT)) {
            n = 12;
        } else if (string.equalsIgnoreCase(TONE_AT_60_DEVIATION_WITHOUT_PL_DPL_TEXT)) {
            n = 13;
        } else if (string.equalsIgnoreCase(TONE_AT_60_DEVIATION_WITH_PL_DPL_TEXT)) {
            n = 14;
        }
        objectArray[0] = new Integer(n);
        LOG.exit("getTransmitPatternSelection", objectArray);
        return objectArray;
    }

    public void stopRunningPattern(int n) {
        LOG.enter("stopRunningPattern", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.patternStopUpdate();
        } else {
            this.m_testMeasurement.popupError(-327849);
        }
        LOG.exit("stopRunningPattern");
    }

    public void patternStartedUpdate() {
        LOG.enter("patternStartedUpdate");
        this.m_selectedTxPatternCbBox.setEnabled(false);
        this.m_startPatternTransmissionBtn.setText(this.c_stopPatternTx);
        LOG.exit("patternStartedUpdate");
    }

    public void patternStopUpdate() {
        LOG.enter("patternStopUpdate");
        this.m_startPatternTransmissionBtn.setText(this.c_startPatternTx);
        if (this.m_currentMode == 2 && this.m_startPatternTransmissionBtn.getText().equals(this.c_startPatternTx)) {
            this.m_selectedTxPatternCbBox.setEnabled(true);
        } else {
            this.m_selectedTxPatternCbBox.setEnabled(false);
        }
        LOG.exit("patternStopUpdate");
    }

    public void updateTestPattern(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateTestPattern", new Object[]{byArray});
        if (this.m_testMeasurement.m_astroBerAndRssiReportPanel.isBer1031andP2() && this.m_testMeasurement.m_astroBerAndRssiReportPanel.isBerTestRunning()) {
            this.m_testMeasurement.popupError("Transmitter problem ocurred on the device. Currently running BER Measurement Test will be stopped.");
        } else {
            switch (n) {
                case 1: {
                    this.m_testMeasurement.popupError(-327850);
                    break;
                }
                case 2: {
                    this.m_testMeasurement.popupError(-327851);
                    break;
                }
                case 3: {
                    this.m_testMeasurement.popupError(-327852);
                    break;
                }
                case 4: {
                    this.m_testMeasurement.popupError(-327853);
                }
            }
        }
        this.m_startPatternTransmissionBtn.setText(this.c_startPatternTx);
        this.m_selectedTxPatternCbBox.setEnabled(true);
        LOG.exit("updateTestPattern");
    }

    public boolean isFdmaTypeTransmitted() {
        LOG.enter("isFdmaTypeTransmitted");
        boolean bl = false;
        Object object = this.m_selectedTxPatternCbBox.getSelectedItem();
        String string = object.toString();
        for (int i = 0; i < this.m_sFdmaTypePatterns.length; ++i) {
            if (this.m_sFdmaTypePatterns[i].indexOf(string) == -1) continue;
            bl = true;
            break;
        }
        LOG.exit("isFdmaTypeTransmitted", (Object)bl);
        return bl;
    }

    public boolean is1031HzTypeTransmitted() {
        LOG.enter("isFdmaTypeTransmitted");
        boolean bl = false;
        Object object = this.m_selectedTxPatternCbBox.getSelectedItem();
        String string = object.toString();
        if (P2_TEST_TONE_1031_HZ_TEXT == string) {
            bl = true;
        }
        LOG.exit("isFdmaTypeTransmitted", (Object)bl);
        return bl;
    }

    public void updatePatternList(int n, Integer[] integerArray) {
        LOG.enter("updatePatternList", new Object[]{n, integerArray});
        if (n == 0) {
            int n2 = 1;
            try {
                n2 = integerArray[0];
            }
            catch (Exception exception) {
                LOG.error((Object)"updatePatternList - TDMA mode value not in range", (Throwable)exception);
            }
            this.m_selectedTxPatternCbBox.setModel(new DefaultComboBoxModel<String>(m_sInitialTxPatternCbBoxList));
            if (1 == n2) {
                this.m_selectedTxPatternCbBox.addItem(F2_TEST_TONE_1031_HZ_TEXT);
            } else if (2 == n2) {
                this.m_selectedTxPatternCbBox.addItem(P2_TEST_TONE_1031_HZ_TEXT);
            } else {
                LOG.warn((Object)"Tdma Mode value not in valid range!");
            }
            if (2 == this.m_currentMode) {
                this.m_selectedTxPatternCbBox.setEnabled(true);
            } else {
                this.m_selectedTxPatternCbBox.setEnabled(false);
            }
        } else {
            LOG.warn((Object)"Unable to read TDMA Mode");
            this.m_testMeasurement.popupError(-327863);
        }
        LOG.exit("updatePatternList");
    }

    static {
        LOG = CssLogger.getCssLogger(BrAstroTestPanel.class);
    }

    public class GetTxFrequency_Rule
    extends Rule {
        private final String sTxFrequency = "sTxFrequency";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sTxFrequency", Byte[].class);
            message.setProtocolKey(2211);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return !BrAstroTestPanel.this.m_testMeasurement.isMsbrIsr();
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            byte[] byArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Current Transmitter Frequency");
            } else if (null != messageIfc && null != (byArray = (byte[])messageIfc.getParameterValue("sTxFrequency"))) {
                Integer n2 = Convert.toInteger((byte[])byArray);
                Double d = (double)n2.intValue() / 1000000.0;
                String string = Double.toString(d);
                BrAstroTestPanel.this.m_transmitFreqValueLbl.setText(string);
            }
            LOG.exit("update");
            return true;
        }
    }
}

