/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.testandmeasurement;

import css.core.screens.tools.StatusBarListener;
import css.core.service.DataObject;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.RuleIfc;
import css.core.service.SessionIfc;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.CssJTabbedPane;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.InfoPopup;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceProtocolMultiplexer;
import css.device.common.util.TestClosable;
import css.device.common.util.TestClosingHandler;
import css.device.platform.common.screens.testandmeasurement.BrAstroBerAndRssiReportPanel;
import css.device.platform.common.screens.testandmeasurement.BrAstroTestPanel;
import css.device.platform.common.screens.testandmeasurement.BrFanHoldoverPanel;
import css.device.platform.common.tables.BrCommonTranslationInfoRules;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.UIInternalFrame;

public class BrTestMeasurementScreen
extends GenericScreen
implements BrCommonTranslationInfoRules,
TestClosable {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrTestMeasurementScreen.class);
    private static final long serialVersionUID = 1L;
    private final int ZERO_INDEX = 0;
    private final int ONE_INDEX = 1;
    private static final int RSSI_OP_CODE = 6;
    public static final int BER_OP_CODE = 8;
    public static final int GET_FAN_HOLDOVER_OP_CODE = 19;
    private final int P2_TEST_TONE_1031_HZ = 12;
    private int c_ReceiveOperations = 1;
    private int c_TdmaMode = 1;
    String m_serviceModeMessage = "Note: When service and measurements are completed, return the station to Normal Mode.";
    String m_normalModeMessage = "Note: The station must be set to Service Mode to transmit Tx BER test patterns or perform Rx BER tests.";
    String m_warningMessage = "WARNING! Receiver fault occured on the device. It may impact the running BER test results.";
    String m_astroTestTabName = "ASTRO Test Patterns";
    String m_astroBerRssiTabName = "ASTRO BER & RSSI Report";
    String m_fanHoldoverTabName = "Fan Holdover";
    String m_serviceModeBtnLblStr = "Change to Service Mode";
    String m_normalModeBtnLblStr = "Change to Normal Mode";
    public BrAstroTestPanel m_astroTestPanel;
    public BrAstroBerAndRssiReportPanel m_astroBerAndRssiReportPanel;
    public BrFanHoldoverPanel m_fanHoldoverPanel;
    public CssJTabbedPane m_testMeasurementTab;
    public JButton m_modeBtn;
    private JLabel m_modeMessageLbl;
    private JLabel m_labWarningMessage;
    private static final InfoPopup infoPopup = new InfoPopup();
    private static final ErrorPopup errorPopup = new ErrorPopup();
    private static final ConfirmationPopup cPop = new ConfirmationPopup();
    boolean m_normalMode = true;
    boolean m_modeChange = false;
    private boolean m_bIsPatternAllowed = false;
    private static boolean m_bIsBerWarningPopupAllowed = false;
    boolean m_isSimulcastApp = true;
    boolean m_isRxOnly = true;
    private TestClosingHandler m_oTestClosingHandler = new TestClosingHandler("Test Pattern is Running. Do You wish To Continue?");
    private static final String FDMA_CANNOT_START_MSG = "Cannot start FDMA type pattern measurement while TDMA type pattern is transmitted.";
    private static final String TDMA_CANNOT_START_MSG = "Cannot start TDMA type pattern measurement while FDMA type pattern is transmitted.";
    String appHWCombination = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");

    public BrTestMeasurementScreen() {
        LOG.enter("BrTestMeasurementScreen");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("STR 3000 Simulcast Radio") < 0) {
            this.m_isSimulcastApp = false;
        }
        if (!CSSUtilities.isApplicationRxOnly()) {
            this.m_isRxOnly = false;
        }
        LOG.exit("BrTestMeasurementScreen");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.MENU_ITEM_NAME = "Test And Measurement Screen";
        this.setLayout(new GridBagLayout());
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_testMeasurementTab = new CssJTabbedPane();
        this.m_astroTestPanel = new BrAstroTestPanel(this);
        this.m_astroBerAndRssiReportPanel = new BrAstroBerAndRssiReportPanel(this);
        this.m_fanHoldoverPanel = new BrFanHoldoverPanel(this);
        this.m_testMeasurementTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (BrTestMeasurementScreen.this.m_testMeasurementTab.getSelectedComponent() instanceof BrAstroTestPanel) {
                    LOG.trace((Object)"buildScreen - CSQ tab selected");
                    BrTestMeasurementScreen.this.startBrAstroTestInitRules();
                } else if (BrTestMeasurementScreen.this.m_testMeasurementTab.getSelectedComponent() instanceof BrAstroBerAndRssiReportPanel) {
                    LOG.trace((Object)"buildScreen - TxWireline tab selected");
                    BrTestMeasurementScreen.this.startBrAstroBerAndRssiReportInitRules();
                }
                LOG.exit("stateChanged");
            }
        });
        this.m_astroTestPanel.buildScreen(this.m_window, statusBarListener);
        this.m_astroBerAndRssiReportPanel.buildScreen(this.m_window, statusBarListener);
        this.m_fanHoldoverPanel.buildScreen(this.m_window, statusBarListener);
        this.addSelectiveTabs();
        GridBagAdder.add((Container)this, (Component)this.m_testMeasurementTab, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)13, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_labWarningMessage = new JLabel("");
        GridBagAdder.add((Container)jPanel, (Component)this.m_labWarningMessage, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)3, (int)0, (int)0, (int)0, (int)0);
        this.m_modeMessageLbl = new JLabel(this.m_normalModeMessage);
        GridBagAdder.add((Container)jPanel, (Component)this.m_modeMessageLbl, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)3, (int)0, (int)0, (int)0, (int)0);
        this.m_modeBtn = new JButton(this.m_normalModeBtnLblStr);
        GridBagAdder.add((Container)jPanel, (Component)this.m_modeBtn, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)2, (int)3, (int)150, (int)0, (int)150, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)3, (int)5, (int)3, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_modeBtn, "Click this button to change the station's mode.");
        this.m_modeBtn.setToolTipText("Switches the Station between Normal and Service Modes.");
        ScreenManager.registerPrecloseOperation(this.m_oTestClosingHandler);
        this.m_testMeasurementTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (BrTestMeasurementScreen.this.m_testMeasurementTab.getSelectedComponent() instanceof BrFanHoldoverPanel) {
                    BrTestMeasurementScreen.this.startFanHoldoverInitRules();
                }
                LOG.exit("stateChanged");
            }
        });
        LOG.exit("buildScreen");
    }

    public boolean startFanHoldoverInitRules() {
        LOG.enter("startFanHoldoverInitRules");
        boolean bl = true;
        this.m_fanHoldoverPanel.m_oGenericListener.notifyGuiListener();
        LOG.exit("startFanHoldoverInitRules", (Object)bl);
        return bl;
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        m_bIsBerWarningPopupAllowed = false;
        this.initializeSelectiveTabs();
        this.m_testMeasurementTab.setSelectedIndex(0);
        this.m_oTestClosingHandler.reset();
        ScreenManager.registerPrecloseOperation(this.m_oTestClosingHandler);
        LOG.exit("initialize");
    }

    public void addSelectiveTabs() {
        LOG.enter("addSelectiveTabs");
        this.m_isSimulcastApp = true;
        if (this.m_isSimulcastApp) {
            if (this.m_isRxOnly) {
                this.m_testMeasurementTab.addTab(this.m_astroBerRssiTabName, (Component)this.m_astroBerAndRssiReportPanel);
            } else {
                this.m_testMeasurementTab.addTab(this.m_astroTestTabName, (Component)this.m_astroTestPanel);
                this.m_testMeasurementTab.addTab(this.m_astroBerRssiTabName, (Component)this.m_astroBerAndRssiReportPanel);
                this.m_testMeasurementTab.addTab(this.m_fanHoldoverTabName, (Component)this.m_fanHoldoverPanel);
            }
        } else {
            this.m_testMeasurementTab.addTab(this.m_astroTestTabName, (Component)this.m_astroTestPanel);
            this.m_testMeasurementTab.addTab(this.m_astroBerRssiTabName, (Component)this.m_astroBerAndRssiReportPanel);
            this.m_testMeasurementTab.addTab(this.m_fanHoldoverTabName, (Component)this.m_fanHoldoverPanel);
        }
        LOG.exit("addSelectiveTabs");
    }

    public void initializeSelectiveTabs() {
        LOG.enter("initializeSelectiveTabs");
        if (this.m_isSimulcastApp) {
            if (this.m_isRxOnly) {
                this.m_astroTestPanel.initialize();
            } else {
                this.m_astroTestPanel.initialize();
                this.m_astroBerAndRssiReportPanel.initialize();
                this.m_fanHoldoverPanel.initialize();
            }
        } else {
            this.m_astroTestPanel.initialize();
            this.m_astroBerAndRssiReportPanel.initialize();
            this.m_fanHoldoverPanel.initialize();
        }
        LOG.exit("initializeSelectiveTabs");
    }

    public void realTimeUpdate(Object object) {
        LOG.enter("realTimeUpdate", new Object[]{object});
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        if (realTimeDataObject != null) {
            if (realTimeDataObject.getError() != 0) {
                int n = realTimeDataObject.getError();
                LOG.error((Object)("realTimeUpdate - error = " + n));
                switch (n) {
                    case -262160: {
                        if (!this.m_modeChange) {
                            this.popupError(-262160);
                            this.close();
                        }
                        this.m_modeChange = false;
                    }
                }
            } else if (realTimeDataObject instanceof FspRealTimeDataObject) {
                if (6 == ((FspRealTimeDataObject)realTimeDataObject).getOpCode() || 8 == ((FspRealTimeDataObject)realTimeDataObject).getOpCode()) {
                    this.m_astroBerAndRssiReportPanel.updateBerRssiParams((FspRealTimeDataObject)realTimeDataObject);
                } else if (19 == ((FspRealTimeDataObject)realTimeDataObject).getOpCode()) {
                    this.m_fanHoldoverPanel.updateFanHoldover((FspRealTimeDataObject)realTimeDataObject);
                } else {
                    for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                        try {
                            String string = realTimeDataObject.getName(i);
                            if (null != string) {
                                if (string.equalsIgnoreCase("ErrorMessage")) {
                                    byArray = (byte[])realTimeDataObject.getValue(string);
                                    this.m_astroTestPanel.updateTestPattern(byArray);
                                    continue;
                                }
                                if (string.equalsIgnoreCase("ReceiverTestRealTimeResponse")) {
                                    byArray = (byte[])realTimeDataObject.getValue(string);
                                    this.m_astroBerAndRssiReportPanel.receiverTestRealTimeResponse(byArray);
                                    continue;
                                }
                                if (!string.equalsIgnoreCase("ReceiverTestErrorRealTimeMessage")) continue;
                                byArray = (byte[])realTimeDataObject.getValue(string);
                                this.m_astroBerAndRssiReportPanel.receiverTestErrorRealTimeResponse(byArray);
                                continue;
                            }
                            LOG.trace((Object)"realTimeUpdate - Did not find name");
                            continue;
                        }
                        catch (NotFoundException notFoundException) {
                            LOG.error((Object)"realTimeUpdate - exception was thrown", (Throwable)notFoundException);
                        }
                    }
                }
            } else {
                LOG.error((Object)"realTimeUpdate - should be a FspRealTimeDataObject");
            }
        } else {
            LOG.error((Object)"realTimeUpdate - The Real Time Data Object Was null");
        }
        LOG.exit("realTimeUpdate");
    }

    @Override
    public void closeScreen(int n) {
        LOG.enter("closeScreen", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.error((Object)"closeScreen - Failed to close session");
        }
        LOG.exit("closeScreen");
    }

    public Object[] startSession() {
        LOG.enter("startSession");
        Object[] objectArray = new Object[]{new Byte(0), new Byte(0), BrCommonMeasurementRules};
        LOG.exit("startSession", objectArray);
        return objectArray;
    }

    public void startSessionUpdate(int n) {
        LOG.enter("startSessionUpdate", new Object[]{Integer.toString(n)});
        if (n != 0) {
            this.popupError("unable_to_start_session");
            this.close();
        }
        LOG.exit("startSessionUpdate");
    }

    public void updateMode(int n, int n2) {
        LOG.enter("updateMode", new Object[]{Integer.toString(n), Integer.toString(n2)});
        if (n == 0) {
            if (n2 == 5) {
                this.updateGuiToServiceMode(n);
                this.startBrAstroTestInitRules();
                this.startBrAstroBerAndRssiReportInitRules();
            } else if (n2 == 2) {
                this.updateGuiToNormalMode(n);
                this.startBrAstroTestInitRules();
                this.startBrAstroBerAndRssiReportInitRules();
            } else {
                LOG.error((Object)"updateMode - Device is in unknown mode");
                this.popupError("device_is_in_unknown_mode");
                this.closeScreen(true);
            }
        } else {
            LOG.error((Object)"updateMode - Unable to get mode");
            this.popupError("unable_to_get_mode");
            this.closeScreen(true);
        }
        LOG.exit("updateMode");
    }

    public boolean userRequest() {
        LOG.enter("userRequest");
        boolean bl = false;
        cPop.display(-327683);
        if (cPop.getStatus()) {
            this.m_modeChange = true;
            bl = true;
        }
        LOG.exit("userRequest", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isScreenInNormalMode() {
        LOG.enter("isScreenInNormalMode");
        boolean bl = false;
        if (this.m_modeChange) {
            bl = this.m_modeBtn.getText().equalsIgnoreCase(this.m_serviceModeBtnLblStr);
        }
        LOG.exit("isScreenInNormalMode", (Object)bl);
        return bl;
    }

    public boolean isScreenInServiceMode() {
        LOG.enter("isScreenInServiceMode");
        boolean bl = false;
        if (this.m_modeChange) {
            bl = this.m_modeBtn.getText().equalsIgnoreCase(this.m_normalModeBtnLblStr);
        }
        LOG.exit("isScreenInServiceMode", (Object)bl);
        return bl;
    }

    public void updateGuiToServiceMode(int n) {
        LOG.enter("updateGuiToServiceMode", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_normalMode = false;
            this.m_modeBtn.setText(this.m_normalModeBtnLblStr);
            this.m_modeMessageLbl.setText(this.m_serviceModeMessage);
            this.m_astroTestPanel.updateGuiToServiceMode();
            this.m_astroBerAndRssiReportPanel.updateGuiToServiceMode();
            if (this.m_modeChange) {
                this.m_modeChange = false;
                ScreenManager.suspend();
            }
        } else {
            this.m_modeChange = false;
            if (n == -393271) {
                LOG.error((Object)"updateGuiToServiceMode - Unable to communicate with the device");
                this.popupError(-327840);
            } else {
                LOG.error((Object)"updateGuiToServiceMode - Unable to change to operational mode");
                this.popupError(-327857);
            }
        }
        LOG.exit("updateGuiToServiceMode");
    }

    public void updateGuiToNormalMode(int n) {
        LOG.enter("updateGuiToNormalMode", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_normalMode = true;
            this.m_modeBtn.setText(this.m_serviceModeBtnLblStr);
            this.m_modeMessageLbl.setText(this.m_normalModeMessage);
            this.m_astroTestPanel.updateGuiToNormalMode();
            this.m_astroBerAndRssiReportPanel.updateGuiToNormalMode();
            if (this.m_modeChange) {
                this.m_modeChange = false;
                ScreenManager.suspend();
            }
        } else {
            this.m_modeChange = false;
            if (n == -393271) {
                LOG.error((Object)"updateGuiToNormalMode - Unable to connect with the device");
                this.popupError(-327840);
            } else {
                LOG.error((Object)"updateGuiToNormalMode - Unable to change operational mode");
                this.popupError(-327857);
            }
        }
        LOG.exit("updateGuiToNormalMode");
    }

    public void doNothing(int n) {
        LOG.enter("doNothing", new Object[]{Integer.toString(n)});
        LOG.exit("doNothing");
    }

    public void genError(int n, String string) {
        LOG.enter("genError", new Object[]{Integer.toString(n), string});
        if (string.equals("m_astroTestPanel.updatePatternSelection")) {
            this.m_astroTestPanel.updatePatternSelection(n, -1);
        }
        LOG.exit("genError");
    }

    public boolean isRssiTestNeedToStop() {
        LOG.enter("isRssiTestNeedToStop");
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        bl = this.m_testMeasurementTab.getSelectedIndex() == 0;
        bl = this.m_astroBerAndRssiReportPanel.isRssiTestRunning() && bl;
        bl3 = this.m_astroBerAndRssiReportPanel.isRssiTestNotRunning();
        if (bl) {
            cPop.display(-327858);
            bl2 = cPop.getStatus();
            if (!bl2) {
                this.m_testMeasurementTab.setSelectedIndex(1);
                LOG.exit("isRssiTestNeedToStop", (Object)Boolean.toString(bl3));
                return bl3;
            }
        }
        LOG.exit("isRssiTestNeedToStop", (Object)Boolean.toString(bl3));
        return bl;
    }

    public boolean tabChangeUpdates() {
        LOG.enter("tabChangeUpdates");
        boolean bl = this.m_astroBerAndRssiReportPanel.isRxTestNotRunning();
        if (0 == this.m_testMeasurementTab.getSelectedIndex() && this.m_astroBerAndRssiReportPanel.isRxTestRunning()) {
            LOG.trace((Object)"tabChangeUpdates - Receiver Test is Running");
            infoPopup.display(-630405);
            this.m_testMeasurementTab.setSelectedIndex(1);
        } else if (1 == this.m_testMeasurementTab.getSelectedIndex()) {
            if (this.m_astroTestPanel.isPatternsRunning()) {
                this.m_astroBerAndRssiReportPanel.m_startRxTestBtn.setEnabled(false);
            } else if (!this.m_normalMode && !this.m_astroBerAndRssiReportPanel.isBerTestRunning()) {
                this.m_astroBerAndRssiReportPanel.m_startRxTestBtn.setEnabled(true);
            }
        }
        LOG.exit("tabChangeUpdates", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isBerTestNeedToStop() {
        LOG.enter("isBerTestNeedToStop");
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        bl = this.m_testMeasurementTab.getSelectedIndex() == 0;
        bl = this.m_astroBerAndRssiReportPanel.isBerTestRunning() && bl;
        bl3 = this.m_astroBerAndRssiReportPanel.isBerTestNotRunning();
        if (bl) {
            LOG.trace((Object)"isBerTestNeedToStop - Test is runnning");
            cPop.display(-327858);
            bl2 = cPop.getStatus();
            if (!bl2) {
                this.m_testMeasurementTab.setSelectedIndex(1);
                LOG.exit("isBerTestNeedToStop", (Object)Boolean.toString(bl3));
                return bl3;
            }
        }
        LOG.exit("isBerTestNeedToStop", (Object)Boolean.toString(bl3));
        return bl;
    }

    public boolean canCloseScreen() {
        LOG.enter("canCloseScreen");
        boolean bl = this.m_oTestClosingHandler.isTestRunning(this);
        LOG.exit("canCloseScreen", (Object)Boolean.toString(bl));
        return bl;
    }

    @Override
    public boolean isTestRunning() {
        LOG.enter("isTestRunning");
        boolean bl = this.m_astroTestPanel.isPatternsRunning();
        LOG.exit("isTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public void setIsPatternAllowed(boolean bl) {
        this.m_bIsPatternAllowed = bl;
    }

    public boolean isRssiPatternAllowed() {
        LOG.enter("isRssiPatternAllowed");
        boolean bl = !this.m_astroBerAndRssiReportPanel.isRssiTestRunning() && this.m_bIsPatternAllowed;
        LOG.exit("isRssiPatternAllowed", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isBerPatternAllowed() {
        LOG.enter("isBerPatternAllowed");
        boolean bl = !this.m_astroBerAndRssiReportPanel.isBerTestRunning() && this.m_bIsPatternAllowed;
        LOG.exit("isBerPatternAllowed", (Object)Boolean.toString(bl));
        return bl;
    }

    public void checkPatternType() {
        this.checkPatternTypeStatus();
    }

    public boolean checkPatternTypeStatus() {
        boolean bl = true;
        LOG.enter("checkPatternType");
        if (this.m_astroTestPanel.isPatternsRunning()) {
            if (this.m_astroTestPanel.isFdmaTypeTransmitted() && !this.m_astroBerAndRssiReportPanel.isFdmaTypeTransmitted()) {
                this.setIsPatternAllowed(false);
                bl = false;
                errorPopup.display(TDMA_CANNOT_START_MSG);
            } else if (!this.m_astroTestPanel.isFdmaTypeTransmitted() && this.m_astroBerAndRssiReportPanel.isFdmaTypeTransmitted()) {
                this.setIsPatternAllowed(false);
                bl = false;
                errorPopup.display(FDMA_CANNOT_START_MSG);
            } else {
                this.setIsPatternAllowed(true);
                bl = true;
            }
        } else {
            this.setIsPatternAllowed(true);
            bl = true;
        }
        LOG.exit("checkPatternType");
        return bl;
    }

    public boolean isMsbrIsr() {
        LOG.enter("isMsbrIsr");
        boolean bl = this.appHWCombination.indexOf("STR 3000 Simulcast Radio") >= 0 || this.appHWCombination.indexOf("ISR") >= 0;
        LOG.exit("isMsbrIsr", (Object)bl);
        return bl;
    }

    public void handleTdmaMode(int n, Integer[] integerArray) {
        LOG.enter("handleTdmaMode", new Object[]{n, integerArray});
        this.c_TdmaMode = integerArray[0];
        this.m_astroTestPanel.updatePatternList(n, integerArray);
        this.m_astroBerAndRssiReportPanel.handleTdmaMode(n, integerArray);
        LOG.exit("handleTdmaMode");
    }

    public void handleReceiveOperations(int n, Integer[] integerArray) {
        LOG.enter("handleReceiveOperations", new Object[]{n, integerArray});
        this.c_ReceiveOperations = integerArray[0];
        LOG.exit("handleReceiveOperations");
    }

    public void receiverStatusRealTimeResponse(int n) {
        LOG.enter("receiverStatusRealTimeResponse", new Object[]{n});
        if (1 == n && m_bIsBerWarningPopupAllowed) {
            infoPopup.display(this.m_warningMessage);
            m_bIsBerWarningPopupAllowed = false;
        }
        LOG.exit("receiverStatusRealTimeResponse");
    }

    public void pressFakeBerStop() {
        LOG.enter("pressFakeBerStop");
        Session4OldRules session4OldRules = new Session4OldRules();
        Rule rule = new BerStopRule();
        rule.process((SessionIfc)session4OldRules);
        rule = new BerStop1031P2();
        rule.process((SessionIfc)session4OldRules);
        LOG.exit("pressFakeBerStop");
    }

    public int getReceiveOperations() {
        return this.c_ReceiveOperations;
    }

    public int getTdmaMode() {
        return this.c_TdmaMode;
    }

    public boolean startBrAstroTestInitRules() {
        LOG.enter("startBrAstroTestInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_astroTestPanel.getGenericListener().notifyGuiListener();
        }
        LOG.exit("startBrAstroTestInitRules", (Object)bl);
        return bl;
    }

    public boolean startBrAstroBerAndRssiReportInitRules() {
        LOG.enter("startBrAstroBerAndRssiReportInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_astroBerAndRssiReportPanel.getGenericListener().notifyGuiListener();
        }
        LOG.exit("startBrAstroBerAndRssiReportInitRules", (Object)bl);
        return bl;
    }

    private class Session4OldRules
    implements SessionIfc {
        private Session4OldRules() {
        }

        public void sendCmd(MessageIfc messageIfc) {
            DataObject dataObject;
            if (null != messageIfc && null != (dataObject = messageIfc.getDataObject())) {
                messageIfc.getDataObject().setSessionName(BrTestMeasurementScreen.this.m_screenMaker.getSessionType());
                ServiceProtocolMultiplexer.getServiceProtocolMultiplexer().process(dataObject);
            }
        }

        public ActionEvent getActionEvent() {
            return null;
        }
    }

    public class StopBerTestTabChange
    implements RuleIfc {
        public boolean process(SessionIfc sessionIfc) {
            LOG.enter("process");
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            bl = BrTestMeasurementScreen.this.m_testMeasurementTab.getSelectedIndex() == 0;
            bl = BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBerTestRunning() && bl;
            bl3 = BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBerTestNotRunning();
            if (bl) {
                LOG.trace((Object)"isBerTestNeedToStop - Test is runnning");
                cPop.display(-327858);
                bl2 = cPop.getStatus();
                if (!bl2) {
                    BrTestMeasurementScreen.this.m_testMeasurementTab.setSelectedIndex(1);
                    LOG.exit("isBerTestNeedToStop", (Object)Boolean.toString(bl3));
                    return bl3;
                }
            }
            LOG.exit("process", (Object)Boolean.toString(bl3));
            return bl;
        }
    }

    public class BerTestAllowance
    implements RuleIfc {
        public boolean process(SessionIfc sessionIfc) {
            LOG.enter("process", new Object[]{sessionIfc});
            boolean bl = false;
            LOG.enter("process");
            LOG.exit("process");
            bl = BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isRssiTestRunning() ? false : BrTestMeasurementScreen.this.checkPatternTypeStatus();
            if (bl) {
                if (BrTestMeasurementScreen.this.isBerPatternAllowed()) {
                    BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.m_BerStartActions.notifyGuiListener();
                } else if (BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBerTestRunning()) {
                    BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.m_BerStopActions.notifyGuiListener();
                } else {
                    LOG.warn((Object)"Should not enter here!");
                }
            }
            LOG.exit("process", (Object)bl);
            return bl;
        }
    }

    public class BerStop1031P2
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2202);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            LOG.exit("condition");
            return BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBer1031andP2();
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            boolean bl = true;
            if (0 == n) {
                bl = true;
                BrTestMeasurementScreen.this.m_astroTestPanel.patternStopUpdate();
            } else {
                bl = false;
                BrTestMeasurementScreen.this.popupError(-327849);
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class BerStart1031P2Started
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            LOG.exit("condition");
            return BrTestMeasurementScreen.this.m_astroTestPanel.is1031HzTypeTransmitted() && BrTestMeasurementScreen.this.m_astroTestPanel.isPatternsRunning();
        }
    }

    public class BerStartNon1031P2
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            LOG.exit("condition");
            return !BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBer1031andP2();
        }
    }

    public class BerStart1031P2
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("TestPattern", Integer.class, (Object)12);
            message.setProtocolKey(2201);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            boolean bl = BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBer1031andP2();
            LOG.exit("condition");
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            boolean bl = true;
            if (0 == n) {
                bl = true;
            } else {
                bl = false;
                BrTestMeasurementScreen.this.popupError(-327847);
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class BerStopRule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            LOG.exit("condition");
            return BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.isBerTestRunning();
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            LOG.exit("getMessage");
            Message message = new Message();
            message.setProtocolKey(2204);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            LOG.exit("update");
            BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.stopBerUpdate(n);
            m_bIsBerWarningPopupAllowed = false;
            return true;
        }
    }

    public class BerStartRule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition");
            LOG.exit("condition");
            return BrTestMeasurementScreen.this.isBerPatternAllowed();
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            LOG.exit("getMessage");
            Object[] objectArray = BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.getNeededBerMeasurementInfo();
            Message message = new Message();
            message.addParameter("PatternType", Integer.class, objectArray[0]);
            message.addParameter("SamplePeriod", Integer.class, objectArray[1]);
            message.setProtocolKey(2203);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            LOG.exit("update");
            BrTestMeasurementScreen.this.m_astroBerAndRssiReportPanel.startBerUpdate(n);
            m_bIsBerWarningPopupAllowed = true;
            return true;
        }
    }
}

