/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.service.DataObject;
import css.core.service.MessageIfc;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceProtocolMultiplexer;
import css.device.platform.summit.screens.alignment.CarrierSquelchTab;
import css.device.platform.summit.screens.alignment.CarrierSquelchTabGUI;
import css.device.platform.summit.screens.alignment.RxWirelinePanel;
import css.device.platform.summit.screens.alignment.SacReferenceOscillatorFrequencyTab;
import css.device.platform.summit.screens.alignment.SummitAstroSimulcastAlignment;
import css.device.platform.summit.screens.alignment.SummitBatteryEqualizationScreen;
import css.device.platform.summit.screens.alignment.TxWirelinePanel;
import css.device.platform.summit.screens.alignment.WirelineController;
import css.device.platform.summit.tables.SummitTranslationInfoRules;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;

public class SummitAlignmentScreen
extends GenericScreen
implements SummitTranslationInfoRules {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitAlignmentScreen.class);
    private final String BATTEQUAL_ALIGNMENT_TAB = "Battery Equalization";
    private final String ASTRO_ALIGNMENT_TAB = "ASTRO/Analog Simulcast Alignment";
    private final String SAC_REFERENCE_OSCILLATOR_TAB = "Reference Oscillator Alignment";
    private final String CARRIER_SQUELCH_TAB = "Carrier Squelch Alignment";
    private final String TX_WIRELINE_TAB = "Tx Wireline Alignment";
    private final String RX_WIRELINE_TAB = "Rx Wireline Alignment";
    private int nCurrentDeviceMode;
    private static final String m_modeMessage = "Note: The station must be set to Service mode in order to perform any alignment or tone generation.";
    private static final String m_modeMessageWithEnterNote = "<html>Notes: The station must be set to Service mode in order to perform any alignment or tone generation.<p align=\"center\">In order to commit current values enter must be pressed.</p>";
    private static final String m_simulcastTabNote = "<html>Notes: The station must be set to Service mode in order to perform any alignment or tone generation.<p align=\"center\">When applied to Analog Simulcast, Simulcast Launch Time Offset is merely a delay of the Analog transmit signal.</p>";
    private static final String m_serviceModeBtnLblStr = "Change to Service Mode";
    private static final String m_normalModeBtnLblStr = "Change to Normal Mode";
    public SummitBatteryEqualizationScreen m_battEqualScreen;
    public SummitAstroSimulcastAlignment m_astroSimulcast;
    public SacReferenceOscillatorFrequencyTab m_refOscilatorFreqTab;
    public CarrierSquelchTab m_carrierSquelchTab;
    public TxWirelinePanel m_txWirelinePanel = null;
    public RxWirelinePanel m_rxWirelinePanel = null;
    public JButton m_deviceModeBtn = new JButton("Change to Normal Mode");
    private JTabbedPane m_tabbedPane;
    private boolean m_isSimulcastApp = true;
    private ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    private JLabel m_modeMessageLbl = new JLabel("Note: The station must be set to Service mode in order to perform any alignment or tone generation.");
    private ErrorPopup m_errorPopup = new ErrorPopup();
    private int m_nTabNumberSimulcast = -2;
    private int m_nTabNumberSAC = -2;
    private int m_nTabNumberCSQ = -2;
    public WirelineController m_wirelineController = null;

    public SummitAlignmentScreen() {
        LOG.enter("SummitAlignmentScreen");
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.setName("TabbedPane");
        this.m_battEqualScreen = new SummitBatteryEqualizationScreen(this);
        this.m_battEqualScreen.setName("BattEqualPanel");
        this.m_astroSimulcast = new SummitAstroSimulcastAlignment(this);
        this.m_refOscilatorFreqTab = new SacReferenceOscillatorFrequencyTab(this);
        this.m_carrierSquelchTab = new CarrierSquelchTab(this);
        this.m_txWirelinePanel = new TxWirelinePanel(this);
        this.m_rxWirelinePanel = new RxWirelinePanel(this);
        this.m_wirelineController = new WirelineController();
        this.m_wirelineController.setTxWirelineView(this.m_txWirelinePanel);
        this.m_wirelineController.setRxWirelineView(this.m_rxWirelinePanel);
        LOG.exit("SummitAlignmentScreen");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        this.MENU_ITEM_NAME = "Alignment Screens";
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("STR 3000 Simulcast Radio") < 0 && string.indexOf("CONVBR") < 0) {
            this.m_isSimulcastApp = false;
        }
        int n = 0;
        this.m_battEqualScreen.buildScreen(this.m_window, statusBarListener, this.m_tabbedPane);
        this.m_tabbedPane.insertTab("Battery Equalization", null, this.m_battEqualScreen, null, n);
        this.m_battEqualScreen.setEnabled(false);
        this.m_astroSimulcast.buildScreen(this.m_window, statusBarListener);
        if (this.m_isSimulcastApp) {
            this.m_nTabNumberSimulcast = ++n;
            this.m_tabbedPane.insertTab("ASTRO/Analog Simulcast Alignment", null, this.m_astroSimulcast, null, this.m_nTabNumberSimulcast);
        }
        ++n;
        this.m_nTabNumberSAC = n++;
        this.m_refOscilatorFreqTab.buildScreen(this.m_window, statusBarListener);
        this.m_tabbedPane.insertTab("Reference Oscillator Alignment", null, this.m_refOscilatorFreqTab, null, this.m_nTabNumberSAC);
        if (this.isConvBR()) {
            this.m_carrierSquelchTab.buildScreen(this.m_window, statusBarListener);
            this.m_tabbedPane.insertTab("Carrier Squelch Alignment", null, this.m_carrierSquelchTab, null, n);
            this.m_nTabNumberCSQ = n++;
            this.m_tabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    LOG.enter("stateChanged");
                    SummitAlignmentScreen.this.uncheckToneOnOffButtons();
                    if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof CarrierSquelchTabGUI) {
                        LOG.trace((Object)"buildScreen - CSQ tab selected");
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_modeMessage);
                        SummitAlignmentScreen.this.startCarrierSquelchInitRules();
                    } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof TxWirelinePanel) {
                        LOG.trace((Object)"buildScreen - TxWireline tab selected");
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_modeMessageWithEnterNote);
                        SummitAlignmentScreen.this.startTxWirelineInitRules();
                    } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof RxWirelinePanel) {
                        LOG.trace((Object)"buildScreen - RxWireline tab selected");
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_modeMessageWithEnterNote);
                        SummitAlignmentScreen.this.startRxWirelineInitRules();
                    } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof SummitAstroSimulcastAlignment) {
                        if (SummitAlignmentScreen.this.m_astroSimulcast.m_isSimulcastEnabled) {
                            SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_simulcastTabNote);
                        } else {
                            SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_modeMessage);
                        }
                    } else {
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.m_modeMessage);
                    }
                    LOG.exit("stateChanged");
                }
            });
            this.m_tabbedPane.setEnabledAt(this.m_nTabNumberCSQ, true);
            this.m_txWirelinePanel.buildScreen(this.m_window, statusBarListener);
            this.m_tabbedPane.insertTab("Tx Wireline Alignment", null, this.m_txWirelinePanel, null, n);
            this.m_rxWirelinePanel.buildScreen(this.m_window, statusBarListener);
            this.m_tabbedPane.insertTab("Rx Wireline Alignment", null, this.m_rxWirelinePanel, null, ++n);
        }
        this.buildModeSwitchPanel(statusBarListener);
        this.disableScreen();
        LOG.exit("buildScreen");
    }

    private void buildModeSwitchPanel(StatusBarListener statusBarListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagAdder.add((Container)jPanel, (Component)this.m_modeMessageLbl, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
        this.m_deviceModeBtn.setToolTipText("Switches the Station between Normal and Service Mode");
        this.m_deviceModeBtn.setEnabled(true);
        this.m_modeMessageLbl.setEnabled(true);
        GridBagAdder.add((Container)jPanel, (Component)this.m_deviceModeBtn, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)2, (int)0, (int)150, (int)0, (int)150, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)5, (int)40, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_deviceModeBtn, "Click this button to change the station's mode");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.m_window.lockWindow();
        this.disableScreen();
        this.m_deviceModeBtn.setText(m_normalModeBtnLblStr);
        if (this.m_isSimulcastApp) {
            this.m_astroSimulcast.initialize();
        }
        this.m_battEqualScreen.initialize();
        LOG.exit("initialize");
    }

    private void disableScreen() {
        LOG.enter("disableScreen");
        this.m_battEqualScreen.disableGuiControl();
        LOG.exit("disableScreen");
    }

    public void handleStopSession(int n) {
        LOG.enter("handleStopSession", new Object[]{n});
        if (n != 0) {
            LOG.error((Object)"handleStopSession - Received error while trying to close session");
        }
        LOG.exit("handleStopSession");
    }

    public void realTimeUpdate(Object object) {
        LOG.enter("realTimeUpdate", new Object[]{object});
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        LOG.enter("realTimeUpdate", new Object[]{object});
        if (realTimeDataObject != null) {
            if (realTimeDataObject.getError() == -262160) {
                LOG.error((Object)("realTimeUpdate" + realTimeDataObject.getError()));
                this.popupError(-262160);
                this.close();
            } else {
                this.m_refOscilatorFreqTab.realTimeUpdate(realTimeDataObject);
                this.m_carrierSquelchTab.realTimeUpdate(realTimeDataObject);
            }
        }
        LOG.exit("realTimeUpdate");
    }

    public Object[] startSession() {
        LOG.enter("startSession");
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        Byte by = new Byte(0);
        Byte by2 = new Byte(0);
        Object[][] objectArray = SummitAlignmentRules;
        Object[] objectArray2 = new Object[]{by, by2, objectArray};
        LOG.exit("startSession");
        return objectArray2;
    }

    public void handleStartSession(int n) {
        LOG.enter("handleStartSession", new Object[]{n});
        if (n != 0) {
            this.popupError("unable_to_start_session");
            this.close();
        }
        LOG.exit("handleStartSession");
    }

    private void initSACTabRules(SessionIfc sessionIfc) {
        Rule rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_SacFreqRefOscStatus();
        if (rule.process(sessionIfc)) {
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_Transmit_Frequency();
            rule.process(sessionIfc);
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_SacFreqRefOscValue();
            rule.process(sessionIfc);
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_Hardware_Type();
            rule.process(sessionIfc);
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Get_KeyUp_DeKey_Status_Rule();
            rule.process(sessionIfc);
            this.m_tabbedPane.setEnabledAt(this.m_nTabNumberSAC, true);
        }
    }

    public boolean startSACTabInitRules() {
        LOG.enter("startSACTabInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            if (5 == this.nCurrentDeviceMode) {
                this.m_window.setCursor(Cursor.getPredefinedCursor(3));
                Session4OldRules session4OldRules = new Session4OldRules();
                this.initSACTabRules(session4OldRules);
                this.m_carrierSquelchTab.setServiceMode(true);
            } else {
                this.m_tabbedPane.setEnabledAt(this.m_nTabNumberSAC, false);
                this.m_carrierSquelchTab.setServiceMode(false);
                this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
            }
        } else if (string.indexOf("ISR") >= 0) {
            if (5 == this.nCurrentDeviceMode) {
                this.m_window.setCursor(Cursor.getPredefinedCursor(3));
                Session4OldRules session4OldRules = new Session4OldRules();
                this.initSACTabRules(session4OldRules);
            } else {
                this.m_tabbedPane.setEnabledAt(this.m_nTabNumberSAC, false);
                this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
            }
        } else {
            this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("startSACTabInitRules", (Object)bl);
        return bl;
    }

    public boolean startSACTabCloseRules() {
        LOG.enter("startSACTabCloseRules");
        boolean bl = true;
        Session4OldRules session4OldRules = new Session4OldRules();
        SacReferenceOscillatorFrequencyTab.DeKey_Rule deKey_Rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.DeKey_Rule();
        deKey_Rule.process(session4OldRules);
        LOG.exit("startSACTabCloseRules", (Object)bl);
        return bl;
    }

    public void updateNormalModeDependencies(int n) {
        LOG.enter("updateNormalModeDependencies", new Object[]{n});
        if (n == 0) {
            ScreenManager.suspend();
        } else {
            LOG.warn((Object)"Unable to Change mode");
            this.m_errorPopup.display(-327684);
        }
        LOG.exit("updateNormalModeDependencies");
    }

    public void updateModeDependencies(int n, Integer n2) {
        LOG.enter("updateModeDependencies", new Object[]{n, n2});
        int n3 = n2;
        if (n == 0) {
            this.nCurrentDeviceMode = n3;
            if (this.m_tabbedPane.getSelectedComponent() instanceof CarrierSquelchTabGUI) {
                this.m_modeMessageLbl.setText(m_modeMessage);
                this.startCarrierSquelchInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof TxWirelinePanel) {
                this.m_modeMessageLbl.setText(m_modeMessageWithEnterNote);
                this.startTxWirelineInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof RxWirelinePanel) {
                this.m_modeMessageLbl.setText(m_modeMessageWithEnterNote);
                this.startRxWirelineInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof SummitAstroSimulcastAlignment) {
                if (this.m_astroSimulcast.m_isSimulcastEnabled) {
                    this.m_modeMessageLbl.setText(m_simulcastTabNote);
                } else {
                    this.m_modeMessageLbl.setText(m_modeMessage);
                }
            } else {
                this.m_modeMessageLbl.setText(m_modeMessage);
            }
            if (n3 == 2) {
                this.m_deviceModeBtn.setText(m_serviceModeBtnLblStr);
                if (this.m_isSimulcastApp) {
                    this.m_astroSimulcast.m_transmitFrequencyLbl.setEnabled(false);
                    this.m_astroSimulcast.m_storedLaunchTimeOffsetLbl.setEnabled(false);
                    this.m_astroSimulcast.m_launchTimeOffsetTFld.setEnabled(false);
                    this.m_astroSimulcast.m_storeLaunchTimeOffsetBtn.setEnabled(false);
                    this.m_astroSimulcast.m_testPatternBtn.setEnabled(false);
                }
                this.m_rxWirelinePanel.getWirelineButton().setEnabled(false);
                this.m_txWirelinePanel.getKeyupLine1Component().setEnabled(false);
                this.m_txWirelinePanel.getKeyupLine3Component().setEnabled(false);
            } else if (n3 == 5) {
                this.m_deviceModeBtn.setText(m_normalModeBtnLblStr);
                if (this.m_isSimulcastApp) {
                    this.m_astroSimulcast.m_transmitFrequencyLbl.setEnabled(true);
                    this.m_astroSimulcast.m_storedLaunchTimeOffsetLbl.setEnabled(true);
                    this.m_astroSimulcast.m_launchTimeOffsetTFld.setEnabled(true);
                    this.m_astroSimulcast.m_storeLaunchTimeOffsetBtn.setEnabled(true);
                    this.m_astroSimulcast.m_testPatternBtn.setEnabled(true);
                }
                this.m_rxWirelinePanel.getWirelineButton().setEnabled(true);
                this.m_txWirelinePanel.getKeyupLine1Component().setEnabled(true);
                this.m_txWirelinePanel.getKeyupLine3Component().setEnabled(true);
            } else {
                LOG.warn((Object)"The station is in Config mode");
                PnmDialog.error((Object)this.m_window, (String)"device_is_in_unknown_mode");
                this.closeScreen(true);
            }
            if (!this.m_isSimulcastApp) {
                this.m_window.unlockWindow();
            }
        } else {
            LOG.warn((Object)"Unable to Change mode");
            PnmDialog.error((Object)this.m_window, (String)"unable_to_get_mode");
            this.closeScreen(true);
        }
        LOG.exit("updateModeDependencies");
    }

    public boolean userRequest() {
        LOG.enter("userRequest");
        this.m_confirmPopup.display(-327683);
        if (this.m_confirmPopup.getStatus()) {
            this.m_window.lockWindow();
        }
        LOG.exit("userRequest", (Object)false);
        return false;
    }

    public boolean isSetForNormal() {
        boolean bl = false;
        LOG.enter("isSetForNormal");
        if (this.m_confirmPopup.getStatus() && this.m_deviceModeBtn.getText().equalsIgnoreCase(m_normalModeBtnLblStr)) {
            bl = true;
        }
        LOG.exit("Exit isSetForNormal", (Object)bl);
        return bl;
    }

    public boolean isSetForService() {
        boolean bl = false;
        LOG.enter("isSetForService");
        if (this.m_confirmPopup.getStatus() && this.m_deviceModeBtn.getText().equalsIgnoreCase(m_serviceModeBtnLblStr)) {
            bl = true;
        }
        LOG.exit("Exit isSetForService", (Object)bl);
        return bl;
    }

    public void genError(int n, String string) {
        LOG.enter("genError", new Object[]{n, string});
        if (string.equalsIgnoreCase("handleStartSession")) {
            this.handleStartSession(n);
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateTxFreq")) {
            this.m_astroSimulcast.updateTxFreq(n, new Integer[]{new Integer(-1)});
        } else if (string.equalsIgnoreCase("updateModeDependencies")) {
            this.updateModeDependencies(n, new Integer(-1));
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateLto")) {
            this.m_astroSimulcast.updateLto(n, new Integer(-1));
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateLto")) {
            this.m_astroSimulcast.updateLto(n);
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateStoredLto")) {
            this.m_astroSimulcast.updateStoredLto(n);
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateInitiateTestPattern")) {
            this.m_astroSimulcast.updateInitiateTestPattern(n);
        } else if (string.equalsIgnoreCase("m_astroSimulcast.updateStopTestPattern")) {
            this.m_astroSimulcast.updateStopTestPattern(n);
        } else if (string.equalsIgnoreCase("updateNormalModeDependencies")) {
            this.updateNormalModeDependencies(n);
        } else if (string.equalsIgnoreCase("closeScreen")) {
            this.closeScreen(n);
        }
        LOG.exit("genError");
    }

    public boolean isSimulcastApplication() {
        LOG.enter("isSimulcastApplication");
        LOG.exit("isSimulcastApplication", (Object)this.m_isSimulcastApp);
        return this.m_isSimulcastApp;
    }

    public boolean startCarrierSquelchInitRules() {
        LOG.enter("startCarrierSquelchInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0 && 5 == this.nCurrentDeviceMode) {
            this.m_carrierSquelchTab.setInitialization(true);
            this.m_window.lockWindow();
            this.m_carrierSquelchTab.m_oGenericListener.notifyGuiListener();
            this.m_carrierSquelchTab.setInitialization(false);
        }
        LOG.exit("startCarrierSquelchInitRules", (Object)bl);
        return bl;
    }

    public boolean startTxWirelineInitRules() {
        LOG.enter("startWirelineInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_txWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            Rule rule = new WirelineController.SetWirelineAlignment_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
            rule = new WirelineController.Get_KeyUp_DeKey_Line1_Status_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
            rule = new WirelineController.Get_KeyUp_DeKey_Line3_Status_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
        }
        LOG.exit("startWirelineInitRules");
        return bl;
    }

    public boolean uncheckToneOnOffButtons() {
        LOG.enter("uncheckToneOnOffButtons");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_rxWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            WirelineController.SetWirelineTonesButtonsOFF_Rule setWirelineTonesButtonsOFF_Rule = new WirelineController.SetWirelineTonesButtonsOFF_Rule(this.m_wirelineController);
            setWirelineTonesButtonsOFF_Rule.process(session4OldRules);
        }
        LOG.exit("uncheckToneOnOffButtons");
        return bl;
    }

    public boolean stopSINADMeasurementProcess() {
        LOG.enter("stopSINADMeasurementProcess");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0 && this.m_carrierSquelchTab.isSINADMeasurementStarted()) {
            Session4OldRules session4OldRules = new Session4OldRules();
            CarrierSquelchTab.SINADMeasurement sINADMeasurement = this.m_carrierSquelchTab.new CarrierSquelchTab.SINADMeasurement();
            sINADMeasurement.process(session4OldRules);
        }
        LOG.exit("stopSINADMeasurementProcess");
        return bl;
    }

    public boolean stopGetCSQStateProcess() {
        LOG.enter("stopGetCSQStateProcess");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            Session4OldRules session4OldRules = new Session4OldRules();
            CarrierSquelchTab.CSQState_Stop cSQState_Stop = this.m_carrierSquelchTab.new CarrierSquelchTab.CSQState_Stop();
            cSQState_Stop.process(session4OldRules);
        }
        LOG.exit("stopGetCSQStateProcess");
        return bl;
    }

    public boolean isAnalogSimulcast() {
        LOG.enter("isAnalogSimulcast");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_astroSimulcast.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            SummitAstroSimulcastAlignment.GetTestPattern_Rule getTestPattern_Rule = new SummitAstroSimulcastAlignment.GetTestPattern_Rule(this.m_astroSimulcast);
            getTestPattern_Rule.process(session4OldRules);
        }
        LOG.exit("isAnalogSimulcast");
        return bl;
    }

    public boolean isSimulcastOperationEnabled() {
        LOG.enter("isSimulcastOperationEnabled");
        LOG.exit("isSimulcastOperationEnabled");
        return this.m_astroSimulcast.m_isSimulcastEnabled;
    }

    public boolean startRxWirelineInitRules() {
        LOG.enter("startRxWirelineInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            this.m_wirelineController.setDeviceMode(this.nCurrentDeviceMode);
            this.m_rxWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            WirelineController.SetWirelineAlignment_Rule setWirelineAlignment_Rule = new WirelineController.SetWirelineAlignment_Rule(this.m_wirelineController);
            setWirelineAlignment_Rule.process(session4OldRules);
        }
        LOG.exit("startWirelineInitRules");
        return bl;
    }

    public boolean isConvBR() {
        boolean bl = false;
        LOG.enter("isConvBR");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (string.indexOf("CONVBR") >= 0) {
            bl = true;
        }
        LOG.exit("isConvBR");
        return bl;
    }

    private class Session4OldRules
    implements SessionIfc {
        private Session4OldRules() {
        }

        public void sendCmd(MessageIfc messageIfc) {
            DataObject dataObject;
            if (null != messageIfc && null != (dataObject = messageIfc.getDataObject())) {
                messageIfc.getDataObject().setSessionName(SummitAlignmentScreen.this.m_screenMaker.getSessionType());
                ServiceProtocolMultiplexer.getServiceProtocolMultiplexer().process(dataObject);
            }
        }

        public ActionEvent getActionEvent() {
            return null;
        }
    }
}

