/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.component.GenericListener;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pnm.ui.UIInternalFrame;

public class SummitAstroSimulcastAlignment
extends JPanel
implements DeviceConstants,
DeviceErrorCodes,
CssConstants {
    private static final String LABEL_FONT_FAMILY = "Tahoma";
    private static final int LABEL_FONT_SIZE = 11;
    private static final long serialVersionUID = -7498064104826218600L;
    public GenericListener m_oGenericListener = new GenericListener();
    public JTextField m_launchTimeOffsetTFld;
    public JLabel m_transmitFrequencyLbl;
    public JLabel m_storedLaunchTimeOffsetLbl;
    public JTextArea m_voInformationTxt;
    private final String m_launchTimeOffset = "Simulcast Transmit Offset Delay (usec)";
    private final String m_storedLaunchTimeOffset = "Stored Simulcast Transmit Offset Delay (usec)";
    private final String m_transmitFrequency = "Transmit Frequency (MHz)";
    private final String m_sInformationTxt = "Ensure that the Transmitter is both ENABLED and IDLE via the Status Panel\nService screen before initiating a Simulcast Test Pattern.";
    public JButton m_storeLaunchTimeOffsetBtn;
    public JButton m_testPatternBtn;
    boolean m_popupIsUp = false;
    private UIInternalFrame m_window;
    private SummitAlignmentScreen m_alignment;
    public boolean m_isSimulcastEnabled = false;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitAstroSimulcastAlignment.class);

    public SummitAstroSimulcastAlignment(SummitAlignmentScreen summitAlignmentScreen) {
        this.m_alignment = summitAlignmentScreen;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText("Transmit Frequency (MHz)");
        jLabel.setToolTipText("Frequency assigned to the transmitter.");
        GridBagAdder.add((Container)this, (Component)jLabel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)10, (int)3, (int)0, (int)10, (int)0);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Stored Simulcast Transmit Offset Delay (usec)");
        jLabel2.setToolTipText("Simulcast Transmit Offset Delay value stored in the station.");
        GridBagAdder.add((Container)this, (Component)jLabel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)5, (int)3, (int)0, (int)10, (int)0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Simulcast Transmit Offset Delay (usec)");
        jLabel3.setToolTipText("Simulcast Transmit Offset Delay to be stored in the station.");
        GridBagAdder.add((Container)this, (Component)jLabel3, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)5, (int)3, (int)0, (int)10, (int)0);
        this.m_transmitFrequencyLbl = new JLabel("N/A");
        GridBagAdder.add((Container)this, (Component)this.m_transmitFrequencyLbl, (int)1, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)1, (int)10, (int)20, (int)0, (int)10, (int)0);
        this.m_storedLaunchTimeOffsetLbl = new JLabel("N/A");
        GridBagAdder.add((Container)this, (Component)this.m_storedLaunchTimeOffsetLbl, (int)1, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)1, (int)5, (int)20, (int)0, (int)10, (int)0);
        this.m_launchTimeOffsetTFld = new JTextField();
        this.m_launchTimeOffsetTFld.setEnabled(true);
        GridBagAdder.add((Container)this, (Component)this.m_launchTimeOffsetTFld, (int)1, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)1, (int)5, (int)20, (int)0, (int)10, (int)0);
        this.m_storeLaunchTimeOffsetBtn = new JButton();
        this.m_storeLaunchTimeOffsetBtn.setText("Store Simulcast Transmit Offset Delay");
        this.m_storeLaunchTimeOffsetBtn.setToolTipText("Stores the Simulcast Transmit Offset Delay in the station.");
        GridBagAdder.add((Container)this, (Component)this.m_storeLaunchTimeOffsetBtn, (int)0, (int)6, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)30, (int)3, (int)30, (int)0, (int)0);
        this.m_testPatternBtn = new JButton();
        this.m_testPatternBtn.setText("Initiate Simulcast Test Pattern");
        this.m_testPatternBtn.setToolTipText("Initiates/Stops the Simulcast Test Pattern.");
        GridBagAdder.add((Container)this, (Component)this.m_testPatternBtn, (int)1, (int)6, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)30, (int)20, (int)30, (int)5, (int)0);
        this.m_voInformationTxt = new JTextArea();
        this.m_voInformationTxt.setFont(new Font(LABEL_FONT_FAMILY, 0, 11));
        this.m_voInformationTxt.setEditable(false);
        this.m_voInformationTxt.setBackground(this.getBackground());
        this.m_voInformationTxt.setDisabledTextColor(this.m_voInformationTxt.getForeground());
        this.m_voInformationTxt.setEnabled(false);
        this.m_voInformationTxt.setText("Ensure that the Transmitter is both ENABLED and IDLE via the Status Panel\nService screen before initiating a Simulcast Test Pattern.");
        GridBagAdder.add((Container)this, (Component)this.m_voInformationTxt, (int)0, (int)7, (double)0.0, (double)0.0, (int)1, (int)2, (int)10, (int)1, (int)5, (int)3, (int)20, (int)10, (int)0);
        statusBarListener.registerComponent((Component)this.m_testPatternBtn, "Click this button to Initiate or Stop the Simulcast Test Pattern in the station.");
        statusBarListener.registerComponent((Component)this.m_storeLaunchTimeOffsetBtn, "Click this button to store the Simulcast Transmit Offset Delay value in the station.");
        statusBarListener.registerComponent((Component)this.m_launchTimeOffsetTFld, "Enter a value between 0 and 999 usec.");
        this.m_window.lockWindow();
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_transmitFrequencyLbl.setText("N/A");
        this.m_storedLaunchTimeOffsetLbl.setText("N/A");
        this.m_launchTimeOffsetTFld.setText(" ");
        this.m_testPatternBtn.setText("Initiate Simulcast Test Pattern");
        this.m_window.lockWindow();
        LOG.exit("initialize");
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public Object[] getLto() {
        Object[] objectArray = new Object[]{null};
        String string = null;
        LOG.enter("getLto");
        this.m_window.lockWindow();
        string = this.m_launchTimeOffsetTFld.getText();
        double d = new Double(string);
        int n = (int)(d * 10.0);
        objectArray[0] = new Integer(n);
        LOG.exit("getLto", objectArray);
        return objectArray;
    }

    public void updateTxFreq(String string) {
        LOG.enter("updateTxFreq", new Object[]{string});
        this.m_transmitFrequencyLbl.setText(string);
        this.m_window.unlockWindow();
        LOG.exit("updateTxFreq");
    }

    public void updateTxFreq(int n, Integer[] integerArray) {
        block5: {
            LOG.enter("updateTxFreq", new Object[]{n, integerArray});
            if (n == 0) {
                try {
                    if (integerArray.length != 0) {
                        double d = (double)integerArray[0].intValue() / 1000000.0;
                        String string = new Double(d).toString();
                        this.m_transmitFrequencyLbl.setText(string);
                        break block5;
                    }
                    LOG.error((Object)"updateTxFreq - Array length is 0");
                    this.m_alignment.popupError(-327690);
                }
                catch (Exception exception) {
                    LOG.error((Object)"updateTxFreq - Invalid value of transmitter frequency");
                    this.m_alignment.popupError(-327690);
                }
            } else {
                LOG.error((Object)"updateTxFreq - Error on getting Transmitter Frequency");
                this.m_alignment.popupError(-327700);
            }
        }
        this.m_window.unlockWindow();
        LOG.exit("updateTxFreq");
    }

    public void updateLto(int n) {
        LOG.enter("updateLto", new Object[]{n});
        if (n != 0) {
            LOG.error((Object)"updateLto - Error on getting Launch Time Offset");
            this.m_alignment.popupError(-327693);
            this.m_storedLaunchTimeOffsetLbl.setText("N/A");
        } else {
            String string = this.m_launchTimeOffsetTFld.getText();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2 + 2);
            }
            this.m_storedLaunchTimeOffsetLbl.setText(string);
        }
        this.m_window.unlockWindow();
        LOG.exit("updateLto");
    }

    public void updateLto(int n, Integer n2) {
        LOG.enter("updateLto", new Object[]{n, n2});
        double d = n2.doubleValue() / 10.0;
        if (n != 0) {
            LOG.error((Object)"updateLto - Error on getting Simulcast Transmit Offset Delay");
            this.m_alignment.popupError(-327688);
            this.m_storedLaunchTimeOffsetLbl.setText("N/A");
        } else {
            this.m_storedLaunchTimeOffsetLbl.setText(Double.toString(d));
        }
        this.m_window.unlockWindow();
        LOG.exit("updateLto");
    }

    public void updateStoredLto(int n) {
        LOG.enter("updateStoredLto", new Object[]{n});
        if (n == 0) {
            String string = this.m_launchTimeOffsetTFld.getText();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2 + 2);
            }
            this.m_storedLaunchTimeOffsetLbl.setText(string);
        } else {
            LOG.error((Object)"updateStoredLto - Error on getting Simulcast Transmit Offset Delay");
            this.m_alignment.popupError(-327693);
            this.m_storedLaunchTimeOffsetLbl.setText("N/A");
        }
        this.m_window.unlockWindow();
        LOG.exit("updateStoredLto");
    }

    public void updateInitiateTestPattern(int n) {
        LOG.enter("updateInitiateTestPattern", new Object[]{n});
        if (n == 0) {
            this.m_testPatternBtn.setText("Stop Test Pattern");
        } else {
            LOG.error((Object)"updateInitiateTestPattern - Error on updating test pattern");
            this.m_alignment.popupError(-327689);
        }
        this.m_window.unlockWindow();
        LOG.exit("updateInitiateTestPattern");
    }

    public void updateStopTestPattern(int n) {
        LOG.enter("updateStopTestPattern", new Object[]{n});
        if (n == 0) {
            this.m_testPatternBtn.setText("Initiate Simulcast Test Pattern");
        } else {
            LOG.error((Object)"updateStopTestPattern - Error on updating test pattern");
            this.m_alignment.popupError(-327689);
        }
        this.m_window.unlockWindow();
        LOG.exit("updateStopTestPattern");
    }

    public boolean validateLto(String string) {
        boolean bl = true;
        LOG.enter("validateLto", new Object[]{string});
        this.m_window.lockWindow();
        try {
            Float f = new Float(string);
            float f2 = f.floatValue();
            if ((double)f2 < 0.0 || (double)f2 > 1000.0) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            LOG.error((Object)"validateLto", (Throwable)numberFormatException);
        }
        LOG.exit("validateLto", (Object)bl);
        return bl;
    }

    public boolean isLtoValid() {
        boolean bl = false;
        LOG.enter("isLtoValid");
        this.m_window.lockWindow();
        bl = this.validateLto(this.m_launchTimeOffsetTFld.getText());
        if (!bl) {
            this.m_alignment.popupError(-327686);
            this.m_window.unlockWindow();
        }
        LOG.exit("isLtoValid", (Object)bl);
        return bl;
    }

    public boolean isInitiateTestPattern() {
        boolean bl = false;
        LOG.enter("isInitiateTestPattern");
        this.m_window.lockWindow();
        String string = this.m_testPatternBtn.getText();
        if (string.equalsIgnoreCase("Initiate Simulcast Test Pattern")) {
            bl = true;
        }
        LOG.exit("isInitiateTestPattern", (Object)bl);
        return bl;
    }

    public JButton getTestPatternButton() {
        return this.m_testPatternBtn;
    }

    public class GetSimultcastTxFrequency_Rule
    extends Rule {
        private final String sTxFrequency = "sTxFrequency";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sTxFrequency", Byte[].class);
            message.setProtocolKey(5319);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = SummitAstroSimulcastAlignment.this.m_alignment.isSimulcastApplication();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            byte[] byArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Current Transmitter Frequency");
            } else if (null != messageIfc && null != (byArray = (byte[])messageIfc.getParameterValue("sTxFrequency"))) {
                Integer n2 = Convert.toInteger((byte[])byArray);
                Double d = (double)n2.intValue() / 1000000.0;
                String string = Double.toString(d);
                SummitAstroSimulcastAlignment.this.updateTxFreq(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetTestPattern_Rule
    extends Rule {
        private final String sSimulcast = "sSimulcastOperation";
        private final String sStation = "sStationType";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sSimulcastOperation", Integer.class);
            message.addParameter("sStationType", Integer.class);
            message.setProtocolKey(1004);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Simulcast Operation and Station Type");
            } else if (null != messageIfc) {
                Integer n2 = (Integer)messageIfc.getParameterValue("sStationType");
                Integer n3 = (Integer)messageIfc.getParameterValue("sSimulcastOperation");
                SummitAstroSimulcastAlignment.this.m_isSimulcastEnabled = 1 == n3;
                if (1 == n3 && 2 == n2) {
                    SummitAstroSimulcastAlignment.this.m_testPatternBtn.setEnabled(true);
                } else {
                    SummitAstroSimulcastAlignment.this.m_testPatternBtn.setEnabled(false);
                }
            }
            LOG.exit("update");
            return true;
        }
    }
}

