/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.GridBagAdder;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SummitBatteryEqualizationScreen
extends JPanel
implements CssConstants,
CssErrorCodes,
DeviceErrorCodes {
    private final String BATEQ_LABEL_UNKNOWN = "Equalization State is Unknown";
    private final String BATEQ_LABEL_ON = "Equalization is On";
    private final String BATEQ_LABEL_OFF = "Equalization is Off";
    private final String BATEQ_LABEL_COMPLETED = "Equalization is Completed";
    private final String BATEQ_LABEL_ABORTED = "Equalization is Aborted";
    private final String BATEQ_LABEL_FAILED = "Equalization is Failed";
    private final String BATEQ_BTN_ON = "Turn Equalization Off";
    private final String BATEQ_BTN_OFF = "Turn Equalization On";
    private final String BAT_TYPE_DEFAULT = "Battery Type: N/A";
    private final String BAT_TYPE_ERROR = "Battery Type: Error!";
    private final String BAT_TYPE_1 = "Battery Type: None";
    private final String BAT_TYPE_5 = "Battery Type: C&D TEL SERIES AGM VRLA";
    private final String BAT_TYPE_6 = "Battery Type: C&D MPS SERIES Gel VRLA";
    private final String BAT_TYPE_7 = "Battery Type: Exide Marathon AGM VRLA";
    private final String BAT_TYPE_8 = "Battery Type: Exide PowerFit AGM VRLA";
    private final String BAT_TYPE_9 = "Battery Type: Exide Sprinter AGM VRLA";
    private final String BAT_TYPE_10 = "Battery Type: Exide DryFit A400 Gel VRLA";
    private final String BAT_TYPE_11 = "Battery Type: Exide DryFit A500 Gel VRLA";
    private final String BAT_TYPE_12 = "Battery Type: Exide DryFit A600 Gel VRLA";
    private final String BAT_TYPE_13 = "Battery Type: Exide DryFit A700 Gel VRLA";
    private final String BAT_TYPE_14 = "Battery Type: Exide Classic Flooded Lead-Antimony";
    private final String BAT_TYPE_15 = "Battery Type: Exide Classic Flooded Lead-Calcium";
    private final String BAT_TYPE_16 = "Battery Type: Other AGM VRLA";
    private final String BAT_TYPE_17 = "Battery Type: Other Gel VRLA";
    private final String BAT_TYPE_18 = "Battery Type: Other Flooded";
    private final String BAT_TYPE_19 = "Battery Type: Saft Ni-Cd";
    private final String BAT_TYPE_20 = "Battery Type: Alcad Ni-Cd";
    private final String BAT_TYPE_21 = "Battery Type: Other Ni-Cd";
    private final String INIT_FAILED_MSG = "Unable to Get Initialization Values\nPerforming This Alignment Will Not Be Permitted";
    private final String c_note1 = "When battery equalization is turned ON, the connected device\n";
    private final String c_note2 = "will equalize the battery for a specific period of time, which\n";
    private final String c_note3 = "depends on the battery type, and then it will turn equalization OFF.\n";
    private final String c_note4 = "Once equalization is turned ON, the CSS can be disconnected from\n";
    private final String c_note5 = "the device.\n";
    private final String c_note6 = "The user is also given the ability to turn OFF equalization before\n";
    private final String c_note7 = "equalization has been completed for a particular type of battery\n";
    private final String c_note8 = "See on-line help for specific battery equalization times.\n";
    public JButton m_batteryBtn;
    private JTextArea m_batteryEquValueTArea;
    private JLabel m_equalStatusLbl;
    private JLabel m_batteryTypeLbl;
    private UIInternalFrame m_window;
    private JComponent m_tabParent = null;
    private JTextArea m_initFailureTextArea;
    private boolean m_isBatteryTypeAndStateGood = true;
    private boolean m_isBatteryTypeRight = false;
    private SummitAlignmentScreen m_screenHandle = null;
    private static final String FILE = "SummitBatteryEqualization";

    public SummitBatteryEqualizationScreen(SummitAlignmentScreen summitAlignmentScreen) {
        Audit.audit((int)1009, (String)FILE, (String)"Enter QuantarBatteryEqualizationScreen");
        this.m_screenHandle = summitAlignmentScreen;
        Audit.audit((int)1010, (String)FILE, (String)"Exit QuantarBatteryEqualizationScreen");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener, JComponent jComponent) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter buildScreeng_window " + uIInternalFrame + "g_statusBarListener " + statusBarListener));
        this.m_window = uIInternalFrame;
        this.m_tabParent = jComponent;
        this.setLayout(new GridBagLayout());
        this.m_batteryEquValueTArea = new JTextArea();
        this.m_batteryEquValueTArea.setSize(360, 300);
        this.m_batteryEquValueTArea.append("When battery equalization is turned ON, the connected device\n");
        this.m_batteryEquValueTArea.append("will equalize the battery for a specific period of time, which\n");
        this.m_batteryEquValueTArea.append("depends on the battery type, and then it will turn equalization OFF.\n");
        this.m_batteryEquValueTArea.append("\n");
        this.m_batteryEquValueTArea.append("Once equalization is turned ON, the CSS can be disconnected from\n");
        this.m_batteryEquValueTArea.append("the device.\n");
        this.m_batteryEquValueTArea.append("\n");
        this.m_batteryEquValueTArea.append("The user is also given the ability to turn OFF equalization before\n");
        this.m_batteryEquValueTArea.append("equalization has been completed for a particular type of battery\n");
        this.m_batteryEquValueTArea.append("\n");
        this.m_batteryEquValueTArea.append("See on-line help for specific battery equalization times.\n");
        this.m_batteryEquValueTArea.setEditable(false);
        this.m_batteryEquValueTArea.setBackground(this.getBackground());
        this.m_batteryEquValueTArea.setDisabledTextColor(this.m_batteryEquValueTArea.getForeground());
        this.m_batteryEquValueTArea.setEnabled(false);
        GridBagAdder.add((Container)this, (Component)this.m_batteryEquValueTArea, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        this.m_batteryTypeLbl = new JLabel();
        GridBagAdder.add((Container)this, (Component)this.m_batteryTypeLbl, (int)1, (int)4, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        this.m_equalStatusLbl = new JLabel();
        GridBagAdder.add((Container)this, (Component)this.m_equalStatusLbl, (int)1, (int)6, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        this.m_batteryBtn = new JButton();
        this.m_batteryBtn.setRequestFocusEnabled(true);
        this.m_batteryBtn.setToolTipText("Turn the Battery Equalizer ON or OFF");
        GridBagAdder.add((Container)this, (Component)this.m_batteryBtn, (int)1, (int)8, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)3, (int)10, (int)3, (int)0);
        this.initialize();
        statusBarListener.registerComponent((Component)this.m_batteryBtn, "Click to turn Equalization ON or OFF");
        Audit.audit((int)1009, (String)FILE, (String)"Exit buildScreen");
    }

    public void initialize() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter initialize");
        this.m_batteryTypeLbl.setText("Battery Type: N/A");
        this.m_equalStatusLbl.setText("Equalization is Off");
        this.m_batteryBtn.setText("Turn Equalization On");
        this.m_isBatteryTypeRight = false;
        if (!this.m_isBatteryTypeAndStateGood) {
            this.m_isBatteryTypeAndStateGood = true;
            this.remove(this.m_initFailureTextArea);
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit initialize");
    }

    public void disableGuiControl() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter disableGuiControl");
        this.m_batteryBtn.setEnabled(false);
        Audit.audit((int)1009, (String)FILE, (String)"Enter disableGuiControl");
    }

    private void updateInitFailureMessage() {
        if (this.m_isBatteryTypeAndStateGood && !this.isAncestorOf(this.m_initFailureTextArea)) {
            this.m_isBatteryTypeAndStateGood = false;
            this.disableGuiControl();
            this.m_initFailureTextArea = new JTextArea();
            this.m_initFailureTextArea.setEditable(false);
            this.m_initFailureTextArea.setEnabled(false);
            this.m_initFailureTextArea.setText("Unable to Get Initialization Values\nPerforming This Alignment Will Not Be Permitted");
            this.m_initFailureTextArea.setFont(new Font("Arial", 1, 12));
            this.m_initFailureTextArea.setBackground(this.getBackground());
            this.m_initFailureTextArea.setDisabledTextColor(new Color(128, 0, 64));
            GridBagAdder.add((Container)this, (Component)this.m_initFailureTextArea, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)10, (int)0, (int)10, (int)3, (int)1, (int)3, (int)0);
        }
    }

    public void getBatteryEqualizationState(int n, Integer n2) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter getBatteryEqualizationState g_error " + n + "g_state " + n2));
        this.m_window.unlockWindow();
        if (n == 0 && n2 != null) {
            if (n2 == 0) {
                this.m_batteryBtn.setText("Turn Equalization On");
                this.m_equalStatusLbl.setText("Equalization is Off");
            } else if (n2 == 1) {
                this.m_batteryBtn.setText("Turn Equalization Off");
                this.m_equalStatusLbl.setText("Equalization is On");
            } else if (n2 == 2) {
                this.m_batteryBtn.setText("Turn Equalization On");
                this.m_equalStatusLbl.setText("Equalization is Completed");
            } else if (n2 == 3) {
                this.m_batteryBtn.setText("Turn Equalization On");
                this.m_equalStatusLbl.setText("Equalization is Aborted");
            } else if (n2 == 4) {
                this.m_batteryBtn.setText("Turn Equalization On");
                this.m_equalStatusLbl.setText("Equalization is Failed");
            } else {
                Audit.audit((int)1002, (String)FILE, (String)"unable to update battery equalization");
                this.m_equalStatusLbl.setText("Equalization State is Unknown");
                this.updateInitFailureMessage();
            }
            if (n2 >= 0 && n2 <= 4) {
                this.m_batteryBtn.setEnabled(true);
            }
        } else {
            Audit.audit((int)1002, (String)FILE, (String)"unable to update battery equalization");
            this.m_equalStatusLbl.setText("Equalization State is Unknown");
            this.updateInitFailureMessage();
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateBatteryEqualization");
    }

    public boolean isBatteryEqualizationOn() {
        boolean bl = true;
        Audit.audit((int)1009, (String)FILE, (String)"Enter isBatteryEqualizationOn");
        if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization On")) {
            bl = false;
        }
        Audit.audit((int)1010, (String)FILE, (String)("Exit isBatteryEqualizationOn state " + bl));
        return bl;
    }

    public void updateSetBatteryEqualization(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter updateSetBatteryEqualization g_error " + n));
        this.m_window.unlockWindow();
        if (n == 0) {
            if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization On")) {
                this.m_batteryBtn.setText("Turn Equalization Off");
                this.m_equalStatusLbl.setText("Equalization is On");
            } else if (this.m_batteryBtn.getText().equalsIgnoreCase("Turn Equalization Off")) {
                this.m_batteryBtn.setText("Turn Equalization On");
                this.m_equalStatusLbl.setText("Equalization is Off");
            }
        } else {
            Audit.audit((int)1002, (String)FILE, (String)"unable to update battery equalization");
            this.m_screenHandle.popupError("battery_equalization_failed");
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateSetBatteryEqualization");
    }

    public void updateBatteryType(int n, Integer[] integerArray) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter updateBatteryType g_error " + n + "g_batteryType " + integerArray));
        if (n == 0) {
            if (integerArray[0] == 1) {
                this.m_batteryBtn.setEnabled(false);
                this.m_batteryTypeLbl.setText("Battery Type: None");
            } else if (integerArray[0] >= 5 && integerArray[0] <= 21) {
                this.m_isBatteryTypeRight = true;
                switch (integerArray[0]) {
                    case 5: {
                        this.m_batteryTypeLbl.setText("Battery Type: C&D TEL SERIES AGM VRLA");
                        break;
                    }
                    case 6: {
                        this.m_batteryTypeLbl.setText("Battery Type: C&D MPS SERIES Gel VRLA");
                        break;
                    }
                    case 7: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide Marathon AGM VRLA");
                        break;
                    }
                    case 8: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide PowerFit AGM VRLA");
                        break;
                    }
                    case 9: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide Sprinter AGM VRLA");
                        break;
                    }
                    case 10: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide DryFit A400 Gel VRLA");
                        break;
                    }
                    case 11: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide DryFit A500 Gel VRLA");
                        break;
                    }
                    case 12: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide DryFit A600 Gel VRLA");
                        break;
                    }
                    case 13: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide DryFit A700 Gel VRLA");
                        break;
                    }
                    case 14: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide Classic Flooded Lead-Antimony");
                        break;
                    }
                    case 15: {
                        this.m_batteryTypeLbl.setText("Battery Type: Exide Classic Flooded Lead-Calcium");
                        break;
                    }
                    case 16: {
                        this.m_batteryTypeLbl.setText("Battery Type: Other AGM VRLA");
                        break;
                    }
                    case 17: {
                        this.m_batteryTypeLbl.setText("Battery Type: Other Gel VRLA");
                        break;
                    }
                    case 18: {
                        this.m_batteryTypeLbl.setText("Battery Type: Other Flooded");
                        break;
                    }
                    case 19: {
                        this.m_batteryTypeLbl.setText("Battery Type: Saft Ni-Cd");
                        break;
                    }
                    case 20: {
                        this.m_batteryTypeLbl.setText("Battery Type: Alcad Ni-Cd");
                        break;
                    }
                    case 21: {
                        this.m_batteryTypeLbl.setText("Battery Type: Other Ni-Cd");
                    }
                }
            } else {
                this.updateInitFailureMessage();
                this.m_batteryTypeLbl.setText("Battery Type: Error!");
            }
        } else {
            this.updateInitFailureMessage();
            this.m_batteryTypeLbl.setText("Battery Type: Error!");
        }
        this.m_tabParent.grabFocus();
        Audit.audit((int)1010, (String)FILE, (String)"Exit updateBatteryType");
    }

    public boolean isBatteryTypeRight() {
        if (!this.m_isBatteryTypeRight) {
            this.m_window.unlockWindow();
        }
        return this.m_isBatteryTypeRight;
    }
}

