/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.testandmeasurement;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.GridBagAdder;
import css.core.util.Logger;
import css.core.util.TimeDialog;
import css.core.util.component.CssJTabbedPane;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.Popup;
import css.core.util.timesuspender.Ticker;
import css.core.util.timesuspender.TickerFactory;
import css.core.util.timesuspender.TimeSuspendedJLabel;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.util.TestClosable;
import css.device.common.util.TestClosingHandler;
import css.device.platform.common.screens.testandmeasurement.BrFanHoldoverPanel;
import css.device.platform.common.tables.BrCommonTranslationInfoRules;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.EngineUtilities;
import pnm.util.path.PathConstants;

public class SummitTestMeasurement
extends GenericScreen
implements BrCommonTranslationInfoRules,
TimeDialog.PostAction,
TestClosable {
    private static final long serialVersionUID = 1L;
    private final int V_52_4_QAM = 7;
    private final int V_52_16_QAM = 8;
    private final int V_52_64_QAM = 9;
    private final int V_52_16_QAM_CALIBRATION = 10;
    private final int HPD_GENERIC_TEST_PATTERN = 3;
    private final int BER_V_52_4_QAM = 1;
    private final int BER_V_52_16_QAM = 2;
    private final int BER_V_52_64_QAM = 3;
    private final int NOT_AVAILABLE = 255;
    private static final String RX_WINDOW_NAME = "Receiver Test";
    private static final String RX_PROGRESS_STRING = null;
    private static final String RX_OPERATION_TIMEOUT = "Receiver Test time out occured.";
    private static final int RX_TEST_TIMEOUT = 20;
    final int RX_TEST_SUCCESS = 1;
    final int RX_TEST_FAILED = 2;
    final int RX_TEST_INV_MODE = 2;
    final int RX_TEST_INV_FAIL = 3;
    final int RX_TEST_INV_INH = 4;
    final int RX_TEST_INV_UNK = 5;
    private final String SERVICE_MODE_MESSAGE = "Note: When service and measurements are completed, return the station to Normal Mode.";
    private final String NORMAL_MODE_MESSAGE = "Note: The station must be set to Service Mode to transmit Tx test patterns or perform Rx tests.";
    private final String c_serviceModeBtnLblStr = "Change to Service Mode";
    private final String c_normalModeBtnLblStr = "Change to Normal Mode";
    private final String c_startPatternTxLbl = "Start Pattern Transmission";
    private final String c_stopPatternTxLbl = "Stop Pattern Transmission";
    private final String PATTERN_TRANSMITTER_STATUS_MSG = "Choose one of the patterns from the given choices.";
    private final String START_PATTERN_TRANSMITTER_STATUS_MSG = "Click the button to start the pattern transmission.";
    private final String STOP_PATTERN_TRANSMITTER_STATUS_MSG = "Click the button to stop the pattern transmission.";
    private final String START_PATTERN_TRANSMITTER_TOOL_TIP = "Start the pattern transmission.";
    private final String STOP_PATTERN_TRANSMITTER_TOOL_TIP = "Stop the pattern transmission.";
    private final String c_startBerMeasurementBtnLbl = "Start BER Measurement";
    private final String c_stopBerMeasurementBtnLbl = "Stop BER Measurement";
    private final String START_BER_TOOL_TIP = "Start BER Measurement.";
    private final String STOP_BER_TOOL_TIP = "Stop BER Measuremen.";
    private final String START_BER_STATUS_MSG = "Click the button to start BER reporting.";
    private final String STOP_BER_STATUS_MSG = "Click the button to stop BER reporting.";
    private final String c_startRssiBtnLbl = "Start RSSI Measurement";
    private final String c_stopRssiBtnLbl = "Stop RSSI Measurement";
    private final String START_RSSI_STATUS_MSG = "Click the button to start RSSI reporting.";
    private final String STOP_RSSI_STATUS_MSG = "Click the button to stop RSSI reporting.";
    private final String START_RSSI_TOOL_TIP = "Starts RSSI reporting.";
    private final String STOP_RSSI_TOOL_TIP = "Stop RSSI reporting.";
    final String c_startRxTestBtnLbl = "Start Receiver Test";
    final String c_startRxTestBtnStatus = "Click the button to start Receiver Test.";
    final String c_startRxTestBtnTooltip = "Starts Receiver Test";
    private boolean m_isRxTestRunning = false;
    private TimeDialog m_cTimeDialog = null;
    private final String c_startLogBtnLbl = "Start Log";
    private final String c_stopLogBtnLbl = "Stop Log";
    private final String START_LOG_STATUS_MSG = "Click the button to start the storing of event logs.";
    private final String STOP_LOG_STATUS_MSG = "Click the button to stop the storing of event logs.";
    private final String START_LOG_TOOL_TIP = "Starts the storing of event logs.";
    private final String STOP_LOG_TOOL_TIP = "Stops the storing of event logs.";
    private final String SAMPLING_PERIOD_STATUS_MSG = "Click and select length of time between report updates.";
    private static final String INVALID = "Invalid";
    private static final int RSSI_FREQUENCY_ERROR_NA = 65535;
    public JButton m_modeBtn;
    private static final ErrorPopup m_errorPopup = new ErrorPopup();
    private static final ConfirmationPopup m_cPopup = new ConfirmationPopup();
    private JLabel m_bitErrorRateValueLbl;
    private JLabel m_receivedFreqErrorValueLbl;
    private JLabel m_receivedSignalValueLbl;
    private JLabel m_receivedSignalValueLbl2;
    private JLabel m_receivedSignalValueLbl3;
    private JLabel m_receivedFreqValueLbl;
    private JLabel m_transmitFreqValueLbl;
    private JLabel m_modeMessageLbl;
    private int m_currentMode = 0;
    private Logger m_log = null;
    private JComboBox m_patternTypeCbBox;
    private JComboBox m_berPatternTypeCbBox;
    private JComboBox m_samplePeriodCbBox;
    public JButton m_berMeasurementBtn;
    public JButton m_rssiMeasurementBtn;
    public JButton m_startRxTestBtn;
    public JButton m_patternTransmissionBtn;
    public JButton m_logBtn;
    private JLabel c_bitErrorRateLbl;
    private JLabel c_patternTypeLbl;
    private JLabel c_berPatternTypeLbl;
    private JLabel c_samplingPeriodLbl;
    private JLabel c_receivedFreqErrorLbl;
    private JLabel c_receivedSignalLbl;
    private JLabel c_receivedSignalLbl1;
    private JLabel c_receivedSignalLbl2;
    private JLabel c_receivedSignalLbl3;
    private JLabel c_transmitFreqLbl;
    private JLabel c_receivedFreqLbl;
    private JPanel configPanel;
    private JPanel patternSettingsPanel;
    private JPanel berPanel;
    private JPanel resultsPanel;
    private JPanel saveLogPanel;
    private String[] c_patternTypeSelection = new String[]{"V.52, 4 QAM", "V.52, 16 QAM", "V.52, 64 QAM", "V.52, 16 QAM Calibration Test"};
    private String[] c_samplingPeriodSelection = new String[]{"1", "10", "100"};
    private String[] c_berPatternTypeSelection = new String[]{"HPD generic test pattern", "V.52, 4 QAM", "V.52, 16 QAM", "V.52, 64 QAM", "Not Available"};
    private SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
    boolean m_normalMode = true;
    boolean m_modeChange = false;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitTestMeasurement.class);
    private StatusBarListener m_statusBarListener;
    private TestClosingHandler m_oTestClosingHandler = new TestClosingHandler("Test Pattern is Running. Do You wish To Continue?");
    CssJTabbedPane m_testMeasurementTab;
    public BrFanHoldoverPanel m_fanHoldoverPanel;

    public SummitTestMeasurement() {
        LOG.enter("SummitTestMeasurement");
        ButtonActionEvent buttonActionEvent = new ButtonActionEvent();
        this.m_logBtn = new JButton();
        this.m_logBtn.addActionListener(buttonActionEvent);
        LOG.exit("SummitTestMeasurement");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        this.MENU_ITEM_NAME = "Test And Measurement Screen";
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_statusBarListener = statusBarListener;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        this.m_fanHoldoverPanel = new BrFanHoldoverPanel(this);
        this.m_fanHoldoverPanel.buildScreen(this.m_window, statusBarListener);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.m_testMeasurementTab = new CssJTabbedPane();
        this.m_testMeasurementTab.addTab("Test and Measurement", (Component)jPanel);
        this.m_testMeasurementTab.addTab("Fan Holdover", (Component)this.m_fanHoldoverPanel);
        this.add((Component)this.m_testMeasurementTab, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.configPanel = new JPanel();
        this.configPanel.setLayout(new GridBagLayout());
        this.configPanel.setBorder(BorderFactory.createEtchedBorder());
        this.configPanel.setMaximumSize(new Dimension(550, 40));
        this.configPanel.setMinimumSize(new Dimension(550, 40));
        this.configPanel.setPreferredSize(new Dimension(550, 40));
        this.c_transmitFreqLbl = new JLabel("Transmit Frequency (MHz)");
        this.c_transmitFreqLbl.setMaximumSize(new Dimension(150, 17));
        this.c_transmitFreqLbl.setMinimumSize(new Dimension(150, 17));
        this.c_transmitFreqLbl.setPreferredSize(new Dimension(150, 17));
        this.m_transmitFreqValueLbl = new JLabel();
        this.m_transmitFreqValueLbl.setMaximumSize(new Dimension(100, 17));
        this.m_transmitFreqValueLbl.setMinimumSize(new Dimension(100, 17));
        this.m_transmitFreqValueLbl.setPreferredSize(new Dimension(100, 17));
        this.c_receivedFreqLbl = new JLabel("Receiver Frequency (MHz)");
        this.c_receivedFreqLbl.setMaximumSize(new Dimension(150, 17));
        this.c_receivedFreqLbl.setMinimumSize(new Dimension(150, 17));
        this.c_receivedFreqLbl.setPreferredSize(new Dimension(150, 17));
        this.m_receivedFreqValueLbl = new JLabel();
        this.m_receivedFreqValueLbl.setMaximumSize(new Dimension(100, 17));
        this.m_receivedFreqValueLbl.setMinimumSize(new Dimension(100, 17));
        this.m_receivedFreqValueLbl.setPreferredSize(new Dimension(100, 17));
        GridBagAdder.add((Container)this.configPanel, (Component)this.m_receivedFreqValueLbl, (int)2, (int)2, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)0, (int)0, (int)90, (int)1, (int)30, (int)0);
        this.configPanel.add((Component)this.m_transmitFreqValueLbl, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.configPanel.add((Component)this.m_receivedFreqValueLbl, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.configPanel.add((Component)this.c_transmitFreqLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 50), 0, 0));
        this.configPanel.add((Component)this.c_receivedFreqLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 50), 0, 0));
        jPanel.add((Component)this.configPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.patternSettingsPanel = new JPanel();
        this.patternSettingsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.patternSettingsPanel.setMaximumSize(new Dimension(550, 40));
        this.patternSettingsPanel.setMinimumSize(new Dimension(550, 40));
        this.patternSettingsPanel.setPreferredSize(new Dimension(550, 40));
        this.patternSettingsPanel.setLayout(new GridBagLayout());
        this.c_patternTypeLbl = new JLabel("Select Pattern to Transmit");
        this.c_patternTypeLbl.setPreferredSize(new Dimension(142, 17));
        this.c_patternTypeLbl.setMaximumSize(new Dimension(142, 17));
        this.c_patternTypeLbl.setMinimumSize(new Dimension(142, 17));
        this.m_patternTypeCbBox = new JComboBox<String>(this.c_patternTypeSelection);
        this.m_patternTypeCbBox.setMaximumSize(new Dimension(165, 21));
        this.m_patternTypeCbBox.setMinimumSize(new Dimension(165, 21));
        this.m_patternTypeCbBox.setPreferredSize(new Dimension(165, 21));
        this.m_patternTransmissionBtn = new JButton();
        this.m_patternTransmissionBtn.setMaximumSize(new Dimension(184, 27));
        this.m_patternTransmissionBtn.setMinimumSize(new Dimension(184, 27));
        this.m_patternTransmissionBtn.setPreferredSize(new Dimension(184, 27));
        jPanel.add((Component)this.patternSettingsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.patternSettingsPanel.add((Component)this.m_patternTypeCbBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.patternSettingsPanel.add((Component)this.c_patternTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 15), 0, 0));
        this.patternSettingsPanel.add((Component)this.m_patternTransmissionBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.berPanel = new JPanel();
        this.berPanel.setBorder(BorderFactory.createEtchedBorder());
        this.berPanel.setMaximumSize(new Dimension(550, 110));
        this.berPanel.setMinimumSize(new Dimension(550, 110));
        this.berPanel.setPreferredSize(new Dimension(550, 110));
        this.berPanel.setLayout(new GridBagLayout());
        this.c_berPatternTypeLbl = new JLabel("BER Rx Pattern Type");
        this.c_berPatternTypeLbl.setMaximumSize(new Dimension(142, 17));
        this.c_berPatternTypeLbl.setMinimumSize(new Dimension(142, 17));
        this.c_berPatternTypeLbl.setPreferredSize(new Dimension(142, 17));
        this.m_berPatternTypeCbBox = new JComboBox<String>(this.c_berPatternTypeSelection);
        this.m_berPatternTypeCbBox.setMaximumSize(new Dimension(165, 21));
        this.m_berPatternTypeCbBox.setMinimumSize(new Dimension(165, 21));
        this.m_berPatternTypeCbBox.setPreferredSize(new Dimension(165, 21));
        this.c_samplingPeriodLbl = new JLabel("Sampling Period (sec)");
        this.m_samplePeriodCbBox = new JComboBox<String>(this.c_samplingPeriodSelection);
        this.m_samplePeriodCbBox.setMaximumSize(new Dimension(80, 21));
        this.m_samplePeriodCbBox.setMinimumSize(new Dimension(80, 21));
        this.m_samplePeriodCbBox.setPreferredSize(new Dimension(80, 21));
        this.m_berMeasurementBtn = new JButton();
        this.m_berMeasurementBtn.setMaximumSize(new Dimension(184, 27));
        this.m_berMeasurementBtn.setMinimumSize(new Dimension(184, 27));
        this.m_berMeasurementBtn.setPreferredSize(new Dimension(184, 27));
        this.m_rssiMeasurementBtn = new JButton();
        this.m_rssiMeasurementBtn.setMaximumSize(new Dimension(184, 27));
        this.m_rssiMeasurementBtn.setMinimumSize(new Dimension(184, 27));
        this.m_rssiMeasurementBtn.setPreferredSize(new Dimension(184, 27));
        this.m_startRxTestBtn = new JButton();
        this.m_startRxTestBtn.setMaximumSize(new Dimension(184, 27));
        this.m_startRxTestBtn.setMinimumSize(new Dimension(184, 27));
        this.m_startRxTestBtn.setPreferredSize(new Dimension(184, 27));
        jPanel.add((Component)this.berPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.berPanel.add((Component)this.c_berPatternTypeLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 15), 0, 0));
        this.berPanel.add((Component)this.m_berMeasurementBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 5), 0, 0));
        this.berPanel.add((Component)this.m_berPatternTypeCbBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.berPanel.add((Component)this.c_samplingPeriodLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 15), 0, 0));
        this.berPanel.add((Component)this.m_samplePeriodCbBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.berPanel.add((Component)this.m_rssiMeasurementBtn, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.berPanel.add((Component)this.m_startRxTestBtn, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 5), 0, 0));
        this.resultsPanel = new JPanel();
        this.resultsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.resultsPanel.setMaximumSize(new Dimension(550, 100));
        this.resultsPanel.setMinimumSize(new Dimension(550, 100));
        this.resultsPanel.setPreferredSize(new Dimension(550, 100));
        Ticker ticker = TickerFactory.getServiceTicker();
        this.resultsPanel.setLayout(new GridBagLayout());
        this.c_bitErrorRateLbl = new JLabel("Bit Error Rate (%)");
        this.c_bitErrorRateLbl.setMaximumSize(new Dimension(220, 17));
        this.c_bitErrorRateLbl.setMinimumSize(new Dimension(220, 17));
        this.c_bitErrorRateLbl.setPreferredSize(new Dimension(220, 17));
        this.m_bitErrorRateValueLbl = new TimeSuspendedJLabel(ticker);
        this.m_bitErrorRateValueLbl.setMaximumSize(new Dimension(55, 17));
        this.m_bitErrorRateValueLbl.setMinimumSize(new Dimension(55, 17));
        this.m_bitErrorRateValueLbl.setPreferredSize(new Dimension(55, 17));
        this.c_receivedFreqErrorLbl = new JLabel("Received Frequency Error (Hz)");
        this.c_receivedFreqErrorLbl.setMaximumSize(new Dimension(220, 17));
        this.c_receivedFreqErrorLbl.setMinimumSize(new Dimension(220, 17));
        this.c_receivedFreqErrorLbl.setPreferredSize(new Dimension(220, 17));
        this.m_receivedFreqErrorValueLbl = new TimeSuspendedJLabel(ticker);
        this.m_receivedFreqErrorValueLbl.setMinimumSize(new Dimension(55, 17));
        this.m_receivedFreqErrorValueLbl.setPreferredSize(new Dimension(55, 17));
        this.c_receivedSignalLbl = new JLabel("Received Signal Strength (dBm)");
        this.c_receivedSignalLbl.setMaximumSize(new Dimension(220, 17));
        this.c_receivedSignalLbl.setMinimumSize(new Dimension(220, 17));
        this.c_receivedSignalLbl.setPreferredSize(new Dimension(220, 17));
        this.c_receivedSignalLbl1 = new JLabel("Branch 1");
        this.c_receivedSignalLbl.setMaximumSize(new Dimension(185, 17));
        this.c_receivedSignalLbl.setMinimumSize(new Dimension(185, 17));
        this.c_receivedSignalLbl.setPreferredSize(new Dimension(185, 17));
        this.c_receivedSignalLbl2 = new JLabel("Branch 2");
        this.c_receivedSignalLbl2.setMaximumSize(new Dimension(55, 17));
        this.c_receivedSignalLbl2.setMinimumSize(new Dimension(55, 17));
        this.c_receivedSignalLbl2.setPreferredSize(new Dimension(55, 17));
        this.c_receivedSignalLbl3 = new JLabel("Branch 3");
        this.c_receivedSignalLbl3.setMaximumSize(new Dimension(55, 17));
        this.c_receivedSignalLbl3.setMinimumSize(new Dimension(55, 17));
        this.c_receivedSignalLbl3.setPreferredSize(new Dimension(55, 17));
        this.m_receivedSignalValueLbl = new TimeSuspendedJLabel(ticker);
        this.m_receivedSignalValueLbl.setMaximumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl.setMinimumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl.setPreferredSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl2 = new TimeSuspendedJLabel(ticker);
        this.m_receivedSignalValueLbl2.setMaximumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl2.setMinimumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl2.setPreferredSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl3 = new TimeSuspendedJLabel(ticker);
        this.m_receivedSignalValueLbl3.setMaximumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl3.setMinimumSize(new Dimension(80, 17));
        this.m_receivedSignalValueLbl3.setPreferredSize(new Dimension(80, 17));
        jPanel.add((Component)this.resultsPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.resultsPanel.add((Component)this.m_bitErrorRateValueLbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.resultsPanel.add((Component)this.m_receivedFreqErrorValueLbl, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.resultsPanel.add((Component)this.c_receivedSignalLbl1, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.resultsPanel.add((Component)this.m_receivedSignalValueLbl, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.resultsPanel.add((Component)this.c_receivedSignalLbl2, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.resultsPanel.add((Component)this.c_receivedSignalLbl3, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.resultsPanel.add((Component)this.m_receivedSignalValueLbl3, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.resultsPanel.add((Component)this.m_receivedSignalValueLbl2, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.resultsPanel.add((Component)this.c_bitErrorRateLbl, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 47), 0, 0));
        this.resultsPanel.add((Component)this.c_receivedFreqErrorLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 5, 47), 0, 0));
        this.resultsPanel.add((Component)this.c_receivedSignalLbl, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 47), 0, 0));
        this.saveLogPanel = new JPanel();
        this.saveLogPanel.setLayout(new GridBagLayout());
        this.saveLogPanel.setMaximumSize(new Dimension(550, 115));
        this.saveLogPanel.setMinimumSize(new Dimension(550, 115));
        this.saveLogPanel.setPreferredSize(new Dimension(550, 115));
        this.m_modeMessageLbl = new JLabel("Note: The station must be set to Service Mode to transmit Tx test patterns or perform Rx tests.");
        this.m_modeBtn = new JButton("Change to Normal Mode");
        jPanel.add((Component)this.saveLogPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.saveLogPanel.add((Component)this.m_logBtn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 15, 0), 0, 0));
        this.saveLogPanel.add((Component)this.m_modeMessageLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.saveLogPanel.add((Component)this.m_modeBtn, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
        statusBarListener.registerComponent((Component)this.m_patternTypeCbBox, "Choose one of the patterns from the given choices.");
        statusBarListener.registerComponent((Component)this.m_patternTransmissionBtn, "Click the button to start the pattern transmission.");
        statusBarListener.registerComponent((Component)this.m_berMeasurementBtn, "Click the button to start BER reporting.");
        statusBarListener.registerComponent((Component)this.m_rssiMeasurementBtn, "Click the button to start RSSI reporting.");
        statusBarListener.registerComponent((Component)this.m_samplePeriodCbBox, "Click and select length of time between report updates.");
        statusBarListener.registerComponent((Component)this.m_logBtn, "Click the button to start the storing of event logs.");
        statusBarListener.registerComponent((Component)this.m_modeBtn, "Click this button to change the station's mode");
        statusBarListener.registerComponent((Component)this.m_startRxTestBtn, "Click the button to start Receiver Test.");
        this.initialize();
        this.m_testMeasurementTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (SummitTestMeasurement.this.m_testMeasurementTab.getSelectedComponent() instanceof BrFanHoldoverPanel) {
                    SummitTestMeasurement.this.startFanHoldoverInitRules();
                }
                LOG.exit("stateChanged");
            }
        });
        LOG.exit("buildScreen");
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.c_transmitFreqLbl.setToolTipText("Transmit frequency value.");
        this.c_receivedFreqLbl.setToolTipText("Frequency to which the receiver is tuned");
        this.c_patternTypeLbl.setToolTipText("Select a pattern to be transmitted");
        this.m_patternTransmissionBtn.setText("Start Pattern Transmission");
        this.m_patternTransmissionBtn.setToolTipText("Start the pattern transmission.");
        this.m_berPatternTypeCbBox.setEnabled(false);
        this.c_berPatternTypeLbl.setToolTipText("BER Rx Pattern types.");
        this.c_samplingPeriodLbl.setToolTipText("Length of time between report updates.");
        this.m_berMeasurementBtn.setText("Start BER Measurement");
        this.m_berMeasurementBtn.setToolTipText("Start BER Measurement.");
        this.m_rssiMeasurementBtn.setText("Start RSSI Measurement");
        this.m_rssiMeasurementBtn.setToolTipText("Starts RSSI reporting.");
        this.m_receivedFreqErrorValueLbl.setText("N/A");
        this.m_bitErrorRateValueLbl.setText("N/A");
        this.m_transmitFreqValueLbl.setText("N/A");
        this.m_receivedFreqValueLbl.setText("N/A");
        this.m_receivedSignalValueLbl.setText("N/A");
        this.m_receivedSignalValueLbl2.setText("N/A");
        this.m_receivedSignalValueLbl3.setText("N/A");
        this.c_bitErrorRateLbl.setToolTipText("Measured value of bit error rate");
        this.c_receivedSignalLbl.setToolTipText("Measured value of received signal strength level");
        this.c_receivedFreqErrorLbl.setToolTipText("Measured value of received frequency error");
        this.m_logBtn.setText("Start Log");
        this.m_logBtn.setToolTipText("Starts the storing of event logs.");
        this.m_modeBtn.setToolTipText("Switches the Station between Normal and Service Modes");
        this.m_startRxTestBtn.setText("Start Receiver Test");
        this.m_startRxTestBtn.setToolTipText("Starts Receiver Test");
        this.m_oTestClosingHandler.reset();
        ScreenManager.registerPrecloseOperation(this.m_oTestClosingHandler);
        LOG.exit("initialize");
    }

    public void realTimeUpdate(Object object) {
        String string = null;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        LOG.enter("realTimeUpdate", new Object[]{object});
        if (realTimeDataObject != null) {
            try {
                if (realTimeDataObject.getError() != 0) {
                    int n = realTimeDataObject.getError();
                    LOG.info((Object)("There was an Error in realTimeUpdate error = " + n));
                    switch (n) {
                        case -262160: {
                            if (!this.m_modeChange) {
                                m_errorPopup.display(-262160);
                                this.close();
                            }
                            this.m_modeChange = false;
                        }
                    }
                }
                for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                    string = realTimeDataObject.getName(i);
                    if (string.equalsIgnoreCase("rssiBranchA")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateRssiValue(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("rssiBranchB")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateRssiSecondValue(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("rssiBranchC")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateRssiThirdValue(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("frequencyOffset")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateFrequecyOffset(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("initialBerMeasurement")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateBerValue(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("hpdBerPatternType")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateBerPatternType(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("ErrorMessage")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.updateTestPattern(byArray);
                        continue;
                    }
                    if (string.equalsIgnoreCase("ReceiverTestRealTimeResponse")) {
                        byArray = (byte[])realTimeDataObject.getValue(string);
                        this.receiverTestRealTimeResponse(byArray);
                        continue;
                    }
                    if (!string.equalsIgnoreCase("ReceiverTestErrorRealTimeMessage")) continue;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.receiverTestErrorRealTimeResponse(byArray);
                }
            }
            catch (NotFoundException notFoundException) {
                LOG.info((Object)"Object not found", (Throwable)notFoundException);
            }
        } else {
            LOG.info((Object)"The Real Time Data Object Was null ");
        }
        LOG.exit("realTimeUpdate");
    }

    public Object[] startSession() {
        Object[] objectArray = new Object[3];
        LOG.enter("startSession");
        objectArray[0] = new Byte(0);
        objectArray[1] = new Byte(0);
        objectArray[2] = BrCommonMeasurementRules;
        LOG.exit("startSession", objectArray);
        return objectArray;
    }

    public void handleStartSession(int n) {
        LOG.enter("handleStartSession", new Object[]{Integer.toString(n)});
        if (n != 0) {
            m_errorPopup.display("unable_to_start_session");
            this.close();
        }
        LOG.exit("handleStartSession");
    }

    public void updateMode(int n, int n2) {
        LOG.enter("updateMode", new Object[]{Integer.toString(n), Integer.toString(n2)});
        if (n == 0) {
            if (n2 == 5) {
                this.updateServiceMode(n);
            } else if (n2 == 2) {
                this.updateNormalMode(n);
            } else {
                PnmDialog.error((Object)this.m_window, (String)"device_is_in_unknown_mode");
                this.closeScreen(true);
            }
        } else {
            PnmDialog.error((Object)this.m_window, (String)"unable_to_get_mode");
            this.closeScreen(true);
        }
        LOG.exit("updateMode");
    }

    public void handleStopSession(int n) {
        LOG.enter("handleStopSession", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.info((Object)("Received error " + n + " while trying to close session"));
        }
        LOG.exit("handleStopSession");
    }

    public boolean userRequest() {
        boolean bl = false;
        LOG.enter("userRequest");
        m_cPopup.display(-327683);
        if (m_cPopup.getStatus()) {
            this.m_modeChange = true;
            bl = true;
        }
        LOG.exit("userRequest", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isScreenInNormalMode() {
        boolean bl = false;
        LOG.enter("isScreenInNormalMode");
        if (this.m_modeChange) {
            bl = this.m_modeBtn.getText().equalsIgnoreCase("Change to Service Mode");
        }
        LOG.exit("isScreenInNormalMode", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isScreenInServiceMode() {
        boolean bl = false;
        LOG.enter("isScreenInServiceMode");
        if (this.m_modeChange) {
            bl = this.m_modeBtn.getText().equalsIgnoreCase("Change to Normal Mode");
        }
        LOG.exit("isScreenInServiceMode", (Object)Boolean.toString(bl));
        return bl;
    }

    public void updateServiceMode(int n) {
        LOG.enter("updateServiceMode", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.m_normalMode = false;
            this.m_modeBtn.setText("Change to Normal Mode");
            this.m_modeMessageLbl.setText("Note: When service and measurements are completed, return the station to Normal Mode.");
            this.updateGuiToServiceMode();
            if (this.m_modeChange) {
                this.m_modeChange = false;
                ScreenManager.suspend();
            }
        } else {
            this.m_modeChange = false;
            if (n == -393271) {
                m_errorPopup.display(-327840);
            } else {
                m_errorPopup.display(-327857);
            }
        }
        LOG.exit("updateServiceMode");
    }

    private void updateGuiToServiceMode() {
        LOG.enter("updateGuiToServiceMode");
        this.m_window.unlockWindow();
        if (this.isPatternsRunning()) {
            this.patternStartedUpdate();
        } else {
            this.patternStopUpdate();
        }
        this.m_samplePeriodCbBox.setEnabled(true);
        this.m_bitErrorRateValueLbl.setEnabled(true);
        this.m_rssiMeasurementBtn.setEnabled(true);
        this.m_rssiMeasurementBtn.setText("Start RSSI Measurement");
        this.m_startRxTestBtn.setEnabled(true);
        this.m_currentMode = 1;
        LOG.exit("updateGuiToServiceMode");
    }

    public void updateNormalMode(int n) {
        LOG.enter("updateNormalMode", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.m_normalMode = true;
            this.m_modeBtn.setText("Change to Service Mode");
            this.m_modeMessageLbl.setText("Note: The station must be set to Service Mode to transmit Tx test patterns or perform Rx tests.");
            this.updateGuiToNormalMode();
            if (this.m_modeChange) {
                this.m_modeChange = false;
                ScreenManager.suspend();
            }
        } else {
            this.m_modeChange = false;
            if (n == -393271) {
                m_errorPopup.display(-327840);
            } else {
                m_errorPopup.display(-327857);
            }
        }
        LOG.exit("updateNormalMode");
    }

    private void updateGuiToNormalMode() {
        LOG.enter("updateGuiToNormalMode");
        this.m_window.unlockWindow();
        this.m_patternTypeCbBox.setEnabled(false);
        this.m_patternTransmissionBtn.setEnabled(false);
        this.m_samplePeriodCbBox.setEnabled(true);
        this.m_bitErrorRateValueLbl.setEnabled(false);
        this.m_berMeasurementBtn.setEnabled(false);
        this.m_rssiMeasurementBtn.setEnabled(true);
        this.m_rssiMeasurementBtn.setText("Start RSSI Measurement");
        this.m_berMeasurementBtn.setText("Start BER Measurement");
        this.m_startRxTestBtn.setEnabled(false);
        this.m_currentMode = 0;
        LOG.exit("updateGuiToNormalMode");
    }

    public void updatePatternSelection(int n, int n2) {
        LOG.enter("updatePatternSelection", new Object[]{Integer.toString(n), Integer.toString(n2)});
        if (n == 0) {
            if (n2 == 0) {
                this.patternStopUpdate();
            }
            if (n2 > 0 && n2 < 11) {
                LOG.info((Object)"Pattern Running Between 1 & 11");
                switch (n2) {
                    case 7: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 8: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 9: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 10: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    default: {
                        LOG.info((Object)"Pattern test not supported");
                        m_errorPopup.display(-327845);
                        break;
                    }
                }
            }
        } else {
            LOG.info((Object)"Invalid pattern Number return from box");
        }
        LOG.exit("updatePatternSelection");
    }

    public void startPattern(int n, int n2) {
        LOG.enter("startPattern", new Object[]{Integer.toString(n), Integer.toString(n2)});
        this.m_window.unlockWindow();
        if (n == 0) {
            if (n2 == 0 && this.m_currentMode == 1) {
                this.patternStopUpdate();
            }
            if (n2 > 0 && n2 < 11) {
                LOG.info((Object)"Pattern Running Between 1 & 11");
                switch (n2) {
                    case 7: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 8: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 9: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    case 10: {
                        this.m_patternTypeCbBox.setSelectedIndex(n2 - 7);
                        this.patternStartedUpdate();
                        break;
                    }
                    default: {
                        LOG.info((Object)"Pattern test not supported");
                        m_errorPopup.display(-327845);
                        break;
                    }
                }
            }
        } else if (n == -393271) {
            m_errorPopup.display(-327846);
        } else {
            m_errorPopup.display(-327847);
        }
        LOG.exit("startPattern");
    }

    public void stopRunningPattern(int n) {
        LOG.enter("stopRunningPattern", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.patternStopUpdate();
        } else if (n == -393271) {
            m_errorPopup.display(-327846);
        } else {
            m_errorPopup.display(-327849);
        }
        LOG.exit("stopRunningPattern");
    }

    private void patternStartedUpdate() {
        LOG.enter("patternStartedUpdate");
        this.m_patternTypeCbBox.setEnabled(false);
        this.m_patternTransmissionBtn.setText("Stop Pattern Transmission");
        this.m_patternTransmissionBtn.setToolTipText("Stop the pattern transmission.");
        this.m_statusBarListener.updateComponent((Component)this.m_patternTransmissionBtn, "Click the button to stop the pattern transmission.");
        this.m_berMeasurementBtn.setEnabled(true);
        this.m_berMeasurementBtn.setText("Start BER Measurement");
        this.m_berMeasurementBtn.setToolTipText("Start BER Measurement.");
        this.m_statusBarListener.updateComponent((Component)this.m_berMeasurementBtn, "Click the button to start BER reporting.");
        this.m_startRxTestBtn.setEnabled(false);
        LOG.exit("patternStartedUpdate");
    }

    private void patternStopUpdate() {
        LOG.enter("patternStopUpdate");
        this.m_patternTransmissionBtn.setText("Start Pattern Transmission");
        this.m_patternTransmissionBtn.setToolTipText("Start the pattern transmission.");
        this.m_statusBarListener.updateComponent((Component)this.m_patternTransmissionBtn, "Click the button to start the pattern transmission.");
        this.m_berMeasurementBtn.setEnabled(false);
        this.m_berMeasurementBtn.setText("Start BER Measurement");
        this.m_berMeasurementBtn.setToolTipText("Start BER Measurement.");
        if (this.m_currentMode == 1) {
            this.m_patternTypeCbBox.setEnabled(true);
            this.m_patternTypeCbBox.setSelectedIndex(0);
            this.m_patternTransmissionBtn.setEnabled(true);
            this.m_startRxTestBtn.setEnabled(true);
        }
        LOG.exit("patternStopUpdate");
    }

    public void updateTxFreq(int n, Integer[] integerArray) {
        LOG.enter("updateTxFreq", new Object[]{Integer.toString(n), integerArray});
        if (n == 0) {
            try {
                int n2 = integerArray[0];
                double d = (double)n2 / 1000000.0;
                this.m_transmitFreqValueLbl.setText(String.valueOf(d));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info((Object)"Floating point conversion Exception in method updateTxFreq", (Throwable)numberFormatException);
                this.m_transmitFreqValueLbl.setText("Error!");
            }
        } else {
            LOG.info((Object)"value error");
            this.m_transmitFreqValueLbl.setText("Error!");
        }
        this.m_window.setCursor(new Cursor(0));
        LOG.exit("updateTxFreq");
    }

    public void updateRxFreq(int n, Integer[] integerArray) {
        LOG.enter("updateRxFreq", new Object[]{Integer.toString(n), integerArray});
        if (n == 0) {
            try {
                int n2 = integerArray[0];
                double d = (double)n2 / 1000000.0;
                this.m_receivedFreqValueLbl.setText(String.valueOf(d));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.info((Object)"Floating point conversion Exception in method updateRxFreq", (Throwable)numberFormatException);
                this.m_receivedFreqValueLbl.setText("Error!");
            }
        } else {
            LOG.info((Object)("Got Error g_error = " + n));
            this.m_receivedFreqValueLbl.setText("Error!");
        }
        LOG.exit("updateRxFreq");
    }

    public boolean isPatternsRunning() {
        boolean bl = true;
        LOG.enter("isPatternsRunning");
        bl = this.m_patternTransmissionBtn.getText().equals("Stop Pattern Transmission");
        LOG.exit("isPatternsRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public Object[] getNeededRssiMeasurementInfo() {
        Object[] objectArray = new Object[]{null};
        LOG.enter("getNeededRssiMeasurementInfo");
        try {
            int n = Integer.parseInt((String)this.m_samplePeriodCbBox.getSelectedItem());
            if (n >= -2147483 && n <= 2147483) {
                n *= 1000;
            } else {
                LOG.error((Object)"Error: Integer overflow");
            }
            objectArray[0] = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.info((Object)"Error converting number.", (Throwable)numberFormatException);
        }
        LOG.exit("getNeededRssiMeasurementInfo", objectArray);
        return objectArray;
    }

    public void startRssiUpdate(int n) {
        LOG.enter("startRssiUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_rssiMeasurementBtn.setText("Stop RSSI Measurement");
            this.m_rssiMeasurementBtn.setToolTipText("Stop RSSI reporting.");
            this.m_statusBarListener.updateComponent((Component)this.m_rssiMeasurementBtn, "Click the button to stop RSSI reporting.");
            this.m_samplePeriodCbBox.setEnabled(false);
            this.m_berMeasurementBtn.setEnabled(false);
            this.m_bitErrorRateValueLbl.setText("N/A");
            this.m_startRxTestBtn.setEnabled(false);
            this.writeToLogFile("\n------------ RSSI Test Started ------------\n");
            this.writeToLogFile("\n Sampling Period Selection  :" + this.m_samplePeriodCbBox.getSelectedItem());
            this.writeToLogFile("\n Receiver Frequency Error (Hz)   :" + this.m_receivedFreqErrorValueLbl.getText());
            this.writeToLogFile("\n ---------- RSSI Real Time Data -----------\n");
        } else if (n == -393271) {
            m_errorPopup.display(-393271);
        } else {
            m_errorPopup.display(-327841);
        }
        LOG.exit("startRssiUpdate");
    }

    public void stopRssiUpdate(int n) {
        LOG.enter("stopRssiUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_rssiMeasurementBtn.setText("Start RSSI Measurement");
            this.m_rssiMeasurementBtn.setToolTipText("Starts RSSI reporting.");
            this.m_statusBarListener.updateComponent((Component)this.m_rssiMeasurementBtn, "Click the button to start RSSI reporting.");
            this.m_samplePeriodCbBox.setEnabled(true);
            if (this.m_currentMode == 1) {
                if (this.isPatternsRunning()) {
                    this.m_berMeasurementBtn.setEnabled(true);
                } else {
                    this.m_startRxTestBtn.setEnabled(true);
                }
            }
            this.writeToLogFile("\n ------------  RSSI Test Stopped -------------\n");
        } else if (n == -393271) {
            m_errorPopup.display(-393271);
        } else {
            m_errorPopup.display(-327842);
        }
        LOG.exit("stopRssiUpdate");
    }

    public boolean isRssiTestRunning() {
        boolean bl = true;
        LOG.enter("isRssiTestRunning");
        bl = this.m_rssiMeasurementBtn.getText().equals("Stop RSSI Measurement");
        LOG.exit("isRssiTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isBerTestRunning() {
        boolean bl = true;
        LOG.enter("isBerTestRunning");
        bl = this.m_berMeasurementBtn.getText().equals("Stop BER Measurement");
        LOG.exit("isBerTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public Object[] getNeededBerMeasurementInfo() {
        Object[] objectArray = new Object[]{null, null};
        LOG.enter("getNeededBerMeasurementInfo");
        this.m_window.lockWindow();
        try {
            int n = Integer.parseInt((String)this.m_samplePeriodCbBox.getSelectedItem());
            if (n >= -2147483 && n <= 2147483) {
                n *= 1000;
            } else {
                LOG.error((Object)"Error: Integer overflow");
            }
            objectArray[0] = this.getSelectedPatternType();
            objectArray[1] = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.info((Object)"Error converting number.", (Throwable)numberFormatException);
        }
        LOG.exit("getNeededBerMeasurementInfo", objectArray);
        return objectArray;
    }

    public void startBerUpdate(int n) {
        LOG.enter("startBerUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_berMeasurementBtn.setText("Stop BER Measurement");
            this.m_berMeasurementBtn.setToolTipText("Stop BER Measuremen.");
            this.m_statusBarListener.updateComponent((Component)this.m_berMeasurementBtn, "Click the button to stop BER reporting.");
            this.m_samplePeriodCbBox.setEnabled(false);
            this.m_rssiMeasurementBtn.setEnabled(false);
            this.m_patternTransmissionBtn.setEnabled(false);
            this.m_startRxTestBtn.setEnabled(false);
            this.writeToLogFile("\n ------------- BER Test Started ---------------\n");
            this.writeToLogFile("\n Sampling Period Selection  :" + this.m_samplePeriodCbBox.getSelectedItem());
            this.writeToLogFile("\n Receiver Frequency Error (Hz)   :" + this.m_receivedFreqErrorValueLbl.getText());
        } else if (n == -393271) {
            m_errorPopup.display(-393271);
        } else {
            m_errorPopup.display(-327843);
        }
        LOG.exit("startBerUpdate");
    }

    private Integer getSelectedPatternType() {
        LOG.enter("getSelectedPatternType");
        int n = 1;
        Object object = null;
        String string = null;
        object = this.m_berPatternTypeCbBox.getSelectedItem();
        string = object.toString();
        if (string.equals("HPD generic test pattern")) {
            n = 3;
        } else if (string.equals("V.52, 4 QAM")) {
            n = 1;
        } else if (string.equals("V.52, 16 QAM")) {
            n = 2;
        } else if (string.equals("V.52, 64 QAM")) {
            n = 3;
        } else if (string.equals("V.52, Calibration Test Pattern")) {
            n = 255;
        }
        LOG.exit("getSelectedPatternType", (Object)Integer.toString(n));
        return new Integer(n);
    }

    public Object[] getTransmitPatternSelection() {
        Object[] objectArray = new Object[1];
        LOG.enter("getTransmitPatternSelection");
        this.m_window.lockWindow();
        int n = this.m_patternTypeCbBox.getSelectedIndex();
        objectArray[0] = new Integer(n + 7);
        LOG.exit("getTransmitPatternSelection", objectArray);
        return objectArray;
    }

    public void stopBerUpdate(int n) {
        LOG.enter("stopBerUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_berMeasurementBtn.setText("Start BER Measurement");
            this.m_berMeasurementBtn.setToolTipText("Start BER Measurement.");
            this.m_statusBarListener.updateComponent((Component)this.m_berMeasurementBtn, "Click the button to start BER reporting.");
            this.m_samplePeriodCbBox.setEnabled(true);
            this.m_rssiMeasurementBtn.setEnabled(true);
            this.m_patternTransmissionBtn.setEnabled(true);
            if (!this.isPatternsRunning()) {
                this.m_startRxTestBtn.setEnabled(true);
            }
            this.m_berPatternTypeCbBox.setSelectedIndex(0);
            this.writeToLogFile("\n -------------  BER Test Stopped ------------\n");
        } else if (n == -393271) {
            m_errorPopup.display(-393271);
        } else {
            m_errorPopup.display(-327844);
        }
        LOG.exit("stopBerUpdate");
    }

    private void updateBerValue(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateBerValue", new Object[]{byArray});
        float f = (float)n / 1000.0f;
        this.m_bitErrorRateValueLbl.setText(String.valueOf(f));
        Date date = new Date();
        String string = this.m_formatter.format(date);
        this.writeToLogFile("\n" + string + " " + this.c_bitErrorRateLbl.getText() + ":\t" + this.m_bitErrorRateValueLbl.getText());
        LOG.exit("updateBerValue");
    }

    private void updateFrequecyOffset(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateFrequecyOffset", new Object[]{byArray});
        this.m_receivedFreqErrorValueLbl.setText(65535 == (n -= 6000) ? INVALID : String.valueOf(n));
        Date date = new Date();
        String string = this.m_formatter.format(date);
        this.writeToLogFile("\n" + string + " " + this.c_receivedFreqErrorLbl.getText() + ":\t" + this.m_receivedFreqErrorValueLbl.getText());
        LOG.exit("updateFrequecyOffset");
    }

    private void updateRssiValue(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateRssiValue", new Object[]{byArray});
        float f = (float)n / -100.0f;
        this.m_receivedSignalValueLbl.setText(65535 == n ? INVALID : String.valueOf(f));
        Date date = new Date();
        String string = this.m_formatter.format(date);
        this.writeToLogFile("\n" + string + " " + this.c_receivedSignalLbl.getText() + " " + this.c_receivedSignalLbl1.getText() + ":\t" + this.m_receivedSignalValueLbl.getText());
        LOG.exit("updateRssiValue");
    }

    private void updateRssiSecondValue(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateRssiSecondValue", new Object[]{byArray});
        float f = (float)n / -100.0f;
        this.m_receivedSignalValueLbl2.setText(65535 == n ? INVALID : String.valueOf(f));
        Date date = new Date();
        String string = this.m_formatter.format(date);
        this.writeToLogFile("\n" + string + " " + this.c_receivedSignalLbl.getText() + " " + this.c_receivedSignalLbl2.getText() + ":\t" + this.m_receivedSignalValueLbl2.getText());
        LOG.exit("updateRssiSecondValue");
    }

    private void updateRssiThirdValue(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateRssiThirdValue", new Object[]{byArray});
        float f = (float)n / -100.0f;
        this.m_receivedSignalValueLbl3.setText(65535 == n ? INVALID : String.valueOf(f));
        Date date = new Date();
        String string = this.m_formatter.format(date);
        this.writeToLogFile("\n" + string + " " + this.c_receivedSignalLbl.getText() + " " + " " + this.c_receivedSignalLbl3.getText() + " " + ":\t" + this.m_receivedSignalValueLbl3.getText());
        LOG.exit("updateRssiThirdValue");
    }

    private void updateTestPattern(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateTestPattern", new Object[]{byArray});
        switch (n) {
            case 1: {
                m_errorPopup.display(-327850);
                break;
            }
            case 2: {
                m_errorPopup.display(-327851);
                break;
            }
            case 3: {
                m_errorPopup.display(-327852);
                break;
            }
            case 4: {
                m_errorPopup.display(-327853);
            }
        }
        this.m_patternTransmissionBtn.setText("Start Pattern Transmission");
        this.m_patternTypeCbBox.setEnabled(true);
        LOG.exit("updateTestPattern");
    }

    private void updateBerPatternType(byte[] byArray) {
        int n = Convert.toInteger((byte[])byArray);
        LOG.enter("updateBerPatternType", new Object[]{byArray});
        switch (n) {
            case 1: {
                this.m_berPatternTypeCbBox.setSelectedIndex(1);
                this.writeToLogFile("\n BER Pattern Type              :V.52, 4 QAM");
                break;
            }
            case 2: {
                this.m_berPatternTypeCbBox.setSelectedIndex(2);
                this.writeToLogFile("\n BER Pattern Type              : V.52, 16 QAM");
                break;
            }
            case 3: {
                this.m_berPatternTypeCbBox.setSelectedIndex(3);
                this.writeToLogFile("\n BER Pattern Type              :V.52, 64 QAM");
                break;
            }
            case 255: {
                this.m_berPatternTypeCbBox.setSelectedIndex(4);
                this.writeToLogFile("\n BER Pattern Type              :Not Available");
            }
        }
        LOG.exit("updateBerPatternType");
    }

    public void doNothing(int n) {
        LOG.enter("doNothing", new Object[]{Integer.toString(n)});
        LOG.exit("doNothing");
    }

    private void writeBerParams() {
        LOG.enter("writeBerParams");
        this.writeToLogFile("\n----------  BER Test Started -----------\n");
        if (this.getSelectedPatternType() == 3) {
            this.writeToLogFile("\n BER Rx Pattern Type:" + this.m_berPatternTypeCbBox.getSelectedItem());
        } else if (this.getSelectedPatternType() == 1) {
            this.writeToLogFile("\n BER Rx Pattern Type:" + this.m_berPatternTypeCbBox.getSelectedItem());
        } else if (this.getSelectedPatternType() == 2) {
            this.writeToLogFile("\n BER Rx Pattern Type:" + this.m_berPatternTypeCbBox.getSelectedItem());
        } else if (this.getSelectedPatternType() == 3) {
            this.writeToLogFile("\n BER Rx Pattern Type:" + this.m_berPatternTypeCbBox.getSelectedItem());
        } else if (this.getSelectedPatternType() == 255) {
            this.writeToLogFile("\n BER Rx Pattern Type:" + this.m_berPatternTypeCbBox.getSelectedItem());
        }
        this.writeToLogFile("\n Sampling Period Selection:" + this.m_samplePeriodCbBox.getSelectedItem());
        this.writeToLogFile("\n\n-------------  BER Data ----------------\n");
        LOG.exit("writeBerParams");
    }

    private void writeRssiParams() {
        LOG.enter("writeRssiParams");
        this.writeToLogFile("\n----------  RSSI Test Started -----------\n");
        this.writeToLogFile("\n Sampling Period Selection:" + this.m_samplePeriodCbBox.getSelectedItem());
        this.writeToLogFile("\n-------------  RSSI Data ----------------\n");
        LOG.exit("writeRssiParams");
    }

    private void logToFile() {
        File file = null;
        LOG.enter("logToFile");
        if ("Start Log".equals(this.m_logBtn.getText())) {
            JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
            int n = jFileChooser.showSaveDialog((Component)this.m_window);
            if (n == 0 && CSSUtilities.isValidLogFile((File)(file = jFileChooser.getSelectedFile()), (ErrorPopup)m_errorPopup)) {
                try {
                    this.m_log = new Logger(file);
                    Date date = new Date();
                    String string = this.m_formatter.format(date);
                    this.m_log.write("START LOG TIME : " + string + "\n");
                    this.m_log.flush();
                    this.m_logBtn.setText("Stop Log");
                    this.m_logBtn.setToolTipText("Stops the storing of event logs.");
                    this.m_statusBarListener.updateComponent((Component)this.m_logBtn, "Click the button to stop the storing of event logs.");
                    this.startWriteToFile();
                }
                catch (IOException iOException) {
                    LOG.info((Object)"Unable to write to log file.", (Throwable)iOException);
                    m_errorPopup.display(-327859);
                }
                catch (Exception exception) {
                    LOG.info((Object)"Unable to create log file.", (Throwable)exception);
                    m_errorPopup.display(-327860);
                }
            }
        } else {
            try {
                this.closeLogFile();
            }
            catch (Exception exception) {
                LOG.info((Object)"Unable to close log file.", (Throwable)exception);
            }
        }
        LOG.exit("logToFile");
    }

    private void startWriteToFile() {
        LOG.enter("startWriteToFile");
        this.writeToLogFile("BIT ERROR RATE AND RECEIVED SIGNAL STRENGTH LOG\n");
        this.writeToLogFile("-----------------------------------------------------\n");
        if (this.isBerTestRunning()) {
            this.writeBerParams();
        } else if (this.isRssiTestRunning()) {
            this.writeRssiParams();
        }
        LOG.exit("startWriteToFile");
    }

    private void writeToLogFile(String string) {
        LOG.enter("writeToLogFile", new Object[]{string});
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                this.m_log.write(string);
            }
            catch (IOException iOException) {
                LOG.info((Object)"Could not write to file.", (Throwable)iOException);
                m_errorPopup.display(-327859);
                this.m_logBtn.setText("Start Log");
                this.m_logBtn.setToolTipText("Starts the storing of event logs.");
                this.m_statusBarListener.updateComponent((Component)this.m_logBtn, "Click the button to start the storing of event logs.");
            }
        }
        LOG.exit("writeToLogFile");
    }

    public boolean isLogFileClosed() {
        boolean bl = true;
        LOG.enter("isLogFileClosed");
        if (this.m_log != null) {
            bl = !this.m_log.isLogEnabled();
        }
        LOG.exit("isLogFileClosed", (Object)Boolean.toString(bl));
        return bl;
    }

    public void closeLogFile() {
        LOG.enter("closeLogFile");
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                Date date = new Date();
                String string = this.m_formatter.format(date);
                this.m_log.write("\n=======================================================\n");
                this.m_log.write("STOP LOG TIME :  " + string + "\n");
                this.m_log.close();
            }
            catch (IOException iOException) {
                m_errorPopup.display(-327859);
                LOG.info((Object)"Could not close file.", (Throwable)iOException);
            }
            this.m_logBtn.setText("Start Log");
            this.m_logBtn.setToolTipText("Starts the storing of event logs.");
            this.m_statusBarListener.updateComponent((Component)this.m_logBtn, "Click the button to start the storing of event logs.");
        }
        LOG.exit("closeLogFile");
    }

    private void enableTestButtons() {
        LOG.enter("enableTestButtons");
        this.m_patternTransmissionBtn.setEnabled(true);
        this.m_berMeasurementBtn.setEnabled(false);
        this.m_rssiMeasurementBtn.setEnabled(true);
        this.m_startRxTestBtn.setEnabled(true);
        this.m_logBtn.setEnabled(true);
        this.m_window.unlockWindow();
        this.m_window.setClosable(true);
        LOG.exit("enableTestButtons");
    }

    public boolean isRxTestRunning() {
        LOG.enter("isRxTestRunning");
        LOG.exit("isRxTestRunning", (Object)Boolean.toString(this.m_isRxTestRunning));
        return this.m_isRxTestRunning;
    }

    public boolean isRxTestNotRunning() {
        LOG.enter("isRxTestNotRunning");
        LOG.exit("isRxTestNotRunning", (Object)Boolean.toString(this.m_isRxTestRunning));
        return !this.m_isRxTestRunning;
    }

    public void setRxTestRunning() {
        LOG.enter("setRxTestRunning");
        this.m_patternTransmissionBtn.setEnabled(false);
        this.m_berMeasurementBtn.setEnabled(false);
        this.m_rssiMeasurementBtn.setEnabled(false);
        this.m_startRxTestBtn.setEnabled(false);
        this.m_logBtn.setEnabled(false);
        if (null != this.m_cTimeDialog) {
            this.m_cTimeDialog.setVisible(false);
            this.m_cTimeDialog = null;
        }
        TimeDialog.WindowSettings windowSettings = new TimeDialog.WindowSettings();
        windowSettings.m_sProgressIndicator = RX_PROGRESS_STRING;
        windowSettings.m_nCounter = 20;
        windowSettings.m_sWindowName = RX_WINDOW_NAME;
        windowSettings.m_sOperationName = Popup.getMessageString((int)-630405);
        windowSettings.m_sOperationSummary = RX_OPERATION_TIMEOUT;
        this.m_cTimeDialog = new TimeDialog((Frame)EngineUtilities.getMainApplicationWindow(), windowSettings);
        this.m_cTimeDialog.setPostActionPerformer((TimeDialog.PostAction)this);
        this.m_cTimeDialog.start();
        this.m_window.setClosable(false);
        this.m_window.lockWindow();
        this.m_isRxTestRunning = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SummitTestMeasurement.this.m_cTimeDialog.setVisible(true);
            }
        });
        LOG.exit("setRxTestRunning");
    }

    public void receiverTestResponse(int n) {
        LOG.enter("receiverTestResponse", new Object[]{Integer.toBinaryString(n)});
        LOG.exit("receiverTestResponse");
    }

    public void receiverTestRealTimeResponse(byte[] byArray) {
        LOG.enter("receiverTestRealTimeResponse", new Object[]{byArray});
        if (null != this.m_cTimeDialog) {
            try {
                int n = Convert.toInteger((byte[])byArray);
                switch (n) {
                    case 1: {
                        LOG.info((Object)"receiverTestRealTimeResponse got response Passed");
                        this.m_cTimeDialog.stop(-630400, 1);
                        break;
                    }
                    case 2: {
                        LOG.info((Object)"receiverTestRealTimeResponse got response Failed");
                        this.m_cTimeDialog.stop(-630406, 0);
                        break;
                    }
                    default: {
                        LOG.info((Object)"receiverTestRealTimeResponse got response Unknown Error");
                        this.m_cTimeDialog.stop(-630404, 0);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LOG.info((Object)"receiverTestRealTimeResponse numeric exception was thrown:", (Throwable)exception);
                this.m_cTimeDialog.stop(-630404, 0);
            }
        } else {
            LOG.info((Object)"receiverTestRealTimeResponse() m_cTimeDialog is null");
        }
        LOG.exit("receiverTestRealTimeResponse");
    }

    public void receiverTestErrorRealTimeResponse(byte[] byArray) {
        LOG.enter("receiverTestErrorRealTimeResponse", new Object[]{byArray});
        if (null != this.m_cTimeDialog) {
            try {
                int n = Convert.toInteger((byte[])byArray);
                switch (n) {
                    case 2: {
                        LOG.info((Object)"receiverTestErrorRealTimeResponse got response Rx Invalid Mode");
                        this.m_cTimeDialog.stop(-630401, 0);
                        break;
                    }
                    case 3: {
                        LOG.info((Object)"receiverTestErrorRealTimeResponse got response Rx Failure");
                        this.m_cTimeDialog.stop(-630402, 0);
                        break;
                    }
                    case 4: {
                        LOG.info((Object)"receiverTestErrorRealTimeResponse got response Rx Inhibited");
                        this.m_cTimeDialog.stop(-630403, 0);
                        break;
                    }
                    default: {
                        LOG.info((Object)"receiverTestErrorRealTimeResponse got response Unknown Error");
                        this.m_cTimeDialog.stop(-630404, 0);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LOG.info((Object)"receiverTestErrorRealTimeResponse numeric exception was thrown:", (Throwable)exception);
                this.m_cTimeDialog.stop(-630404, 0);
            }
        } else {
            LOG.info((Object)"receiverTestErrorRealTimeResponse() m_cTimeDialog is null");
        }
        LOG.exit("receiverTestErrorRealTimeResponse");
    }

    public void PerformPostAction() {
        LOG.enter("PerformPostAction");
        this.enableTestButtons();
        this.m_isRxTestRunning = false;
        LOG.exit("PerformPostAction");
    }

    public boolean canCloseScreen() {
        LOG.enter("canCloseScreen");
        boolean bl = this.m_oTestClosingHandler.isTestRunning(this);
        LOG.exit("canCloseScreen", (Object)Boolean.toString(bl));
        return bl;
    }

    @Override
    public boolean isTestRunning() {
        LOG.enter("isTestRunning");
        boolean bl = this.isPatternsRunning();
        LOG.exit("isTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean startFanHoldoverInitRules() {
        LOG.enter("startFanHoldoverInitRules");
        boolean bl = true;
        this.m_fanHoldoverPanel.m_oGenericListener.notifyGuiListener();
        LOG.exit("startFanHoldoverInitRules", (Object)bl);
        return bl;
    }

    class ButtonActionEvent
    implements ActionListener {
        ButtonActionEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SummitTestMeasurement.this.m_logBtn) {
                SummitTestMeasurement.this.logToFile();
            }
        }
    }
}

