/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.screens.ScreenInterface;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceMaker;
import css.device.common.util.DeviceConstants;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Cursor;
import java.beans.PropertyVetoException;
import javax.swing.JPanel;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;

public abstract class GenericScreen
extends JPanel
implements DeviceConstants,
DeviceErrorCodes,
CssConstants,
CssErrorCodes,
ScreenInterface {
    public String FILE = "Generic Screen";
    private static final CssLogger LOG = CssLogger.getCssLogger(GenericScreen.class);
    public String MENU_ITEM_NAME = "Screen Name";
    public GenericScreenMaker m_screenMaker = null;
    public UIInternalFrame m_window;

    @Override
    public abstract void buildScreen(Object var1, StatusBarListener var2, GenericScreenMaker var3);

    @Override
    public abstract void initialize();

    public void close() {
        ServiceMaker serviceMaker;
        LOG.enter("close");
        if (this.m_window != null && this.m_window.isVisible()) {
            this.m_window.unlockWindow();
            this.m_window.setVisible(false);
            ScreenManager.removeScreen(this);
        }
        if (null != (serviceMaker = ScreenManager.getDeviceServiceMakerHandle())) {
            serviceMaker.handleMenuItemDependencies(this.MENU_ITEM_NAME);
        }
        LOG.exit("close");
    }

    public void popupError(String string) {
        LOG.enter("popupError", new Object[]{string});
        if (this.m_window.isVisible()) {
            PnmDialog.error((Object)this.m_window, (String)string);
        }
        LOG.exit("popupError");
    }

    public void popupError(int n) {
        LOG.enter("popupError", new Object[]{Integer.toString(n)});
        if (this.m_window.isVisible()) {
            ErrorPopup errorPopup = new ErrorPopup();
            errorPopup.display(n);
        }
        LOG.exit("popupError");
    }

    public void popupInfo(String string) {
        LOG.enter("popupInfo", new Object[]{string});
        if (this.m_window.isVisible()) {
            PnmDialog.info((Object)this.m_window, (String)string);
        }
        LOG.exit("popupInfo");
    }

    @Override
    public void startScreen() {
        LOG.enter("startScreen");
        this.m_screenMaker.getGuiListener().startProcess();
        LOG.exit("startScreen");
    }

    @Override
    public void closeScreen(boolean bl) {
        LOG.enter("closeScreen", new Object[]{Boolean.toString(bl)});
        if (bl) {
            try {
                this.m_window.setClosed(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                LOG.error((Object)"closeScreen - message", (Throwable)propertyVetoException);
            }
        } else {
            this.m_window.setVisible(false);
            ServiceMaker serviceMaker = ScreenManager.getDeviceServiceMakerHandle();
            if (null != serviceMaker) {
                serviceMaker.handleMenuItemDependencies(this.MENU_ITEM_NAME);
            }
        }
        LOG.exit("closeScreen");
    }

    public void closeScreen(int n) {
        LOG.enter("closeScreen", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.warn((Object)"Unable to close screen");
            this.popupError(-70);
        }
        this.m_window.setVisible(false);
        this.m_window.setCursor(new Cursor(0));
        LOG.exit("closeScreen");
    }
}

