/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.service.DataObject;
import css.core.service.ServiceMakerIfc;
import css.core.util.CSSUtilities;
import css.core.util.ClassFinder;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.core.util.popup.PopupProperties;
import css.core.util.timesuspender.TickerFactory;
import css.device.common.service.ScreenManager;
import css.device.common.tables.CommonOidTable;
import css.device.common.util.DeviceConstants;
import java.util.Iterator;
import java.util.jar.JarFile;
import pnm.util.EngineUtilities;

public class ServiceMaker
implements CssErrorCodes,
CssConstants,
DeviceConstants,
CommonOidTable,
ServiceMakerIfc {
    private static final CssLogger LOG = CssLogger.getCssLogger(ServiceMaker.class);
    protected static String m_deviceType = "UNKNOWN";

    public int initiateService() {
        int n;
        block6: {
            LOG.enter("initiateService");
            n = -1;
            DataObject dataObject = null;
            dataObject = CSSUtilities.addOID((Object[][])COMMON_OID_TABLE, (String)"Common Service Initialization");
            if (dataObject.getError() != 0) {
                LOG.error((Object)"initiateService - Trouble adding the common OIDs to SNMP Interface");
            }
            ScreenManager.newInstance();
            try {
                String string = MetadataAcquisitionService.getServiceFilename();
                JarFile jarFile = new JarFile(string);
                ClassFinder classFinder = new ClassFinder(jarFile, "css.device");
                Iterator iterator = classFinder.findClass("ServiceMaker", 2);
                ClassLoader classLoader = EngineUtilities.getCssClassLoader();
                if (null != classLoader) {
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (string2.equals("css.device.common.service.ServiceMaker")) continue;
                        LOG.trace((Object)("initiateService - Found a match of the Class Name " + string2));
                        Class<?> clazz = classLoader.loadClass(string2);
                        Object obj = clazz.newInstance();
                        n = ((ServiceMaker)obj).initiateService();
                        if (n == 0) {
                            ScreenManager.setDeviceServiceMakerHandle((ServiceMaker)obj);
                            n = PopupProperties.addMessages((String)COMMON_SERVICE_ERROR_MESSAGES_FILE);
                        }
                        break block6;
                    }
                    break block6;
                }
                throw new ClassNotFoundException("CSS class loader was not found!!!");
            }
            catch (Exception exception) {
                LOG.error((Object)"initiateService - Exception was thrown!", (Throwable)exception);
            }
        }
        LOG.exit("initiateService", (Object)Integer.toString(n));
        return n;
    }

    public int shutdownService() {
        LOG.enter("shutdownService");
        TickerFactory.disposeServiceTicker();
        int n = CSSUtilities.deregisterServiceOids();
        LOG.exit("shutdownService", (Object)Integer.toString(n));
        return n;
    }

    public static String getDeviceType() {
        LOG.enter("getDeviceType");
        LOG.exit("getDeviceType", (Object)m_deviceType);
        return m_deviceType;
    }

    public void handleMenuItemDependencies(String string) {
        LOG.enter("handleMenuItemDependencies", new Object[]{string});
        LOG.exit("handleMenuItemDependencies");
    }
}

