/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.service.DataObject;
import css.core.service.ProtocolMultiplexer;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.tables.CssTranslationInfoRules;
import css.device.common.util.DeviceErrorCodes;

public class ServiceProtocolMultiplexer
extends ProtocolMultiplexer
implements CssErrorCodes,
CssConstants,
DeviceErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(ServiceProtocolMultiplexer.class);
    private CmdManager m_command;

    public DataObject process(DataObject dataObject) {
        LOG.enter("process", new Object[]{dataObject});
        DataObject dataObject2 = null;
        if ((long)dataObject.getProtocolKey() < 999L) {
            dataObject2 = m_ftp.doOperation(dataObject);
            if (dataObject2.getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -65536);
                } else {
                    dataObject2.setError(dataObject2.getError() + -65536);
                }
            }
        } else if ((long)dataObject.getProtocolKey() < 1999L) {
            dataObject2 = m_snmp.doOperation(dataObject);
            if (dataObject2.getError() != 0 && dataObject2.getError() > 0) {
                dataObject2.setError(-1 * dataObject2.getError());
            }
        } else if ((long)dataObject.getProtocolKey() < 19999L) {
            if (this.m_command == null) {
                this.m_command = new CmdManager(CssTranslationInfoRules.cssCommandManagerRules);
            }
            if ((dataObject2 = this.m_command.doOperation(dataObject)).getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -262144);
                } else {
                    dataObject2.setError(dataObject2.getError() + -262144);
                }
            }
        } else if ((long)dataObject.getProtocolKey() < 29999L) {
            dataObject2 = m_ascii.doOperation(dataObject);
            if (dataObject2.getError() != 0) {
                if (dataObject2.getError() > 0) {
                    dataObject2.setError(-1 * dataObject2.getError() + -131072);
                } else {
                    dataObject2.setError(dataObject2.getError() + -131072);
                }
            }
        } else {
            LOG.error((Object)("process - process: undefined protocal key " + dataObject.getProtocolKey()));
        }
        LOG.exit("process", (Object)dataObject2);
        return dataObject2;
    }

    public static ServiceProtocolMultiplexer getServiceProtocolMultiplexer() {
        LOG.enter("getServiceProtocolMultiplexer");
        LOG.exit("getServiceProtocolMultiplexer");
        return (ServiceProtocolMultiplexer)CSSUtilities.getServiceProtocolMultiplexer();
    }
}

