/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.ErrorLogUtilities;
import css.device.common.util.ErrorLogsColInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ErrorLogsDataHandler
extends DefaultHandler
implements CssConstants {
    private static final CssLogger LOG = CssLogger.getCssLogger(ErrorLogsDataHandler.class);
    public static final int RECOVERABLE_ERROR = -1;
    private static final String LOG_DELIM_ATTR = "delim";
    private static final String DEFAULT_DELIM = "|";
    private static final String COL_TAG = "Col";
    private static final String ELEMENT_TAG = "E";
    private static final String LOG_TAG = "Log";
    private static final String COL_ATTR_1 = "type";
    private static final String COL_ATTR_2 = "name";
    private static final String HEAD_TAG = "Head";
    private String DELIM;
    private static final String DOCTYPE_TAG = "!DOCTYPE";
    private static final Pattern NOT_TRANSLATED = Pattern.compile("The entity \"(\\w+)\" was referenced, but not declared\\.");
    Vector<ErrorLogsColInfo> m_errorLogsData = null;
    private boolean m_ElementHeaderTagStart = false;
    private boolean m_ElementTagStart = false;
    private StringBuffer strBuf = null;
    private StringBuffer m_strHeaderBuf = new StringBuffer();
    private Locator m_oLocator = null;
    private String m_sUndefinedEntity = null;
    Writer out;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_oLocator = locator;
    }

    public int parseErrorLogFile(String string) {
        int n = 0;
        LOG.enter("parseErrorLogFile", new Object[]{string});
        try {
            this.m_errorLogsData = new Vector();
            this.DELIM = DEFAULT_DELIM;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            File file = new File(string);
            this.m_sUndefinedEntity = null;
            sAXParser.parse(file, (DefaultHandler)this);
        }
        catch (RecoverableDtdException recoverableDtdException) {
            this.m_sUndefinedEntity = recoverableDtdException.getMessage();
            n = -1;
        }
        catch (Throwable throwable) {
            n = -2;
        }
        LOG.exit("parseErrorLogFile", (Object)n);
        return n;
    }

    public int recoverDtdFile() {
        String string;
        int n = -2;
        LOG.enter("recoverDtdFile");
        if (null != this.m_sUndefinedEntity && (string = ErrorLogUtilities.getDtdFileName()) != null) {
            try {
                FileWriter fileWriter = new FileWriter(string, true);
                fileWriter.write("<!ENTITY " + this.m_sUndefinedEntity + " \"Warning! Entry not found in DTD file: " + this.m_sUndefinedEntity + "\" >");
                fileWriter.close();
            }
            catch (Exception exception) {
                LOG.error((Object)"recoverDtdFile - Unable to recover dtd file.");
            }
            n = -100;
        }
        LOG.exit("recoverDtdFile", (Object)n);
        return n;
    }

    public Vector<ErrorLogsColInfo> getParsedTableData() {
        LOG.enter("getParsedTableData");
        LOG.exit("getParsedTableData", this.m_errorLogsData);
        return this.m_errorLogsData;
    }

    public String getDtdFileNameFromErrorLog(String string) {
        String string2 = null;
        String string3 = null;
        LOG.enter("getDtdFileNameFromErrorLog", new Object[]{string});
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf(DOCTYPE_TAG) < 0) continue;
                int n = string3.indexOf("\"");
                int n2 = string3.lastIndexOf("\"");
                string2 = string3.substring(n + 1, n2);
                break;
            }
            bufferedReader.close();
            inputStreamReader.close();
            fileInputStream.close();
        }
        catch (Exception exception) {
            LOG.error((Object)"Unable to get dtd file name.");
        }
        LOG.exit("getDtdFileNameFromErrorLog", string2);
        return string2;
    }

    public String getHeaderInfo() {
        LOG.enter("getHeaderInfo");
        String string = this.m_strHeaderBuf.toString();
        LOG.exit("getHeaderInfo", (Object)string);
        return string;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        LOG.enter("startElement", new Object[]{string, string2, string3, attributes});
        if (string3.equalsIgnoreCase(LOG_TAG)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equalsIgnoreCase(LOG_DELIM_ATTR)) continue;
                this.DELIM = attributes.getValue(i);
            }
        }
        if (string3.equalsIgnoreCase(COL_TAG)) {
            ErrorLogsColInfo errorLogsColInfo = new ErrorLogsColInfo();
            String string4 = "";
            String string5 = "";
            String string6 = "";
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string7 = attributes.getLocalName(i);
                if (string7.equalsIgnoreCase(COL_ATTR_1)) {
                    string4 = attributes.getType(i);
                    string5 = attributes.getValue(i);
                    continue;
                }
                if (!string7.equalsIgnoreCase(COL_ATTR_2)) continue;
                string6 = attributes.getValue(i);
            }
            errorLogsColInfo.setColInfo(string6, string5, string4);
            this.m_errorLogsData.addElement(errorLogsColInfo);
        } else if (string3.equalsIgnoreCase(ELEMENT_TAG)) {
            this.m_ElementTagStart = true;
            this.strBuf = new StringBuffer();
        } else if (string3.equalsIgnoreCase(HEAD_TAG)) {
            this.m_ElementHeaderTagStart = true;
        }
        LOG.exit("startElement");
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        LOG.enter("endElement", new Object[]{string, string2, string3});
        if (string3.equalsIgnoreCase(ELEMENT_TAG)) {
            this.m_ElementTagStart = false;
            int n = this.parseErrorLogsTableData();
            if (n != 0) {
                throw new SAXException("Error Parsing: Invalid Row Data, Row# " + n);
            }
        } else if (string3.equalsIgnoreCase(HEAD_TAG)) {
            this.m_ElementHeaderTagStart = false;
        }
        LOG.exit("endElement");
    }

    public int parseErrorLogsTableData() {
        int n = 0;
        LOG.enter("parseErrorLogsTableData");
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.strBuf.toString(), this.DELIM);
            for (int i = 0; i < this.m_errorLogsData.size(); ++i) {
                if (stringTokenizer.hasMoreTokens()) {
                    ErrorLogsColInfo errorLogsColInfo = this.m_errorLogsData.elementAt(i);
                    errorLogsColInfo.addColValue(stringTokenizer.nextToken());
                    continue;
                }
                LOG.error((Object)"parseErrorLogsTableData - error in storing error log data");
                n = -1;
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"parseErrorLogsTableData - generic Exception", (Throwable)exception);
            n = -1;
        }
        LOG.exit("parseErrorLogsTableData", (Object)n);
        return n;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        LOG.enter("characters", new Object[]{cArray, n, n2});
        for (int i = 0; i < n2; ++i) {
            if (this.m_ElementTagStart) {
                this.strBuf.append(cArray[n + i]);
                continue;
            }
            if (!this.m_ElementHeaderTagStart) continue;
            this.m_strHeaderBuf.append(cArray[n + i]);
        }
        LOG.exit("characters");
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        LOG.enter("error", new Object[]{sAXParseException});
        LOG.warn((Object)("error - message: " + sAXParseException.getMessage()));
        SAXParseException sAXParseException2 = sAXParseException;
        String string = sAXParseException.getMessage();
        Matcher matcher = NOT_TRANSLATED.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            sAXParseException2 = new RecoverableDtdException(string2);
        }
        LOG.exit("error", (Object)sAXParseException2);
        throw sAXParseException2;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        LOG.enter("warning", new Object[]{sAXParseException});
        LOG.error((Object)("warning - message, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "   "), (Throwable)sAXParseException);
        LOG.exit("warning");
    }

    private class RecoverableDtdException
    extends SAXParseException {
        private static final long serialVersionUID = 1L;
        private final CssLogger LOG;

        public RecoverableDtdException(String string) {
            super(string, ErrorLogsDataHandler.this.m_oLocator);
            this.LOG = CssLogger.getCssLogger(RecoverableDtdException.class);
            this.LOG.enter("RecoverableDtdException", new Object[]{string});
            this.LOG.exit("RecoverableDtdException");
        }
    }
}

