/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.DateAndTimeConversion;
import css.core.util.GridBagAdder;
import css.core.util.timesuspender.Ticker;
import css.core.util.timesuspender.TickerFactory;
import css.core.util.timesuspender.TimeSuspendedJLabel;
import css.device.common.util.DeviceErrorCodes;
import css.device.common.util.ErrorLogUtility;
import css.device.platform.common.screens.statuspanel.BrStatusPanelScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pnm.ui.UIInternalFrame;
import pnm.util.IntegerFormat;

public class BrStationStatusPanel
extends JPanel
implements CssConstants,
DeviceErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrStationStatusPanel.class);
    private static final long serialVersionUID = -1L;
    private static final String m_transmitterDisableLblStr = "Transmitter Inhibit";
    private static final String m_transmitterEnableLblStr = "Transmitter Enable";
    private static final String m_receiverEnableLblStr = "Receiver Enable";
    private static final String m_receiverDisableLblStr = "Receiver Inhibit";
    private static final String FAILED = "FAILED";
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";
    private static final String REPEATER_SET_UP = "Repeater Set Up";
    private static final String REPEATER_KNOCKDOWN = "Repeater Knockdown";
    private static final String NOT_APPLICABLE = "NOT APPLICABLE";
    private static final String IDLE = "IDLE";
    private static final String VOICE = "VOICE";
    private static final String DATA = "DATA";
    private static final String CONSOLE_PRIORITY = "Console priority";
    private static final String TSBK = "TSBK";
    private static final int TSBK_ONSCREEN_TIMEOUT = 1000;
    private static final String INHIBIT = "INHIBIT";
    private static final String N_A = "N/A";
    private static final String STATION_OPERATION_MODE = "Station Operation Mode";
    private static final String TRANSMITTER = "Transmitter";
    private static final String P2_TRANSMITTER_SLOT1 = "TA - FDMA/TDMA logical channel 0";
    private static final String P2_TRANSMITTER_SLOT2 = "TA - TDMA logical channel 1";
    private static final String TRANSMITTER_ACTIVITY = "Transmitter Activity";
    private static final String TX_NETWORK_ACCESS_CODE = "Tx Network Access Code (hex)";
    private static final String TX_COLOR_CODE = "Tx Color Code (hex)";
    private static final String STATION_USAGE = "Station Usage";
    private static final String RECEIVER = "Receiver";
    private static final String RECEIVER_ACTIVITY = "Receiver Activity";
    private static final String P2_RECEIVER_SLOT1 = "RA - FDMA/TDMA logical channel 0";
    private static final String P2_RECEIVER_SLOT2 = "RA - TDMA logical channel 1";
    private static final String RX_NETWORK_ACCESS_CODE = "Rx Network Access Code (hex)";
    private static final String RX_COLOR_CODE = "Rx Color Code (hex)";
    private static final String STATION_TIME = "Station Time";
    private static final String STATION_DATE = "Station Date";
    private ErrorLogUtility m_errorLogUtility = new ErrorLogUtility();
    private static final String CONVENTIONAL = "CONVENTIONAL";
    private static final int TRANSMITTER_FIELD = 0;
    private static final int TA_FDMA_TDMA_SLOT_1 = 1;
    private static final int TA_TDMA_SLOT_2 = 2;
    private static final int RECEIVER_FIELD = 0;
    private static final int RA_FDMA_TDMA_SLOT_1 = 1;
    private static final int RA_TDMA_SLOT_2 = 2;
    private static final int F2_TDMA = 1;
    private static final int P2_TDMA = 2;
    private static final HashMap<Integer, String> STATIONOPERATIONALMODE = new HashMap();
    private static final HashMap<Integer, String> TRANSMITTEROPERATIONALSTATE;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT1MSBR;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR;
    private static final HashMap<Integer, String> TRANSMITTERACTIVITYSLOT2;
    private static final HashMap<Integer, String> STATIONUSAGE;
    private static final HashMap<Integer, String> RECEIVERACTIVITYSLOT1;
    private static final HashMap<Integer, String> RECEIVERACTIVITYSLOT2;
    private static final HashMap<Integer, String> RECEIVEROPERATIONALSTATE;
    private static final int STATIONUSAGEVOICETDMA = 8;
    private static final HashMap<Integer, String> REPEATERSTATE;
    private static final HashMap<Integer, String> REPEATERACTIVITYSTATE;
    private static final int ACTIVITY_IDLE = 0;
    private static int m_nTdmaMode;
    private static final int REPEATER_ACTIVITY_TSBK = 4;
    private static final int RECEIVER_ACTIVITY_TSBK = 9;
    private static final int TRANSMITTER_ACTIVITY_TSBK = 12;
    private long nLastRepeaterActivitySetTime = 0L;
    private long nLastReceiverActivitySetTime = 0L;
    private long nLastTransmitterActivitySetTime = 0L;
    private UIInternalFrame m_window;
    private JLabel m_stationOperationModeLbl;
    private JLabel m_txNetworkAccessCodeLbl;
    private JLabel m_stationUsageLbl;
    private JLabel m_rxNetworkAccessCodeLbl;
    private JLabel m_stationTimeLbl;
    private JLabel m_stationDateLbl;
    private JLabel m_stationRepeaterStateLbl;
    private JLabel m_stationRepeaterStateValueLbl;
    private JLabel m_stationRepeaterActStateLbl;
    private JLabel m_stationRepeaterActStateValueLbl;
    JLabel m_transmitterNetworkAccessCodeColorCodeLabel;
    JLabel m_receiverNetworkAccessCodeColorCodeLabel;
    public JButton m_transmitterDisableBtn = new JButton("Transmitter Inhibit");
    public JButton m_receiverDisableBtn = new JButton("Receiver Inhibit");
    private JTable m_statusTable;
    private JTable m_transmitterOperationTable;
    private JTable m_receiverOperationTable;
    private BrStatusPanelScreen m_statusPanelScreen;
    private DefaultTableModel m_model;
    private DefaultTableModel m_transmitterOperationModel;
    private DefaultTableModel m_receiverOperationModel;

    public BrStationStatusPanel(BrStatusPanelScreen brStatusPanelScreen) {
        LOG.enter("BrStationStatusPanel", new Object[]{brStatusPanelScreen});
        this.m_statusPanelScreen = brStatusPanelScreen;
        LOG.exit("BrStationStatusPanel");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        int n = 165;
        int n2 = 15;
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 1));
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Station Configuration");
        jPanel.setBorder(titledBorder);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)1, (int)5, (int)10, (int)5, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)2, (int)17, (int)1, (int)5, (int)10, (int)5, (int)10, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Status Message");
        jPanel3.setBorder(titledBorder2);
        GridBagAdder.add((Container)this, (Component)jPanel3, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)2, (int)10, (int)1, (int)5, (int)10, (int)5, (int)10, (int)0);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        GridBagAdder.add((Container)jPanel, (Component)jPanel4, (int)0, (int)0, (double)2.0, (double)1.0, (int)1, (int)1, (int)17, (int)1, (int)5, (int)10, (int)5, (int)0, (int)0);
        Ticker ticker = TickerFactory.getServiceTicker();
        JLabel jLabel = new JLabel();
        jLabel.setText(STATION_OPERATION_MODE);
        jLabel.setToolTipText("Current state of the operation mode of the station.");
        jLabel.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel, (int)0, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        this.m_stationOperationModeLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationOperationModeLbl.setText(N_A);
        this.m_stationOperationModeLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationOperationModeLbl, (int)1, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(STATION_USAGE);
        jLabel2.setToolTipText("Current state of the usage of the station.");
        jLabel2.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel2, (int)0, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        this.m_stationUsageLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationUsageLbl.setText(N_A);
        this.m_stationUsageLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationUsageLbl, (int)1, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(STATION_TIME);
        jLabel3.setToolTipText("Time stored in the station.");
        jLabel3.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel3, (int)0, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        this.m_stationTimeLbl = new JLabel("00:00:00");
        this.m_stationTimeLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationTimeLbl, (int)1, (int)2, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(STATION_DATE);
        jLabel4.setToolTipText("Date stored in the station.");
        jLabel4.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)jLabel4, (int)0, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)10, (int)5, (int)0, (int)0);
        this.m_stationDateLbl = new JLabel("1970-01-01");
        this.m_stationDateLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationDateLbl, (int)1, (int)3, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        this.m_stationRepeaterStateLbl = new JLabel("Repeater State ");
        this.m_stationRepeaterStateLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterStateLbl, (int)2, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        this.m_stationRepeaterStateLbl.setToolTipText("Current repeater state of the station.");
        this.m_stationRepeaterStateValueLbl = new TimeSuspendedJLabel(ticker);
        this.m_stationRepeaterStateValueLbl.setText(N_A);
        this.m_stationRepeaterStateValueLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterStateValueLbl, (int)3, (int)0, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)0, (int)0);
        this.m_stationRepeaterActStateLbl = new JLabel("Repeater Activity State ");
        this.m_stationRepeaterActStateLbl.setPreferredSize(new Dimension(n, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterActStateLbl, (int)2, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)5, (int)0);
        this.m_stationRepeaterActStateLbl.setToolTipText("Current repeater activity state of the station.");
        this.m_stationRepeaterActStateValueLbl = new JLabel(N_A);
        this.m_stationRepeaterActStateValueLbl.setPreferredSize(new Dimension(n / 3, n2));
        GridBagAdder.add((Container)jPanel4, (Component)this.m_stationRepeaterActStateValueLbl, (int)3, (int)1, (double)1.0, (double)1.0, (int)1, (int)1, (int)17, (int)2, (int)5, (int)3, (int)5, (int)5, (int)0);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder("Transmitter Operation");
        jPanel5.setBorder(titledBorder3);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        Object[][] objectArray = this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isConvBrApplication() ? new Object[][]{{TRANSMITTER, N_A}, {TRANSMITTER_ACTIVITY, N_A}} : new Object[][]{{TRANSMITTER, N_A}, {P2_TRANSMITTER_SLOT1, N_A}, {P2_TRANSMITTER_SLOT2, N_A}};
        Object[] objectArray2 = new String[]{"Object Name", "State"};
        this.m_transmitterOperationModel = new DefaultTableModel(objectArray, objectArray2);
        this.m_transmitterOperationTable = new JTable(this.m_transmitterOperationModel);
        this.m_transmitterOperationTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel = this.m_transmitterOperationTable.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setPreferredWidth(170);
        tableColumn.setCellRenderer(new InsetsFormatCellRenderer());
        TableColumn tableColumn2 = tableColumnModel.getColumn(1);
        tableColumn2.setPreferredWidth(140);
        tableColumn2.setCellRenderer(new InsetsFormatCellRenderer());
        this.m_transmitterOperationTable.setEnabled(false);
        this.m_transmitterOperationTable.setShowHorizontalLines(true);
        this.m_transmitterOperationTable.setShowVerticalLines(true);
        JTableHeader jTableHeader = this.m_transmitterOperationTable.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        int n3 = this.m_transmitterOperationTable.getRowCount();
        for (int i = 0; i < n3; ++i) {
            JTextField jTextField = (JTextField)this.m_transmitterOperationTable.getCellEditor(i, 0).getTableCellEditorComponent(this.m_transmitterOperationTable, null, true, i, 0);
            jTextField.setEnabled(false);
            jTextField = (JTextField)this.m_transmitterOperationTable.getCellEditor(i, 1).getTableCellEditorComponent(this.m_transmitterOperationTable, null, true, i, 1);
            jTextField.setEnabled(false);
        }
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("Object Name.");
        }
        if ((tableCellRenderer = tableColumn2.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer).setToolTipText("State.");
        }
        this.m_transmitterOperationTable.setBorder(BorderFactory.createBevelBorder(1));
        this.m_transmitterOperationTable.repaint();
        JScrollPane jScrollPane = new JScrollPane(this.m_transmitterOperationTable);
        jScrollPane.setPreferredSize(new Dimension(320, 90));
        jPanel6.add(jScrollPane);
        jPanel6.setEnabled(false);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_transmitterNetworkAccessCodeColorCodeLabel = new TimeSuspendedJLabel(ticker);
        this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
        this.m_transmitterNetworkAccessCodeColorCodeLabel.setToolTipText("Network access code or Color Code of the transmitter.");
        jPanel7.add(this.m_transmitterNetworkAccessCodeColorCodeLabel);
        this.m_txNetworkAccessCodeLbl = new TimeSuspendedJLabel(ticker);
        this.m_txNetworkAccessCodeLbl.setText(N_A);
        jPanel7.add(this.m_txNetworkAccessCodeLbl);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridBagLayout());
        this.m_transmitterDisableBtn.setToolTipText("Enables or disables the transmitter.");
        this.m_transmitterDisableBtn.setPreferredSize(new Dimension(145, 20));
        jPanel8.add(this.m_transmitterDisableBtn);
        if (this.m_statusPanelScreen.isHPDApplication() || CSSUtilities.isApplicationRxOnly()) {
            this.m_transmitterDisableBtn.setEnabled(false);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        gridBagConstraints.anchor = 18;
        jPanel5.add((Component)jPanel6, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel5.add((Component)jPanel7, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel5.add((Component)jPanel8, gridBagConstraints);
        jPanel5.repaint();
        jPanel2.add(jPanel5);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridBagLayout());
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder("Receiver Operation");
        jPanel9.setBorder(titledBorder4);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridBagLayout());
        Object[][] objectArray3 = this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isConvBrApplication() ? new Object[][]{{RECEIVER, N_A}, {RECEIVER_ACTIVITY, N_A}} : new Object[][]{{RECEIVER, N_A}, {P2_RECEIVER_SLOT1, N_A}, {P2_RECEIVER_SLOT2, N_A}};
        Object[] objectArray4 = new String[]{"Object Name", "State"};
        this.m_receiverOperationModel = new DefaultTableModel(objectArray3, objectArray4);
        this.m_receiverOperationTable = new JTable(this.m_receiverOperationModel);
        this.m_receiverOperationTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel2 = this.m_receiverOperationTable.getColumnModel();
        TableColumn tableColumn3 = tableColumnModel2.getColumn(0);
        tableColumn3.setPreferredWidth(170);
        tableColumn3.setCellRenderer(new InsetsFormatCellRenderer());
        TableColumn tableColumn4 = tableColumnModel2.getColumn(1);
        tableColumn4.setPreferredWidth(140);
        tableColumn4.setCellRenderer(new InsetsFormatCellRenderer());
        this.m_receiverOperationTable.setEnabled(false);
        this.m_receiverOperationTable.setShowHorizontalLines(true);
        this.m_receiverOperationTable.setShowVerticalLines(true);
        JTableHeader jTableHeader2 = this.m_receiverOperationTable.getTableHeader();
        jTableHeader2.setReorderingAllowed(false);
        int n4 = this.m_receiverOperationTable.getRowCount();
        for (int i = 0; i < n4; ++i) {
            JTextField jTextField = (JTextField)this.m_receiverOperationTable.getCellEditor(i, 0).getTableCellEditorComponent(this.m_receiverOperationTable, null, true, i, 0);
            jTextField.setEnabled(false);
            jTextField = (JTextField)this.m_receiverOperationTable.getCellEditor(i, 1).getTableCellEditorComponent(this.m_receiverOperationTable, null, true, i, 1);
            jTextField.setEnabled(false);
        }
        TableCellRenderer tableCellRenderer2 = tableColumn3.getHeaderRenderer();
        if (tableCellRenderer2 instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer2).setToolTipText("Object Name.");
        }
        if ((tableCellRenderer2 = tableColumn4.getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer2).setToolTipText("State.");
        }
        this.m_receiverOperationTable.setBorder(BorderFactory.createBevelBorder(1));
        this.m_receiverOperationTable.repaint();
        JScrollPane jScrollPane2 = new JScrollPane(this.m_receiverOperationTable);
        jScrollPane2.setPreferredSize(new Dimension(320, 90));
        jPanel10.add(jScrollPane2);
        jPanel10.setEnabled(false);
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayout(1, 2, 10, 10));
        this.m_receiverNetworkAccessCodeColorCodeLabel = new TimeSuspendedJLabel(ticker);
        this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
        this.m_receiverNetworkAccessCodeColorCodeLabel.setToolTipText("Network access code or Color Code of the receiver.");
        jPanel11.add(this.m_receiverNetworkAccessCodeColorCodeLabel);
        this.m_rxNetworkAccessCodeLbl = new TimeSuspendedJLabel(ticker);
        this.m_rxNetworkAccessCodeLbl.setText(N_A);
        jPanel11.add(this.m_rxNetworkAccessCodeLbl);
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridBagLayout());
        this.m_receiverDisableBtn.setToolTipText("Enables or disables the receiver.");
        this.m_receiverDisableBtn.setPreferredSize(new Dimension(145, 20));
        jPanel12.add(this.m_receiverDisableBtn);
        if (this.m_statusPanelScreen.isHPDApplication() || this.m_statusPanelScreen.isRptrBrApplication()) {
            this.m_receiverDisableBtn.setEnabled(false);
        }
        gridBagConstraints.gridy = 0;
        jPanel9.add((Component)jPanel10, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel9.add((Component)jPanel11, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel9.add((Component)jPanel12, gridBagConstraints);
        jPanel9.repaint();
        jPanel2.add(jPanel9);
        Object[][] objectArray5 = new Object[][]{{"", ""}};
        Object[] objectArray6 = new String[]{"Time", "Message"};
        this.m_model = new DefaultTableModel(objectArray5, objectArray6);
        this.m_statusTable = new JTable(this.m_model);
        this.m_statusTable.setAutoResizeMode(0);
        TableColumnModel tableColumnModel3 = this.m_statusTable.getColumnModel();
        TableColumn tableColumn5 = tableColumnModel3.getColumn(0);
        tableColumn5.setPreferredWidth(130);
        TableColumn tableColumn6 = tableColumnModel3.getColumn(1);
        tableColumn6.setPreferredWidth(480);
        this.m_statusTable.setShowHorizontalLines(true);
        this.m_statusTable.setShowVerticalLines(true);
        JTableHeader jTableHeader3 = this.m_statusTable.getTableHeader();
        jTableHeader3.setReorderingAllowed(false);
        JScrollPane jScrollPane3 = new JScrollPane(this.m_statusTable);
        jScrollPane3.setPreferredSize(new Dimension(620, 100));
        jPanel3.add(jScrollPane3);
        JTextField jTextField = (JTextField)this.m_statusTable.getCellEditor(0, 0).getTableCellEditorComponent(this.m_statusTable, null, true, 0, 0);
        jTextField.setEnabled(false);
        jTextField = (JTextField)this.m_statusTable.getCellEditor(0, 0).getTableCellEditorComponent(this.m_statusTable, null, true, 0, 1);
        jTextField.setEnabled(false);
        tableColumn5 = this.m_statusTable.getColumnModel().getColumn(0);
        TableCellRenderer tableCellRenderer3 = tableColumn5.getHeaderRenderer();
        if (tableCellRenderer3 instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer3).setToolTipText("Time.");
        }
        if ((tableCellRenderer3 = (tableColumn6 = this.m_statusTable.getColumnModel().getColumn(1)).getHeaderRenderer()) instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)tableCellRenderer3).setToolTipText("Message.");
        }
        statusBarListener.registerComponent((Component)this.m_receiverDisableBtn, "Click this button to enable/disable the Receiver.");
        statusBarListener.registerComponent((Component)this.m_transmitterDisableBtn, "Click this button to enable/disable the Transmitter.");
        this.initialize();
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        this.m_stationOperationModeLbl.setText(N_A);
        this.setTransmitterTableValue(N_A, 0);
        this.setTransmitterTableValue(N_A, 1);
        this.setReceiverTableValue(N_A, 0);
        this.setReceiverTableValue(N_A, 1);
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            this.setTransmitterTableValue(N_A, 2);
            this.setReceiverTableValue(N_A, 2);
        }
        this.m_stationUsageLbl.setText(N_A);
        this.m_rxNetworkAccessCodeLbl.setText(N_A);
        this.m_txNetworkAccessCodeLbl.setText(N_A);
        this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
        this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
        this.m_stationTimeLbl.setText(N_A);
        this.m_stationDateLbl.setText(N_A);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        this.m_stationRepeaterStateValueLbl.setText(N_A);
        this.m_stationRepeaterActStateValueLbl.setText(N_A);
        LOG.exit("initialize");
    }

    public ErrorLogUtility getErrorLogUtility() {
        LOG.enter("getErrorLogUtility");
        LOG.exit("getErrorLogUtility");
        return this.m_errorLogUtility;
    }

    public void updateTransmitterEnable(int n) {
        LOG.enter("updateTransmitterEnable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_transmitterDisableBtn.setText(m_transmitterDisableLblStr);
            this.setTransmitterTableValue(ENABLED, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Transmitter = : " + this.getTransmitterTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateTransmitterEnable - Error on updating the transmitter state");
            this.m_statusPanelScreen.popupError(-327730);
        }
        LOG.exit("updateTransmitterEnable");
    }

    public void updateTransmitterDisable(int n) {
        LOG.enter("updateTransmitterDisable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
            this.setTransmitterTableValue(INHIBIT, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Transmitter = : " + this.getTransmitterTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateTransmitterDisable - Error on updating the transmitter state");
            this.m_statusPanelScreen.popupError(-327730);
        }
        LOG.exit("updateTransmitterDisable");
    }

    public void updateReceiverEnable(int n) {
        LOG.enter("updateReceiverEnable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_receiverDisableBtn.setText(m_receiverDisableLblStr);
            this.setReceiverTableValue(ENABLED, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Receiver = : " + this.getReceiverTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateReceiverEnable - Error on updating the receiver state");
            this.m_statusPanelScreen.popupError(-327731);
        }
        LOG.exit("updateReceiverEnable");
    }

    public void updateReceiverDisable(int n) {
        LOG.enter("updateReceiverDisable", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
            this.setReceiverTableValue(INHIBIT, 0);
            this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
            this.m_statusPanelScreen.appendString("Receiver = : " + this.getReceiverTableValue(0) + "\n");
        } else {
            LOG.error((Object)"updateReceiverDisable - Error on updating the receiver state");
            this.m_statusPanelScreen.popupError(-327731);
        }
        LOG.exit("updateReceiverDisable");
    }

    public void updateStationConfiguration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        LOG.enter("updateStationConfiguration", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, n10});
        this.updateStationOperationalMode(n);
        this.updateStationUsage(n2);
        this.updateTransmitterOperationalState(n3);
        this.updateReceiverOperationalState(n4);
        this.updateTransmitterActivity(n5, 1);
        this.updateReceiverActivity(n6, 1);
        this.updateTxNetworkAccessCode(n7);
        this.updateRepeaterState(n8);
        this.updateRepeaterActivity(n9);
        this.updateRxNetworkAccessCode(n10);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateStationConfiguration");
    }

    public void updateTdmaStationConfiguration(int n, int n2) {
        LOG.enter("updateTdmaStationConfiguration", new Object[]{n, n2});
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            this.updateTransmitterActivity(n, 2);
            this.updateReceiverActivity(n2, 2);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateTdmaStationConfiguration");
    }

    public boolean isTransmitterEnable() {
        LOG.enter("isTransmitterEnable");
        boolean bl = false;
        String string = this.m_transmitterDisableBtn.getText();
        if (string.equalsIgnoreCase(m_transmitterDisableLblStr)) {
            bl = true;
        }
        LOG.exit("isTransmitterEnable", (Object)bl);
        return bl;
    }

    public boolean isReceiverEnable() {
        LOG.enter("isReceiverEnable");
        boolean bl = false;
        String string = this.m_receiverDisableBtn.getText();
        if (string.equalsIgnoreCase(m_receiverDisableLblStr)) {
            bl = true;
        }
        LOG.exit("isReceiverEnable", (Object)bl);
        return bl;
    }

    public void writeInitialDataToFile() {
        LOG.enter("writeInitialDataToFile");
        String string = "            INITIAL STATION STATUS AT LOG TIME:         \n";
        string = string + "=================================================================================" + "\n";
        string = string + "Station Operational Mode: " + this.m_stationOperationModeLbl.getText() + "\n";
        string = string + "Transmitter State: " + this.getTransmitterTableValue(0) + "\n";
        string = this.m_statusPanelScreen.isConvBrApplication() ? string + "Transmitter Activity: " : string + "TA - FDMA/TDMA logical channel 0: ";
        string = string + this.getTransmitterTableValue(1) + "\n";
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            string = string + "TA - TDMA logical channel 1: " + this.getTransmitterTableValue(2) + "\n";
        }
        string = string + "Transmitter Network Access Code: " + this.m_txNetworkAccessCodeLbl.getText() + "\n";
        string = string + "Station Usage: " + this.m_stationUsageLbl.getText() + "\n";
        string = string + "Receiver State: " + this.getReceiverTableValue(0) + "\n";
        string = this.m_statusPanelScreen.isConvBrApplication() ? string + "Receiver Activity: " : string + "RA - FDMA/TDMA logical channel 0: ";
        string = string + this.getReceiverTableValue(1) + "\n";
        if (!this.m_statusPanelScreen.isHPDApplication() && !this.m_statusPanelScreen.isConvBrApplication()) {
            string = string + "RA - TDMA logical channel 1: " + this.getTransmitterTableValue(2) + "\n";
        }
        string = string + "Receiver Network Access Code: " + this.m_rxNetworkAccessCodeLbl.getText() + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "\n" + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "            REAL TIME UPDATE :         " + "\n";
        string = string + "=================================================================================" + "\n";
        this.m_statusPanelScreen.appendString(string);
        LOG.exit("writeInitialDataToFile");
    }

    public boolean updateRealTimeData(Object object) {
        LOG.enter("updateRealTimeData", new Object[]{object});
        boolean bl = true;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        String string = null;
        byte[] byArray = new byte[4];
        int n = 0;
        Integer n2 = null;
        int n3 = 0;
        try {
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase("ExciterState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationOperationalMode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("StationOperationalMode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationOperationalMode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterOperationalState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterOperationalState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterActivity")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterActivity(Convert.toInteger((byte[])byArray), 1);
                    continue;
                }
                if (string.equalsIgnoreCase("TransmitterActivitySlot2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTransmitterActivity(Convert.toInteger((byte[])byArray), 2);
                    continue;
                }
                if (string.equalsIgnoreCase("NetworkAccessCode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTxNetworkAccessCode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("StationUsage")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateStationUsage(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverOperationalState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverOperationalState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverActivity")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverActivity(Convert.toInteger((byte[])byArray), 1);
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverActivitySlot2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverActivity(Convert.toInteger((byte[])byArray), 2);
                    continue;
                }
                if (string.equalsIgnoreCase("RepeaterState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRepeaterState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RepeaterActivityState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRepeaterActivity(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RxAccessCode")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxNetworkAccessCode(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("FaultMessage")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n2 = Convert.toInteger((byte[])byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("EpochTime")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n3 = Convert.toInteger((byte[])byArray);
                    this.updateStationTime(n3);
                    continue;
                }
                if (string.equalsIgnoreCase("NumOfBytes")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    n = Convert.toInteger((byte[])byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("X")) {
                    int[] nArray = null;
                    if (n != 0) {
                        nArray = new int[n];
                        byte[] byArray2 = new byte[n * 4];
                        byte[] byArray3 = new byte[4];
                        int n4 = 0;
                        int n5 = 0;
                        byArray2 = (byte[])realTimeDataObject.getValue(string);
                        while (n4 < byArray2.length) {
                            for (int j = 0; j < 4; ++j) {
                                byArray3[j] = byArray2[n4];
                                ++n4;
                            }
                            nArray[n5] = Convert.toInteger((byte[])byArray3);
                            ++n5;
                        }
                    }
                    this.updateStatusPanelTable(n2, n3, n, nArray);
                    continue;
                }
                bl = false;
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateRealTimeData - exception ", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData", (Object)bl);
        return bl;
    }

    private void updateStationTime(int n) {
        LOG.enter("updateStationTime", new Object[]{n});
        String string = null;
        String string2 = null;
        string2 = DateAndTimeConversion.getTime((int)n);
        string = DateAndTimeConversion.getDate((int)n);
        this.m_stationTimeLbl.setText(string2);
        this.m_stationDateLbl.setText(string);
        LOG.exit("updateStationTime");
    }

    private void updateStationOperationalMode(int n) {
        LOG.enter("updateStationOperationalMode", new Object[]{n});
        String string = STATIONOPERATIONALMODE.get(new Integer(n));
        if (null != string) {
            this.m_stationOperationModeLbl.setText(string);
        } else {
            this.m_stationOperationModeLbl.setText("UNKNOWN");
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText() + " = :");
        this.m_statusPanelScreen.appendString("StationOperationalMode = : " + this.m_stationOperationModeLbl.getText() + "\n");
        LOG.exit("updateStationOperationalMode");
    }

    private void updateTransmitterOperationalState(int n) {
        LOG.enter("updateTransmitterOperationalState", new Object[]{n});
        String string = TRANSMITTEROPERATIONALSTATE.get(new Integer(n));
        if (null != string) {
            this.setTransmitterTableValue(string, 0);
            if (string.equalsIgnoreCase(INHIBIT)) {
                this.m_transmitterDisableBtn.setText(m_transmitterEnableLblStr);
            } else {
                this.m_transmitterDisableBtn.setText(m_transmitterDisableLblStr);
            }
        } else {
            this.setTransmitterTableValue("UNKNOWN", 0);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Operational State = : " + this.getTransmitterTableValue(0) + "\n");
        LOG.exit("updateTransmitterOperationalState");
    }

    private void updateTransmitterActivity(int n, int n2) {
        long l;
        LOG.enter("updateTransmitterActivity", new Object[]{n, n2});
        HashMap<Integer, String> hashMap = n2 == 1 ? (this.m_statusPanelScreen.isMsbrApplication() ? TRANSMITTERACTIVITYSLOT1MSBR : TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR) : TRANSMITTERACTIVITYSLOT2;
        String string = hashMap.get(new Integer(n));
        if (n == 0 && this.getTransmitterTableValue(1).equalsIgnoreCase(TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.get(12)) && (l = System.currentTimeMillis() - this.nLastTransmitterActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.getTransmitterTableValue(1).equalsIgnoreCase((String)TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.get(12))) {
                        BrStationStatusPanel.this.setTransmitterTableValue(BrStationStatusPanel.IDLE, 1);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("Transmitter Activity = : " + BrStationStatusPanel.this.getTransmitterTableValue(1) + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateTransmitterActivity with timer running");
            return;
        }
        if (null != string) {
            this.setTransmitterTableValue(string, n2);
        } else {
            this.setTransmitterTableValue("UNKNOWN", n2);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Activity = : " + this.getTransmitterTableValue(n2) + "\n");
        this.nLastTransmitterActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateTransmitterActivity");
    }

    private void updateStationUsage(int n) {
        LOG.enter("updateStationUsage", new Object[]{n});
        String string = STATIONUSAGE.get(new Integer(n));
        if (this.m_statusPanelScreen.isConvBrApplication()) {
            string = CONVENTIONAL;
        }
        if (null != string) {
            this.m_stationUsageLbl.setText(string);
        } else {
            this.m_stationUsageLbl.setText("UNKNOWN");
            LOG.warn((Object)("Unknown value: " + n));
        }
        if (8 == n) {
            if (2 == m_nTdmaMode) {
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
                this.m_rxNetworkAccessCodeLbl.setText(N_A);
                this.m_rxNetworkAccessCodeLbl.setEnabled(false);
                this.m_txNetworkAccessCodeLbl.setText(N_A);
                this.m_txNetworkAccessCodeLbl.setEnabled(false);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(false);
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(false);
            } else {
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_COLOR_CODE);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_COLOR_CODE);
                this.m_rxNetworkAccessCodeLbl.setEnabled(true);
                this.m_txNetworkAccessCodeLbl.setEnabled(true);
                this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(true);
                this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(true);
            }
        } else {
            this.m_transmitterNetworkAccessCodeColorCodeLabel.setText(TX_NETWORK_ACCESS_CODE);
            this.m_receiverNetworkAccessCodeColorCodeLabel.setText(RX_NETWORK_ACCESS_CODE);
            this.m_rxNetworkAccessCodeLbl.setEnabled(true);
            this.m_txNetworkAccessCodeLbl.setEnabled(true);
            this.m_receiverNetworkAccessCodeColorCodeLabel.setEnabled(true);
            this.m_transmitterNetworkAccessCodeColorCodeLabel.setEnabled(true);
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("StationUsage = : " + this.m_stationUsageLbl.getText() + "\n");
        LOG.exit("updateStationUsage");
    }

    private void updateReceiverOperationalState(int n) {
        LOG.enter("updateReceiverOperationalState", new Object[]{n});
        String string = RECEIVEROPERATIONALSTATE.get(new Integer(n));
        if (null != string) {
            this.setReceiverTableValue(string, 0);
            if (string.equalsIgnoreCase(INHIBIT)) {
                this.m_receiverDisableBtn.setText(m_receiverEnableLblStr);
            } else {
                this.m_receiverDisableBtn.setText(m_receiverDisableLblStr);
            }
        } else {
            this.setReceiverTableValue("UNKNOWN", 0);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Operational State = : " + this.getReceiverTableValue(0) + "\n");
        LOG.exit("updateReceiverOperationalState");
    }

    private void updateReceiverActivity(int n, int n2) {
        long l;
        LOG.enter("updateReceiverActivity", new Object[]{n, n2});
        HashMap<Integer, String> hashMap = n2 == 1 ? RECEIVERACTIVITYSLOT1 : RECEIVERACTIVITYSLOT2;
        String string = hashMap.get(new Integer(n));
        if (n == 0 && this.getReceiverTableValue(1).equalsIgnoreCase(RECEIVERACTIVITYSLOT1.get(9)) && (l = System.currentTimeMillis() - this.nLastReceiverActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.getReceiverTableValue(1).equalsIgnoreCase((String)REPEATERACTIVITYSTATE.get(4))) {
                        BrStationStatusPanel.this.setReceiverTableValue(BrStationStatusPanel.IDLE, 1);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("ReceiverActivity = : " + BrStationStatusPanel.this.getReceiverTableValue(1) + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateReceiverActivity with timer running");
            return;
        }
        if (null != string) {
            this.setReceiverTableValue(string, n2);
        } else {
            this.setReceiverTableValue("UNKNOWN", n2);
            LOG.warn((Object)("Unknown value: " + n));
        }
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("ReceiverActivity = : " + this.getReceiverTableValue(n2) + "\n");
        this.nLastReceiverActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateReceiverActivity");
    }

    private void updateRepeaterState(int n) {
        LOG.enter("updateRepeaterState", new Object[]{n});
        String string = null;
        if (this.m_statusPanelScreen.isMsbrApplication() || this.m_statusPanelScreen.isHPDApplication()) {
            string = DISABLED;
        } else if (this.m_statusPanelScreen.isRptrBrApplication()) {
            string = REPEATER_SET_UP;
        } else {
            string = REPEATERSTATE.get(n);
            if (null == string) {
                string = N_A;
            }
        }
        this.m_stationRepeaterStateValueLbl.setText(string);
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Repeater State = : " + this.m_stationRepeaterStateValueLbl.getText() + "\n");
        LOG.exit("updateRepeaterState");
    }

    private void updateRepeaterActivity(int n) {
        long l;
        LOG.enter("updateRepeaterActivity", new Object[]{n});
        String string = REPEATERACTIVITYSTATE.get(n);
        if (n == 0 && this.m_stationRepeaterActStateValueLbl.getText().equalsIgnoreCase(REPEATERACTIVITYSTATE.get(4)) && (l = System.currentTimeMillis() - this.nLastRepeaterActivitySetTime) < 1000L) {
            final Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    if (BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.getText().equalsIgnoreCase((String)REPEATERACTIVITYSTATE.get(4))) {
                        BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.setText(BrStationStatusPanel.IDLE);
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString(BrStationStatusPanel.this.getDateAndTime() + " = :");
                        BrStationStatusPanel.this.m_statusPanelScreen.appendString("Repeater Activity State = : " + BrStationStatusPanel.this.m_stationRepeaterActStateValueLbl.getText() + "\n");
                    }
                    timer.cancel();
                }
            }, 1000L - l);
            LOG.exit("updateRepeaterActivity with timer running");
            return;
        }
        if (null == string) {
            string = N_A;
        }
        this.m_stationRepeaterActStateValueLbl.setText(string);
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Repeater Activity State = : " + this.m_stationRepeaterActStateValueLbl.getText() + "\n");
        this.nLastRepeaterActivitySetTime = System.currentTimeMillis();
        LOG.exit("updateRepeaterActivity");
    }

    private void updateTxNetworkAccessCode(int n) {
        LOG.enter("updateTxNetworkAccessCode", new Object[]{n});
        this.m_txNetworkAccessCodeLbl.setText(IntegerFormat.addLeadingZeros((String)Integer.toHexString(n), (int)3));
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Transmitter Network Access Code = : " + this.m_txNetworkAccessCodeLbl.getText() + "\n");
        LOG.exit("updateTxNetworkAccessCode");
    }

    private void updateRxNetworkAccessCode(int n) {
        LOG.enter("updateRxNetworkAccessCode", new Object[]{n});
        this.m_rxNetworkAccessCodeLbl.setText(IntegerFormat.addLeadingZeros((String)Integer.toHexString(n), (int)3));
        this.m_statusPanelScreen.appendString(this.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Network Access Code = : " + this.m_rxNetworkAccessCodeLbl.getText() + "\n");
        LOG.exit("updateRxNetworkAccessCode");
    }

    private void updateStatusPanelTable(Integer n, int n2, int n3, int[] nArray) {
        LOG.enter("updateStatusPanelTable", new Object[]{n, n2, n3, nArray});
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = this.m_errorLogUtility.getErrorCode(n.toString());
        string = DateAndTimeConversion.getTime((int)n2);
        string2 = DateAndTimeConversion.getDate((int)n2);
        String string5 = string2 + " " + string;
        String string6 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "_");
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            string3 = string3 + string6 + " ";
        }
        if (n3 != 0) {
            string3 = string3 + "Values = " + " ";
            for (int i = 0; i < nArray.length; ++i) {
                string3 = string3 + String.valueOf(nArray[i]) + " ";
            }
        }
        if (((String)this.m_statusTable.getValueAt(0, 0)).equals("")) {
            this.m_model.setValueAt(string5, 0, 0);
            this.m_model.setValueAt(string3, 0, 1);
        } else {
            this.m_model.addRow(new Object[]{string5, string3});
            this.m_statusTable.setModel(this.m_model);
        }
        String string7 = string5 + "\t" + string3 + "\n";
        this.m_statusPanelScreen.appendString(string7);
        LOG.exit("updateStatusPanelTable");
    }

    public String getDateAndTime() {
        LOG.enter("getDateAndTime");
        LOG.exit("getDateAndTime");
        return this.m_stationDateLbl.getText() + "/" + this.m_stationTimeLbl.getText();
    }

    private void setTransmitterTableValue(String string, int n) {
        LOG.enter("setTransmitterTableValue", new Object[]{string, n});
        this.m_transmitterOperationTable.setValueAt(string, n, 1);
        LOG.exit("setTransmitterTableValue");
    }

    private String getTransmitterTableValue(int n) {
        LOG.enter("getTransmitterTableValue", new Object[]{n});
        LOG.exit("getTransmitterTableValue");
        Object object = this.m_transmitterOperationTable.getValueAt(n, 1);
        return object.toString();
    }

    private void setReceiverTableValue(String string, int n) {
        LOG.enter("setReceiverTableValue", new Object[]{string, n});
        this.m_receiverOperationTable.setValueAt(string, n, 1);
        LOG.exit("setReceiverTableValue");
    }

    private String getReceiverTableValue(int n) {
        LOG.enter("getReceiverTableValue", new Object[]{n});
        Object object = this.m_receiverOperationTable.getValueAt(n, 1);
        LOG.exit("getReceiverTableValue");
        return object.toString();
    }

    public void handleTdmaMode(int n, Integer[] integerArray) {
        LOG.enter("handleTdmaMode", new Object[]{n, integerArray});
        if (n == 0) {
            try {
                m_nTdmaMode = integerArray[0];
            }
            catch (Exception exception) {
                LOG.error((Object)"updateObjectNames - TDMA Mode not in range", (Throwable)exception);
            }
        } else {
            LOG.warn((Object)"Unable to read TDMA Mode");
            this.m_statusPanelScreen.popupError(-327863);
        }
        LOG.exit("handleTdmaMode");
    }

    static {
        STATIONOPERATIONALMODE.put(new Integer(2), "NORMAL");
        STATIONOPERATIONALMODE.put(new Integer(4), "CONFIGURATION");
        STATIONOPERATIONALMODE.put(new Integer(5), "SERVICE");
        STATIONOPERATIONALMODE.put(new Integer(8), "INITIALIZATION");
        TRANSMITTEROPERATIONALSTATE = new HashMap();
        TRANSMITTEROPERATIONALSTATE.put(new Integer(1), ENABLED);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(2), INHIBIT);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(3), FAILED);
        TRANSMITTEROPERATIONALSTATE.put(new Integer(16), NOT_APPLICABLE);
        TRANSMITTERACTIVITYSLOT1MSBR = new HashMap();
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(1), VOICE);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(2), "CONTROL");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(3), "FAILSOFT");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(5), "V.52");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(6), "P25 SYMBOL");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(7), "P25 TEST TONE");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(8), "P25 ASTRO");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(9), "SIMULCAST TEST PATTERN");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(10), "BSI");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(11), "P25 LOW DEVIATION");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(13), DATA);
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(14), "1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1MSBR.put(new Integer(15), "1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR = new HashMap();
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(1), VOICE);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(2), "CONTROL");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(3), "FAILSOFT");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(5), "V.52");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(6), "P25 SYMBOL");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(7), "P25 TEST TONE");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(8), "P25 C4FM MOD FID");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(9), "SIMULCAST TEST PATTERN");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(10), "BSI");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(11), "P25 LOW DEVIATION");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(12), TSBK);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(13), DATA);
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(15), "1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(14), "1031 Hz test tone");
        TRANSMITTERACTIVITYSLOT1RSBRHPDBRCVBR.put(new Integer(16), NOT_APPLICABLE);
        TRANSMITTERACTIVITYSLOT2 = new HashMap();
        TRANSMITTERACTIVITYSLOT2.put(new Integer(0), IDLE);
        TRANSMITTERACTIVITYSLOT2.put(new Integer(1), VOICE);
        TRANSMITTERACTIVITYSLOT2.put(new Integer(2), "Silence AMBE");
        TRANSMITTERACTIVITYSLOT2.put(new Integer(3), "1031 Hz test tone");
        STATIONUSAGE = new HashMap();
        STATIONUSAGE.put(new Integer(0), "VOICE - FDMA");
        STATIONUSAGE.put(new Integer(1), "CONTROL");
        STATIONUSAGE.put(new Integer(2), "FAILSOFT");
        STATIONUSAGE.put(new Integer(3), "SERVICE");
        STATIONUSAGE.put(new Integer(4), IDLE);
        STATIONUSAGE.put(new Integer(5), DATA);
        STATIONUSAGE.put(new Integer(6), "BSI");
        STATIONUSAGE.put(new Integer(7), "TX TEST");
        STATIONUSAGE.put(new Integer(8), "VOICE - TDMA");
        RECEIVERACTIVITYSLOT1 = new HashMap();
        RECEIVERACTIVITYSLOT1.put(new Integer(0), IDLE);
        RECEIVERACTIVITYSLOT1.put(new Integer(1), VOICE);
        RECEIVERACTIVITYSLOT1.put(new Integer(2), "CONTROL");
        RECEIVERACTIVITYSLOT1.put(new Integer(3), "FAILSOFT");
        RECEIVERACTIVITYSLOT1.put(new Integer(4), "INVALID NAC");
        RECEIVERACTIVITYSLOT1.put(new Integer(5), "V.52");
        RECEIVERACTIVITYSLOT1.put(new Integer(7), "P25 TEST TONE");
        RECEIVERACTIVITYSLOT1.put(new Integer(8), "1031 Hz test tone");
        RECEIVERACTIVITYSLOT1.put(new Integer(12), TSBK);
        RECEIVERACTIVITYSLOT1.put(new Integer(13), DATA);
        RECEIVERACTIVITYSLOT1.put(new Integer(14), "1031 Hz test tone");
        RECEIVERACTIVITYSLOT2 = new HashMap();
        RECEIVERACTIVITYSLOT2.put(new Integer(0), IDLE);
        RECEIVERACTIVITYSLOT2.put(new Integer(1), VOICE);
        RECEIVERACTIVITYSLOT2.put(new Integer(2), "1031 Hz test tone");
        RECEIVEROPERATIONALSTATE = new HashMap();
        RECEIVEROPERATIONALSTATE.put(new Integer(1), ENABLED);
        RECEIVEROPERATIONALSTATE.put(new Integer(2), INHIBIT);
        RECEIVEROPERATIONALSTATE.put(new Integer(3), FAILED);
        REPEATERSTATE = new HashMap();
        REPEATERSTATE.put(new Integer(1), DISABLED);
        REPEATERSTATE.put(new Integer(2), REPEATER_SET_UP);
        REPEATERSTATE.put(new Integer(3), REPEATER_KNOCKDOWN);
        REPEATERSTATE.put(new Integer(16), NOT_APPLICABLE);
        REPEATERACTIVITYSTATE = new HashMap();
        REPEATERACTIVITYSTATE.put(new Integer(0), IDLE);
        REPEATERACTIVITYSTATE.put(new Integer(1), VOICE);
        REPEATERACTIVITYSTATE.put(new Integer(12), TSBK);
        REPEATERACTIVITYSTATE.put(new Integer(12), TSBK);
        REPEATERACTIVITYSTATE.put(new Integer(13), DATA);
        REPEATERACTIVITYSTATE.put(new Integer(16), NOT_APPLICABLE);
        m_nTdmaMode = 1;
    }

    private static class InsetsFormatCellRenderer
    extends JTextField
    implements TableCellRenderer {
        private static final CssLogger LOG = CssLogger.getCssLogger(InsetsFormatCellRenderer.class);
        private static final long serialVersionUID = 1L;

        private InsetsFormatCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            LOG.enter("getTableCellRendererComponent", new Object[]{jTable, object, Boolean.toString(bl), Boolean.toString(bl2), Integer.toString(n), Integer.toString(n2)});
            this.setText(" " + object + " ");
            this.setBorder(BorderFactory.createEmptyBorder());
            LOG.exit("getTableCellRendererComponent");
            return this;
        }
    }
}

