/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.RealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.platform.common.tables.BrCommonTranslationInfoRules;
import css.device.platform.summit.screens.SummitPowerSupplyPanel;
import css.device.platform.summit.screens.SummitTransmitterPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JTabbedPane;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SummitMeteringScreen
extends GenericScreen
implements BrCommonTranslationInfoRules {
    private final String FILE = "SummitMeteringScreen";
    private final String EXCITERPA_METERING = "Transmitter";
    private final String POWERSUPPLY_METERING = "Power Supply";
    private final int ZERO_INDEX = 0;
    private final int ONE_INDEX = 1;
    public SummitTransmitterPanel m_transmitter;
    public SummitPowerSupplyPanel m_pwrSupply;
    private JTabbedPane m_tabbedPane;

    public SummitMeteringScreen() {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)"Enter construtor");
        this.m_tabbedPane = new JTabbedPane();
        this.m_pwrSupply = new SummitPowerSupplyPanel();
        this.m_transmitter = new SummitTransmitterPanel();
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit construtor");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        this.MENU_ITEM_NAME = "Metering Screen";
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)"Enter buildScreen");
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        this.m_transmitter.buildScreen(this.m_window, statusBarListener);
        this.m_pwrSupply.buildScreen(this.m_window, statusBarListener);
        this.m_tabbedPane.insertTab("Power Supply", null, this.m_pwrSupply, null, 0);
        this.m_tabbedPane.insertTab("Transmitter", null, this.m_transmitter, null, 1);
        this.m_tabbedPane.setSelectedIndex(0);
        this.m_transmitter.setEnabled(false);
        this.m_pwrSupply.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
        this.m_tabbedPane.requestFocus();
        this.m_window.lockWindow();
        this.m_window.setCursor(new Cursor(3));
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit buildScreen");
    }

    @Override
    public void initialize() {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)"Enter initialize()");
        this.m_window.lockWindow();
        this.m_window.setCursor(new Cursor(3));
        this.m_tabbedPane.setSelectedIndex(0);
        this.m_pwrSupply.initialize();
        this.m_transmitter.initialize();
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit initialize()");
    }

    public void realTimeUpdate(Object object) {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)"Enter realTimeUpdate.");
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        int n = realTimeDataObject.getError();
        if (n != 0) {
            if (n != -262184) {
                this.popupError(-262160);
                this.close();
            }
        } else {
            boolean bl = this.m_transmitter.realTimeUpdate(realTimeDataObject);
            if (!bl) {
                bl = this.m_pwrSupply.realTimeUpdate(realTimeDataObject);
            }
            if (!bl) {
                Audit.audit((int)1002, (String)"SummitMeteringScreen", (String)"Name not found");
            }
        }
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit realTimeUpdate");
    }

    public Object[] startSession() {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)"Enter startSession()");
        Byte by = new Byte(0);
        Byte by2 = new Byte(0);
        Object[][] objectArray = BrCommonMeasurementRules;
        Object[] objectArray2 = new Object[]{by, by2, objectArray};
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit startSession()");
        return objectArray2;
    }

    public void handleStartSession(int n) {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)("Enter handleStartSession(): Error = " + n));
        if (n != 0) {
            this.popupError("unable_to_start_session");
            Audit.audit((int)1002, (String)"SummitMeteringScreen", (String)"Cannot start Measurement Session error");
            this.close();
        }
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit handleStartSession");
    }

    public void handleStopSession(int n) {
        Audit.audit((int)1009, (String)"SummitMeteringScreen", (String)("Enter handleStopSession(): g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)"SummitMeteringScreen", (String)("Received error " + n + " while trying to close session"));
        }
        Audit.audit((int)1010, (String)"SummitMeteringScreen", (String)"Exit handleStopSession()");
    }
}

