/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.appservices.cs.ConnectionInfoObject;
import css.core.service.CmdHandler;
import css.core.service.CmdHandlerRules;
import css.core.service.DataObject;
import css.core.service.ProtocolMultiplexer;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.service.ScreenManager;
import css.device.common.util.Alarm;
import java.util.Vector;

public class ScCmdManager
extends CmdManager {
    private Alarm m_alarm;
    private long m_startResetTime;
    private static final CssLogger LOG = CssLogger.getCssLogger(ScCmdManager.class);

    public ScCmdManager(Object[][] objectArray) {
        super(objectArray);
        LOG.enter("ScCmdManager");
        LOG.exit("ScCmdManager");
    }

    @Override
    public void handleRestart() {
        this.m_alarm = new Alarm(15000, this);
        this.m_alarm.start();
        this.m_startResetTime = System.currentTimeMillis();
    }

    @Override
    public void alarmCall(Object object) {
        block16: {
            LOG.enter("alarmCall", new Object[]{object});
            boolean bl = false;
            Object[][] objectArray = new Object[][]{{new Integer(2), new String[]{"scState"}, new String[]{"Integer[]"}, new Integer(1006)}};
            ProtocolMultiplexer protocolMultiplexer = ProtocolMultiplexer.getCoreProtocolMultiplexer();
            CmdHandlerRules cmdHandlerRules = new CmdHandlerRules(objectArray);
            CmdHandler cmdHandler = new CmdHandler(cmdHandlerRules, "DeviceModeRequest", protocolMultiplexer);
            int n = 2;
            int n2 = 4;
            String string = "scState";
            String string2 = ConnectionInfoObject.getDeviceType();
            if (null != string2) {
                if (n != -1 && null != string && n2 != -1) {
                    DataObject dataObject = cmdHandler.processSyncRequest(n, (Object[])new String[]{""});
                    if (null != dataObject && dataObject.getError() == 0) {
                        Vector vector = (Vector)dataObject.getParameterValue(string);
                        if (null != vector && vector.size() > 0) {
                            int n3 = (Integer)vector.elementAt(0);
                            if (n2 != n3) {
                                bl = true;
                            } else {
                                LOG.trace((Object)"alarmCall - Device initializes.");
                            }
                        }
                    } else {
                        LOG.warn((Object)"alarmCall - Error while retrieving current device state.");
                    }
                } else {
                    LOG.warn((Object)"alarmCall - Incompatible device type.");
                }
            } else {
                LOG.error((Object)"alarmCall - Cannot determine device type.");
            }
            if (bl) {
                ScreenManager.update(true);
            } else {
                long l = System.currentTimeMillis();
                String string3 = ConnectionInfoObject.getResetTimeout();
                if (null != string3) {
                    try {
                        long l2 = Long.parseLong(string3);
                        if (l - this.m_startResetTime < l2) {
                            this.m_alarm = new Alarm(5000, this);
                            this.m_alarm.start();
                            break block16;
                        }
                        ScreenManager.update(false);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"alarmCall - Caught exception while checking for device to restart", (Throwable)exception);
                        ScreenManager.update(false);
                    }
                } else {
                    LOG.error((Object)"alarmCall - Error while getting timeout value from properties.");
                    ScreenManager.update(false);
                }
            }
        }
        LOG.exit("alarmCall");
    }
}

