/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.channelnumber;

import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.device.common.screens.ChannelNumber;
import css.device.common.util.DeviceErrorCodes;
import java.util.Enumeration;
import pnm.config.configwindow.XField;
import pnm.ui.PnmField;

public class BrChannelNumber
extends ChannelNumber
implements CssConstants {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(BrChannelNumber.class);
    private static boolean m_validMode = true;

    public void getDeviceMode(int n, Integer[] integerArray, Integer[] integerArray2) {
        LOG.enter("getDeviceMode", new Object[]{n, integerArray, integerArray2});
        if (n == 0) {
            int n2 = integerArray[0];
            switch (n2) {
                case 2: 
                case 4: 
                case 5: {
                    m_validMode = true;
                    break;
                }
                default: {
                    m_validMode = false;
                    break;
                }
            }
        } else {
            m_validMode = true;
            LOG.warn((Object)"Unable to get device mode");
        }
        LOG.exit("getDeviceMode");
    }

    @Override
    public boolean userRequest() {
        LOG.enter("userRequest");
        boolean bl = false;
        if (m_validMode) {
            bl = this.validateChannelNumber();
            if (bl) {
                this.m_confirmPopup.display(-524341);
                bl = this.m_confirmPopup.getStatus();
            }
        } else {
            bl = false;
            this.m_errorPopup.display(-524345);
        }
        LOG.exit("userRequest", (Object)bl);
        return bl;
    }

    @Override
    public void updateChannelNumber(int n, Integer n2) {
        LOG.enter("updateChannelNumber", new Object[]{n, n2});
        XField xField = null;
        if (n != 0 && null != n2) {
            if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                LOG.error((Object)("updateChannelNumber - Error data: " + n2));
                this.m_errorPopup.display(n2.intValue());
            } else {
                LOG.warn((Object)"Unable to set channel Number");
                this.m_errorPopup.display(-524339);
            }
        } else {
            Enumeration enumeration = XField.getInstances();
            while (enumeration.hasMoreElements()) {
                xField = (XField)enumeration.nextElement();
                if (!xField.get_field_name().equalsIgnoreCase("brChannelNum")) continue;
                PnmField.setValue((Object)xField.get_field_id(), (Object)this.m_channelNumberTFld.getText());
            }
            this.m_channelNumberLbl.setText(this.m_channelNumberTFld.getText());
        }
        this.m_window.unlockWindow();
        LOG.exit("enclosing_method");
    }

    @Override
    public boolean validateChannelNumber() {
        LOG.enter("validateChannelNumber");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        try {
            int n = new Integer(this.m_channelNumberTFld.getText());
            if (Devices.isIsrApplication((String)string).booleanValue()) {
                if (n < 1 || n > 28) {
                    this.m_errorPopup.display(-524343);
                    this.m_channelNumberTFld.requestFocus();
                    bl = false;
                }
            } else if (Devices.isHpdBrApplication((String)string).booleanValue()) {
                if (n < 1 || n > 5) {
                    this.m_errorPopup.display(-524346);
                    this.m_channelNumberTFld.requestFocus();
                    bl = false;
                }
            } else {
                int n2 = 30;
                int n3 = -524344;
                if (Devices.isConvBrApplication((String)string).booleanValue()) {
                    n2 = 200;
                    n3 = -524347;
                }
                if (n < 1 || n > n2) {
                    this.m_errorPopup.display(n3);
                    this.m_channelNumberTFld.requestFocus();
                    bl = false;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.m_errorPopup.display(-524340);
            LOG.error((Object)"validateChannelNumber - exception", (Throwable)numberFormatException);
        }
        LOG.exit("validateChannelNumber", (Object)bl);
        return bl;
    }
}

