/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.component.CssGridBagLayout;
import css.core.util.component.CssServicePanel;
import css.core.util.timesuspender.Ticker;
import css.core.util.timesuspender.TickerFactory;
import css.device.platform.common.screens.statuspanel.BrStationStatusPanel;
import css.device.platform.common.screens.statuspanel.BrStatusCommonPanel;
import css.device.platform.common.screens.statuspanel.BrStatusPanelScreen;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import pnm.ui.UIInternalFrame;
import pnm.util.IntegerFormat;

public class BrHardwareStatusPanel
extends BrStatusCommonPanel
implements CssConstants {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrHardwareStatusPanel.class);
    private static final long serialVersionUID = -1L;
    static final String OPERATIONAL = "OPERATIONAL";
    static final String WARMING_UP = "WARMING UP";
    static final String FAILED = "FAILED";
    static final String LOCKED = "LOCKED";
    static final String ACTIVE = "ACTIVE";
    static final String DISABLED = "DISABLED";
    static final String UNLOCKED = "UNLOCKED";
    static final String PA_ACTIVE = "ACTIVE";
    static final String N_A = "N/A";
    static final String NOT_AVAILABLE = "NOT AVAILABLE";
    static final String NOT_CONFIGURED = "NOT CONFIGURED";
    static final String TXT_NOT_APPLICABLE = "NOT APPLICABLE";
    static final String UNKNOWN = "UNKNOWN";
    static final String NOT_APPLICABLE = "NOT APPLICABLE";
    static final String AC_POWER = "AC POWER";
    static final String DC_POWER = "DC POWER";
    static final String PS_FAILED = "PS HW FAILED";
    static final String PS_SHARED = "SHARED";
    static final String EMPTY = "";
    private static final int OVERVOLTAGE_ALARM_ALARM = 0;
    private static final int OVERVOLTAGE_ALARM_NO_ALARM = 1;
    private static final HashMap<Integer, String> OVERVOLTAGE_ALARM = new HashMap();
    private CssServicePanel _systemIdPanel;
    private CssServicePanel _siteIdPanel;
    private CssServicePanel _subsiteIdPanel;
    private CssServicePanel _stationNamePanel;
    private CssServicePanel _siteNamePanel;
    private CssServicePanel _txFrequencyPanel;
    private CssServicePanel _rxFrequencyPanel;
    private CssServicePanel _exciterPanel;
    private CssServicePanel _txSynthesizerPanel;
    private CssServicePanel _powerAmplifierPanel;
    private CssServicePanel _externalRefPanel;
    private CssServicePanel _integratedRefAPanel;
    private CssServicePanel _integratedRefBPanel;
    private CssServicePanel _controlPanel;
    private CssServicePanel _receiverPanel;
    private CssServicePanel _rxSynthesizerPanel;
    private CssServicePanel _powerSupplyPanel;
    private CssServicePanel _infraLinkPanel;
    private CssServicePanel _overVoltageAlarmPanel;
    private CssServicePanel _analogInfrastructureStatePanel;
    private CssServicePanel _lan1Panel;
    private CssServicePanel _lan2Panel;
    private CssServicePanel _internalFreqRefPanel;
    private UIInternalFrame m_window;
    private BrStatusPanelScreen m_statusPanelScreen;
    private BrStationStatusPanel m_stationStatusPanel;
    private static final String PANEL_STATION_CONFIGURATION = "Station Configuration";
    private static final String PANEL_HARDWARE_STATUS = "Hardware Status";
    private static final String SITE_ID = "Site ID";
    private static final String SITE_ID_LABEL = "Site ID Label";
    private static final String SYSTEM_ID = "System ID (hex)";
    private static final String SYSTEM_ID_LABEL = "System ID (hex) Label";
    private static final String STATION_NAME = "Station Name";
    private static final String STATION_NAME_LABEL = "Station Name Label";
    private static final String SITE_NAME = "Site Name";
    private static final String SITE_NAME_LABEL = "Site Name Label";
    private static final String TX_FREQUENCY_CVBR_3600 = "Current Tx Frequency";
    private static final String CURRENT_TX_FREQUENCY_CVBR_3600_LABEL = "Current Tx Frequency Label";
    private static final String RX_FREQUENCY_CVBR_3600 = "Current Rx Frequency";
    private static final String CURRENT_RX_FREQUENCY_CVBR_3600_LABEL = "Current Rx Frequency Label";
    private static final String RX_FREQUENCY_MSBR_HPD_ISR = "Rx Frequency (MHz)";
    private static final String RX_FREQUENCY_MSBR_HPD_ISR_LABEL = "Rx Frequency (MHz) Label";
    private static final String TX_FREQUENCY_MSBR_HPD_ISR = "Tx Frequency (MHz)";
    private static final String TX_FREQUENCY_MSBR_HPD_ISR_LABEL = "Tx Frequency (MHz) Label";
    private static final String SUBSITE_ID = "Subsite ID";
    private static final String SUBSITE_ID_LABEL = "Subsite ID Label";
    private static final String EXCITER = "Exciter";
    private static final String EXCITER_LABEL = "Exciter Label";
    private static final String EXTERNAL_REF = "External Reference";
    private static final String EXTERNAL_REF_LABEL = "External Reference Label";
    private static final String TX_SYNTHESIZER = "Tx Synthesizer";
    private static final String TX_SYNTHESIZER_LABEL = "Tx Synthesizer Label";
    private static final String INTEGRATED_REFA = "Integrated Reference A";
    private static final String INTEGRATED_REFA_LABEL = "Integrated Reference A Label";
    private static final String INTEGRATED_REFB = "Integrated Reference B";
    private static final String INTEGRATED_REFB_LABEL = "Integrated Reference B Label";
    private static final String CONTROL = "Control";
    private static final String CONTROL_LABEL = "Control Label";
    private static final String RX_SYNTHESIZER = "Rx Synthesizer";
    private static final String RX_SYNTHESIZER_LABEL = "Rx Synthesizer Label";
    private static final String RECEIVER = "Receiver";
    private static final String RECEIVER_LABEL = "Receiver Label";
    private static final String POWER_AMPLIFIER = "Power Amplifier";
    private static final String POWER_AMPLIFIER_LABEL = "Power Amplifier Label";
    private static final String POWER_SUPPLY = "Power Supply";
    private static final String POWER_SUPPLY_LABEL = "Power Supply Label";
    private static final String LAN1 = "LAN1";
    private static final String LAN1_LABEL = "LAN1 Label";
    private static final String LAN2 = "LAN2";
    private static final String LAN2_LABEL = "LAN2 Label";
    private static final String DIGITAL_INFRASTRUCTURE_LINK = "Digital Infrastructure Link";
    private static final String DIGITAL_INFRASTRUCTURE_LINK_LABEL = "Digital Infrastructure Link Label";
    private static final String INTERNAL_FREQUENCY_REFERENCE = "Internal Frequency Reference";
    private static final String INTERNAL_FREQUENCY_REFERENCE_LABEL = "Internal Frequency Reference Label";
    private static final String OVER_VOLTAGE_ALARM = "Over Voltage Alarm";
    private static final String ANALOG_LINK_STATE = "Analog Link State";
    private static final int ANALOG_INFRASTRUCTURE_STATE_FAILED = 0;
    private static final int ANALOG_INFRASTRUCTURE_STATE_OPERATIONAL = 1;
    private static final int ANALOG_INFRASTRUCTURE_STATE_DISABLED = 2;
    private static final int ANALOG_INFRASTRUCTURE_STATE_NOTCONFIGURED = 15;
    private static final HashMap<Integer, String> ANALOG_INFRASTRUCTURE_STATE = new HashMap();
    private static final HashMap<String, String[]> HARDWARESTATUS_FIELDS = new HashMap();
    private static HashMap<String, Color> POWER_AMPLIFIER_BACKGROUND_COLORS;
    private static HashMap<String, Color> LAN_INTEGRATED_BACKGROUND_COLORS;

    public BrHardwareStatusPanel(BrStatusPanelScreen brStatusPanelScreen, BrStationStatusPanel brStationStatusPanel) {
        super(HARDWARESTATUS_FIELDS);
        OVERVOLTAGE_ALARM.put(0, "ALARM");
        OVERVOLTAGE_ALARM.put(1, "NO ALARM");
        ANALOG_INFRASTRUCTURE_STATE.put(0, FAILED);
        ANALOG_INFRASTRUCTURE_STATE.put(1, OPERATIONAL);
        ANALOG_INFRASTRUCTURE_STATE.put(2, "LINK CHECK DISABLED");
        ANALOG_INFRASTRUCTURE_STATE.put(15, NOT_CONFIGURED);
        DEFAULT_BACKGROUND_COLORS.put(OPERATIONAL, GREEN);
        DEFAULT_BACKGROUND_COLORS.put(FAILED, RED);
        DEFAULT_BACKGROUND_COLORS.put(LOCKED, GREEN);
        DEFAULT_BACKGROUND_COLORS.put(UNLOCKED, RED);
        DEFAULT_BACKGROUND_COLORS.put(PS_FAILED, RED);
        DEFAULT_BACKGROUND_COLORS.put(WARMING_UP, YELLOW);
        DEFAULT_BACKGROUND_COLORS.put(DC_POWER, GREEN);
        DEFAULT_BACKGROUND_COLORS.put(AC_POWER, GREEN);
        DEFAULT_BACKGROUND_COLORS.put(PS_SHARED, GREEN);
        POWER_AMPLIFIER_BACKGROUND_COLORS.put(FAILED, RED);
        POWER_AMPLIFIER_BACKGROUND_COLORS.put(OPERATIONAL, GREEN);
        POWER_AMPLIFIER_BACKGROUND_COLORS.put("ACTIVE", GREEN);
        LAN_INTEGRATED_BACKGROUND_COLORS.put(FAILED, RED);
        LAN_INTEGRATED_BACKGROUND_COLORS.put(OPERATIONAL, GREEN);
        LAN_INTEGRATED_BACKGROUND_COLORS.put("ACTIVE", GREEN);
        this.m_statusPanelScreen = brStatusPanelScreen;
        this.m_stationStatusPanel = brStationStatusPanel;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new CssGridBagLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PANEL_STATION_CONFIGURATION);
        jPanel.setBorder(titledBorder);
        jPanel.setName(PANEL_STATION_CONFIGURATION);
        this.addOneElement(this, jPanel, 0, 0, 1.0, 0.0, 4, 1, 18, 0, 3, 10, 3, 10, 0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new CssGridBagLayout());
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(PANEL_HARDWARE_STATUS);
        jPanel2.setBorder(titledBorder2);
        jPanel2.setName(PANEL_HARDWARE_STATUS);
        this.addOneElement(this, jPanel2, 0, 4, 1.0, 0.0, 8, 1, 18, 0, 3, 10, 3, 10, 0);
        Ticker ticker = TickerFactory.getServiceTicker();
        this._siteIdPanel = this.addFieldValuePanel(jPanel, SITE_ID, "ID assigned to the site in which this station is configured.", SITE_ID_LABEL, SITE_ID, N_A, null);
        this._systemIdPanel = this.addFieldValuePanel(jPanel, SYSTEM_ID, "Unique ID assigned to the system.", SYSTEM_ID_LABEL, SYSTEM_ID, N_A, null);
        this._stationNamePanel = this.addFieldValuePanel(jPanel, STATION_NAME, "Name given to the station.", STATION_NAME_LABEL, STATION_NAME, N_A, null);
        this._siteNamePanel = this.addFieldValuePanel(jPanel, SITE_NAME, "Name given to the site.", SITE_NAME_LABEL, SITE_NAME, N_A, null);
        this._txFrequencyPanel = this.isApplicable(TX_FREQUENCY_CVBR_3600) ? this.addFieldValuePanel(jPanel, TX_FREQUENCY_CVBR_3600, "Displays the Current Transmitter Frequency.", CURRENT_TX_FREQUENCY_CVBR_3600_LABEL, TX_FREQUENCY_CVBR_3600, N_A, null) : this.addFieldValuePanel(jPanel, TX_FREQUENCY_MSBR_HPD_ISR, "Frequency assigned to the transmitter of the station.", TX_FREQUENCY_MSBR_HPD_ISR_LABEL, TX_FREQUENCY_MSBR_HPD_ISR, N_A, null);
        this._subsiteIdPanel = this.addFieldValuePanel(jPanel, SUBSITE_ID, "ID assigned to the Subsite in which this station is configured.", SUBSITE_ID_LABEL, SUBSITE_ID, N_A, null);
        this._rxFrequencyPanel = this.isApplicable(RX_FREQUENCY_CVBR_3600) ? this.addFieldValuePanel(jPanel, RX_FREQUENCY_CVBR_3600, "Displays the Current Receiver Frequency.", CURRENT_RX_FREQUENCY_CVBR_3600_LABEL, RX_FREQUENCY_CVBR_3600, N_A, null) : this.addFieldValuePanel(jPanel, RX_FREQUENCY_MSBR_HPD_ISR, "Configured frequency of the receiver.", RX_FREQUENCY_MSBR_HPD_ISR_LABEL, RX_FREQUENCY_MSBR_HPD_ISR, N_A, null);
        this._exciterPanel = this.addFieldValuePanelWithTicker(jPanel2, EXCITER, "Current status of the exciter.", EXCITER_LABEL, EXCITER, N_A, null, ticker);
        this._externalRefPanel = this.addFieldValuePanelWithTicker(jPanel2, EXTERNAL_REF, "Current status of external reference.", EXTERNAL_REF_LABEL, EXTERNAL_REF, N_A, null, ticker);
        this._txSynthesizerPanel = this.addFieldValuePanelWithTicker(jPanel2, TX_SYNTHESIZER, "Current status of the Tx Synthesizer.", TX_SYNTHESIZER_LABEL, TX_SYNTHESIZER, N_A, null, ticker);
        this._integratedRefAPanel = this.addFieldValuePanelWithTicker(jPanel2, INTEGRATED_REFA, "Current status of integrated reference A.", INTEGRATED_REFA_LABEL, INTEGRATED_REFA, N_A, null, LAN_INTEGRATED_BACKGROUND_COLORS, ticker);
        this._controlPanel = this.addFieldValuePanelWithTicker(jPanel2, CONTROL, "Current status of the control module.", CONTROL_LABEL, CONTROL, N_A, null, ticker);
        this._integratedRefBPanel = this.addFieldValuePanelWithTicker(jPanel2, INTEGRATED_REFB, "Current status of integrated reference B.", INTEGRATED_REFB_LABEL, INTEGRATED_REFB, N_A, null, LAN_INTEGRATED_BACKGROUND_COLORS, ticker);
        this._rxSynthesizerPanel = this.addFieldValuePanelWithTicker(jPanel2, RX_SYNTHESIZER, "Current status of the Rx Synthesizer.", RX_SYNTHESIZER_LABEL, RX_SYNTHESIZER, N_A, null, ticker);
        this._receiverPanel = this.addFieldValuePanelWithTicker(jPanel2, RECEIVER, "Current status of the receiver.", RECEIVER_LABEL, RECEIVER, N_A, null, ticker);
        this._powerAmplifierPanel = this.addFieldValuePanelWithTicker(jPanel2, POWER_AMPLIFIER, "Current status of the power amplifier.", POWER_AMPLIFIER_LABEL, POWER_AMPLIFIER, N_A, null, POWER_AMPLIFIER_BACKGROUND_COLORS, ticker);
        this._powerSupplyPanel = this.addFieldValuePanelWithTicker(jPanel2, POWER_SUPPLY, "Current status of the power supply.", POWER_SUPPLY_LABEL, POWER_SUPPLY, N_A, null, ticker);
        this._lan1Panel = this.addFieldValuePanelWithTicker(jPanel2, LAN1, "Current activity of LAN 1.", LAN1_LABEL, LAN1, N_A, null, LAN_INTEGRATED_BACKGROUND_COLORS, ticker);
        this._lan2Panel = this.addFieldValuePanelWithTicker(jPanel2, LAN2, "Current activity of LAN 2.", LAN2_LABEL, LAN2, N_A, null, LAN_INTEGRATED_BACKGROUND_COLORS, ticker);
        this._infraLinkPanel = this.addFieldValuePanelWithTicker(jPanel2, DIGITAL_INFRASTRUCTURE_LINK, "Current status of the Infrastructure Link.", DIGITAL_INFRASTRUCTURE_LINK_LABEL, DIGITAL_INFRASTRUCTURE_LINK, N_A, null, ticker);
        this._analogInfrastructureStatePanel = this.addFieldValuePanel(jPanel2, ANALOG_LINK_STATE, "Current Analog Link state.", "Analog Link State Label", ANALOG_LINK_STATE, N_A, null);
        this._overVoltageAlarmPanel = this.addFieldValuePanel(jPanel2, OVER_VOLTAGE_ALARM, "Current Over Voltage Alarm state.", "Over Voltage Alarm Label", OVER_VOLTAGE_ALARM, N_A, null);
        this._internalFreqRefPanel = this.addFieldValuePanelWithTicker(jPanel2, INTERNAL_FREQUENCY_REFERENCE, "Current SAC Frequency Reference.", INTERNAL_FREQUENCY_REFERENCE_LABEL, INTERNAL_FREQUENCY_REFERENCE, N_A, null, ticker);
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints);
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        if (null != this._systemIdPanel) {
            this._systemIdPanel.setValue(N_A);
        }
        if (null != this._siteIdPanel) {
            this._siteIdPanel.setValue(N_A);
        }
        if (null != this._subsiteIdPanel) {
            this._subsiteIdPanel.setValue(N_A);
        }
        if (null != this._rxFrequencyPanel) {
            this._rxFrequencyPanel.setValue(N_A);
        }
        if (null != this._txFrequencyPanel) {
            this._txFrequencyPanel.setValue(N_A);
        }
        if (null != this._stationNamePanel) {
            this._stationNamePanel.setValue(N_A);
        }
        if (null != this._siteNamePanel) {
            this._siteNamePanel.setValue(N_A);
        }
        if (null != this._powerSupplyPanel) {
            this._powerSupplyPanel.setValue(N_A);
        }
        if (null != this._rxSynthesizerPanel) {
            this._rxSynthesizerPanel.setValue(N_A);
        }
        if (null != this._controlPanel) {
            this._controlPanel.setValue(N_A);
        }
        if (null != this._externalRefPanel) {
            this._externalRefPanel.setValue(N_A);
        }
        if (null != this._integratedRefAPanel) {
            this._integratedRefAPanel.setValue(N_A);
        }
        if (null != this._integratedRefBPanel) {
            this._integratedRefBPanel.setValue(N_A);
        }
        if (null != this._powerAmplifierPanel) {
            this._powerAmplifierPanel.setValue(N_A);
        }
        if (null != this._txSynthesizerPanel) {
            this._txSynthesizerPanel.setValue(N_A);
        }
        if (null != this._exciterPanel) {
            this._exciterPanel.setValue(N_A);
        }
        if (null != this._receiverPanel) {
            this._receiverPanel.setValue(N_A);
        }
        if (null != this._lan1Panel) {
            this._lan1Panel.setValue(N_A);
        }
        if (null != this._lan2Panel) {
            this._lan2Panel.setValue(N_A);
        }
        if (null != this._infraLinkPanel) {
            this._infraLinkPanel.setValue(N_A);
        }
        if (null != this._analogInfrastructureStatePanel) {
            this._analogInfrastructureStatePanel.setValue(N_A);
        }
        if (null != this._overVoltageAlarmPanel) {
            this._overVoltageAlarmPanel.setValue(N_A);
        }
        if (null != this._internalFreqRefPanel) {
            this._internalFreqRefPanel.setValue(N_A);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        LOG.exit("initialize");
    }

    public void updateScreenSubSiteId(int n, Integer[] integerArray) {
        LOG.enter("updateScreenSubSiteId", new Object[]{n, integerArray});
        try {
            if (n == 0) {
                this._subsiteIdPanel.setValue(integerArray[0].toString());
            } else {
                this._subsiteIdPanel.setValue(N_A);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"updateScreenSubSiteId - Field not supported", (Throwable)exception);
        }
        LOG.exit("enclosing_method");
    }

    public void updateScreenSystemId(int n, Integer[] integerArray) {
        LOG.enter("updateScreenSystemId", new Object[]{n, integerArray});
        try {
            if (n == 0) {
                this._systemIdPanel.setValue(IntegerFormat.addLeadingZeros((String)Integer.toHexString(integerArray[0]), (int)4));
            } else {
                this._systemIdPanel.setValue(N_A);
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"updateScreenSystemId - Field not supported", (Throwable)exception);
        }
        LOG.exit("enclosing_method");
    }

    public void updateCommonParamsIrbr3600(int n, Integer[] integerArray, String[] stringArray, String[] stringArray2) {
        if (n == 0) {
            if (integerArray.length != 0) {
                this._siteIdPanel.setValue(integerArray[0].toString());
            } else {
                LOG.warn((Object)"Array length is 0");
                this.m_statusPanelScreen.popupError("Unable to Get Site ID ");
            }
            this._stationNamePanel.setValue(stringArray[0]);
            this._siteNamePanel.setValue(stringArray2[0]);
        } else {
            LOG.warn((Object)("updateCommonParamsIrbr3600 - error occured: " + n));
            this.m_statusPanelScreen.popupError("Error occured while getting parameters from the device.\nSite ID, Station Name and Site Name may not be displayed correctly.");
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateCommonParamsMsbr3600(int n, String[] stringArray) {
        if (n == 0) {
            this._stationNamePanel.setValue(stringArray[0]);
        } else {
            LOG.warn((Object)("updateCommonParamsMsbr3600 - error occured: " + n));
            this.m_statusPanelScreen.popupError("Error occured while getting parameters from the device.\nStation Name may not be displayed correctly.");
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateStationStatus(int n, Integer[] integerArray, Integer[] integerArray2, String[] stringArray, String[] stringArray2, Integer[] integerArray3, Integer[] integerArray4) {
        LOG.enter("updateStationStatus", new Object[]{n, integerArray, integerArray2, stringArray, stringArray2, integerArray3, integerArray4});
        if (n == 0) {
            String string;
            double d;
            if (!this.isApplicable(TX_FREQUENCY_CVBR_3600)) {
                if (integerArray3.length != 0) {
                    d = (double)integerArray3[0].intValue() / 1000000.0;
                    string = new Double(d).toString();
                    this._txFrequencyPanel.setValue(string);
                } else {
                    LOG.warn((Object)"Array length is 0");
                    this.m_statusPanelScreen.popupError("Unable to Get Transmitter Frequency ");
                }
            }
            if (!this.isApplicable(RX_FREQUENCY_CVBR_3600)) {
                if (integerArray4.length != 0) {
                    d = (double)integerArray4[0].intValue() / 1000000.0;
                    string = new Double(d).toString();
                    this._rxFrequencyPanel.setValue(string);
                } else {
                    LOG.warn((Object)"Array length is 0");
                    this.m_statusPanelScreen.popupError("Unable to Get Receiver Frequency ");
                }
            }
            if (integerArray.length != 0) {
                this._siteIdPanel.setValue(integerArray[0].toString());
            } else {
                LOG.warn((Object)"Array length is 0");
                this.m_statusPanelScreen.popupError("Unable to Get Site ID ");
            }
            if (integerArray2.length != 0) {
                String string2 = System.getProperty("css.core.deviceandhwtype", UNKNOWN);
                if (!Devices.isConvBrApplication((String)string2).booleanValue()) {
                    this._systemIdPanel.setValue(IntegerFormat.addLeadingZeros((String)Integer.toHexString(integerArray2[0]), (int)5));
                } else {
                    this._systemIdPanel.setValue(N_A);
                }
            } else {
                LOG.warn((Object)"Array length is 0");
                this.m_statusPanelScreen.popupError("Unable to Get System ID ");
            }
            this._stationNamePanel.setValue(stringArray[0]);
            this._siteNamePanel.setValue(stringArray2[0]);
        } else {
            LOG.warn((Object)("updateStationStatus - error occured: " + n));
            this.m_statusPanelScreen.popupError(-262182);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("enclosing_method");
    }

    public void updateHardwareConfiguration(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, byte[] byArray, byte[] byArray2, int n15, int n16, int n17) {
        LOG.enter("updateHardwareConfiguration", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, byArray, byArray2, n15, n16, n17});
        this.updateExciter(n);
        this.updateTxSynthesizer(n2);
        this.updatePowerAmplifier(n3);
        this.updateExternalRef(n4);
        this.updateIntegratedRefA(n5);
        this.updateIntegratedRefB(n6);
        this.updateLan1(n7);
        this.updateLan2(n8);
        this.updateControlModule(n9);
        this.updateReceiverState(n10);
        this.updateRxSynthesizer(n11);
        this.updateTXFreq(byArray);
        this.updateRXFreq(byArray2);
        if (this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.is3600Application()) {
            this.updatePowerSupplyNew(n15);
        } else {
            this.updatePowerSupply(n12);
        }
        this.updateOverVoltageAlarm(n16);
        this.updateAnalogInfrastructureState(n17);
        this.updateInfrastructureInterface(n13);
        this.updateSacFrequencyReference(n14);
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("updateHardwareConfiguration");
    }

    public boolean updateRealTimeData(Object object) {
        boolean bl = true;
        String string = null;
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        byte[] byArray = new byte[4];
        LOG.enter("updateRealTimeData", new Object[]{object});
        try {
            for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
                string = realTimeDataObject.getName(i);
                if (string.equalsIgnoreCase(EXCITER)) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateExciter(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("TxSynthesizer")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTxSynthesizer(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("PowerAmplifier")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerAmplifier(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ExternalReference")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateExternalRef(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("IntegratedRefA")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateIntegratedRefA(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("IntegratedRefB")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateIntegratedRefB(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("CurrentTXFreq")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateTXFreq(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("CurrentRXFreq")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRXFreq(byArray);
                    continue;
                }
                if (string.equalsIgnoreCase("Lan1")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateLan1(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("Lan2")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateLan2(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ControlModule")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateControlModule(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("ReceiverState")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateReceiverState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("RxSynthesizer")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateRxSynthesizer(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("PowerSupply")) {
                    if (this.m_statusPanelScreen.isConvBrApplication() || this.m_statusPanelScreen.is3600Application()) continue;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerSupply(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("GetPowerSupplyStateNew")) {
                    if (!this.m_statusPanelScreen.isConvBrApplication() && !this.m_statusPanelScreen.is3600Application()) continue;
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updatePowerSupplyNew(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("InfrastructureInterface")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateInfrastructureInterface(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("SacFrequencyReference")) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateSacFrequencyReference(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("OverVoltageAlarm") && this.m_statusPanelScreen.is3600Application()) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateOverVoltageAlarm(Convert.toInteger((byte[])byArray));
                    continue;
                }
                if (string.equalsIgnoreCase("AnalogInfrastructureState") && this.m_statusPanelScreen.isIR3600Application()) {
                    byArray = (byte[])realTimeDataObject.getValue(string);
                    this.updateAnalogInfrastructureState(Convert.toInteger((byte[])byArray));
                    continue;
                }
                bl = false;
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateRealTimeData - Name not found", (Throwable)notFoundException);
        }
        LOG.exit("updateRealTimeData");
        return bl;
    }

    public void updateTXFreq(byte[] byArray) {
        if (!this.isApplicable(TX_FREQUENCY_CVBR_3600)) {
            return;
        }
        Integer n = Convert.toInteger((byte[])byArray);
        Double d = (double)n.intValue() / 1000000.0;
        String string = Double.toString(d);
        this._txFrequencyPanel.setValue(string + " MHz");
    }

    public void updateRXFreq(byte[] byArray) {
        if (!this.isApplicable(RX_FREQUENCY_CVBR_3600)) {
            return;
        }
        Integer n = Convert.toInteger((byte[])byArray);
        Double d = (double)n.intValue() / 1000000.0;
        String string = Double.toString(d);
        this._rxFrequencyPanel.setValue(string + " MHz");
    }

    private void updateExciter(int n) {
        LOG.enter("updateExciter", new Object[]{n});
        switch (n) {
            case 1: {
                this._exciterPanel.setValue(OPERATIONAL);
                break;
            }
            case 0: {
                this._exciterPanel.setValue(FAILED);
                break;
            }
            case 15: {
                this._exciterPanel.setValue(NOT_AVAILABLE);
                break;
            }
            case 16: {
                this._exciterPanel.setValue("NOT APPLICABLE");
                break;
            }
            default: {
                this._exciterPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Exciter = : " + this._exciterPanel.getValue() + "\n");
        LOG.exit("updateExciter");
    }

    private void updateTxSynthesizer(int n) {
        LOG.enter("updateTxSynthesizer", new Object[]{n});
        switch (n) {
            case 1: {
                this._txSynthesizerPanel.setValue(LOCKED);
                break;
            }
            case 2: {
                this._txSynthesizerPanel.setValue(UNLOCKED);
                break;
            }
            case 16: {
                this._txSynthesizerPanel.setValue("NOT APPLICABLE");
                break;
            }
            default: {
                this._txSynthesizerPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Tx Synthesizer = : " + this._txSynthesizerPanel.getValue() + "\n");
        LOG.exit("updateTxSynthesizer");
    }

    private void updatePowerAmplifier(int n) {
        LOG.enter("updatePowerAmplifier", new Object[]{n});
        switch (n) {
            case 0: {
                this._powerAmplifierPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._powerAmplifierPanel.setValue(OPERATIONAL);
                break;
            }
            case 4: {
                this._powerAmplifierPanel.setValue("ACTIVE");
                break;
            }
            case 15: {
                this._powerAmplifierPanel.setValue(NOT_AVAILABLE);
                break;
            }
            case 16: {
                this._powerAmplifierPanel.setValue("NOT APPLICABLE");
                break;
            }
            default: {
                this._powerAmplifierPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Amplifier = : " + this._powerAmplifierPanel.getValue() + "\n");
        LOG.exit("updatePowerAmplifier");
    }

    private void updateExternalRef(int n) {
        LOG.enter("updateExternalRef", new Object[]{n});
        switch (n) {
            case 0: {
                this._externalRefPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._externalRefPanel.setValue(OPERATIONAL);
                break;
            }
            case 15: {
                this._externalRefPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._externalRefPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("External Reference = " + this._externalRefPanel.getValue() + "\n");
        LOG.exit("updateExternalRef");
    }

    private void updateIntegratedRefA(int n) {
        LOG.enter("updateIntegratedRefA", new Object[]{n});
        switch (n) {
            case 1: {
                this._integratedRefAPanel.setValue(OPERATIONAL);
                break;
            }
            case 2: {
                this._integratedRefAPanel.setValue("ACTIVE");
                break;
            }
            case 3: {
                this._integratedRefAPanel.setValue(DISABLED);
                break;
            }
            case 0: {
                this._integratedRefAPanel.setValue(FAILED);
                break;
            }
            case 15: {
                this._integratedRefAPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._integratedRefAPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Integrated Reference A = " + this._integratedRefAPanel.getValue() + "\n");
        LOG.exit("updateIntegratedRefA");
    }

    private void updateIntegratedRefB(int n) {
        LOG.enter("updateIntegratedRefB", new Object[]{n});
        switch (n) {
            case 1: {
                this._integratedRefBPanel.setValue(OPERATIONAL);
                break;
            }
            case 2: {
                this._integratedRefBPanel.setValue("ACTIVE");
                break;
            }
            case 3: {
                this._integratedRefBPanel.setValue(DISABLED);
                break;
            }
            case 0: {
                this._integratedRefBPanel.setValue(FAILED);
                break;
            }
            case 15: {
                this._integratedRefBPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._integratedRefBPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Integrated Reference B = " + this._integratedRefBPanel.getValue() + "\n");
        LOG.exit("updateIntegratedRefB");
    }

    private void updateLan1(int n) {
        LOG.enter("updateLan1", new Object[]{n});
        switch (n) {
            case 1: {
                this._lan1Panel.setValue(OPERATIONAL);
                break;
            }
            case 0: {
                this._lan1Panel.setValue(FAILED);
                break;
            }
            case 2: {
                this._lan1Panel.setValue("ACTIVE");
                break;
            }
            case 3: {
                this._lan1Panel.setValue(DISABLED);
                break;
            }
            case 15: {
                this._lan1Panel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._lan1Panel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Lan 1 = " + this._lan1Panel.getValue() + "\n");
        LOG.exit("updateLan1");
    }

    private void updateLan2(int n) {
        LOG.enter("updateLan2", new Object[]{n});
        switch (n) {
            case 1: {
                this._lan2Panel.setValue(OPERATIONAL);
                break;
            }
            case 0: {
                this._lan2Panel.setValue(FAILED);
                break;
            }
            case 2: {
                this._lan2Panel.setValue("ACTIVE");
                break;
            }
            case 3: {
                this._lan2Panel.setValue(DISABLED);
                break;
            }
            case 15: {
                this._lan2Panel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._lan2Panel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Lan 2 = " + this._lan2Panel.getValue() + "\n");
        LOG.exit("updateLan2");
    }

    private void updateControlModule(int n) {
        LOG.enter("updateControlModule", new Object[]{n});
        switch (n) {
            case 0: {
                this._controlPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._controlPanel.setValue(OPERATIONAL);
                break;
            }
            case 15: {
                this._controlPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._controlPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Control = : " + this._controlPanel.getValue() + "\n");
        LOG.exit("updateControlModule");
    }

    private void updateReceiverState(int n) {
        LOG.enter("updateReceiverState", new Object[]{n});
        switch (n) {
            case 0: {
                this._receiverPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._receiverPanel.setValue(OPERATIONAL);
                break;
            }
            case 15: {
                this._receiverPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._receiverPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver = : " + this._receiverPanel.getValue() + "\n");
        LOG.exit("updateReceiverState");
    }

    private void updateRxSynthesizer(int n) {
        LOG.enter("updateRxSynthesizer", new Object[]{n});
        switch (n) {
            case 1: {
                this._rxSynthesizerPanel.setValue(LOCKED);
                break;
            }
            case 2: {
                this._rxSynthesizerPanel.setValue(UNLOCKED);
                break;
            }
            default: {
                this._rxSynthesizerPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Receiver Synthesizer = : " + this._rxSynthesizerPanel.getValue() + "\n");
        LOG.exit("updateRxSynthesizer");
    }

    private void updatePowerSupplyNew(int n) {
        LOG.enter("updatePowerSupply", new Object[]{n});
        switch (n) {
            case 0: {
                this._powerSupplyPanel.setValue(AC_POWER);
                break;
            }
            case 1: {
                this._powerSupplyPanel.setValue(DC_POWER);
                break;
            }
            case 2: {
                this._powerSupplyPanel.setValue(PS_FAILED);
                break;
            }
            case 3: {
                this._powerSupplyPanel.setValue(PS_SHARED);
                break;
            }
            default: {
                this._powerSupplyPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Supply = : " + this._powerSupplyPanel.getValue() + "\n");
        LOG.exit("updatePowerSupply");
    }

    private void updatePowerSupply(int n) {
        LOG.enter("updatePowerSupply", new Object[]{n});
        switch (n) {
            case 0: {
                this._powerSupplyPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._powerSupplyPanel.setValue(OPERATIONAL);
                break;
            }
            case 2: {
                this._powerSupplyPanel.setValue(PS_SHARED);
                break;
            }
            case 15: {
                this._powerSupplyPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._powerSupplyPanel.setValue(UNKNOWN);
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Power Supply = : " + this._powerSupplyPanel.getValue() + "\n");
        LOG.exit("updatePowerSupply");
    }

    private void updateInfrastructureInterface(int n) {
        LOG.enter("updateInfrastructureInterface", new Object[]{n});
        if (this.m_statusPanelScreen.isServiceMode()) {
            this._infraLinkPanel.setValue(EMPTY);
        } else {
            switch (n) {
                case 0: {
                    this._infraLinkPanel.setValue(FAILED);
                    break;
                }
                case 1: {
                    this._infraLinkPanel.setValue(OPERATIONAL);
                    break;
                }
                case 15: {
                    this._infraLinkPanel.setValue(NOT_CONFIGURED);
                    break;
                }
                default: {
                    this._infraLinkPanel.setValue(UNKNOWN);
                    LOG.warn((Object)("Default condition, state is " + n));
                }
            }
        }
        this.m_statusPanelScreen.appendString(this.m_stationStatusPanel.getDateAndTime() + " = :");
        this.m_statusPanelScreen.appendString("Infrastructure Link = : " + this._infraLinkPanel.getValue() + "\n");
        LOG.exit("updateInfrastructureInterface");
    }

    private void updateSacFrequencyReference(int n) {
        LOG.enter("updateSacFrequencyReference", new Object[]{n});
        switch (n) {
            case 0: {
                this._internalFreqRefPanel.setValue(FAILED);
                break;
            }
            case 1: {
                this._internalFreqRefPanel.setValue(OPERATIONAL);
                break;
            }
            case 2: {
                this._internalFreqRefPanel.setValue(WARMING_UP);
                break;
            }
            case 15: {
                this._internalFreqRefPanel.setValue(NOT_AVAILABLE);
                break;
            }
            default: {
                this._internalFreqRefPanel.setValue(UNKNOWN);
                LOG.warn((Object)("Default condition, state is " + n));
            }
        }
        LOG.exit("updateSacFrequencyReference");
    }

    private void updateOverVoltageAlarm(int n) {
        String string = OVERVOLTAGE_ALARM.get(new Integer(n));
        if (null != string) {
            this._overVoltageAlarmPanel.setValue(string);
        } else {
            this._overVoltageAlarmPanel.setValue(UNKNOWN);
            LOG.warn((Object)("Unknown value: " + n));
        }
    }

    private void updateAnalogInfrastructureState(int n) {
        if (this.m_statusPanelScreen.isServiceMode()) {
            this._analogInfrastructureStatePanel.setValue(EMPTY);
        } else {
            this._analogInfrastructureStatePanel.setValue(ANALOG_INFRASTRUCTURE_STATE.get(new Integer(n)));
        }
    }

    public void writeInitialDataToFile() {
        LOG.enter("writeInitialDataToFile");
        String string = "=================================================================================\n";
        string = string + "            STATION INFORMATION :       " + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "System Id : " + this._systemIdPanel.getValue() + "\n";
        string = string + "Site ID: " + this._siteIdPanel.getValue() + "\n";
        string = string + "Subsite ID: " + this._subsiteIdPanel.getValue() + "\n";
        string = string + "Receiver Frequency: " + this._rxFrequencyPanel.getValue() + "\n";
        string = string + "Transmitter Frequency: " + this._txFrequencyPanel.getValue() + "\n";
        string = string + "Station Name     : " + this._stationNamePanel.getValue() + "\n";
        string = string + "Site Name     : " + this._siteNamePanel.getValue() + "\n";
        string = string + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "            INITIAL HARDWARE STATUS AT LOG TIME :    " + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "Infrastructure Link : " + this._infraLinkPanel.getValue() + "\n";
        string = string + "Power Suply : " + this._powerSupplyPanel.getValue() + "\n";
        string = string + "Receiver Synthesizer : " + this._rxSynthesizerPanel.getValue() + "\n";
        string = string + "Control : " + this._controlPanel.getValue() + "\n";
        string = string + "External Reference : " + this._externalRefPanel.getValue() + "\n";
        string = string + "Integrated Reference A : " + this._integratedRefAPanel.getValue() + "\n";
        string = string + "Integrated Reference B : " + this._integratedRefBPanel.getValue() + "\n";
        string = string + "Power Amplifier : " + this._powerAmplifierPanel.getValue() + "\n";
        string = string + "Transmitter Synthesizer : " + this._txSynthesizerPanel.getValue() + "\n";
        string = string + "Exciter : " + this._exciterPanel.getValue() + "\n";
        string = string + "Receiver : " + this._receiverPanel.getValue() + "\n";
        string = string + "LAN 1 : " + this._lan1Panel.getValue() + "\n";
        string = string + "LAN 2 : " + this._lan2Panel.getValue() + "\n";
        string = string + INTERNAL_FREQUENCY_REFERENCE + " : " + this._internalFreqRefPanel.getValue() + "\n";
        string = string + "\n";
        string = string + "=================================================================================" + "\n";
        string = string + "\n";
        this.m_statusPanelScreen.appendString(string);
        LOG.exit("writeInitialDataToFile");
    }

    static {
        HARDWARESTATUS_FIELDS.put(PANEL_STATION_CONFIGURATION, new String[]{"Panel", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(PANEL_HARDWARE_STATUS, new String[]{"Panel", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(SITE_ID, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(SYSTEM_ID, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(STATION_NAME, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(SITE_NAME, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(TX_FREQUENCY_CVBR_3600, new String[]{"Field", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(TX_FREQUENCY_MSBR_HPD_ISR, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio"});
        HARDWARESTATUS_FIELDS.put(RX_FREQUENCY_CVBR_3600, new String[]{"Field", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(RX_FREQUENCY_MSBR_HPD_ISR, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio"});
        HARDWARESTATUS_FIELDS.put(SUBSITE_ID, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600"});
        HARDWARESTATUS_FIELDS.put(EXCITER, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(EXTERNAL_REF, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(TX_SYNTHESIZER, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(INTEGRATED_REFA, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(INTEGRATED_REFB, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(CONTROL, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(RX_SYNTHESIZER, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(RECEIVER, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(POWER_AMPLIFIER, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(POWER_SUPPLY, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(LAN1, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(LAN2, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(DIGITAL_INFRASTRUCTURE_LINK, new String[]{"Field", "HPDBR", "ISR", "STR 3000 Simulcast Radio", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(INTERNAL_FREQUENCY_REFERENCE, new String[]{"Field", "ISR", "CONVBR", "MSBR3600", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(ANALOG_LINK_STATE, new String[]{"Field", "IRBR3600"});
        HARDWARESTATUS_FIELDS.put(OVER_VOLTAGE_ALARM, new String[]{"Field", "MSBR3600", "IRBR3600"});
        POWER_AMPLIFIER_BACKGROUND_COLORS = new HashMap();
        LAN_INTEGRATED_BACKGROUND_COLORS = new HashMap();
    }
}

