/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssLogger;
import css.core.util.component.CSSComboItem;
import css.core.util.component.CSSJComboBox;
import css.core.util.component.CSSJSpinner;
import css.core.util.component.CssJSlider;
import css.core.util.component.GenericListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.UIInternalFrame;

public class CarrierSquelchTabGUI
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final int MAX_SPKR_LVL = 20;
    protected static final int MIN_SPKR_LVL = 0;
    private static final int SLIDER_MAX = 127;
    private static String STATUS_CHANNEL_125 = "Press this button to set CSQ Alignment channel bandwidth to 12.5 kHz.";
    private static String STATUS_CHANNEL_25 = "Press this button to set CSQ Alignment channel bandwidth to 25 kHz.";
    private static String STATUS_BTN_100 = "Press this button to set Carrier Squelch Set Level Value to maximum value.";
    private static String STATUS_BTN_0 = "Press this button to set Carrier Squelch Set Level Value to minimum value.";
    private static String STATUS_BTN_INC_10 = "Press this button to increment Carrier Squelch Set Level Value by 10.";
    private static String STATUS_BTN_DEC_10 = "Press this button to decrement Carrier Squelch Set Level Value by 10.";
    private static String STATUS_BTN_INC_1 = "Press this button to increment Carrier Squelch Set Level Value by 1.";
    private static String STATUS_BTN_DEC_1 = "Press this button to decrement Carrier Squelch Set Level Value by 1.";
    private static String STATUS_BTN_SAVE = "Press this button to command the device to save Carrier Squelch Set Level Value.";
    private static String STATUS_SPKR_VOLUME = "Set Speaker Volume Level, RANGE: 0 - 20 dB";
    private static String STATUS_RX_QUALIFIERS = "Select the Analog RX Qualifiers.";
    private static String STATUS_START_SINAD = "Press this button to Start/Stop SINAD measurement process.";
    public static final String START_SINAD_VALUE = "WAIT";
    public static String STOP_SINAD_VALUE = "";
    private static final int SPEAKER_VOLUME_MIN = 0;
    private static final int SPEAKER_VOLUME_MAX = 20;
    private static final CssLogger LOG = CssLogger.getCssLogger(CarrierSquelchTabGUI.class);
    public GenericListener m_sliderListener = new GenericListener();
    private UIInternalFrame m_window = null;
    private int m_speakerLevelValue = 10;
    private int m_nStoredCSQLevelValue = 0;
    public static final int SINAD_START_MODE = 1;
    public static final int SINAD_STOP_MODE = 2;
    private int m_SINADMode = 2;
    public static final int CSQ_STATE_START_MODE = 1;
    public static final int CSQ_STATE_STOP_MODE = 2;
    private int m_CSQState_mode = 0;
    public static final int CSQ_MANUAL_MODE = 1;
    public static final int CSQ_SINAD_MODE = 2;
    public static final int CSQ_ABOVE_SET_LEVEL = 0;
    public static final int CSQ_BELOW_SET_LEVEL = 1;
    public static final int CSQ_DEFAULT_SET_LEVEL = 2;
    private int m_CSQMode = 1;
    private JButton btnChannel125;
    private JButton btnChannel25;
    private JButton btnDec1;
    private JButton btnDec10;
    private JButton btnInc1;
    private JButton btnInc10;
    private JButton btnSave;
    private JButton btnSet0;
    private JButton btnSet127;
    private JButton btnStartStopSINAD;
    private JCheckBox chkSINADEnabled;
    private JComboBox cmbRxQualifiers;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JLabel labBandwidth;
    private JLabel labCSQState;
    private JLabel labCSQStateValue;
    private JLabel labCurrentFrequency;
    private JLabel labCurrentThreshodVal;
    private JLabel labInfoBandwidth;
    private JLabel labInfoSINADValue;
    private JLabel labRxQualifiers;
    private JLabel labSINADValue;
    private JLabel labSpeakerVolume;
    private JSlider m_slider;
    private JPanel panelAdjustment;
    private JPanel panelChoice;
    private JPanel panelInfo;
    private JPanel panelSINAD;
    private JSpinner spinSpeakerVolume;

    public CarrierSquelchTabGUI() {
        this.initComponents();
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        this.setWindow(uIInternalFrame);
        statusBarListener.registerComponent((Component)this.btnChannel125, STATUS_CHANNEL_125);
        statusBarListener.registerComponent((Component)this.btnChannel25, STATUS_CHANNEL_25);
        statusBarListener.registerComponent((Component)this.btnSet127, STATUS_BTN_100);
        statusBarListener.registerComponent((Component)this.btnSet0, STATUS_BTN_0);
        statusBarListener.registerComponent((Component)this.btnDec1, STATUS_BTN_DEC_1);
        statusBarListener.registerComponent((Component)this.btnInc1, STATUS_BTN_INC_1);
        statusBarListener.registerComponent((Component)this.btnDec10, STATUS_BTN_DEC_10);
        statusBarListener.registerComponent((Component)this.btnInc10, STATUS_BTN_INC_10);
        statusBarListener.registerComponent((Component)this.btnSave, STATUS_BTN_SAVE);
        statusBarListener.registerComponent((Component)((JSpinner.NumberEditor)this.spinSpeakerVolume.getEditor()).getTextField(), STATUS_SPKR_VOLUME);
        statusBarListener.registerComponent((Component)this.cmbRxQualifiers, STATUS_RX_QUALIFIERS);
        statusBarListener.registerComponent((Component)this.btnStartStopSINAD, STATUS_START_SINAD);
        this.chkSINADEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (CarrierSquelchTabGUI.this.m_CSQMode) {
                    case 2: {
                        CarrierSquelchTabGUI.this.m_CSQMode = 1;
                        break;
                    }
                    case 1: {
                        CarrierSquelchTabGUI.this.m_CSQMode = 2;
                    }
                }
                CarrierSquelchTabGUI.this.updateToSINADMode();
            }
        });
        this.setVisible(true);
    }

    public void setStoredCSQSetLevel(int n) {
        this.m_nStoredCSQLevelValue = n;
    }

    public int getStoredCSQSetLevel() {
        return this.m_nStoredCSQLevelValue;
    }

    public int getCSQStateMode() {
        return this.m_CSQState_mode;
    }

    public void setCSQStateMode(int n) {
        this.m_CSQState_mode = n;
    }

    public JCheckBox getCheckBoxSINAD() {
        return this.chkSINADEnabled;
    }

    private void updateToSINADMode() {
        switch (this.m_CSQMode) {
            case 1: {
                this.btnSet127.setEnabled(true);
                this.btnSet0.setEnabled(true);
                this.btnDec1.setEnabled(true);
                this.btnInc1.setEnabled(true);
                this.btnDec10.setEnabled(true);
                this.btnInc10.setEnabled(true);
                this.m_slider.setEnabled(true);
                this.cmbRxQualifiers.setEnabled(true);
                this.btnStartStopSINAD.setEnabled(false);
                this.labInfoSINADValue.setEnabled(false);
                this.labSINADValue.setEnabled(false);
                break;
            }
            case 2: {
                this.btnStartStopSINAD.setEnabled(true);
                this.labInfoSINADValue.setEnabled(true);
                this.labSINADValue.setEnabled(true);
                this.btnSet127.setEnabled(false);
                this.btnSet0.setEnabled(false);
                this.btnDec1.setEnabled(false);
                this.btnInc1.setEnabled(false);
                this.btnDec10.setEnabled(false);
                this.btnInc10.setEnabled(false);
                this.m_slider.setEnabled(false);
                this.cmbRxQualifiers.setEnabled(false);
            }
        }
    }

    public void updateCSQState(int n) {
        switch (n) {
            case 0: {
                this.labCSQStateValue.setText("OPEN");
                this.labCSQStateValue.setForeground(new Color(0, 170, 0));
                break;
            }
            case 1: {
                this.labCSQStateValue.setText("CLOSED");
                this.labCSQStateValue.setForeground(Color.red);
                break;
            }
            default: {
                this.labCSQStateValue.setText("N/A");
                this.labCSQStateValue.setForeground(Color.BLACK);
            }
        }
    }

    public JButton getBtnChannel_125() {
        return this.btnChannel125;
    }

    public JButton getBtnChannel_25() {
        return this.btnChannel25;
    }

    public void setCurrentChannel(String string) {
        this.labInfoBandwidth.setText(string);
    }

    public void setCurrentReceiverFrequency(String string) {
        this.labCurrentFrequency.setText(string);
    }

    public JButton getBtnSave() {
        return this.btnSave;
    }

    public JButton getBtnSINAD() {
        return this.btnStartStopSINAD;
    }

    public int getSINADMode() {
        return this.m_SINADMode;
    }

    public void setSINADMode(int n) {
        this.m_SINADMode = n;
        switch (this.m_SINADMode) {
            case 1: {
                this.btnStartStopSINAD.setText("Stop SINAD measurement");
                this.btnStartStopSINAD.setToolTipText("Stop SINAD measurement.");
                break;
            }
            case 2: {
                this.btnStartStopSINAD.setText("Start SINAD measurement");
                this.btnStartStopSINAD.setToolTipText("Start SINAD measurement.");
            }
        }
    }

    public boolean isSINADMeasurementStarted() {
        return this.getSINADMode() == 1;
    }

    public void setSINADValue(String string) {
        this.labSINADValue.setText(string);
    }

    public JSlider getThresholdSlider() {
        return this.m_slider;
    }

    public int getThresholdValue() {
        return this.m_slider.getValue();
    }

    private void updateThresholdLabel() {
        this.labCurrentThreshodVal.setText(new Integer(this.m_slider.getValue()).toString());
    }

    private CssJSlider createCssJSlider() {
        CssJSlider cssJSlider = new CssJSlider();
        cssJSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                CarrierSquelchTabGUI.this.updateThresholdLabel();
            }
        });
        cssJSlider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LOG.enter("actionPerformed");
                if (0 == "RELEASED".compareTo(actionEvent.getActionCommand())) {
                    CarrierSquelchTabGUI.this.m_sliderListener.notifyGuiListener();
                }
                LOG.exit("actionPerformed");
            }
        });
        return cssJSlider;
    }

    protected void setCSQGrayed(boolean bl) {
        for (Component component : this.panelInfo.getComponents()) {
            component.setEnabled(!bl);
        }
        this.panelInfo.setEnabled(!bl);
        for (Component component : this.panelAdjustment.getComponents()) {
            component.setEnabled(!bl);
        }
        this.panelAdjustment.setEnabled(!bl);
        for (Component component : this.panelChoice.getComponents()) {
            component.setEnabled(!bl);
        }
        this.panelChoice.setEnabled(!bl);
        for (Component component : this.jPanel1.getComponents()) {
            component.setEnabled(!bl);
        }
        this.jPanel1.setEnabled(!bl);
        for (Component component : this.panelSINAD.getComponents()) {
            component.setEnabled(!bl);
        }
        this.panelSINAD.setEnabled(!bl);
        if (!bl) {
            this.updateToSINADMode();
        }
    }

    public void setCurrentQualifier(int n) {
        this.cmbRxQualifiers.setSelectedIndex(n);
    }

    private void initComponents() {
        this.panelInfo = new JPanel();
        this.labBandwidth = new JLabel();
        this.labInfoBandwidth = new JLabel();
        this.jLabel3 = new JLabel();
        this.labCurrentFrequency = new JLabel();
        this.panelAdjustment = new JPanel();
        this.btnSet0 = new JButton();
        this.btnDec10 = new JButton();
        this.btnDec1 = new JButton();
        this.m_slider = this.createCssJSlider();
        this.btnInc1 = new JButton();
        this.btnInc10 = new JButton();
        this.btnSet127 = new JButton();
        this.jLabel1 = new JLabel();
        this.labCurrentThreshodVal = new JLabel();
        this.btnSave = new JButton();
        this.labCSQState = new JLabel();
        this.labCSQStateValue = new JLabel();
        this.panelChoice = new JPanel();
        this.btnChannel125 = new JButton();
        this.btnChannel25 = new JButton();
        this.jPanel1 = new JPanel();
        this.spinSpeakerVolume = new CSSJSpinner();
        this.labSpeakerVolume = new JLabel();
        this.labRxQualifiers = new JLabel();
        this.cmbRxQualifiers = new CSSJComboBox();
        this.panelSINAD = new JPanel();
        this.btnStartStopSINAD = new JButton();
        this.labInfoSINADValue = new JLabel();
        this.labSINADValue = new JLabel();
        this.chkSINADEnabled = new JCheckBox();
        this.setPreferredSize(new Dimension(660, 450));
        this.setRequestFocusEnabled(false);
        this.panelInfo.setBorder(BorderFactory.createTitledBorder("Information"));
        this.panelInfo.setName("boxInformation");
        this.labBandwidth.setText("Alignment Channel Bandwidth:");
        this.labBandwidth.setToolTipText("This read-only field displays the current channel bandwidth.");
        this.labBandwidth.setName("Alignment Channel Bandwidth label");
        this.labInfoBandwidth.setText("N/A");
        this.labInfoBandwidth.setToolTipText("Current Channel Bandwidth.");
        this.labInfoBandwidth.setName("Alignment Channel Bandwidth value");
        this.jLabel3.setText("Current Receiver Frequency:");
        this.jLabel3.setToolTipText("This read-only field displays the current receiver frequency for the base radio");
        this.jLabel3.setName("Current Receiver Frequency label");
        this.labCurrentFrequency.setText("N/A");
        this.labCurrentFrequency.setToolTipText("Current Receiver Frequency.");
        this.labCurrentFrequency.setName("Current Receiver Frequency value");
        GroupLayout groupLayout = new GroupLayout(this.panelInfo);
        this.panelInfo.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labBandwidth).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labCurrentFrequency, -1, -1, Short.MAX_VALUE).addComponent(this.labInfoBandwidth)).addContainerGap(433, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labBandwidth).addComponent(this.labInfoBandwidth)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.labCurrentFrequency))));
        this.panelAdjustment.setBorder(BorderFactory.createTitledBorder("Manual Adjustment"));
        this.panelAdjustment.setName("boxAdjustment");
        this.btnSet0.setFont(new Font("Tahoma", 0, 10));
        this.btnSet0.setText("CSQ Open");
        this.btnSet0.setToolTipText("Set Current CSQ Set Level value to 0%.");
        this.btnSet0.setName("CSQ Open button");
        this.btnSet0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnSet0ActionPerformed(actionEvent);
            }
        });
        this.btnDec10.setFont(new Font("Tahoma", 0, 10));
        this.btnDec10.setText("<<");
        this.btnDec10.setToolTipText("Decrement Current CSQ Set Level value by 10.");
        this.btnDec10.setName("Dec 10 button");
        this.btnDec10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnDec10ActionPerformed(actionEvent);
            }
        });
        this.btnDec1.setFont(new Font("Tahoma", 0, 10));
        this.btnDec1.setText("<");
        this.btnDec1.setToolTipText("Decrement Current CSQ Set Level value by 1.");
        this.btnDec1.setName("Dec 1 button");
        this.btnDec1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnDec1ActionPerformed(actionEvent);
            }
        });
        this.m_slider.setMaximum(127);
        this.m_slider.setMinorTickSpacing(7);
        this.m_slider.setPaintTicks(true);
        this.m_slider.setToolTipText("Current CSQ Set Level.");
        this.m_slider.setValue(0);
        this.m_slider.setName("Level slider");
        this.btnInc1.setFont(new Font("Tahoma", 0, 10));
        this.btnInc1.setText(">");
        this.btnInc1.setToolTipText("Increment Current CSQ Set Level Value by 1.");
        this.btnInc1.setName("Inc 1 button");
        this.btnInc1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnInc1ActionPerformed(actionEvent);
            }
        });
        this.btnInc10.setFont(new Font("Tahoma", 0, 10));
        this.btnInc10.setText(">>");
        this.btnInc10.setToolTipText("Increment Current CSQ Set Level Value by 10.");
        this.btnInc10.setName("Inc 10 button");
        this.btnInc10.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnInc10ActionPerformed(actionEvent);
            }
        });
        this.btnSet127.setFont(new Font("Tahoma", 0, 10));
        this.btnSet127.setText("CSQ Tight");
        this.btnSet127.setToolTipText("Set Current CSQ Set Level Value to 100%.");
        this.btnSet127.setName("CSQ Tight button");
        this.btnSet127.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CarrierSquelchTabGUI.this.btnSet127ActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setText("Current CSQ Set Level:");
        this.jLabel1.setToolTipText("Current CSQ Set Level");
        this.jLabel1.setName("Current CSQ Set Level label");
        this.labCurrentThreshodVal.setText("N/A");
        this.labCurrentThreshodVal.setToolTipText("CSQ Set Level.");
        this.labCurrentThreshodVal.setName("Current CSQ Set Level value");
        this.btnSave.setText("Save");
        this.btnSave.setToolTipText("Saves Current CSQ Set Level on the device.");
        this.btnSave.setMaximumSize(new Dimension(60, 23));
        this.btnSave.setName("Save button");
        this.btnSave.setPreferredSize(new Dimension(60, 23));
        this.labCSQState.setText("CSQ State:");
        this.labCSQState.setToolTipText("This field works with the CSQ set level and displays the following values: OPEN, CLOSED");
        this.labCSQState.setName("CSQ State label");
        this.labCSQStateValue.setText("N/A");
        this.labCSQStateValue.setToolTipText("CSQ State.");
        this.labCSQStateValue.setName("CSQ State value");
        GroupLayout groupLayout2 = new GroupLayout(this.panelAdjustment);
        this.panelAdjustment.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.labCSQState).addGap(42, 42, 42).addComponent(this.labCSQStateValue, -1, 509, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.btnSet0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDec10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDec1, -2, 41, -2).addGap(0, 0, 0).addComponent(this.m_slider, -2, 131, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnInc1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnInc10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSet127, -2, 81, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave, -1, 102, Short.MAX_VALUE)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel1, -2, 219, -2).addGap(28, 28, 28).addComponent(this.labCurrentThreshodVal))).addContainerGap()));
        groupLayout2.linkSize(0, this.btnSet0, this.btnSet127);
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.labCurrentThreshodVal)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSet127).addComponent(this.btnInc10).addComponent(this.btnInc1).addComponent(this.btnSave, -2, -1, -2)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnSet0).addComponent(this.btnDec10).addComponent(this.btnDec1)).addComponent(this.m_slider, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCSQStateValue).addComponent(this.labCSQState))));
        this.panelChoice.setBorder(BorderFactory.createTitledBorder("Alignment Channel Bandwidth"));
        this.panelChoice.setName("boxChoice");
        this.btnChannel125.setText("12.5 kHz");
        this.btnChannel125.setToolTipText("Set CSQ Alignment channel bandwidth to 12.5 kHz");
        this.btnChannel125.setName("12 kHz button");
        this.btnChannel25.setText("25 kHz");
        this.btnChannel25.setToolTipText("Set CSQ Alignment channel bandwidth to 25 kHz");
        this.btnChannel25.setMaximumSize(new Dimension(75, 23));
        this.btnChannel25.setMinimumSize(new Dimension(75, 23));
        this.btnChannel25.setName("25 kHz button");
        this.btnChannel25.setPreferredSize(new Dimension(75, 23));
        GroupLayout groupLayout3 = new GroupLayout(this.panelChoice);
        this.panelChoice.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.btnChannel125, -2, 130, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnChannel25, -2, 136, -2).addContainerGap(343, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnChannel125).addComponent(this.btnChannel25, -2, -1, -2))));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Local Speaker Control"));
        this.spinSpeakerVolume.setModel(new SpinnerNumberModel(10, 0, 20, 1));
        this.spinSpeakerVolume.setToolTipText("Local Speaker Volume.");
        this.spinSpeakerVolume.setName("Local Speaker Volume spinner");
        this.spinSpeakerVolume.setValue(this.m_speakerLevelValue);
        this.labSpeakerVolume.setText("Local Speaker Volume:");
        this.labSpeakerVolume.setToolTipText("This field is used to set the local speaker volume.");
        this.labSpeakerVolume.setName("Local Speaker Volume label");
        this.labRxQualifiers.setText("Analog Rx Qualifiers:");
        this.labRxQualifiers.setToolTipText("This field is used to select the receive qualifiers. ");
        this.labRxQualifiers.setName("Analog Rx Qualifiers label");
        this.cmbRxQualifiers.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cmbRxQualifiers.setToolTipText("Rx Qualifiers.");
        this.cmbRxQualifiers.setName("Analog Rx Qualifiers combo");
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.labSpeakerVolume).addGap(18, 18, 18).addComponent(this.spinSpeakerVolume, -2, 42, -2).addGap(136, 136, 136).addComponent(this.labRxQualifiers).addGap(18, 18, 18).addComponent(this.cmbRxQualifiers, -2, 148, -2).addContainerGap(48, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSpeakerVolume).addComponent(this.labRxQualifiers).addComponent(this.cmbRxQualifiers, -2, -1, -2).addComponent(this.spinSpeakerVolume, -2, 20, -2))));
        this.panelSINAD.setBorder(BorderFactory.createTitledBorder("SINAD Measurement "));
        this.btnStartStopSINAD.setText("Start SINAD measurement");
        this.btnStartStopSINAD.setToolTipText("This button is used to start/stop the SINAD measurement for the selected Alignment Channel Bandwidth. ");
        this.btnStartStopSINAD.setName("Sinad measurement button");
        this.labInfoSINADValue.setText("SINAD measured value:");
        this.labInfoSINADValue.setToolTipText("Displays the current SINAD measurement");
        this.labInfoSINADValue.setName("Sinad measurement label");
        this.labSINADValue.setText("N/A");
        this.labSINADValue.setToolTipText("SINAD measured value");
        this.labSINADValue.setName("Sinad measurement value");
        this.chkSINADEnabled.setText("SINAD measurement");
        this.chkSINADEnabled.setToolTipText("Enable/Disable SINAD measurement process ");
        this.chkSINADEnabled.setName("Sinad measurement checkbox");
        GroupLayout groupLayout5 = new GroupLayout(this.panelSINAD);
        this.panelSINAD.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnStartStopSINAD, GroupLayout.Alignment.TRAILING).addGroup(groupLayout5.createSequentialGroup().addComponent(this.chkSINADEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 34, -2))).addGap(142, 142, 142).addComponent(this.labInfoSINADValue, -2, 129, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labSINADValue).addContainerGap(161, Short.MAX_VALUE)));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.chkSINADEnabled).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 8, Short.MAX_VALUE).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnStartStopSINAD).addComponent(this.labSINADValue).addComponent(this.labInfoSINADValue))));
        GroupLayout groupLayout6 = new GroupLayout(this);
        this.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addContainerGap().addGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelAdjustment, -1, -1, Short.MAX_VALUE).addComponent(this.panelInfo, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.panelChoice, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.panelSINAD, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout6.createSequentialGroup().addGap(6, 6, 6).addComponent(this.panelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelChoice, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelAdjustment, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.panelSINAD, -2, -1, -2).addContainerGap(32, Short.MAX_VALUE)));
    }

    private void btnInc1ActionPerformed(ActionEvent actionEvent) {
        int n = this.m_slider.getValue();
        if (n < this.m_slider.getMaximum()) {
            this.m_slider.setValue(n + 1);
            this.m_sliderListener.notifyGuiListener();
        }
        this.setStoredCSQSetLevel(n);
    }

    private void btnDec1ActionPerformed(ActionEvent actionEvent) {
        int n = this.m_slider.getValue();
        if (n > this.m_slider.getMinimum()) {
            this.m_slider.setValue(n - 1);
            this.m_sliderListener.notifyGuiListener();
        }
        this.setStoredCSQSetLevel(n);
    }

    private void btnDec10ActionPerformed(ActionEvent actionEvent) {
        int n = this.m_slider.getValue();
        if (n > 10) {
            this.m_slider.setValue(n - 10);
        } else {
            this.m_slider.setValue(this.m_slider.getMinimum());
        }
        this.setStoredCSQSetLevel(n);
        this.m_sliderListener.notifyGuiListener();
    }

    private void btnSet0ActionPerformed(ActionEvent actionEvent) {
        this.m_slider.setValue(0);
        this.setStoredCSQSetLevel(0);
        this.m_sliderListener.notifyGuiListener();
    }

    private void btnInc10ActionPerformed(ActionEvent actionEvent) {
        int n = this.m_slider.getValue();
        if (n < this.m_slider.getMaximum() - 10) {
            this.m_slider.setValue(n + 10);
        } else {
            this.m_slider.setValue(this.m_slider.getMaximum());
        }
        this.setStoredCSQSetLevel(n);
        this.m_sliderListener.notifyGuiListener();
    }

    private void btnSet127ActionPerformed(ActionEvent actionEvent) {
        this.m_slider.setValue(127);
        this.setStoredCSQSetLevel(127);
        this.m_sliderListener.notifyGuiListener();
    }

    protected void updateThresholdLevel(Integer n) {
        this.m_slider.setValue(n);
        this.updateThresholdLabel();
    }

    protected void setWindow(UIInternalFrame uIInternalFrame) {
        this.m_window = uIInternalFrame;
    }

    protected UIInternalFrame getWindow() {
        return this.m_window;
    }

    public int getSpeakerLevelValue() {
        return this.m_speakerLevelValue;
    }

    public void setSpeakerLevelValue(int n) {
        int n2 = 0;
        if (n <= 20 && n >= 0) {
            n2 = 20 - n;
        }
        this.m_speakerLevelValue = n2;
    }

    protected void setRxQualifiersModel(DefaultComboBoxModel<CSSComboItem> defaultComboBoxModel) {
        this.cmbRxQualifiers.setModel(defaultComboBoxModel);
    }

    public CSSJSpinner getSpinComponent() {
        return (CSSJSpinner)this.spinSpeakerVolume;
    }

    protected Integer getSpeakerVolumeValue() {
        int n = 0;
        int n2 = (Integer)this.spinSpeakerVolume.getValue();
        if (n2 <= 20 && n2 >= 0) {
            n = 20 - n2;
        }
        return n;
    }

    public CSSJComboBox getRxQualifiersComponent() {
        return (CSSJComboBox)this.cmbRxQualifiers;
    }

    public CSSComboItem getRxQualifiersValue() {
        return (CSSComboItem)this.cmbRxQualifiers.getSelectedItem();
    }
}

