/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.util.component.CSSJTextField;
import css.core.util.component.GenericListener;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import pnm.ui.UIInternalFrame;

public class RxWirelinePanel
extends JPanel {
    protected static final String TOOLTIP_PEAK_AUDIO_LEVEL = "Specify the peak audio level. The peak is 4.4 dB above Rx Wireline level.";
    protected static final String STAT_WIRELINE_LINE1 = "Current Rx Wireline Level. Range: -20 to 0 dBm.";
    protected static final String TOOLTIP_STAT_WIRELINE_LINE1 = "Specify the Rx wireline level desired for a received RF signal at 60% of the rated system deviation.";
    protected static final String STAT_WIRELINE_LO_BOOST = "Lo Boost Adjust Level. Range: 0 to 6 dB.";
    protected static final String TOOLTIP_WIRELINE_LO_BOOST = "Specify how many dB's the LO Boost level is below the Reference Level.";
    protected static final String STAT_WIRELINE_HI_BOOST = "Hi Boost Adjust Level. Range: 0 to 9 dB.";
    protected static final String TOOLTIP_WIRELINE_HI_BOOST = "Specify how many dB's the Hi Boost level is below the Reference Level.";
    protected static final String STAT_WIRELINE_HI_BOOST_FREQ = "Hi Boost Frequency. Range: 2000 to 3000 Hz.";
    protected static final String TOOLTIP_WIRELINE_HI_BOOST_FREQ = "Specify the frequency used for Base Station to generate a Hi Boost Adjust Level tone.";
    protected static final String STAT_WIRELINE_STATUS = "Status Tone/ALMT Level Below Peak Audio. Range: -20 to 0 dB.";
    protected static final String TOOLTIP_WIRELINE_STATUS = "Specify the offset that the status tone level is below the peak audio level.";
    protected static final String STAT_WIRELINE_ALERT = "Alert Tone Level Below Peak Audio. Range: -45 to 0 dB.";
    protected static final String TOOLTIP_WIRELINE_ALERT = "Specify the offset that the alert tone level is below the peak audio level.";
    protected static final String STAT_WL_SAVE = "Click the save button to save the set Rx Wireline Levels.";
    protected static final String TOOLTIP_WL_SAVE = "Click the save button to save the set Rx Wireline Levels.";
    private static final String PEAK_AUDIO_LEVEL_ABOVE_RX_WIRELINE = "4.4";
    private static final String PEAK_AUDIO_LEVEL_LABEL = "Peak Audio Level";
    private static final String RX_WIRELINE_LEVEL_LABEL = "Rx Wireline Level (1kHz)";
    private static final String STORED_RX_WIRELINE_LEVEL_LABEL = "Stored Rx Wireline Level";
    private static final String LO_BOOST_ADJUST_LEVEL_LABEL = "LO Boost Adjust Level";
    private static final String STORED_LO_BOOST_ADJUST_LEVEL_LABEL = "Stored LO Boost Adjust Level";
    private static final String HI_BOOST_ADJUST_LEVEL_LABEL = "Hi Boost Adjust Level";
    private static final String STORED_HI_BOOST_ADJUST_LEVEL_LABEL = "Stored Hi Boost Adjust Level";
    private static final String HI_BOOST_FREQUENCY_LABEL = "Hi Boost Frequency";
    private static final String STORED_HI_BOOST_FREQUENCY_LABEL = "Stored Hi Boost Frequency";
    private static final String STATUS_TONE_ALMT_LEVEL_BELOW_PEAK_AUDIO_LABEL = "Status Tone/ALMT Level Below Peak Audio";
    private static final String STORED_STATUS_TONE_ALMT_LEVEL_BELOW_PEAK_AUDIO_LABEL = "Stored Status Tone/ALMT Level Below Peak Audio";
    private static final String TONE_ON_OFF_RX_WIRELINE_BUTTON_ID = "Rx Wireline Tone On/Off";
    private static final String TONE_ON_OFF_LO_BOOST_ADJUST_BUTTON_ID = "LO Boost Adjust Tone On/Off";
    private static final String TONE_ON_OFF_HI_BOOST_ADJUST_BUTTON_ID = "Hi Boost Adjust Tone On/Off";
    private static final String TONE_ON_OFF_STATUS_TONE_BUTTON_ID = "Status Tone Tone On/Off";
    private static final String SAVE_LABEL = "Save";
    private static final String TONE_ON_LABEL = "Tone On";
    private static final long serialVersionUID = 1L;
    private SummitAlignmentScreen m_screen;
    private StatusBarListener m_statusBarListener;
    private UIInternalFrame m_window;
    private boolean m_bSaveButtonPush = false;
    public GenericListener m_oGenericListener = new GenericListener();
    private boolean isHiBoostOn = false;
    private boolean isLoBoostOn = false;
    private boolean isWirelineOn = false;
    private boolean isStatusOn = false;
    private JPanel BelowPeekAudioPanel;
    private JPanel RxWirelineEqualizationPanel;
    private JPanel RxWirelineLevelPanel;
    private JToggleButton btnHiOnOff;
    private JToggleButton btnLOOnOff;
    private JToggleButton btnRxOnOff;
    private JButton btnSave;
    private JToggleButton btnStatusOnOff;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel18;
    private JLabel jLabel19;
    private JLabel jLabel20;
    private JLabel jLabel21;
    private JLabel jLabel22;
    private JLabel jLabel23;
    private JLabel jLabel3;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel m_labelPeakAudioLevel;
    private JLabel m_lblCurrentAlertTone;
    private JLabel m_lblCurrentAlertToneDB;
    private JLabel m_lblStoredAlertToneDB;
    private JTextField m_txtCurrentAlertTone;
    private JTextField m_txtCurrentHiBoost;
    private JTextField m_txtCurrentHiBoostFreq;
    private JTextField m_txtCurrentLoBoostLevel;
    private JTextField m_txtCurrentRxWirelineLevel;
    private JTextField m_txtCurrentStatusTone;
    private JTextField m_txtPeakAudioLevel;
    private JTextField m_txtStoredAlertTone;
    private JTextField m_txtStoredHiBoostFreq;
    private JTextField m_txtStoredHiBoostLevel;
    private JTextField m_txtStoredLoBoostLevel;
    private JTextField m_txtStoredRxWirelineLevel;
    private JTextField m_txtStoredStatusTone;

    public RxWirelinePanel() {
        this.initComponents();
    }

    public RxWirelinePanel(SummitAlignmentScreen summitAlignmentScreen) {
        this.initComponents();
        this.m_screen = summitAlignmentScreen;
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        this.setWindow(uIInternalFrame);
        this.m_statusBarListener = statusBarListener;
        if (null != this.m_statusBarListener) {
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineLine1Component(), STAT_WIRELINE_LINE1, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineLoBoostComponent(), STAT_WIRELINE_LO_BOOST, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineHiBoostComponent(), STAT_WIRELINE_HI_BOOST, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineHiBoostFreqComponent(), STAT_WIRELINE_HI_BOOST_FREQ, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineStatusToneComponent(), STAT_WIRELINE_STATUS, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrentWirelineAlertToneComponent(), STAT_WIRELINE_ALERT, false);
            this.m_statusBarListener.updateComponent((Component)this.getSaveButton(), "Click the save button to save the set Rx Wireline Levels.", false);
        }
        this.jLabel1.setToolTipText(TOOLTIP_STAT_WIRELINE_LINE1);
        this.jLabel10.setToolTipText(TOOLTIP_WIRELINE_LO_BOOST);
        this.jLabel13.setToolTipText(TOOLTIP_WIRELINE_HI_BOOST);
        this.jLabel16.setToolTipText(TOOLTIP_WIRELINE_HI_BOOST_FREQ);
        this.jLabel21.setToolTipText(TOOLTIP_WIRELINE_STATUS);
        this.m_lblCurrentAlertTone.setToolTipText(TOOLTIP_WIRELINE_ALERT);
        this.m_labelPeakAudioLevel.setToolTipText(TOOLTIP_PEAK_AUDIO_LEVEL);
        this.btnSave.setToolTipText("Click the save button to save the set Rx Wireline Levels.");
        if (this.m_screen.isIR3600()) {
            this.setRxWirelineEqualizationPanel(false);
            this.setVisibleAlertTone(false);
        }
        if (this.m_screen.isMsBR3600()) {
            this.setVisibleAlertTone(false);
        }
    }

    protected void setRxWirelineEqualizationPanel(boolean bl) {
        this.getRxWirelineEqualizationPanel().setVisible(false);
    }

    protected void setVisibleAlertTone(boolean bl) {
        this.getLabelCurrentAlertTone().setVisible(bl);
        this.getLabelCurrentAlertToneDB().setVisible(bl);
        this.getLabelStoredAlertToneDB().setVisible(bl);
        this.getCurrentWirelineAlertToneComponent().setVisible(bl);
        this.getStoredWirelineAlertToneComponent().setVisible(bl);
    }

    protected void setWindow(UIInternalFrame uIInternalFrame) {
        this.m_window = uIInternalFrame;
    }

    protected UIInternalFrame getWindow() {
        return this.m_window;
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    protected JTextField getCurrentWirelineLine1Component() {
        return this.m_txtCurrentRxWirelineLevel;
    }

    protected JTextField getStoredWirelineLine1Component() {
        return this.m_txtStoredRxWirelineLevel;
    }

    protected JTextField getCurrentWirelineLoBoostComponent() {
        return this.m_txtCurrentLoBoostLevel;
    }

    protected JTextField getStoredWirelineLoBoostComponent() {
        return this.m_txtStoredLoBoostLevel;
    }

    protected JTextField getCurrentWirelineHiBoostComponent() {
        return this.m_txtCurrentHiBoost;
    }

    protected JTextField getStoredWirelineHiBoostComponent() {
        return this.m_txtStoredHiBoostLevel;
    }

    protected JTextField getCurrentWirelineHiBoostFreqComponent() {
        return this.m_txtCurrentHiBoostFreq;
    }

    protected JTextField getStoredWirelineHiBoostFreqComponent() {
        return this.m_txtStoredHiBoostFreq;
    }

    protected JTextField getCurrentWirelineStatusToneComponent() {
        return this.m_txtCurrentStatusTone;
    }

    protected JLabel getLabelCurrentAlertTone() {
        return this.m_lblCurrentAlertTone;
    }

    protected JLabel getLabelCurrentAlertToneDB() {
        return this.m_lblCurrentAlertToneDB;
    }

    protected JLabel getLabelStoredAlertToneDB() {
        return this.m_lblStoredAlertToneDB;
    }

    protected JTextField getStoredWirelineStatusToneComponent() {
        return this.m_txtStoredStatusTone;
    }

    protected JTextField getCurrentWirelineAlertToneComponent() {
        return this.m_txtCurrentAlertTone;
    }

    protected JTextField getStoredWirelineAlertToneComponent() {
        return this.m_txtStoredAlertTone;
    }

    public JToggleButton getWirelineButton() {
        return this.btnRxOnOff;
    }

    public JToggleButton getLoBoostButton() {
        return this.btnLOOnOff;
    }

    public JToggleButton getHiBoostButton() {
        return this.btnHiOnOff;
    }

    public JToggleButton getStatusButton() {
        return this.btnStatusOnOff;
    }

    protected JButton getSaveButton() {
        return this.btnSave;
    }

    public boolean getSaveButtonState() {
        return this.m_bSaveButtonPush;
    }

    public void setSaveButtonState(boolean bl) {
        this.m_bSaveButtonPush = bl;
    }

    protected String getCurrentWirelineAlertToneText() {
        return this.m_txtCurrentAlertTone.getText();
    }

    protected JPanel getRxWirelineEqualizationPanel() {
        return this.RxWirelineEqualizationPanel;
    }

    private void initComponents() {
        this.RxWirelineLevelPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.m_txtCurrentRxWirelineLevel = new CSSJTextField();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.m_txtStoredRxWirelineLevel = new JTextField();
        this.jLabel7 = new JLabel();
        this.btnRxOnOff = new JToggleButton();
        this.m_txtPeakAudioLevel = new JTextField();
        this.m_labelPeakAudioLevel = new JLabel();
        this.RxWirelineEqualizationPanel = new JPanel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.m_txtCurrentLoBoostLevel = new CSSJTextField();
        this.jLabel11 = new JLabel();
        this.m_txtStoredLoBoostLevel = new JTextField();
        this.jLabel12 = new JLabel();
        this.jLabel13 = new JLabel();
        this.m_txtCurrentHiBoost = new CSSJTextField();
        this.jLabel14 = new JLabel();
        this.m_txtStoredHiBoostLevel = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.m_txtCurrentHiBoostFreq = new CSSJTextField();
        this.jLabel17 = new JLabel();
        this.m_txtStoredHiBoostFreq = new JTextField();
        this.jLabel18 = new JLabel();
        this.btnLOOnOff = new JToggleButton();
        this.btnHiOnOff = new JToggleButton();
        this.BelowPeekAudioPanel = new JPanel();
        this.jLabel19 = new JLabel();
        this.jLabel20 = new JLabel();
        this.jLabel21 = new JLabel();
        this.m_txtCurrentStatusTone = new CSSJTextField();
        this.jLabel22 = new JLabel();
        this.m_txtStoredStatusTone = new JTextField();
        this.jLabel23 = new JLabel();
        this.m_lblCurrentAlertTone = new JLabel();
        this.m_txtCurrentAlertTone = new CSSJTextField();
        this.m_lblCurrentAlertToneDB = new JLabel();
        this.m_txtStoredAlertTone = new JTextField();
        this.m_lblStoredAlertToneDB = new JLabel();
        this.btnStatusOnOff = new JToggleButton();
        this.btnSave = new JButton();
        this.RxWirelineLevelPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.jLabel1.setText(RX_WIRELINE_LEVEL_LABEL);
        this.m_txtCurrentRxWirelineLevel.setColumns(8);
        this.m_txtCurrentRxWirelineLevel.setName(RX_WIRELINE_LEVEL_LABEL);
        this.jLabel3.setText("dBm");
        this.jLabel5.setText("Current");
        this.jLabel6.setText("Stored");
        this.m_txtStoredRxWirelineLevel.setColumns(8);
        this.m_txtStoredRxWirelineLevel.setEnabled(false);
        this.m_txtStoredRxWirelineLevel.setName(STORED_RX_WIRELINE_LEVEL_LABEL);
        this.jLabel7.setText("dBm");
        this.btnRxOnOff.setText(TONE_ON_LABEL);
        this.btnRxOnOff.setMinimumSize(new Dimension(80, 0));
        this.btnRxOnOff.setName(TONE_ON_OFF_RX_WIRELINE_BUTTON_ID);
        this.btnRxOnOff.setPreferredSize(new Dimension(80, 23));
        this.m_txtPeakAudioLevel.setEditable(false);
        this.m_txtPeakAudioLevel.setColumns(8);
        this.m_txtPeakAudioLevel.setName(PEAK_AUDIO_LEVEL_LABEL);
        this.m_labelPeakAudioLevel.setText(PEAK_AUDIO_LEVEL_LABEL);
        this.m_labelPeakAudioLevel.setToolTipText("");
        GroupLayout groupLayout = new GroupLayout(this.RxWirelineLevelPanel);
        this.RxWirelineLevelPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.btnRxOnOff, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.m_labelPeakAudioLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_txtPeakAudioLevel, -2, -1, -2).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_txtCurrentRxWirelineLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3))).addGap(10, 10, 10).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_txtStoredRxWirelineLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7)).addComponent(this.jLabel6)))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtPeakAudioLevel, -2, -1, -2).addComponent(this.m_labelPeakAudioLevel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtCurrentRxWirelineLevel, -2, -1, -2).addComponent(this.jLabel3).addComponent(this.m_txtStoredRxWirelineLevel, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.jLabel1).addComponent(this.btnRxOnOff, -2, -1, -2)).addContainerGap()));
        this.RxWirelineEqualizationPanel.setBorder(BorderFactory.createTitledBorder("Rx Wireline Equalization"));
        this.jLabel8.setText("Current");
        this.jLabel9.setText("Stored");
        this.jLabel10.setText(LO_BOOST_ADJUST_LEVEL_LABEL);
        this.m_txtCurrentLoBoostLevel.setColumns(8);
        this.m_txtCurrentLoBoostLevel.setName(LO_BOOST_ADJUST_LEVEL_LABEL);
        this.jLabel11.setText("dB");
        this.m_txtStoredLoBoostLevel.setColumns(8);
        this.m_txtStoredLoBoostLevel.setEnabled(false);
        this.m_txtStoredLoBoostLevel.setName(STORED_LO_BOOST_ADJUST_LEVEL_LABEL);
        this.jLabel12.setText("dB");
        this.jLabel13.setText(HI_BOOST_ADJUST_LEVEL_LABEL);
        this.m_txtCurrentHiBoost.setColumns(8);
        this.m_txtCurrentHiBoost.setName(HI_BOOST_ADJUST_LEVEL_LABEL);
        this.jLabel14.setText("dB");
        this.m_txtStoredHiBoostLevel.setColumns(8);
        this.m_txtStoredHiBoostLevel.setEnabled(false);
        this.m_txtStoredHiBoostLevel.setName(STORED_HI_BOOST_ADJUST_LEVEL_LABEL);
        this.jLabel15.setText("dB");
        this.jLabel16.setText(HI_BOOST_FREQUENCY_LABEL);
        this.m_txtCurrentHiBoostFreq.setColumns(8);
        this.m_txtCurrentHiBoostFreq.setName(HI_BOOST_FREQUENCY_LABEL);
        this.jLabel17.setText("Hz");
        this.m_txtStoredHiBoostFreq.setColumns(8);
        this.m_txtStoredHiBoostFreq.setEnabled(false);
        this.m_txtStoredHiBoostFreq.setName(STORED_HI_BOOST_FREQUENCY_LABEL);
        this.jLabel18.setText("Hz");
        this.btnLOOnOff.setLabel(TONE_ON_LABEL);
        this.btnLOOnOff.setMinimumSize(new Dimension(80, 0));
        this.btnLOOnOff.setName(TONE_ON_OFF_LO_BOOST_ADJUST_BUTTON_ID);
        this.btnLOOnOff.setPreferredSize(new Dimension(80, 23));
        this.btnHiOnOff.setLabel(TONE_ON_LABEL);
        this.btnHiOnOff.setMinimumSize(new Dimension(80, 0));
        this.btnHiOnOff.setName(TONE_ON_OFF_HI_BOOST_ADJUST_BUTTON_ID);
        this.btnHiOnOff.setPreferredSize(new Dimension(80, 23));
        GroupLayout groupLayout2 = new GroupLayout(this.RxWirelineEqualizationPanel);
        this.RxWirelineEqualizationPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnHiOnOff, -2, -1, -2).addComponent(this.btnLOOnOff, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel13).addComponent(this.jLabel10).addComponent(this.jLabel16)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_txtCurrentHiBoostFreq, -2, -1, -2).addComponent(this.m_txtCurrentLoBoostLevel, -2, -1, -2).addComponent(this.m_txtCurrentHiBoost, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.jLabel11).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addGroup(groupLayout2.createSequentialGroup().addComponent(this.m_txtStoredLoBoostLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel12)))).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel14).addComponent(this.jLabel17)).addGap(18, 18, 18).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addComponent(this.m_txtStoredHiBoostFreq, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel18)).addGroup(groupLayout2.createSequentialGroup().addComponent(this.m_txtStoredHiBoostLevel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel15))))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtCurrentLoBoostLevel, -2, -1, -2).addComponent(this.jLabel11).addComponent(this.m_txtStoredLoBoostLevel, -2, -1, -2).addComponent(this.jLabel12).addComponent(this.jLabel10).addComponent(this.btnLOOnOff, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtCurrentHiBoost, -2, -1, -2).addComponent(this.btnHiOnOff, -2, -1, -2).addComponent(this.jLabel13)).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.m_txtStoredHiBoostLevel, -2, -1, -2).addComponent(this.jLabel15))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtCurrentHiBoostFreq, -2, -1, -2).addComponent(this.jLabel17).addComponent(this.m_txtStoredHiBoostFreq, -2, -1, -2).addComponent(this.jLabel18).addComponent(this.jLabel16)).addContainerGap(-1, Short.MAX_VALUE)));
        this.BelowPeekAudioPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.BelowPeekAudioPanel.setMinimumSize(new Dimension(551, 120));
        this.jLabel19.setText("Current");
        this.jLabel20.setText("Stored");
        this.jLabel21.setText(STATUS_TONE_ALMT_LEVEL_BELOW_PEAK_AUDIO_LABEL);
        this.m_txtCurrentStatusTone.setColumns(8);
        this.m_txtCurrentStatusTone.setName(STATUS_TONE_ALMT_LEVEL_BELOW_PEAK_AUDIO_LABEL);
        this.jLabel22.setText("dB");
        this.m_txtStoredStatusTone.setColumns(8);
        this.m_txtStoredStatusTone.setEnabled(false);
        this.m_txtStoredStatusTone.setName(STORED_STATUS_TONE_ALMT_LEVEL_BELOW_PEAK_AUDIO_LABEL);
        this.jLabel23.setText("dB");
        this.m_lblCurrentAlertTone.setText("Alert Tone Level Below Peak Audio");
        this.m_txtCurrentAlertTone.setColumns(8);
        this.m_lblCurrentAlertToneDB.setText("dB");
        this.m_txtStoredAlertTone.setColumns(8);
        this.m_txtStoredAlertTone.setEnabled(false);
        this.m_lblStoredAlertToneDB.setText("dB");
        this.btnStatusOnOff.setLabel(TONE_ON_LABEL);
        this.btnStatusOnOff.setMinimumSize(new Dimension(80, 0));
        this.btnStatusOnOff.setName(TONE_ON_OFF_STATUS_TONE_BUTTON_ID);
        this.btnStatusOnOff.setPreferredSize(new Dimension(80, 23));
        GroupLayout groupLayout3 = new GroupLayout(this.BelowPeekAudioPanel);
        this.BelowPeekAudioPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addGap(14, 14, 14).addComponent(this.btnStatusOnOff, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel21).addComponent(this.m_lblCurrentAlertTone)).addGap(7, 7, 7).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.m_txtCurrentStatusTone, -2, -1, -2).addComponent(this.m_txtCurrentAlertTone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel22).addComponent(this.m_lblCurrentAlertToneDB))).addComponent(this.jLabel19)).addGap(14, 14, 14).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addComponent(this.m_txtStoredAlertTone, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.m_lblStoredAlertToneDB)).addComponent(this.jLabel20).addGroup(groupLayout3.createSequentialGroup().addComponent(this.m_txtStoredStatusTone, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel23))).addGap(38, 38, 38)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel20).addComponent(this.jLabel19)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtStoredStatusTone, -2, -1, -2).addComponent(this.jLabel23).addComponent(this.jLabel22).addComponent(this.btnStatusOnOff, -2, -1, -2).addComponent(this.jLabel21).addComponent(this.m_txtCurrentStatusTone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_txtCurrentAlertTone, -2, -1, -2).addComponent(this.m_txtStoredAlertTone, -2, -1, -2).addComponent(this.m_lblStoredAlertToneDB).addComponent(this.m_lblCurrentAlertToneDB).addComponent(this.m_lblCurrentAlertTone)).addGap(11, 11, 11)));
        this.btnSave.setText(SAVE_LABEL);
        this.btnSave.setName(SAVE_LABEL);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RxWirelinePanel.this.btnSaveActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this);
        this.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.BelowPeekAudioPanel, -1, -1, Short.MAX_VALUE).addComponent(this.btnSave).addComponent(this.RxWirelineEqualizationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()).addGroup(groupLayout4.createSequentialGroup().addComponent(this.RxWirelineLevelPanel, -1, -1, Short.MAX_VALUE).addGap(14, 14, 14)))));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.RxWirelineLevelPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.RxWirelineEqualizationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BelowPeekAudioPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addContainerGap(21, Short.MAX_VALUE)));
    }

    private void btnSaveActionPerformed(ActionEvent actionEvent) {
        this.setSaveButtonState(!this.getSaveButtonState());
    }

    protected void btnHiOnOffActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        this.btnHiOnOff.setSelected(abstractButton.getModel().isSelected());
    }

    protected void btnLOOnOffActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        this.btnLOOnOff.setSelected(abstractButton.getModel().isSelected());
    }

    protected void btnRxOnOffActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        this.btnRxOnOff.setSelected(abstractButton.getModel().isSelected());
    }

    protected void btnStatusOnOffActionPerformed(ActionEvent actionEvent) {
        AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
        this.btnStatusOnOff.setSelected(abstractButton.getModel().isSelected());
    }

    public boolean isHiBoostOn() {
        return this.isHiBoostOn;
    }

    public void setHiBoostOn(boolean bl) {
        this.isHiBoostOn = bl;
    }

    public boolean isLoBoostOn() {
        return this.isLoBoostOn;
    }

    public void setLoBoostOn(boolean bl) {
        this.isLoBoostOn = bl;
    }

    public boolean isWirelineOn() {
        return this.isWirelineOn;
    }

    public void setWirelineOn(boolean bl) {
        this.isWirelineOn = bl;
    }

    public boolean isStatusOn() {
        return this.isStatusOn;
    }

    public void setStatusOn(boolean bl) {
        this.isStatusOn = bl;
    }

    public void setCurrentLoBoostLevel(String string) {
        this.m_txtCurrentLoBoostLevel.setText(string);
        ((CSSJTextField)this.m_txtCurrentLoBoostLevel).setStoredValue(string);
    }

    public void setStoredLoBoostLevel(String string) {
        this.m_txtStoredLoBoostLevel.setText(string);
    }

    public void setCurrentHiBoostLevel(String string) {
        this.m_txtCurrentHiBoost.setText(string);
        ((CSSJTextField)this.m_txtCurrentHiBoost).setStoredValue(string);
    }

    public void setStoredHiBoostLevel(String string) {
        this.m_txtStoredHiBoostLevel.setText(string);
    }

    public void setCurrentHiBoostFreq(int n) {
        this.m_txtCurrentHiBoostFreq.setText(new Integer(n).toString());
        String string = Integer.toString(n);
        ((CSSJTextField)this.m_txtCurrentHiBoostFreq).setStoredValue(string);
    }

    public void setStoredHiBoostFreq(int n) {
        this.m_txtStoredHiBoostFreq.setText(new Integer(n).toString());
    }

    public void setCurrentStatusTone(String string) {
        this.m_txtCurrentStatusTone.setText(string);
        ((CSSJTextField)this.m_txtCurrentStatusTone).setStoredValue(string);
    }

    public void setStoredStatusTone(String string) {
        this.m_txtStoredStatusTone.setText(string);
    }

    public void setCurrentAlarmTone(String string) {
        this.m_txtCurrentAlertTone.setText(string);
        ((CSSJTextField)this.m_txtCurrentAlertTone).setStoredValue(string);
    }

    public void setStoredAlarmTone(String string) {
        this.m_txtStoredAlertTone.setText(string);
    }

    public void setCurrentWirelineLevel(String string) {
        this.m_txtCurrentRxWirelineLevel.setText(string);
        ((CSSJTextField)this.m_txtCurrentRxWirelineLevel).setStoredValue(string);
        this.setPeakAudioLevel(string);
    }

    public void setStoredWirelineLevel(String string) {
        this.m_txtStoredRxWirelineLevel.setText(string);
    }

    public void setPeakAudioLevel(String string) {
        if (string.contains(",")) {
            string = string.replace(",", ".");
        }
        BigDecimal bigDecimal = new BigDecimal(string);
        BigDecimal bigDecimal2 = new BigDecimal(PEAK_AUDIO_LEVEL_ABOVE_RX_WIRELINE);
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2);
        bigDecimal3.setScale(8, 4);
        this.m_txtPeakAudioLevel.setText(bigDecimal3.toString());
    }
}

