/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.RuleIfc;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.TimeDialog;
import css.core.util.TimeDialogWithCancel;
import css.core.util.popup.ConfirmationPopup;
import css.device.common.screens.GenericScreen;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.summit.screens.alignment.SacReferenceOscillatorFrequencyTabGUI;
import java.awt.Frame;
import java.util.Locale;
import pnm.util.EngineUtilities;

public class SacReferenceOscillatorFrequencyTab
extends SacReferenceOscillatorFrequencyTabGUI {
    private static final long serialVersionUID = -2408321060517172769L;
    private static final int POLLING_INTERVAL = 1000;
    private static final String ABORT_CONFIRM_MSG = "Do you really want to abort the auto-alignment process?";
    public final String TOC_MODULE_IS_NOT_INSTALLED = "TOC module is not installed.";
    private static final CssLogger LOG = CssLogger.getCssLogger(SacReferenceOscillatorFrequencyTab.class);
    private GenericScreen m_screen;
    private TimeDialogWithCancel m_cTimeDialog = null;
    public boolean m_bErrorDialogShown = false;

    public SacReferenceOscillatorFrequencyTab(GenericScreen genericScreen) {
        LOG.enter("SacReferenceOscillatorFrequencyTab");
        this.m_screen = genericScreen;
        LOG.exit("SacReferenceOscillatorFrequencyTab");
    }

    public void initialize() {
        LOG.enter("initialize");
        LOG.exit("initialize");
    }

    public void displayWarning(String string) {
        this.m_screen.popupInfo(string);
    }

    private boolean isMsbrOrHpdbr() {
        Devices devices = Devices.getDeviceByName((String)MetadataAcquisitionService.getDeviceName());
        if (null == devices) {
            LOG.error((Object)"isMsbrOrHpdbr - cannot get loaded device.");
        }
        return Devices.LSS == devices || Devices.LSS_GEN2 == devices || Devices.HPDBR == devices || Devices.HPDBR_GEN2 == devices;
    }

    public void displayWarningTocModuleNotInstalled() {
        if (!this.isMsbrOrHpdbr()) {
            this.displayWarning("TOC module is not installed.");
        }
    }

    private final class StartTimeDialogThread
    extends Thread {
        private final CssLogger LOG;
        private final int AUTO_ALIGNEMENT_TIMEOUT = 600;
        AutoAlignmentGetStatusThread m_oGetStatusThread;

        public StartTimeDialogThread(AutoAlignmentGetStatusThread autoAlignmentGetStatusThread) {
            super("TimeDialogWithCancel");
            this.LOG = CssLogger.getCssLogger(StartTimeDialogThread.class);
            this.AUTO_ALIGNEMENT_TIMEOUT = 600;
            this.m_oGetStatusThread = null;
            this.LOG.enter("StartTimeDialogThread");
            this.m_oGetStatusThread = autoAlignmentGetStatusThread;
            this.LOG.exit("StartTimeDialogThread");
        }

        @Override
        public void run() {
            this.LOG.enter("run");
            TimeDialog.WindowSettings windowSettings = new TimeDialog.WindowSettings();
            windowSettings.m_nCounter = 600;
            windowSettings.m_sWindowName = "Auto Alignment timer";
            windowSettings.m_sOperationName = "Auto Alignment in progress.";
            windowSettings.m_sOperationSummary = "Auto alignment did not complete within the 10 minutes timeout window.";
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog = new TimeDialogWithCancel((Frame)EngineUtilities.getMainApplicationWindow(), windowSettings);
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.setPostCancelActionPerformer((TimeDialog.PostAction)new CancelPostAction());
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.setPostOkActionPerformer((TimeDialog.PostAction)new OkPostAction());
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.setPostTimoutActionPerformer((TimeDialog.PostAction)new TimeOutPostAction());
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.start();
            SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.setVisible(true);
            this.LOG.exit("run");
        }

        public void closeTimeDialog() {
            this.LOG.enter("closeTimeDialog");
            if (SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog != null) {
                SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.setVisible(false);
                SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.dispose();
                SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog = null;
            }
            this.LOG.exit("closeTimeDialog");
        }

        class TimeOutPostAction
        implements TimeDialog.PostAction {
            private final CssLogger LOG = CssLogger.getCssLogger(TimeOutPostAction.class);

            TimeOutPostAction() {
            }

            public void PerformPostAction() {
                this.LOG.enter("PerformPostAction");
                if (StartTimeDialogThread.this.m_oGetStatusThread != null) {
                    Cancel_AutoAligment_Rule cancel_AutoAligment_Rule;
                    boolean bl;
                    StartTimeDialogThread.this.m_oGetStatusThread.closeGetAutoAlignmentStatusThread();
                    if (StartTimeDialogThread.this.m_oGetStatusThread.m_oSession != null && !(bl = (cancel_AutoAligment_Rule = new Cancel_AutoAligment_Rule()).process(StartTimeDialogThread.this.m_oGetStatusThread.m_oSession))) {
                        this.LOG.error((Object)"Cancel_AutoAligment_Rule failed");
                    }
                }
                this.LOG.exit("PerformPostAction");
            }
        }

        class OkPostAction
        implements TimeDialog.PostAction {
            private final CssLogger LOG = CssLogger.getCssLogger(OkPostAction.class);

            OkPostAction() {
            }

            public void PerformPostAction() {
                this.LOG.enter("PerformPostAction");
                this.LOG.exit("PerformPostAction");
            }
        }

        class CancelPostAction
        implements TimeDialog.PostAction {
            private final CssLogger LOG = CssLogger.getCssLogger(CancelPostAction.class);

            CancelPostAction() {
            }

            public void PerformPostAction() {
                this.LOG.enter("PerformPostAction");
                ConfirmationPopup confirmationPopup = new ConfirmationPopup();
                confirmationPopup.display(SacReferenceOscillatorFrequencyTab.ABORT_CONFIRM_MSG);
                if (confirmationPopup.getStatus()) {
                    if (StartTimeDialogThread.this.m_oGetStatusThread != null) {
                        Cancel_AutoAligment_Rule cancel_AutoAligment_Rule;
                        boolean bl;
                        SessionIfc sessionIfc = StartTimeDialogThread.this.m_oGetStatusThread.m_oSession;
                        StartTimeDialogThread.this.m_oGetStatusThread.closeGetAutoAlignmentStatusThread();
                        if (sessionIfc != null && !(bl = (cancel_AutoAligment_Rule = new Cancel_AutoAligment_Rule()).process(sessionIfc))) {
                            this.LOG.error((Object)"Cancel_AutoAligment_Rule failed");
                        }
                    }
                    StartTimeDialogThread.this.closeTimeDialog();
                }
                this.LOG.exit("PerformPostAction");
            }
        }
    }

    private final class AutoAlignmentGetStatusThread
    extends Thread {
        private final CssLogger LOG;
        private SessionIfc m_oSession;
        private StartTimeDialogThread m_oTimeDialogThread;
        private Boolean isInterrupted;

        public AutoAlignmentGetStatusThread(SessionIfc sessionIfc) {
            super("GetAutoAlignStatus");
            this.LOG = CssLogger.getCssLogger(AutoAlignmentGetStatusThread.class);
            this.m_oSession = null;
            this.m_oTimeDialogThread = null;
            this.isInterrupted = false;
            this.LOG.enter("GetStatusThread");
            this.m_oSession = sessionIfc;
            this.LOG.exit("GetStatusThread");
        }

        @Override
        public void run() {
            this.LOG.enter("run");
            long l = 0L;
            long l2 = 0L;
            this.m_oTimeDialogThread = new StartTimeDialogThread(this);
            this.m_oTimeDialogThread.start();
            boolean bl = false;
            while (!bl && !this.isInterrupted.booleanValue()) {
                l = System.currentTimeMillis();
                Get_AutoAligmentStatus_Rule get_AutoAligmentStatus_Rule = new Get_AutoAligmentStatus_Rule();
                bl = get_AutoAligmentStatus_Rule.process(this.m_oSession);
                if (bl) break;
                l2 = System.currentTimeMillis();
                long l3 = l2 - l;
                if (l3 <= 0L || l3 >= 1000L) continue;
                try {
                    Thread.sleep(1000L - l3);
                }
                catch (InterruptedException interruptedException) {
                    this.LOG.error((Object)"run - sleep failure", (Throwable)interruptedException);
                }
            }
            this.LOG.exit("run");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeGetAutoAlignmentStatusThread() {
            this.LOG.enter("closeGetAutoAlignmentStatusThread");
            Boolean bl = this.isInterrupted;
            synchronized (bl) {
                this.isInterrupted = true;
            }
            this.LOG.exit("closeGetAutoAlignmentStatusThread");
        }
    }

    public class Stop_AlignmentSession_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return true;
        }

        public boolean isRunUpdateInSwingThread() {
            LOG.enter("isRunUpdateInSwingThread");
            LOG.exit("isRunUpdateInSwingThread", (Object)false);
            return false;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2109);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                Integer n2 = (Integer)messageIfc.getDataObject().getParameterValue("ErrorData");
                if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                    LOG.error((Object)("Stop_AlignmentSession_Rule - Error data: " + n2));
                    SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(n2);
                }
                LOG.error((Object)"Stop_AlignmentSession_Rule() failed ");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Save_SACFreqOscVal_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return true;
        }

        public boolean isRunUpdateInSwingThread() {
            LOG.enter("isRunUpdateInSwingThread");
            LOG.exit("isRunUpdateInSwingThread", (Object)false);
            return false;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2193);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError("Unable to save Reference Oscillator value.");
                LOG.error((Object)"Save_SACFreqOscVal_Rule() failed ");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Cancel_AutoAligment_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2194);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() == 0 && SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog != null) {
                SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.stop("Auto alignment did not complete within the 10 minutes timeout window.", 0);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Close_Screen
    implements RuleIfc {
        public boolean doAction(SessionIfc sessionIfc) {
            LOG.enter("doAction");
            boolean bl = true;
            SacReferenceOscillatorFrequencyTab.this.m_screen.close();
            LOG.exit("doAction");
            return bl;
        }

        public final boolean process(SessionIfc sessionIfc) {
            LOG.enter("process", new Object[]{sessionIfc});
            boolean bl = false;
            bl = this.doAction(sessionIfc);
            LOG.exit("process", (Object)bl);
            return bl;
        }
    }

    public class Get_AutoAligmentStatus_Rule
    extends Rule {
        public static final String sGetStatusAutoAlignment = "GetAutoAlignmentStatus";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sGetStatusAutoAlignment, byte[].class);
            message.setProtocolKey(2195);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            byte[] byArray;
            boolean bl = false;
            LOG.enter("update");
            if (messageIfc.getError() == 0 && null != (byArray = (byte[])messageIfc.getParameterValue(sGetStatusAutoAlignment)) && byArray.length > 0) {
                if (0 == byArray[0]) {
                    bl = false;
                } else if (1 == byArray[0]) {
                    bl = true;
                    if (SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog != null) {
                        SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.stop("Auto alignment did not complete successfully.", 0);
                    }
                } else if (2 == byArray[0]) {
                    bl = true;
                    if (SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog != null) {
                        SacReferenceOscillatorFrequencyTab.this.m_cTimeDialog.stop("Auto alignment completed successfully", 1);
                    }
                }
                if (bl) {
                    Get_SacFreqRefOsc_Value_Rule get_SacFreqRefOsc_Value_Rule = new Get_SacFreqRefOsc_Value_Rule();
                    get_SacFreqRefOsc_Value_Rule.process(sessionIfc);
                }
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class AutoAligment_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            AutoAlignmentGetStatusThread autoAlignmentGetStatusThread = new AutoAlignmentGetStatusThread(sessionIfc);
            autoAlignmentGetStatusThread.start();
            LOG.exit("condition", (Object)true);
            return true;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (SacReferenceOscillatorFrequencyTab.this.getRefOscilatorFreq() == 5) {
                message.setProtocolKey(2191);
            } else {
                message.setProtocolKey(2192);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                Integer n2 = (Integer)messageIfc.getDataObject().getParameterValue("ErrorData");
                if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                    LOG.error((Object)("AutoAligment_Rule - Error data: " + n2));
                    SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(n2);
                }
                LOG.error((Object)"AutoAligment_Rule() failed ");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Set_SACFreqOscVal_Rule
    extends Rule {
        public static final String sFrequencyReferenceSetType = "FrequencyReferenceSetType";
        public static final String sFrequencyReferenceSetValue = "FrequencyReferenceSetValue";

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return true;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sFrequencyReferenceSetValue, Integer.class, (Object)SacReferenceOscillatorFrequencyTab.this.getReferenceOscillatorValue());
            message.setProtocolKey(2190);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (SacReferenceOscillatorFrequencyTab.this.getRefOscValue().isEnabled()) {
                SacReferenceOscillatorFrequencyTab.this.getButLeft().setEnabled(true);
                SacReferenceOscillatorFrequencyTab.this.getButRight().setEnabled(true);
            } else {
                SacReferenceOscillatorFrequencyTab.this.getButLeft().setEnabled(false);
                SacReferenceOscillatorFrequencyTab.this.getButRight().setEnabled(false);
            }
            if (messageIfc.getError() != 0) {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400006);
                SacReferenceOscillatorFrequencyTab.this.setReferenceOscillatorValue(SacReferenceOscillatorFrequencyTab.this.m_nStoredValue);
                LOG.error((Object)"Set_SACFreqOscVal_Rule() failed ");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Get_KeyUp_DeKey_Status_Rule
    extends Rule {
        public static final String sKeyupDeKeyStatus = "sTransmitterMode";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sKeyupDeKeyStatus, Byte.class);
            message.setProtocolKey(2199);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError("Unable to get the status of running ASTRO Symbol Test Pattern.");
                LOG.error((Object)"Get_KeyUp_DeKey_Status_Rule() failed ");
                SacReferenceOscillatorFrequencyTab.this.setKeyUp(true);
            } else if ((Byte)messageIfc.getParameterValue(sKeyupDeKeyStatus) == 1) {
                SacReferenceOscillatorFrequencyTab.this.setKeyUp(false);
            } else {
                SacReferenceOscillatorFrequencyTab.this.setKeyUp(true);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class DeKey_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_DEKEY_GENERIC = 0;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !SacReferenceOscillatorFrequencyTab.this.isKeyUp();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            SacReferenceOscillatorFrequencyTab.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)0);
            message.setProtocolKey(2198);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!SacReferenceOscillatorFrequencyTab.this.m_bErrorDialogShown) {
                    SacReferenceOscillatorFrequencyTab.this.m_screen.popupError("Unable to Dekey the Station.");
                }
                LOG.error((Object)"DeKey_Rule() failed ");
            } else {
                SacReferenceOscillatorFrequencyTab.this.setKeyUp(!SacReferenceOscillatorFrequencyTab.this.isKeyUp());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class KeyUp_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_KEYUP_GENERIC = 0;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = SacReferenceOscillatorFrequencyTab.this.isKeyUp();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            SacReferenceOscillatorFrequencyTab.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)0);
            message.setProtocolKey(2196);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!SacReferenceOscillatorFrequencyTab.this.m_bErrorDialogShown) {
                    SacReferenceOscillatorFrequencyTab.this.m_screen.popupError("Unable to keyup the Station.");
                }
                LOG.error((Object)"KeyUp_Rule() failed ");
            } else {
                SacReferenceOscillatorFrequencyTab.this.setKeyUp(!SacReferenceOscillatorFrequencyTab.this.isKeyUp());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Get_SacFreqRefOsc_Value_Rule
    extends Rule {
        public static final String sSacFrequencyReferenceOscillatorValue = "SacFrequencyReferenceValue";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sSacFrequencyReferenceOscillatorValue, Integer.class);
            message.setProtocolKey(2187);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl;
            LOG.enter("update");
            if (messageIfc.getError() == 0) {
                Integer n2 = 0;
                Object object = messageIfc.getParameterValue(sSacFrequencyReferenceOscillatorValue);
                if (object != null) {
                    n2 = (Integer)object;
                }
                SacReferenceOscillatorFrequencyTab.this.setReferenceOscillatorValue(n2);
                SacReferenceOscillatorFrequencyTab.this.m_nStoredValue = n2;
                bl = true;
            } else {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400001);
                LOG.error((Object)"Init_Rule_SacFreqRefOscValue() failed");
                bl = false;
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class Init_Rule_ConvBR_Tx_Service
    extends Rule {
        public static final String sConvBRTxService = "convBRTxService";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sConvBRTxService, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl;
            LOG.enter("update");
            if (messageIfc.getError() == 0) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(sConvBRTxService);
                if (2 == integerArray[0]) {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenForHwType(false);
                } else {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenForHwType(true);
                }
                bl = true;
            } else {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400005);
                LOG.error((Object)"Init_Rule_ConvBR_Tx_Service() failed");
                bl = false;
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class Init_Rule_Hardware_Type
    extends Rule {
        public static final String sHwType = "HwType";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sHwType, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl;
            LOG.enter("update");
            if (messageIfc.getError() == 0) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(sHwType);
                if (4 == integerArray[0]) {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenForHwType(false);
                } else {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenForHwType(true);
                }
                bl = true;
            } else {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400005);
                LOG.error((Object)"Init_Rule_Transmit_Frequency() failed");
                bl = false;
            }
            LOG.exit("update");
            return bl;
        }
    }

    public class Init_Rule_Transmit_Frequency
    extends Rule {
        public static final String XMIT_FREQ_FSP = "sTxFrequency";
        public static final String XMIT_FREQ_SNMP = "TxFreq";

        private boolean isConvbrOrIR3600() {
            Devices devices = Devices.getDeviceByName((String)MetadataAcquisitionService.getDeviceName());
            if (null == devices) {
                LOG.error((Object)"Init_Rule_Transmit_Frequency - cannot get loaded device.");
            }
            return Devices.IR == devices || Devices.CONVBR == devices || Devices.CONVBR_GEN2 == devices;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("Init_Rule_Transmit_Frequency:getMessage");
            Message message = new Message();
            if (this.isConvbrOrIR3600()) {
                message.addParameter(XMIT_FREQ_FSP, Byte[].class);
                message.setProtocolKey(5319);
            } else {
                message.addParameter(XMIT_FREQ_SNMP, Integer[].class);
                message.setProtocolKey(1006);
            }
            LOG.exit("Init_Rule_Transmit_Frequency:getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl = false;
            LOG.enter("Init_Rule_Transmit_Frequency:update");
            if (messageIfc.getError() == 0) {
                Object object;
                Object object2 = null;
                if (this.isConvbrOrIR3600()) {
                    object = (byte[])messageIfc.getParameterValue(XMIT_FREQ_FSP);
                    if (null != object) {
                        object2 = Convert.toInteger((byte[])object);
                    }
                } else {
                    object = (Integer[])messageIfc.getParameterValue(XMIT_FREQ_SNMP);
                    if (null != object && ((byte[])object).length > 0) {
                        object2 = object[0];
                    }
                }
                if (null != object2) {
                    object = (double)object2.intValue() / 1000000.0;
                    String string = String.format(Locale.ENGLISH, "%.6f", object);
                    SacReferenceOscillatorFrequencyTab.this.setTransmitFrequency(string);
                    bl = true;
                } else {
                    LOG.error((Object)"Init_Rule_Transmit_Frequency: Tx frequency value received is null or empty.");
                    bl = false;
                }
            } else {
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400004);
                LOG.error((Object)("Init_Rule_Transmit_Frequency: error received in the message, code: " + messageIfc.getError()));
                bl = false;
            }
            LOG.exit("Init_Rule_Transmit_Frequency:update");
            return bl;
        }
    }

    public class Init_Rule_SacFreqRefOscStatus
    extends Rule {
        public static final String sSacFrequencyReferenceOscillatorStatus = "SacFrequencyReferenceOscillatorStatus";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sSacFrequencyReferenceOscillatorStatus, Integer.class);
            message.setProtocolKey(2185);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl;
            LOG.enter("update");
            if (messageIfc.getError() == 0) {
                SacReferenceOscillatorFrequencyTab.this.setStatus((Integer)messageIfc.getParameterValue(sSacFrequencyReferenceOscillatorStatus));
                bl = true;
                if (SacReferenceOscillatorFrequencyTabGUI.SACRefOscStatus.NA == SacReferenceOscillatorFrequencyTab.this.getStatus()) {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenSacOperational(false, "NOT PRESENT");
                    if (SacReferenceOscillatorFrequencyTab.this.isShowing()) {
                        SacReferenceOscillatorFrequencyTab.this.displayWarningTocModuleNotInstalled();
                    }
                    bl = false;
                } else if (SacReferenceOscillatorFrequencyTabGUI.SACRefOscStatus.OPERATIONAL != SacReferenceOscillatorFrequencyTab.this.getStatus()) {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenSacOperational(false);
                } else {
                    SacReferenceOscillatorFrequencyTab.this.updateScreenSacOperational(true);
                }
            } else {
                SacReferenceOscillatorFrequencyTab.this.updateScreenSacOperational(false, SacReferenceOscillatorFrequencyTabGUI.SACRefOscStatus.NA.getDesc());
                SacReferenceOscillatorFrequencyTab.this.m_screen.popupError(-400000);
                LOG.error((Object)"Init_Rule_SacFreqRefOscStatus() failed");
                bl = false;
            }
            LOG.exit("update");
            return bl;
        }
    }
}

