/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.component.CSSJTextField;
import css.core.util.component.GenericListener;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pnm.ui.UIInternalFrame;

public class SummitAstroSimulcastAlignment
extends JPanel
implements CssConstants {
    private static final String LABEL_NAME_SUFIX = " label";
    private static final String LABEL_FONT_FAMILY = "Tahoma";
    private static final int LABEL_FONT_SIZE = 11;
    private static final int ANALOG_ONLY = 2;
    private static final String LABEL_SIMUL_XMIT_DELAY = "Simulcast Transmit Offset Delay (usec)";
    private static final String LABEL_TX_FREQ_TEXT = "Transmit Frequency (MHz)";
    private static final String TOOLTIP_LABEL_SIMUL_XMIT = "This field allows the user to modify the Simulcast transmit offset delay the BR uses for transmission.";
    private static final String STORED_DIGITAL_SIMULCAST_OFSET_LABEL = "Stored Digital Simulcast Offset Delay";
    private static final String LABEL_DIGITAL_SIMUL_XMIT_DELAY = "Digital Simulcast Transmit Offset Delay (usec)";
    private static final String STORE_SIMULCAST_TRANSMIT_OFFSET_DELAY_LABEL = "Store Simulcast Transmit Offset Delay";
    private static final String TEST_PATTERN_BUTTON_INITIATE_LABEL = "Initiate Simulcast Test Pattern";
    private static final String TEST_PATTERN_BUTTON_STOP_LABEL = "Stop Test Pattern";
    private static final String TEST_PATTERN_INFO_TEXT = "Ensure that the Transmitter is both ENABLED and IDLE via the Status Panel\nService screen before initiating a Simulcast Test Pattern.";
    private static final long serialVersionUID = -7498064104826218600L;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitAstroSimulcastAlignment.class);
    public GenericListener m_oGenericListener = new GenericListener();
    private UIInternalFrame m_window;
    private SummitAlignmentScreen m_alignment;
    public JTextField m_voCurrentTransmitOffsetDelay;
    public JTextField m_voCurrentAnalogTransmitOffsetDelay;
    public JTextField m_voStoredTransmitOffsetDelay;
    public JTextField m_voStoredAnalogTransmitOffsetDelay;
    public JButton m_storeTransmitOffsetDelayBtn;
    public JLabel m_transmitFrequencyLbl;
    public JButton m_testPatternBtn;
    public JTextArea m_voInformationTxt;
    private boolean m_isSimulcastEnabled = false;
    public boolean m_isTestPatternStarted = false;
    private boolean m_hasAnalogTransmitField = false;
    private boolean m_errorDialogShown = false;

    public SummitAstroSimulcastAlignment(SummitAlignmentScreen summitAlignmentScreen) {
        this.m_alignment = summitAlignmentScreen;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener});
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(LABEL_TX_FREQ_TEXT);
        jLabel.setToolTipText("Frequency assigned to the transmitter.");
        jLabel.setName("Transmit Frequency (MHz) label");
        jLabel.setPreferredSize(new Dimension(170, 15));
        jPanel.add(jLabel);
        this.m_transmitFrequencyLbl = new JLabel("N/A");
        this.m_transmitFrequencyLbl.setName(LABEL_TX_FREQ_TEXT);
        jPanel.add(this.m_transmitFrequencyLbl);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)20, (int)0, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 40, 10));
        JLabel jLabel2 = new JLabel(" ");
        jPanel2.add(jLabel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2, 20, 0));
        JLabel jLabel3 = new JLabel("Current");
        jPanel3.add(jLabel3);
        JLabel jLabel4 = new JLabel("Stored");
        jPanel3.add(jLabel4);
        jPanel2.add(jPanel3);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(LABEL_SIMUL_XMIT_DELAY);
        jLabel5.setToolTipText(TOOLTIP_LABEL_SIMUL_XMIT);
        jLabel5.setName("Digital Simulcast Transmit Offset Delay (usec) label");
        jPanel2.add(jLabel5);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2, 20, 0));
        this.m_voCurrentTransmitOffsetDelay = new CSSJTextField();
        this.m_voCurrentTransmitOffsetDelay.setEnabled(true);
        this.m_voCurrentTransmitOffsetDelay.setName(LABEL_DIGITAL_SIMUL_XMIT_DELAY);
        jPanel4.add(this.m_voCurrentTransmitOffsetDelay);
        this.m_voStoredTransmitOffsetDelay = new CSSJTextField();
        this.m_voStoredTransmitOffsetDelay.setText("N/A");
        this.m_voStoredTransmitOffsetDelay.setEnabled(false);
        this.m_voStoredTransmitOffsetDelay.setName(STORED_DIGITAL_SIMULCAST_OFSET_LABEL);
        jPanel4.add(this.m_voStoredTransmitOffsetDelay);
        jPanel2.add(jPanel4);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)20, (int)0, (int)10, (int)0);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        this.m_storeTransmitOffsetDelayBtn = new JButton();
        this.m_storeTransmitOffsetDelayBtn.setText(STORE_SIMULCAST_TRANSMIT_OFFSET_DELAY_LABEL);
        this.m_storeTransmitOffsetDelayBtn.setName(STORE_SIMULCAST_TRANSMIT_OFFSET_DELAY_LABEL);
        this.m_storeTransmitOffsetDelayBtn.setToolTipText("Stores the Simulcast Transmit Offset Delay in the station.");
        jPanel5.add(this.m_storeTransmitOffsetDelayBtn);
        this.m_testPatternBtn = new JButton();
        this.m_testPatternBtn.setText(TEST_PATTERN_BUTTON_INITIATE_LABEL);
        this.m_testPatternBtn.setName(TEST_PATTERN_BUTTON_INITIATE_LABEL);
        this.m_testPatternBtn.setToolTipText("Initiates/Stops the Simulcast Test Pattern.");
        jPanel5.add(this.m_testPatternBtn);
        GridBagAdder.add((Container)this, (Component)jPanel5, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)20, (int)0, (int)10, (int)0);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        this.m_voInformationTxt = new JTextArea();
        this.m_voInformationTxt.setFont(new Font(LABEL_FONT_FAMILY, 0, 11));
        this.m_voInformationTxt.setEditable(false);
        this.m_voInformationTxt.setBackground(this.getBackground());
        this.m_voInformationTxt.setDisabledTextColor(this.m_voInformationTxt.getForeground());
        this.m_voInformationTxt.setEnabled(false);
        this.m_voInformationTxt.setText(TEST_PATTERN_INFO_TEXT);
        jPanel6.add(this.m_voInformationTxt);
        GridBagAdder.add((Container)this, (Component)jPanel6, (int)0, (int)3, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)10, (int)20, (int)0, (int)10, (int)0);
        statusBarListener.registerComponent((Component)this.m_testPatternBtn, "Click this button to Initiate or Stop the Simulcast Test Pattern in the station.");
        statusBarListener.registerComponent((Component)this.m_storeTransmitOffsetDelayBtn, "Click this button to store the Simulcast Transmit Offset Delay value in the station.");
        statusBarListener.registerComponent((Component)this.m_voCurrentTransmitOffsetDelay, "Enter a value between 0 and 1000 usec.");
        if (this.hasAnalogTransmitField()) {
            statusBarListener.registerComponent((Component)this.m_voCurrentAnalogTransmitOffsetDelay, "Enter a value between 0 and 1000 usec.");
        }
        this.m_window.lockWindow();
        LOG.exit("buildScreen");
    }

    public void initialize() {
        LOG.enter("initialize");
        this.m_transmitFrequencyLbl.setText("N/A");
        this.m_voCurrentTransmitOffsetDelay.setText(" ");
        this.m_voStoredTransmitOffsetDelay.setText("N/A");
        if (this.hasAnalogTransmitField()) {
            this.m_voCurrentAnalogTransmitOffsetDelay.setText(" ");
            this.m_voStoredAnalogTransmitOffsetDelay.setText("N/A");
        }
        this.m_testPatternBtn.setText(TEST_PATTERN_BUTTON_INITIATE_LABEL);
        this.m_testPatternBtn.setName(TEST_PATTERN_BUTTON_INITIATE_LABEL);
        this.setIsTestPaternStarted(false);
        this.m_window.lockWindow();
        LOG.exit("initialize");
    }

    public boolean hasAnalogTransmitField() {
        return this.m_hasAnalogTransmitField;
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public Integer getTransmitOffsetDelay() {
        String string = null;
        LOG.enter("getTransmitOffsetDelay");
        this.m_window.lockWindow();
        string = this.m_voCurrentTransmitOffsetDelay.getText();
        double d = new Double(string);
        int n = (int)(d * 10.0);
        LOG.exit("getTransmitOffsetDelay", (Object)n);
        return n;
    }

    public void setIsTestPaternStarted(boolean bl) {
        this.m_isTestPatternStarted = bl;
    }

    public boolean getIsTestPaternStarted() {
        return this.m_isTestPatternStarted;
    }

    public int getAnalogTransmitOffsetDelay() {
        int n = 0;
        String string = null;
        LOG.enter("getAnalogTransmitOffsetDelay");
        string = this.m_voCurrentAnalogTransmitOffsetDelay.getText();
        double d = new Double(string);
        n = (int)(d * 10.0);
        LOG.exit("getAnalogTransmitOffsetDelay", (Object)n);
        return n;
    }

    public void updateTxFreq(String string) {
        LOG.enter("updateTxFreq", new Object[]{string});
        this.m_transmitFrequencyLbl.setText(string);
        this.m_window.unlockWindow();
        LOG.exit("updateTxFreq");
    }

    public void updateTxFreq(int n, Integer[] integerArray) {
        block5: {
            LOG.enter("updateTxFreq", new Object[]{n, integerArray});
            if (n == 0) {
                try {
                    if (integerArray.length != 0) {
                        double d = (double)integerArray[0].intValue() / 1000000.0;
                        String string = new Double(d).toString();
                        this.m_transmitFrequencyLbl.setText(string);
                        break block5;
                    }
                    LOG.error((Object)"updateTxFreq - Array length is 0");
                    this.m_alignment.popupError(-327690);
                }
                catch (Exception exception) {
                    LOG.error((Object)"updateTxFreq - Invalid value of transmitter frequency");
                    this.m_alignment.popupError(-327690);
                }
            } else {
                LOG.error((Object)"updateTxFreq - Error on getting Transmitter Frequency");
                this.m_alignment.popupError(-327700);
            }
        }
        this.m_window.unlockWindow();
        LOG.exit("updateTxFreq");
    }

    public void updateStoredXmitOffsetOnScreen(int n) {
        LOG.enter("updateStoredXmitOffsetOnScreen", new Object[]{n});
        if (n == 0) {
            String string = this.m_voCurrentTransmitOffsetDelay.getText();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2 + 2);
            }
            this.m_voStoredTransmitOffsetDelay.setText(string);
        } else {
            LOG.error((Object)"updateStoredXmitOffsetOnScreen - Error on getting Simulcast Transmit Offset Delay");
            this.m_alignment.popupError(-327693);
            this.m_voStoredTransmitOffsetDelay.setText("N/A");
        }
        this.m_window.unlockWindow();
        LOG.exit("updateStoredXmitOffsetOnScreen");
    }

    public void updateStoredAnalogXmitOffsetOnScreen(int n) {
        LOG.enter("updateStoredAnalogXmitOffsetOnScreen", new Object[]{n});
        if (n == 0) {
            String string = this.m_voCurrentAnalogTransmitOffsetDelay.getText();
            int n2 = string.lastIndexOf(46);
            if (n2 != -1) {
                string = string.substring(0, n2 + 2);
            }
            this.m_voStoredAnalogTransmitOffsetDelay.setText(string);
        } else {
            LOG.error((Object)"updateStoredAnalogXmitOffsetOnScreen - Error on getting Simulcast Transmit Offset Delay");
            this.m_alignment.popupError(-327701);
            this.m_voStoredAnalogTransmitOffsetDelay.setText("N/A");
        }
        this.m_window.unlockWindow();
        LOG.exit("updateStoredAnalogXmitOffsetOnScreen");
    }

    public void updateInitiateTestPattern(int n) {
        LOG.enter("updateInitiateTestPattern", new Object[]{n});
        if (n == 0) {
            this.m_testPatternBtn.setText(TEST_PATTERN_BUTTON_STOP_LABEL);
            this.setIsTestPaternStarted(true);
        } else if (!this.m_errorDialogShown) {
            LOG.error((Object)"updateInitiateTestPattern - Error on updating test pattern");
            this.m_alignment.popupError(-327689);
        } else {
            this.m_errorDialogShown = true;
        }
        this.m_window.unlockWindow();
        LOG.exit("updateInitiateTestPattern");
    }

    public void updateStopTestPattern(int n) {
        LOG.enter("updateStopTestPattern", new Object[]{n});
        if (n == 0) {
            this.m_testPatternBtn.setText(TEST_PATTERN_BUTTON_INITIATE_LABEL);
            this.setIsTestPaternStarted(false);
        } else if (!this.m_errorDialogShown) {
            LOG.error((Object)"updateStopTestPattern - Error on updating test pattern");
            this.m_alignment.popupError(-327689);
        } else {
            this.m_errorDialogShown = false;
        }
        this.m_window.unlockWindow();
        LOG.exit("updateStopTestPattern");
    }

    public boolean isSimulcastXmitOffsetDelayValid(String string) {
        Object object;
        boolean bl = true;
        LOG.enter("isSimulcastXmitOffsetDelayValid", new Object[]{string});
        if (string.indexOf(".") > 0) {
            object = "0*$";
            String string2 = "";
            string = string.replaceAll((String)object, string2);
        }
        this.m_window.lockWindow();
        try {
            object = new Float(string);
            float f = ((Float)object).floatValue();
            if ((double)f < 0.0 || (double)f > 1000.0) {
                bl = false;
            }
            if (string.indexOf(".") > 0 && string.indexOf(".") < string.length() - 2) {
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            LOG.error((Object)"isSimulcastXmitOffsetDelayValid", (Throwable)numberFormatException);
        }
        this.m_window.unlockWindow();
        LOG.exit("isSimulcastXmitOffsetDelayValid", (Object)bl);
        return bl;
    }

    public boolean validateTransmitOffsetDelay() {
        boolean bl = false;
        LOG.enter("validateTransmitOffsetDelay");
        String string = this.m_voCurrentTransmitOffsetDelay.getText();
        this.m_window.lockWindow();
        if (!string.isEmpty()) {
            bl = this.isSimulcastXmitOffsetDelayValid(string);
            if (!bl) {
                this.m_alignment.popupError(-327686);
                String string2 = ((CSSJTextField)this.m_voCurrentTransmitOffsetDelay).getStoredValue();
                this.m_voCurrentTransmitOffsetDelay.setText(string2);
                ((CSSJTextField)this.m_voCurrentTransmitOffsetDelay).setCurrentValue(string2);
            } else {
                ((CSSJTextField)this.m_voCurrentTransmitOffsetDelay).setStoredValue(string);
            }
        }
        this.m_window.unlockWindow();
        LOG.exit("validateTransmitOffsetDelay", (Object)bl);
        return bl;
    }

    public boolean validateAnalogTransmitOffsetDelay() {
        boolean bl = false;
        LOG.enter("validateAnalogTransmitOffsetDelay");
        String string = this.m_voCurrentAnalogTransmitOffsetDelay.getText();
        if (!string.isEmpty()) {
            bl = this.isSimulcastXmitOffsetDelayValid(string);
            if (!bl) {
                this.m_alignment.popupError(-327686);
                String string2 = ((CSSJTextField)this.m_voCurrentAnalogTransmitOffsetDelay).getStoredValue();
                this.m_voCurrentAnalogTransmitOffsetDelay.setText(string2);
                ((CSSJTextField)this.m_voCurrentAnalogTransmitOffsetDelay).setCurrentValue(string2);
            } else {
                ((CSSJTextField)this.m_voCurrentAnalogTransmitOffsetDelay).setStoredValue(string);
            }
        }
        LOG.exit("validateAnalogTransmitOffsetDelay", (Object)bl);
        return bl;
    }

    public boolean isInitiateTestPattern() {
        boolean bl = false;
        LOG.enter("isInitiateTestPattern");
        this.m_window.lockWindow();
        String string = this.m_testPatternBtn.getText();
        if (string.equalsIgnoreCase(TEST_PATTERN_BUTTON_INITIATE_LABEL)) {
            bl = true;
        }
        LOG.exit("isInitiateTestPattern", (Object)bl);
        return bl;
    }

    public JButton getTestPatternButton() {
        return this.m_testPatternBtn;
    }

    public void setIsSimulcastEnabled(boolean bl) {
        this.m_isSimulcastEnabled = bl;
    }

    public boolean getIsSimulcastEnabled() {
        return this.m_isSimulcastEnabled;
    }

    public void showErrorForSimulcastTestPattern(Integer n) {
        if (null == n) {
            this.m_alignment.popupError("Error during Simulcast Test Pattern!");
        } else {
            switch (n) {
                case 1: {
                    this.m_alignment.popupError(-327850);
                    break;
                }
                case 2: {
                    this.m_alignment.popupError(-327851);
                    break;
                }
                case 3: {
                    this.m_alignment.popupError(-327852);
                    break;
                }
                case 4: {
                    this.m_alignment.popupError(-327853);
                    break;
                }
                default: {
                    if (DeviceErrorCodes.isInGeneralErrorRange(n)) {
                        LOG.error((Object)("realTimeUpdate - Error data: " + n));
                        this.m_alignment.popupError(n);
                        break;
                    }
                    this.m_alignment.popupError("Error during Simulcast Test Pattern!");
                }
            }
        }
        this.m_testPatternBtn.setText(TEST_PATTERN_BUTTON_INITIATE_LABEL);
        this.setIsTestPaternStarted(false);
        this.m_errorDialogShown = true;
    }

    public class StopTestPattern_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            SummitAstroSimulcastAlignment.this.m_window.lockWindow();
            message.setProtocolKey(2106);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = SummitAstroSimulcastAlignment.this.getIsTestPaternStarted();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            SummitAstroSimulcastAlignment.this.m_window.unlockWindow();
            if (n != 0) {
                LOG.warn((Object)"update - error in Stop Test Pattern");
                SummitAstroSimulcastAlignment.this.m_alignment.popupError("Unable to Stop Test Pattern");
            } else {
                SummitAstroSimulcastAlignment.this.updateStopTestPattern(n);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class InitiateTestPattern_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            SummitAstroSimulcastAlignment.this.m_window.lockWindow();
            message.setProtocolKey(2105);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !SummitAstroSimulcastAlignment.this.getIsTestPaternStarted();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            SummitAstroSimulcastAlignment.this.m_window.unlockWindow();
            if (n != 0) {
                if (!SummitAstroSimulcastAlignment.this.m_errorDialogShown) {
                    LOG.warn((Object)"update - error in Initiate Test Pattern");
                    SummitAstroSimulcastAlignment.this.m_alignment.popupError("Unable to Initiate Test Pattern");
                } else {
                    SummitAstroSimulcastAlignment.this.m_errorDialogShown = false;
                }
            } else {
                SummitAstroSimulcastAlignment.this.updateInitiateTestPattern(n);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class StoreSimulcastTransmitOffsetDelay_Rule
    extends Rule {
        private final String sDigitalSimultcastDelay = "LTO";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("StoreSimulcastTransmitOffsetDelay_Rule.getMessage");
            SummitAstroSimulcastAlignment.this.m_window.lockWindow();
            Message message = new Message();
            message.addParameter("LTO", Short.class, (Object)SummitAstroSimulcastAlignment.this.getTransmitOffsetDelay());
            message.setProtocolKey(2104);
            LOG.exit("StoreSimulcastTransmitOffsetDelay_Rule.getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("StoreSimulcastTransmitOffsetDelay_Rule.condition", new Object[]{sessionIfc});
            boolean bl = SummitAstroSimulcastAlignment.this.validateTransmitOffsetDelay();
            LOG.exit("StoreSimulcastTransmitOffsetDelay_Rule.condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("StoreSimulcastTransmitOffsetDelay_Rule.update");
            SummitAstroSimulcastAlignment.this.m_window.unlockWindow();
            if (n != 0) {
                LOG.error((Object)"StoreSimulcastTransmitOffsetDelay_Rule.update - error setting Simulcast Xmit Delay");
                SummitAstroSimulcastAlignment.this.m_alignment.popupError(-327693);
            } else {
                SummitAstroSimulcastAlignment.this.updateStoredXmitOffsetOnScreen(n);
            }
            LOG.exit("StoreSimulcastTransmitOffsetDelay_Rule.update");
            return true;
        }
    }

    public class SetSimultcastDelayTemporary_Rule
    extends Rule {
        private final String sDigitalSimultcastDelay = "LTO";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            SummitAstroSimulcastAlignment.this.m_window.lockWindow();
            Message message = new Message();
            message.addParameter("LTO", Short.class, (Object)SummitAstroSimulcastAlignment.this.getTransmitOffsetDelay());
            message.setProtocolKey(2103);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = SummitAstroSimulcastAlignment.this.validateTransmitOffsetDelay();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            SummitAstroSimulcastAlignment.this.m_window.unlockWindow();
            if (n != 0) {
                LOG.error((Object)"SetSimultcastDelayTemporary_Rule.update - error setting Simulcast Delay");
                SummitAstroSimulcastAlignment.this.m_alignment.popupError(-327693);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetSimultcastDelay_Rule
    extends Rule {
        private final String sDigitalSimultcastDelay = "LTO";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("LTO", Byte[].class);
            message.setProtocolKey(2101);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            byte[] byArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.error((Object)"update - error getting (digital) Simulcast Delay");
                SummitAstroSimulcastAlignment.this.m_alignment.popupError(-327688);
                SummitAstroSimulcastAlignment.this.m_voStoredTransmitOffsetDelay.setText("N/A");
            } else if (null != messageIfc && null != (byArray = (byte[])messageIfc.getParameterValue("LTO"))) {
                Integer n2 = Convert.toInteger((byte[])byArray);
                double d = n2.doubleValue() / 10.0;
                String string = Double.toString(d);
                SummitAstroSimulcastAlignment.this.m_voStoredTransmitOffsetDelay.setText(string);
                SummitAstroSimulcastAlignment.this.m_voCurrentTransmitOffsetDelay.setText(string);
                ((CSSJTextField)SummitAstroSimulcastAlignment.this.m_voCurrentTransmitOffsetDelay).setCurrentValue(string);
                ((CSSJTextField)SummitAstroSimulcastAlignment.this.m_voCurrentTransmitOffsetDelay).setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetSimultcastTxFrequency_Rule
    extends Rule {
        public static final String XMIT_FREQ_FSP = "sTxFrequency";
        public static final String XMIT_FREQ_SNMP = "TxFreq";

        private boolean isConvbrOrMsBR3600() {
            Devices devices = Devices.getDeviceByName((String)MetadataAcquisitionService.getDeviceName());
            if (null == devices) {
                LOG.error((Object)"GetSimultcastTxFrequency_Rule - cannot get loaded device.");
            }
            return Devices.MSBR3600 == devices || Devices.CONVBR == devices || Devices.CONVBR_GEN2 == devices;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("GetSimultcastTxFrequency_Rule:getMessage");
            Message message = new Message();
            if (this.isConvbrOrMsBR3600()) {
                message.addParameter(XMIT_FREQ_FSP, Byte[].class);
                message.setProtocolKey(5319);
            } else {
                message.addParameter(XMIT_FREQ_SNMP, Integer[].class);
                message.setProtocolKey(1006);
            }
            LOG.exit("GetSimultcastTxFrequency_Rule:getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = SummitAstroSimulcastAlignment.this.m_alignment.isSimulcastApplication();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl = false;
            LOG.enter("GetSimultcastTxFrequency_Rule:update");
            if (messageIfc.getError() == 0) {
                Object object;
                Object object2 = null;
                if (this.isConvbrOrMsBR3600()) {
                    object = (byte[])messageIfc.getParameterValue(XMIT_FREQ_FSP);
                    if (null != object) {
                        object2 = Convert.toInteger((byte[])object);
                    }
                } else {
                    object = (Integer[])messageIfc.getParameterValue(XMIT_FREQ_SNMP);
                    if (null != object && ((byte[])object).length > 0) {
                        object2 = object[0];
                    }
                }
                if (null != object2) {
                    object = (double)object2.intValue() / 1000000.0;
                    String string = String.format(Locale.ENGLISH, "%.6f", object);
                    SummitAstroSimulcastAlignment.this.updateTxFreq(string);
                    bl = true;
                } else {
                    LOG.error((Object)"GetSimultcastTxFrequency_Rule: Tx frequency value received is null or empty.");
                    bl = false;
                }
            } else {
                LOG.error((Object)("GetSimultcastTxFrequency_Rule: error received in the message, code: " + messageIfc.getError()));
                bl = false;
            }
            LOG.exit("GetSimultcastTxFrequency_Rule:update");
            return bl;
        }
    }

    public class SimulcastAndStatTypeDeps_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sSimulcastOperation", Integer[].class);
            message.addParameter("sStationType", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Simulcast Operation and Station Type");
            } else if (null != messageIfc) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue("sStationType");
                Integer[] integerArray2 = (Integer[])messageIfc.getParameterValue("sSimulcastOperation");
                if (1 == integerArray2[0]) {
                    SummitAstroSimulcastAlignment.this.setIsSimulcastEnabled(true);
                } else {
                    SummitAstroSimulcastAlignment.this.setIsSimulcastEnabled(false);
                }
                if (2 == integerArray[0]) {
                    SummitAstroSimulcastAlignment.this.m_testPatternBtn.setEnabled(false);
                } else if (SummitAstroSimulcastAlignment.this.m_alignment.isDeviceInServiceMode()) {
                    SummitAstroSimulcastAlignment.this.m_testPatternBtn.setEnabled(true);
                }
            }
            LOG.exit("update");
            return true;
        }
    }
}

