/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.RealTimeDataObject;
import css.core.service.RealTimeUpdaterIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.component.CSSJTextField;
import css.device.platform.summit.screens.alignment.RxWirelinePanel;
import css.device.platform.summit.screens.alignment.TxWirelinePanel;
import java.util.Locale;

public class WirelineController
implements RealTimeUpdaterIfc {
    private static final CssLogger LOG = CssLogger.getCssLogger(WirelineController.class);
    public TxWirelinePanel m_txWirelinePanel = null;
    public boolean m_bErrorDialogShown = false;
    private RxWirelinePanel m_rxWirelinePanel;
    protected static final String TONE_ON = "Tone On";
    protected static final String TONE_OFF = "Tone Off";
    protected static final int MAX_LO_BOOST = 60;
    protected static final int MAX_HI_BOOST = 90;
    protected static final double MAX_STATUS_TONE = 0.0;
    protected static final double MIN_STATUS_TONE = -20.0;
    protected static final double MAX_RX_WIRELINE_LEVEL = 0.0;
    protected static final double MIN_RX_WIRELINE_LEVEL = -20.0;
    private int m_mode;
    private static final String ERROR_INVALID_ALERT_TONE = "Invalid Rx Wireline Alert Tone value.\nThe valid range for this field is: -45 to 0 dB.";
    private static final String ERROR_INVALID_STATUS_TONE = "Invalid Status Tone value.\nThe valid range for this field is: -20 to 0 dB.";
    private static final String ERROR_INVALID_STATUS_TONE_AFTER_LIMITATION = "Invalid Status Tone value.\nStatus Tone level cannot exceed 0 dBm.";
    private static final String ERROR_INVALID_WIRELINE_LEVEL_AFTER_LIMITATION = "Invalid Rx Wireline Level value.\nStatus Tone level cannot exceed 0 dBm.";
    private static final String ERROR_INVALID_HYSTERESIS = "Invalid Wireline Hysteresis Level value.\nThe valid range for this field is: 1 to 6 dB.";
    private static final String ERROR_INVALID_SQUELCH = "Invalid Wireline Squelch Level value.\nThe valid range for this field is: -50 to -20 dBm.";
    private static final String ERROR_INVALID_TX_LINE1 = "Invalid Tx Wireline Line1 Level value.\nThe valid range for this field is: -35 to 0 dBm.";
    private static final String ERROR_INVALID_TX_LINE3 = "Invalid Tx Wireline Line3 Level value.\nThe valid range for this field is: -35 to 0 dBm.";
    private static final String ERROR_INVALID_RX_LEVEL = "Invalid Rx Wireline Level value.\nThe valid range for this field is: -20 to 0 dBm.";
    private static final String ERROR_INVALID_LO_BOOST_ADJUST_LEVEL = "Invalid Lo Boost Adjust Level value.\nThe valid range for this field is: 0 to 6 dB.";
    private static final String ERROR_INVALID_HI_BOOST_ADJUST_LEVEL = "Invalid Hi Boost Adjust Level value.\nThe valid range for this field is: 0 to 9 dB.";

    public void setTxWirelineView(TxWirelinePanel txWirelinePanel) {
        this.m_txWirelinePanel = txWirelinePanel;
    }

    public TxWirelinePanel getTxView() {
        return this.m_txWirelinePanel;
    }

    public void setRxWirelineView(RxWirelinePanel rxWirelinePanel) {
        LOG.enter("setRxWirelineView");
        this.m_rxWirelinePanel = rxWirelinePanel;
        LOG.exit("setRxWirelineView");
    }

    public RxWirelinePanel getRxView() {
        return this.m_rxWirelinePanel;
    }

    private boolean validateRxHiBoostFreq(String string) {
        boolean bl = false;
        CSSJTextField cSSJTextField = (CSSJTextField)this.getRxView().getCurrentWirelineHiBoostFreqComponent();
        String string2 = cSSJTextField.getStoredValue();
        try {
            Integer n = new Integer(string);
            if (n >= 2000 && n <= 3000) {
                bl = true;
            }
            return bl;
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return (Boolean)null;
        }
    }

    public void realTimeUpdate(RealTimeDataObject realTimeDataObject) {
        LOG.enter("realTimeUpdate");
        LOG.exit("realTimeUpdate");
    }

    public int createFrequencyFromBytes(byte by, byte by2) {
        int n = 0;
        n = (short)(n + (0xFF & (short)by));
        n = (short)(n << 8);
        n = (short)(n + (0xFF & (short)by2));
        return n;
    }

    public int convertBytes2Int(byte by, byte by2) {
        int n = 0;
        n += 0xFF & (short)by;
        n = (short)(n << 8);
        return n += 0xFF & (short)by2;
    }

    protected boolean CheckLimitationDependency(double d, double d2) {
        boolean bl = false;
        double d3 = d + d2 + 4.4;
        if ((d3 = this.roundValue(d3, 10)) <= 0.0) {
            bl = true;
        }
        return bl;
    }

    protected String formatValue(Integer n, int n2) {
        if (0 != n) {
            return String.format(Locale.ENGLISH, "%.1f", Float.valueOf(n.floatValue() / (float)n2));
        }
        return String.format(Locale.ENGLISH, "%.1f", Float.valueOf(n.floatValue()));
    }

    protected int convertByteToIntUnsigned(byte by) {
        return 0xFF & by;
    }

    protected Integer convertValue(String string, int n) {
        Double d = new Double(string) * (double)n;
        Integer n2 = d.intValue();
        return n2;
    }

    public double roundValue(double d, int n) {
        long l = Math.round(d *= (double)n);
        return (double)l / (double)n;
    }

    protected Integer getCurrentWirelineAlertTone() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getRxView().getCurrentWirelineAlertToneComponent();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, -10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getCurrentHiBoost() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getRxView().getCurrentWirelineHiBoostComponent();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getCurrentLoBoost() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getRxView().getCurrentWirelineLoBoostComponent();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, 10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getCurrentWirelineLine1() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getRxView().getCurrentWirelineLine1Component();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, -10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getCurrentHysteresis() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getTxView().getHysteresisComponent();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, 1);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getCurrentSquelch() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getTxView().getSquelchComponent();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, -1);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getTxWirelineLine1() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getTxView().getCurrent1kHzLevelLine1Component();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, -10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    protected Integer getTxWirelineLine3() {
        CSSJTextField cSSJTextField = (CSSJTextField)this.getTxView().getCurrent1kHzLevelLine3Component();
        String string = cSSJTextField.getText();
        String string2 = cSSJTextField.getStoredValue();
        try {
            return this.convertValue(string, -10);
        }
        catch (NumberFormatException numberFormatException) {
            cSSJTextField.setText(string2);
            cSSJTextField.setCurrentValue(string2);
            return null;
        }
    }

    public void setDeviceMode(int n) {
        this.m_mode = n;
    }

    public class SetWirelineTonesButtonsOFF_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = WirelineController.this.getRxView().getWirelineButton().isSelected() || WirelineController.this.getRxView().getHiBoostButton().isSelected() || WirelineController.this.getRxView().getStatusButton().isSelected() || WirelineController.this.getRxView().getLoBoostButton().isSelected() || WirelineController.this.getRxView().getWirelineButton().getText().equals(WirelineController.TONE_OFF) || WirelineController.this.getRxView().getHiBoostButton().getText().equals(WirelineController.TONE_OFF) || WirelineController.this.getRxView().getStatusButton().getText().equals(WirelineController.TONE_OFF) || WirelineController.this.getRxView().getLoBoostButton().getText().equals(WirelineController.TONE_OFF);
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5318);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Tones ON/OFF Buttons to OFF.");
                LOG.error((Object)"SetWirelineTonesButtonsOFF_Rule failed ");
            } else {
                WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_ON);
                WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_ON);
                WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_ON);
                WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_ON);
                WirelineController.this.getRxView().getWirelineButton().setSelected(false);
                WirelineController.this.getRxView().getHiBoostButton().setSelected(false);
                WirelineController.this.getRxView().getStatusButton().setSelected(false);
                WirelineController.this.getRxView().getLoBoostButton().setSelected(false);
                WirelineController.this.getRxView().setWirelineOn(false);
                WirelineController.this.getRxView().setLoBoostOn(false);
                WirelineController.this.getRxView().setHiBoostOn(false);
                WirelineController.this.getRxView().setStatusOn(false);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineToneStatus_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (WirelineController.this.getRxView().getStatusButton().isSelected()) {
                message.setProtocolKey(5317);
            } else {
                message.setProtocolKey(5318);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Tone Status " + (WirelineController.this.getRxView().getStatusButton().isSelected() ? "On" : "Off"));
                WirelineController.this.getRxView().getStatusButton().setSelected(WirelineController.this.getRxView().isStatusOn());
                LOG.warn((Object)"SetWirelineToneStatus() failed ");
            } else {
                WirelineController.this.getRxView().setStatusOn(WirelineController.this.getRxView().getStatusButton().isSelected());
                if (WirelineController.this.getRxView().isStatusOn()) {
                    WirelineController.this.getRxView().getWirelineButton().setSelected(false);
                    WirelineController.this.getRxView().setWirelineOn(false);
                    WirelineController.this.getRxView().getLoBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setLoBoostOn(false);
                    WirelineController.this.getRxView().getHiBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setHiBoostOn(false);
                    WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_OFF);
                    WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_ON);
                } else {
                    WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_ON);
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineToneHiBoost_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (WirelineController.this.getRxView().getHiBoostButton().isSelected()) {
                message.setProtocolKey(5316);
            } else {
                message.setProtocolKey(5318);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Hi Boost " + (WirelineController.this.getRxView().getHiBoostButton().isSelected() ? "On" : "Off"));
                WirelineController.this.getRxView().getHiBoostButton().setSelected(WirelineController.this.getRxView().isHiBoostOn());
                LOG.warn((Object)"SetWirelineToneHiBoost() failed ");
            } else {
                WirelineController.this.getRxView().setHiBoostOn(WirelineController.this.getRxView().getHiBoostButton().isSelected());
                if (WirelineController.this.getRxView().isHiBoostOn()) {
                    WirelineController.this.getRxView().getWirelineButton().setSelected(false);
                    WirelineController.this.getRxView().setWirelineOn(false);
                    WirelineController.this.getRxView().getLoBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setLoBoostOn(false);
                    WirelineController.this.getRxView().getStatusButton().setSelected(false);
                    WirelineController.this.getRxView().setStatusOn(false);
                    WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_OFF);
                    WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_ON);
                } else {
                    WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_ON);
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineToneLoBoost_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (WirelineController.this.getRxView().getLoBoostButton().isSelected()) {
                message.setProtocolKey(5315);
            } else {
                message.setProtocolKey(5318);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Lo Boost " + (WirelineController.this.getRxView().getLoBoostButton().isSelected() ? "On" : "Off"));
                WirelineController.this.getRxView().getLoBoostButton().setSelected(WirelineController.this.getRxView().isLoBoostOn());
                LOG.warn((Object)"SetWirelineToneLoBoost() failed ");
            } else {
                WirelineController.this.getRxView().setLoBoostOn(WirelineController.this.getRxView().getLoBoostButton().isSelected());
                if (WirelineController.this.getRxView().isLoBoostOn()) {
                    WirelineController.this.getRxView().getWirelineButton().setSelected(false);
                    WirelineController.this.getRxView().setWirelineOn(false);
                    WirelineController.this.getRxView().getHiBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setHiBoostOn(false);
                    WirelineController.this.getRxView().getStatusButton().setSelected(false);
                    WirelineController.this.getRxView().setStatusOn(false);
                    WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_OFF);
                    WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_ON);
                } else {
                    WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_ON);
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineToneLevel1_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            if (WirelineController.this.getRxView().getWirelineButton().isSelected()) {
                message.setProtocolKey(5314);
            } else {
                message.setProtocolKey(5318);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Tone 1 " + (WirelineController.this.getRxView().getWirelineButton().isSelected() ? "On" : "Off"));
                WirelineController.this.getRxView().getWirelineButton().setSelected(WirelineController.this.getRxView().isWirelineOn());
                LOG.warn((Object)"SetWirelineToneLevel1() failed ");
            } else {
                WirelineController.this.getRxView().setWirelineOn(WirelineController.this.getRxView().getWirelineButton().isSelected());
                if (WirelineController.this.getRxView().isWirelineOn()) {
                    WirelineController.this.getRxView().getLoBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setLoBoostOn(false);
                    WirelineController.this.getRxView().getHiBoostButton().setSelected(false);
                    WirelineController.this.getRxView().setHiBoostOn(false);
                    WirelineController.this.getRxView().getStatusButton().setSelected(false);
                    WirelineController.this.getRxView().setStatusOn(false);
                    WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_OFF);
                    WirelineController.this.getRxView().getLoBoostButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getHiBoostButton().setText(WirelineController.TONE_ON);
                    WirelineController.this.getRxView().getStatusButton().setText(WirelineController.TONE_ON);
                } else {
                    WirelineController.this.getRxView().getWirelineButton().setText(WirelineController.TONE_ON);
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineAlertTone_Rule
    extends Rule {
        public static final String setWirelineAlertTone = "setWirelineAlertTone";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Integer n = null;
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineAlertToneComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            n = WirelineController.this.getCurrentWirelineAlertTone();
            if (null != n) {
                if (n >= 0 && n <= 450) {
                    message = new Message();
                    message.addParameter(setWirelineAlertTone, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5308);
                } else {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_ALERT_TONE);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Alert Tone.");
                LOG.error((Object)"setWirelineAlertTone() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineAlertToneComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineStatusTone_Rule
    extends Rule {
        public static final String setWirelineStatusTone = "setWirelineStatusTone";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            boolean bl = false;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            String string2 = cSSJTextField.getStoredValue();
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            try {
                double d = new Double(string);
                if (d >= -20.0 && d <= 0.0) {
                    String string3 = WirelineController.this.getRxView().getCurrentWirelineLine1Component().getText();
                    double d2 = new Double(string3);
                    if (WirelineController.this.CheckLimitationDependency(d, d2)) {
                        message = new Message();
                        Integer n = WirelineController.this.convertValue(string, -10);
                        message.addParameter(setWirelineStatusTone, Short.TYPE, (Object)n.shortValue());
                        message.setProtocolKey(5307);
                    } else {
                        bl = true;
                        WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_STATUS_TONE_AFTER_LIMITATION);
                    }
                } else {
                    bl = true;
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_STATUS_TONE);
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                cSSJTextField.setText(string2);
                cSSJTextField.setCurrentValue(string2);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Status Tone.");
                LOG.error((Object)"setWirelineStatusTone() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineHiBoostFreq_Rule
    extends Rule {
        public static final String setWirelineHiBoostFreq = "setWirelineHiBoostFreq";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            String string = WirelineController.this.getRxView().getCurrentWirelineHiBoostFreqComponent().getText();
            Boolean bl = WirelineController.this.validateRxHiBoostFreq(string);
            if (null != bl) {
                if (!bl.booleanValue()) {
                    CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineHiBoostFreqComponent();
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError("Invalid Rx Wireline Hi Boost Frequency value.\nThe valid range for Hi Boost Frequency is 2000 - 3000 Hz.");
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                } else {
                    message = new Message();
                    message.addParameter(setWirelineHiBoostFreq, Short.TYPE, (Object)new Integer(string).shortValue());
                    message.setProtocolKey(5306);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Hi Boost Frequency.");
                LOG.error((Object)"setWirelineHiBoostFreq() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineHiBoostFreqComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineHiBoost_Rule
    extends Rule {
        public static final String setWirelineHiBoost = "setWirelineHiBoost";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getCurrentHiBoost();
            if (null != n) {
                if (90 < n || 0 > n) {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_HI_BOOST_ADJUST_LEVEL);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                } else {
                    message = new Message();
                    message.addParameter(setWirelineHiBoost, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5305);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Hi Boost level.");
                LOG.error((Object)"setWirelineHiBoost() failed");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineLoBoost_Rule
    extends Rule {
        public static final String setWirelineLoBoost = "setWirelineLoBoost";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getCurrentLoBoost();
            if (null != n) {
                if (60 < n || 0 > n) {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_LO_BOOST_ADJUST_LEVEL);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                } else {
                    message = new Message();
                    message.addParameter(setWirelineLoBoost, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5304);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Lo Boost level.");
                LOG.error((Object)"setWirelineLoBoost() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineRxLine_Rule
    extends Rule {
        public static final String setWirelineLine1 = "setWireline1kHz";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            boolean bl = false;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineLine1Component();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            String string2 = cSSJTextField.getStoredValue();
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            try {
                double d = new Double(string);
                if (d >= -20.0 && d <= 0.0) {
                    String string3 = WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent().getText();
                    double d2 = new Double(string3);
                    if (WirelineController.this.CheckLimitationDependency(d2, d)) {
                        message = new Message();
                        Integer n = WirelineController.this.convertValue(string, -10);
                        message.addParameter(setWirelineLine1, Short.TYPE, (Object)n.shortValue());
                        message.setProtocolKey(5303);
                    } else {
                        bl = true;
                        WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_WIRELINE_LEVEL_AFTER_LIMITATION);
                    }
                } else {
                    bl = true;
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_RX_LEVEL);
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                cSSJTextField.setText(string2);
                cSSJTextField.setCurrentValue(string2);
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Rx Wireline Level.");
                LOG.error((Object)"setWirelineLine1() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getRxView().getCurrentWirelineLine1Component();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
                WirelineController.this.getRxView().setPeakAudioLevel(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineAlignment_Rule
    extends Rule {
        public static final String sSetWirelineAlignment = "setWirelineAlignment";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5313);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Wireline Alignment.");
                LOG.error((Object)"Save() failed ");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineHysteresis_Rule
    extends Rule {
        public static final String sSetWirelineLevels = "setWirelineHysteresis";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getHysteresisComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getCurrentHysteresis();
            if (null != n) {
                if (n >= 1 && n <= 6) {
                    message = new Message();
                    message.addParameter(sSetWirelineLevels, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5312);
                } else {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_HYSTERESIS);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Tx Wireline Hysteresis level.");
                LOG.error((Object)"setWirelineHysteresis() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getHysteresisComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWirelineSquelch_Rule
    extends Rule {
        public static final String sSetWirelineLevels = "setWirelineSquelch";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getSquelchComponent();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getCurrentSquelch();
            if (n != null) {
                if (n >= 20 && n <= 50) {
                    message = new Message();
                    message.addParameter(sSetWirelineLevels, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5311);
                } else {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_SQUELCH);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Tx Wireline Squelch level.");
                LOG.error((Object)"Save() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getSquelchComponent();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWireline1kHzLine3_Rule
    extends Rule {
        public static final String sSetWirelineLevels = "setWirelineLine3";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getCurrent1kHzLevelLine3Component();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getTxWirelineLine3();
            if (null != n) {
                if (n >= 0 && n <= 350) {
                    message = new Message();
                    message.addParameter(sSetWirelineLevels, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5310);
                } else {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_TX_LINE3);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Tx Wireline Line 3 Level.");
                LOG.error((Object)"Save() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getCurrent1kHzLevelLine3Component();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetWireline1kHzLine1_Rule
    extends Rule {
        public static final String sSetWirelineLevels = "setWirelineLine1";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getCurrent1kHzLevelLine1Component();
            String string = cSSJTextField.convertValueWithRounding(cSSJTextField.getText(), 1);
            cSSJTextField.setText(string);
            cSSJTextField.setCurrentValue(string);
            Integer n = WirelineController.this.getTxWirelineLine1();
            if (null != n) {
                if (n >= 0 && n <= 350) {
                    message = new Message();
                    message.addParameter(sSetWirelineLevels, Short.TYPE, (Object)n.shortValue());
                    message.setProtocolKey(5309);
                } else {
                    String string2 = cSSJTextField.getStoredValue();
                    WirelineController.this.getTxView().popupError(WirelineController.ERROR_INVALID_TX_LINE1);
                    cSSJTextField.setText(string2);
                    cSSJTextField.setCurrentValue(string2);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to set Tx Wireline Line 1 Level.");
                LOG.error((Object)"Save() failed ");
            } else {
                CSSJTextField cSSJTextField = (CSSJTextField)WirelineController.this.getTxView().getCurrent1kHzLevelLine1Component();
                String string = cSSJTextField.getCurrentValue();
                cSSJTextField.setText(string);
                cSSJTextField.setStoredValue(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Save_Rule
    extends Rule {
        public static final String sSaveWirelineLevels = "sSaveWirelineLevels";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5301);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                if (WirelineController.this.getTxView().getSaveButtonState()) {
                    WirelineController.this.getTxView().popupError("Unable to save Tx Wireline Levels.");
                    WirelineController.this.getTxView().setSaveButtonState(false);
                    LOG.error((Object)"Save() Tx levels failed ");
                } else if (WirelineController.this.getRxView().getSaveButtonState()) {
                    WirelineController.this.getTxView().popupError("Unable to save Rx Wireline Levels.");
                    WirelineController.this.getRxView().setSaveButtonState(false);
                    LOG.error((Object)"Save() Rx levels failed ");
                }
            } else if (WirelineController.this.getTxView().getSaveButtonState()) {
                WirelineController.this.getTxView().setStoredLine1Component(WirelineController.this.getTxView().getCurrent1kHzLevelLine1Component().getText());
                WirelineController.this.getTxView().setStoredLine3Component(WirelineController.this.getTxView().getCurrent1kHzLevelLine3Component().getText());
                WirelineController.this.getTxView().setSaveButtonState(false);
            } else if (WirelineController.this.getRxView().getSaveButtonState()) {
                WirelineController.this.getRxView().setStoredAlarmTone(WirelineController.this.getRxView().getCurrentWirelineAlertToneComponent().getText());
                WirelineController.this.getRxView().setStoredHiBoostFreq(Integer.parseInt(WirelineController.this.getRxView().getCurrentWirelineHiBoostFreqComponent().getText()));
                WirelineController.this.getRxView().setStoredHiBoostLevel(WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent().getText());
                WirelineController.this.getRxView().setStoredLoBoostLevel(WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent().getText());
                WirelineController.this.getRxView().setStoredStatusTone(WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent().getText());
                WirelineController.this.getRxView().setStoredWirelineLevel(WirelineController.this.getRxView().getCurrentWirelineLine1Component().getText());
                WirelineController.this.getRxView().setSaveButtonState(false);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Get_KeyUp_DeKey_Line3_Status_Rule
    extends Rule {
        public static final String sKeyupDeKeyStatus = "sTransmitterMode";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sKeyupDeKeyStatus, Byte.class);
            message.setProtocolKey(2199);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to get the status of running ASTRO Symbol Test Pattern.");
                LOG.error((Object)"Get_KeyUp_DeKey_Line3_Status_Rule() failed ");
                WirelineController.this.m_txWirelinePanel.setKeyUpLine3(true);
            } else if (messageIfc != null) {
                if ((Byte)messageIfc.getParameterValue(sKeyupDeKeyStatus) == 1) {
                    WirelineController.this.m_txWirelinePanel.setKeyUpLine3(false);
                } else {
                    WirelineController.this.m_txWirelinePanel.setKeyUpLine3(true);
                }
            } else {
                LOG.error((Object)"update - Get_KeyUp_DeKey_Line3_Status_Rule - null packet received");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Get_KeyUp_DeKey_Line1_Status_Rule
    extends Rule {
        public static final String sKeyupDeKeyStatus = "sTransmitterMode";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(sKeyupDeKeyStatus, Byte.class);
            message.setProtocolKey(2199);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                WirelineController.this.getTxView().popupError("Unable to get the status of running ASTRO Symbol Test Pattern.");
                LOG.error((Object)"Get_KeyUp_DeKey_Line1_Status_Rule() failed ");
                WirelineController.this.m_txWirelinePanel.setKeyUpLine1(true);
            } else if (messageIfc != null) {
                if ((Byte)messageIfc.getParameterValue(sKeyupDeKeyStatus) == 1) {
                    WirelineController.this.m_txWirelinePanel.setKeyUpLine1(false);
                } else {
                    WirelineController.this.m_txWirelinePanel.setKeyUpLine1(true);
                }
            } else {
                LOG.error((Object)"update - Get_KeyUp_DeKey_Line3_Status_Rule - null packet received");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class DeKeyLine3_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_DEKEY_GENERIC = 6;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !WirelineController.this.m_txWirelinePanel.isKeyUpLine3();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            WirelineController.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)6);
            message.setProtocolKey(2198);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!WirelineController.this.m_bErrorDialogShown) {
                    WirelineController.this.m_bErrorDialogShown = true;
                    WirelineController.this.getTxView().popupError("Unable to dekey station.");
                }
                LOG.error((Object)"DeKeyLine3_Rule() failed ");
            } else {
                WirelineController.this.m_txWirelinePanel.setKeyUpLine3(!WirelineController.this.m_txWirelinePanel.isKeyUpLine3());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class DeKeyLine1_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_DEKEY_GENERIC = 5;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = !WirelineController.this.m_txWirelinePanel.isKeyUpLine1();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            WirelineController.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)5);
            message.setProtocolKey(2198);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!WirelineController.this.m_bErrorDialogShown) {
                    WirelineController.this.m_bErrorDialogShown = true;
                    WirelineController.this.getTxView().popupError("Unable to dekey station.");
                }
                LOG.error((Object)"DeKey_Rule() failed ");
            } else {
                WirelineController.this.m_txWirelinePanel.setKeyUpLine1(!WirelineController.this.m_txWirelinePanel.isKeyUpLine1());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class KeyUpLine3_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_KEYUP_GENERIC = 6;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = WirelineController.this.m_txWirelinePanel.isKeyUpLine3();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            WirelineController.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)6);
            message.setProtocolKey(2196);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!WirelineController.this.m_bErrorDialogShown) {
                    WirelineController.this.m_bErrorDialogShown = true;
                    WirelineController.this.getTxView().popupError("Unable to keyup the Station and route Tx wireline Line 3 to the transmitter.");
                }
                LOG.error((Object)"KeyUpLine3_Rule() failed ");
            } else {
                WirelineController.this.m_txWirelinePanel.setKeyUpLine3(!WirelineController.this.m_txWirelinePanel.isKeyUpLine3());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class KeyUpLine1_Rule
    extends Rule {
        public static final String sInputKeyup = "sTransmitterMode";
        final int INPUT_KEYUP_GENERIC = 5;

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = WirelineController.this.m_txWirelinePanel.isKeyUpLine1();
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            WirelineController.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter(sInputKeyup, Integer.class, (Object)5);
            message.setProtocolKey(2196);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (messageIfc.getError() != 0) {
                if (!WirelineController.this.m_bErrorDialogShown) {
                    WirelineController.this.m_bErrorDialogShown = true;
                    WirelineController.this.getTxView().popupError("Unable to keyup the Station and route Tx wireline Line 1 to the transmitter.");
                }
                LOG.error((Object)"KeyUpLine1_Rule() failed ");
            } else {
                WirelineController.this.m_txWirelinePanel.setKeyUpLine1(!WirelineController.this.m_txWirelinePanel.isKeyUpLine1());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetWirelineLevels_Rule
    extends Rule {
        private final String sWirelineGetLevels = "sWirelineGetLevels";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            WirelineController.this.m_bErrorDialogShown = false;
            Message message = new Message();
            message.addParameter("sWirelineGetLevels", Byte[].class);
            message.setProtocolKey(5300);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                if (!WirelineController.this.m_bErrorDialogShown) {
                    WirelineController.this.m_bErrorDialogShown = true;
                    WirelineController.this.getTxView().popupError("Unable to get Wireline Levels from the device.");
                }
            } else if (null != messageIfc) {
                byte[] byArray = (byte[])messageIfc.getParameterValue("sWirelineGetLevels");
                if (null != byArray) {
                    int n2 = WirelineController.this.convertBytes2Int(byArray[0], byArray[1]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentWirelineLevel(WirelineController.this.formatValue(n2, -10));
                    WirelineController.this.m_rxWirelinePanel.setStoredWirelineLevel(WirelineController.this.formatValue(n2, -10));
                    int n3 = WirelineController.this.convertBytes2Int(byArray[2], byArray[3]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentLoBoostLevel(WirelineController.this.formatValue(n3, 10));
                    WirelineController.this.m_rxWirelinePanel.setStoredLoBoostLevel(WirelineController.this.formatValue(n3, 10));
                    int n4 = WirelineController.this.convertBytes2Int(byArray[4], byArray[5]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentHiBoostLevel(WirelineController.this.formatValue(n4, 10));
                    WirelineController.this.m_rxWirelinePanel.setStoredHiBoostLevel(WirelineController.this.formatValue(n4, 10));
                    int n5 = WirelineController.this.createFrequencyFromBytes(byArray[6], byArray[7]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentHiBoostFreq(n5);
                    WirelineController.this.m_rxWirelinePanel.setStoredHiBoostFreq(n5);
                    int n6 = WirelineController.this.convertBytes2Int(byArray[8], byArray[9]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentStatusTone(WirelineController.this.formatValue(n6, -10));
                    WirelineController.this.m_rxWirelinePanel.setStoredStatusTone(WirelineController.this.formatValue(n6, -10));
                    int n7 = WirelineController.this.convertBytes2Int(byArray[10], byArray[11]);
                    WirelineController.this.m_rxWirelinePanel.setCurrentAlarmTone(WirelineController.this.formatValue(n7, -10));
                    WirelineController.this.m_rxWirelinePanel.setStoredAlarmTone(WirelineController.this.formatValue(n7, -10));
                    int n8 = WirelineController.this.convertBytes2Int(byArray[12], byArray[13]);
                    WirelineController.this.m_txWirelinePanel.set1kHzLevelLine1(WirelineController.this.formatValue(n8, -10));
                    WirelineController.this.m_txWirelinePanel.setCurrent1kHzLevelLine1Component(WirelineController.this.formatValue(n8, -10));
                    int n9 = WirelineController.this.convertBytes2Int(byArray[14], byArray[15]);
                    WirelineController.this.m_txWirelinePanel.set1kHzLevelLine3(WirelineController.this.formatValue(n9, -10));
                    WirelineController.this.m_txWirelinePanel.setCurrent1kHzLevelLine3Component(WirelineController.this.formatValue(n9, -10));
                    int n10 = WirelineController.this.convertBytes2Int(byArray[16], byArray[17]);
                    WirelineController.this.m_txWirelinePanel.setSquelchLevel(WirelineController.this.formatValue(n10, -1));
                    int n11 = WirelineController.this.convertBytes2Int(byArray[18], byArray[19]);
                    WirelineController.this.m_txWirelinePanel.setHysteresis(WirelineController.this.formatValue(n11, 1));
                } else {
                    LOG.error((Object)"update - GetWirelineLevels - null packet received");
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetAutomaticLevelControl_Rule
    extends Rule {
        private final String sAutomaticLevelControl = "sAutomaticLevelControl";

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("GetAutomaticLevelControl_Rule.condition", new Object[]{sessionIfc});
            boolean bl = true;
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.is3600Application((String)string).booleanValue()) {
                bl = false;
            }
            LOG.exit("GetAutomaticLevelControl_Rule.condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("GetAutomaticLevelControl_Rule.getMessage");
            Message message = new Message();
            message.addParameter("sAutomaticLevelControl", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("GetAutomaticLevelControl_Rule.update");
            if (n != 0) {
                LOG.error((Object)"GetAutomaticLevelControl_Rule.update - error getting Current Automatic Level Control");
            } else if (null != messageIfc) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue("sAutomaticLevelControl");
                if (1 == integerArray[0]) {
                    WirelineController.this.getTxView().getCurrent1kHzLevelLine1Component().setEnabled(false);
                    WirelineController.this.getTxView().setCurrent1kHzLevelLine1Component("");
                    WirelineController.this.getTxView().setStoredLine1Component("");
                } else {
                    WirelineController.this.getTxView().getCurrent1kHzLevelLine1Component().setEnabled(true);
                }
            } else {
                LOG.error((Object)"GetAutomaticLevelControl_Rule.update - oMessage is null");
            }
            LOG.exit("GetAutomaticLevelControl_Rule.update");
            return true;
        }
    }

    public class GetWirelineEqualization_Rule
    extends Rule {
        private final String sWirelineEqualization = "sWirelineEqualization";

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("GetWirelineEqualization_Rule.condition", new Object[]{sessionIfc});
            boolean bl = true;
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.isIR3600Application((String)string).booleanValue()) {
                bl = false;
            }
            LOG.exit("GetWirelineEqualization_Rule.condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("GetWirelineEqualization_Rule.getMessage");
            Message message = new Message();
            message.addParameter("sWirelineEqualization", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("GetWirelineEqualization_Rule.update");
            if (n != 0) {
                LOG.error((Object)"GetWirelineEqualization_Rule.update - error getting Current Wireline Equalization");
            } else if (null != messageIfc) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue("sWirelineEqualization");
                if (2 == integerArray[0]) {
                    WirelineController.this.getRxView().getLoBoostButton().setEnabled(false);
                    WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent().setEnabled(false);
                    WirelineController.this.getRxView().getHiBoostButton().setEnabled(false);
                    WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent().setEnabled(false);
                } else if (WirelineController.this.m_mode == 2) {
                    WirelineController.this.getRxView().getLoBoostButton().setEnabled(false);
                    WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent().setEnabled(true);
                    WirelineController.this.getRxView().getHiBoostButton().setEnabled(false);
                    WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent().setEnabled(true);
                } else {
                    WirelineController.this.getRxView().getLoBoostButton().setEnabled(true);
                    WirelineController.this.getRxView().getCurrentWirelineLoBoostComponent().setEnabled(true);
                    WirelineController.this.getRxView().getHiBoostButton().setEnabled(true);
                    WirelineController.this.getRxView().getCurrentWirelineHiBoostComponent().setEnabled(true);
                }
            } else {
                LOG.error((Object)"GetWirelineEqualization_Rule.update - oMessage is null");
            }
            LOG.exit("GetWirelineEqualization_Rule.update");
            return true;
        }
    }

    public class GetStatusToneAndAnalogIdleLinkCheck_Rule
    extends Rule {
        private final String sWirelineStatusTone = "sWirelineStatusTone";
        private final String sAnalogIdleLinkCheck = "sAnalogIdleLinkCheck";

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("GetStatusToneAndAnalogIdleLinkCheck_Rule.condition", new Object[]{sessionIfc});
            boolean bl = true;
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.isIR3600Application((String)string).booleanValue()) {
                bl = false;
            }
            LOG.exit("GetStatusToneAndAnalogIdleLinkCheck_Rule.condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("GetStatusToneAndAnalogIdleLinkCheck_Rule.getMessage");
            Message message = new Message();
            message.addParameter("sWirelineStatusTone", Integer[].class);
            message.addParameter("sAnalogIdleLinkCheck", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("GetStatusToneAndAnalogIdleLinkCheck_Rule.update");
            if (n != 0) {
                LOG.error((Object)"GetStatusToneAndAnalogIdleLinkCheck_Rule.update - error getting SNMP parameters");
            } else if (null != messageIfc) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue("sWirelineStatusTone");
                Integer[] integerArray2 = (Integer[])messageIfc.getParameterValue("sAnalogIdleLinkCheck");
                if (1 == integerArray[0] || 1 == integerArray2[0]) {
                    if (WirelineController.this.m_mode == 2) {
                        WirelineController.this.getRxView().getStatusButton().setEnabled(false);
                        WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent().setEnabled(true);
                    } else {
                        WirelineController.this.getRxView().getStatusButton().setEnabled(true);
                        WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent().setEnabled(true);
                    }
                } else {
                    WirelineController.this.getRxView().getStatusButton().setEnabled(false);
                    WirelineController.this.getRxView().getCurrentWirelineStatusToneComponent().setEnabled(false);
                }
            } else {
                LOG.error((Object)"GetStatusToneAndAnalogIdleLinkCheck_Rule.update - oMessage is null");
            }
            LOG.exit("GetStatusToneAndAnalogIdleLinkCheck_Rule.update");
            return true;
        }
    }

    public class GetTxFrequency_Rule
    extends Rule {
        private final String sTxFrequency = "sTxFrequency";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sTxFrequency", Byte[].class);
            message.setProtocolKey(5319);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            byte[] byArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Current Transmitter Frequency");
            } else if (null != messageIfc && null != (byArray = (byte[])messageIfc.getParameterValue("sTxFrequency"))) {
                Integer n2 = Convert.toInteger((byte[])byArray);
                Double d = (double)n2.intValue() / 1000000.0;
                String string = Double.toString(d);
                WirelineController.this.m_txWirelinePanel.setTransmitterFrequency(string);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetWirelineSquelch_Rule
    extends Rule {
        private final String sWirelineSquelch = "sWirelineSquelch";

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("GetWirelineSquelch_Rule.condition", new Object[]{sessionIfc});
            boolean bl = true;
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.is3600Application((String)string).booleanValue()) {
                bl = false;
            }
            LOG.exit("GetWirelineSquelch_Rule.condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("GetWirelineSquelch_Rule.getMessage");
            Message message = new Message();
            message.addParameter("sWirelineSquelch", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("GetWirelineSquelch_Rule.update");
            if (n != 0) {
                LOG.error((Object)"GetWirelineSquelch_Rule.update - error getting Wireline Squelch value");
            } else if (null != messageIfc) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue("sWirelineSquelch");
                if (1 == integerArray[0]) {
                    WirelineController.this.getTxView().getHysteresisComponent().setEnabled(true);
                    WirelineController.this.getTxView().getSquelchComponent().setEnabled(true);
                } else if (2 == integerArray[0]) {
                    WirelineController.this.getTxView().getHysteresisComponent().setEnabled(false);
                    WirelineController.this.getTxView().getSquelchComponent().setEnabled(false);
                } else {
                    LOG.error((Object)("GetWirelineSquelch_Rule.update: invalid Wireline Squelch value [" + integerArray + "]."));
                }
            } else {
                LOG.error((Object)"GetWirelineSquelch_Rule.update - oMessage is null");
            }
            LOG.exit("GetWirelineSquelch_Rule.update");
            return true;
        }
    }
}

