/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.referenceservice;

import css.core.util.CSSUtilities;
import css.device.sc_platform.common.screens.referenceservice.TimeReferenceSource;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class PrimarySecondaryTimeReferenceSource {
    private static final String DELIMETER = "/";
    private static Set<PrimarySecondaryTimeReferenceSource> rdmPairsMap = new LinkedHashSet<PrimarySecondaryTimeReferenceSource>();
    private static Set<PrimarySecondaryTimeReferenceSource> sscPairsMap;
    private static Set<PrimarySecondaryTimeReferenceSource> allowedPairs;
    private TimeReferenceSource primarySource;
    private TimeReferenceSource secondarySource;

    public PrimarySecondaryTimeReferenceSource(TimeReferenceSource timeReferenceSource, TimeReferenceSource timeReferenceSource2) {
        this.primarySource = timeReferenceSource;
        this.secondarySource = timeReferenceSource2;
    }

    public String toString() {
        return (Object)((Object)this.primarySource) + DELIMETER + (Object)((Object)this.secondarySource);
    }

    public static Vector<PrimarySecondaryTimeReferenceSource> getValues() {
        return new Vector<PrimarySecondaryTimeReferenceSource>(allowedPairs);
    }

    public static PrimarySecondaryTimeReferenceSource getDefaultValue() {
        if (CSSUtilities.isRdm()) {
            return new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.GPSR, TimeReferenceSource.REDUNDANT);
        }
        return new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.EXTERNAL, TimeReferenceSource.NONE);
    }

    public static PrimarySecondaryTimeReferenceSource getPrimarySecondaryTimeReferenceSource(TimeReferenceSource timeReferenceSource, TimeReferenceSource timeReferenceSource2) {
        PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource = null;
        for (PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource2 : allowedPairs) {
            if (primarySecondaryTimeReferenceSource2.getTimeReferenceSource(1) != timeReferenceSource || primarySecondaryTimeReferenceSource2.getTimeReferenceSource(2) != timeReferenceSource2) continue;
            primarySecondaryTimeReferenceSource = primarySecondaryTimeReferenceSource2;
        }
        return primarySecondaryTimeReferenceSource;
    }

    public TimeReferenceSource getTimeReferenceSource(int n) {
        if (1 == n) {
            return this.primarySource;
        }
        return this.secondarySource;
    }

    static {
        rdmPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.GPSR, TimeReferenceSource.REDUNDANT));
        rdmPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.GPSR, TimeReferenceSource.EXTERNAL));
        rdmPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.EXTERNAL));
        rdmPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.EXTERNAL, TimeReferenceSource.REDUNDANT));
        rdmPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.NONE));
        sscPairsMap = new LinkedHashSet<PrimarySecondaryTimeReferenceSource>();
        sscPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.EXTERNAL, TimeReferenceSource.NONE));
        sscPairsMap.add(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.NONE));
        allowedPairs = CSSUtilities.isRdm() ? rdmPairsMap : sscPairsMap;
    }
}

