/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.referenceservice;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.NmaBoolean;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.service.Serviceable;
import css.device.sc_platform.common.screens.referenceservice.PrimarySecondaryTimeReferenceSource;
import css.device.sc_platform.common.screens.referenceservice.ReferenceServiceScreenGUI;
import css.device.sc_platform.common.screens.referenceservice.TimeReferenceSource;
import java.util.Vector;

public class ReferenceServiceScreen
extends ReferenceServiceScreenGUI
implements Serviceable {
    public static final String scCommonRefSvcSourceTypeRequested = "scCommonRefSvcSourceTypeRequested";
    private static final CssLogger LOG = CssLogger.getCssLogger(ReferenceServiceScreen.class);
    private static final long serialVersionUID = 1L;
    protected static final String ERROR_MESSAGE = "Error In Getting Some Of The Reference Service Parameters.";
    private static final String REQUESTED_TIME_REFERENCE_SOURCE_ERROR = "Error while writing the Requested Time Reference Sources:";
    private static final String REQUESTED_PRIMARY_TIME_REFERENCE_GET_ERROR = "Time Reference Configuration is not supported.";
    private static final Integer OTHER = 1;
    private static Integer scBoxNum;
    private static Integer scSitePlatType;

    @Override
    public void initialize() {
        this.bError = false;
    }

    @Override
    public void closeScreen(boolean bl) {
        LOG.enter("closeScreen");
        if (this.m_window != null) {
            this.m_window.unlockWindow();
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        LOG.exit("closeScreen");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        LOG.enter("buildScreen");
        LOG.exit("buildScreen");
    }

    public class GetTimeReferenceTypeRequestedRule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(ReferenceServiceScreen.scCommonRefSvcSourceTypeRequested, Integer.class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl;
            int n2 = ((Vector)messageIfc.getParameterValue(ReferenceServiceScreen.scCommonRefSvcSourceTypeRequested)).size();
            if (n != 0 || n2 != 2) {
                ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.setEnabled(false);
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.REQUESTED_PRIMARY_TIME_REFERENCE_GET_ERROR);
            } else {
                ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.setEnabled(true);
            }
            boolean bl2 = !CSSUtilities.isRdm();
            boolean bl3 = bl = OTHER.equals(scSitePlatType);
            if (bl2 && bl) {
                ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.setRequestedPrimarySecondaryTimeReferenceSource(new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.NONE));
                ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.setEnabled(false);
            }
            return true;
        }
    }

    public class SetReferenceApplyFlagRule
    extends Rule {
        public static final String scCommonRefSvcTimeSourceTableApply = "scCommonRefSvcTimeSourceTableApply";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scCommonRefSvcTimeSourceTableApply, Integer.class);
            message.setProtocolKey(1005);
            message.setParameterValue(scCommonRefSvcTimeSourceTableApply, (Object)NmaBoolean.TRUE.getIntegerValue().toString());
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl = true;
            if (n != 0) {
                PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource = ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.getRequestedPrimarySecondaryTimeReferenceSource();
                ReferenceServiceScreen.this.m_errorPopup.display("Error while writing the Requested Time Reference Sources: " + primarySecondaryTimeReferenceSource.getTimeReferenceSource(1).toString() + "/" + primarySecondaryTimeReferenceSource.getTimeReferenceSource(2).toString() + ".");
                ReferenceServiceScreen.this.getApplyButton().setEnabled(true);
                ReferenceServiceScreen.this.getRefreshButton().setEnabled(true);
                bl = false;
            }
            return bl;
        }
    }

    public class SetTimeReferenceTypeRule
    extends Rule {
        private int _instanceId;

        SetTimeReferenceTypeRule(int n) {
            this._instanceId = n;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            ReferenceServiceScreen.this.getApplyButton().setEnabled(false);
            ReferenceServiceScreen.this.getRefreshButton().setEnabled(false);
            Message message = new Message();
            message.addParameter("scCommonRefSvcSourceTypeRequested.instanceId", Integer.class);
            message.addParameter(ReferenceServiceScreen.scCommonRefSvcSourceTypeRequested, Integer.class);
            PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource = ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.getRequestedPrimarySecondaryTimeReferenceSource();
            message.setParameterValue("scCommonRefSvcSourceTypeRequested.instanceId", (Object)("." + scBoxNum.toString() + "." + Integer.toString(this._instanceId)));
            message.setParameterValue(ReferenceServiceScreen.scCommonRefSvcSourceTypeRequested, (Object)primarySecondaryTimeReferenceSource.getTimeReferenceSource(this._instanceId).getIntegerValue().toString());
            message.setProtocolKey(1010);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            boolean bl = true;
            if (n != 0) {
                PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource = ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.getRequestedPrimarySecondaryTimeReferenceSource();
                ReferenceServiceScreen.this.m_errorPopup.display("Error while writing the Requested Time Reference Sources: " + primarySecondaryTimeReferenceSource.getTimeReferenceSource(1).toString() + "/" + primarySecondaryTimeReferenceSource.getTimeReferenceSource(2).toString() + ".");
                ReferenceServiceScreen.this.getApplyButton().setEnabled(true);
                ReferenceServiceScreen.this.getRefreshButton().setEnabled(true);
                bl = false;
            }
            return bl;
        }
    }

    public class GetRefSvcSourceAlignment
    extends Rule {
        public static final String scCommonRefSvcSourceAlignment = "scCommonRefSvcSourceAlignment";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scCommonRefSvcSourceAlignment, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 == n) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(scCommonRefSvcSourceAlignment);
                for (int i = 0; i < 2 && i < integerArray.length; ++i) {
                    ReferenceServiceScreen.this.setRefSvcAlignment(i, integerArray[i] - 500000000);
                }
            } else if (!ReferenceServiceScreen.this.bError) {
                ReferenceServiceScreen.this.bError = true;
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.ERROR_MESSAGE);
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }

    public class GetRefSvcSourceState
    extends Rule {
        public static final String scCommonRefSvcSourceState = "scCommonRefSvcSourceState";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scCommonRefSvcSourceState, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("main");
            if (0 == n) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(scCommonRefSvcSourceState);
                for (int i = 0; i < 2 && i < integerArray.length; ++i) {
                    ReferenceServiceScreen.this.setRefSvcSourceState(i, integerArray[i]);
                }
            } else if (!ReferenceServiceScreen.this.bError) {
                ReferenceServiceScreen.this.bError = true;
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.ERROR_MESSAGE);
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }

    public class GetRefSvcSourceType
    extends Rule {
        public static final String scCommonRefSvcSourceType = "scCommonRefSvcSourceType";
        private boolean enableApplyButton;

        public GetRefSvcSourceType(boolean bl) {
            this.enableApplyButton = bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scCommonRefSvcSourceType, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 == n) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(scCommonRefSvcSourceType);
                TimeReferenceSource[] timeReferenceSourceArray = new TimeReferenceSource[integerArray.length];
                for (int i = 0; i < 2 && i < integerArray.length; ++i) {
                    timeReferenceSourceArray[i] = TimeReferenceSource.getTimeReferenceSource(integerArray[i]);
                    ReferenceServiceScreen.this.setRefSvcSourceType(i, timeReferenceSourceArray[i]);
                }
                if (timeReferenceSourceArray.length > 1) {
                    ReferenceServiceScreen.this.m_RDMRequestedSourcesPanel.setRequestedPrimarySecondaryTimeReferenceSource(PrimarySecondaryTimeReferenceSource.getPrimarySecondaryTimeReferenceSource(timeReferenceSourceArray[0], timeReferenceSourceArray[1]));
                }
            } else if (!ReferenceServiceScreen.this.bError) {
                ReferenceServiceScreen.this.bError = true;
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.ERROR_MESSAGE);
            }
            if (this.enableApplyButton) {
                ReferenceServiceScreen.this.getApplyButton().setEnabled(true);
                ReferenceServiceScreen.this.getRefreshButton().setEnabled(true);
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }

    public class GetScBoxNum
    extends Rule {
        public static final String scBoxNum = "scBoxNum";
        public static final String scSitePlatType = "scSitePlatType";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scBoxNum, Integer.class);
            message.addParameter(scSitePlatType, Integer.class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 == n) {
                Vector vector = (Vector)messageIfc.getParameterValue(scBoxNum);
                scBoxNum = (Integer)vector.get(0);
                Vector vector2 = (Vector)messageIfc.getParameterValue(scSitePlatType);
                scSitePlatType = (Integer)vector2.get(0);
            } else if (!ReferenceServiceScreen.this.bError) {
                ReferenceServiceScreen.this.bError = true;
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.ERROR_MESSAGE);
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }

    public class GetRefSvcInstance
    extends Rule {
        public static final String scCommonRefSvcSourceInstanceID = "scCommonRefSvcSourceInstanceID";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter(scCommonRefSvcSourceInstanceID, Integer[].class);
            message.setProtocolKey(1006);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 == n) {
                Integer[] integerArray = (Integer[])messageIfc.getParameterValue(scCommonRefSvcSourceInstanceID);
                for (int i = 0; i < 2 && i < integerArray.length; ++i) {
                    ReferenceServiceScreen.this.setRefSvcInstance(i, integerArray[i]);
                }
            } else if (!ReferenceServiceScreen.this.bError) {
                ReferenceServiceScreen.this.bError = true;
                ReferenceServiceScreen.this.m_errorPopup.display(ReferenceServiceScreen.ERROR_MESSAGE);
            }
            LOG.exit("update", (Object)true);
            return true;
        }
    }
}

