/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.util.CssConstants;
import pnm.util.Audit;

class Datagram
implements CssConstants {
    private short m_protocolVersionNumber;
    private int m_protocolPacketSize;
    private int m_protocolFlags;
    private short m_protocolStartOfData;
    private short m_protocolSequenceNumber;
    private short m_sessionVersionNumber;
    private short m_sessionType;
    private short m_sessionID;
    private int m_sessionPacketSize;
    private int m_sessionFlags;
    private short m_sessionStartOfData;
    private short m_opcode;
    private short m_subOpcode;
    private int m_dataSize;
    private short m_startOfData;
    private byte[] m_data;
    private boolean m_waitForAdditionalResponse = true;

    public Datagram() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter Datagram.Datagram.");
        this.m_protocolVersionNumber = 1;
        this.m_protocolPacketSize = 20;
        this.m_protocolFlags = 0;
        this.m_protocolStartOfData = (short)7;
        this.m_protocolSequenceNumber = 0;
        this.m_sessionVersionNumber = 1;
        this.m_sessionType = 0;
        this.m_sessionID = 0;
        this.m_sessionPacketSize = 13;
        this.m_sessionFlags = 0;
        this.m_sessionStartOfData = (short)8;
        this.m_opcode = 0;
        this.m_subOpcode = 0;
        this.m_dataSize = 0;
        this.m_startOfData = (short)5;
        this.m_data = null;
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit Datagram.Datagram. " + this.datagramString()));
    }

    public Datagram(byte by, byte by2, byte by3, byte by4) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.Datagram.  g_sessionID = " + by2 + " g_opcode = " + by3 + " g_subOpcode = " + by4));
        this.m_protocolVersionNumber = 1;
        this.m_protocolPacketSize = 20;
        this.m_protocolFlags = 0;
        this.m_protocolStartOfData = (short)7;
        this.m_protocolSequenceNumber = 0;
        this.m_sessionVersionNumber = 1;
        this.m_sessionType = by;
        this.m_sessionID = by2;
        this.m_sessionPacketSize = 13;
        this.m_sessionFlags = 0;
        this.m_sessionStartOfData = (short)8;
        this.m_opcode = by3;
        this.m_subOpcode = by4;
        this.m_dataSize = 0;
        this.m_startOfData = (short)5;
        this.m_data = null;
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit Datagram.Datagram. " + this.datagramString()));
    }

    public byte getProtocolVersionNumber() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter getProtocolVersionNumber. Value = " + this.m_protocolVersionNumber));
        return (byte)this.m_protocolVersionNumber;
    }

    public short getProtocolPacketSize() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getProtocolPacketSize. Value = " + this.m_protocolPacketSize));
        return (short)this.m_protocolPacketSize;
    }

    public short getProtocolFlags() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getProtocolFlags. Value = " + this.m_protocolFlags));
        return (short)this.m_protocolFlags;
    }

    public byte getProtocolSequenceNumber() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getProtocolSequenceNumber. Value = " + this.m_protocolSequenceNumber));
        return (byte)this.m_protocolSequenceNumber;
    }

    public byte getProtocolStartOfData() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getProtocolStartOfData. Value = " + this.m_protocolStartOfData));
        return (byte)this.m_protocolStartOfData;
    }

    public byte getSessionVersionNumber() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionVersionNumber. Value = " + this.m_sessionVersionNumber));
        return (byte)this.m_sessionVersionNumber;
    }

    public byte getSessionType() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionType. Value = " + this.m_sessionType));
        return (byte)this.m_sessionType;
    }

    public byte getSessionID() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionID. Value = " + this.m_sessionID));
        return (byte)this.m_sessionID;
    }

    public short getSessionPacketSize() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionPacketSize. Value = " + this.m_sessionPacketSize));
        return (short)this.m_sessionPacketSize;
    }

    public short getSessionFlags() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionFlags. Value = " + this.m_sessionFlags));
        return (short)this.m_sessionFlags;
    }

    public byte getSessionStartOfData() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSessionStartOfData. Value = " + this.m_sessionStartOfData));
        return (byte)this.m_sessionStartOfData;
    }

    public byte getOpcode() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getOpcode. Value = " + this.m_opcode));
        return (byte)this.m_opcode;
    }

    public byte getSubOpcode() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getSubOpcode. Value = " + this.m_subOpcode));
        return (byte)this.m_subOpcode;
    }

    public short getDataSize() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getDataSize. Value = " + this.m_dataSize));
        return (short)this.m_dataSize;
    }

    public byte getStartOfData() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.getStartOfData. Value = " + this.m_startOfData));
        return (byte)this.m_startOfData;
    }

    public byte[] getData() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter Datagram.getData.");
        return this.m_data;
    }

    private void setProtocolVersionNumber(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setProtocolVersionNumber. Value = " + by));
        this.m_protocolVersionNumber = 0;
        this.m_protocolVersionNumber = (short)(this.m_protocolVersionNumber | by);
    }

    private void setProtocolPacketSize(short s) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setProtocolPacketSize. Value = " + s));
        this.m_protocolPacketSize = 0;
        this.m_protocolPacketSize |= s;
    }

    public void setProtocolFlags(short s) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setProtocolFlags. Value = " + s));
        this.m_protocolFlags = 0;
        this.m_protocolFlags |= s;
    }

    private void setProtocolStartOfData(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setProtocolStartOfData. Value = " + by));
        this.m_protocolStartOfData = 0;
        this.m_protocolStartOfData = (short)(this.m_protocolStartOfData | by);
    }

    public void setProtocolSequenceNumber(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setProtocolSequenceNumber. Value = " + by));
        this.m_protocolSequenceNumber = 0;
        this.m_protocolSequenceNumber = (short)(this.m_protocolSequenceNumber | by);
    }

    private void setSessionVersionNumber(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionVersionNumber. Value = " + by));
        this.m_sessionVersionNumber = 0;
        this.m_sessionVersionNumber = (short)(this.m_sessionVersionNumber | by);
    }

    public void setSessionType(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionType. Value = " + by));
        this.m_sessionType = 0;
        this.m_sessionType = (short)(this.m_sessionType | by);
    }

    public void setSessionID(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionID. Value = " + by));
        this.m_sessionID = 0;
        this.m_sessionID = (short)(this.m_sessionID | by);
    }

    private void setSessionPacketSize(short s) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionPacketSize. Value = " + s));
        this.m_sessionPacketSize = 0;
        this.m_sessionPacketSize |= s;
    }

    public void setSessionFlags(short s) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionFlags. Value = " + s));
        this.m_sessionFlags = 0;
        this.m_sessionFlags |= s;
    }

    private void setSessionStartOfData(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSessionStartOfData. Value = " + by));
        this.m_sessionStartOfData = 0;
        this.m_sessionStartOfData = (short)(this.m_sessionStartOfData | by);
    }

    public void setOpcode(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setOpcode. Value = " + by));
        this.m_opcode = 0;
        this.m_opcode = (short)(this.m_opcode | by);
    }

    public void setSubOpcode(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setSubOpcode. Value = " + by));
        this.m_subOpcode = 0;
        this.m_subOpcode = (short)(this.m_subOpcode | by);
    }

    private void setDataSize(short s) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setDataSize. Value = " + s));
        this.m_dataSize = 0;
        this.m_dataSize |= s;
    }

    private void setStartOfData(byte by) {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setStartOfData. Value = " + by));
        this.m_startOfData = 0;
        this.m_startOfData = (short)(this.m_startOfData | by);
    }

    public void setData(byte[] byArray) {
        int n = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.setData. Value = " + this.bufferString(byArray)));
        n = this.m_data != null ? byArray.length - this.m_data.length : byArray.length;
        this.m_data = byArray;
        this.m_dataSize += n;
        this.m_sessionPacketSize += n;
        this.m_protocolPacketSize += n;
    }

    private int calcSessionPacketSize() {
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.calcSessionPacketSize. Value = " + (13 + this.m_dataSize)));
        return 13 + this.m_dataSize;
    }

    private int calcSessionDataStart() {
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter Datagram.calcSessionDataStart. Value = 15");
        return 15;
    }

    public byte[] pack() {
        byte[] byArray = new byte[this.m_protocolPacketSize];
        int n = 0;
        int n2 = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)("Enter Datagram.pack.\n" + this.datagramString()));
        byArray[n++] = (byte)this.m_protocolVersionNumber;
        byArray[n++] = (byte)((this.m_protocolPacketSize & 0xFF00) >> 8);
        byArray[n++] = (byte)(this.m_protocolPacketSize & 0xFF);
        byArray[n++] = (byte)((this.m_protocolFlags & 0xFF00) >> 8);
        byArray[n++] = (byte)(this.m_protocolFlags & 0xFF);
        byArray[n++] = (byte)this.m_protocolStartOfData;
        byArray[n++] = (byte)this.m_protocolSequenceNumber;
        byArray[n++] = (byte)this.m_sessionVersionNumber;
        byArray[n++] = (byte)((this.m_sessionPacketSize & 0xFF00) >> 8);
        byArray[n++] = (byte)(this.m_sessionPacketSize & 0xFF);
        byArray[n++] = (byte)this.m_sessionType;
        byArray[n++] = (byte)this.m_sessionID;
        byArray[n++] = (byte)((this.m_sessionFlags & 0xFF00) >> 8);
        byArray[n++] = (byte)(this.m_sessionFlags & 0xFF);
        byArray[n++] = (byte)this.m_sessionStartOfData;
        byArray[n++] = (byte)this.m_opcode;
        byArray[n++] = (byte)this.m_subOpcode;
        byArray[n++] = (byte)((this.m_dataSize & 0xFF00) >> 8);
        byArray[n++] = (byte)(this.m_dataSize & 0xFF);
        byArray[n++] = (byte)this.m_startOfData;
        for (n2 = 0; n2 < this.m_dataSize; ++n2) {
            byArray[n + n2] = this.m_data[n2];
        }
        Audit.audit((int)1012, (String)this.toString(), (String)"Exit Datagram.pack. Buffer = ");
        return byArray;
    }

    public void unpack(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        byte by = 0;
        Audit.audit((int)1011, (String)this.toString(), (String)"Enter Datagram.unpack.");
        this.m_protocolVersionNumber = (short)(by | byArray[n++]);
        Byte by2 = new Byte(byArray[n + 1]);
        this.m_protocolPacketSize = this.getInt(byArray[n], byArray[n + 1]);
        this.m_protocolFlags = this.getInt(byArray[n += 2], byArray[n + 1]);
        n += 2;
        this.m_protocolStartOfData = (short)(by | byArray[n++]);
        this.m_protocolSequenceNumber = (short)(by | byArray[n++]);
        this.m_sessionVersionNumber = (short)(by | byArray[n++]);
        this.m_sessionPacketSize = this.getInt(byArray[n], byArray[n + 1]);
        n += 2;
        this.m_sessionType = (short)(by | byArray[n++]);
        this.m_sessionID = (short)(by | byArray[n++]);
        this.m_sessionFlags = this.getInt(byArray[n], byArray[n + 1]);
        n += 2;
        this.m_sessionStartOfData = (short)(by | byArray[n++]);
        this.m_opcode = (short)(by | byArray[n++]);
        this.m_subOpcode = (short)(by | byArray[n++]);
        this.m_dataSize = this.getInt(byArray[n], byArray[n + 1]);
        n += 2;
        this.m_startOfData = (short)(by | byArray[n++]);
        this.m_data = new byte[this.m_dataSize];
        for (n2 = 0; n2 < this.m_dataSize; ++n2) {
            this.m_data[n2] = byArray[n + n2];
        }
        Audit.audit((int)1012, (String)this.toString(), (String)("Exit Datagram.unpack. \n" + this.datagramString()));
    }

    public int getInt(byte by, byte by2) {
        int n = 0;
        int n2 = 0xFF & by;
        int n3 = 0xFF & by2;
        Audit.audit((int)1011, (String)this.toString(), (String)("Exit Datagram.pack. g_high = " + by + " g_low = " + by2));
        n = n2;
        n <<= 8;
        Audit.audit((int)1011, (String)this.toString(), (String)("Exit Datagram.getInt. temp = " + (n |= n3)));
        return n;
    }

    public String datagramString() {
        String string = new String();
        string = string + new String("ProtocolVersionNumber = " + this.m_protocolVersionNumber + "\n" + "ProtocolPacketSize = " + this.m_protocolPacketSize + "\n" + "ProtocolFlags = " + this.m_protocolFlags + "\n" + "ProtocolStartOfData = " + this.m_protocolStartOfData + "\n" + "ProtocolSequenceNumber = " + this.m_protocolSequenceNumber + "\n" + "SessionVersionNumber = " + this.m_sessionVersionNumber + "\n" + "SessionType = " + this.m_sessionType + "\n" + "SessionID = " + this.m_sessionID + "\n" + "SessionPacketSize = " + this.m_sessionPacketSize + "\n" + "SessionFlags = " + this.m_sessionFlags + "\n" + "SessionStartOfData = " + this.m_sessionStartOfData + "\n" + "Opcode = " + this.m_opcode + "\n" + "SubOpcode = " + this.m_subOpcode + "\n" + "DataSize = " + this.m_dataSize + "\n" + "StartOfData = " + this.m_startOfData + "\n" + "Data = ");
        if (this.m_data != null) {
            String string2 = new String(this.m_data);
            string = string + string2;
        }
        return string;
    }

    public String bufferString(byte[] byArray) {
        String string = new String(byArray);
        return string;
    }

    public boolean getWaitForResponse() {
        return this.m_waitForAdditionalResponse;
    }

    public void setWaitForResponse(boolean bl) {
        this.m_waitForAdditionalResponse = bl;
    }
}

