/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.Convert;
import css.core.service.DataObject;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.ApplicationMessenger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.protocol.cmdmgr.InPort;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.TranslationInfo;
import java.io.PipedInputStream;
import java.util.Arrays;
import java.util.List;
import pnm.ui.UIStatusBar;
import pnm.util.EngineUtilities;

class Protocol
implements CssConstants,
CssErrorCodes {
    private static final CssLogger LOG = CssLogger.getCssLogger(Protocol.class);
    private static final String ERROR_DATA = "ErrorData";
    public static final String FILE = "Protocol";
    DataObject ref_DataObject;
    DevicePorts ref_DevicePorts;
    DeviceSessions ref_DeviceSessions;
    private byte m_sessionID;
    private byte m_opcode = 0;
    private byte m_subcode = 0;
    private byte m_sessionType;
    private int m_port;
    private TranslationInfo m_translationInfo;
    private DataObject m_dataObject;
    private CmdManager m_commandManager;
    private ApplicationMessenger m_applicationPipe;
    private static final int PACKET_AWAITING_TIMER = 250;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Protocol(byte by, int n, byte by2, Object[][] objectArray, CmdManager cmdManager, DataObject dataObject) {
        InPort inPort = null;
        OutPort outPort = null;
        LOG.enter(FILE, new Object[]{by, n, by2, objectArray, cmdManager, dataObject});
        this.m_sessionType = by;
        this.m_port = n;
        this.m_sessionID = by2;
        this.m_commandManager = cmdManager;
        this.m_translationInfo = new TranslationInfo(objectArray);
        this.ref_DevicePorts = cmdManager.getDevicePorts();
        this.ref_DeviceSessions = cmdManager.getDeviceSessions();
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            if (!this.ref_DevicePorts.portExists(n) && n == 1054) {
                inPort = new InPort(n, false, cmdManager);
                outPort = new OutPort(n, false, cmdManager, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                thread.start();
                Thread thread2 = new Thread(outPort);
                thread2.start();
            } else if (!this.ref_DevicePorts.portExists(n) && n != 1054) {
                inPort = new InPort(n, true, cmdManager);
                outPort = new OutPort(n, true, cmdManager, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                thread.start();
                Thread thread3 = new Thread(outPort);
                thread3.start();
            } else if (this.ref_DevicePorts.portExists(n) && n == 1054) {
                inPort = this.ref_DevicePorts.getInPortHandle(n);
                inPort.setKeepAlives(true);
                outPort = this.ref_DevicePorts.getOutPortHandle(n);
                outPort.setKeepAlives(true);
            } else if (this.ref_DevicePorts.portExists(n) && n != 1054) {
                inPort = this.ref_DevicePorts.getInPortHandle(n);
                outPort = this.ref_DevicePorts.getOutPortHandle(n);
            }
            this.ref_DevicePorts.addPort(n, inPort, outPort);
            this.ref_DeviceSessions.addEntry(by2, this.getName(by, dataObject), n, this);
        }
        LOG.exit(FILE);
    }

    public synchronized DataObject doOperation(DataObject dataObject) {
        byte[] byArray;
        Datagram datagram = null;
        Datagram datagram2 = null;
        int n = 0;
        byte by = 0;
        byte by2 = 0;
        int n2 = 0;
        int n3 = 0;
        Integer n4 = new Integer(-1);
        LOG.enter("doOperation", new Object[]{dataObject});
        this.m_dataObject = dataObject;
        datagram = this.buildDatagram(dataObject, this.m_sessionType, this.m_sessionID);
        if (datagram == null) {
            dataObject.setError(-10);
            n3 = -10;
        } else {
            if (datagram.getSessionID() == 0) {
                datagram.setProtocolFlags((short)1);
            }
            datagram2 = null;
            datagram2 = this.routeDatagram(datagram);
            if (datagram2 == null) {
                dataObject.setError(-15);
                n3 = -15;
            } else if (datagram2.getOpcode() == -1) {
                dataObject.setError(-1);
                byArray = datagram2.getData();
                if (byArray != null) {
                    if (-1 == dataObject.getIndex(ERROR_DATA)) {
                        dataObject.addParameterNameArray(new String[]{ERROR_DATA});
                        dataObject.addParameterTypeArray(new String[]{"Integer"});
                        dataObject.addParameterValueArray((Object[])new Integer[]{null});
                    }
                    if (byArray.length != 0) {
                        dataObject.setParameterValue(ERROR_DATA, Convert.toInteger((byte[])byArray));
                    }
                }
                n3 = -1;
            }
        }
        if (n3 == 0) {
            n = dataObject.getProtocolKey();
            if (n >= 2001 && n <= 2005) {
                byArray = datagram2.getData();
                by = byArray[0];
                by2 = byArray[1];
                n2 = byArray[2];
                n2 <<= 8;
                n2 |= byArray[3];
                n2 <<= 8;
                n2 |= byArray[4];
                n2 <<= 8;
                Protocol protocol = new Protocol(by, n2 |= byArray[5], by2, (Object[][])dataObject.getParameterValue("TranslationInfo"), this.m_commandManager, dataObject);
                EngineUtilities.getMainApplicationWindow().getStatusBar().enableProtocolLabel(UIStatusBar.FSP);
                if (dataObject.getParameterValue("realTimeDataPipe") != n4) {
                    PipedInputStream pipedInputStream = (PipedInputStream)dataObject.getParameterValue("realTimeDataPipe");
                    ApplicationMessenger applicationMessenger = new ApplicationMessenger(pipedInputStream);
                    protocol.setApplicationPipe(applicationMessenger);
                } else {
                    dataObject.setError(-7);
                    n3 = -7;
                }
            } else if (datagram.getOpcode() == 1) {
                this.close();
                EngineUtilities.getMainApplicationWindow().getStatusBar().disableProtocolLabel(UIStatusBar.FSP);
            }
            dataObject = this.buildDataObject(datagram2);
        }
        LOG.exit("doOperation", (Object)dataObject);
        return dataObject;
    }

    public void setApplicationPipe(ApplicationMessenger applicationMessenger) {
        this.m_applicationPipe = applicationMessenger;
    }

    public void removeApplicationPipe() {
        if (this.m_applicationPipe != null) {
            this.m_applicationPipe.closeOutputStreams();
            this.m_applicationPipe = null;
        }
    }

    public int reply(Datagram datagram) {
        int n = 0;
        short s = 0;
        RealTimeDataObject realTimeDataObject = null;
        Class<FspRealTimeDataObject> clazz = null;
        LOG.enter("reply", new Object[]{datagram});
        s = datagram.getSessionFlags();
        this.checkForError(datagram);
        if ((s & 1) != 0) {
            try {
                if (datagram.getOpcode() == -1) {
                    realTimeDataObject = new FspRealTimeDataObject();
                    ((FspRealTimeDataObject)realTimeDataObject).setOpCode(datagram.getOpcode());
                    ((FspRealTimeDataObject)realTimeDataObject).setSubOpCode(datagram.getSubOpcode());
                    ((FspRealTimeDataObject)realTimeDataObject).setData(datagram.getData());
                    realTimeDataObject.setError((int)datagram.getSubOpcode());
                    n = -1;
                } else {
                    clazz = this.m_translationInfo.getOpcodeReceiveMessage(datagram.getOpcode(), datagram.getSubOpcode());
                    byte[] byArray = datagram.getData();
                    if (null != clazz) {
                        realTimeDataObject = clazz.newInstance();
                        ((FspRealTimeDataObject)realTimeDataObject).setData(byArray);
                    } else {
                        realTimeDataObject = new FspRealTimeDataObject();
                        ((FspRealTimeDataObject)realTimeDataObject).setOpCode(datagram.getOpcode());
                        ((FspRealTimeDataObject)realTimeDataObject).setSubOpCode(datagram.getSubOpcode());
                        String[] stringArray = this.m_translationInfo.getOpcodeReceiveParamsNameArray(datagram.getOpcode(), datagram.getSubOpcode());
                        String[] stringArray2 = this.m_translationInfo.getOpcodeReceiveDataFormat(datagram.getOpcode(), datagram.getSubOpcode());
                        int n2 = 0;
                        if (stringArray != null) {
                            for (int i = 0; i < stringArray.length; ++i) {
                                int n3;
                                byte[] byArray2;
                                if (stringArray[i].equalsIgnoreCase("X")) {
                                    if (byArray.length - n2 != 0) {
                                        int n4 = n2;
                                        byArray2 = new byte[byArray.length - n2];
                                        for (n3 = 0; n3 < byArray.length - n2; ++n3) {
                                            byArray2[n3] = byArray[n4++];
                                        }
                                        realTimeDataObject.insertValue(stringArray[i], "byte[]", (Object)byArray2);
                                        continue;
                                    }
                                    realTimeDataObject.insertValue(stringArray[i], "byte[]", null);
                                    continue;
                                }
                                int n5 = new Integer(stringArray2[i]);
                                byArray2 = new byte[n5];
                                for (n3 = 0; n3 < n5; ++n3) {
                                    byArray2[n3] = byArray[n2++];
                                }
                                realTimeDataObject.insertValue(stringArray[i], "byte[]", (Object)byArray2);
                            }
                        } else {
                            realTimeDataObject = null;
                        }
                    }
                }
                this.m_applicationPipe.setData(realTimeDataObject);
            }
            catch (Exception exception) {
                realTimeDataObject = new RealTimeDataObject();
                realTimeDataObject.setError(-262165);
                LOG.error((Object)"reply - Corrupted real time data", (Throwable)exception);
            }
        }
        LOG.exit("reply", (Object)n);
        return n;
    }

    public Datagram buildDatagram(DataObject dataObject, byte by, byte by2) {
        boolean bl;
        byte[] byArray;
        Datagram datagram;
        block15: {
            String[] stringArray = null;
            Object[] objectArray = null;
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            byte[] byArray2 = null;
            datagram = null;
            byArray = null;
            int n = 0;
            int n2 = 0;
            bl = true;
            LOG.enter("buildDatagram", new Object[]{dataObject, by, by2});
            if (dataObject == null) {
                LOG.error((Object)"buildDatagram - Dataobject is null");
                return null;
            }
            try {
                this.m_dataObject = dataObject;
                int n3 = dataObject.getProtocolKey();
                stringArray2 = this.m_translationInfo.getSendParamsNameArray(n3);
                stringArray3 = this.m_translationInfo.getSendDataFormat(n3);
                this.m_opcode = this.m_translationInfo.getActionCode(n3);
                this.m_subcode = this.m_translationInfo.getActionSubCode(n3);
                stringArray = dataObject.getParameterNamesArray();
                objectArray = dataObject.getParameterValuesArray();
                Class<FspRealTimeDataObject> clazz = this.m_translationInfo.getOpcodeReceiveMessage(this.m_opcode, this.m_subcode);
                if (null != clazz) {
                    try {
                        RealTimeDataObject realTimeDataObject = clazz.newInstance();
                        bl = realTimeDataObject.getWaitForResponse();
                    }
                    catch (InstantiationException instantiationException) {
                        LOG.error((Object)"buildDatagram - Could not create fsp packet instance", (Throwable)instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        LOG.error((Object)"buildDatagram - IllegalAccessException when creating fsp packet instance", (Throwable)illegalAccessException);
                    }
                }
                if (stringArray2 == null) break block15;
                for (int i = 0; i < stringArray3.length; ++i) {
                    try {
                        n2 += Integer.parseInt(stringArray3[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.error((Object)"buildDatagram - Cannot convert string to integer:", (Throwable)numberFormatException);
                    }
                }
                byArray = new byte[n2];
                if (stringArray != null) {
                    List<String> list = Arrays.asList(stringArray);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        int n4 = list.indexOf(stringArray2[i]);
                        if (n4 < 0) continue;
                        int n5 = Integer.parseInt(stringArray3[i]);
                        byArray2 = this.convertToByteFormat(objectArray[n4]);
                        if (null != byArray2) {
                            for (int j = n5 - 1; j >= 0; --j) {
                                byArray[n++] = byArray2[j];
                            }
                            continue;
                        }
                        LOG.error((Object)"buildDatagram - Send Name array does not match");
                        dataObject.setError(-8);
                        datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                        datagram.setProtocolFlags((short)3);
                        datagram.setWaitForResponse(bl);
                        return datagram;
                    }
                    break block15;
                }
                LOG.error((Object)"buildDatagram - Name array received from dataobject is null");
                dataObject.setError(-7);
                datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                datagram.setProtocolFlags((short)3);
                datagram.setWaitForResponse(bl);
                return datagram;
            }
            catch (NotFoundException notFoundException) {
                LOG.error((Object)"buildDatagram - Couldn't find row in translation Info", (Throwable)notFoundException);
                datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
                datagram.setProtocolFlags((short)3);
                datagram.setWaitForResponse(bl);
                return datagram;
            }
        }
        datagram = new Datagram(by, by2, this.m_opcode, this.m_subcode);
        datagram.setWaitForResponse(bl);
        datagram.setProtocolFlags((short)3);
        if (byArray != null) {
            datagram.setData(byArray);
        }
        LOG.exit("buildDatagram");
        return datagram;
    }

    public DataObject buildDataObject(Datagram datagram) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        LOG.enter("buildDataObject", new Object[]{datagram});
        if (datagram == null) {
            this.m_dataObject.setError(-10);
            LOG.error((Object)"buildDataObject - Datagram is null");
        } else {
            try {
                byArray = datagram.getData();
                stringArray = this.m_translationInfo.getOpcodeReceiveParamsNameArray(this.m_dataObject.getProtocolKey());
                String[] stringArray3 = this.m_translationInfo.getOpcodeReceiveDataFormat(this.m_dataObject.getProtocolKey());
                stringArray2 = this.m_dataObject.getParameterNamesArray();
                if (null != stringArray3 && null != stringArray && null != stringArray2) {
                    int n = 0;
                    block2: for (int i = 0; i < stringArray.length; ++i) {
                        for (int j = 0; j < stringArray2.length; ++j) {
                            if (!stringArray[i].equalsIgnoreCase(stringArray2[j])) continue;
                            int n2 = new Integer(stringArray3[i]);
                            byArray2 = new byte[n2];
                            for (int k = 0; k < n2; ++k) {
                                byArray2[k] = byArray[n++];
                            }
                            this.m_dataObject.setParameterValue(stringArray2[j], (Object)byArray2);
                            continue block2;
                        }
                    }
                } else {
                    LOG.debug((Object)"buildDataObject - Given datagram packet does not contain any parameters data.");
                }
            }
            catch (NotFoundException notFoundException) {
                LOG.error((Object)"buildDataObject - Receive Name array does not match");
                this.m_dataObject.setError(-22);
            }
        }
        LOG.exit("buildDataObject", (Object)this.m_dataObject);
        return this.m_dataObject;
    }

    public byte[] convertToByteFormat(Object object) {
        byte[] byArray = null;
        LOG.enter("convertToByteFormat", new Object[]{object});
        try {
            if (object instanceof Long) {
                long l = (Long)object;
                byArray = new byte[8];
                byArray[0] = (byte)(l & 0xFFL);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l >> 8 * i & 0xFFL);
                }
            } else if (object instanceof Double) {
                double d = (Double)object;
                long l = Double.doubleToLongBits(d);
                byArray = new byte[8];
                byArray[0] = (byte)(l & 0xFFL);
                for (int i = 1; i < 8; ++i) {
                    byArray[i] = (byte)(l >> 8 * i & 0xFFL);
                }
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                byArray = new byte[4];
                byArray[0] = (byte)(n & 0xFF);
                for (int i = 1; i < 4; ++i) {
                    byArray[i] = (byte)(n >> 8 * i & 0xFF);
                }
            } else if (object instanceof Float) {
                float f = ((Float)object).floatValue();
                int n = Float.floatToIntBits(f);
                byArray = new byte[4];
                byArray[0] = (byte)(n & 0xFF);
                for (int i = 1; i < 4; ++i) {
                    byArray[i] = (byte)(n >> 8 * i & 0xFF);
                }
            } else if (object instanceof Short) {
                short s = (Short)object;
                byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
            } else if (object instanceof String) {
                byArray = ((String)object).getBytes();
            } else if (object instanceof Boolean) {
                byArray = new byte[1];
                byArray[0] = !((Boolean)object).booleanValue() ? new Byte(0).byteValue() : new Byte(1).byteValue();
            } else if (object instanceof Byte) {
                byArray = new byte[]{(Byte)object};
            } else if (object instanceof Character) {
                char c = ((Character)object).charValue();
                byArray = new byte[]{(byte)(c & 0xFF), (byte)(c >> 8 & 0xFF)};
            }
        }
        catch (Exception exception) {
            LOG.error((Object)"convertToByteFormat - Unable to convert to byte array[]", (Throwable)exception);
        }
        return byArray;
    }

    public String getName(byte by, DataObject dataObject) {
        LOG.enter("getName", new Object[]{by, dataObject});
        String string = by == 0 ? "command" : dataObject.getSessionName();
        LOG.exit("getName", (Object)string);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datagram routeDatagram(Datagram datagram) {
        Datagram datagram2 = null;
        Datagram datagram3 = null;
        LOG.enter("routeDatagram", new Object[]{datagram});
        OutPort outPort = this.ref_DevicePorts.getOutPortHandle(this.m_port);
        InPort inPort = this.ref_DevicePorts.getInPortHandle(this.m_port);
        inPort.getDatagramQueue().clearReplyQueue();
        for (int i = 0; i < 3 && datagram2 == null; ++i) {
            outPort.sendDatagram(datagram);
            try {
                int n;
                Protocol protocol = this;
                synchronized (protocol) {
                    for (n = 0; n < 24; ++n) {
                        datagram3 = inPort.getDatagramQueue().getReplyIfAvailable(this.m_sessionID, this.m_sessionType);
                        if (datagram3 != null) {
                            datagram2 = datagram3;
                            break;
                        }
                        this.wait(250L);
                    }
                }
                if (datagram2 != null) {
                    if (datagram2.getSessionType() == 0) {
                        if (datagram2.getSubOpcode() == datagram.getOpcode()) {
                            i = 3;
                            continue;
                        }
                        datagram2 = null;
                        continue;
                    }
                    if (datagram2.getOpcode() == 1 && datagram2.getSubOpcode() == datagram.getProtocolSequenceNumber()) {
                        i = 3;
                        if (datagram.getOpcode() == 1 || !datagram.getWaitForResponse()) continue;
                        protocol = this;
                        synchronized (protocol) {
                            datagram2 = null;
                            for (n = 0; n < 40; ++n) {
                                datagram3 = inPort.getDatagramQueue().getReplyIfAvailable(this.m_sessionID, this.m_sessionType);
                                if (datagram3 != null) {
                                    datagram2 = datagram3;
                                    break;
                                }
                                this.wait(250L);
                            }
                            continue;
                        }
                    }
                    LOG.error((Object)"routeDatagram - InPort:routeDatagram: NO IDEA ABOUT PACKET SO IGNORE.");
                    continue;
                }
                LOG.error((Object)"routeDatagram - InPort:routeDatagram: Reply Was Null");
                continue;
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"routeDatagram - InPort:routeDatagram: Wait Timer expired.", (Throwable)interruptedException);
                continue;
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                LOG.error((Object)"routeDatagram - InPort:routeDatagram: Illegal Monitor State.", (Throwable)illegalMonitorStateException);
            }
        }
        LOG.exit("routeDatagram", datagram2);
        return datagram2;
    }

    public byte getHeaderVersion(byte by) {
        Datagram datagram = null;
        byte by2 = 0;
        LOG.enter("getHeaderVersion", new Object[]{by});
        datagram = null;
        Datagram datagram2 = new Datagram(0, 0, by, 0);
        datagram2.setProtocolFlags((short)1);
        datagram = this.routeDatagram(datagram2);
        if (datagram != null) {
            byte[] byArray = datagram.getData();
            by2 = byArray[0];
        }
        LOG.exit("getHeaderVersion", (Object)by2);
        return by2;
    }

    public void sendPipeData(byte[] byArray) {
        this.m_applicationPipe.setData(byArray);
    }

    public int restartDevice() {
        int n = 0;
        Datagram datagram = new Datagram(0, 0, 7, 0);
        datagram.setProtocolFlags((short)1);
        OutPort outPort = this.ref_DevicePorts.getOutPortHandle(1054);
        n = outPort.sendDatagram(datagram);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            this.ref_DevicePorts.deletePort(this.m_port);
            this.ref_DeviceSessions.deleteEntry(this.m_sessionID);
            this.removeApplicationPipe();
        }
    }

    private void checkForError(Datagram datagram) {
        LOG.enter("checkForError", new Object[]{datagram});
        if (datagram != null && this.m_applicationPipe != null && datagram.getOpcode() == -1 && datagram.getSubOpcode() < 0) {
            int n = datagram.getSubOpcode() + -262144;
            if (-262160 == n || -262184 == n) {
                EngineUtilities.getMainApplicationWindow().getStatusBar().disableProtocolLabel(UIStatusBar.FSP);
            }
            RealTimeDataObject realTimeDataObject = new RealTimeDataObject();
            realTimeDataObject.setError(n);
            this.m_applicationPipe.setData(realTimeDataObject);
        }
        LOG.exit("checkForError");
    }
}

