/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FileLogger {
    File logFile = null;
    FileWriter writer = null;
    private String statusMessage = null;
    private static final String ERR_UNABLE_TO_SAVE = "Unable to save log file.";
    private static final String ERR_CANNOT_WRITE = "Unable to write to log file.";
    private static final String ERR_CANNOT_START = "Unable to start log file.";
    private static final String ERR_CANNOT_STOP = "Unable to close log file.";
    private static final String ERR_CANNOT_SAVE_HIDDEN = "Unable to write to hidden file.";

    public FileLogger(File file) {
        this.logFile = file;
    }

    public boolean startLogging() {
        boolean bl = true;
        if (null == this.logFile) {
            this.statusMessage = ERR_UNABLE_TO_SAVE;
        } else if (this.logFile.exists()) {
            if (!this.logFile.canWrite()) {
                this.statusMessage = ERR_CANNOT_WRITE;
                bl = false;
            } else if (this.logFile.isHidden()) {
                this.statusMessage = ERR_CANNOT_SAVE_HIDDEN;
                bl = false;
            }
        }
        if (bl) {
            try {
                this.writer = new FileWriter(this.logFile);
                this.statusMessage = "";
            }
            catch (IOException iOException) {
                bl = false;
                this.statusMessage = ERR_CANNOT_START;
            }
        }
        return bl;
    }

    public boolean stopLogging() {
        boolean bl = true;
        try {
            this.writer.close();
            this.statusMessage = "";
        }
        catch (IOException iOException) {
            bl = false;
            this.statusMessage = ERR_CANNOT_STOP;
        }
        return bl;
    }

    public boolean appendString(String string) {
        boolean bl = true;
        try {
            this.writer.write(string);
            this.writer.flush();
        }
        catch (Exception exception) {
            bl = false;
            this.statusMessage = ERR_CANNOT_WRITE;
        }
        return bl;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }
}

