/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.RealTimeDataObject;
import css.core.util.CssConstants;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.CommonTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import pnm.util.Audit;

public class SummitPowerSupplyPanel
extends JPanel
implements CssConstants {
    private static final long serialVersionUID = 1L;
    private static final String FILE = "SummitPowerSupplyPanel";
    private ErrorPopup m_errorPopup;
    private JTable m_table = null;
    private final String[] m_fields = new String[]{"DC Output Voltage (Volts)", "DC Output Current (Amps)", "Power Supply Ambient Air Inlet Temp (\u00b0C)", "Power Supply Ambient Air Outlet Temp (\u00b0C)", "Battery Charger Output Voltage (Volts)", "Battery Charger Output Current (Amps)"};
    private final double MAX_MEASUREMENT_VALUE = 150.0;
    private final double NOT_APPLICABLE_VALUE = 6553.5;
    private final String[] m_columnNames = new String[]{"Item", "Meter Value"};
    private String[] m_current = new String[]{"Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"};
    private final Object[][] m_data = new Object[][]{{this.m_fields[0], this.m_current[0]}, {this.m_fields[1], this.m_current[1]}, {this.m_fields[2], this.m_current[2]}, {this.m_fields[3], this.m_current[3]}, {this.m_fields[4], this.m_current[4]}, {this.m_fields[5], this.m_current[5]}};

    public SummitPowerSupplyPanel() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter SummitPowerSupplyPanel Constructor");
        this.m_table = new JTable();
        this.m_errorPopup = new ErrorPopup();
        Audit.audit((int)1010, (String)FILE, (String)"Exit SummitPowerSupplyPanel Constructor");
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        Audit.audit((int)1009, (String)FILE, (String)"Enter buildScreen");
        this.setLayout(new GridBagLayout());
        CommonTableModel commonTableModel = new CommonTableModel();
        commonTableModel.setDataVector(this.m_data, this.m_columnNames);
        this.m_table.setModel(commonTableModel);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_table.setName("Power Supply table");
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(350, 200));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 5, 10, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        Audit.audit((int)1010, (String)FILE, (String)"Exit buildScreen");
    }

    public void initialize() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter initialize");
        int n = 0;
        int n2 = 0;
        while (n < this.m_current.length) {
            this.m_current[n] = "Unknown";
            this.m_table.setValueAt(this.m_current[n], n2, 1);
            ++n;
            ++n2;
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit initialize");
    }

    public boolean realTimeUpdate(RealTimeDataObject realTimeDataObject) {
        Audit.audit((int)1009, (String)FILE, (String)"Enter realTimeUpdate.");
        boolean bl = false;
        for (int i = 0; i < realTimeDataObject.getSize(); ++i) {
            try {
                String string = realTimeDataObject.getName(i);
                byte[] byArray = (byte[])realTimeDataObject.getValue(i);
                String string2 = this.convertValue(byArray);
                if (string.equals("dcOutputVoltage")) {
                    this.m_current[0] = string2;
                    this.m_table.setValueAt(this.m_current[0], 0, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("dcOutputCurrent")) {
                    this.m_current[1] = string2;
                    this.m_table.setValueAt(this.m_current[1], 1, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("psAmbientAirInletTemp")) {
                    this.m_current[2] = string2;
                    this.m_table.setValueAt(this.m_current[2], 2, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("psAmbientAirOutletTemp")) {
                    this.m_current[3] = string2;
                    this.m_table.setValueAt(this.m_current[3], 3, 1);
                    bl = true;
                    continue;
                }
                if (string.equals("batteryChargerOutputVoltage")) {
                    this.m_current[4] = string2;
                    this.m_table.setValueAt(this.m_current[4], 4, 1);
                    bl = true;
                    continue;
                }
                if (!string.equals("batteryChargerOutputCurrent")) continue;
                this.m_current[5] = string2;
                this.m_table.setValueAt(this.m_current[5], 5, 1);
                bl = true;
                continue;
            }
            catch (Exception exception) {
                Audit.audit((int)1001, (String)FILE, (String)(exception + " Unable to convert real time update metering value"));
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)("Exit realTimeUpdate: status = " + bl));
        return bl;
    }

    public void handleStartPowerSupplyMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStartPowerSupplyMetering Error:" + n));
        if (n != 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.m_current.length) {
                this.m_current[n2] = "Unknown";
                this.m_table.setValueAt(this.m_current[n2], n3, 1);
                ++n2;
                ++n3;
            }
            this.m_errorPopup.display(-610321);
            Audit.audit((int)1002, (String)FILE, (String)"Power Supply Metering Command Error");
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStartPowerSupplyMetering");
    }

    public void handleStopMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStopMetering(): g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)FILE, (String)("Received error " + n + " while trying to stop power supply metering"));
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStopMetering()");
    }

    private String convertValue(byte[] byArray) {
        int n = 0xFF & byArray[0];
        int n2 = 0xFF & byArray[1];
        int n3 = n;
        n3 <<= 8;
        double d = (double)(n3 |= n2) / 10.0;
        String string = d <= 150.0 ? String.valueOf(d) : (d == 6553.5 ? "N/A" : "");
        return string;
    }
}

