/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.component.GenericListener;
import css.core.util.popup.ErrorPopup;
import css.device.common.util.CommonTableModel;
import css.device.common.util.DeviceErrorCodes;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class SummitTransmitterPanel
extends JPanel
implements CssConstants {
    private static final String FILE = "SummitTransmitterPanel";
    private static final String TRANSMITTER_TEST_SUCCESSFUL = "Current Status: Transmitter Test Was Successful In The Station";
    private static final String TRANSMITTER_TEST_FAIL = "Current Status: Transmitter Test Failed In The Station";
    private static final String TRANSMITTER_TEST_UNKNOWN = "No Such Response for transmitter test";
    private static final String TRANSMITTER_TEST_IN_PROGRESS = "Current Status: Transmitter Test IN PROGRESS";
    private static final String TRANSMITTER_TEST_STOPPED = " ";
    private static final String TRANSMITTER_TEST_SUSPENDED_INH = "Current Status: Transmitter Test SUSPENDED; transmitter device is inhibited";
    private static final String TRANSMITTER_TEST_SUSPENDED_FAIL = "Current Status: Transmitter Test SUSPENDED; transmitter device is failed";
    private static final String TRANSMITTER_TEST_SUSPENDED_INIT = "Current Status: Transmitter Test SUSPENDED; transmitter device is initializing";
    private static final String TRANSMITTER_TEST_SUSPENDED_DFB = "Current Status: Transmitter Test SUSPENDED; DFB is enabled";
    private static final String TRANSMITTER_TEST_SUSPENDED_VOICE_DATA = "Current Status: Transmitter Test SUSPENDED; voice or data activity in progress";
    private static final String TRANSMITTER_TEST_SUSPENDED_CC_ACTIV = "Current Status: Transmitter Test SUSPENDED; control channel activity in progress";
    private static final String TRANSMITTER_TEST_SUSPENDED_BSI = "Current Status: Transmitter Test SUSPENDED; BSI activity in progress";
    private static final String TRANSMITTER_TEST_SUSPENDED_TEST_ACTIV = "Current Status: Transmitter Test status SUSPENDED; test activity in progress";
    private static final String DEFAULT_20_SECONDS = "Default (20 seconds)";
    private static final String CONTINUOUS_TEST_PATTERN = "Continuous Test";
    private static final String START_TRANSMITTER_TEST = "Start Transmitter Test";
    private static final String TRANSMITTER_TEST = "Transmitter Test";
    private static final String STOP_TRANSMITTER_TEST = "Stop Transmitter Test";
    private static final long serialVersionUID = 1L;
    public JButton m_transmitterTestBtn;
    private final int NUM_ROWS = 3;
    private boolean isIsr = false;
    private boolean isRxOnly = false;
    private boolean isNormalMode = false;
    private boolean isConTestPatternSupported = true;
    private boolean isTransmitterTestStopped = true;
    private boolean isContTestStarted = false;
    private JComboBox<String> cmbDuration;
    private JLabel lblDuration;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitTransmitterPanel.class);
    private final String[] m_fields = new String[]{"Current Measured Forward Power (Watts)", "Current Measured Reflected Power (Watts)", "Current Measured VSWR", "Current Stored Measured Forward Power (Watts)", "Current Stored Measured Reflected Power (Watts)", "Current Stored Measured VSWR"};
    private final String[] m_columnNames = new String[]{"Item", "Current"};
    private String[] m_current = new String[]{"Unknown", "Unknown", "Unknown", "Unknown", "Unknown", "Unknown"};
    private final Object[][] m_data = new Object[][]{{this.m_fields[0], this.m_current[0]}, {this.m_fields[1], this.m_current[1]}, {this.m_fields[2], this.m_current[2]}, {this.m_fields[3], this.m_current[3]}, {this.m_fields[4], this.m_current[4]}, {this.m_fields[5], this.m_current[5]}};
    private JLabel m_currentStatus;
    private ErrorPopup m_errorPopup;
    private JTable m_table;
    private UIInternalFrame m_window;
    public GenericListener m_oGenericListener = new GenericListener();
    private boolean m_realtimeUpdateCalled = false;
    private boolean m_updateTransmitterTestCalled = false;
    String appHWCombination = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");

    public SummitTransmitterPanel() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter SummitTransmitterPanel Constructor");
        this.m_errorPopup = new ErrorPopup();
        this.m_table = new JTable();
        Audit.audit((int)1010, (String)FILE, (String)"Exit SummitTransmitterPanel Constructor");
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public void buildScreen(Object object, StatusBarListener statusBarListener) {
        Audit.audit((int)1009, (String)FILE, (String)"Enter buildScreen");
        this.m_window = (UIInternalFrame)object;
        this.setLayout(new GridBagLayout());
        CommonTableModel commonTableModel = new CommonTableModel();
        commonTableModel.setDataVector(this.m_data, this.m_columnNames);
        this.m_table.setModel(commonTableModel);
        this.m_table.setShowHorizontalLines(true);
        this.m_table.setShowVerticalLines(true);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(50);
        this.m_table.setName("Transmitter table");
        JTableHeader jTableHeader = this.m_table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        JScrollPane jScrollPane = new JScrollPane(this.m_table);
        jScrollPane.setPreferredSize(new Dimension(350, 150));
        GridBagAdder.add((Container)this, (Component)jScrollPane, (int)0, (int)0, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 3));
        if (this.isIsr) {
            this.m_transmitterTestBtn = new JButton(START_TRANSMITTER_TEST);
            this.m_transmitterTestBtn.setToolTipText("Perform Transmitter Test.");
            this.cmbDuration = new JComboBox();
            this.cmbDuration.addItem(DEFAULT_20_SECONDS);
            this.cmbDuration.addItem(CONTINUOUS_TEST_PATTERN);
            this.cmbDuration.setName("Duration Combo");
            this.lblDuration = new JLabel("                     Test Duration:");
            this.lblDuration.setToolTipText("Select Test Duration and then click the Start Transmitter Test button.");
            jPanel.add(this.m_transmitterTestBtn);
            jPanel.add(this.lblDuration);
            jPanel.add(this.cmbDuration);
        } else {
            this.m_transmitterTestBtn = new JButton(TRANSMITTER_TEST);
            this.m_transmitterTestBtn.setToolTipText("Perform Transmitter Test.");
            jPanel.add(new JLabel());
            jPanel.add(this.m_transmitterTestBtn);
            jPanel.add(new JLabel());
        }
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)4, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)10, (int)0, (int)10, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 0, 10));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.m_currentStatus = new JLabel("         ");
        jPanel2.add(this.m_currentStatus);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)6, (double)0.0, (double)0.0, (int)2, (int)2, (int)10, (int)1, (int)0, (int)0, (int)0, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_transmitterTestBtn, "Click this button to perform Transmitter Test");
        this.m_window.setCursor(new Cursor(3));
        Audit.audit((int)1010, (String)FILE, (String)"Exit buildScreen");
    }

    public synchronized void initialize() {
        Audit.audit((int)1009, (String)FILE, (String)"Enter initialize");
        for (int i = 0; i < 3; ++i) {
            this.m_current[i] = "Unknown";
        }
        this.m_currentStatus.setText(TRANSMITTER_TEST_STOPPED);
        if (this.cmbDuration != null) {
            this.cmbDuration.setSelectedItem(DEFAULT_20_SECONDS);
            if (this.isNormalMode) {
                this.enableCmbDuration(true);
            } else {
                this.enableCmbDuration(false);
            }
        }
        if (this.isRxOnly) {
            this.setTransmitterTestButtonEnabled(false);
        } else {
            this.setTransmitterTestButtonEnabled(true);
        }
        this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
        this.m_realtimeUpdateCalled = false;
        this.m_updateTransmitterTestCalled = false;
        Audit.audit((int)1010, (String)FILE, (String)"Exit initialize");
    }

    public void updateContTransmitterTest(int n, Integer n2) {
        LOG.enter("updateContTransmitterTest", new Object[]{n});
        this.m_window.unlockWindow();
        int n3 = -1;
        if (null != n2) {
            n3 = n2;
        }
        if (n == 0) {
            this.setStatusForContTransmitterTest(n3);
            this.isConTestPatternSupported = true;
        } else {
            this.setTransmitterTestButtonEnabled(true);
            this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
            this.isContTestStarted = false;
            this.isTransmitterTestStopped = true;
            if (null != this.cmbDuration) {
                this.isConTestPatternSupported = false;
                this.cmbDuration.setSelectedItem(DEFAULT_20_SECONDS);
                this.enableCmbDuration(false);
            }
            LOG.error((Object)("updateContTransmitterTest - device replied with error data: " + n3));
            LOG.error((Object)"Unable to Get Status of Continuous Transmitter Test.");
        }
        LOG.exit("updateContTransmitterTest");
    }

    public void startContTransmitterTest(int n, Integer n2) {
        LOG.enter("startContTransmitterTest", new Object[]{n});
        this.m_window.unlockWindow();
        int n3 = -1;
        if (null != n2) {
            n3 = n2;
        }
        if (n == 0) {
            this.setStatusForContTransmitterTest(n3);
        } else {
            this.setTransmitterTestButtonEnabled(true);
            this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
            this.isContTestStarted = false;
            this.isTransmitterTestStopped = true;
            if (DeviceErrorCodes.isInGeneralErrorRange(n3)) {
                this.m_errorPopup.display(n3);
            } else {
                this.m_errorPopup.display("Unable to Start Continuous Transmitter Test.");
            }
        }
        LOG.exit("startContTransmitterTest");
    }

    public void stopContTransmitterTest(int n, Integer n2) {
        LOG.enter("stopContTransmitterTest", new Object[]{n});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.setStatusForContTransmitterTest(1);
        } else {
            if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                this.m_errorPopup.display(n2.intValue());
            } else {
                this.m_errorPopup.display("Unable to Stop Continuous Transmitter Test.");
            }
            this.isTransmitterTestStopped = false;
            this.isContTestStarted = true;
        }
        LOG.exit("stopContTransmitterTest");
    }

    public synchronized boolean realTimeUpdate(RealTimeDataObject realTimeDataObject) {
        String string = new String("");
        boolean bl = false;
        Audit.audit((int)1009, (String)FILE, (String)"Enter realTimeUpdate.");
        RealTimeDataObject realTimeDataObject2 = realTimeDataObject;
        for (int i = 0; i < realTimeDataObject2.getSize(); ++i) {
            try {
                string = realTimeDataObject2.getName(i);
                byte[] byArray = (byte[])realTimeDataObject2.getValue(i);
                bl = this.updateTableFieldValues(string, byArray);
                if (string.equalsIgnoreCase("TransmitterTest")) {
                    byArray = (byte[])realTimeDataObject2.getValue(string);
                    int n = Convert.toInteger((byte[])byArray);
                    this.setTransmitterTestButtonEnabled(true);
                    this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
                    if (n == 1) {
                        this.m_currentStatus.setText(TRANSMITTER_TEST_SUCCESSFUL);
                    } else if (n == 2) {
                        this.m_currentStatus.setText(TRANSMITTER_TEST_FAIL);
                    } else {
                        this.m_errorPopup.display(TRANSMITTER_TEST_UNKNOWN);
                        this.m_currentStatus.setText(TRANSMITTER_TEST_STOPPED);
                    }
                    this.isTransmitterTestStopped = true;
                    this.enableCmbDuration(true);
                    bl = true;
                    continue;
                }
                if (!string.equalsIgnoreCase("ContinuousTransmitterTest")) continue;
                byArray = (byte[])realTimeDataObject2.getValue(string);
                int n = Convert.toInteger((byte[])byArray);
                this.setStatusForContTransmitterTest(n);
                continue;
            }
            catch (NotFoundException notFoundException) {
                Audit.audit((int)1001, (String)FILE, (String)"realTimeUpdate: Received unexpected field name which is not in the table");
            }
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit realTimeUpdate");
        return bl;
    }

    private void setStatusForContTransmitterTest(int n) {
        LOG.enter("setStatusForContTransmitterTest");
        switch (n) {
            case 1: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_STOPPED);
                if (this.cmbDuration != null) {
                    if (this.isNormalMode) {
                        this.enableCmbDuration(true);
                    } else {
                        this.cmbDuration.setSelectedItem(DEFAULT_20_SECONDS);
                        this.enableCmbDuration(false);
                    }
                }
                this.setTransmitterTestButtonEnabled(true);
                this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
                this.isTransmitterTestStopped = true;
                this.isContTestStarted = false;
                break;
            }
            case 2: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_IN_PROGRESS);
                if (this.cmbDuration != null) {
                    this.setTransmitterTestButtonEnabled(true);
                    this.setTransmitterTestButtonText(STOP_TRANSMITTER_TEST);
                    this.cmbDuration.setSelectedItem(CONTINUOUS_TEST_PATTERN);
                    this.enableCmbDuration(false);
                }
                this.isTransmitterTestStopped = false;
                this.isContTestStarted = true;
                break;
            }
            case 3: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_INH);
                break;
            }
            case 4: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_FAIL);
                break;
            }
            case 5: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_INIT);
                break;
            }
            case 6: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_DFB);
                break;
            }
            case 7: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_VOICE_DATA);
                break;
            }
            case 8: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_CC_ACTIV);
                break;
            }
            case 9: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_BSI);
                break;
            }
            case 10: {
                this.m_currentStatus.setText(TRANSMITTER_TEST_SUSPENDED_TEST_ACTIV);
            }
        }
        if (n > 2) {
            this.enableCmbDuration(false);
            this.cmbDuration.setSelectedItem(CONTINUOUS_TEST_PATTERN);
            this.setTransmitterTestButtonEnabled(true);
            this.setTransmitterTestButtonText(STOP_TRANSMITTER_TEST);
            this.isTransmitterTestStopped = false;
            this.isContTestStarted = true;
        }
        LOG.exit("setStatusForContTransmitterTest");
    }

    public void showErrorForTransmitterTest(Integer n) {
        if (null == n) {
            this.m_errorPopup.display("Unable to Start Transmitter Test.");
        } else {
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    this.m_errorPopup.display(-327834);
                    break;
                }
                case 3: {
                    this.m_errorPopup.display(-327835);
                    break;
                }
                case 4: {
                    this.m_errorPopup.display(-327836);
                    break;
                }
                case 5: {
                    this.m_errorPopup.display(-327837);
                    break;
                }
                case 6: {
                    this.m_errorPopup.display(-620001);
                    break;
                }
                case 7: {
                    this.m_errorPopup.display(-327839);
                    break;
                }
                case 8: {
                    this.m_errorPopup.display(-327861);
                    break;
                }
                case 9: {
                    this.m_errorPopup.display(-327862);
                    break;
                }
                default: {
                    if (DeviceErrorCodes.isInGeneralErrorRange(n)) {
                        this.m_errorPopup.display(n.intValue());
                        break;
                    }
                    this.m_errorPopup.display("Unable to Start Transmitter Test.");
                }
            }
        }
        if (!this.m_updateTransmitterTestCalled) {
            this.m_realtimeUpdateCalled = true;
        }
        this.setTransmitterTestButtonEnabled(true);
        this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
        this.isContTestStarted = false;
        this.isTransmitterTestStopped = true;
        this.enableCmbDuration(true);
        this.m_currentStatus.setText(TRANSMITTER_TEST_STOPPED);
    }

    private boolean updateTableFieldValues(String string, byte[] byArray) {
        boolean bl = false;
        if (string.equals("forwardPower")) {
            this.m_current[0] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[0], 0, 1);
            bl = true;
        } else if (string.equals("reflectedPower")) {
            this.m_current[1] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[1], 1, 1);
            bl = true;
        } else if (string.equals("stationVswr")) {
            this.m_current[2] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[2], 2, 1);
            bl = true;
        } else if (string.equals("storedForwardPower")) {
            this.m_current[3] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[3], 3, 1);
            bl = true;
        } else if (string.equals("storedReflectedPower")) {
            this.m_current[4] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[4], 4, 1);
            bl = true;
        } else if (string.equals("storedStationVswr")) {
            this.m_current[5] = this.convertValueUnsigned(byArray);
            this.m_table.setValueAt(this.m_current[5], 5, 1);
            bl = true;
        }
        return bl;
    }

    private String convertValueUnsigned(byte[] byArray) {
        int n = 0;
        String string = null;
        for (int i = 0; i < byArray.length; ++i) {
            n += 0xFF & byArray[i];
            if (i >= byArray.length - 1) continue;
            n <<= 8;
        }
        string = n > 300 ? "" : Integer.toString(n);
        return string;
    }

    public synchronized void updateTransmitterTest(int n) {
        if (n == 0) {
            if (!this.m_realtimeUpdateCalled) {
                this.setTransmitterTestButtonEnabled(false);
                this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
                this.m_currentStatus.setText(TRANSMITTER_TEST_IN_PROGRESS);
                this.m_updateTransmitterTestCalled = true;
                this.isContTestStarted = false;
                this.isTransmitterTestStopped = false;
                this.enableCmbDuration(false);
            }
        } else {
            this.setTransmitterTestButtonEnabled(true);
            this.setTransmitterTestButtonText(START_TRANSMITTER_TEST);
            this.m_currentStatus.setText(TRANSMITTER_TEST_FAIL);
            this.isContTestStarted = false;
            this.isTransmitterTestStopped = true;
            this.enableCmbDuration(true);
        }
    }

    private void enableCmbDuration(Boolean bl) {
        if (null != this.cmbDuration) {
            if (bl.booleanValue() && this.isNormalMode && this.isConTestPatternSupported) {
                this.cmbDuration.setEnabled(true);
            } else {
                this.cmbDuration.setEnabled(false);
            }
        }
    }

    public void handleStartExciterMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStartExciterMetering Error:" + n));
        this.m_window.unlockWindow();
        this.m_window.setCursor(new Cursor(0));
        if (n != 0) {
            int n2 = 0;
            int n3 = 0;
            while (n2 < this.m_current.length) {
                this.m_current[n2] = "Unknown";
                this.m_table.setValueAt(this.m_current[n2], n3, 1);
                ++n2;
                ++n3;
            }
            this.m_errorPopup.display(-327831);
            Audit.audit((int)1002, (String)FILE, (String)"Transmiter Metering Command Error");
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStartExciterMetering");
    }

    public void handleStopMetering(int n) {
        Audit.audit((int)1009, (String)FILE, (String)("Enter handleStopMetering(): g_error = " + n));
        if (n != 0) {
            Audit.audit((int)1002, (String)FILE, (String)("Received error " + n + " while trying to stop transmitter metering"));
        }
        Audit.audit((int)1010, (String)FILE, (String)"Exit handleStopMetering()");
    }

    private void setTransmitterTestButtonEnabled(boolean bl) {
        this.m_transmitterTestBtn.setEnabled(bl);
    }

    private void setTransmitterTestButtonText(String string) {
        if (this.isIsr) {
            this.m_transmitterTestBtn.setText(string);
        } else {
            this.m_transmitterTestBtn.setText(TRANSMITTER_TEST);
        }
    }

    public void setNormalMode(boolean bl) {
        LOG.enter("setNormalMode");
        this.isNormalMode = bl;
        LOG.exit("setNormalMode");
    }

    public void updateNormalModeDependencies() {
        LOG.enter("updateNormalModeDependencies");
        if (this.isTransmitterTestStopped) {
            this.enableCmbDuration(true);
        }
        LOG.exit("updateNormalModeDependencies");
    }

    public void updateOtherThanNormalModeDependencies() {
        LOG.enter("updateOtherThanNormalModeDependencies");
        if (null != this.cmbDuration) {
            this.cmbDuration.setSelectedItem(DEFAULT_20_SECONDS);
            this.enableCmbDuration(false);
        }
        LOG.exit("updateOtherThanNormalModeDependencies");
    }

    public boolean isContinuousTestSelected() {
        return this.cmbDuration != null && this.cmbDuration.getSelectedItem().equals(CONTINUOUS_TEST_PATTERN);
    }

    public boolean isContinuousTestSelectedAndTestPatternStarted() {
        return this.isContinuousTestSelected() && this.isContTestStarted;
    }

    public boolean isContinuousTestSelectedAndTestPatternStopped() {
        return this.isContinuousTestSelected() && this.isTransmitterTestStopped;
    }

    public void setIsr(boolean bl) {
        this.isIsr = bl;
    }

    public void setRxOnly(boolean bl) {
        this.isRxOnly = bl;
    }

    public class Get_ConvBR_HardwarePlatform_Rule
    extends Rule {
        private final String sConvBRHardwarePlatform = "sConvBRHardwarePlatform";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sConvBRHardwarePlatform", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return Devices.isConvBrApplication((String)SummitTransmitterPanel.this.appHWCombination);
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            Integer[] integerArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Hardware Platform Type");
            } else if (null != messageIfc && (integerArray = (Integer[])messageIfc.getParameterValue("sConvBRHardwarePlatform"))[0] == 2) {
                SummitTransmitterPanel.this.setTransmitterTestButtonEnabled(false);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class Get_MsBR_HardwarePlatform_Rule
    extends Rule {
        private final String sHardwarePlatform = "sHardwarePlatform";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sHardwarePlatform", Integer[].class);
            message.setProtocolKey(1006);
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return Devices.isMsBrApplication((String)SummitTransmitterPanel.this.appHWCombination);
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            Integer[] integerArray;
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Hardware Platform Type");
            } else if (null != messageIfc && (integerArray = (Integer[])messageIfc.getParameterValue("sHardwarePlatform"))[0] == 2) {
                SummitTransmitterPanel.this.setTransmitterTestButtonEnabled(false);
            }
            LOG.exit("update");
            return true;
        }
    }
}

