/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.service.ConditionRule;
import css.core.service.Convert;
import css.core.service.DataObject;
import css.core.service.MessageIfc;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.service.ServiceProtocolMultiplexer;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.summit.screens.alignment.CarrierSquelchTab;
import css.device.platform.summit.screens.alignment.CarrierSquelchTabGUI;
import css.device.platform.summit.screens.alignment.RxWirelinePanel;
import css.device.platform.summit.screens.alignment.SacReferenceOscillatorFrequencyTab;
import css.device.platform.summit.screens.alignment.SacReferenceOscillatorFrequencyTabGUI;
import css.device.platform.summit.screens.alignment.SummitAstroSimulcastAlignment;
import css.device.platform.summit.screens.alignment.SummitBatteryEqualizationScreen;
import css.device.platform.summit.screens.alignment.TxWirelinePanel;
import css.device.platform.summit.screens.alignment.WirelineController;
import css.device.platform.summit.tables.SummitTranslationInfoRules;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;

public class SummitAlignmentScreen
extends GenericScreen {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitAlignmentScreen.class);
    private final String BATTEQUAL_ALIGNMENT_TAB = "Battery Equalization";
    private final String ASTRO_ALIGNMENT_TAB = "ASTRO Simulcast Alignment";
    private final String ASTRO_ANALOG_ALIGNMENT_TAB = "ASTRO/Analog Simulcast Alignment";
    private final String SAC_REFERENCE_OSCILLATOR_TAB = "Reference Oscillator Alignment";
    private final String CARRIER_SQUELCH_TAB = "Carrier Squelch Alignment";
    private final String TX_WIRELINE_TAB = "Tx Wireline Alignment";
    private final String RX_WIRELINE_TAB = "Rx Wireline Alignment";
    private int nCurrentDeviceMode;
    private static final String NOTE_NON_CONVBR_ANALOG_SIMULCAST = "Note: The station must be set to Service mode in order to perform any alignment or tone generation.";
    private static final String NOTE_WITH_ENTER_KEY_COMMIT = "<html>Notes: The station must be set to Service mode in order to perform any alignment or tone generation.<p align=\"center\">In order to commit current values enter must be pressed.</p>";
    private static final String NOTE_CONVBR_ANLG_SUMULCAST = "<html>Notes: The station must be set to Service mode in order to perform any alignment or tone generation.<p align=\"center\">When applied to Analog Simulcast, Simulcast Launch Time Offset is merely a delay of the Analog transmit signal.</p>";
    private static final String m_serviceModeBtnLblStr = "Change to Service Mode";
    private static final String m_normalModeBtnLblStr = "Change to Normal Mode";
    private static final String m_modeBtnNameStr = "Change Mode Button";
    private boolean m_rxWirelinePanelOpened = false;
    public SummitBatteryEqualizationScreen m_battEqualScreen;
    public SummitAstroSimulcastAlignment m_astroSimulcast;
    public SacReferenceOscillatorFrequencyTab m_refOscilatorFreqTab;
    public CarrierSquelchTab m_carrierSquelchTab;
    public TxWirelinePanel m_txWirelinePanel = null;
    public RxWirelinePanel m_rxWirelinePanel = null;
    public JButton m_deviceModeBtn = new JButton("Change to Normal Mode");
    private JTabbedPane m_tabbedPane;
    private boolean m_isSimulcastApp = true;
    private ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    private JLabel m_modeMessageLbl = new JLabel("Note: The station must be set to Service mode in order to perform any alignment or tone generation.");
    private ErrorPopup m_errorPopup = new ErrorPopup();
    private int m_nTabNumberSimulcast = -2;
    private int m_nTabNumberSAC = -2;
    private int m_nTabNumberCSQ = -2;
    private int m_nTabBatteryEqu = -2;
    private int m_nTabTxWireline = -2;
    private int m_nTabRxWireline = -2;
    public WirelineController m_wirelineController = null;

    public SummitAlignmentScreen() {
        LOG.enter("SummitAlignmentScreen");
        this.m_tabbedPane = new JTabbedPane();
        this.m_tabbedPane.setName("TabbedPane");
        this.m_battEqualScreen = new SummitBatteryEqualizationScreen(this);
        this.m_battEqualScreen.setName("BattEqualPanel");
        this.m_astroSimulcast = new SummitAstroSimulcastAlignment(this);
        this.m_refOscilatorFreqTab = new SacReferenceOscillatorFrequencyTab(this);
        this.m_carrierSquelchTab = new CarrierSquelchTab(this);
        this.m_txWirelinePanel = new TxWirelinePanel(this);
        this.m_rxWirelinePanel = new RxWirelinePanel(this);
        this.m_wirelineController = new WirelineController();
        this.m_wirelineController.setTxWirelineView(this.m_txWirelinePanel);
        this.m_wirelineController.setRxWirelineView(this.m_rxWirelinePanel);
        LOG.exit("SummitAlignmentScreen");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        this.MENU_ITEM_NAME = "Alignment Screen";
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        if (!(this.isMsBR() || this.isConvBR() || this.isMsBR3600())) {
            this.m_isSimulcastApp = false;
        }
        int n = 0;
        this.insertBatteryEqualizationTab(statusBarListener, n);
        if (this.m_isSimulcastApp) {
            this.insertAstroSimulcastTab(statusBarListener, ++n);
        }
        if (!this.isMsBR3600()) {
            this.insertReferenceOscillatorTab(statusBarListener, ++n);
        }
        if (this.isConvBR() || this.isIR3600()) {
            this.insertCarrierSquelchTab(statusBarListener, ++n);
            this.insertTXWirelineTab(statusBarListener, ++n);
            this.insertRXWirelineTab(statusBarListener, ++n);
        } else if (this.isMsBR3600()) {
            this.insertCarrierSquelchTab(statusBarListener, ++n);
            this.insertRXWirelineTab(statusBarListener, ++n);
        }
        int n2 = 0;
        int n3 = 0;
        for (Component component : this.m_tabbedPane.getComponents()) {
            Dimension dimension = component.getPreferredSize();
            n2 = Math.max(n2, dimension.width);
            n3 = Math.max(n3, dimension.height);
        }
        Dimension dimension = new Dimension(n2 + 24, n3 + 64);
        this.m_tabbedPane.setPreferredSize(dimension);
        this.m_tabbedPane.setMinimumSize(dimension);
        this.m_window.pack();
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (SummitAlignmentScreen.this.m_rxWirelinePanelOpened) {
                    SummitAlignmentScreen.this.uncheckToneOnOffButtons();
                    SummitAlignmentScreen.this.m_rxWirelinePanelOpened = false;
                }
                if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof CarrierSquelchTabGUI) {
                    LOG.trace((Object)"buildScreen - CSQ tab selected");
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                    SummitAlignmentScreen.this.startCarrierSquelchInitRules();
                    SummitAlignmentScreen.this.dekeyTxWireline();
                } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof TxWirelinePanel) {
                    LOG.trace((Object)"buildScreen - TxWireline tab selected");
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_WITH_ENTER_KEY_COMMIT);
                    SummitAlignmentScreen.this.startTxWirelineInitRules();
                } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof RxWirelinePanel) {
                    LOG.trace((Object)"buildScreen - RxWireline tab selected");
                    SummitAlignmentScreen.this.m_rxWirelinePanelOpened = true;
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_WITH_ENTER_KEY_COMMIT);
                    SummitAlignmentScreen.this.startRxWirelineInitRules();
                } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof SummitAstroSimulcastAlignment) {
                    LOG.trace((Object)"buildScreen - Astro Simulcast tab selected");
                    if (SummitAlignmentScreen.this.m_astroSimulcast.getIsSimulcastEnabled() && SummitAlignmentScreen.this.isConvBR()) {
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_CONVBR_ANLG_SUMULCAST);
                    } else {
                        SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                    }
                    SummitAlignmentScreen.this.dekeyTxWireline();
                } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof SummitBatteryEqualizationScreen) {
                    LOG.trace((Object)"buildScreen - Battery Equalization tab selected");
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                    SummitAlignmentScreen.this.startBatteryEqualizationTabUpdateRules();
                    SummitAlignmentScreen.this.dekeyTxWireline();
                } else if (SummitAlignmentScreen.this.m_tabbedPane.getSelectedComponent() instanceof SacReferenceOscillatorFrequencyTab) {
                    LOG.trace((Object)"buildScreen - Reference Oscillator tab selected");
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                    if (SacReferenceOscillatorFrequencyTabGUI.SACRefOscStatus.NA == SummitAlignmentScreen.this.m_refOscilatorFreqTab.getStatus() && SummitAlignmentScreen.this.isDeviceInServiceMode()) {
                        SummitAlignmentScreen.this.m_refOscilatorFreqTab.displayWarningTocModuleNotInstalled();
                    }
                    SummitAlignmentScreen.this.dekeyTxWireline();
                } else {
                    SummitAlignmentScreen.this.m_modeMessageLbl.setText(SummitAlignmentScreen.NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                }
                LOG.exit("stateChanged");
            }
        });
        this.buildModeSwitchPanel(statusBarListener);
        this.disableScreen();
        LOG.exit("buildScreen");
    }

    private void dekeyTxWireline() {
        if (this.isConvBR()) {
            Session4OldRules session4OldRules = new Session4OldRules();
            Rule[] ruleArray = new Rule[1];
            ruleArray[0] = new WirelineController.DeKeyLine1_Rule(this.m_wirelineController);
            ConditionRule conditionRule = new ConditionRule(ruleArray);
            conditionRule.process((SessionIfc)session4OldRules);
            Rule[] ruleArray2 = new Rule[1];
            ruleArray2[0] = new WirelineController.DeKeyLine3_Rule(this.m_wirelineController);
            conditionRule = new ConditionRule(ruleArray2);
            conditionRule.process((SessionIfc)session4OldRules);
        }
    }

    private void insertBatteryEqualizationTab(StatusBarListener statusBarListener, int n) {
        this.m_battEqualScreen.buildScreen(this.m_window, statusBarListener, this.m_tabbedPane);
        this.m_nTabBatteryEqu = n;
        this.m_tabbedPane.insertTab("Battery Equalization", null, this.m_battEqualScreen, null, this.m_nTabBatteryEqu);
        this.m_battEqualScreen.setEnabled(false);
    }

    private void insertAstroSimulcastTab(StatusBarListener statusBarListener, int n) {
        this.m_astroSimulcast.buildScreen(this.m_window, statusBarListener);
        this.m_nTabNumberSimulcast = n;
        String string = this.isConvBR() ? "ASTRO/Analog Simulcast Alignment" : "ASTRO Simulcast Alignment";
        this.m_tabbedPane.insertTab(string, null, this.m_astroSimulcast, null, this.m_nTabNumberSimulcast);
    }

    private void insertReferenceOscillatorTab(StatusBarListener statusBarListener, int n) {
        this.m_refOscilatorFreqTab.buildScreen(this.m_window, statusBarListener);
        this.m_nTabNumberSAC = n;
        this.m_tabbedPane.insertTab("Reference Oscillator Alignment", null, this.m_refOscilatorFreqTab, null, this.m_nTabNumberSAC);
    }

    private void insertCarrierSquelchTab(StatusBarListener statusBarListener, int n) {
        this.m_carrierSquelchTab.buildScreen(this.m_window, statusBarListener);
        this.m_nTabNumberCSQ = n;
        this.m_tabbedPane.insertTab("Carrier Squelch Alignment", null, this.m_carrierSquelchTab, null, this.m_nTabNumberCSQ);
        this.m_tabbedPane.setEnabledAt(this.m_nTabNumberCSQ, true);
    }

    private void insertTXWirelineTab(StatusBarListener statusBarListener, int n) {
        this.m_txWirelinePanel.buildScreen(this.m_window, statusBarListener);
        this.m_nTabTxWireline = n;
        this.m_tabbedPane.insertTab("Tx Wireline Alignment", null, this.m_txWirelinePanel, null, this.m_nTabTxWireline);
    }

    private void insertRXWirelineTab(StatusBarListener statusBarListener, int n) {
        this.m_rxWirelinePanel.buildScreen(this.m_window, statusBarListener);
        this.m_nTabRxWireline = n;
        this.m_tabbedPane.insertTab("Rx Wireline Alignment", null, this.m_rxWirelinePanel, null, this.m_nTabRxWireline);
    }

    public boolean startBatteryEqualizationTabUpdateRules() {
        LOG.enter("startBatteryEqualizationTabUpdateRules");
        boolean bl = true;
        Session4OldRules session4OldRules = new Session4OldRules();
        SummitBatteryEqualizationScreen.GetPowerSupplyType_Rule getPowerSupplyType_Rule = new SummitBatteryEqualizationScreen.GetPowerSupplyType_Rule(this.m_battEqualScreen);
        getPowerSupplyType_Rule.process(session4OldRules);
        LOG.exit("startBatteryEqualizationTabUpdateRules");
        return bl;
    }

    private void buildModeSwitchPanel(StatusBarListener statusBarListener) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setPreferredSize(new Dimension(400, 60));
        GridBagAdder.add((Container)jPanel, (Component)this.m_modeMessageLbl, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0);
        this.m_deviceModeBtn.setToolTipText("Switches the Station between Normal and Service Mode");
        this.m_deviceModeBtn.setEnabled(true);
        this.m_deviceModeBtn.setName(m_modeBtnNameStr);
        this.m_modeMessageLbl.setEnabled(true);
        GridBagAdder.add((Container)jPanel, (Component)this.m_deviceModeBtn, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)2, (int)0, (int)150, (int)0, (int)150, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)5, (int)12, (int)0, (int)0);
        statusBarListener.registerComponent((Component)this.m_deviceModeBtn, "Click this button to change the station's mode");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.m_window.lockWindow();
        this.disableScreen();
        this.m_deviceModeBtn.setText(m_normalModeBtnLblStr);
        this.m_deviceModeBtn.setName(m_modeBtnNameStr);
        if (this.m_isSimulcastApp) {
            this.m_astroSimulcast.initialize();
        }
        this.m_battEqualScreen.initialize();
        LOG.exit("initialize");
    }

    private void disableScreen() {
        LOG.enter("disableScreen");
        this.m_battEqualScreen.disableGuiControl();
        LOG.exit("disableScreen");
    }

    public void handleStopSession(int n) {
        LOG.enter("handleStopSession", new Object[]{n});
        if (n != 0) {
            LOG.error((Object)"handleStopSession - Received error while trying to close session");
        }
        LOG.exit("handleStopSession");
    }

    public void realTimeUpdate(Object object) {
        LOG.enter("realTimeUpdate", new Object[]{object});
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        LOG.enter("realTimeUpdate", new Object[]{object});
        if (realTimeDataObject != null) {
            if (realTimeDataObject.getError() != 0) {
                Integer n = null;
                byte[] byArray = null;
                if (realTimeDataObject instanceof FspRealTimeDataObject) {
                    byArray = ((FspRealTimeDataObject)realTimeDataObject).getData();
                    n = Convert.toInteger((byte[])byArray);
                }
                if (realTimeDataObject.getError() == -262160) {
                    LOG.error((Object)("realTimeUpdate" + realTimeDataObject.getError()));
                    this.popupError(-262160);
                    this.close();
                } else if (realTimeDataObject instanceof FspRealTimeDataObject && ((FspRealTimeDataObject)realTimeDataObject).getOpCode() == -1) {
                    switch (((FspRealTimeDataObject)realTimeDataObject).getSubOpCode()) {
                        case 4: {
                            this.m_astroSimulcast.showErrorForSimulcastTestPattern(n);
                            break;
                        }
                        case 25: {
                            this.showErrorForKeyupDekey(n);
                            break;
                        }
                        default: {
                            if (DeviceErrorCodes.isInGeneralErrorRange(n)) {
                                LOG.error((Object)("realTimeUpdate - Error data: " + n));
                                this.popupError(n);
                                break;
                            }
                            LOG.error((Object)("realTimeUpdate - Unknown error code: " + realTimeDataObject.getError()));
                        }
                    }
                }
            }
            this.m_carrierSquelchTab.realTimeUpdate(realTimeDataObject);
        }
        LOG.exit("realTimeUpdate");
    }

    public Object[] startSession() {
        LOG.enter("startSession");
        this.m_window.setCursor(Cursor.getPredefinedCursor(3));
        Byte by = new Byte(0);
        Byte by2 = new Byte(0);
        Object[][] objectArray = SummitTranslationInfoRules.SummitAlignmentRules;
        Object[] objectArray2 = new Object[]{by, by2, objectArray};
        LOG.exit("startSession");
        return objectArray2;
    }

    public void handleStartSession(int n) {
        LOG.enter("handleStartSession", new Object[]{n});
        if (n != 0) {
            this.popupError("unable_to_start_session");
            this.close();
        }
        LOG.exit("handleStartSession");
    }

    private boolean initSACTabRules(SessionIfc sessionIfc) {
        boolean bl = true;
        Rule rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_SacFreqRefOscStatus();
        if (rule.process(sessionIfc)) {
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_Transmit_Frequency();
            rule.process(sessionIfc);
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Get_SacFreqRefOsc_Value_Rule();
            rule.process(sessionIfc);
            rule = this.isConvBR() ? this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_ConvBR_Tx_Service() : this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Init_Rule_Hardware_Type();
            rule.process(sessionIfc);
            rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.Get_KeyUp_DeKey_Status_Rule();
            rule.process(sessionIfc);
            this.m_tabbedPane.setEnabledAt(this.m_nTabNumberSAC, true);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean startSACTabInitRules() {
        LOG.enter("startSACTabInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (this.isConvBR() || this.isIR3600()) {
            if (5 == this.nCurrentDeviceMode) {
                this.m_window.setCursor(Cursor.getPredefinedCursor(3));
                Session4OldRules session4OldRules = new Session4OldRules();
                this.initSACTabRules(session4OldRules);
                this.m_carrierSquelchTab.setServiceMode(true);
            } else {
                this.m_carrierSquelchTab.setServiceMode(false);
                this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
            }
        } else if (Devices.isIsrApplication((String)string).booleanValue()) {
            if (5 == this.nCurrentDeviceMode) {
                this.m_window.setCursor(Cursor.getPredefinedCursor(3));
                Session4OldRules session4OldRules = new Session4OldRules();
                this.initSACTabRules(session4OldRules);
            } else {
                this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
            }
        } else if (this.isMsBR3600()) {
            if (5 == this.nCurrentDeviceMode) {
                this.m_carrierSquelchTab.setServiceMode(true);
            } else {
                this.m_carrierSquelchTab.setServiceMode(false);
            }
        } else {
            this.m_refOscilatorFreqTab.updateScreenSacOperational(false);
        }
        this.m_window.setCursor(Cursor.getPredefinedCursor(0));
        LOG.exit("startSACTabInitRules", (Object)bl);
        return bl;
    }

    public boolean startSACTabCloseRules() {
        LOG.enter("startSACTabCloseRules");
        boolean bl = true;
        Session4OldRules session4OldRules = new Session4OldRules();
        SacReferenceOscillatorFrequencyTab.DeKey_Rule deKey_Rule = this.m_refOscilatorFreqTab.new SacReferenceOscillatorFrequencyTab.DeKey_Rule();
        deKey_Rule.process(session4OldRules);
        LOG.exit("startSACTabCloseRules", (Object)bl);
        return bl;
    }

    public void updateNormalModeDependencies(int n) {
        LOG.enter("updateNormalModeDependencies", new Object[]{n});
        if (n == 0) {
            if (this.is3600()) {
                ScreenManager.suspend(true);
            } else {
                ScreenManager.suspend(false);
            }
        } else {
            LOG.warn((Object)"Unable to Change mode");
            this.m_errorPopup.display(-327684);
        }
        LOG.exit("updateNormalModeDependencies");
    }

    public void updateModeDependencies(int n, Integer n2) {
        LOG.enter("updateModeDependencies", new Object[]{n, n2});
        int n3 = n2;
        if (n == 0) {
            this.nCurrentDeviceMode = n3;
            if (this.m_tabbedPane.getSelectedComponent() instanceof CarrierSquelchTabGUI) {
                this.m_modeMessageLbl.setText(NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                this.startCarrierSquelchInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof TxWirelinePanel) {
                this.m_modeMessageLbl.setText(NOTE_WITH_ENTER_KEY_COMMIT);
                this.startTxWirelineInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof RxWirelinePanel) {
                this.m_modeMessageLbl.setText(NOTE_WITH_ENTER_KEY_COMMIT);
                this.startRxWirelineInitRules();
            } else if (this.m_tabbedPane.getSelectedComponent() instanceof SummitAstroSimulcastAlignment) {
                if (this.m_astroSimulcast.getIsSimulcastEnabled() && this.isConvBR()) {
                    this.m_modeMessageLbl.setText(NOTE_CONVBR_ANLG_SUMULCAST);
                } else {
                    this.m_modeMessageLbl.setText(NOTE_NON_CONVBR_ANALOG_SIMULCAST);
                }
            } else {
                this.m_modeMessageLbl.setText(NOTE_NON_CONVBR_ANALOG_SIMULCAST);
            }
            if (n3 == 2) {
                this.m_deviceModeBtn.setText(m_serviceModeBtnLblStr);
                if (this.m_isSimulcastApp) {
                    this.m_astroSimulcast.m_transmitFrequencyLbl.setEnabled(false);
                    this.m_astroSimulcast.m_voCurrentTransmitOffsetDelay.setEnabled(false);
                    if (this.m_astroSimulcast.hasAnalogTransmitField()) {
                        this.m_astroSimulcast.m_voCurrentAnalogTransmitOffsetDelay.setEnabled(false);
                    }
                    this.m_astroSimulcast.m_storeTransmitOffsetDelayBtn.setEnabled(false);
                    this.m_astroSimulcast.m_testPatternBtn.setEnabled(false);
                    if (!this.m_astroSimulcast.getIsDigitalOffsetEnabledByDependency()) {
                        this.m_astroSimulcast.m_voCurrentTransmitOffsetDelay.setText("N/A");
                    }
                    if (!this.m_astroSimulcast.getIsAnalogOffsetEnabledByDependency()) {
                        this.m_astroSimulcast.m_voCurrentAnalogTransmitOffsetDelay.setText("N/A");
                    }
                }
                this.m_rxWirelinePanel.getWirelineButton().setEnabled(false);
                if (this.isIR3600()) {
                    this.m_rxWirelinePanel.getStatusButton().setEnabled(false);
                }
                this.m_txWirelinePanel.getKeyupLine1Component().setEnabled(false);
                this.m_txWirelinePanel.getKeyupLine3Component().setEnabled(false);
            } else if (n3 == 5) {
                this.m_deviceModeBtn.setText(m_normalModeBtnLblStr);
                if (this.m_isSimulcastApp) {
                    this.m_astroSimulcast.m_transmitFrequencyLbl.setEnabled(true);
                    boolean bl = this.m_astroSimulcast.getIsDigitalOffsetEnabledByDependency();
                    this.m_astroSimulcast.m_voCurrentTransmitOffsetDelay.setEnabled(bl);
                    if (!bl) {
                        this.m_astroSimulcast.m_voCurrentTransmitOffsetDelay.setText("N/A");
                    }
                    boolean bl2 = true;
                    if (this.m_astroSimulcast.hasAnalogTransmitField()) {
                        bl2 = this.m_astroSimulcast.getIsAnalogOffsetEnabledByDependency();
                        this.m_astroSimulcast.m_voCurrentAnalogTransmitOffsetDelay.setEnabled(bl2);
                        if (!bl2) {
                            this.m_astroSimulcast.m_voCurrentAnalogTransmitOffsetDelay.setText("N/A");
                        }
                    }
                    this.m_astroSimulcast.m_storeTransmitOffsetDelayBtn.setEnabled(bl2 || bl);
                    this.m_astroSimulcast.m_testPatternBtn.setEnabled(bl2 || bl);
                }
                this.m_rxWirelinePanel.getWirelineButton().setEnabled(true);
                if (this.isIR3600()) {
                    this.m_rxWirelinePanel.getStatusButton().setEnabled(true);
                }
                this.m_txWirelinePanel.getKeyupLine1Component().setEnabled(true);
                this.m_txWirelinePanel.getKeyupLine3Component().setEnabled(true);
            } else {
                LOG.warn((Object)"The station is in Config mode");
                PnmDialog.error((Object)this.m_window, (String)"device_is_in_unknown_mode");
                this.closeScreen(true);
            }
            if (!this.m_isSimulcastApp) {
                this.m_window.unlockWindow();
            }
        } else {
            LOG.warn((Object)"Unable to Change mode");
            PnmDialog.error((Object)this.m_window, (String)"unable_to_get_mode");
            this.closeScreen(true);
        }
        LOG.exit("updateModeDependencies");
    }

    public boolean userRequest() {
        LOG.enter("userRequest");
        if (this.is3600()) {
            this.m_confirmPopup.display(-327687);
        } else {
            this.m_confirmPopup.display(-327683);
        }
        if (this.m_confirmPopup.getStatus()) {
            this.m_window.lockWindow();
        }
        LOG.exit("userRequest", (Object)false);
        return false;
    }

    public boolean isDeviceInServiceMode() {
        return this.nCurrentDeviceMode == 5;
    }

    public boolean isSetForNormal() {
        boolean bl = false;
        LOG.enter("isSetForNormal");
        if (this.m_confirmPopup.getStatus() && this.isDeviceInServiceMode()) {
            bl = true;
        }
        LOG.exit("Exit isSetForNormal", (Object)bl);
        return bl;
    }

    public boolean isDeviceInNormalMode() {
        return this.nCurrentDeviceMode == 2;
    }

    public boolean isSetForService() {
        boolean bl = false;
        LOG.enter("isSetForService");
        if (this.m_confirmPopup.getStatus() && this.isDeviceInNormalMode()) {
            bl = true;
        }
        LOG.exit("Exit isSetForService", (Object)bl);
        return bl;
    }

    public boolean isSimulcastApplication() {
        LOG.enter("isSimulcastApplication");
        LOG.exit("isSimulcastApplication", (Object)this.m_isSimulcastApp);
        return this.m_isSimulcastApp;
    }

    public boolean startCarrierSquelchInitRules() {
        LOG.enter("startCarrierSquelchInitRules");
        boolean bl = true;
        if ((this.isConvBR() || this.isMsBR3600() || this.isIR3600()) && 5 == this.nCurrentDeviceMode) {
            this.m_carrierSquelchTab.setInitialization(true);
            this.m_window.lockWindow();
            this.m_carrierSquelchTab.m_oGenericListener.notifyGuiListener();
            this.m_carrierSquelchTab.setInitialization(false);
        }
        LOG.exit("startCarrierSquelchInitRules", (Object)bl);
        return bl;
    }

    public boolean startTxWirelineInitRules() {
        LOG.enter("startWirelineInitRules");
        boolean bl = true;
        if (this.isConvBR() || this.isIR3600()) {
            this.m_wirelineController.setDeviceMode(this.nCurrentDeviceMode);
            this.m_txWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            Rule rule = new WirelineController.SetWirelineAlignment_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
            rule = new WirelineController.Get_KeyUp_DeKey_Line1_Status_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
            rule = new WirelineController.Get_KeyUp_DeKey_Line3_Status_Rule(this.m_wirelineController);
            rule.process((SessionIfc)session4OldRules);
        }
        LOG.exit("startWirelineInitRules");
        return bl;
    }

    public boolean uncheckToneOnOffButtons() {
        LOG.enter("uncheckToneOnOffButtons");
        boolean bl = true;
        if (this.isConvBR() || this.isMsBR3600() || this.isIR3600()) {
            this.m_rxWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            WirelineController.SetWirelineTonesButtonsOFF_Rule setWirelineTonesButtonsOFF_Rule = new WirelineController.SetWirelineTonesButtonsOFF_Rule(this.m_wirelineController);
            setWirelineTonesButtonsOFF_Rule.process(session4OldRules);
        }
        LOG.exit("uncheckToneOnOffButtons");
        return bl;
    }

    public boolean stopSINADMeasurementProcess() {
        LOG.enter("stopSINADMeasurementProcess");
        boolean bl = true;
        if ((this.isConvBR() || this.isMsBR3600() || this.isIR3600()) && this.m_carrierSquelchTab.isSINADMeasurementStarted()) {
            Session4OldRules session4OldRules = new Session4OldRules();
            CarrierSquelchTab.SINADMeasurement sINADMeasurement = this.m_carrierSquelchTab.new CarrierSquelchTab.SINADMeasurement();
            sINADMeasurement.process(session4OldRules);
        }
        LOG.exit("stopSINADMeasurementProcess");
        return bl;
    }

    public boolean stopGetCSQStateProcess() {
        LOG.enter("stopGetCSQStateProcess");
        boolean bl = true;
        if (this.isConvBR() || this.isMsBR3600() || this.isIR3600()) {
            Session4OldRules session4OldRules = new Session4OldRules();
            CarrierSquelchTab.CSQState_Stop cSQState_Stop = this.m_carrierSquelchTab.new CarrierSquelchTab.CSQState_Stop();
            cSQState_Stop.process(session4OldRules);
        }
        LOG.exit("stopGetCSQStateProcess");
        return bl;
    }

    public boolean startSimulcastAlgnTabInitRules() {
        LOG.enter("startSimulcastAlgnTabInitRules");
        boolean bl = true;
        if (this.isConvBR() || this.isMsBR3600() || this.isMsBR()) {
            this.m_astroSimulcast.getGenericListener().notifyGuiListener();
            if (!this.isMsBR()) {
                Session4OldRules session4OldRules = new Session4OldRules();
                SummitAstroSimulcastAlignment.SimulcastAndStatTypeDeps_Rule simulcastAndStatTypeDeps_Rule = new SummitAstroSimulcastAlignment.SimulcastAndStatTypeDeps_Rule(this.m_astroSimulcast);
                simulcastAndStatTypeDeps_Rule.process(session4OldRules);
            } else {
                this.m_astroSimulcast.setIsSimulcastEnabled(true);
            }
        }
        LOG.exit("startSimulcastAlgnTabInitRules");
        return bl;
    }

    public boolean startRxWirelineInitRules() {
        LOG.enter("startRxWirelineInitRules");
        boolean bl = true;
        if (this.isConvBR() || this.isMsBR3600() || this.isIR3600()) {
            this.m_wirelineController.setDeviceMode(this.nCurrentDeviceMode);
            this.m_rxWirelinePanel.getGenericListener().notifyGuiListener();
            Session4OldRules session4OldRules = new Session4OldRules();
            WirelineController.SetWirelineAlignment_Rule setWirelineAlignment_Rule = new WirelineController.SetWirelineAlignment_Rule(this.m_wirelineController);
            setWirelineAlignment_Rule.process(session4OldRules);
        }
        LOG.exit("startWirelineInitRules");
        return bl;
    }

    public boolean isConvBR() {
        boolean bl = false;
        LOG.enter("isConvBR");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isConvBrApplication((String)string).booleanValue()) {
            bl = true;
        }
        LOG.exit("isConvBR");
        return bl;
    }

    public boolean isMsBR3600() {
        boolean bl = false;
        LOG.enter("isMsBR3600");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isMsBR3600Application((String)string).booleanValue()) {
            bl = true;
        }
        LOG.exit("isMsBR3600");
        return bl;
    }

    public boolean isIR3600() {
        boolean bl = false;
        LOG.enter("isIR");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isIR3600Application((String)string).booleanValue()) {
            bl = true;
        }
        LOG.exit("isIR");
        return bl;
    }

    public boolean is3600() {
        return this.isIR3600() || this.isMsBR3600();
    }

    public boolean isMsBR() {
        boolean bl = false;
        LOG.enter("isMsBR");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isMsBrApplication((String)string).booleanValue()) {
            bl = true;
        }
        LOG.exit("isMsBR");
        return bl;
    }

    public void showErrorForKeyupDekey(Integer n) {
        if (null == n) {
            this.popupError("Error during Keyup/Dekey!");
        } else {
            switch (n) {
                case 1: 
                case 129: {
                    this.m_refOscilatorFreqTab.setKeyUp(true);
                    this.m_txWirelinePanel.setKeyUpLine1(true);
                    this.m_txWirelinePanel.setKeyUpLine3(true);
                    this.popupError("Unable to Keyup the Station.");
                    break;
                }
                case 2: 
                case 130: {
                    this.m_refOscilatorFreqTab.setKeyUp(false);
                    this.m_txWirelinePanel.setKeyUpLine1(false);
                    this.m_txWirelinePanel.setKeyUpLine3(false);
                    this.popupError("Unable to Dekey the Station.");
                    break;
                }
                default: {
                    if (DeviceErrorCodes.isInGeneralErrorRange(n)) {
                        LOG.error((Object)("realTimeUpdate - Error data: " + n));
                        this.popupError(n);
                        this.m_refOscilatorFreqTab.setKeyUp(true);
                        this.m_txWirelinePanel.setKeyUpLine1(true);
                        this.m_txWirelinePanel.setKeyUpLine3(true);
                        break;
                    }
                    this.popupError("Error during Keyup/Dekey!");
                }
            }
        }
        this.m_refOscilatorFreqTab.m_bErrorDialogShown = true;
        this.m_wirelineController.m_bErrorDialogShown = true;
    }

    private class Session4OldRules
    implements SessionIfc {
        private Session4OldRules() {
        }

        public void sendCmd(MessageIfc messageIfc) {
            DataObject dataObject;
            if (null != messageIfc && null != (dataObject = messageIfc.getDataObject())) {
                messageIfc.getDataObject().setSessionName(SummitAlignmentScreen.this.m_screenMaker.getSessionType());
                ServiceProtocolMultiplexer.getServiceProtocolMultiplexer().process(dataObject);
            }
        }

        public ActionEvent getActionEvent() {
            return null;
        }
    }
}

