/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.util.component.CSSJTextField;
import css.core.util.component.GenericListener;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import pnm.ui.UIInternalFrame;

public class TxWirelinePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private UIInternalFrame m_window = null;
    private SummitAlignmentScreen m_screen = null;
    public GenericListener m_oGenericListener = new GenericListener();
    public StatusBarListener m_statusBarListener;
    private static final String KEYUP = "KEYUP";
    private static final String DEKEY = "DEKEY";
    private boolean m_bIsKeyUpLine1 = true;
    private boolean m_bIsKeyUpLine3 = true;
    private boolean m_bSaveButtonPush = false;
    private static String STAT_WL_CURRENT_LINE1 = "Set current Tx Wireline Line 1 Level. Range: -35 to 0 dBm.";
    private static String TOOLTIP_WL_CURRENT_LINE1 = "Current Tx Wireline Line 1 Level.";
    private static String TOOLTIP_WL_STORED_LINE1 = "Stored Tx Wireline line 1 level.";
    private static String STAT_WL_CURRENT_LINE3 = "Set current Tx Wireline Line 3 Level. Range: -35 to 0 dBm.";
    private static String TOOLTIP_WL_CURRENT_LINE3 = "Current Tx Wireline Line 3 Level.";
    private static String TOOLTIP_WL_STORED_LINE3 = "Stored Tx Wireline line 3 level.";
    private static String STAT_WL_HYSTERESIS = "Set Tx Wireline Hysteresis Level. Range: 1 to 6 dB.";
    private static String TOOLTIP_WL_HYSTERESIS = "Tx Wireline Hysteresis Level.";
    private static String STAT_WL_SQUELCH = "Set Tx Wireline Squelch Threshold Level. Range: -50 to -20 dBm.";
    private static String TOOLTIP_WL_SQUELCH = "Tx Wireline Squelch Threshold Level.";
    private static String STAT_WL_SAVE = "Click the save button to save the set Tx Wireline Levels.";
    private static String TOOLTIP_WL_SAVE = "Click the save button to save the set Tx Wireline Levels.";
    private static String STAT_WL_KEYUP_LINE1 = "Keyup the Station and route Line 1 audio to the transmitter.";
    private static String TOOLTIP_WL_KEYUP_LINE1 = "Route Tx wireline Line 1 to the transmitter.";
    private static String STAT_WL_KEYUP_LINE3 = "Keyup the Station and route Line 3 audio to the transmitter.";
    private static String TOOLTIP_WL_KEYUP_LINE3 = "Route Tx wireline Line 3 to the transmitter.";
    private static String TOOLTIP_WL_FREQUENCY = "Transmit Frequency (MHz).";
    private static String SAVE_LABEL = "Save";
    private JPanel TXWirelineLine1Panel;
    private JPanel TxSquelchHysteresisPanel;
    private JPanel TxWirelineLine3Panel;
    private JPanel TxfrequencyPanel;
    private JButton btnKeyupLine1;
    private JButton btnKeyupLine3;
    private JButton btnSave;
    private JLabel jLabel2;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JLabel labCurrentLine1;
    private JLabel labCurrentLine3;
    private JLabel labFrequency;
    private JLabel labHysteresis;
    private JLabel labSquelch;
    private JLabel labStoredLine1;
    private JLabel labStoredLine3;
    private JTextField txtCurrent1kHzLevelLine1;
    private JTextField txtCurrent1kHzLevelLine3;
    private JTextField txtStored1kHzLine1;
    private JTextField txtStored1kHzLine3;
    private JTextField txtTxFrequency;
    private JTextField txtWirelineHysteresis;
    private JTextField txtWirelineSquelch;

    public TxWirelinePanel() {
        this.initComponents();
    }

    public TxWirelinePanel(SummitAlignmentScreen summitAlignmentScreen) {
        this.initComponents();
        this.m_screen = summitAlignmentScreen;
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        this.setWindow(uIInternalFrame);
        this.m_statusBarListener = statusBarListener;
        if (null != this.m_statusBarListener) {
            this.m_statusBarListener.updateComponent((Component)this.getCurrent1kHzLevelLine1Component(), STAT_WL_CURRENT_LINE1, false);
            this.m_statusBarListener.updateComponent((Component)this.getCurrent1kHzLevelLine3Component(), STAT_WL_CURRENT_LINE3, false);
            this.m_statusBarListener.updateComponent((Component)this.getHysteresisComponent(), STAT_WL_HYSTERESIS, false);
            this.m_statusBarListener.updateComponent((Component)this.getSquelchComponent(), STAT_WL_SQUELCH, false);
            this.m_statusBarListener.updateComponent((Component)this.getSaveComponent(), STAT_WL_SAVE, false);
            this.m_statusBarListener.updateComponent((Component)this.getKeyupLine1Component(), STAT_WL_KEYUP_LINE1, false);
            this.m_statusBarListener.updateComponent((Component)this.getKeyupLine3Component(), STAT_WL_KEYUP_LINE3, false);
        }
        this.labHysteresis.setToolTipText(TOOLTIP_WL_HYSTERESIS);
        this.labCurrentLine1.setToolTipText(TOOLTIP_WL_CURRENT_LINE1);
        this.labCurrentLine3.setToolTipText(TOOLTIP_WL_CURRENT_LINE3);
        this.labSquelch.setToolTipText(TOOLTIP_WL_SQUELCH);
        this.labFrequency.setToolTipText(TOOLTIP_WL_FREQUENCY);
        this.btnKeyupLine1.setToolTipText(TOOLTIP_WL_KEYUP_LINE1);
        this.btnKeyupLine3.setToolTipText(TOOLTIP_WL_KEYUP_LINE3);
        this.btnSave.setToolTipText(TOOLTIP_WL_SAVE);
        this.labStoredLine1.setToolTipText(TOOLTIP_WL_STORED_LINE1);
        this.labStoredLine3.setToolTipText(TOOLTIP_WL_STORED_LINE3);
        if (this.m_screen.isIR3600()) {
            this.setVisibleTxSquelchHysteresisPanel(false);
            this.setVisibleTxWirelineLine3Panel(false);
        }
    }

    protected void setVisibleTxSquelchHysteresisPanel(boolean bl) {
        this.getTxSquelchHysteresisPanel().setVisible(bl);
    }

    protected JPanel getTxSquelchHysteresisPanel() {
        return this.TxSquelchHysteresisPanel;
    }

    protected void setVisibleTxWirelineLine3Panel(boolean bl) {
        this.getTxWirelineLine3Panel().setVisible(bl);
    }

    protected JPanel getTxWirelineLine3Panel() {
        return this.TxWirelineLine3Panel;
    }

    protected void setWindow(UIInternalFrame uIInternalFrame) {
        this.m_window = uIInternalFrame;
    }

    protected UIInternalFrame getWindow() {
        return this.m_window;
    }

    public void set1kHzLevelLine1(String string) {
        this.txtStored1kHzLine1.setText(string);
    }

    public JTextField getCurrent1kHzLevelLine1Component() {
        return this.txtCurrent1kHzLevelLine1;
    }

    public void setStoredLine1Component(String string) {
        this.txtStored1kHzLine1.setText(string);
    }

    public void setCurrent1kHzLevelLine1Component(String string) {
        this.txtCurrent1kHzLevelLine1.setText(string);
        ((CSSJTextField)this.txtCurrent1kHzLevelLine1).setStoredValue(string);
    }

    public void set1kHzLevelLine3(String string) {
        this.txtStored1kHzLine3.setText(string);
    }

    public JTextField getCurrent1kHzLevelLine3Component() {
        return this.txtCurrent1kHzLevelLine3;
    }

    public void setStoredLine3Component(String string) {
        this.txtStored1kHzLine3.setText(string);
    }

    public void setCurrent1kHzLevelLine3Component(String string) {
        this.txtCurrent1kHzLevelLine3.setText(string);
        ((CSSJTextField)this.txtCurrent1kHzLevelLine3).setStoredValue(string);
    }

    public void setSquelchLevel(String string) {
        this.txtWirelineSquelch.setText(string);
        ((CSSJTextField)this.txtWirelineSquelch).setStoredValue(string);
    }

    public void setHysteresis(String string) {
        this.txtWirelineHysteresis.setText(string);
        ((CSSJTextField)this.txtWirelineHysteresis).setStoredValue(string);
    }

    public void setTransmitterFrequency(Integer n) {
        this.txtTxFrequency.setText(new Double(n / 1000000).toString());
    }

    public void setTransmitterFrequency(String string) {
        this.txtTxFrequency.setText(string);
    }

    public JButton getKeyupLine1Component() {
        return this.btnKeyupLine1;
    }

    public JButton getKeyupLine3Component() {
        return this.btnKeyupLine3;
    }

    public JButton getSaveComponent() {
        return this.btnSave;
    }

    public JTextField getSquelchComponent() {
        return this.txtWirelineSquelch;
    }

    public JTextField getHysteresisComponent() {
        return this.txtWirelineHysteresis;
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public void popupError(String string) {
        this.m_screen.popupError(string);
    }

    public boolean getSaveButtonState() {
        return this.m_bSaveButtonPush;
    }

    public void setSaveButtonState(boolean bl) {
        this.m_bSaveButtonPush = bl;
    }

    public boolean isKeyUpLine1() {
        return this.m_bIsKeyUpLine1;
    }

    public boolean isKeyUpLine3() {
        return this.m_bIsKeyUpLine3;
    }

    public void setKeyUpLine1(boolean bl) {
        this.m_bIsKeyUpLine1 = bl;
        if (this.m_bIsKeyUpLine1) {
            this.getKeyupLine1Component().setText(KEYUP);
        } else {
            this.getKeyupLine1Component().setText(DEKEY);
        }
    }

    public void setKeyUpLine3(boolean bl) {
        this.m_bIsKeyUpLine3 = bl;
        if (this.m_bIsKeyUpLine3) {
            this.getKeyupLine3Component().setText(KEYUP);
        } else {
            this.getKeyupLine3Component().setText(DEKEY);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.TxSquelchHysteresisPanel = new JPanel();
        this.labHysteresis = new JLabel();
        this.labSquelch = new JLabel();
        this.txtWirelineSquelch = new CSSJTextField();
        this.txtWirelineHysteresis = new CSSJTextField();
        this.TxfrequencyPanel = new JPanel();
        this.labFrequency = new JLabel();
        this.txtTxFrequency = new JTextField();
        this.btnSave = new JButton();
        this.TxWirelineLine3Panel = new JPanel();
        this.labCurrentLine3 = new JLabel();
        this.txtCurrent1kHzLevelLine3 = new CSSJTextField();
        this.labStoredLine3 = new JLabel();
        this.jLabel8 = new JLabel();
        this.txtStored1kHzLine3 = new JTextField();
        this.jLabel9 = new JLabel();
        this.btnKeyupLine3 = new JButton();
        this.TXWirelineLine1Panel = new JPanel();
        this.labCurrentLine1 = new JLabel();
        this.txtCurrent1kHzLevelLine1 = new CSSJTextField();
        this.labStoredLine1 = new JLabel();
        this.jLabel5 = new JLabel();
        this.txtStored1kHzLine1 = new JTextField();
        this.jLabel6 = new JLabel();
        this.btnKeyupLine1 = new JButton();
        this.setPreferredSize(new Dimension(400, 250));
        this.jLabel2.setHorizontalAlignment(0);
        this.jLabel2.setText("TX WIRELINE INPUT CALIBRATION");
        this.TxSquelchHysteresisPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.labHysteresis.setText("Tx Wireline Hysteresis Level");
        this.labSquelch.setText("Current Tx Wireline Squelch Threshold");
        this.txtWirelineSquelch.setColumns(8);
        this.txtWirelineSquelch.setName("Tx Wireline Threshold");
        this.txtWirelineHysteresis.setColumns(8);
        this.txtWirelineHysteresis.setName("Tx Wireline Histeresis Level");
        GroupLayout groupLayout = new GroupLayout(this.TxSquelchHysteresisPanel);
        this.TxSquelchHysteresisPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labHysteresis).addComponent(this.labSquelch)).addGap(50, 50, 50).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtWirelineSquelch, -2, 70, -2).addComponent(this.txtWirelineHysteresis, -1, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtWirelineSquelch, -2, -1, -2).addComponent(this.labSquelch, -2, 20, -2)).addGap(12, 12, 12).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtWirelineHysteresis, -2, -1, -2).addComponent(this.labHysteresis)).addContainerGap(-1, Short.MAX_VALUE)));
        this.TxfrequencyPanel.setBorder(BorderFactory.createTitledBorder(""));
        this.labFrequency.setText("Transmit Frequency ( MHz )");
        this.txtTxFrequency.setEditable(false);
        this.txtTxFrequency.setColumns(8);
        this.txtTxFrequency.setName("Tx Frequency");
        GroupLayout groupLayout2 = new GroupLayout(this.TxfrequencyPanel);
        this.TxfrequencyPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.labFrequency).addGap(102, 102, 102).addComponent(this.txtTxFrequency, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labFrequency).addComponent(this.txtTxFrequency, -2, -1, -2)).addContainerGap()));
        this.btnSave.setText("Save");
        this.btnSave.setName("Save");
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TxWirelinePanel.this.btnSaveActionPerformed(actionEvent);
            }
        });
        this.TxWirelineLine3Panel.setBorder(BorderFactory.createTitledBorder("Tx Wireline Level Line 3 (1 kHz)"));
        this.TxWirelineLine3Panel.setPreferredSize(new Dimension(490, 50));
        this.labCurrentLine3.setText("Current");
        this.txtCurrent1kHzLevelLine3.setColumns(8);
        this.txtCurrent1kHzLevelLine3.setName("Tx 3 Current");
        this.labStoredLine3.setText("Stored");
        this.jLabel8.setText("dBm");
        this.txtStored1kHzLine3.setEditable(false);
        this.txtStored1kHzLine3.setColumns(8);
        this.txtStored1kHzLine3.setName("Tx 3 Stored");
        this.jLabel9.setText("dBm");
        this.btnKeyupLine3.setText("Keyup");
        this.btnKeyupLine3.setHorizontalAlignment(4);
        this.btnKeyupLine3.setName("Keyup 3");
        GroupLayout groupLayout3 = new GroupLayout(this.TxWirelineLine3Panel);
        this.TxWirelineLine3Panel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGap(8, 8, 8).addComponent(this.labCurrentLine3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtCurrent1kHzLevelLine3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addGap(48, 48, 48).addComponent(this.labStoredLine3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtStored1kHzLine3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addGap(62, 62, 62).addComponent(this.btnKeyupLine3).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8, -2, 23, -2).addComponent(this.txtCurrent1kHzLevelLine3, -2, -1, -2).addComponent(this.labCurrentLine3, -2, 23, -2)).addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtStored1kHzLine3, -2, -1, -2).addComponent(this.labStoredLine3, -2, 23, -2).addComponent(this.jLabel9, -2, 23, -2).addComponent(this.btnKeyupLine3))).addGap(4, 4, 4)));
        this.TXWirelineLine1Panel.setBorder(BorderFactory.createTitledBorder("Tx Wireline Level Line 1 (1 kHz)"));
        this.TXWirelineLine1Panel.setPreferredSize(new Dimension(492, 50));
        this.labCurrentLine1.setText("Current");
        this.txtCurrent1kHzLevelLine1.setColumns(8);
        this.txtCurrent1kHzLevelLine1.setName("Tx 1 Current");
        this.labStoredLine1.setText("Stored");
        this.jLabel5.setText("dBm");
        this.txtStored1kHzLine1.setEditable(false);
        this.txtStored1kHzLine1.setColumns(8);
        this.txtStored1kHzLine1.setName("Tx 1 Stored");
        this.jLabel6.setText("dBm");
        this.btnKeyupLine1.setText("Keyup");
        this.btnKeyupLine1.setHorizontalAlignment(4);
        this.btnKeyupLine1.setName("Keyup 1");
        GroupLayout groupLayout4 = new GroupLayout(this.TXWirelineLine1Panel);
        this.TXWirelineLine1Panel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(8, 8, 8).addComponent(this.labCurrentLine1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtCurrent1kHzLevelLine1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addGap(48, 48, 48).addComponent(this.labStoredLine1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtStored1kHzLine1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addGap(62, 62, 62).addComponent(this.btnKeyupLine1).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createSequentialGroup().addGap(1, 1, 1).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtCurrent1kHzLevelLine1, -2, -1, -2).addComponent(this.labCurrentLine1, -2, 23, -2).addComponent(this.jLabel5, -2, 23, -2)).addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtStored1kHzLine1, -2, -1, -2).addComponent(this.labStoredLine1, -2, 23, -2).addComponent(this.jLabel6, -2, 23, -2).addComponent(this.btnKeyupLine1)))));
        GroupLayout groupLayout5 = new GroupLayout(this);
        this.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addGap(0, 22, Short.MAX_VALUE).addComponent(this.jLabel2, -2, 444, -2).addContainerGap(24, Short.MAX_VALUE)).addGroup(groupLayout5.createSequentialGroup().addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.TxSquelchHysteresisPanel, -1, -1, Short.MAX_VALUE).addComponent(this.TxfrequencyPanel, -1, -1, Short.MAX_VALUE).addComponent(this.TXWirelineLine1Panel, -1, 480, Short.MAX_VALUE).addComponent(this.TxWirelineLine3Panel, -1, 480, Short.MAX_VALUE)).addContainerGap()))).addGroup(GroupLayout.Alignment.TRAILING, groupLayout5.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnSave, -2, 64, -2).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel2).addGap(32, 32, 32).addComponent(this.TXWirelineLine1Panel, -2, -1, -2).addGap(1, 1, 1).addComponent(this.TxWirelineLine3Panel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TxSquelchHysteresisPanel, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TxfrequencyPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnSave).addContainerGap(-1, Short.MAX_VALUE)));
        this.TXWirelineLine1Panel.getAccessibleContext().setAccessibleName("Tx Wireline Level Line 3 (1 kHz)");
        this.TXWirelineLine1Panel.getAccessibleContext().setAccessibleDescription("");
    }

    private void btnSaveActionPerformed(ActionEvent actionEvent) {
        this.setSaveButtonState(!this.getSaveButtonState());
    }
}

