/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.service.NotFoundException;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.device.common.protocol.cmdmgr.CmdManager;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.protocol.cmdmgr.RetryableDatagram;
import java.util.Vector;

public class DatagramQueue
implements Runnable,
CssConstants {
    private static final CssLogger LOG = CssLogger.getCssLogger(DatagramQueue.class);
    private static final int REAL_TIME_PACKET_FLAG = 1;
    private static final int WAIT_TIMEOUT = 250;
    private Vector<Datagram> m_listDatagramsQueue;
    private boolean m_bIsActive = true;
    private CmdManager m_oCmdManager;

    public DatagramQueue(CmdManager cmdManager) {
        LOG.enter("DatagramQueue");
        this.m_listDatagramsQueue = new Vector();
        this.m_oCmdManager = cmdManager;
        LOG.exit("DatagramQueue");
    }

    @Override
    public synchronized void run() {
        LOG.enter("run");
        RetryableDatagram retryableDatagram = null;
        while (this.m_bIsActive) {
            int n = 0;
            while (n < this.m_listDatagramsQueue.size()) {
                try {
                    retryableDatagram = (RetryableDatagram)this.m_listDatagramsQueue.elementAt(n);
                    if ((retryableDatagram.getSessionFlags() & 1) == 0) {
                        ++n;
                        continue;
                    }
                    this.m_listDatagramsQueue.removeElementAt(n);
                    DeviceSessions deviceSessions = this.m_oCmdManager.getDeviceSessions();
                    Protocol protocol = deviceSessions.getProtocolHandle(retryableDatagram.getSessionID());
                    protocol.reply(retryableDatagram);
                }
                catch (NotFoundException notFoundException) {
                    LOG.error((Object)"run DatagramQueue - NotFoundException - waiting for session start");
                    try {
                        this.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.error((Object)"DatagramQueue: Wait timer expired", (Throwable)interruptedException);
                    }
                    if (retryableDatagram.m_nTryCount < 50) {
                        LOG.trace((Object)"run - adding datagram to queue again");
                        ++retryableDatagram.m_nTryCount;
                        this.m_listDatagramsQueue.add(retryableDatagram);
                    }
                    LOG.error((Object)"CmdManager:doOperation: Can't find protocol handle from session id.", (Throwable)notFoundException);
                }
            }
            try {
                this.wait(250L);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"sendDatagram: Wait timer expired", (Throwable)interruptedException);
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                LOG.error((Object)"sendDatagram: Current thread is not the owner of the object's monitor", (Throwable)illegalMonitorStateException);
            }
        }
        LOG.exit("run");
    }

    public synchronized void addDatagram(Datagram datagram) {
        LOG.enter("addDatagram");
        this.m_listDatagramsQueue.addElement(datagram);
        LOG.exit("addDatagram");
    }

    public synchronized void terminateQueueThread() {
        LOG.enter("terminateQueueThread");
        this.m_bIsActive = false;
        this.m_listDatagramsQueue.clear();
        LOG.exit("terminateQueueThread");
    }

    public synchronized Datagram getReplyIfAvailable(byte by, byte by2) {
        LOG.enter("getReplyIfAvailable");
        while (!this.m_listDatagramsQueue.isEmpty()) {
            Datagram datagram = this.m_listDatagramsQueue.elementAt(0);
            if ((datagram.getSessionFlags() & 1) != 0) {
                this.notifyAll();
                break;
            }
            if (by == datagram.getSessionID()) {
                this.m_listDatagramsQueue.removeElementAt(0);
                LOG.exit("getReplyIfAvailable");
                return datagram;
            }
            LOG.error((Object)("getReplyIfAvailable: invalid datagram was received session ID:" + by + " session type:" + by2 + " datagram session ID:" + datagram.getSessionID() + " datagram session type:" + datagram.getSessionType()));
            this.m_listDatagramsQueue.removeElementAt(0);
        }
        LOG.exit("getReplyIfAvailable");
        return null;
    }

    public synchronized void clearReplyQueue() {
        LOG.enter("clearReplyQueue");
        for (int i = 0; i < this.m_listDatagramsQueue.size(); ++i) {
            Datagram datagram = this.m_listDatagramsQueue.elementAt(i);
            if ((datagram.getSessionFlags() & 1) != 0) continue;
            this.m_listDatagramsQueue.removeElementAt(i);
        }
        LOG.exit("clearReplyQueue");
    }
}

