/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.deviceifcfactory.DeviceInterfaceFactory;
import css.core.deviceifcfactory.RecipeFileManager;
import css.core.screens.tools.StatusBarListener;
import css.core.util.CSSException;
import css.core.util.Devices;
import css.core.util.VersionInfo;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.CommonHardwareVersion;
import css.device.common.screens.CommonSoftwareVersion;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.JTabbedPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class CommonVersion
extends GenericScreen {
    private static final long serialVersionUID = 1L;
    private static final String INVALID_STRING = "Invalid";
    private static final int INVALID_NUMBER = Integer.MAX_VALUE;
    private static final String NONE = "None";
    private static final String NO_FILE_PRESENT = "No File Present";
    private static final String CRC_ERROR = "CRC Error";
    private static final String NMA_MARKED_INVALID = "NMA Marked Invalid";
    private static final String TRANSFER_IN_PROGRESS = "Transfer In Progress";
    private static final String TRANSFER_INCOMPLETE = "Transfer Incomplete";
    private static final String INSTALL_INCOMPLETE = "Prepare To Install Incomplete";
    private static final int HARDWARE_VER_TYPE = 4;
    private static final int FILESET_VER_TYPE = 6;
    private static final int INVALID_OP_STATUS = 1;
    private static final int INUSE_OP_STATUS = 3;
    private static final String INVALID = "Invalid";
    private static final String PRESENT = "Present";
    private static final String INUSE = "In Use";
    private static final String TRANSFERRED = "Transferred";
    private CommonSoftwareVersion m_commonSoftwareVersion;
    private CommonHardwareVersion m_commonHardwareVersion;
    private JTabbedPane m_tabbedPane;
    private SimpleDateFormat m_oDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ErrorPopup m_errPopup = new ErrorPopup();
    private boolean bankFound = false;

    public CommonVersion() {
        this.m_commonSoftwareVersion = new CommonSoftwareVersion();
        this.m_commonHardwareVersion = new CommonHardwareVersion();
        this.m_oDateTimeFormatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter buildScreen() arguments:g_window = " + object + " g_statusBarListener = " + statusBarListener));
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonVersion.this);
                CommonVersion.this.m_window.setVisible(false);
            }
        });
        this.m_tabbedPane = new JTabbedPane();
        this.m_commonSoftwareVersion.buildScreen((UIInternalFrame)object, statusBarListener);
        this.m_commonHardwareVersion.buildScreen((UIInternalFrame)object, statusBarListener);
        this.m_tabbedPane.addTab("Hardware Version", this.m_commonHardwareVersion);
        this.m_tabbedPane.addTab("Software Version", this.m_commonSoftwareVersion);
        this.m_tabbedPane.setSelectedIndex(1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
        Audit.audit((int)1010, (String)this.toString(), (String)"Exit buildScreen()");
    }

    @Override
    public void initialize() {
        Audit.audit((int)1009, (String)this.toString(), (String)"Enter initialize()");
        this.m_commonSoftwareVersion.initialize();
        this.m_commonHardwareVersion.initialize();
        Audit.audit((int)1010, (String)this.toString(), (String)"Exit initialize()");
    }

    public void updateVersionParams(int n, Integer[] integerArray, String[] stringArray, String[] stringArray2, Integer[] integerArray2, Integer[] integerArray3, Integer[] integerArray4, Integer[] integerArray5, Integer[] integerArray6, Integer[] integerArray7, Integer[] integerArray8, Integer[] integerArray9, Integer[] integerArray10, Integer[] integerArray11, Integer[] integerArray12, String[] stringArray3) {
        boolean bl = false;
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter updateVersionParams() arguments:g_error = " + n + " g_verIndex = " + integerArray + "g_name = " + stringArray + "g_version = " + stringArray2 + " g_locationId = " + integerArray2 + "g_verType = " + integerArray3 + " g_filesetId = " + integerArray4 + "g_opStatus = " + integerArray5 + " g_state = " + integerArray6 + "g_currentIndex = " + integerArray7 + " g_nextIndex = " + integerArray8 + "g_fallbackIndex = " + integerArray9 + " g_sysUpgradeDate = " + integerArray10 + "g_boxUpgradeDate = " + integerArray11 + "g_activationDate = " + integerArray12));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)this.toString(), (String)"Error in getting Version Table Info");
            this.m_errPopup.display(-524288);
        } else {
            int n2;
            int n3;
            Vector[] vectorArray = new Vector[8];
            for (n3 = 0; n3 < vectorArray.length; ++n3) {
                vectorArray[n3] = new Vector();
            }
            n3 = 0;
            for (n2 = 0; n2 < integerArray3.length; ++n2) {
                if (integerArray3[n2] == 4) {
                    String string = this.convDate(integerArray12[n2]);
                    this.m_commonHardwareVersion.updateTable(stringArray[n2], stringArray2[n2], string);
                    continue;
                }
                boolean bl2 = true;
                bl2 = this.checkOID(stringArray3[n2]);
                if (integerArray5[n2] == 3 && integerArray3[n2] == 6 && bl2) {
                    String string = "Invalid";
                    String string2 = "Invalid";
                    String string3 = "Invalid";
                    int n4 = integerArray7[n2];
                    int n5 = integerArray8[n2];
                    int n6 = integerArray9[n2];
                    for (int i = 0; i < integerArray.length; ++i) {
                        int n7;
                        if (integerArray[i] == n4) {
                            n7 = integerArray2[i];
                            string = this.convIndexToString(n7);
                        }
                        if (integerArray[i] == n5) {
                            n7 = integerArray2[i];
                            string2 = this.convIndexToString(n7);
                        }
                        if (integerArray[i] != n6) continue;
                        n7 = integerArray2[i];
                        string3 = this.convIndexToString(n7);
                    }
                    if (n4 == Integer.MAX_VALUE) {
                        string = "Invalid";
                    }
                    if (n5 == Integer.MAX_VALUE) {
                        string2 = "Invalid";
                    }
                    if (n6 == Integer.MAX_VALUE) {
                        string3 = "Invalid";
                    }
                    if (this.bankFound && !bl) {
                        this.m_commonSoftwareVersion.updateIndexes(string, string2, string3);
                        bl = true;
                    }
                }
                n3 = 0;
                if (integerArray5[n2] != 1) {
                    n3 = 1;
                } else {
                    for (int i = 0; i < integerArray3.length; ++i) {
                        if (integerArray4[i].intValue() != integerArray4[n2].intValue() || integerArray5[i] == 1) continue;
                        n3 = 1;
                        break;
                    }
                }
                if (1 != n3) continue;
                int n8 = vectorArray[0].size();
                for (int i = 0; i < vectorArray[0].size(); ++i) {
                    if (integerArray4[n2].intValue() != ((Integer)vectorArray[0].elementAt(i)).intValue()) continue;
                    if (integerArray3[n2] == 6) {
                        n8 = i;
                        break;
                    }
                    n8 = i + 1;
                    break;
                }
                vectorArray[0].insertElementAt(integerArray4[n2], n8);
                vectorArray[1].insertElementAt(stringArray[n2], n8);
                vectorArray[2].insertElementAt(stringArray2[n2], n8);
                if (integerArray5[n2] == 1) {
                    vectorArray[3].insertElementAt(this.convState(integerArray6[n2]), n8);
                } else {
                    vectorArray[3].insertElementAt(this.convOpStatus(integerArray5[n2]), n8);
                }
                vectorArray[4].insertElementAt(this.convIndexToString(integerArray2[n2]), n8);
                vectorArray[5].insertElementAt(this.convDate(integerArray10[n2]), n8);
                vectorArray[6].insertElementAt(this.convDate(integerArray11[n2]), n8);
                vectorArray[7].insertElementAt(this.convDate(integerArray12[n2]), n8);
            }
            if (vectorArray[0].size() > 0) {
                n2 = (Integer)vectorArray[0].elementAt(0);
                for (int i = 0; i < vectorArray[0].size(); ++i) {
                    if (n2 != (Integer)vectorArray[0].elementAt(i)) {
                        n2 = (Integer)vectorArray[0].elementAt(i);
                        this.m_commonSoftwareVersion.updateTable("", "", "", "", "", "", "");
                    }
                    this.m_commonSoftwareVersion.updateTable((String)vectorArray[1].elementAt(i), (String)vectorArray[2].elementAt(i), (String)vectorArray[3].elementAt(i), (String)vectorArray[4].elementAt(i), (String)vectorArray[5].elementAt(i), (String)vectorArray[6].elementAt(i), (String)vectorArray[7].elementAt(i));
                }
            }
        }
        Audit.audit((int)1010, (String)this.toString(), (String)"Exit updateVersionParams()");
    }

    private String convState(int n) {
        String string = "n/a";
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter convState()arguments: g_state = " + n));
        switch (n) {
            case 1: {
                string = NONE;
                break;
            }
            case 2: {
                string = NO_FILE_PRESENT;
                break;
            }
            case 3: {
                string = CRC_ERROR;
                break;
            }
            case 4: {
                string = NMA_MARKED_INVALID;
                break;
            }
            case 5: {
                string = TRANSFER_IN_PROGRESS;
                break;
            }
            case 6: {
                string = TRANSFER_INCOMPLETE;
                break;
            }
            case 7: {
                string = INSTALL_INCOMPLETE;
            }
        }
        Audit.audit((int)1010, (String)this.toString(), (String)("Exit convState() return: " + string));
        return string;
    }

    private String convOpStatus(int n) {
        String string = "n/a";
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter convOpStatus()arguments: g_status = " + n));
        switch (n) {
            case 1: {
                string = "Invalid";
                break;
            }
            case 2: {
                string = PRESENT;
                break;
            }
            case 3: {
                string = INUSE;
                break;
            }
            case 4: {
                string = TRANSFERRED;
            }
        }
        Audit.audit((int)1010, (String)this.toString(), (String)("Exit convOpStatus() return: " + string));
        return string;
    }

    private String convDate(int n) {
        String string = "n/a";
        long l = 0L;
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter convDate()arguments: g_date = " + n));
        l = 0xFFFFFFFFL & (long)n;
        Date date = new Date(l *= 1000L);
        string = this.m_oDateTimeFormatter.format(date);
        Audit.audit((int)1010, (String)this.toString(), (String)("Exit convDate() return: " + string));
        return string;
    }

    private String convIndexToString(int n) {
        String string = "n/a";
        Audit.audit((int)1009, (String)this.toString(), (String)("Enter convIndexToString()arguments: g_index = " + n));
        if (n == 1) {
            string = "DRAM";
        } else if (n > 1) {
            string = "BANK " + (n - 1);
            this.bankFound = true;
        }
        Audit.audit((int)1010, (String)this.toString(), (String)("Exit convIndexToString() return: " + string));
        return string;
    }

    private boolean checkOID(String string) {
        boolean bl = false;
        try {
            RecipeFileManager recipeFileManager = new RecipeFileManager();
            Vector vector = recipeFileManager.getExtraParams(DeviceInterfaceFactory.getCurrentDeviceName(), "EthernetConnectionInterface");
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string2 = vector.get(i).toString();
                String string3 = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
                if (Devices.isBaseRadio((String)string3).booleanValue() && Devices.isSummit2Platform((String)string3).booleanValue()) {
                    for (VersionInfo.BrOids brOids : VersionInfo.BrOids.values()) {
                        string2 = brOids.getSummit1_oid(string2);
                    }
                }
                if (string.startsWith(string2)) {
                    bl = true;
                    break;
                }
                bl = false;
            }
        }
        catch (CSSException cSSException) {
            Audit.audit((int)1002, (String)"Common Version", (String)("checkOID():" + cSSException.toString()));
        }
        return bl;
    }
}

