/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.service;

import css.core.service.ScreenManagerIfc;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.component.WaitPopup;
import css.device.common.service.ServiceMaker;
import css.device.common.service.ServicePrecloseable;
import css.device.common.service.Serviceable;
import java.util.Vector;
import pnm.ui.PnmDialog;
import pnm.util.EngineUtilities;

public class ScreenManager
implements ScreenManagerIfc {
    private static final CssLogger LOG = CssLogger.getCssLogger(ScreenManager.class);
    private ServiceMaker m_oDeviceServiceMaker = null;
    private Vector m_listScreens = null;
    private Vector m_listPrecloseOperations = null;
    private WaitPopup m_oResetPopup = null;

    private ScreenManager() {
        LOG.enter("ScreenManager");
        this.m_listScreens = new Vector();
        this.m_listPrecloseOperations = new Vector();
        LOG.exit("ScreenManager");
    }

    static synchronized void newInstance() {
        LOG.enter("newInstance");
        ScreenManager screenManager = new ScreenManager();
        CSSUtilities.setScreenManager((ScreenManagerIfc)screenManager);
        LOG.exit("newInstance");
    }

    public static synchronized void suspend(boolean bl) {
        LOG.enter("suspend");
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (null != screenManager) {
            screenManager.suspendImplementation(bl);
        }
        LOG.exit("suspend");
    }

    public static synchronized void registerScreen(Serviceable serviceable) {
        LOG.enter("registerScreen", new Object[]{serviceable});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (screenManager != null) {
            screenManager.registerScreenImplementation(serviceable);
        }
        LOG.exit("registerScreen");
    }

    public static synchronized void registerPrecloseOperation(ServicePrecloseable servicePrecloseable) {
        LOG.enter("registerPrecloseOperation", new Object[]{servicePrecloseable});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (screenManager != null) {
            screenManager.registerPrecloseOperationImplementation(servicePrecloseable);
        }
        LOG.exit("registerPrecloseOperation");
    }

    public static synchronized void removeScreen(Serviceable serviceable) {
        LOG.enter("removeScreen", new Object[]{serviceable});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (screenManager != null) {
            screenManager.removeScreenImplementation(serviceable);
        }
        LOG.exit("removeScreen");
    }

    public static synchronized void removePrecloseOperation(ServicePrecloseable servicePrecloseable) {
        LOG.enter("removePrecloseOperation", new Object[]{servicePrecloseable});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (screenManager != null) {
            screenManager.removePrecloseOperationImplementation(servicePrecloseable);
        }
        LOG.exit("removePrecloseOperation");
    }

    public static synchronized void update(boolean bl) {
        LOG.enter("update", new Object[]{Boolean.toString(bl)});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (null != screenManager) {
            screenManager.updateImplementation(bl);
        }
        LOG.exit("update");
    }

    public static synchronized void update() {
        LOG.enter("update");
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (null != screenManager) {
            screenManager.updateImplementation();
        }
        LOG.exit("update");
    }

    public static synchronized void setDeviceServiceMakerHandle(ServiceMaker serviceMaker) {
        LOG.enter("setDeviceServiceMakerHandle", new Object[]{serviceMaker});
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (null != screenManager) {
            screenManager.m_oDeviceServiceMaker = serviceMaker;
        }
        LOG.exit("setDeviceServiceMakerHandle");
    }

    public static synchronized ServiceMaker getDeviceServiceMakerHandle() {
        LOG.enter("getDeviceServiceMakerHandle");
        ServiceMaker serviceMaker = null;
        ScreenManager screenManager = (ScreenManager)CSSUtilities.getScreenManager();
        if (null != screenManager) {
            serviceMaker = screenManager.m_oDeviceServiceMaker;
        }
        LOG.exit("getDeviceServiceMakerHandle", (Object)serviceMaker);
        return serviceMaker;
    }

    public synchronized void closeScreenImplementation() {
        Object object;
        int n;
        LOG.enter("closeScreenImplementation");
        for (n = 0; n < this.m_listPrecloseOperations.size(); ++n) {
            object = (ServicePrecloseable)this.m_listPrecloseOperations.get(n);
            object.preclose();
        }
        for (n = this.m_listScreens.size(); n > 0; --n) {
            object = (Serviceable)this.m_listScreens.get(n - 1);
            object.closeScreen(true);
        }
        this.m_listPrecloseOperations.removeAllElements();
        this.m_listScreens.removeAllElements();
        LOG.exit("closeScreenImplementation");
    }

    public synchronized void shutDownImplementation() {
        Object object;
        int n;
        LOG.enter("shutDownImplementation");
        CSSUtilities.disableServiceMenu();
        for (n = this.m_listPrecloseOperations.size(); n > 0; --n) {
            object = (ServicePrecloseable)this.m_listPrecloseOperations.get(n - 1);
            object.preclose();
        }
        this.m_listPrecloseOperations.removeAllElements();
        for (n = this.m_listScreens.size(); n > 0; --n) {
            object = (Serviceable)this.m_listScreens.get(n - 1);
            object.closeScreen(true);
        }
        this.m_listScreens.removeAllElements();
        CSSUtilities.setScreenManager(null);
        if (null != this.m_oDeviceServiceMaker && 0 != this.m_oDeviceServiceMaker.shutdownService()) {
            LOG.error((Object)"shutDownImplementation - service deregistration failed");
        }
        LOG.exit("shutDownImplementation");
    }

    protected void updateImplementation(boolean bl) {
        LOG.enter("updateImplementation", new Object[]{Boolean.toString(bl)});
        if (this.m_oResetPopup != null) {
            try {
                int n = (100 - this.m_oResetPopup.getProgress()) / 2;
                this.m_oResetPopup.setProgress(this.m_oResetPopup.getProgress() + n);
                Thread.sleep(250L);
                this.m_oResetPopup.setProgress(100);
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"run - thread sleep exception", (Throwable)interruptedException);
            }
            this.m_oResetPopup.dispose();
            this.m_oResetPopup = null;
        }
        if (!bl) {
            PnmDialog.error((Object)EngineUtilities.getMainApplicationWindow(), (String)"Timed Out While Waiting For Device To Be Restarted");
        } else {
            EngineUtilities.getMainApplicationWindow().getStatusBar().update("Device is restarted successfully");
        }
        LOG.exit("updateImplementation");
    }

    protected void suspendImplementation(boolean bl) {
        Object object;
        int n;
        LOG.enter("suspendImplementation");
        for (n = 0; n < this.m_listPrecloseOperations.size(); ++n) {
            object = (ServicePrecloseable)this.m_listPrecloseOperations.get(n);
            object.preclose();
        }
        for (n = this.m_listScreens.size(); n > 0; --n) {
            object = (Serviceable)this.m_listScreens.get(n - 1);
            object.closeScreen(true);
        }
        this.m_listPrecloseOperations.removeAllElements();
        this.m_listScreens.removeAllElements();
        if (bl) {
            this.m_oResetPopup = new WaitPopup("Reset Screen");
            this.m_oResetPopup.display("Please Wait While Device Resets.");
        }
        LOG.exit("suspendImplementation");
    }

    protected void registerPrecloseOperationImplementation(ServicePrecloseable servicePrecloseable) {
        LOG.enter("registerPrecloseOperationImplementation", new Object[]{servicePrecloseable});
        if (!this.m_listPrecloseOperations.contains(servicePrecloseable)) {
            this.m_listPrecloseOperations.add(servicePrecloseable);
        }
        LOG.exit("registerPrecloseOperationImplementation");
    }

    protected void removePrecloseOperationImplementation(ServicePrecloseable servicePrecloseable) {
        LOG.enter("removePrecloseOperationImplementation", new Object[]{servicePrecloseable});
        this.m_listPrecloseOperations.removeElement(servicePrecloseable);
        LOG.exit("removePrecloseOperationImplementation");
    }

    protected void registerScreenImplementation(Serviceable serviceable) {
        LOG.enter("registerScreenImplementation", new Object[]{serviceable});
        if (!this.m_listScreens.contains(serviceable)) {
            this.m_listScreens.add(serviceable);
        }
        LOG.exit("registerScreenImplementation");
    }

    protected void removeScreenImplementation(Serviceable serviceable) {
        LOG.enter("removeScreenImplementation", new Object[]{serviceable});
        this.m_listScreens.removeElement(serviceable);
        LOG.exit("removeScreenImplementation");
    }

    protected void updateImplementation() {
        LOG.enter("updateImplementation");
        if (this.m_oResetPopup != null) {
            try {
                int n = (100 - this.m_oResetPopup.getProgress()) / 2;
                this.m_oResetPopup.setProgress(this.m_oResetPopup.getProgress() + n);
                Thread.sleep(250L);
                this.m_oResetPopup.setProgress(100);
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"run - thread sleep exception", (Throwable)interruptedException);
            }
            this.m_oResetPopup.dispose();
            this.m_oResetPopup = null;
        }
        LOG.exit("updateImplementation");
    }
}

