/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.Popup;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;

public class CommonModeScreen
extends GenericScreen {
    private final String FILE = "CommonModeScreen";
    private static final CssLogger LOG = CssLogger.getCssLogger(CommonModeScreen.class);
    private ErrorPopup m_errorPopup = new ErrorPopup();
    public JButton m_changeModeBtn = new JButton("Change To Normal Mode");
    public JLabel m_deviceModeTFld;
    private String m_instanceId;
    public Mode m_CurrMode;

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        Audit.audit((int)1011, (String)"CommonModeScreen", (String)("Enter buildScreen() arguments: g_window = " + object + ", g_statusBar = " + statusBarListener));
        this.m_CurrMode = Mode.UNKNOWN;
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonModeScreen.this);
                CommonModeScreen.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2));
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 1));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setText("  Current Station Mode");
        jLabel.setToolTipText("Station's Current Operational Mode");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(50, 10));
        jPanel3.add(jLabel2);
        this.m_deviceModeTFld = new JLabel("N/A");
        this.m_deviceModeTFld.setBackground(this.getBackground());
        this.m_deviceModeTFld.setPreferredSize(new Dimension(90, 20));
        jPanel3.add(this.m_deviceModeTFld);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(1));
        this.m_changeModeBtn.setEnabled(false);
        jPanel4.add(this.m_changeModeBtn);
        jPanel2.add(jPanel4);
        statusBarListener.registerComponent((Component)this.m_changeModeBtn, "Click this button to change the station mode");
        Audit.audit((int)1012, (String)"CommonModeScreen", (String)"Exit buildScreen() ");
    }

    @Override
    public void initialize() {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)"Enter initialize()");
        this.m_deviceModeTFld.setText("N/A");
        this.m_changeModeBtn.setEnabled(false);
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit initialize()");
    }

    public void updateDeviceMode(int n, Integer[] integerArray, Integer[] integerArray2) {
        Audit.audit((int)1009, (String)"CommonModeScreen", (String)("Enter updateDeviceMode(), arguments: g_error = " + n + "g_deviceMode " + integerArray + "g_instanceId " + integerArray2));
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)"CommonModeScreen", (String)"Unable to get device mode ");
            if (this.m_window.isVisible()) {
                this.m_errorPopup.display("Unable to get device Mode from the device");
            }
        } else {
            this.m_instanceId = "." + integerArray2[0];
            this.m_CurrMode = Mode.getModeFor(integerArray[0]);
            this.m_CurrMode.setComponents(this.m_deviceModeTFld, this.m_changeModeBtn);
            this.m_CurrMode.refreshButtons();
        }
        Audit.audit((int)1010, (String)"CommonModeScreen", (String)"Exit updateDeviceMode()");
    }

    public JButton getChangeModeButton() {
        LOG.enter("getChangeModeButton");
        LOG.exit("getChangeModeButton", (Object)this.m_changeModeBtn);
        return this.m_changeModeBtn;
    }

    public boolean isResetOperationRequired() {
        LOG.enter("isResetOperationRequired");
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        boolean bl = Devices.is3600Application((String)string) != false || this.m_CurrMode.equals((Object)Mode.CONFIGURATION);
        LOG.exit("isResetOperationRequired");
        return bl;
    }

    public void updateChangeModeDependencies(int n) {
        LOG.enter("updateNormalModeDependencies", new Object[]{n});
        if (n == 0) {
            if (this.isResetOperationRequired()) {
                ScreenManager.suspend(true);
            } else {
                ScreenManager.suspend(false);
            }
        } else {
            LOG.warn((Object)"Unable to Change mode");
            this.m_errorPopup.display(-327684);
        }
        LOG.exit("updateNormalModeDependencies");
    }

    public class ChangeToServiceMode_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = false;
            if (CommonModeScreen.this.m_CurrMode.equals((Object)Mode.NORMAL)) {
                bl = true;
                bl = CommonModeScreen.this.isResetOperationRequired() ? PnmDialog.confirm((Object)CommonModeScreen.this.m_window, (String)Popup.getMessageString((int)-327687)) : PnmDialog.confirm((Object)CommonModeScreen.this.m_window, (String)Popup.getMessageString((int)-327683));
            }
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2011);
            CommonModeScreen.this.m_window.lockWindow();
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            CommonModeScreen.this.m_window.unlockWindow();
            CommonModeScreen.this.updateChangeModeDependencies(messageIfc.getError());
            LOG.exit("update");
            return true;
        }
    }

    public class ChangeToNormalMode_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = false;
            if (CommonModeScreen.this.m_CurrMode.equals((Object)Mode.SERVICE) || CommonModeScreen.this.m_CurrMode.equals((Object)Mode.CONFIGURATION)) {
                bl = true;
                bl = CommonModeScreen.this.isResetOperationRequired() ? PnmDialog.confirm((Object)CommonModeScreen.this.m_window, (String)Popup.getMessageString((int)-327687)) : PnmDialog.confirm((Object)CommonModeScreen.this.m_window, (String)Popup.getMessageString((int)-327683));
            }
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(2010);
            CommonModeScreen.this.m_window.lockWindow();
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            CommonModeScreen.this.m_window.unlockWindow();
            CommonModeScreen.this.updateChangeModeDependencies(messageIfc.getError());
            LOG.exit("update");
            return true;
        }
    }

    public static enum Mode {
        NORMAL(2){

            @Override
            public void refreshButtons() {
                this.oText.setText("Normal");
                this.setButtonToService(true);
            }
        }
        ,
        CONFIGURATION(4){

            @Override
            public void refreshButtons() {
                this.oText.setText("Configuration");
                this.setButtonToNormal(true);
            }
        }
        ,
        SERVICE(5){

            @Override
            public void refreshButtons() {
                this.oText.setText("Service");
                this.setButtonToNormal(true);
            }
        }
        ,
        RESET(6){

            @Override
            public void refreshButtons() {
                this.oText.setText("Reset");
                this.setButtonToNormal(false);
            }
        }
        ,
        NORMAL2(7){

            @Override
            public void refreshButtons() {
                this.oText.setText("Normal");
                this.setButtonToService(true);
            }
        }
        ,
        INITIALIZATION(8){

            @Override
            public void refreshButtons() {
                this.oText.setText("Initialization");
                this.setButtonToNormal(false);
            }
        }
        ,
        UNKNOWN(-1){

            @Override
            public void refreshButtons() {
                this.oText.setText("Unknown");
                this.setButtonToNormal(false);
            }
        };

        private int iMode;
        public JLabel oText;
        public JButton oButton;

        public abstract void refreshButtons();

        private Mode(int n2) {
            this.iMode = n2;
        }

        public void setComponents(JLabel jLabel, JButton jButton) {
            this.oText = jLabel;
            this.oButton = jButton;
        }

        public void setButtonToNormal(boolean bl) {
            this.oButton.setText("Change To Normal Mode");
            this.oButton.setToolTipText("Set the Station in Normal Mode");
            this.oButton.setEnabled(bl);
        }

        public void setButtonToService(boolean bl) {
            this.oButton.setText("Change To Service Mode");
            this.oButton.setToolTipText("Set the Station in Service Mode");
            this.oButton.setEnabled(bl);
        }

        public static Mode getModeFor(int n) {
            for (Mode mode : Mode.values()) {
                if (n != mode.iMode) continue;
                return mode;
            }
            return UNKNOWN;
        }

        public int getMode() {
            return this.iMode;
        }
    }
}

