/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.statuspanel;

import css.core.appservices.cs.ConnectionInfoObject;
import css.core.appservices.cs.ConnectionService;
import css.core.appservices.mas.MetadataAcquisitionService;
import css.core.protocol.ProtocolListener;
import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.RealTimeDataObject;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CSSException;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.ErrorLogUtilities;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.common.util.DeviceErrorCodes;
import css.device.common.util.LogFileClosable;
import css.device.common.util.LoggerClosingHandler;
import css.device.platform.common.screens.statuspanel.BrHardwareStatusPanel;
import css.device.platform.common.screens.statuspanel.BrStationStatusPanel;
import css.device.platform.common.screens.statuspanel.DiagnosticMessageTab;
import css.device.platform.common.screens.statuspanel.StationCommandTab;
import css.device.platform.common.tables.BrCommonTranslationInfoRules;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;
import pnm.util.Audit;
import pnm.util.EngineUtilities;
import pnm.util.path.PathConstants;

public class BrStatusPanelScreen
extends GenericScreen
implements ActionListener,
LogFileClosable {
    private static final long serialVersionUID = -1L;
    private final String m_startLogBtnLblStr = "Start Log";
    private final String m_stopLogBtnLblStr = "Stop Log";
    private boolean m_serviceMode = false;
    private LoggerClosingHandler m_oLoggerClosingHandler = new LoggerClosingHandler("log_close_confirmation");
    private static final CssLogger LOG = CssLogger.getCssLogger(BrStatusPanelScreen.class);
    public BrHardwareStatusPanel m_hardwareStatusPanel;
    public BrStationStatusPanel m_stationStatusPanel;
    public DiagnosticMessageTab m_diagnosticMessageTab;
    public StationCommandTab m_stationCommandTab;
    private JTabbedPane m_statusPanelTab;
    private ErrorPopup m_errorPopup = new ErrorPopup();
    private ConfirmationPopup m_confirmPopup = new ConfirmationPopup();
    public JButton m_resetBtn = new JButton("Reset");
    public JButton m_siteResetBtn = new JButton("Site Reset");
    public JButton m_startLogBtn = new JButton("Start Log");
    private FileWriter out = null;
    private boolean m_storeHistory = false;
    private SimpleDateFormat m_formatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
    private boolean m_bIsFspSessionRunning = false;
    private boolean m_isHpdApp = true;
    private boolean m_isMsbrApp = true;
    private boolean m_isRptrBrApp = true;
    private boolean m_isConvBrApp = true;
    private boolean m_isMsBR3600App = true;
    private boolean m_isIR3600App = true;

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (!Devices.isHpdBrApplication((String)string).booleanValue()) {
            this.m_isHpdApp = false;
        }
        if (!Devices.isMsBrApplication((String)string).booleanValue()) {
            this.m_isMsbrApp = false;
        }
        if (!Devices.isIsrApplication((String)string).booleanValue()) {
            this.m_isRptrBrApp = false;
        }
        if (!Devices.isConvBrApplication((String)string).booleanValue()) {
            this.m_isConvBrApp = false;
        }
        if (!Devices.isMsBR3600Application((String)string).booleanValue()) {
            this.m_isMsBR3600App = false;
        }
        if (!Devices.isIR3600Application((String)string).booleanValue()) {
            this.m_isIR3600App = false;
        }
        this.setLayout(new BorderLayout());
        this.m_stationStatusPanel = new BrStationStatusPanel(this);
        this.m_stationStatusPanel.buildScreen(this.m_window, statusBarListener);
        this.m_hardwareStatusPanel = new BrHardwareStatusPanel(this, this.m_stationStatusPanel);
        this.m_hardwareStatusPanel.buildScreen(this.m_window, statusBarListener);
        this.m_diagnosticMessageTab = new DiagnosticMessageTab(this);
        this.m_diagnosticMessageTab.buildScreen(this.m_window, statusBarListener);
        this.m_stationCommandTab = new StationCommandTab(this, this.m_stationStatusPanel);
        this.m_stationCommandTab.buildScreen(this.m_window, statusBarListener);
        this.m_stationStatusPanel.setStationCommandTab(this.m_stationCommandTab);
        this.m_statusPanelTab = new JTabbedPane();
        this.m_statusPanelTab.addTab("Hardware Status", this.m_hardwareStatusPanel);
        this.m_statusPanelTab.addTab("Station Status", this.m_stationStatusPanel);
        if (this.isConvBrApplication()) {
            this.m_statusPanelTab.addTab("Station Command", this.m_stationCommandTab);
            this.m_statusPanelTab.addTab("Decoder Messages", this.m_diagnosticMessageTab);
        }
        this.m_statusPanelTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (BrStatusPanelScreen.this.m_statusPanelTab.getSelectedComponent() instanceof DiagnosticMessageTab) {
                    BrStatusPanelScreen.this.m_diagnosticMessageTab.setDecoderMessageTypeDisabledInServiceMode();
                } else if (BrStatusPanelScreen.this.m_statusPanelTab.getSelectedComponent() instanceof StationCommandTab) {
                    LOG.trace((Object)"buildScreen - StationCommandTab tab selected");
                    BrStatusPanelScreen.this.m_stationCommandTab.lockScreenWhenToneIsOn();
                    BrStatusPanelScreen.this.startStationCommandRules();
                }
                LOG.exit("stateChanged");
            }
        });
        this.add((Component)this.m_statusPanelTab, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        this.add((Component)jPanel, "South");
        this.m_resetBtn.setToolTipText("Resets the station.");
        jPanel.add(this.m_resetBtn);
        statusBarListener.registerComponent((Component)this.m_resetBtn, "Click this button to Reset the Station.");
        JLabel jLabel = new JLabel();
        jLabel.setText("     ");
        jPanel.add(jLabel);
        if (this.isIR3600Application()) {
            this.m_siteResetBtn.setName("Site Reset");
            jPanel.add(this.m_siteResetBtn);
            statusBarListener.registerComponent((Component)this.m_siteResetBtn, "Click this button to reset all IRs in the Site.");
        }
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("     ");
        jPanel.add(jLabel2);
        this.m_startLogBtn.setToolTipText("Starts/Stops the storing of event logs.");
        this.m_startLogBtn.addActionListener(this);
        jPanel.add(this.m_startLogBtn);
        ScreenManager.registerPrecloseOperation(this.m_oLoggerClosingHandler);
        statusBarListener.registerComponent((Component)this.m_startLogBtn, "Click this button to start/stop the storing of event logs.");
        LOG.exit("buildScreen");
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.m_hardwareStatusPanel.initialize();
        this.m_stationStatusPanel.initialize();
        this.m_diagnosticMessageTab.initialize();
        this.m_stationCommandTab.initialize();
        this.m_statusPanelTab.setSelectedIndex(0);
        this.m_oLoggerClosingHandler.reset();
        ScreenManager.registerPrecloseOperation(this.m_oLoggerClosingHandler);
        LOG.exit("initialize");
    }

    public void updateResetDependencies(int n) {
        LOG.enter("updateResetDependencies", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.warn((Object)"updateResetDependencies: Unable to reset station ");
            this.popupError(-327733);
        } else {
            ScreenManager.suspend(true);
        }
        LOG.exit("updateResetDependencies");
    }

    public void closeScreen() {
        LOG.enter("closeScreen");
        this.m_window.setVisible(false);
        ScreenManager.removeScreen(this);
        LOG.exit("closeScreen");
    }

    public void handleStopSession(int n) {
        LOG.enter("handleStopSession", new Object[]{Integer.toString(n)});
        if (n != 0) {
            LOG.warn((Object)"Window Closing Error");
        } else {
            this.closeFile();
        }
        LOG.exit("handleStopSession");
    }

    public boolean userRequest() {
        boolean bl = false;
        LOG.enter("userRequest");
        this.m_confirmPopup.display(-327737);
        bl = this.m_confirmPopup.getStatus();
        LOG.exit("userRequest", (Object)Boolean.toString(bl));
        return bl;
    }

    public void realTimeUpdate(Object object) {
        block7: {
            RealTimeDataObject realTimeDataObject;
            block8: {
                LOG.enter("realTimeUpdate", new Object[]{object});
                realTimeDataObject = (RealTimeDataObject)object;
                if (realTimeDataObject == null) break block7;
                if (realTimeDataObject.getError() == 0) break block8;
                int n = realTimeDataObject.getError();
                switch (n) {
                    case -262160: {
                        this.popupError(-262160);
                        this.m_oLoggerClosingHandler.preclose();
                        if (this.canCloseScreen()) {
                            this.closeScreen();
                            break;
                        }
                        break block7;
                    }
                    default: {
                        if (realTimeDataObject instanceof FspRealTimeDataObject) {
                            byte[] byArray = ((FspRealTimeDataObject)realTimeDataObject).getData();
                            Integer n2 = Convert.toInteger((byte[])byArray);
                            if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                                LOG.error((Object)("realTimeUpdate - Error data: " + n2));
                                this.popupError(n2);
                                break;
                            }
                            LOG.error((Object)("realTimeUpdate - Unknown error code: " + realTimeDataObject.getError()));
                            break;
                        }
                        LOG.error((Object)("realTimeUpdate - Unknown error code: " + n));
                        break;
                    }
                }
                break block7;
            }
            boolean bl = this.m_hardwareStatusPanel.updateRealTimeData(realTimeDataObject);
            if (!(bl || (bl = this.m_stationStatusPanel.updateRealTimeData(realTimeDataObject)) || (bl = this.m_diagnosticMessageTab.updateRealTimeData(object)) || (bl = this.m_stationCommandTab.updateRealTimeData(object)))) {
                LOG.warn(new Object[]{"realTimeUpdate: Name not found.", realTimeDataObject});
            }
        }
        LOG.exit("realTimeUpdate");
    }

    public Object[] startSession() {
        LOG.enter("startSession");
        Byte by = new Byte(0);
        Byte by2 = new Byte(0);
        Object[][] objectArray = BrCommonTranslationInfoRules.BrCommonRealTimeStatusRules;
        Object[] objectArray2 = new Object[]{by, by2, objectArray};
        LOG.exit("startSession", objectArray2);
        return objectArray2;
    }

    public void handleStartSession(int n) {
        LOG.enter("handleStartSession", new Object[]{Integer.toString(n)});
        if (n == 0) {
            this.m_bIsFspSessionRunning = true;
        } else {
            this.popupError("unable_to_start_session");
            this.closeScreen();
        }
        LOG.exit("handleStartSession");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoginSuccessfull() {
        ProtocolListener protocolListener = null;
        boolean bl = false;
        boolean bl2 = true;
        LOG.enter("isLoginSuccessfull");
        Integer n = CSSUtilities.getComponentMajorVersion((String)MetadataAcquisitionService.getMetadataVersion());
        if (n != null && n > 11) {
            this.m_statusPanelTab.setEnabled(false);
            this.m_startLogBtn.setEnabled(false);
            this.m_resetBtn.setEnabled(false);
            this.m_siteResetBtn.setEnabled(false);
            try {
                ErrorLogUtilities.getDtdFile();
                ErrorLogUtilities errorLogUtilities = this.m_stationStatusPanel.getErrorLogUtility();
                if (errorLogUtilities == null || errorLogUtilities.isFileExist(ErrorLogUtilities.getDtdFileName()) != 0) {
                    PnmDialog.error((Object)this.m_window, (String)"unable_to_display_errorlog_file");
                    bl2 = false;
                }
            }
            catch (CSSException cSSException) {
                bl2 = false;
                protocolListener = ConnectionService.getProtocolListener();
                if (protocolListener != null) {
                    if (protocolListener.isCancelButtonPressed() != null) {
                        bl = protocolListener.isCancelButtonPressed();
                        if (!bl) {
                            if (ConnectionInfoObject.getFtpCredentials() == null) {
                                PnmDialog.error((Object)EngineUtilities.getMainApplicationWindow(), (String)"unable_to_login_to_device");
                            } else {
                                PnmDialog.error((Object)this.m_window, (String)"unable_to_establish_physical_connection_check_settings");
                            }
                        }
                        protocolListener.setCancelButtonStatus(null);
                    } else {
                        PnmDialog.error((Object)this.m_window, (String)"unable_to_establish_physical_connection_check_settings");
                    }
                } else {
                    LOG.warn((Object)"Unexpected condition protocol listener is null.");
                }
                ScreenManager.removeScreen(this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BrStatusPanelScreen.this.m_window.unlockWindow();
                        BrStatusPanelScreen.this.m_window.setCursor(Cursor.getPredefinedCursor(0));
                        BrStatusPanelScreen.this.m_window.setVisible(false);
                    }
                });
            }
            finally {
                if (bl2) {
                    this.m_statusPanelTab.setEnabled(true);
                    this.m_startLogBtn.setEnabled(true);
                    this.m_resetBtn.setEnabled(true);
                    if (this.isServiceMode()) {
                        this.m_siteResetBtn.setEnabled(false);
                        this.m_siteResetBtn.setToolTipText("This function is only available in Normal Mode.");
                    } else {
                        this.m_siteResetBtn.setEnabled(true);
                        this.m_siteResetBtn.setToolTipText("Command all IRs at site to reset or re-init the IR applications");
                    }
                }
            }
        }
        LOG.exit("isLoginSuccessfull", (Object)Boolean.toString(bl2));
        return bl2;
    }

    public boolean isFspSessionRunning() {
        LOG.enter("isFspSessionRunning");
        LOG.exit("isFspSessionRunning", (Object)Boolean.toString(this.m_bIsFspSessionRunning));
        return this.m_bIsFspSessionRunning;
    }

    public void handleInitialRealTimeStatus(int n, Integer n2, Integer n3, Integer n4, Integer n5, Integer n6, Integer n7, Integer n8, Integer n9, Integer n10, Integer n11, Integer n12, Integer n13, Integer n14, Integer n15, Integer n16, Integer n17, Integer n18, Integer n19, Integer n20, Integer n21, Integer n22, Integer n23, Integer n24, Integer n25, Integer n26, Integer n27, byte[] byArray, byte[] byArray2, Integer n28, Integer n29, Integer n30, Integer n31, Integer n32, Integer n33, Integer n34, Integer n35, Integer n36, Integer n37, Integer n38, Integer n39, Integer n40, byte[] byArray3, byte[] byArray4, byte[] byArray5, Integer n41, Integer n42, Integer n43, Integer n44, Integer n45, Integer n46, Integer n47, Integer n48, byte[] byArray6, byte[] byArray7) {
        LOG.enter("handleInitialRealTimeStatus", new Object[]{n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, n18, n19, n20, n21, n22, n23, n24, n25, n26, n27, n29, n30, n31, n32, n33, n34, n35, n36, n37, n38, n39, n40, byArray3, byArray4, byArray5, n41, n42, n43, n44, n45, n46, n47, n48, byArray6, byArray7});
        if (n != 0) {
            this.popupError(-620002);
        } else {
            this.m_stationStatusPanel.updateStationConfiguration(n11, n12, n13, n15, n14, n16, n17, n24, n25, n26, byArray, byArray2, n28, n32, n34, n31, n33, n29, n30, n36, n38, byArray5, n42, n43, n44, n45, n46, n47, byArray6, byArray7);
            this.m_stationStatusPanel.updateTdmaStationConfiguration(n22, n23);
            this.m_hardwareStatusPanel.updateHardwareConfiguration(n2, n4, n6, n10, n20, n21, n18, n19, n8, n3, n5, n7, n9, n27, byArray3, byArray4, n41, n35, n37, n48);
            this.m_stationCommandTab.updateStationCommand(n39, n40);
        }
        this.m_window.unlockWindow();
        LOG.exit("handleInitialRealTimeStatus");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = null;
        LOG.enter("actionPerformed", new Object[]{actionEvent});
        if ("Start Log".equals(this.m_startLogBtn.getText())) {
            JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
            int n = jFileChooser.showSaveDialog((Component)this.m_window);
            if (n == 0 && CSSUtilities.isValidLogFile((File)(file = jFileChooser.getSelectedFile()), (ErrorPopup)this.m_errorPopup)) {
                try {
                    this.m_storeHistory = true;
                    this.out = new FileWriter(file);
                    Date date = new Date();
                    String string = this.m_formatter.format(date);
                    this.out.write("  START LOG TIME  : " + string + "\n");
                    this.out.flush();
                    this.startWriteToFile();
                    this.m_startLogBtn.setText("Stop Log");
                }
                catch (IOException iOException) {
                    LOG.info((Object)"Unable to create file for writing", (Throwable)iOException);
                    this.popupError(-327859);
                    this.m_storeHistory = false;
                }
                catch (Exception exception) {
                    LOG.info((Object)"Unknown Exception was thrown", (Throwable)exception);
                    this.popupError(-327860);
                    this.m_storeHistory = false;
                }
            }
        } else {
            this.closeMessageLog();
        }
        LOG.exit("actionPerformed");
    }

    private void startWriteToFile() {
        LOG.enter("startWriteToFile");
        this.m_hardwareStatusPanel.writeInitialDataToFile();
        this.m_stationStatusPanel.writeInitialDataToFile();
        LOG.exit("startWriteToFile");
    }

    public void appendString(String string) {
        LOG.enter("appendString", new Object[]{string});
        if (this.m_storeHistory) {
            try {
                this.out.write(string);
                this.out.flush();
            }
            catch (IOException iOException) {
                LOG.warn((Object)("Unable to write to File" + iOException));
                this.m_errorPopup.display(-327859);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        BrStatusPanelScreen.this.m_startLogBtn.setText("Start Log");
                    }
                };
                SwingUtilities.invokeLater(runnable);
                this.m_storeHistory = false;
            }
        }
        LOG.exit("appendString");
    }

    public boolean isLogClosed() {
        LOG.enter("isLogClosed");
        boolean bl = this.m_oLoggerClosingHandler.isLogClosed(this) && this.m_diagnosticMessageTab.closeLogIfCan();
        LOG.exit("isLogClosed", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean canCloseScreen() {
        boolean bl;
        LOG.enter("canCloseScreen");
        boolean bl2 = bl = this.isLogClosed() && this.m_diagnosticMessageTab.closeLogIfCan();
        if (bl) {
            bl = this.isFspSessionRunning();
        }
        LOG.exit("canCloseScreen", (Object)Boolean.toString(bl));
        return bl;
    }

    protected void closeMessageLog() {
        this.m_storeHistory = false;
        try {
            Date date = new Date();
            String string = this.m_formatter.format(date);
            if (this.out != null) {
                this.out.write("=================================================================================\n");
                this.out.write("  STOP LOG TIME  : " + string + "\n");
                this.out.flush();
                this.out.close();
            }
        }
        catch (IOException iOException) {
            LOG.info((Object)"Unable to close file for writing", (Throwable)iOException);
        }
        this.m_startLogBtn.setText("Start Log");
    }

    @Override
    public void closeFile() {
        LOG.enter("closeFile");
        this.closeMessageLog();
        this.m_diagnosticMessageTab.closeLogging();
        LOG.exit("closeFile");
    }

    @Override
    public boolean isFileOpen() {
        LOG.enter("isFileOpen");
        LOG.exit("isFileOpen", (Object)Boolean.toString(this.m_storeHistory));
        return this.m_storeHistory;
    }

    public boolean isHPDApplication() {
        LOG.enter("isHPDApplication");
        LOG.exit("isHPDApplication", (Object)this.m_isHpdApp);
        return this.m_isHpdApp;
    }

    public boolean isMsbrApplication() {
        LOG.enter("isMsbrApplication");
        LOG.exit("isMsbrApplication", (Object)this.m_isMsbrApp);
        return this.m_isMsbrApp;
    }

    public boolean isRptrBrApplication() {
        LOG.enter("isRptrBrApplication");
        LOG.exit("isRptrBrApplication", (Object)this.m_isRptrBrApp);
        return this.m_isRptrBrApp;
    }

    public boolean isConvBrApplication() {
        LOG.enter("isConvBrApplication");
        LOG.exit("isConvBrApplication", (Object)this.m_isConvBrApp);
        return this.m_isConvBrApp;
    }

    public boolean isMsBR3600Application() {
        return this.m_isMsBR3600App;
    }

    public boolean isIR3600Application() {
        return this.m_isIR3600App;
    }

    public boolean isNon3600Application() {
        return false == this.isIR3600Application() && false == this.isMsBR3600Application();
    }

    public boolean is3600Application() {
        return this.isIR3600Application() || this.isMsBR3600Application();
    }

    public void getServiceMode(int n, Integer n2) {
        this.m_window.unlockWindow();
        if (n != 0) {
            Audit.audit((int)1002, (String)this.FILE, (String)"Unable to get device mode ");
            if (this.m_window.isVisible()) {
                this.m_errorPopup.display("Unable to get device Mode from the device");
                this.closeScreen();
            }
        } else {
            int n3 = n2;
            this.m_serviceMode = n3 == 5;
        }
    }

    public boolean isServiceMode() {
        return this.m_serviceMode;
    }

    public boolean startStationCommandRules() {
        LOG.enter("startStationCommandRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isConvBrApplication((String)string).booleanValue()) {
            this.m_stationCommandTab.getGenericListener().notifyGuiListener();
        }
        LOG.exit("startStationCommandRules");
        return bl;
    }

    public class StartSiteReset_Rule
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            boolean bl = false;
            if (BrStatusPanelScreen.this.isIR3600Application()) {
                BrStatusPanelScreen.this.m_confirmPopup.display("This operation requires Site reset. Do you wish to proceed ?");
                bl = BrStatusPanelScreen.this.m_confirmPopup.getStatus();
            }
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5464);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            ScreenManager.suspend(true);
            LOG.exit("update");
            return true;
        }
    }
}

