/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.common.screens.testandmeasurement;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.Rule;
import css.core.service.SessionIfc;
import css.core.util.CSSUtilities;
import css.core.util.CssConstants;
import css.core.util.CssErrorCodes;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.Logger;
import css.core.util.TimeDialog;
import css.core.util.component.GenericListener;
import css.core.util.popup.ErrorPopup;
import css.core.util.popup.Popup;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.util.CssServiceJLabel;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.common.screens.testandmeasurement.BrTestMeasurementScreen;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import pnm.ui.UIInternalFrame;
import pnm.util.EngineUtilities;
import pnm.util.path.PathConstants;

public class BrAstroBerAndRssiReportPanel
extends JPanel
implements CssConstants,
CssErrorCodes,
TimeDialog.PostAction {
    private static final long serialVersionUID = 1L;
    private static final int OFFSET_6000 = 6000;
    static final int PATTERN_V_DOT_52 = 1;
    static final int PATTERN_PROJECT25_1011 = 2;
    static final int P2_TEST_TONE_1031_HZ = 5;
    private static final String RX_WINDOW_NAME = "Receiver Test";
    private static final String RX_PROGRESS_STRING = null;
    private static final String RX_OPERATION_TIMEOUT = "Receiver Test time out occurred.";
    private static final int RX_TEST_TIMEOUT = 20;
    final int RX_TEST_SUCCESS = 1;
    final int RX_TEST_FAILED = 2;
    final int RX_NO_ERROR_PRESENT = 1;
    final int RX_TEST_INV_MODE = 2;
    final int RX_TEST_INV_FAIL = 3;
    final int RX_TEST_INV_INH = 4;
    final int RX_TEST_INV_UNK = 5;
    private static final String V_25_TEXT = "V.52 (FDMA)";
    private static final String PROJECT_25_TEXT = "1011 Hz (FDMA)";
    private static final String P2_TEST_TONE_1031_HZ_TEXT = "1031 Hz test tone (TDMA logical channel 0 & 1)";
    public GenericListener m_oGenericListener = new GenericListener();
    public static final int SLOT0 = 0;
    public static final int SLOT1 = 1;
    String[] m_sFdmaTypePatterns = new String[]{"V.52 (FDMA)", "1011 Hz (FDMA)"};
    String[] m_sP2TdmaTypePatterns = new String[]{"V.52 (FDMA)", "1011 Hz (FDMA)", "1031 Hz test tone (TDMA logical channel 0 & 1)"};
    private static final HashMap<Integer, String> TESTPATTERNSPAIRS = new HashMap();
    private static final int RSSI_FREQUENCY_ERROR_NA = 65535;
    private static final String N_A = "N/A";
    private static final String BER_0xFFFF = "65.535";
    private static final int NOTEST = 0;
    private static final int BER = 1;
    private static final int RSSI = 2;
    private static final int ENABLED = 1;
    private static final int DISABLED = 2;
    private int m_nRunningTest = 0;
    private final String INVALID = "Invalid";
    final String c_titlePatternTypeStr = "Settings";
    final String c_titleResultsStr = "Results";
    final String c_titleRxFreq = "Received Frequency";
    final String c_startRssiBtnLbl = "Start RSSI Measurement";
    final String c_stopRssiBtnLbl = "Stop RSSI Measurement";
    final String c_startBerMeasurementBtnLbl = "Start BER Measurement";
    final String c_stopBerMeasurementBtnLbl = "Stop BER Measurement";
    final String c_startLogBtnLbl = "Start Log";
    final String c_stopLogBtnLbl = "Stop Log";
    final String c_startRxTestBtnLbl = "Start Receiver Test";
    final String c_startRxTestBtnStatus = "Click the button to start Receiver Test.";
    final String c_startRxTestBtnTooltip = "Starts Receiver Test.";
    private CssServiceJLabel m_labBitErrorRate;
    private JLabel m_labPatternType;
    private JLabel m_labSamplingPeriod;
    private CssServiceJLabel m_labReceivedFreqOffset;
    private CssServiceJLabel m_labReceivedSlotTimeOffset;
    private CssServiceJLabel m_labReceivedSignalLblBranchA;
    private CssServiceJLabel m_labReceivedSignalLblBranchB;
    private CssServiceJLabel m_labReceivedSlotTimeDrift;
    private CssServiceJLabel m_labReceivedDeviationOffset;
    private JComboBox<String> m_voPatternType;
    private JComboBox m_voSamplePeriod;
    private BitErrorRateValueLbl m_labBitErrorRateValueSlot1;
    private BitErrorRateValueLbl m_labBitErrorRateValueSlot2;
    private ReceivedSignalValueLbl m_labReceivedSignalValueSlot1BranchA;
    private ReceivedSignalValueLbl m_labReceivedSignalValueSlot2BranchA;
    private ReceivedSignalValueLbl m_labReceivedSignalValueSlot1BranchB;
    private ReceivedSignalValueLbl m_labReceivedSignalValueSlot2BranchB;
    private ReceivedFreqOffsetValueLbl m_labReceivedFreqOffsetValueSlot1;
    private ReceivedFreqOffsetValueLbl m_labReceivedFreqOffsetValueSlot2;
    private ReceivedSlotTimeOffsetValueLbl m_labReceivedSlotTimeOffsetValueSlot1;
    private ReceivedSlotTimeOffsetValueLbl m_labReceivedSlotTimeOffsetValueSlot2;
    private ReceivedSlotTimeDriftModOffsetValueLbl m_labReceivedSlotTimeDriftValueSlot1;
    private ReceivedSlotTimeDriftModOffsetValueLbl m_labReceivedSlotTimeDriftValueSlot2;
    private ReceivedSlotTimeDriftModOffsetValueLbl m_labReceivedDeviationOffsetValueSlot1;
    private ReceivedSlotTimeDriftModOffsetValueLbl m_labReceivedDeviationOffsetValueSlot2;
    private JLabel m_labReceivedFreqValue;
    public JButton m_startBerMeasurementBtn;
    public JButton m_startRssiMeasurementBtn;
    public JButton m_saveLogBtn;
    public JButton m_startRxTestBtn;
    public GenericListener m_BerStartActions = new GenericListener();
    public GenericListener m_BerStopActions = new GenericListener();
    public GenericListener m_BerStopOnExitActions = new GenericListener();
    private Hashtable<String, CssServiceJLabel> m_oSlot0ParamsNameLabel = new Hashtable();
    public Hashtable<String, CssServiceJLabel> m_oSlot1ParamsNameLabel = new Hashtable();
    private int m_currentMode = 0;
    private boolean m_isRxTestRunning = false;
    private static final SimpleDateFormat m_formatter;
    private static final ErrorPopup errorPopup;
    private TimeDialog m_cTimeDialog = null;
    private BrTestMeasurementScreen m_testMeasurement;
    private UIInternalFrame m_window;
    private static final CssLogger LOG;
    private Logger m_log;
    private String m_sAppHWCombination = "UNKNOWN";
    private static final String BRANCH_A = "Branch A";
    private static final String BRANCH_B = "Branch B";
    JLabel titleLabelSlot1 = null;
    JLabel titleLabelSlot2 = null;

    public BrAstroBerAndRssiReportPanel(BrTestMeasurementScreen brTestMeasurementScreen) {
        this.m_testMeasurement = brTestMeasurementScreen;
        ButtonActionEvent buttonActionEvent = new ButtonActionEvent();
        this.m_saveLogBtn = new JButton();
        this.m_saveLogBtn.addActionListener(buttonActionEvent);
    }

    public GenericListener getGenericListener() {
        return this.m_oGenericListener;
    }

    public int buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        String[] stringArray = new String[]{"1", "10", "100"};
        this.m_sAppHWCombination = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        Vector<String> vector = null;
        vector = Devices.isConvBrApplication((String)this.m_sAppHWCombination) != false || Devices.is3600Application((String)this.m_sAppHWCombination) != false ? new Vector<String>(Arrays.asList(this.m_sFdmaTypePatterns)) : new Vector<String>(Arrays.asList(this.m_sP2TdmaTypePatterns));
        this.m_window = uIInternalFrame;
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Receiver Frequency (MHz)");
        jLabel.setName("Receiver Frequency (MHz) label");
        GridBagAdder.add((Container)jPanel, (Component)jLabel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)0, (int)30, (int)1, (int)20, (int)0);
        this.m_labReceivedFreqValue = new JLabel(N_A);
        this.m_labReceivedFreqValue.setName("Receiver Frequency (MHz)");
        GridBagAdder.add((Container)jPanel, (Component)this.m_labReceivedFreqValue, (int)1, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)0, (int)80, (int)1, (int)20, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)15, (int)0, (int)0, (int)10, (int)0);
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Settings");
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(new GridBagLayout());
        this.m_labPatternType = new JLabel("Pattern Type");
        this.m_labPatternType.setName("Pattern Type label");
        GridBagAdder.add((Container)jPanel2, (Component)this.m_labPatternType, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)0, (int)25, (int)1, (int)20, (int)0);
        this.m_voPatternType = new JComboBox<String>(vector);
        this.m_voPatternType.setName("Pattern Type");
        this.m_voPatternType.setSize(90, 15);
        GridBagAdder.add((Container)jPanel2, this.m_voPatternType, (int)1, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)90, (int)1, (int)30, (int)0);
        this.m_labSamplingPeriod = new JLabel("Sampling Period (sec)");
        this.m_labSamplingPeriod.setName("Sampling Period (sec) label");
        GridBagAdder.add((Container)jPanel2, (Component)this.m_labSamplingPeriod, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)0, (int)25, (int)1, (int)20, (int)0);
        this.m_voSamplePeriod = new JComboBox<String>(stringArray);
        this.m_voSamplePeriod.setName("Sampling Period (sec)");
        GridBagAdder.add((Container)jPanel2, (Component)this.m_voSamplePeriod, (int)1, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)90, (int)1, (int)30, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)5, (int)0, (int)1, (int)10, (int)0);
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Results");
        jPanel3.setBorder(titledBorder2);
        jPanel3.setLayout(new GridBagLayout());
        int n = 0;
        if (Devices.isConvBrApplication((String)this.m_sAppHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.m_sAppHWCombination).booleanValue() || Devices.isIR3600Application((String)this.m_sAppHWCombination).booleanValue()) {
            this.titleLabelSlot1 = new JLabel("FDMA");
            GridBagAdder.add((Container)jPanel3, (Component)this.titleLabelSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labBitErrorRate = new CssServiceJLabel("Bit Error Rate (%)");
            this.m_labBitErrorRate.setName("Bit Error Rate (%) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labBitErrorRate, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labBitErrorRateValueSlot1 = new BitErrorRateValueLbl(N_A);
            this.m_labBitErrorRateValueSlot1.setName("Bit Error Rate (%)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labBitErrorRateValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSignalLblBranchA = new CssServiceJLabel("Received Signal Strength Branch A (dBm)");
            this.m_labReceivedSignalLblBranchA.setName("Received Signal Strength Branch A (dBm) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalLblBranchA, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedSignalValueSlot1BranchA = new ReceivedSignalValueLbl(N_A, BRANCH_A);
            this.m_labReceivedSignalValueSlot1BranchA.setName("Received Signal Strength Branch A (dBm)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalValueSlot1BranchA, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedFreqOffset = new CssServiceJLabel("Received Frequency Offset (Hz)");
            this.m_labReceivedFreqOffset.setName("Received Frequency Offset (Hz) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedFreqOffset, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedFreqOffsetValueSlot1 = new ReceivedFreqOffsetValueLbl(N_A);
            this.m_labReceivedFreqOffsetValueSlot1.setName("Received Frequency Offset (Hz)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedFreqOffsetValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            ++n;
        } else {
            this.titleLabelSlot1 = new JLabel("FDMA/TDMA logical channel 0");
            GridBagAdder.add((Container)jPanel3, (Component)this.titleLabelSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.titleLabelSlot2 = new JLabel("TDMA logical channel 1");
            GridBagAdder.add((Container)jPanel3, (Component)this.titleLabelSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labBitErrorRate = new CssServiceJLabel("Bit Error Rate (%)");
            this.m_labBitErrorRate.setName("Bit Error Rate (%) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labBitErrorRate, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labBitErrorRateValueSlot1 = new BitErrorRateValueLbl(N_A);
            this.m_labBitErrorRateValueSlot1.setName("Bit Error Rate (%)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labBitErrorRateValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labBitErrorRateValueSlot2 = new BitErrorRateValueLbl(N_A);
            this.m_labBitErrorRateValueSlot2.setName("Bit Error Rate (%) 2");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labBitErrorRateValueSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSignalLblBranchA = new CssServiceJLabel("Received Signal Strength Branch A (dBm)");
            this.m_labReceivedSignalLblBranchA.setName("Received Signal Strength Branch A (dBm) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalLblBranchA, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedSignalValueSlot1BranchA = new ReceivedSignalValueLbl(N_A, BRANCH_A);
            this.m_labReceivedSignalValueSlot1BranchA.setName("Received Signal Strength Branch A (dBm)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalValueSlot1BranchA, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSignalValueSlot2BranchA = new ReceivedSignalValueLbl(N_A, BRANCH_A);
            this.m_labReceivedSignalValueSlot2BranchA.setName("Received Signal Strength Branch A (dBm) 2");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalValueSlot2BranchA, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSignalLblBranchB = new CssServiceJLabel("Received Signal Strength Branch B (dBm)");
            this.m_labReceivedSignalLblBranchB.setName("Received Signal Strength Branch B (dBm) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalLblBranchB, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedSignalValueSlot1BranchB = new ReceivedSignalValueLbl(N_A, BRANCH_B);
            this.m_labReceivedSignalValueSlot1BranchB.setName("Received Signal Strength Branch B (dBm)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalValueSlot1BranchB, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSignalValueSlot2BranchB = new ReceivedSignalValueLbl(N_A, BRANCH_B);
            this.m_labReceivedSignalValueSlot2BranchB.setName("Received Signal Strength Branch B (dBm) 2");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSignalValueSlot2BranchB, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedFreqOffset = new CssServiceJLabel("Received Frequency Offset (Hz)");
            this.m_labReceivedFreqOffset.setName("Received Frequency Offset (Hz) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedFreqOffset, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedFreqOffsetValueSlot1 = new ReceivedFreqOffsetValueLbl(N_A);
            this.m_labReceivedFreqOffsetValueSlot1.setName("Received Frequency Offset (Hz)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedFreqOffsetValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedFreqOffsetValueSlot2 = new ReceivedFreqOffsetValueLbl(N_A);
            this.m_labReceivedFreqOffsetValueSlot2.setName("Received Frequency Offset (Hz) 2");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedFreqOffsetValueSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSlotTimeOffset = new CssServiceJLabel("Received Slot Time Offset (usec)");
            this.m_labReceivedSlotTimeOffset.setName("Received Slot Time Offset (usec) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeOffset, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedSlotTimeOffsetValueSlot1 = new ReceivedSlotTimeOffsetValueLbl(N_A);
            this.m_labReceivedSlotTimeOffsetValueSlot1.setName("Received Slot Time Offset (usec)");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeOffsetValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSlotTimeOffsetValueSlot2 = new ReceivedSlotTimeOffsetValueLbl(N_A);
            this.m_labReceivedSlotTimeOffsetValueSlot2.setName("Received Slot Time Offset (usec) 2");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeOffsetValueSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSlotTimeDrift = new CssServiceJLabel("Received Slot Time Drift (usec/min)");
            this.m_labReceivedSlotTimeDrift.setName("Received Slot Time Drift (usec) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeDrift, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedSlotTimeDriftValueSlot1 = new ReceivedSlotTimeDriftModOffsetValueLbl(N_A);
            this.m_labReceivedSlotTimeDriftValueSlot1.setName("Received Slot Time Drift (usec)");
            this.m_labReceivedSlotTimeDriftValueSlot1.setFieldName(this.m_labReceivedSlotTimeDrift);
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeDriftValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedSlotTimeDriftValueSlot2 = new ReceivedSlotTimeDriftModOffsetValueLbl(N_A);
            this.m_labReceivedSlotTimeDriftValueSlot2.setName("Received Slot Time Drift (usec) 2");
            this.m_labReceivedSlotTimeDriftValueSlot2.setFieldName(this.m_labReceivedSlotTimeDrift);
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedSlotTimeDriftValueSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedDeviationOffset = new CssServiceJLabel("Received Mod Deviation Offset (Hz)");
            this.m_labReceivedDeviationOffset.setName("Received Mod Deviation Offset (Hz) label");
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedDeviationOffset, (int)0, (int)(++n), (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)25, (int)1, (int)10, (int)0);
            this.m_labReceivedDeviationOffsetValueSlot1 = new ReceivedSlotTimeDriftModOffsetValueLbl(N_A);
            this.m_labReceivedDeviationOffsetValueSlot1.setName("Received Mod Deviation Offset (Hz)");
            this.m_labReceivedDeviationOffsetValueSlot1.setFieldName(this.m_labReceivedDeviationOffset);
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedDeviationOffsetValueSlot1, (int)1, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
            this.m_labReceivedDeviationOffsetValueSlot2 = new ReceivedSlotTimeDriftModOffsetValueLbl(N_A);
            this.m_labReceivedDeviationOffsetValueSlot1.setName("Received Mod Deviation Offset (Hz) 2");
            this.m_labReceivedDeviationOffsetValueSlot2.setFieldName(this.m_labReceivedDeviationOffset);
            GridBagAdder.add((Container)jPanel3, (Component)this.m_labReceivedDeviationOffsetValueSlot2, (int)2, (int)n, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)18, (int)0, (int)35, (int)1, (int)60, (int)0);
        }
        GridBagAdder.add((Container)this, (Component)jPanel3, (int)0, (int)2, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)0, (int)10, (int)10, (int)0);
        this.m_labBitErrorRate.setToolTipText("Measured value of bit error rate.");
        this.m_labReceivedSignalLblBranchA.setToolTipText("Measured value of received signal strength level.");
        this.m_labReceivedFreqOffset.setToolTipText("Measured value of received frequency error.");
        if (Devices.isConvBrApplication((String)this.m_sAppHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.m_sAppHWCombination).booleanValue() || Devices.isIR3600Application((String)this.m_sAppHWCombination).booleanValue()) {
            this.m_oSlot0ParamsNameLabel.put("initialBerMeasurement", this.m_labBitErrorRateValueSlot1);
            this.m_oSlot0ParamsNameLabel.put("rssiBranchA", this.m_labReceivedSignalValueSlot1BranchA);
            this.m_oSlot0ParamsNameLabel.put("frequencyOffset", this.m_labReceivedFreqOffsetValueSlot1);
        } else {
            this.m_oSlot0ParamsNameLabel.put("initialBerMeasurement", this.m_labBitErrorRateValueSlot1);
            this.m_oSlot0ParamsNameLabel.put("rssiBranchA", this.m_labReceivedSignalValueSlot1BranchA);
            this.m_oSlot0ParamsNameLabel.put("rssiBranchB", this.m_labReceivedSignalValueSlot1BranchB);
            this.m_oSlot0ParamsNameLabel.put("frequencyOffset", this.m_labReceivedFreqOffsetValueSlot1);
            this.m_oSlot0ParamsNameLabel.put("slotTimeOffset", this.m_labReceivedSlotTimeOffsetValueSlot1);
            this.m_oSlot0ParamsNameLabel.put("slotTimeJitter", this.m_labReceivedSlotTimeDriftValueSlot1);
            this.m_oSlot0ParamsNameLabel.put("deviationOffset", this.m_labReceivedDeviationOffsetValueSlot1);
            this.m_oSlot1ParamsNameLabel.put("initialBerMeasurement", this.m_labBitErrorRateValueSlot2);
            this.m_oSlot1ParamsNameLabel.put("rssiBranchA", this.m_labReceivedSignalValueSlot2BranchA);
            this.m_oSlot1ParamsNameLabel.put("rssiBranchB", this.m_labReceivedSignalValueSlot2BranchB);
            this.m_oSlot1ParamsNameLabel.put("frequencyOffset", this.m_labReceivedFreqOffsetValueSlot2);
            this.m_oSlot1ParamsNameLabel.put("slotTimeOffset", this.m_labReceivedSlotTimeOffsetValueSlot2);
            this.m_oSlot1ParamsNameLabel.put("slotTimeJitter", this.m_labReceivedSlotTimeDriftValueSlot2);
            this.m_oSlot1ParamsNameLabel.put("deviationOffset", this.m_labReceivedDeviationOffsetValueSlot2);
            if (null != this.m_labReceivedSignalLblBranchB && null != this.m_labReceivedSlotTimeOffset && null != this.m_labReceivedSlotTimeDrift && null != this.m_labReceivedDeviationOffset) {
                this.m_labReceivedSignalLblBranchB.setToolTipText("Measured value of received signal strength level.");
                this.m_labReceivedSlotTimeOffset.setToolTipText("Measured value of received slot offset.");
                this.m_labReceivedSlotTimeDrift.setToolTipText("Measured value of received slot drift.");
                this.m_labReceivedDeviationOffset.setToolTipText("Measured value of received mod deviation offset.");
            } else {
                LOG.warn((Object)"Should not enter here!");
            }
        }
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridBagLayout());
        this.m_startBerMeasurementBtn = new JButton("Start BER Measurement");
        this.m_startBerMeasurementBtn.setName("Start BER Measurement");
        GridBagAdder.add((Container)jPanel4, (Component)this.m_startBerMeasurementBtn, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)3, (int)0, (int)0, (int)0, (int)0);
        this.m_startRssiMeasurementBtn = new JButton("Start RSSI Measurement");
        this.m_startRssiMeasurementBtn.setName("Start RSSI Measurement");
        GridBagAdder.add((Container)jPanel4, (Component)this.m_startRssiMeasurementBtn, (int)1, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)3, (int)20, (int)0, (int)0, (int)0);
        this.m_startRxTestBtn = new JButton("Start Receiver Test");
        this.m_startRxTestBtn.setName("Start Receiver Test");
        GridBagAdder.add((Container)jPanel4, (Component)this.m_startRxTestBtn, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)1, (int)10, (int)2, (int)3, (int)0, (int)0, (int)0, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel4, (int)0, (int)3, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)10, (int)10, (int)20, (int)0);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        this.m_saveLogBtn.setText("Start Log");
        this.m_saveLogBtn.setName("Start Log");
        GridBagAdder.add((Container)jPanel5, (Component)this.m_saveLogBtn, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)0, (int)0, (int)30, (int)10, (int)15, (int)0);
        GridBagAdder.add((Container)this, (Component)jPanel5, (int)0, (int)4, (double)0.0, (double)0.0, (int)1, (int)1, (int)17, (int)2, (int)0, (int)0, (int)0, (int)20, (int)0);
        this.m_saveLogBtn.setToolTipText("Starts/Stops the storing of event logs.");
        statusBarListener.registerComponent((Component)this.m_saveLogBtn, "Click this button to start/stop the storing of event logs.");
        statusBarListener.registerComponent(this.m_voPatternType, "Click and select one of the available pattern types.");
        this.m_labPatternType.setToolTipText("Pattern types.");
        statusBarListener.registerComponent((Component)this.m_voSamplePeriod, "Click and select length of time between report updates.");
        this.m_labSamplingPeriod.setToolTipText("Length of time between report updates.");
        statusBarListener.registerComponent((Component)this.m_startBerMeasurementBtn, "Click the button to start/stop BER reporting.");
        this.m_startBerMeasurementBtn.setToolTipText("Initiates or terminates BER measurement.");
        statusBarListener.registerComponent((Component)this.m_startRssiMeasurementBtn, "Click the button to start/stop RSSI reporting.");
        this.m_startRssiMeasurementBtn.setToolTipText("Starts/stops RSSI reporting.");
        jLabel.setToolTipText("Frequency to which the receiver is tuned.");
        statusBarListener.registerComponent((Component)this.m_startRxTestBtn, "Click the button to start Receiver Test.");
        this.m_startRxTestBtn.setToolTipText("Starts Receiver Test.");
        LOG.exit("buildScreen");
        return 1;
    }

    public void initialize() {
        LOG.enter("initialize");
        LOG.exit("initialize");
    }

    private void defaultBerRssiParameters() {
        LOG.enter("defaultBerRssi");
        for (CssServiceJLabel cssServiceJLabel : this.m_oSlot0ParamsNameLabel.values()) {
            cssServiceJLabel.setText(N_A);
        }
        for (CssServiceJLabel cssServiceJLabel : this.m_oSlot1ParamsNameLabel.values()) {
            cssServiceJLabel.setText(N_A);
        }
        LOG.exit("defaultBerRssi");
    }

    void updateGuiToServiceMode() {
        LOG.enter("updateGuiToServiceMode");
        this.m_voPatternType.setEnabled(true);
        this.m_voSamplePeriod.setEnabled(true);
        this.m_labBitErrorRateValueSlot1.setEnabled(true);
        if (!(Devices.isConvBrApplication((String)this.m_sAppHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.m_sAppHWCombination).booleanValue() || Devices.isIR3600Application((String)this.m_sAppHWCombination).booleanValue())) {
            this.m_labBitErrorRateValueSlot2.setEnabled(true);
        }
        this.m_startBerMeasurementBtn.setEnabled(true);
        this.m_startRssiMeasurementBtn.setEnabled(true);
        this.m_startRssiMeasurementBtn.setText("Start RSSI Measurement");
        this.m_startBerMeasurementBtn.setText("Start BER Measurement");
        if (!this.m_testMeasurement.m_astroTestPanel.isPatternsRunning()) {
            this.m_startRxTestBtn.setEnabled(true);
        } else {
            this.m_startRxTestBtn.setEnabled(false);
        }
        this.m_currentMode = 1;
        LOG.exit("updateGuiToServiceMode");
    }

    void updateGuiToNormalMode() {
        LOG.enter("updateGuiToNormalMode");
        this.m_voPatternType.setEnabled(false);
        this.m_voSamplePeriod.setEnabled(true);
        this.m_labBitErrorRateValueSlot1.setEnabled(false);
        if (!(Devices.isConvBrApplication((String)this.m_sAppHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.m_sAppHWCombination).booleanValue() || Devices.isIR3600Application((String)this.m_sAppHWCombination).booleanValue())) {
            this.m_labBitErrorRateValueSlot2.setEnabled(false);
        }
        this.m_startBerMeasurementBtn.setEnabled(false);
        this.m_startRssiMeasurementBtn.setEnabled(true);
        this.m_startRssiMeasurementBtn.setText("Start RSSI Measurement");
        this.m_startBerMeasurementBtn.setText("Start BER Measurement");
        this.m_startRxTestBtn.setEnabled(false);
        this.m_currentMode = 0;
        LOG.exit("updateGuiToNormalMode");
    }

    public boolean isRssiTestRunning() {
        boolean bl = true;
        LOG.enter("isRssiTestRunning");
        bl = this.m_startRssiMeasurementBtn.getText().equals("Stop RSSI Measurement");
        LOG.exit("isRssiTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    private void enableTestButtons() {
        LOG.enter("enableTestButtons");
        this.m_startBerMeasurementBtn.setEnabled(true);
        this.m_startRssiMeasurementBtn.setEnabled(true);
        this.m_startRxTestBtn.setEnabled(true);
        this.m_saveLogBtn.setEnabled(true);
        this.m_window.unlockWindow();
        this.m_window.setClosable(true);
        LOG.exit("enableTestButtons");
    }

    public boolean isRxTestRunning() {
        LOG.enter("isRxTestRunning");
        LOG.exit("isRxTestRunning", (Object)Boolean.toString(this.m_isRxTestRunning));
        return this.m_isRxTestRunning;
    }

    public boolean isRxTestNotRunning() {
        LOG.enter("isRxTestNotRunning");
        LOG.exit("isRxTestNotRunning", (Object)Boolean.toString(this.m_isRxTestRunning));
        return !this.m_isRxTestRunning;
    }

    public boolean isBer1031andP2() {
        LOG.enter("isBer1031andP2");
        boolean bl = this.getSelectedPatternType() == 5;
        LOG.exit("isBer1031andP2", (Object)bl);
        return bl;
    }

    public void setRxTestRunning() {
        LOG.enter("setRxTestRunning");
        this.m_startBerMeasurementBtn.setEnabled(false);
        this.m_startRssiMeasurementBtn.setEnabled(false);
        this.m_startRxTestBtn.setEnabled(false);
        this.m_saveLogBtn.setEnabled(false);
        if (null != this.m_cTimeDialog) {
            this.m_cTimeDialog.setVisible(false);
            this.m_cTimeDialog = null;
        }
        TimeDialog.WindowSettings windowSettings = new TimeDialog.WindowSettings();
        windowSettings.m_sProgressIndicator = RX_PROGRESS_STRING;
        windowSettings.m_nCounter = 20;
        windowSettings.m_sWindowName = RX_WINDOW_NAME;
        windowSettings.m_sOperationName = Popup.getMessageString((int)-630405);
        windowSettings.m_sOperationSummary = RX_OPERATION_TIMEOUT;
        this.m_cTimeDialog = new TimeDialog((Frame)EngineUtilities.getMainApplicationWindow(), windowSettings);
        this.m_cTimeDialog.setPostActionPerformer((TimeDialog.PostAction)this);
        this.m_window.setClosable(false);
        this.m_window.lockWindow();
        this.m_isRxTestRunning = true;
        this.m_cTimeDialog.start();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BrAstroBerAndRssiReportPanel.this.m_cTimeDialog.setVisible(true);
            }
        });
        LOG.exit("setRxTestRunning");
    }

    public void receiverTestResponse(int n) {
        LOG.enter("receiverTestResponse", new Object[]{Integer.toString(n)});
        LOG.exit("receiverTestResponse");
    }

    public void receiverTestRealTimeResponse(byte[] byArray) {
        LOG.enter("receiverTestRealTimeResponse", new Object[]{byArray});
        if (null != this.m_cTimeDialog) {
            try {
                int n = Convert.toInteger((byte[])byArray);
                switch (n) {
                    case 1: {
                        LOG.debug((Object)"receiverTestRealTimeResponse got response Passed");
                        this.m_cTimeDialog.stop(-630400, 1);
                        break;
                    }
                    case 2: {
                        LOG.debug((Object)"receiverTestRealTimeResponse got response Failed");
                        this.m_cTimeDialog.stop(-630406, 0);
                        break;
                    }
                    default: {
                        LOG.debug((Object)"receiverTestRealTimeResponse got response Unknown Error");
                        this.m_cTimeDialog.stop(-630404, 0);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                LOG.warn((Object)"receiverTestRealTimeResponse numeric exception was thrown", (Throwable)exception);
                this.m_cTimeDialog.stop(-630404, 0);
            }
        } else {
            LOG.warn((Object)"receiverTestRealTimeResponse m_cTimeDialog is null");
        }
        LOG.exit("receiverTestRealTimeResponse");
    }

    public void receiverTestErrorRealTimeResponse(byte[] byArray) {
        LOG.enter("receiverTestErrorRealTimeResponse", new Object[]{byArray});
        if (null != this.m_cTimeDialog) {
            try {
                int n = Convert.toInteger((byte[])byArray);
                this.showErrorForReceiverTest(n);
            }
            catch (Exception exception) {
                LOG.info((Object)"receiverTestErrorRealTimeResponse numeric exception was thrown", (Throwable)exception);
                this.m_cTimeDialog.stop(-630404, 0);
            }
        } else {
            LOG.warn((Object)"receiverTestErrorRealTimeResponse m_cTimeDialog is null");
        }
        LOG.exit("receiverTestErrorRealTimeResponse");
    }

    public void showErrorForReceiverTest(Integer n) {
        if (null == n) {
            LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Rx Invalid Mode");
            this.m_cTimeDialog.stop(-630404, 0);
        }
        switch (n) {
            case 1: {
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response No Error Present");
                break;
            }
            case 2: {
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Rx Invalid Mode");
                this.m_cTimeDialog.stop(-630401, 0);
                break;
            }
            case 3: {
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Rx Failure");
                this.m_cTimeDialog.stop(-630402, 0);
                break;
            }
            case 4: {
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Rx Inhibited");
                this.m_cTimeDialog.stop(-630403, 0);
                break;
            }
            case 5: {
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Unknown Error");
                this.m_cTimeDialog.stop(-630404, 0);
                break;
            }
            default: {
                if (DeviceErrorCodes.isInGeneralErrorRange(n)) {
                    LOG.error((Object)("realTimeUpdate - Error data: " + n));
                    this.m_testMeasurement.popupError(n);
                }
                LOG.debug((Object)"receiverTestErrorRealTimeResponse got response Unknown Error");
                this.m_cTimeDialog.stop(-630404, 0);
            }
        }
    }

    public boolean isBerTestRunning() {
        boolean bl = true;
        LOG.enter("isBerTestRunning");
        bl = this.m_startBerMeasurementBtn.getText().equals("Stop BER Measurement");
        LOG.exit("isBerTestRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isRssiTestNotRunning() {
        boolean bl = true;
        LOG.enter("isRssiTestNotRunning");
        bl = this.m_startRssiMeasurementBtn.getText().equals("Start RSSI Measurement");
        LOG.exit("isRssiTestNotRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public boolean isBerTestNotRunning() {
        boolean bl = true;
        LOG.enter("isBerTestNotRunning");
        bl = this.m_startBerMeasurementBtn.getText().equals("Start BER Measurement");
        LOG.exit("isBerTestNotRunning", (Object)Boolean.toString(bl));
        return bl;
    }

    public Object[] getNeededRssiMeasurementInfo() {
        Object[] objectArray = new Object[]{null};
        LOG.enter("getNeededRssiMeasurementInfo");
        this.m_window.lockWindow();
        try {
            int n = Integer.parseInt((String)this.m_voSamplePeriod.getSelectedItem());
            if (n >= -2147483 && n <= 2147483) {
                n *= 1000;
            } else {
                LOG.warn((Object)"Error: Integer overflow");
            }
            objectArray[0] = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn((Object)"getNeededRssiMeasurementInfo: Error converting number.");
        }
        LOG.exit("getNeededRssiMeasurementInfo", objectArray);
        return objectArray;
    }

    public void startRssiUpdate(int n, Integer n2) {
        LOG.enter("startRssiUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_nRunningTest = 2;
            this.m_startRssiMeasurementBtn.setText("Stop RSSI Measurement");
            this.m_voPatternType.setEnabled(false);
            this.m_voSamplePeriod.setEnabled(false);
            this.m_startBerMeasurementBtn.setEnabled(false);
            this.m_labBitErrorRateValueSlot1.setText(N_A);
            if (!(Devices.isConvBrApplication((String)this.m_sAppHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.m_sAppHWCombination).booleanValue() || Devices.isIR3600Application((String)this.m_sAppHWCombination).booleanValue())) {
                this.m_labBitErrorRateValueSlot2.setText(N_A);
            }
            this.m_startRxTestBtn.setEnabled(false);
            this.writeToLogFile("\n------------ RSSI Test Started ------------\n");
            this.writeToLogFile("\n Sampling Period Selection  :" + this.m_voSamplePeriod.getSelectedItem());
            this.writeToLogFile("\n Receiver Frequency (MHz)   :" + this.m_labReceivedFreqValue.getText());
            this.writeToLogFile("\n ---------- RSSI Real Time Data -----------\n");
        } else if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
            LOG.error((Object)("startRssiUpdate - Error data: " + n2));
            this.m_testMeasurement.popupError(n2);
        } else if (n == -393271) {
            this.m_testMeasurement.popupError(-327840);
        } else {
            this.m_testMeasurement.popupError(-327841);
        }
        LOG.exit("startRssiUpdate");
    }

    public void stopRssiUpdate(int n, Integer n2) {
        LOG.enter("stopRssiUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_nRunningTest = 0;
            this.m_startRssiMeasurementBtn.setText("Start RSSI Measurement");
            this.m_voSamplePeriod.setEnabled(true);
            if (this.m_currentMode == 1) {
                this.m_startBerMeasurementBtn.setEnabled(true);
                this.m_voPatternType.setEnabled(true);
                if (!this.m_testMeasurement.m_astroTestPanel.isPatternsRunning()) {
                    this.m_startRxTestBtn.setEnabled(true);
                }
            }
            this.defaultBerRssiParameters();
            this.writeToLogFile("\n ------------  RSSI Test Stopped -------------\n");
        } else if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
            LOG.error((Object)("updateReceiverDisable - Error data: " + n2));
            this.m_testMeasurement.popupError(n2);
        } else if (n == -393271) {
            this.m_testMeasurement.popupError(-327840);
        } else {
            this.m_testMeasurement.popupError(-327842);
        }
        LOG.exit("stopRssiUpdate");
    }

    public Object[] getNeededBerMeasurementInfo() {
        Object[] objectArray = new Object[]{null, null};
        LOG.enter("getNeededBerMeasurementInfo");
        this.m_window.lockWindow();
        try {
            int n = Integer.parseInt((String)this.m_voSamplePeriod.getSelectedItem());
            if (n >= -2147483 && n <= 2147483) {
                n *= 1000;
            } else {
                LOG.warn((Object)"Error: Integer overflow");
            }
            objectArray[0] = this.getSelectedPatternType();
            objectArray[1] = new Integer(n);
        }
        catch (NumberFormatException numberFormatException) {
            LOG.warn((Object)"getNeededBerMeasurementInfo: Error converting number.");
        }
        LOG.exit("getNeededBerMeasurementInfo", objectArray);
        return objectArray;
    }

    public void startBerUpdate(MessageIfc messageIfc) {
        int n = messageIfc.getError();
        Integer n2 = (Integer)messageIfc.getDataObject().getParameterValue("ErrorData");
        LOG.enter("startBerUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_nRunningTest = 1;
            this.m_startBerMeasurementBtn.setText("Stop BER Measurement");
            this.m_voPatternType.setEnabled(false);
            this.m_voSamplePeriod.setEnabled(false);
            this.m_startRssiMeasurementBtn.setEnabled(false);
            this.m_startRxTestBtn.setEnabled(false);
            this.writeToLogFile("\n ------------- BER Test Started ---------------\n");
            this.writeToLogFile("\n Sampling Period Selection  :" + this.m_voSamplePeriod.getSelectedItem());
            this.writeToLogFile("\n Receiver Frequency (MHz)   :" + this.m_labReceivedFreqValue.getText());
            this.writeToLogFile("\n Pattern Type             :" + this.m_voPatternType.getSelectedItem());
            this.writeToLogFile("\n ------------- BER Real Time Data ------------\n");
        } else if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
            LOG.error((Object)("startBerUpdate - Error data: " + n2));
            this.m_testMeasurement.popupError(n2);
        } else if (n == -393271) {
            this.m_testMeasurement.popupError(-393271);
        } else {
            this.m_testMeasurement.popupError(-327843);
        }
        LOG.exit("startBerUpdate");
    }

    public void stopBerUpdate(MessageIfc messageIfc) {
        int n = messageIfc.getError();
        Integer n2 = (Integer)messageIfc.getDataObject().getParameterValue("ErrorData");
        LOG.enter("stopBerUpdate", new Object[]{Integer.toString(n)});
        this.m_window.unlockWindow();
        if (n == 0) {
            this.m_nRunningTest = 0;
            this.m_startBerMeasurementBtn.setText("Start BER Measurement");
            this.m_voPatternType.setEnabled(true);
            this.m_voSamplePeriod.setEnabled(true);
            this.m_startRssiMeasurementBtn.setEnabled(true);
            this.defaultBerRssiParameters();
            if (!this.m_testMeasurement.m_astroTestPanel.isPatternsRunning()) {
                this.m_startRxTestBtn.setEnabled(true);
            }
            this.writeToLogFile("\n -------------  BER Test Stopped ------------\n");
        } else if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
            LOG.error((Object)("stopBerUpdate - Error data: " + n2));
            this.m_testMeasurement.popupError(n2);
        } else if (n == -393271) {
            this.m_testMeasurement.popupError(-393271);
        } else {
            this.m_testMeasurement.popupError(-327844);
        }
        LOG.exit("stopBerUpdate");
    }

    private Integer getSelectedPatternType() {
        LOG.enter("getSelectedPatternType");
        Integer n = 1;
        Object object = null;
        String string = null;
        object = this.m_voPatternType.getSelectedItem();
        string = object.toString();
        Set<Map.Entry<Integer, String>> set = TESTPATTERNSPAIRS.entrySet();
        for (Map.Entry<Integer, String> entry : set) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            n = entry.getKey();
            break;
        }
        LOG.exit("getSelectedPatternType", (Object)n);
        return n;
    }

    public void updateRxFreq(int n, Integer[] integerArray) {
        LOG.enter("updateRxFreq", new Object[]{Integer.toString(n), integerArray});
        if (n == 0) {
            try {
                int n2 = integerArray[0];
                double d = (double)n2 / 1000000.0;
                this.m_labReceivedFreqValue.setText(String.valueOf(d));
            }
            catch (NumberFormatException numberFormatException) {
                LOG.warn((Object)"Floating point conversion Exception in method updateRxFreq", (Throwable)numberFormatException);
            }
        } else {
            LOG.warn((Object)("Got Error g_error = " + n));
            this.m_labReceivedFreqValue.setText("Error!");
        }
        LOG.exit("updateRxFreq");
    }

    public void writeBerParams() {
        LOG.enter("writeBerParams");
        this.writeToLogFile("\n----------  BER Test Started -----------\n");
        this.writeToLogFile("\n Pattern Type:" + this.m_voPatternType.getSelectedItem());
        this.writeToLogFile("\n Sampling Period Selection:" + this.m_voSamplePeriod.getSelectedItem());
        this.writeToLogFile("\n\n-------------  BER Data ----------------\n");
        LOG.exit("writeBerParams");
    }

    public void writeRssiParams() {
        LOG.enter("writeRssiParams");
        this.writeToLogFile("\n----------  RSSI Test Started -----------\n");
        this.writeToLogFile("\n Sampling Period Selection:" + this.m_voSamplePeriod.getSelectedItem());
        this.writeToLogFile("\n-------------  RSSI Data ----------------\n");
        LOG.exit("writeRssiParams");
    }

    private void logToFile() {
        File file = null;
        LOG.enter("logToFile");
        if ("Start Log".equals(this.m_saveLogBtn.getText())) {
            JFileChooser jFileChooser = new JFileChooser(PathConstants.CSS_LOGS_CHAIN.toString());
            int n = jFileChooser.showSaveDialog((Component)this.m_window);
            if (n == 0 && CSSUtilities.isValidLogFile((File)(file = jFileChooser.getSelectedFile()), (ErrorPopup)errorPopup)) {
                try {
                    this.m_log = new Logger(file);
                    Date date = new Date();
                    String string = m_formatter.format(date);
                    this.m_log.write("START LOG TIME : " + string + "\n");
                    this.m_log.flush();
                    this.m_saveLogBtn.setText("Stop Log");
                    this.startWriteToFile();
                }
                catch (IOException iOException) {
                    LOG.info((Object)"Unable to create log file.", (Throwable)iOException);
                    this.m_testMeasurement.popupError(-327859);
                }
                catch (Exception exception) {
                    LOG.info((Object)"Unable to create log file.", (Throwable)exception);
                    this.m_testMeasurement.popupError(-327860);
                }
            }
        } else {
            try {
                this.closeLogFile();
            }
            catch (Exception exception) {
                LOG.info((Object)"Unable to close log file.", (Throwable)exception);
            }
        }
        LOG.exit("logToFile");
    }

    private void startWriteToFile() {
        LOG.enter("startWriteToFile");
        this.writeToLogFile("ASTRO BIT ERROR RATE AND RECEIVED SIGNAL STRENGTH LOG\n");
        this.writeToLogFile("-----------------------------------------------------\n");
        if (this.isBerTestRunning()) {
            this.writeBerParams();
        } else if (this.isRssiTestRunning()) {
            this.writeRssiParams();
        }
        LOG.exit("startWriteToFile");
    }

    private void writeToLogFile(String string) {
        LOG.enter("writeToLogFile", new Object[]{string});
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                this.m_log.write(string);
            }
            catch (IOException iOException) {
                LOG.info((Object)"Could not write to file.", (Throwable)iOException);
                errorPopup.display(-327859);
                this.m_saveLogBtn.setText("Start Log");
            }
        }
        LOG.exit("writeToLogFile");
    }

    public boolean isLogFileClosed() {
        boolean bl = true;
        LOG.enter("isLogFileClosed");
        bl = this.m_log == null ? true : !this.m_log.isLogEnabled();
        LOG.exit("isLogFileClosed");
        return bl;
    }

    public void closeLogFile() {
        LOG.enter("closeLogFile");
        if (this.m_log != null && this.m_log.isLogEnabled()) {
            try {
                Date date = new Date();
                String string = m_formatter.format(date);
                this.m_log.write("\n=======================================================\n");
                this.m_log.write("STOP LOG TIME :  " + string + "\n");
                this.m_log.close();
            }
            catch (IOException iOException) {
                LOG.warn((Object)"Rssi and Ber: closeLogFile: Could not close file.");
                errorPopup.display(-327859);
            }
            this.m_saveLogBtn.setText("Start Log");
        }
        LOG.exit("closeLogFile");
    }

    public void PerformPostAction() {
        LOG.enter("PerformPostAction");
        this.enableTestButtons();
        this.m_isRxTestRunning = false;
        LOG.exit("PerformPostAction");
    }

    public boolean isFdmaTypeTransmitted() {
        LOG.enter("sFdmaTypeTransmitted");
        boolean bl = false;
        Object object = this.m_voPatternType.getSelectedItem();
        String string = object.toString();
        for (int i = 0; i < this.m_sFdmaTypePatterns.length; ++i) {
            if (this.m_sFdmaTypePatterns[i].indexOf(string) == -1) continue;
            bl = true;
            break;
        }
        LOG.exit("sFdmaTypeTransmitted");
        return bl;
    }

    public void updateBerRssiParams(FspRealTimeDataObject fspRealTimeDataObject) {
        LOG.enter("updateBerRssiParams", new Object[]{fspRealTimeDataObject});
        CssServiceJLabel cssServiceJLabel = null;
        int n = 0;
        String string = null;
        try {
            n = Convert.toInteger((byte[])((byte[])fspRealTimeDataObject.getValue("logicalChannelNumber")));
            for (int i = 0; i < fspRealTimeDataObject.getSize(); ++i) {
                string = fspRealTimeDataObject.getName(i);
                if (0 == n || 255 == n) {
                    cssServiceJLabel = this.m_oSlot0ParamsNameLabel.get(string);
                } else if (1 == n) {
                    cssServiceJLabel = this.m_oSlot1ParamsNameLabel.get(string);
                } else {
                    LOG.warn((Object)"updateBerRssiParams - Should not enter here");
                }
                if (null != cssServiceJLabel) {
                    String string2 = Convert.toInteger((byte[])((byte[])fspRealTimeDataObject.getValue(string))).toString();
                    cssServiceJLabel.setText(string2, n, this.m_testMeasurement.isMsbrIsr(), this.m_testMeasurement.getReceiveOperations(), this.m_nRunningTest, this.getSelectedPatternType());
                }
                if (8 != fspRealTimeDataObject.getOpCode()) continue;
                int n2 = Convert.toInteger((byte[])((byte[])fspRealTimeDataObject.getValue("receiverStatus")));
                this.m_testMeasurement.receiverStatusRealTimeResponse(n2);
            }
        }
        catch (NotFoundException notFoundException) {
            LOG.error((Object)"updateBerRssiParams", (Throwable)notFoundException);
        }
        LOG.exit("updateBerRssiParams");
    }

    static {
        TESTPATTERNSPAIRS.put(new Integer(1), V_25_TEXT);
        TESTPATTERNSPAIRS.put(new Integer(2), PROJECT_25_TEXT);
        TESTPATTERNSPAIRS.put(new Integer(5), P2_TEST_TONE_1031_HZ_TEXT);
        m_formatter = new SimpleDateFormat("yyyy-MM-dd/HH:mm:ss");
        errorPopup = new ErrorPopup();
        LOG = CssLogger.getCssLogger(BrAstroBerAndRssiReportPanel.class);
    }

    class BitErrorRateValueLbl
    extends CssServiceJLabel {
        public BitErrorRateValueLbl(String string) {
            super(string);
            LOG.enter("ReceivedSignalValueLbl");
            LOG.exit("ReceivedSignalValueLbl");
        }

        String calculateValue(String string, int n, boolean bl, int n2, int n3, int n4) {
            String string2;
            LOG.enter("calculateValue", new Object[]{string, n, bl, n2, n3, n4});
            try {
                int n5 = Integer.parseInt(string);
                float f = (float)n5 / 1000.0f;
                string2 = 65535 == n5 ? BrAstroBerAndRssiReportPanel.BER_0xFFFF : String.valueOf(f);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = BrAstroBerAndRssiReportPanel.N_A;
            }
            LOG.exit("calculateValue", (Object)string2);
            return string2;
        }

        @Override
        public void setText(String string, int n, boolean bl, int n2, int n3, int n4) {
            LOG.enter("setText", new Object[]{string, n, bl, n2, n3, n4});
            String string2 = this.calculateValue(string, n, bl, n2, n3, n4);
            super.setText(string2);
            Date date = new Date();
            String string3 = m_formatter.format(date);
            BrAstroBerAndRssiReportPanel.this.writeToLogFile("\n" + string3 + " " + BrAstroBerAndRssiReportPanel.this.m_labBitErrorRate.getText() + " logical slot nr: " + n + ":\t" + string2);
            LOG.exit("setText");
        }
    }

    class ReceivedSlotTimeDriftModOffsetValueLbl
    extends CssServiceJLabel {
        private CssServiceJLabel voName;

        public ReceivedSlotTimeDriftModOffsetValueLbl(String string) {
            super(string);
            LOG.enter("ReceivedSlotTimeDriftModOffsetValueLbl");
            LOG.exit("ReceivedSlotTimeDriftModOffsetValueLbl");
        }

        void setFieldName(CssServiceJLabel cssServiceJLabel) {
            LOG.enter("setFieldName", new Object[]{cssServiceJLabel});
            this.voName = cssServiceJLabel;
            LOG.exit("setFieldName");
        }

        String calculateValue(String string, int n, boolean bl, int n2, int n3, int n4) {
            String string2;
            LOG.enter("calculateValue", new Object[]{string, n, bl, n2, n3, n4});
            try {
                int n5 = Integer.parseInt(string);
                string2 = 65535 == n5 ? (2 == n3 ? (0 == n || 1 == n ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A) : (5 == n4 ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A)) : String.valueOf(n5 - 6000);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = BrAstroBerAndRssiReportPanel.N_A;
            }
            LOG.exit("calculateValue", (Object)string2);
            return string2;
        }

        @Override
        public void setText(String string, int n, boolean bl, int n2, int n3, int n4) {
            LOG.enter("setText", new Object[]{string, n, bl, n2, n3, n4});
            String string2 = this.calculateValue(string, n, bl, n2, n3, n4);
            super.setText(string2);
            Date date = new Date();
            String string3 = m_formatter.format(date);
            BrAstroBerAndRssiReportPanel.this.writeToLogFile("\n" + string3 + " " + this.voName.getText() + " logical slot nr: " + n + ":\t" + string2);
            LOG.exit("setText");
        }
    }

    class ReceivedSlotTimeOffsetValueLbl
    extends CssServiceJLabel {
        public ReceivedSlotTimeOffsetValueLbl(String string) {
            super(string);
            LOG.enter("ReceivedSlotTimeOffsetValueLbl");
            LOG.exit("ReceivedSlotTimeOffsetValueLbl");
        }

        String calculateValue(String string, int n, boolean bl, int n2, int n3, int n4) {
            String string2;
            LOG.enter("calculateValue", new Object[]{string, n, bl, n2, n3, n4});
            try {
                int n5 = Integer.parseInt(string);
                string2 = null;
                if (65535 == n5) {
                    if (2 == n3) {
                        string2 = !bl ? BrAstroBerAndRssiReportPanel.N_A : (0 == n || 1 == n ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A);
                    } else if (1 == n4 || 2 == n4) {
                        string2 = BrAstroBerAndRssiReportPanel.N_A;
                    } else if (5 == n4) {
                        string2 = "Invalid";
                    }
                } else {
                    string2 = String.valueOf(n5 - 6000);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string2 = BrAstroBerAndRssiReportPanel.N_A;
            }
            LOG.exit("calculateValue", (Object)string2);
            return string2;
        }

        @Override
        public void setText(String string, int n, boolean bl, int n2, int n3, int n4) {
            LOG.enter("setText", new Object[]{string, n, bl, n2, n3, n4});
            String string2 = this.calculateValue(string, n, bl, n2, n3, n4);
            super.setText(string2);
            Date date = new Date();
            String string3 = m_formatter.format(date);
            BrAstroBerAndRssiReportPanel.this.writeToLogFile("\n" + string3 + " " + BrAstroBerAndRssiReportPanel.this.m_labReceivedSlotTimeOffset.getText() + " logical slot nr: " + n + ":\t" + string2);
            LOG.exit("setText");
        }
    }

    class ReceivedFreqOffsetValueLbl
    extends CssServiceJLabel {
        public ReceivedFreqOffsetValueLbl(String string) {
            super(string);
            LOG.enter("ReceivedFreqOffsetValueLbl");
            LOG.exit("ReceivedFreqOffsetValueLbl");
        }

        String calculateValue(String string, int n, boolean bl, int n2, int n3, int n4) {
            String string2;
            LOG.enter("calculateValue", new Object[]{string, n, bl, n2, n3, n4});
            try {
                int n5 = Integer.parseInt(string);
                string2 = 65535 == n5 ? (2 == n3 ? "Invalid" : (0 == n || 255 == n ? "Invalid" : (5 == n4 ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A))) : String.valueOf(n5 - 6000);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = BrAstroBerAndRssiReportPanel.N_A;
            }
            LOG.exit("calculateValue", (Object)string2);
            return string2;
        }

        @Override
        public void setText(String string, int n, boolean bl, int n2, int n3, int n4) {
            LOG.enter("setText", new Object[]{string, n, bl, n2, n3, n4});
            String string2 = this.calculateValue(string, n, bl, n2, n3, n4);
            super.setText(string2);
            Date date = new Date();
            String string3 = m_formatter.format(date);
            BrAstroBerAndRssiReportPanel.this.writeToLogFile("\n" + string3 + " " + BrAstroBerAndRssiReportPanel.this.m_labReceivedFreqOffset.getText() + " logical slot nr: " + n + ":\t" + string2);
            LOG.exit("setText");
        }
    }

    class ReceivedSignalValueLbl
    extends CssServiceJLabel {
        String sBranchName;

        public ReceivedSignalValueLbl(String string, String string2) {
            super(string);
            this.sBranchName = null;
            LOG.enter("ReceivedSignalValueLbl");
            this.sBranchName = string2;
            LOG.exit("ReceivedSignalValueLbl");
        }

        String calculateValue(String string, int n, boolean bl, int n2, int n3, int n4, String string2, String string3) {
            String string4;
            LOG.enter("calculateValue", new Object[]{string, n, bl, n2, n3, n4, string2, string3});
            try {
                int n5 = Integer.parseInt(string);
                string4 = null;
                if (65535 == n5) {
                    if (2 == n3) {
                        string4 = bl ? (BrAstroBerAndRssiReportPanel.BRANCH_A.equalsIgnoreCase(this.sBranchName) ? "Invalid" : (1 == n2 ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A)) : "Invalid";
                    } else if (bl) {
                        if (1 == n4 || 2 == n4) {
                            string4 = 0 == n || 255 == n ? (BrAstroBerAndRssiReportPanel.BRANCH_A.equalsIgnoreCase(this.sBranchName) ? (2 == n2 ? "Invalid" : (!string3.equalsIgnoreCase(BrAstroBerAndRssiReportPanel.N_A) && !string3.equalsIgnoreCase("Invalid") ? BrAstroBerAndRssiReportPanel.N_A : "Invalid")) : (2 == n2 ? BrAstroBerAndRssiReportPanel.N_A : (!string2.equalsIgnoreCase(BrAstroBerAndRssiReportPanel.N_A) && !string2.equalsIgnoreCase("Invalid") ? BrAstroBerAndRssiReportPanel.N_A : "Invalid"))) : BrAstroBerAndRssiReportPanel.N_A;
                        } else if (5 == n4) {
                            string4 = BrAstroBerAndRssiReportPanel.BRANCH_A.equalsIgnoreCase(this.sBranchName) ? "Invalid" : (1 == n2 ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A);
                        }
                    } else {
                        string4 = BrAstroBerAndRssiReportPanel.BRANCH_A.equalsIgnoreCase(this.sBranchName) ? "Invalid" : BrAstroBerAndRssiReportPanel.N_A;
                    }
                } else {
                    float f = (float)n5 / -100.0f;
                    string4 = String.valueOf(f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                string4 = BrAstroBerAndRssiReportPanel.N_A;
            }
            LOG.exit("calculateValue", (Object)string4);
            return string4;
        }

        @Override
        public void setText(String string, int n, boolean bl, int n2, int n3, int n4) {
            LOG.enter("setText", new Object[]{string, n, bl, n2, n3, n4});
            String string2 = "";
            String string3 = "";
            if (BrAstroBerAndRssiReportPanel.this.m_labReceivedSignalValueSlot1BranchA != null) {
                string2 = BrAstroBerAndRssiReportPanel.this.m_labReceivedSignalValueSlot1BranchA.getText();
            }
            if (BrAstroBerAndRssiReportPanel.this.m_labReceivedSignalValueSlot1BranchB != null) {
                string3 = BrAstroBerAndRssiReportPanel.this.m_labReceivedSignalValueSlot1BranchB.getText();
            }
            String string4 = this.calculateValue(string, n, bl, n2, n3, n4, string2, string3);
            super.setText(string4);
            Date date = new Date();
            String string5 = m_formatter.format(date);
            super.setText(string4);
            BrAstroBerAndRssiReportPanel.this.writeToLogFile("\n" + string5 + " " + "Received Signal Strength " + this.sBranchName + " logical slot nr: " + n + ":\t" + string4);
            LOG.exit("enclosing_method");
        }
    }

    public class GetCurrentRxFrequency
    extends Rule {
        private final String sGetReceiverFrequency = "sGetReceiverFrequency";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sGetReceiverFrequency", Byte[].class);
            message.setProtocolKey(2212);
            LOG.exit("getMessage");
            return message;
        }

        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            LOG.exit("condition", (Object)true);
            return !BrAstroBerAndRssiReportPanel.this.m_testMeasurement.isMsbrIsr();
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Current Receiver Frequency");
            } else if (null != messageIfc) {
                byte[] byArray = (byte[])messageIfc.getParameterValue("sGetReceiverFrequency");
                if (null != byArray) {
                    Integer n2 = Convert.toInteger((byte[])byArray);
                    Double d = (double)n2.intValue() / 1000000.0;
                    String string = Double.toString(d);
                    BrAstroBerAndRssiReportPanel.this.m_labReceivedFreqValue.setText(string);
                } else {
                    LOG.error((Object)"update - null message parameters from FSP packet");
                }
            } else {
                LOG.error((Object)"update - null message from FSP packet");
            }
            LOG.exit("update");
            return true;
        }
    }

    class ButtonActionEvent
    implements ActionListener {
        ButtonActionEvent() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BrAstroBerAndRssiReportPanel.this.m_saveLogBtn) {
                BrAstroBerAndRssiReportPanel.this.logToFile();
            }
        }
    }
}

