/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.service.Convert;
import css.core.service.Message;
import css.core.service.MessageIfc;
import css.core.service.NotFoundException;
import css.core.service.RealTimeDataObject;
import css.core.service.RealTimeUpdaterIfc;
import css.core.service.Rule;
import css.core.service.RuleIfc;
import css.core.service.SessionIfc;
import css.core.util.CssLogger;
import css.core.util.component.CSSComboItem;
import css.core.util.component.GenericListener;
import css.device.common.screens.GenericScreen;
import css.device.platform.summit.screens.alignment.CarrierSquelchTabGUI;
import css.device.platform.summit.screens.alignment.SummitAlignmentScreen;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import pnm.ui.UIInternalFrame;

public class CarrierSquelchTab
extends CarrierSquelchTabGUI
implements RealTimeUpdaterIfc {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(CarrierSquelchTab.class);
    private GenericScreen m_screen;
    public StringBuffer m_sErrors = new StringBuffer("");
    private boolean m_bInitialization = false;
    private static final String UNABLE_TO_GET = "Unable to get ";
    private static final String UNABLE_TO_SET = "Unable to set ";
    private static final String FROM_THE_DEVICE = " value from the device.";
    private static final String CSQ_READ_THRESHOLD_ERROR = "Unable to get CSQ Set Level value from the device.";
    private static final String CSQ_READ_RX_QUALIFIER_ERROR = "Unable to get Current Receiver Qualifier value from the device.";
    private static final String CSQ_READ_CHANNEL_BANDWIDTH_ERROR = "Unable to get Current Channel Bandwidth value from the device.";
    private static final String CSQ_READ_RECEIVER_FREQUENCY_ERROR = "Unable to get Current Receiver Frequency value from the device.";
    private static final String CSQ_SAVE_THRESHOLD_ERROR = "Unable to save CSQ Set Level value to the device.";
    private static final String CSQ_WRITE_THRESHOLD_ERROR = "Unable to update Current CSQ Set Level value.";
    private static final String CSQ_WRITE_CHANNEL_BANDWIDTH_125_ERROR = "Unable to set Channel Bandwidth to 12.5 kHz.";
    private static final String CSQ_WRITE_CHANNEL_BANDWIDTH_25_ERROR = "Unable to set Channel Bandwidth to 25 kHz.";
    private static final String SPKR_SET_VOLUME_ERROR = "Unable to set Speaker Volume value.";
    private static final String SPKR_SET_RXQUALIFIERS_ERROR = "Unable to set Analog RX Qualifier.";
    private static final String SINAD_START_ERROR = "Unable to Start SINAD process.";
    private static final String SINAD_STOP_ERROR = "Unable to Stop SINAD process.";
    private static final String CSQ_STATE_START_ERROR = "Unable to Start CSQ State process.";
    private static final String CSQ_STATE_STOP_ERROR = "Unable to Stop CSQ State process.";
    private static final int INFO_CSQ = 0;
    private static final int INFO_ON = 1;
    private static final int INFO_NORMAL = 2;
    private static final String INFO_125 = "12.5 kHz";
    private static final String INFO_25 = "25 kHz";
    public GenericListener m_oGenericListener = new GenericListener();
    private static final int RX_QUAL_CSQ = 0;
    private static final int RX_QUAL_ON = 1;
    private static final int RX_QUAL_NORMAL = 2;
    private static final double MIN_SINAD_VALUE = 0.0;
    private static final double MAX_SINAD_VALUE = 40.0;
    private static DefaultComboBoxModel<CSSComboItem> m_RxQualifiersModel = new DefaultComboBoxModel();

    private void fillRxQualifiersModel() {
        m_RxQualifiersModel.addElement(new CSSComboItem(Integer.valueOf(0), "CSQ"));
        m_RxQualifiersModel.addElement(new CSSComboItem(Integer.valueOf(1), "Open Rx"));
        if (!((SummitAlignmentScreen)this.m_screen).isMsBR3600() && !((SummitAlignmentScreen)this.m_screen).isIR3600()) {
            m_RxQualifiersModel.addElement(new CSSComboItem(Integer.valueOf(2), "Rx Qualifiers"));
        }
    }

    public CarrierSquelchTab(GenericScreen genericScreen) {
        LOG.enter("CarrierSquelchTab");
        this.m_screen = genericScreen;
        this.fillRxQualifiersModel();
        this.setRxQualifiersModel(m_RxQualifiersModel);
        this.getVolumeControlTextField().addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CarrierSquelchTab.this.validateSpeakerVolumeValue();
                }
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.getVolumeControlTextField().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (!focusEvent.isTemporary()) {
                    CarrierSquelchTab.this.validateSpeakerVolumeValue();
                }
            }
        });
        LOG.exit("CarrierSquelchTab");
    }

    private void validateSpeakerVolumeValue() {
        try {
            int n = Integer.parseInt(this.getVolumeControlTextField().getText());
            if (n < 0 || 20 < n) {
                this.m_screen.popupError("Only numeric values between 0 and 20 are allowed in the Local Speaker Volume field.");
                this.getVolumeControlTextField().setText(String.valueOf(this.getSpinComponent().getModel().getValue()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_screen.popupError("Only numeric values between 0 and 20 are allowed in the Local Speaker Volume field.");
            this.getVolumeControlTextField().setText(String.valueOf(this.getSpinComponent().getModel().getValue()));
        }
    }

    private JFormattedTextField getVolumeControlTextField() {
        return ((JSpinner.DefaultEditor)this.getSpinComponent().getEditor()).getTextField();
    }

    public void setInitialization(boolean bl) {
        if (bl) {
            this.m_bInitialization = bl;
            this.m_sErrors = new StringBuffer("");
        }
    }

    protected void processGetThresholdRules(SessionIfc sessionIfc) {
        UIInternalFrame uIInternalFrame = this.getWindow();
        if (null != uIInternalFrame) {
            uIInternalFrame.lockWindow();
        }
        Object object = new GetThresholdLevel();
        object.process(sessionIfc);
        object = new ShowErrorMessageRule();
        object.process(sessionIfc);
    }

    /*
     * Unable to fully structure code
     */
    public void realTimeUpdate(RealTimeDataObject var1_1) {
        var2_2 = null;
        var3_3 = var1_1;
        var5_4 = new byte[4];
        CarrierSquelchTab.LOG.enter("realTimeUpdate", new Object[]{var1_1});
        if (var3_3 != null) {
            try {
                if (var3_3.getError() != 0) ** GOTO lbl35
                for (var4_5 = 0; var4_5 < var3_3.getSize(); ++var4_5) {
                    var2_2 = var3_3.getName(var4_5);
                    if (var2_2.equalsIgnoreCase("sCsqSINADValue")) {
                        var5_4 = (byte[])var3_3.getValue(var2_2);
                        if (null != var5_4) {
                            var6_6 = Convert.toInteger((byte[])var5_4);
                            var7_8 = (double)var6_6.intValue() / 10.0;
                            if (var7_8 >= 0.0 && var7_8 <= 40.0) {
                                var8_9 = Double.toString(var7_8);
                                this.setSINADValue(var8_9);
                                continue;
                            }
                            this.setSINADValue("UNKNOWN");
                            continue;
                        }
                        CarrierSquelchTab.LOG.error((Object)"update - null message parameters from FSP packet");
                        continue;
                    }
                    if (!var2_2.equalsIgnoreCase("sCsqStateValue")) continue;
                    var5_4 = (byte[])var3_3.getValue(var2_2);
                    if (null != var5_4) {
                        this.updateCSQState(Convert.toInteger((byte[])var5_4));
                        continue;
                    }
                    CarrierSquelchTab.LOG.error((Object)"update - null message parameters from FSP packet");
                }
            }
            catch (NotFoundException var6_7) {
                CarrierSquelchTab.LOG.info((Object)"Object not found", (Throwable)var6_7);
            }
        } else {
            CarrierSquelchTab.LOG.info((Object)"The Real Time Data Object Was null ");
        }
lbl35:
        // 4 sources

        CarrierSquelchTab.LOG.exit("realTimeUpdate");
    }

    public void setServiceMode(boolean bl) {
        this.setCSQGrayed(!bl);
    }

    public class CSQState_Stop
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            int n = CarrierSquelchTab.this.getCSQStateMode();
            boolean bl = n != 2;
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5225);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_STATE_STOP_ERROR);
            } else {
                CarrierSquelchTab.this.updateCSQState(2);
                CarrierSquelchTab.this.setCSQStateMode(2);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class CSQState_Start
    extends Rule {
        public boolean condition(SessionIfc sessionIfc) {
            LOG.enter("condition", new Object[]{sessionIfc});
            int n = CarrierSquelchTab.this.getCSQStateMode();
            boolean bl = n != 1;
            LOG.exit("condition", (Object)bl);
            return bl;
        }

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            CarrierSquelchTab.this.updateCSQState(2);
            Message message = new Message();
            message.setProtocolKey(5224);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_STATE_START_ERROR);
            } else {
                CarrierSquelchTab.this.setCSQStateMode(1);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SINADMeasurement_Disable
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            switch (CarrierSquelchTab.this.getSINADMode()) {
                case 2: {
                    break;
                }
                case 1: {
                    message.setProtocolKey(5222);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                switch (CarrierSquelchTab.this.getSINADMode()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.SINAD_STOP_ERROR);
                    }
                }
            } else {
                switch (CarrierSquelchTab.this.getSINADMode()) {
                    case 2: {
                        break;
                    }
                    case 1: {
                        CarrierSquelchTab.this.setSINADMode(2);
                        CarrierSquelchTab.this.setSINADValue(CarrierSquelchTabGUI.STOP_SINAD_VALUE);
                    }
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SINADMeasurement
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            switch (CarrierSquelchTab.this.getSINADMode()) {
                case 2: {
                    message.setProtocolKey(5221);
                    break;
                }
                case 1: {
                    message.setProtocolKey(5222);
                }
            }
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                switch (CarrierSquelchTab.this.getSINADMode()) {
                    case 2: {
                        CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.SINAD_START_ERROR);
                        break;
                    }
                    case 1: {
                        CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.SINAD_STOP_ERROR);
                    }
                }
            } else {
                switch (CarrierSquelchTab.this.getSINADMode()) {
                    case 1: {
                        CarrierSquelchTab.this.setSINADMode(2);
                        CarrierSquelchTab.this.setSINADValue(CarrierSquelchTabGUI.STOP_SINAD_VALUE);
                        break;
                    }
                    case 2: {
                        CarrierSquelchTab.this.setSINADMode(1);
                        CarrierSquelchTab.this.setSINADValue("WAIT");
                    }
                }
            }
            LOG.exit("update");
            return true;
        }
    }

    public class ShowErrorMessageRule
    implements RuleIfc {
        public boolean process(SessionIfc sessionIfc) {
            LOG.enter("showErrorMessage");
            UIInternalFrame uIInternalFrame = CarrierSquelchTab.this.getWindow();
            if (null != uIInternalFrame) {
                uIInternalFrame.unlockWindow();
            }
            if (CarrierSquelchTab.this.m_sErrors.length() > 0) {
                if (!CarrierSquelchTab.this.m_bInitialization) {
                    CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.this.m_sErrors.toString());
                } else {
                    CarrierSquelchTab.this.m_screen.popupError("Unable to read:" + CarrierSquelchTab.this.m_sErrors.toString());
                }
                CarrierSquelchTab.this.m_sErrors = new StringBuffer("");
            }
            LOG.exit("showErrorMessage");
            return false;
        }
    }

    public class SetRxQualifiers_Rule
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = null;
            int n = -1;
            switch (CarrierSquelchTab.this.getRxQualifiersValue().getCode()) {
                case 0: {
                    n = 5204;
                    break;
                }
                case 1: {
                    n = 5205;
                    break;
                }
                case 2: {
                    n = 5217;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            if (n > -1) {
                message = new Message();
                message.setProtocolKey(n);
            }
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 != n) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.SPKR_SET_RXQUALIFIERS_ERROR);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetSpeakerVolume_Rule
    extends Rule {
        private final String sSetSpeakerVolume = "setSpeakerVolumeCSQ";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("setSpeakerVolumeCSQ", Byte.class, (Object)CarrierSquelchTab.this.getSpeakerVolumeValue());
            message.setProtocolKey(5210);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (0 != n) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.SPKR_SET_VOLUME_ERROR);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetThresholdLevel
    extends Rule {
        private final String sCsqSetThresholdLevel = "sCsqSetThresholdLevel";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqSetThresholdLevel", Byte.class, (Object)CarrierSquelchTab.this.getThresholdValue());
            message.setProtocolKey(5207);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_WRITE_THRESHOLD_ERROR);
                CarrierSquelchTab.this.updateThresholdLevel(CarrierSquelchTab.this.getStoredCSQSetLevel());
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SaveThresholdLevel
    extends Rule {
        private final String sCsqSaveThresholdLevel = "sCsqSaveThresholdLevel";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqSaveThresholdLevel", Byte.class, (Object)CarrierSquelchTab.this.getThresholdValue());
            message.setProtocolKey(5209);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Threshold Level");
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_SAVE_THRESHOLD_ERROR);
            } else {
                CarrierSquelchTab.this.processGetThresholdRules(sessionIfc);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetThresholdLevel
    extends Rule {
        private final String sCsqGetThresholdLevel = "sCsqGetThresholdLevel";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqGetThresholdLevel", Byte.class);
            message.setProtocolKey(5206);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Threshold Level");
                if (!CarrierSquelchTab.this.m_bInitialization) {
                    CarrierSquelchTab.this.m_sErrors.append(CarrierSquelchTab.CSQ_READ_THRESHOLD_ERROR);
                } else {
                    CarrierSquelchTab.this.m_sErrors.append("\n- CSQ Set Level");
                }
                CarrierSquelchTab.this.updateThresholdLevel(CarrierSquelchTab.this.getStoredCSQSetLevel());
            } else if (null != messageIfc) {
                Byte by = (Byte)messageIfc.getParameterValue("sCsqGetThresholdLevel");
                if (null != by) {
                    CarrierSquelchTab.this.setStoredCSQSetLevel(by.intValue());
                    CarrierSquelchTab.this.updateThresholdLevel(by.intValue());
                } else {
                    LOG.error((Object)"update - null message parameters from FSP packet");
                }
            } else {
                LOG.error((Object)"update - null message from FSP packet");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetCurrentChannelBandwidth
    extends Rule {
        private final String sCsqGetChannelBandwidth = "sCsqGetChannelBandwidth";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqGetChannelBandwidth", Byte.class);
            message.setProtocolKey(5200);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Channel Bandwidth");
                if (!CarrierSquelchTab.this.m_bInitialization) {
                    CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_READ_CHANNEL_BANDWIDTH_ERROR);
                } else {
                    CarrierSquelchTab.this.m_sErrors.append("\n- Channel bandwidth");
                }
            } else if (null != messageIfc) {
                Byte by = (Byte)messageIfc.getParameterValue("sCsqGetChannelBandwidth");
                if (null != by) {
                    if (by == 0) {
                        CarrierSquelchTab.this.setCurrentChannel(CarrierSquelchTab.INFO_125);
                    } else if (by == 1) {
                        CarrierSquelchTab.this.setCurrentChannel(CarrierSquelchTab.INFO_25);
                    } else {
                        LOG.error((Object)"update - invalid channel");
                    }
                } else {
                    LOG.error((Object)"update - null message parameters from FSP packet");
                }
            } else {
                LOG.error((Object)"update - null message from FSP packet");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetCurrentRxFrequency
    extends Rule {
        private final String sCsqGetReceiverFrequency = "sCsqGetReceiverFrequency";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqGetReceiverFrequency", Byte[].class);
            message.setProtocolKey(5320);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Current Receiver Frequency");
                if (!CarrierSquelchTab.this.m_bInitialization) {
                    CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_READ_RECEIVER_FREQUENCY_ERROR);
                } else {
                    CarrierSquelchTab.this.m_sErrors.append("\n- Receiver Frequency");
                }
            } else if (null != messageIfc) {
                byte[] byArray = (byte[])messageIfc.getParameterValue("sCsqGetReceiverFrequency");
                if (null != byArray) {
                    Integer n2 = Convert.toInteger((byte[])byArray);
                    Double d = (double)n2.intValue() / 1000000.0;
                    String string = Double.toString(d);
                    CarrierSquelchTab.this.setCurrentReceiverFrequency(string);
                } else {
                    LOG.error((Object)"update - null message parameters from FSP packet");
                }
            } else {
                LOG.error((Object)"update - null message from FSP packet");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class GetRxQualifier
    extends Rule {
        private final String sCsqGetRxQualifier = "sCsqGetRxQualifier";

        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.addParameter("sCsqGetRxQualifier", Byte.class);
            message.setProtocolKey(5203);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                LOG.warn((Object)"update - error getting Analog Rx Qualifier");
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_READ_RX_QUALIFIER_ERROR);
            } else if (null != messageIfc) {
                Byte by = (Byte)messageIfc.getParameterValue("sCsqGetRxQualifier");
                if (null != by) {
                    switch (by) {
                        case 0: {
                            CarrierSquelchTab.this.setCurrentQualifier(0);
                            break;
                        }
                        case 1: {
                            CarrierSquelchTab.this.setCurrentQualifier(1);
                            break;
                        }
                        case 2: {
                            CarrierSquelchTab.this.setCurrentQualifier(2);
                            break;
                        }
                        default: {
                            LOG.error((Object)"update - invalid qualifier");
                            break;
                        }
                    }
                } else {
                    LOG.error((Object)"update - null message from FSP packet");
                }
            } else {
                LOG.error((Object)"update - null message from FSP packet");
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetChannelBandwidth_25
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5202);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_WRITE_CHANNEL_BANDWIDTH_25_ERROR);
            } else {
                CarrierSquelchTab.this.setCurrentChannel(CarrierSquelchTab.INFO_25);
                CarrierSquelchTab.this.processGetThresholdRules(sessionIfc);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class SetChannelBandwidth_125
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5201);
            LOG.exit("getMessage");
            return message;
        }

        public boolean update(SessionIfc sessionIfc, int n, MessageIfc messageIfc) {
            LOG.enter("update");
            if (n != 0) {
                CarrierSquelchTab.this.m_screen.popupError(CarrierSquelchTab.CSQ_WRITE_CHANNEL_BANDWIDTH_125_ERROR);
            } else {
                CarrierSquelchTab.this.setCurrentChannel(CarrierSquelchTab.INFO_125);
                CarrierSquelchTab.this.processGetThresholdRules(sessionIfc);
            }
            LOG.exit("update");
            return true;
        }
    }

    public class StartCarrierSquelch
    extends Rule {
        public MessageIfc getMessage(SessionIfc sessionIfc) {
            LOG.enter("getMessage");
            Message message = new Message();
            message.setProtocolKey(5208);
            LOG.exit("getMessage");
            return message;
        }
    }
}

