/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens.alignment;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssLogger;
import css.core.util.component.CssJSlider;
import css.core.util.component.GenericListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.UIInternalFrame;

public class SacReferenceOscillatorFrequencyTabGUI
extends JPanel {
    private static final CssLogger LOG = CssLogger.getCssLogger(SacReferenceOscillatorFrequencyTabGUI.class);
    private final String SACROF_FIELD_FOS_TOOLTIP = "Current Internal Frequency Reference Oscillator Status.";
    private final String SACROF_FIELD_TF_TOOLTIP = "Current Transmit Frequency value.";
    private final String SACROF_CURRENT_FOV_TOOLTIP = "Current Internal Frequency Reference Oscillator Value.";
    private final String SACROF_FIELD_ADJUST_TOOLTIP = "Select a +/- selection value to decrement or increment the Ref Oscillator Value.";
    private final String SACROF_FIELD_AUTOALIGN_TOOLTIP = "External frequency reference: 5 MHz or 10 MHz.";
    private final String SACROF_FIELD_AUTOALIGN_STATUS_MSG = "External frequency reference for automatic alignment procedure.";
    private final String SACROF_BTN_KEYUP_TOOLTIP = "Pressing this button will keyup the station.";
    private final String SACROF_BTN_KEYUP_STATUS_MSG = "Click the KEYUP button to keyup the station.";
    private final String SACROF_BTN_DEKEY_TOOLTIP = "Pressing this button will dekey the station.";
    private final String SACROF_BTN_DEKEY_STATUS_MSG = "Click the DEKEY button to dekey the station.";
    private final String SACROF_BTN_LEFT_TOOLTIP = "Decrement Reference Oscillator value by the - selection. ";
    private final String SACROF_BTN_LEFT_STATUS_MSG = "Select the amount to Reference Oscillator value decrement.";
    private final String SACROF_BTN_RIGHT_TOOLTIP = "Increment Reference Oscillator value by the + selection.";
    private final String SACROF_BTN_RIGHT_STATUS_MSG = "Select the amount to Reference Oscillator value increment.";
    private final String SACROF_BTN_AUTCALC_TOOLTIP = "This button will auto-calculate the reference oscillator value.";
    private final String SACROF_BTN_AUTCALC_STATUS_MSG = "Click this button to auto-calculate the Reference Oscillator value.";
    private final String SACROF_BTN_SAVE_TOOLTIP = "This button will save the current reference oscillator value to the device.";
    private final String SACROF_BTN_SAVE_STATUS_MSG = "Click the save button to save the set reference oscillator value.";
    private final String SACROF_BTN_CANCEL_TOOLTIP = "This button will cancel set reference oscillator value and exit the screen.";
    private final String SACROF_BTN_CANCEL_STATUS_MSG = "Click the cancel button to discard changes and close the screen.";
    private static final String KEYUP = "KEYUP";
    private static final String DEKEY = "DEKEY";
    private static final String N_A = "N/A";
    protected static final String SAC_NOT_PRESENT = "NOT PRESENT";
    private static final String REF_OSCILLATOR_VALUE = "+/- Ref Oscillator Value";
    private static final String EXT_REF_OSCILLATOR_FREQUENCY = "Ext Ref Oscillator Frequency";
    private static final String INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_STATUS = "Internal Frequency Reference Oscillator Status:";
    private static final String TRANSMIT_FREQUENCY = "Transmit Frequency (MHz):";
    private static final String CURRENT_INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_VALUE = "Current Internal Frequency Reference Oscillator Value";
    protected int m_nStoredValue = 0;
    public StatusBarListener m_statusBarListener;
    public boolean m_bErrorDialogShown = false;
    private SACRefOscStatus m_eStatus = SACRefOscStatus.NA;
    private String m_sTransmitFrequency = null;
    private boolean m_bIsKeyUp = true;
    public GenericListener m_glRefrenceOscillatorValueChanged = new GenericListener();
    private boolean m_bSacOperational = true;
    private static final long serialVersionUID = 1L;
    private JLabel m_labInstructions = null;
    private JPanel m_panStatus = null;
    private JLabel m_labSACReferenceOscillatorStatusDesc = null;
    private JLabel m_labTransmitFrequencyDesc = null;
    private JLabel m_labTransmitFrequencyVal = null;
    private JLabel m_labSACReferenceOscillatorStatusVal = null;
    private CssJSlider m_voRefOscValue = null;
    private JPanel m_panManualAdjust = null;
    private JLabel m_labManualAdjustDesc = null;
    private JPanel m_panAutoCalculate = null;
    private JLabel m_labAutoCalculateDesc = null;
    private JComboBox<String> m_comManualAdjustStep = null;
    private JComboBox<String> m_comRefOscilatorFreq = null;
    private JButton m_butAutoAlignment = null;
    private JButton m_butLeft = null;
    private JButton m_butRight = null;
    private JButton m_butKeyUp_DeKey = null;
    private JLabel m_labCurrentSACFrequencyOscillatorValueDesc = null;
    private JLabel m_labCurrentSACFrequencyOscillatorValueVal = null;
    private JLabel m_labMHz = null;
    private JPanel m_panButtonsPanel = null;
    private JButton m_butSave = null;
    private JButton m_butCancel = null;

    public SacReferenceOscillatorFrequencyTabGUI() {
        LOG.enter("SacReferenceOscillatorFrequencyTabGUI");
        this.initialize();
        this.setDefaultValues();
        LOG.exit("SacReferenceOscillatorFrequencyTabGUI");
    }

    private void setDefaultValues() {
        LOG.enter("setDefaultValues");
        this.setStatus(this.m_eStatus);
        this.setTransmitFrequency(this.m_sTransmitFrequency);
        this.setKeyUp(this.m_bIsKeyUp);
        this.setReferenceOscillatorValue(0);
        LOG.exit("setDefaultValues");
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen", new Object[]{uIInternalFrame, statusBarListener});
        this.m_statusBarListener = statusBarListener;
        if (this.m_statusBarListener != null) {
            this.m_statusBarListener.updateComponent(this.m_comRefOscilatorFreq, "External frequency reference for automatic alignment procedure.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butAutoAlignment, "Click this button to auto-calculate the Reference Oscillator value.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butLeft, "Select the amount to Reference Oscillator value decrement.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butRight, "Select the amount to Reference Oscillator value increment.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butKeyUp_DeKey, "Click the KEYUP button to keyup the station.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butSave, "Click the save button to save the set reference oscillator value.", false);
            this.m_statusBarListener.updateComponent((Component)this.m_butCancel, "Click the cancel button to discard changes and close the screen.", false);
        }
        LOG.exit("buildScreen");
    }

    protected void updateScreenForHwType(boolean bl) {
        String string;
        LOG.enter("updateScreenForHwType", new Object[]{bl});
        String string2 = string = bl ? null : N_A;
        if (!this.m_bSacOperational && bl) {
            return;
        }
        for (Component component : this.getPanManualAdjust().getComponents()) {
            component.setEnabled(bl);
        }
        this.getLabTransmitFrequencyVal().setEnabled(bl);
        this.getButKeyUp_DeKey().setEnabled(bl);
        this.getRefOscValue().setEnabled(bl);
        this.m_labCurrentSACFrequencyOscillatorValueVal.setEnabled(bl);
        if (null != string) {
            this.getLabTransmitFrequencyVal().setText(string);
            this.m_labCurrentSACFrequencyOscillatorValueVal.setText(string);
            this.getRefOscValue().setValue(0);
        }
        LOG.exit("updateScreenForRxOnly");
    }

    protected void updateScreenSacOperational(boolean bl) {
        LOG.enter("updateScreenSacOperational", new Object[]{bl});
        this.m_bSacOperational = bl;
        this.m_butSave.setEnabled(bl);
        this.updateScreenForHwType(bl);
        for (Component component : this.getPanAutoCalculate().getComponents()) {
            component.setEnabled(bl);
        }
        LOG.exit("updateScreenSacOperational");
    }

    protected void updateScreenSacOperational(boolean bl, String string) {
        LOG.enter("updateScreenSacOperational", new Object[]{bl, string});
        this.updateScreenSacOperational(bl);
        if (null != string) {
            this.getLabSACReferenceOscillatorStatusVal().setText(string);
        }
        LOG.exit("updateScreenSacOperational");
    }

    private void initialize() {
        LOG.enter("initialize");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 5;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        this.m_labCurrentSACFrequencyOscillatorValueVal = new JLabel();
        this.m_labCurrentSACFrequencyOscillatorValueVal.setText("0");
        this.m_labCurrentSACFrequencyOscillatorValueVal.setToolTipText("Current Internal Frequency Reference Oscillator Value.");
        this.m_labCurrentSACFrequencyOscillatorValueVal.setName(CURRENT_INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_VALUE);
        this.m_labCurrentSACFrequencyOscillatorValueDesc = new JLabel();
        this.m_labCurrentSACFrequencyOscillatorValueDesc.setText(CURRENT_INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_VALUE);
        this.m_labCurrentSACFrequencyOscillatorValueDesc.setToolTipText("Current Internal Frequency Reference Oscillator Value.");
        this.m_labAutoCalculateDesc = new JLabel();
        this.m_labAutoCalculateDesc.setText(EXT_REF_OSCILLATOR_FREQUENCY);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 4;
        this.m_labManualAdjustDesc = new JLabel();
        this.m_labManualAdjustDesc.setText(REF_OSCILLATOR_VALUE);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.gridy = 3;
        this.m_labTransmitFrequencyDesc = new JLabel();
        this.m_labTransmitFrequencyDesc.setText(TRANSMIT_FREQUENCY);
        this.m_labTransmitFrequencyDesc.setToolTipText("Current Transmit Frequency value.");
        this.m_labSACReferenceOscillatorStatusDesc = new JLabel();
        this.m_labSACReferenceOscillatorStatusDesc.setText(INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_STATUS);
        this.m_labSACReferenceOscillatorStatusDesc.setToolTipText("Current Internal Frequency Reference Oscillator Status.");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.anchor = 10;
        gridBagConstraints5.gridy = 2;
        this.setSize(627, 556);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getPanStatus(), gridBagConstraints5);
        this.add((Component)this.getPanManualAdjust(), gridBagConstraints4);
        this.add((Component)this.getPanAutoCalculate(), gridBagConstraints3);
        this.add((Component)this.getLabInstructions(), gridBagConstraints2);
        this.add((Component)this.getPanButtonsPanel(), gridBagConstraints);
        LOG.exit("initialize");
    }

    public JLabel getLabTransmitFrequencyVal() {
        LOG.enter("getLabTransmitFrequencyVal");
        if (null == this.m_labTransmitFrequencyVal) {
            this.m_labTransmitFrequencyVal = new JLabel();
            this.m_labTransmitFrequencyVal.setText(N_A);
            this.m_labTransmitFrequencyVal.setToolTipText("Current Transmit Frequency value.");
            this.m_labTransmitFrequencyVal.setName(TRANSMIT_FREQUENCY);
        }
        LOG.exit("getLabTransmitFrequencyVal", (Object)this.m_labTransmitFrequencyVal);
        return this.m_labTransmitFrequencyVal;
    }

    public JLabel getLabSACReferenceOscillatorStatusVal() {
        LOG.enter("getLabSACReferenceOscillatorStatusVal");
        if (null == this.m_labSACReferenceOscillatorStatusVal) {
            this.m_labSACReferenceOscillatorStatusVal = new JLabel();
            this.m_labSACReferenceOscillatorStatusVal.setText(N_A);
            this.m_labSACReferenceOscillatorStatusVal.setToolTipText("Current Internal Frequency Reference Oscillator Status.");
            this.m_labSACReferenceOscillatorStatusVal.setName(INTERNAL_FREQUENCY_REFERENCE_OSCILLATOR_STATUS);
        }
        LOG.exit("getLabSACReferenceOscillatorStatusVal", (Object)this.m_labSACReferenceOscillatorStatusVal);
        return this.m_labSACReferenceOscillatorStatusVal;
    }

    private JLabel getLabInstructions() {
        LOG.enter("getLabInstructions");
        if (this.m_labInstructions == null) {
            this.m_labInstructions = new JLabel();
            this.m_labInstructions.setText("<HTML><BODY><TABLE><TR><TD VALIGN=TOP>1</TD><TD>The Base Radio should be powered on for 7 days to allow the oscillator to stabilize before the oscillator is adjusted.</TD></TR><TR><TD VALIGN=TOP>2</TD><TD>Using a service monitor with a measurement accuracy of .001 PPM, as provided by a rubidium reference,</TD></TR><TR><TD VALIGN=TOP> </TD><TD>monitor the selected station\u2019s transmit output frequency.</TD></TR><TR><TD VALIGN=TOP>3</TD><TD>When the target frequency has been reached, save the Reference Oscillator setting to the device by clicking the Save button.</TD><TR><TR><TD VALIGN=TOP></TD></TR></TABLE></BODY></HTML>");
        }
        LOG.exit("getLabInstructions", (Object)this.m_labInstructions);
        return this.m_labInstructions;
    }

    private JPanel getPanStatus() {
        LOG.enter("getPanStatus");
        if (this.m_panStatus == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 5;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.gridy = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 3;
            gridBagConstraints4.gridy = 6;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 10;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.anchor = 10;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.anchor = 10;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 13;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.gridy = 0;
            this.m_panStatus = new JPanel();
            this.m_panStatus.setLayout(new GridBagLayout());
            this.m_panStatus.add((Component)this.m_labTransmitFrequencyDesc, gridBagConstraints7);
            this.m_panStatus.add((Component)this.m_labSACReferenceOscillatorStatusDesc, gridBagConstraints8);
            this.m_panStatus.add((Component)this.getLabTransmitFrequencyVal(), gridBagConstraints6);
            this.m_panStatus.add((Component)this.getLabSACReferenceOscillatorStatusVal(), gridBagConstraints5);
            this.m_panStatus.add((Component)this.getRefOscValue(), gridBagConstraints4);
            this.m_panStatus.add((Component)this.getButKeyUp_DeKey(), gridBagConstraints3);
            this.m_panStatus.add((Component)this.m_labCurrentSACFrequencyOscillatorValueDesc, gridBagConstraints2);
            this.m_panStatus.add((Component)this.m_labCurrentSACFrequencyOscillatorValueVal, gridBagConstraints);
        }
        LOG.exit("getPanStatus", (Object)this.m_panStatus);
        return this.m_panStatus;
    }

    public CssJSlider getRefOscValue() {
        LOG.enter("getRefOscValue");
        if (this.m_voRefOscValue == null) {
            this.m_voRefOscValue = new CssJSlider();
            this.m_voRefOscValue.setPaintLabels(true);
            this.m_voRefOscValue.setSnapToTicks(false);
            this.m_voRefOscValue.setMinorTickSpacing(1000);
            this.m_voRefOscValue.setMinimum(0);
            this.m_voRefOscValue.setMajorTickSpacing(10000);
            this.m_voRefOscValue.setMaximum(65535);
            this.m_voRefOscValue.setPreferredSize(new Dimension(500, 43));
            this.m_voRefOscValue.setMinimumSize(new Dimension(500, 43));
            this.m_voRefOscValue.setPaintTrack(true);
            this.m_voRefOscValue.setValue(0);
            this.m_voRefOscValue.setPaintTicks(true);
            this.m_voRefOscValue.setToolTipText("Current Internal Frequency Reference Oscillator Value.");
            this.m_voRefOscValue.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    LOG.enter("stateChanged", new Object[]{changeEvent});
                    SacReferenceOscillatorFrequencyTabGUI.this.m_labCurrentSACFrequencyOscillatorValueVal.setText(SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.getValue() + "");
                    LOG.exit("stateChanged");
                }
            });
            this.m_voRefOscValue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LOG.enter("actionPerformed");
                    if (SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.isEnabled() && 0 == "RELEASED".compareTo(actionEvent.getActionCommand())) {
                        SacReferenceOscillatorFrequencyTabGUI.this.m_glRefrenceOscillatorValueChanged.notifyGuiListener();
                    }
                    LOG.exit("actionPerformed");
                }
            });
        }
        LOG.exit("getRefOscValue", (Object)this.m_voRefOscValue);
        return this.m_voRefOscValue;
    }

    private JPanel getPanManualAdjust() {
        LOG.enter("getPanManualAdjust");
        if (this.m_panManualAdjust == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.25;
            gridBagConstraints.fill = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 0.25;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.weightx = 0.3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.weightx = 0.25;
            gridBagConstraints4.gridy = -1;
            this.m_panManualAdjust = new JPanel();
            this.m_panManualAdjust.setLayout(new GridBagLayout());
            this.m_panManualAdjust.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Manual Calibration", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.m_panManualAdjust.add((Component)this.m_labManualAdjustDesc, gridBagConstraints4);
            this.m_panManualAdjust.add((Component)this.getButLeft(), gridBagConstraints);
            this.m_panManualAdjust.add(this.getComManualAdjustStep(), gridBagConstraints3);
            this.m_panManualAdjust.add((Component)this.getButRight(), gridBagConstraints2);
        }
        LOG.exit("getPanManualAdjust", (Object)this.m_panManualAdjust);
        return this.m_panManualAdjust;
    }

    private JPanel getPanAutoCalculate() {
        LOG.enter("getPanAutoCalculate");
        if (this.m_panAutoCalculate == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.gridy = 0;
            this.m_labMHz = new JLabel();
            this.m_labMHz.setText("MHz");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints2.weightx = 0.5;
            gridBagConstraints2.gridx = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.weightx = 0.2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = -1;
            gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints4.weightx = 0.3;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.gridy = -1;
            this.m_panAutoCalculate = new JPanel();
            this.m_panAutoCalculate.setLayout(new GridBagLayout());
            this.m_panAutoCalculate.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Auto Calibration", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.m_panAutoCalculate.add((Component)this.m_labAutoCalculateDesc, gridBagConstraints4);
            this.m_panAutoCalculate.add(this.getComRefOscilatorFreq(), gridBagConstraints3);
            this.m_panAutoCalculate.add((Component)this.getAutoAligmentButton(), gridBagConstraints2);
            this.m_panAutoCalculate.add((Component)this.m_labMHz, gridBagConstraints);
        }
        LOG.exit("getPanAutoCalculate", (Object)this.m_panAutoCalculate);
        return this.m_panAutoCalculate;
    }

    private JComboBox<String> getComManualAdjustStep() {
        LOG.enter("getComManualAdjustStep");
        if (this.m_comManualAdjustStep == null) {
            this.m_comManualAdjustStep = new JComboBox();
            this.m_comManualAdjustStep.addItem("1");
            this.m_comManualAdjustStep.addItem("10");
            this.m_comManualAdjustStep.addItem("100");
            this.m_comManualAdjustStep.setToolTipText("Select a +/- selection value to decrement or increment the Ref Oscillator Value.");
            this.m_comManualAdjustStep.setName(REF_OSCILLATOR_VALUE);
        }
        LOG.exit("getComManualAdjustStep", this.m_comManualAdjustStep);
        return this.m_comManualAdjustStep;
    }

    private JComboBox<String> getComRefOscilatorFreq() {
        LOG.enter("getComRefOscilatorFreq");
        if (this.m_comRefOscilatorFreq == null) {
            this.m_comRefOscilatorFreq = new JComboBox();
            this.m_comRefOscilatorFreq.addItem("5");
            this.m_comRefOscilatorFreq.addItem("10");
            this.m_comRefOscilatorFreq.setToolTipText("External frequency reference: 5 MHz or 10 MHz.");
            this.m_comRefOscilatorFreq.setName(EXT_REF_OSCILLATOR_FREQUENCY);
        }
        LOG.exit("getComRefOscilatorFreq", this.m_comRefOscilatorFreq);
        return this.m_comRefOscilatorFreq;
    }

    public JButton getAutoAligmentButton() {
        LOG.enter("getAutoAligmentButton");
        if (this.m_butAutoAlignment == null) {
            this.m_butAutoAlignment = new JButton();
            this.m_butAutoAlignment.setText("Auto Alignment");
            this.m_butAutoAlignment.setToolTipText("This button will auto-calculate the reference oscillator value.");
        }
        LOG.exit("getAutoAligmentButton", (Object)this.m_butAutoAlignment);
        return this.m_butAutoAlignment;
    }

    protected JButton getButLeft() {
        LOG.enter("getButLeft");
        if (this.m_butLeft == null) {
            this.m_butLeft = new JButton();
            this.m_butLeft.setText("<");
            this.m_butLeft.setToolTipText("Decrement Reference Oscillator value by the - selection. ");
            this.m_butLeft.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SacReferenceOscillatorFrequencyTabGUI.this.m_nStoredValue = SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.getValue();
                    SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.setValue(SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.getValue() - SacReferenceOscillatorFrequencyTabGUI.this.getManualAdjustStep());
                    SacReferenceOscillatorFrequencyTabGUI.this.m_glRefrenceOscillatorValueChanged.notifyGuiListener();
                }
            });
        }
        LOG.exit("getButLeft", (Object)this.m_butLeft);
        return this.m_butLeft;
    }

    protected JButton getButRight() {
        LOG.enter("getButRight");
        if (this.m_butRight == null) {
            this.m_butRight = new JButton();
            this.m_butRight.setText(">");
            this.m_butRight.setToolTipText("Increment Reference Oscillator value by the + selection.");
            this.m_butRight.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SacReferenceOscillatorFrequencyTabGUI.this.m_nStoredValue = SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.getValue();
                    SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.setValue(SacReferenceOscillatorFrequencyTabGUI.this.m_voRefOscValue.getValue() + SacReferenceOscillatorFrequencyTabGUI.this.getManualAdjustStep());
                    SacReferenceOscillatorFrequencyTabGUI.this.m_glRefrenceOscillatorValueChanged.notifyGuiListener();
                }
            });
        }
        LOG.exit("getButRight", (Object)this.m_butRight);
        return this.m_butRight;
    }

    public JButton getButKeyUp_DeKey() {
        LOG.enter("getButKeyUp_DeKey");
        if (this.m_butKeyUp_DeKey == null) {
            this.m_butKeyUp_DeKey = new JButton();
            this.m_butKeyUp_DeKey.setText(KEYUP);
            this.m_butKeyUp_DeKey.setToolTipText("Pressing this button will keyup the station.");
            this.m_butKeyUp_DeKey.setName("Keyup button");
        }
        LOG.exit("getButKeyUp_DeKey", (Object)this.m_butKeyUp_DeKey);
        return this.m_butKeyUp_DeKey;
    }

    private JPanel getPanButtonsPanel() {
        LOG.enter("getPanButtonsPanel");
        if (this.m_panButtonsPanel == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setHgap(50);
            this.m_panButtonsPanel = new JPanel();
            this.m_panButtonsPanel.setLayout(flowLayout);
            this.m_panButtonsPanel.add((Component)this.getButSave(), null);
            this.m_panButtonsPanel.add((Component)this.getButCancel(), null);
        }
        LOG.exit("getPanButtonsPanel", (Object)this.m_panButtonsPanel);
        return this.m_panButtonsPanel;
    }

    public JButton getButSave() {
        LOG.enter("getButSave");
        if (this.m_butSave == null) {
            this.m_butSave = new JButton();
            this.m_butSave.setText("Save");
            this.m_butSave.setMnemonic(0);
            this.m_butSave.setPreferredSize(new Dimension(100, 26));
            this.m_butSave.setToolTipText("This button will save the current reference oscillator value to the device.");
        }
        LOG.exit("getButSave", (Object)this.m_butSave);
        return this.m_butSave;
    }

    public JButton getButCancel() {
        LOG.enter("getButCancel");
        if (this.m_butCancel == null) {
            this.m_butCancel = new JButton();
            this.m_butCancel.setText("Cancel");
            this.m_butCancel.setMnemonic(0);
            this.m_butCancel.setPreferredSize(new Dimension(100, 26));
            this.m_butCancel.setToolTipText("This button will cancel set reference oscillator value and exit the screen.");
        }
        LOG.exit("getButCancel", (Object)this.m_butCancel);
        return this.m_butCancel;
    }

    public void setStatus(SACRefOscStatus sACRefOscStatus) {
        LOG.enter("setStatus", new Object[]{sACRefOscStatus});
        this.m_eStatus = sACRefOscStatus;
        this.getLabSACReferenceOscillatorStatusVal().setText(this.m_eStatus.getDesc());
        LOG.exit("setStatus");
    }

    public void setStatus(int n) {
        LOG.enter("setStatus", new Object[]{n});
        this.setStatus(SACRefOscStatus.getStatus(n));
        LOG.exit("getStatus");
    }

    public SACRefOscStatus getStatus() {
        LOG.enter("getStatus");
        LOG.exit("getStatus");
        return this.m_eStatus;
    }

    public String getTransmitFrequency() {
        LOG.enter("getTransmitFrequency");
        LOG.exit("getTransmitFrequency");
        return this.m_sTransmitFrequency;
    }

    public void setTransmitFrequency(String string) {
        LOG.enter("setTransmitFrequency", new Object[]{string});
        this.m_sTransmitFrequency = string;
        if (null != this.m_sTransmitFrequency) {
            this.getLabTransmitFrequencyVal().setText(this.m_sTransmitFrequency);
        } else {
            this.getLabTransmitFrequencyVal().setText(N_A);
        }
        LOG.exit("setTransmitFrequency");
    }

    public boolean isKeyUp() {
        LOG.enter("isKeyUp");
        LOG.exit("isKeyUp");
        return this.m_bIsKeyUp;
    }

    public void setKeyUp(boolean bl) {
        LOG.enter("setKeyUp", new Object[]{bl});
        this.m_bIsKeyUp = bl;
        if (this.m_bIsKeyUp) {
            this.getButKeyUp_DeKey().setText(KEYUP);
            if (this.m_statusBarListener != null && this.m_butKeyUp_DeKey != null) {
                this.m_statusBarListener.updateComponent((Component)this.getButKeyUp_DeKey(), "Click the KEYUP button to keyup the station.", false);
                this.getButKeyUp_DeKey().setToolTipText("Pressing this button will keyup the station.");
            }
        } else {
            this.getButKeyUp_DeKey().setText(DEKEY);
            if (this.m_statusBarListener != null && this.m_butKeyUp_DeKey != null) {
                this.m_statusBarListener.updateComponent((Component)this.getButKeyUp_DeKey(), "Click the DEKEY button to dekey the station.", false);
                this.getButKeyUp_DeKey().setToolTipText("Pressing this button will dekey the station.");
            }
        }
        LOG.exit("setKeyUp");
    }

    public int getReferenceOscillatorValue() {
        LOG.enter("getReferenceOscillatorValue");
        LOG.exit("getReferenceOscillatorValue");
        return this.getRefOscValue().getValue();
    }

    public void setReferenceOscillatorValue(int n) {
        LOG.enter("setReferenceOscillatorValue", new Object[]{n});
        this.getRefOscValue().setValue(n);
        LOG.exit("setReferenceOscillatorValue");
    }

    public int getManualAdjustStep() {
        LOG.enter("getManualAdjustStep");
        int n = 1;
        n = Integer.parseInt(this.m_comManualAdjustStep.getSelectedItem().toString());
        LOG.exit("getManualAdjustStep", (Object)n);
        return n;
    }

    public int getRefOscilatorFreq() {
        LOG.enter("getRefOscilatorFreq");
        int n = 1;
        n = Integer.parseInt(this.m_comRefOscilatorFreq.getSelectedItem().toString());
        LOG.exit("getRefOscilatorFreq", (Object)n);
        return n;
    }

    public static enum SACRefOscStatus {
        FAILED(0, "FAILED"),
        OPERATIONAL(1, "OPERATIONAL"),
        WARMING_UP(2, "WARMING UP"),
        NA(15, "N/A");

        private int value;
        private String desc;

        private SACRefOscStatus(int n2, String string2) {
            this.desc = string2;
            this.value = n2;
        }

        public static SACRefOscStatus getStatus(int n) {
            for (SACRefOscStatus sACRefOscStatus : SACRefOscStatus.values()) {
                if (sACRefOscStatus.getValue() != n) continue;
                return sACRefOscStatus;
            }
            return NA;
        }

        public int getValue() {
            return this.value;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

