/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.referenceservice;

import css.core.util.Devices;
import css.device.sc_platform.common.screens.referenceservice.TimeReferenceSource;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class PrimarySecondaryTimeReferenceSource {
    private static final PrimarySecondaryTimeReferenceSource EXTERNAL_NONE = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.EXTERNAL, TimeReferenceSource.NONE);
    public static final PrimarySecondaryTimeReferenceSource REDUNDANT_NONE = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.NONE);
    private static final PrimarySecondaryTimeReferenceSource EXTERNAL_REDUNDANT = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.EXTERNAL, TimeReferenceSource.REDUNDANT);
    private static final PrimarySecondaryTimeReferenceSource REDUNDANT_EXTERNAL = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.REDUNDANT, TimeReferenceSource.EXTERNAL);
    private static final PrimarySecondaryTimeReferenceSource GPRS_EXTERNAL = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.GPSR, TimeReferenceSource.EXTERNAL);
    private static final PrimarySecondaryTimeReferenceSource GPRS_REDUNDANT = new PrimarySecondaryTimeReferenceSource(TimeReferenceSource.GPSR, TimeReferenceSource.REDUNDANT);
    private static final String DELIMETER = "/";
    private static Set<PrimarySecondaryTimeReferenceSource> rdmPairsMap = new LinkedHashSet<PrimarySecondaryTimeReferenceSource>();
    private static Set<PrimarySecondaryTimeReferenceSource> sscPairsMap;
    private static Set<PrimarySecondaryTimeReferenceSource> scSummitPairsMap;
    private static Set<PrimarySecondaryTimeReferenceSource> allowedPairs;
    private TimeReferenceSource primarySource;
    private TimeReferenceSource secondarySource;

    public PrimarySecondaryTimeReferenceSource(TimeReferenceSource timeReferenceSource, TimeReferenceSource timeReferenceSource2) {
        this.primarySource = timeReferenceSource;
        this.secondarySource = timeReferenceSource2;
    }

    public String toString() {
        return (Object)((Object)this.primarySource) + DELIMETER + (Object)((Object)this.secondarySource);
    }

    public static Vector<PrimarySecondaryTimeReferenceSource> getValues() {
        return new Vector<PrimarySecondaryTimeReferenceSource>(allowedPairs);
    }

    public static PrimarySecondaryTimeReferenceSource getDefaultValue() {
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isRdmPlatform((String)string).booleanValue()) {
            return GPRS_REDUNDANT;
        }
        if (Devices.isScSummitPlatform((String)string).booleanValue()) {
            return REDUNDANT_NONE;
        }
        return EXTERNAL_NONE;
    }

    public static PrimarySecondaryTimeReferenceSource getPrimarySecondaryTimeReferenceSource(TimeReferenceSource timeReferenceSource, TimeReferenceSource timeReferenceSource2) {
        PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource = null;
        for (PrimarySecondaryTimeReferenceSource primarySecondaryTimeReferenceSource2 : allowedPairs) {
            if (primarySecondaryTimeReferenceSource2.getTimeReferenceSource(1) != timeReferenceSource || primarySecondaryTimeReferenceSource2.getTimeReferenceSource(2) != timeReferenceSource2) continue;
            primarySecondaryTimeReferenceSource = primarySecondaryTimeReferenceSource2;
        }
        return primarySecondaryTimeReferenceSource;
    }

    public TimeReferenceSource getTimeReferenceSource(int n) {
        if (1 == n) {
            return this.primarySource;
        }
        return this.secondarySource;
    }

    static {
        rdmPairsMap.add(GPRS_REDUNDANT);
        rdmPairsMap.add(GPRS_EXTERNAL);
        rdmPairsMap.add(REDUNDANT_EXTERNAL);
        rdmPairsMap.add(EXTERNAL_REDUNDANT);
        rdmPairsMap.add(REDUNDANT_NONE);
        sscPairsMap = new LinkedHashSet<PrimarySecondaryTimeReferenceSource>();
        sscPairsMap.add(EXTERNAL_NONE);
        sscPairsMap.add(REDUNDANT_NONE);
        scSummitPairsMap = new LinkedHashSet<PrimarySecondaryTimeReferenceSource>();
        scSummitPairsMap.add(REDUNDANT_NONE);
        scSummitPairsMap.add(EXTERNAL_REDUNDANT);
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        allowedPairs = Devices.isRdmPlatform((String)string) != false ? rdmPairsMap : (Devices.isScSummitPlatform((String)string) != false ? scSummitPairsMap : sscPairsMap);
    }
}

