/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.protocol.cmdmgr;

import css.core.appservices.cs.ConnectionInfoObject;
import css.core.service.CmdHandler;
import css.core.service.CmdHandlerRules;
import css.core.service.DataObject;
import css.core.service.Destroyable;
import css.core.service.NotFoundException;
import css.core.service.ProtocolMultiplexer;
import css.core.util.CssConstants;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.device.common.protocol.cmdmgr.Datagram;
import css.device.common.protocol.cmdmgr.DevicePorts;
import css.device.common.protocol.cmdmgr.DeviceSessions;
import css.device.common.protocol.cmdmgr.InPort;
import css.device.common.protocol.cmdmgr.OutPort;
import css.device.common.protocol.cmdmgr.PortInfo;
import css.device.common.protocol.cmdmgr.Protocol;
import css.device.common.service.ScreenManager;
import css.device.common.util.Alarm;
import css.device.common.util.Alarmable;
import java.util.Vector;

public class CmdManager
implements Destroyable,
CssConstants,
Alarmable {
    private static final CssLogger LOG = CssLogger.getCssLogger(CmdManager.class);
    DeviceSessions ref_DeviceSessions;
    DevicePorts ref_DevicePorts;
    private Protocol m_protocol;
    private Alarm m_alarm;
    private long m_startResetTime;
    private boolean m_resetCmdPort = false;

    public CmdManager(Object[][] objectArray) {
        LOG.enter("CmdManager", new Object[]{objectArray});
        this.ref_DeviceSessions = new DeviceSessions();
        this.ref_DevicePorts = new DevicePorts();
        this.m_protocol = new Protocol(0, 1054, 0, objectArray, this, new DataObject());
        LOG.exit("CmdManager");
    }

    public synchronized DataObject doOperation(DataObject dataObject) {
        LOG.enter("doOperation", new Object[]{dataObject});
        int n = -1;
        String string = null;
        int n2 = 0;
        n = dataObject.getProtocolKey();
        if (n == 2016) {
            this.destroy();
        } else if (dataObject.getSessionName() == null) {
            n2 = -14;
            dataObject.setError(n2);
        } else {
            string = dataObject.getSessionName();
            if (n == 2015) {
                this.handleCmdMgrPortReset();
                n2 = this.m_protocol.restartDevice();
                dataObject.setError(n2);
                if (n2 != 0) {
                    this.m_resetCmdPort = true;
                }
            } else if (n >= 2000 && n <= 2049) {
                this.handleCmdMgrPortReset();
                if (n >= 2001 && n <= 2005) {
                    if (this.m_protocol.getHeaderVersion((byte)5) != 1) {
                        n2 = -12;
                        dataObject.setError(n2);
                    } else if (this.m_protocol.getHeaderVersion((byte)6) != 1) {
                        n2 = -13;
                        dataObject.setError(n2);
                    }
                }
                if (n2 == 0) {
                    dataObject = this.m_protocol.doOperation(dataObject);
                }
                if (n2 != 0 || dataObject.getError() != 0) {
                    this.m_resetCmdPort = true;
                }
            } else {
                try {
                    Protocol protocol = this.ref_DeviceSessions.getProtocolHandleFromName(string);
                    dataObject = protocol.doOperation(dataObject);
                    n2 = dataObject.getError();
                }
                catch (NotFoundException notFoundException) {
                    LOG.warn((Object)("doOperation - Can't find protocol handle from session name = " + string), (Throwable)notFoundException);
                }
            }
            if (n2 == 0 && (n == 2015 || n == 2010 || n == 2011 || n == 5464)) {
                this.handleRestart();
            }
        }
        LOG.exit("doOperation - status = " + n2, (Object)dataObject);
        return dataObject;
    }

    public DeviceSessions getDeviceSessions() {
        LOG.enter("getDeviceSessions");
        LOG.exit("getDeviceSessions - " + this.ref_DeviceSessions.dumpDeviceSessions());
        return this.ref_DeviceSessions;
    }

    public DevicePorts getDevicePorts() {
        LOG.enter("getDevicePorts");
        LOG.exit("getDevicePorts - " + this.ref_DevicePorts.dumpDevicePorts());
        return this.ref_DevicePorts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeSessionsOnPort(int n, byte by, byte by2) {
        LOG.enter("closeSessionsOnPort", new Object[]{Integer.toString(n), Byte.toString(by), Byte.toString(by2)});
        Datagram datagram = new Datagram();
        datagram.setOpcode(by);
        datagram.setSubOpcode(by2);
        Vector vector = this.ref_DeviceSessions.getProtocolHandlesFromPort(n);
        for (int i = 0; i < vector.size(); ++i) {
            Protocol protocol = (Protocol)vector.elementAt(i);
            protocol.reply(datagram);
            if (protocol.equals(this.m_protocol)) continue;
            protocol.close();
        }
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            this.ref_DeviceSessions.deletePort(n);
            if (this.ref_DevicePorts.portExists(n)) {
                while (this.ref_DevicePorts.getPort(n).getCount() > 1) {
                    this.ref_DevicePorts.deletePort(n);
                }
                if (n != 1054) {
                    this.ref_DevicePorts.deletePort(n);
                }
            }
        }
        LOG.exit("closeSessionsOnPort");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        PortInfo portInfo;
        Vector vector;
        LOG.enter("destroy");
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            vector = this.ref_DevicePorts.getPorts();
        }
        for (int i = 0; i < vector.size(); ++i) {
            portInfo = (PortInfo)vector.elementAt(i);
            int n = portInfo.getPortNumber();
            this.closeSessionsOnPort(n, (byte)-1, (byte)-40);
        }
        DevicePorts devicePorts2 = this.ref_DevicePorts;
        synchronized (devicePorts2) {
            portInfo = this.ref_DevicePorts.getPort(1054);
            InPort inPort = portInfo.getInPortHandle();
            inPort.terminate();
            OutPort outPort = portInfo.getOutPortHandle();
            outPort.terminate();
        }
        LOG.exit("destroy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRestart() {
        Vector vector;
        LOG.enter("handleRestart");
        DevicePorts devicePorts = this.ref_DevicePorts;
        synchronized (devicePorts) {
            vector = this.ref_DevicePorts.getPorts();
        }
        for (int i = 0; i < vector.size(); ++i) {
            PortInfo portInfo = (PortInfo)vector.elementAt(i);
            int n = portInfo.getPortNumber();
            this.closeSessionsOnPort(n, (byte)-1, (byte)-40);
        }
        this.m_alarm = new Alarm(15000, this);
        this.m_alarm.start();
        this.m_startResetTime = System.currentTimeMillis();
        LOG.exit("handleRestart");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCmdMgrPortReset() {
        LOG.enter("handleCmdMgrPortReset");
        if (this.m_resetCmdPort) {
            this.m_resetCmdPort = false;
            DevicePorts devicePorts = this.ref_DevicePorts;
            synchronized (devicePorts) {
                this.ref_DevicePorts.deletePort(1054);
                InPort inPort = new InPort(1054, false, this);
                OutPort outPort = new OutPort(1054, false, this, inPort.getDatagramSocket());
                Thread thread = new Thread(inPort);
                Thread thread2 = new Thread(outPort);
                thread.start();
                thread2.start();
                this.ref_DevicePorts.addPort(1054, inPort, outPort);
            }
        }
        LOG.exit("handleCmdMgrPortReset");
    }

    @Override
    public void alarmCall(Object object) {
        LOG.enter("alarmCall", new Object[]{object});
        boolean bl = false;
        this.handleCmdMgrPortReset();
        if (1 == this.m_protocol.getHeaderVersion((byte)5)) {
            Object[][] objectArray = new Object[][]{{new Integer(1), new String[]{"deviceMode"}, new String[]{"Integer[]"}, new Integer(1006)}, {new Integer(2), new String[]{"cmState"}, new String[]{"Integer[]"}, new Integer(1006)}};
            ProtocolMultiplexer protocolMultiplexer = ProtocolMultiplexer.getCoreProtocolMultiplexer();
            CmdHandlerRules cmdHandlerRules = new CmdHandlerRules(objectArray);
            CmdHandler cmdHandler = new CmdHandler(cmdHandlerRules, "DeviceModeRequest", protocolMultiplexer);
            int n = -1;
            int n2 = -1;
            String string = null;
            String string2 = ConnectionInfoObject.getDeviceType();
            if (null != string2) {
                if (Devices.isBaseRadio((String)string2).booleanValue()) {
                    n = 1;
                    string = "deviceMode";
                    n2 = 8;
                } else if (Devices.isCmPlatform((String)string2).booleanValue() || Devices.isGcm8000Platform((String)string2).booleanValue() || Devices.isGcm8000ConvPlatform((String)string2).booleanValue()) {
                    n = 2;
                    string = "cmState";
                    n2 = 10;
                } else {
                    LOG.warn((Object)("alarmCall - cannot recognize device type " + string2));
                }
                if (n != -1 && null != string && n2 != -1) {
                    DataObject dataObject = cmdHandler.processSyncRequest(n, (Object[])new String[]{""});
                    if (null != dataObject && dataObject.getError() == 0) {
                        Vector vector = (Vector)dataObject.getParameterValue(string);
                        if (null != vector && vector.size() > 0) {
                            int n3 = (Integer)vector.elementAt(0);
                            if (n2 != n3) {
                                bl = true;
                            } else {
                                LOG.trace((Object)"alarmCall - Device initializes.");
                            }
                        }
                    } else {
                        LOG.warn((Object)"alarmCall - Error while retrieving current device state.");
                    }
                } else {
                    LOG.warn((Object)"alarmCall - Incompatible device type.");
                }
            } else {
                LOG.error((Object)"alarmCall - Cannot determine device type.");
            }
        }
        if (bl) {
            ScreenManager.update(true);
        } else {
            long l = System.currentTimeMillis();
            String string = ConnectionInfoObject.getResetTimeout();
            if (null != string) {
                try {
                    long l2 = Long.parseLong(string);
                    if (l - this.m_startResetTime < l2) {
                        this.m_alarm = new Alarm(5000, this);
                        this.m_alarm.start();
                    } else {
                        ScreenManager.update(false);
                    }
                    this.m_resetCmdPort = true;
                }
                catch (Exception exception) {
                    LOG.error((Object)"alarmCall - Caught exception while checking for device to restart", (Throwable)exception);
                    ScreenManager.update(false);
                }
            } else {
                LOG.error((Object)"alarmCall - Error while getting timeout value from properties.");
                ScreenManager.update(false);
            }
        }
        LOG.exit("alarmCall");
    }
}

