/*
 * Decompiled with CFR 0.152.
 */
package css.device.common.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.core.util.GridBagAdder;
import css.core.util.component.WaitPopup;
import css.core.util.popup.ConfirmationPopup;
import css.core.util.popup.ErrorPopup;
import css.device.common.protocol.cmdmgr.ScCmdManager;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.service.ScreenManager;
import css.device.sc_platform.common.tables.ScCommonOidTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Array;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import pnm.ui.UIInternalFrame;

public class CommonVlanScreen
extends GenericScreen
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final CssLogger LOG = CssLogger.getCssLogger(CommonVlanScreen.class);
    private static final int VLAN_SWITCH_TIME = 15000;
    private static final int COUNTDOWN_UPDATE = 1000;
    private static final String SWITCHING_VLANS_MSG = "Switching Vlans, please wait ";
    private static final String SECONDS_MSG = " seconds.";
    private ErrorPopup m_errorPopup = new ErrorPopup();
    public JButton m_okBtn = new JButton("  OK  ");
    private JButton m_cancelBtn = new JButton("Cancel");
    private JTextField m_vlanRequestedTFld;
    private JLabel m_vlanActualTFld;
    private int m_count;
    Integer[] m_agentState;
    boolean m_state = true;
    boolean m_bPerformReset = false;
    JLabel m_labProgress = null;
    private WaitPopup m_oProgressPopup = new WaitPopup("Change Vlan Screen");

    public CommonVlanScreen() {
        LOG.enter("CommonVlanScreen");
        LOG.exit("CommonVlanScreen");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        LOG.enter("buildScreen", new Object[]{object, statusBarListener, genericScreenMaker});
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.m_window.addInternalFrameListener((InternalFrameListener)new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                ScreenManager.removeScreen(CommonVlanScreen.this);
                CommonVlanScreen.this.m_window.setVisible(false);
            }
        });
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(2, 2));
        GridBagAdder.add((Container)this, (Component)jPanel, (int)0, (int)0, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        GridBagAdder.add((Container)this, (Component)jPanel2, (int)0, (int)1, (double)0.0, (double)0.0, (int)1, (int)2, (int)17, (int)2, (int)0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0));
        JLabel jLabel = new JLabel();
        jLabel.setText("Actual Vlan Number");
        jLabel.setToolTipText("Actual Vlan Number of the Station");
        jPanel3.add(jLabel);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setPreferredSize(new Dimension(50, 10));
        jPanel3.add(jLabel2);
        this.m_vlanActualTFld = new JLabel("N/A");
        this.m_vlanActualTFld.setBackground(this.getBackground());
        this.m_vlanActualTFld.setPreferredSize(new Dimension(60, 20));
        jPanel3.add(this.m_vlanActualTFld);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(0));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Requested Vlan Number");
        jLabel3.setToolTipText("Requested Vlan Number of the device");
        jPanel4.add(jLabel3);
        JLabel jLabel4 = new JLabel("");
        jLabel4.setPreferredSize(new Dimension(22, 10));
        jPanel4.add(jLabel4);
        this.m_vlanRequestedTFld = new JTextField();
        this.m_vlanRequestedTFld.setPreferredSize(new Dimension(60, 20));
        this.m_vlanRequestedTFld.addActionListener(this);
        jPanel4.add(this.m_vlanRequestedTFld);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(1));
        this.m_okBtn.setToolTipText("Set Requested Vlan Number in device");
        jPanel5.add(this.m_okBtn);
        JLabel jLabel5 = new JLabel("");
        jLabel5.setPreferredSize(new Dimension(10, 10));
        jPanel5.add(jLabel5);
        this.m_cancelBtn.setToolTipText("Ignore any changes and close Screen");
        this.m_cancelBtn.addActionListener(this);
        jPanel5.add(this.m_cancelBtn);
        jPanel2.add(jPanel5);
        statusBarListener.registerComponent((Component)this.m_vlanRequestedTFld, "Enter Vlan number ");
        statusBarListener.registerComponent((Component)this.m_okBtn, "Click this button to set Vlan Number in device");
        statusBarListener.registerComponent((Component)this.m_cancelBtn, "Click this button to clear all changes and return to previous settings");
        LOG.exit("buildScreen");
    }

    @Override
    public void initialize() {
        LOG.enter("initialize");
        this.m_vlanActualTFld.setText("N/A");
        this.m_vlanRequestedTFld.setText(" ");
        this.m_bPerformReset = false;
        LOG.exit("initialize");
    }

    public Object[] getVlanNumber() {
        LOG.enter("getVlanNumber");
        Object[] objectArray = new Object[]{this.m_vlanRequestedTFld.getText().trim()};
        LOG.exit("getVlanNumber", objectArray);
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVlanNumber(int n) {
        LOG.enter("updateVlanNumber", new Object[]{n});
        if (!this.m_bPerformReset) {
            try {
                WaitPopup waitPopup = this.m_oProgressPopup;
                synchronized (waitPopup) {
                    this.m_oProgressPopup.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"updateVlanNumber - TODO", (Throwable)interruptedException);
            }
            try {
                int n2 = (100 - this.m_oProgressPopup.getProgress()) / 2;
                this.m_oProgressPopup.setProgress(this.m_oProgressPopup.getProgress() + n2);
                Thread.sleep(250L);
                this.m_oProgressPopup.setProgress(100);
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                LOG.error((Object)"run - thread sleep exception", (Throwable)interruptedException);
            }
            this.m_window.unlockWindow();
            if (n != 0) {
                LOG.error((Object)"updateVlanNumber - Unable to set vlan Number");
                if (this.m_window.isVisible()) {
                    this.m_errorPopup.display(-327930);
                }
            } else {
                this.m_vlanActualTFld.setText(this.m_vlanRequestedTFld.getText().trim());
            }
        } else {
            ScreenManager.suspend(true);
            ScCmdManager scCmdManager = new ScCmdManager(ScCommonOidTable.SCCOMMON_OID_TABLE);
            scCmdManager.handleRestart();
        }
        LOG.exit("updateVlanNumber");
    }

    public void updateCurrentVlanNumber(int n, Integer n2, Integer n3) {
        LOG.enter("updateCurrentVlanNumber", new Object[]{n, n2, n3});
        this.m_window.unlockWindow();
        if (n != 0) {
            LOG.error((Object)"updateCurrentVlanNumber - Unable to get vlan number");
            this.popupError(-327931);
        } else {
            this.m_count = n3;
            this.m_vlanActualTFld.setText(n2.toString());
        }
        LOG.exit("enclosing_method");
    }

    public void updateAgentState(int n, Integer[] integerArray) {
        LOG.enter("updateAgentState", new Object[]{n, integerArray});
        int n2 = 0;
        if (n == 0) {
            this.m_agentState = integerArray;
            n2 = Array.getLength(this.m_agentState);
            for (int i = 0; i < n2; ++i) {
                this.m_state = this.m_agentState[i] == 1 || this.m_agentState[i] == 6;
            }
        }
        LOG.exit("updateAgentState");
    }

    public boolean validateVlanNumber() {
        boolean bl = true;
        LOG.enter("validateVlanNumber");
        try {
            int n = new Integer(this.m_vlanRequestedTFld.getText().trim());
            if (n < 1 || n > this.m_count) {
                this.popupError(-327932);
                this.m_window.unlockWindow();
                bl = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
            this.popupError(-327932);
            this.m_window.unlockWindow();
            LOG.error((Object)"validateVlanNumber - Invalid format of the requestion vlan number", (Throwable)numberFormatException);
        }
        LOG.exit("validateVlanNumber", (Object)bl);
        return bl;
    }

    public boolean userRequest() {
        boolean bl = false;
        LOG.enter("userRequest");
        bl = this.validateVlanNumber();
        if (!this.m_state) {
            this.popupError("Invalid Agent State. Cannot Change Vlan Number.");
            bl = false;
        } else if (bl) {
            String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
            if (Devices.isHpdscPlatform((String)string).booleanValue() || Devices.isIscPlatform((String)string).booleanValue() || Devices.isSscPlatform((String)string).booleanValue()) {
                ConfirmationPopup confirmationPopup = new ConfirmationPopup();
                confirmationPopup.display(-524341);
                this.m_bPerformReset = bl = confirmationPopup.getStatus();
            } else {
                CountingThread countingThread = new CountingThread();
                new Thread(countingThread).start();
                bl = true;
            }
        }
        if (!bl) {
            this.m_window.unlockWindow();
        }
        LOG.exit("userRequest", (Object)bl);
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        LOG.enter("actionPerformed", new Object[]{actionEvent});
        if (actionEvent.getSource() == this.m_cancelBtn) {
            ScreenManager.removeScreen(this);
            this.m_window.setVisible(false);
        }
        if (actionEvent.getSource() == this.m_vlanRequestedTFld) {
            this.m_okBtn.doClick();
        }
        LOG.exit("actionPerformed");
    }

    class CountingThread
    implements Runnable {
        CountingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 15000; i > 0; i -= 1000) {
                CommonVlanScreen.this.m_oProgressPopup.display(CommonVlanScreen.SWITCHING_VLANS_MSG + i / 1000 + CommonVlanScreen.SECONDS_MSG);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    LOG.error((Object)"run - thread sleep exception", (Throwable)interruptedException);
                }
            }
            CommonVlanScreen.this.m_oProgressPopup.setVisible(false);
            WaitPopup waitPopup = CommonVlanScreen.this.m_oProgressPopup;
            synchronized (waitPopup) {
                CommonVlanScreen.this.m_oProgressPopup.notify();
            }
        }
    }
}

