/*
 * Decompiled with CFR 0.152.
 */
package css.device.platform.summit.screens;

import css.core.screens.tools.StatusBarListener;
import css.core.service.Convert;
import css.core.service.RealTimeDataObject;
import css.core.util.CSSUtilities;
import css.core.util.CssLogger;
import css.core.util.Devices;
import css.device.common.protocol.cmdmgr.FspRealTimeDataObject;
import css.device.common.screens.GenericScreen;
import css.device.common.screens.GenericScreenMaker;
import css.device.common.util.DeviceErrorCodes;
import css.device.platform.common.tables.BrCommonTranslationInfoRules;
import css.device.platform.summit.screens.SummitPowerSupplyPanel;
import css.device.platform.summit.screens.SummitTransmitterPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pnm.ui.PnmDialog;
import pnm.ui.UIInternalFrame;

public class SummitMeteringScreen
extends GenericScreen {
    private static final CssLogger LOG = CssLogger.getCssLogger(SummitMeteringScreen.class);
    private static final long serialVersionUID = 3995956409187780606L;
    private final String FILE = "SummitMeteringScreen";
    private final String EXCITERPA_METERING = "Transmitter";
    private final String POWERSUPPLY_METERING = "Power Supply";
    private final int ZERO_INDEX = 0;
    private final int ONE_INDEX = 1;
    public SummitTransmitterPanel m_transmitter;
    public SummitPowerSupplyPanel m_pwrSupply;
    private JTabbedPane m_tabbedPane;
    private boolean isIsrOrConvBr;
    private boolean m_isRxOnly;
    private int nCurrentDeviceMode = -1;
    private String appHWCombination = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");

    public SummitMeteringScreen() {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter construtor"});
        this.m_tabbedPane = new JTabbedPane();
        this.m_pwrSupply = new SummitPowerSupplyPanel();
        this.m_transmitter = new SummitTransmitterPanel();
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        this.isIsrOrConvBr = Devices.isIsrApplication((String)string) != false || Devices.isConvBrApplication((String)string) != false;
        this.m_transmitter.setIsrOrConvBr(this.isIsrOrConvBr);
        this.m_isRxOnly = CSSUtilities.isApplicationRxOnly();
        this.m_transmitter.setRxOnly(this.m_isRxOnly);
        LOG.exit("SummitMeteringScreen", (Object)"Exit construtor");
    }

    @Override
    public void buildScreen(Object object, StatusBarListener statusBarListener, GenericScreenMaker genericScreenMaker) {
        this.MENU_ITEM_NAME = "Metering Screen";
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter buildScreen"});
        this.m_window = (UIInternalFrame)object;
        this.m_screenMaker = genericScreenMaker;
        this.setLayout(new GridBagLayout());
        this.m_tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                LOG.enter("stateChanged");
                if (SummitMeteringScreen.this.m_tabbedPane.getSelectedComponent() instanceof SummitTransmitterPanel) {
                    SummitMeteringScreen.this.startSummitTransmitterInitRules();
                }
                LOG.exit("stateChanged");
            }
        });
        this.m_transmitter.buildScreen(this.m_window, statusBarListener);
        this.m_pwrSupply.buildScreen(this.m_window, statusBarListener);
        this.addSelectiveTabs();
        this.m_tabbedPane.setSelectedIndex(0);
        this.m_transmitter.setEnabled(false);
        this.m_pwrSupply.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.m_tabbedPane, gridBagConstraints);
        this.m_tabbedPane.requestFocus();
        this.m_window.lockWindow();
        this.m_window.setCursor(new Cursor(3));
        LOG.exit("SummitMeteringScreen", (Object)"Exit buildScreen");
    }

    public boolean startSummitTransmitterInitRules() {
        LOG.enter("startSummitTransmitterInitRules");
        boolean bl = true;
        String string = System.getProperty("css.core.deviceandhwtype", "UNKNOWN");
        if (Devices.isConvBrApplication((String)string).booleanValue() || Devices.isMsBR3600Application((String)string).booleanValue() || Devices.isIR3600Application((String)string).booleanValue() || Devices.isMsBrApplication((String)string).booleanValue()) {
            this.m_transmitter.getGenericListener().notifyGuiListener();
        }
        LOG.exit("startSummitTransmitterInitRules", (Object)bl);
        return bl;
    }

    private void addSelectiveTabs() {
        LOG.enter("addSelectiveTabs");
        this.m_tabbedPane.insertTab("Power Supply", null, this.m_pwrSupply, null, 0);
        this.m_pwrSupply.setEnabled(false);
        if (!this.m_isRxOnly && (Devices.isConvBrApplication((String)this.appHWCombination).booleanValue() || Devices.isMsBR3600Application((String)this.appHWCombination).booleanValue() || Devices.isIR3600Application((String)this.appHWCombination).booleanValue() || Devices.isMsBrApplication((String)this.appHWCombination).booleanValue() || Devices.isHpdBrApplication((String)this.appHWCombination).booleanValue() || Devices.isIsrApplication((String)this.appHWCombination).booleanValue())) {
            this.m_tabbedPane.insertTab("Transmitter", null, this.m_transmitter, null, 1);
            this.m_transmitter.setEnabled(false);
        }
        LOG.exit("addSelectiveTabs");
    }

    @Override
    public void initialize() {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter initialize()"});
        this.initializeSelectiveTabs();
        this.m_tabbedPane.setSelectedIndex(0);
        LOG.exit("SummitMeteringScreen", (Object)"Exit initialize()");
    }

    private void initializeSelectiveTabs() {
        LOG.enter("initializeSelectiveTabs");
        this.m_isRxOnly = CSSUtilities.isApplicationRxOnly();
        this.m_transmitter.setRxOnly(this.m_isRxOnly);
        this.m_pwrSupply.initialize();
        if (!this.m_isRxOnly) {
            this.m_transmitter.initialize();
        }
        LOG.exit("initializeSelectiveTabs");
    }

    public void realTimeUpdate(Object object) {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter realTimeUpdate."});
        RealTimeDataObject realTimeDataObject = (RealTimeDataObject)object;
        int n = realTimeDataObject.getError();
        if (n != 0) {
            byte[] byArray = null;
            Integer n2 = null;
            if (realTimeDataObject instanceof FspRealTimeDataObject) {
                byArray = ((FspRealTimeDataObject)realTimeDataObject).getData();
                n2 = Convert.toInteger((byte[])byArray);
            }
            switch (n) {
                case 9: {
                    this.m_transmitter.showErrorForTransmitterTest(n2);
                    break;
                }
                case -262160: {
                    this.popupError(-262160);
                    this.close();
                    break;
                }
                case -262184: {
                    LOG.warn((Object)"Device is resetting.");
                    this.close();
                    break;
                }
                default: {
                    if (DeviceErrorCodes.isInGeneralErrorRange(n2)) {
                        LOG.error((Object)("realTimeUpdate - Error data: " + n2));
                        this.popupError(n2);
                        break;
                    }
                    LOG.error(new Object[]{"SummitMeteringScreen", "realTimeUpdate - Unknown error code: " + n});
                    break;
                }
            }
        } else {
            boolean bl = this.m_transmitter.realTimeUpdate(realTimeDataObject);
            if (!bl) {
                bl = this.m_pwrSupply.realTimeUpdate(realTimeDataObject);
            }
            if (!bl) {
                LOG.warn((Object)"Name not found");
            }
        }
        LOG.exit("SummitMeteringScreen", (Object)"Exit realTimeUpdate");
    }

    public Object[] startSession() {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter startSession()"});
        Byte by = new Byte(0);
        Byte by2 = new Byte(0);
        Object[][] objectArray = BrCommonTranslationInfoRules.BrCommonMeasurementRules;
        Object[] objectArray2 = new Object[]{by, by2, objectArray};
        LOG.exit("SummitMeteringScreen", (Object)"Exit startSession()");
        return objectArray2;
    }

    public void handleStartSession(int n) {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter handleStartSession(): Error = " + n});
        if (n != 0) {
            this.popupError("unable_to_start_session");
            LOG.error(new Object[]{"SummitMeteringScreen", "Cannot start Measurement Session error"});
            this.close();
        }
        LOG.exit("SummitMeteringScreen", (Object)"Exit handleStartSession");
    }

    public void handleStopSession(int n) {
        LOG.enter("SummitMeteringScreen", new Object[]{"Enter handleStopSession(): g_error = " + n});
        if (n != 0) {
            LOG.error(new Object[]{"SummitMeteringScreen", "Received error " + n + " while trying to close session"});
        }
        LOG.exit("SummitMeteringScreen", (Object)"Exit handleStopSession()");
    }

    public void updateModeDependencies(int n, Integer n2) {
        LOG.enter("updateModeDependencies", new Object[]{n, n2});
        if (n == 0) {
            this.nCurrentDeviceMode = n2;
            if (this.nCurrentDeviceMode == 2) {
                this.m_transmitter.setNormalMode(true);
                this.m_transmitter.updateNormalModeDependencies();
            } else {
                this.m_transmitter.setNormalMode(false);
                this.m_transmitter.updateOtherThanNormalModeDependencies();
            }
        } else {
            LOG.warn((Object)"Unable to get Device Mode.");
            PnmDialog.error((Object)this.m_window, (String)"unable_to_get_mode");
            this.close();
        }
        LOG.exit("updateModeDependencies");
    }

    public boolean isIsrOrConvBr() {
        return this.isIsrOrConvBr;
    }

    public boolean isIsrOrConvBrInNormalMode() {
        return this.isIsrOrConvBr && this.nCurrentDeviceMode == 2;
    }
}

