/*
 * Decompiled with CFR 0.152.
 */
package css.device.sc_platform.common.screens.referenceservice;

import css.core.screens.tools.StatusBarListener;
import css.core.util.CssLogger;
import css.core.util.component.CssJTable;
import css.core.util.popup.ErrorPopup;
import css.device.common.screens.GenericScreen;
import css.device.sc_platform.common.screens.referenceservice.RDMRequestedSourcesPanel;
import css.device.sc_platform.common.screens.referenceservice.TimeReferenceSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import pnm.ui.UIInternalFrame;

public abstract class ReferenceServiceScreenGUI
extends GenericScreen {
    private static final long serialVersionUID = 1L;
    private static final String[] TABLE_HEADERS = new String[]{"Number", "Source Type", "Source State", "Alignment"};
    private static final String[] TABLE_TOOLTIPS = new String[]{"Indicates the number of Time Reference.", "Indicates the type of Time Reference Source (GPS or Redundant).", "Indicates the state of the 1PPS external time reference source.", "Indicates the alignment of the 1PPS time references relative to the time reference being output from the RDM module."};
    private static final int TABLE_ROWS = 2;
    private static final int TABLE_COLS = 4;
    private static final int COL_NUMBER = 0;
    private static final int COL_SOURCE_TYPE = 1;
    private static final int COL_SOURCE_STATE = 2;
    private static final int COL_ALIGNMENT = 3;
    private static final String BUTTON_CAPTION = "Refresh";
    private static final String BUTTON_TOOLTIP = "Get the latest Reference Service information from the device.";
    private static final String BUTTON_STATUS = "Click this button to get the latest Reference Service information from the device.";
    private static final String TIME_REFERENCE_STATUS = "Time Reference Status";
    protected boolean bError = false;
    protected ErrorPopup m_errorPopup = new ErrorPopup();
    private static final HashMap<Integer, String> mapSourceState = new HashMap();
    private static final CssLogger LOG;
    private CssJTable m_oTimeRefTable = null;
    private JButton m_oRefreshButton = null;
    private JScrollPane m_oScrollPane = null;
    protected RDMRequestedSourcesPanel m_RDMRequestedSourcesPanel = null;

    public ReferenceServiceScreenGUI() {
        this.initialize();
    }

    @Override
    public void initialize() {
        this.setSize(new Dimension(318, 184));
        this.add((Component)this.getRefreshButton(), null);
    }

    public void buildScreen(UIInternalFrame uIInternalFrame, StatusBarListener statusBarListener) {
        LOG.enter("buildScreen");
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(372, 200));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(TIME_REFERENCE_STATUS));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createScrollPane(), "First");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2, 5, 5));
        jPanel2.add(this.createRefreshButton());
        jPanel.add((Component)jPanel2, "Last");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 20;
        this.m_RDMRequestedSourcesPanel = new RDMRequestedSourcesPanel();
        this.m_RDMRequestedSourcesPanel.setEnabled(false);
        this.add((Component)this.m_RDMRequestedSourcesPanel, gridBagConstraints);
        statusBarListener.registerComponent((Component)this.m_oRefreshButton, BUTTON_STATUS);
        this.m_window = uIInternalFrame;
        LOG.exit("buildScreen");
    }

    private JTable createTimeRefTable() {
        LOG.enter("createTimeRefTable");
        Object[][] objectArray = new Object[2][4];
        for (int i = 0; i < 2; ++i) {
            objectArray[i] = new Object[]{"", "", "", ""};
        }
        if (null == this.m_oTimeRefTable) {
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, TABLE_HEADERS);
            this.m_oTimeRefTable = new CssJTable(defaultTableModel){
                private static final long serialVersionUID = 1L;

                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.m_oTimeRefTable.setShowHorizontalLines(true);
            this.m_oTimeRefTable.setShowVerticalLines(true);
            this.m_oTimeRefTable.setAllHeadersTooltips(TABLE_TOOLTIPS);
            this.m_oTimeRefTable.getTableHeader().setReorderingAllowed(false);
            this.m_oTimeRefTable.setAutoResizeMode(4);
            this.m_oScrollPane.add((Component)this.m_oTimeRefTable);
        }
        LOG.exit("createTimeRefTable");
        return this.m_oTimeRefTable;
    }

    public JButton getRefreshButton() {
        LOG.enter("getRefreshButton");
        LOG.exit("enclosing_method");
        return this.m_oRefreshButton;
    }

    private JButton createRefreshButton() {
        LOG.enter("createRefreshButton");
        if (this.m_oRefreshButton == null) {
            this.m_oRefreshButton = new JButton();
            this.m_oRefreshButton.setText(BUTTON_CAPTION);
            this.m_oRefreshButton.setPreferredSize(new Dimension(100, 26));
            this.m_oRefreshButton.setMaximumSize(new Dimension(100, 26));
            this.m_oRefreshButton.setToolTipText(BUTTON_TOOLTIP);
            this.m_oRefreshButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    LOG.enter("actionPerformed");
                    ReferenceServiceScreenGUI.this.bError = false;
                    LOG.exit("actionPerformed");
                }
            });
        }
        LOG.exit("createRefreshButton");
        return this.m_oRefreshButton;
    }

    private JScrollPane createScrollPane() {
        LOG.enter("createScrollPane");
        if (this.m_oScrollPane == null) {
            this.m_oScrollPane = new JScrollPane();
            this.m_oScrollPane.setPreferredSize(new Dimension(356, 59));
            this.m_oScrollPane.setViewportView(this.createTimeRefTable());
        }
        LOG.exit("createScrollPane");
        return this.m_oScrollPane;
    }

    public void setRefSvcInstance(int n, Integer n2) {
        LOG.enter("setRefSvcInstance");
        this.m_oTimeRefTable.setValueAt((Object)n2, n, 0);
        LOG.exit("setRefSvcSourceType");
    }

    public void setRefSvcSourceType(int n, TimeReferenceSource timeReferenceSource) {
        LOG.enter("setRefSvcSourceType");
        this.m_oTimeRefTable.setValueAt((Object)(timeReferenceSource == null ? "" : timeReferenceSource.toString()), n, 1);
        LOG.exit("setRefSvcSourceType");
    }

    public void setRefSvcSourceState(int n, Integer n2) {
        LOG.enter("setRefSvcSourceState");
        String string = mapSourceState.get(n2);
        this.m_oTimeRefTable.setValueAt((Object)(string == null ? "" : string), n, 2);
        LOG.exit("setRefSvcSourceState");
    }

    public void setRefSvcAlignment(int n, Integer n2) {
        LOG.enter("setRefSvcAlignment");
        this.m_oTimeRefTable.setValueAt((Object)n2, n, 3);
        LOG.exit("setRefSvcAlignment");
    }

    public JButton getApplyButton() {
        return this.m_RDMRequestedSourcesPanel.getApplyButton();
    }

    static {
        mapSourceState.put(new Integer(1), new String("Inactive"));
        mapSourceState.put(new Integer(2), new String("Standby"));
        mapSourceState.put(new Integer(3), new String("Active"));
        LOG = CssLogger.getCssLogger(ReferenceServiceScreenGUI.class);
    }
}

