/*
 * Decompiled with CFR 0.152.
 */
package css.metadata.common_br.validation;

import css.core.util.CssLogger;

public class BrConstants {
    private static final CssLogger LOG = CssLogger.getCssLogger(BrConstants.class);
    public static final String AUTOCALC_FIELD = "br_autocalculate_freq_fld";
    public static final String TX_FREQ_FIELD = "br_channel_tx_freq_fld";
    public static final String RX_FREQ_FIELD = "br_channel_rx_freq_fld";
    public static final String TX_FREQ_MIN_FIELD = "brExciterTxMinFreq";
    public static final String TX_FREQ_MAX_FIELD = "brExciterTxMaxFreq";
    public static final String RX_FREQ_MIN_FIELD = "brReceiverRxMinFreq";
    public static final String RX_FREQ_MAX_FIELD = "brReceiverRxMaxFreq";
    public static final String BR_FREQ_REFERENCE_FIELD = "brFreqRefReq";
    public static final String BR_TIME_REFERENCE_FIELD = "brTimeRefReq";
    public static final String BR_TIME_REFERENCE_ACT_FIELD = "hiddenBrTimeRefAct";
    public static final String BR_TOC_ACTUAL_FIELD = "brActualTransceiverOptionCardStatus";
    public static final String BR_TOC_FIELD = "convBRSacCardOption";
    public static final String BR_FIELD_STATION_TYPE = "brStationType";
    public static final String BR_FIELD_DIGITAL_IDLE_LNK_CHK = "brDigIdleLink";
    public static final int BR_FREQ_REF_INTEGRATED_REF_AB = 9;
    public static final int BR_FREQ_REF_EXT_5_BACK_PANEL = 3;
    public static final int BR_TIME_REF_COMBINED_WITH_FREQ_REF = 2;
    public static final int BR_TIME_REF_INDEPENDENT_FROM_FREQ_REF = 3;
    public static final int BR_TIME_REF_NONE = 1;
    public static final String OID_CENTRAL_AUTHENTICATION = ".1.3.6.1.4.1.161.3.5.13.2.1.0";
    public static final String BR_TOC_ACTUAL_DETECTED = "1";
    public static final String BR_TOC_ACTUAL_NOT_DETECTED = "2";
    public static final String BR_TOC_REQ = "1";
    public static final String BR_TOC_NOT_REQ = "2";
    public static final String TX_MODULATION_TYPE_LSM = "1";
    public static final String TX_POWER_LSM_VALUE = "50";
    public static final String TX_MODULATION_TYPE_LSM_WORN = "lsm_modulation_warning";
    public static final String CONVBR_HWCONFIG_TXPOWEROUT = "hwconfig_txPowerOut";
    public static final String LSS_HWCONFIG_TXPOWEROUT = "hwconfig_txPowerOut";
    public static final String ISR_HWCONFIG_TXPOWEROUT = "brPwrAmpTxPwrOutReq";
    public static final String CONVBR_BATTERY_BACKUP = "convbrPwrSupplyTxPwrLvlBattBck";
    public static final String LSS_BATTERY_BACKUP = "lssPwrSupplyTxPwrLvlBattBck";
    public static final String ISR_BATTERY_BACKUP = "brPwrAmpTxPwrLvlBattBck";
    public static final String CONVBR_TX_MODULATION_TYPE = "convbr_channel_tx_modulation_type";
    public static final String LSS_TX_MODULATION_TYPE = "lss_channel_tx_modulation_type";
    public static final String ISR_TX_MODULATION_TYPE = "isrExciterTxModType";
    public static final String LSS_HARDWARE_PLATFORM = "lss_txservice";
    public static final String HW_GTR_8000 = "1";
    public static final String HW_RX_ONLY = "2";
    public static final int VAL_STATION_TYPE_ASTRO_CAI = 1;
    public static final int VAL_STATION_TYPE_ANALOG_ONLY = 2;
    public static final String SYSTEM_GAIN_FIELD = "system_gain";
    public static final String BR_RMC_GAIN_FIELD = "brRMCGain";
    public static final int RMC_SYSTEM_GAIN_THRESHOLD = 128;
    public static final String BR_RMC_CONFIG_FIELD = "brRMCConfigSetting";
    public static final String BR_SITE_RMC_CONFIG_FIELD = "brSiteRMCConfigSetting";
    public static final String SITE_RMC_ATTENUATION_FIELD = "site_rmc_attenuation";
    public static final String CABINET_RMC_ATTENUATION_FIELD = "cabinet_rmc_attenuation";
    public static final String BR_SITE_RMC_ATTENUATIONN_FIELD = "brSiteRMCAttenuation";
    public static final String BR_CABINET_RMC_ATTENUATION_FIELD = "brCabinetRMCAttenuation";
    public static final String XCVR_ELEC_ATTEN_FIELD = "brXcvrElecAtten";
    public static final String BR_CABINET_RMC_CONFIG_FIELD = "brCabinetRMCConfigSetting";
    public static final String BR_POWER_SUPPLY_TYPE_ACTUAL = "brPwrSupplyTypeAct";
    public static final String BR_POWER_SUPPLY_TYPE_REQUESTED = "brPwrSupplyTypeReq";
    public static final String BR_RF_THRESHOLD_FIELD = "display_RFThre";
    public static final String BR_FIELD_RTTE_CAPABLE = "brRTTECapable";
    public static final String BR_FIELD_RTTE_MODE = "brRTTEMode";
    public static final int RMC_BASE_RADIO_STANDALONE = 1;
    public static final int RMC_EXPANDABLE_SITE_SUBSYSTEM = 3;
    public static final int RMC_EMULATES_STR_3000 = 4;
    public static final int RMC_EMULATES_QUANTAR = 5;
    public static final String RMC_CONFIG_ENUM_ID_800_MHZ = "0";
    public static final String RMC_CONFIG_ENUM_ID_UHF_VHF = "1";
    public static final String RMC_CONFIG_ENUM_ID_900_MHZ = "2";
    public static final String RMC_CONFIG_ENUM_ID_700_MHZ = "3";
    public static final String RMC_CONFIG_ENUM_VALUE_UHF_VHF = Integer.toString(1);
    public static final String INSTALLED = "1";
    public static final String NOT_INSTALLED = "2";
    public static final String PASS_THRU_INSTALLED = "3";
    public static final String RMC_ATTENUATION_NOT_APPLICABLE_VALUE = "32";
    public static final String RMC_NOT_APPLICABLE_STRING = "Not Applicable";
    public static final int MIN_UHF_RANGE = 380000000;
    public static final int MAX_UHF_RANGE = 524000000;
    public static final int MIN_VHF_RANGE = 132000000;
    public static final int MAX_VHF_RANGE = 174000000;
    public static final int MIN_UHF_RX_R1_RANGE = 380000000;
    public static final int MAX_UHF_RX_R1_RANGE = 434999999;
    public static final int MIN_UHF_RX_R2_RANGE = 435000000;
    public static final int MAX_UHF_RX_R2_RANGE = 524000000;
    @Deprecated
    public static final int MIN_UHF_TX_RANGE = 380000000;
    @Deprecated
    public static final int MAX_UHF_TX_RANGE = 524000000;
    @Deprecated
    public static final int MIN_VHF_TX_RANGE = 132000000;
    @Deprecated
    public static final int MAX_VHF_TX_RANGE = 174000000;
    @Deprecated
    public static final int MIN_UHF_RX_RANGE = 380000000;
    @Deprecated
    public static final int MAX_UHF_RX_RANGE = 524000000;
    @Deprecated
    public static final int MIN_VHF_RX_RANGE = 132000000;
    @Deprecated
    public static final int MAX_VHF_RX_RANGE = 174000000;
    public static final int MIN_900_TX_RANGE = 935006250;
    public static final int MAX_900_TX_RANGE = 940993750;
    public static final int MIN_800_TX_RANGE = 851006250;
    public static final int MAX_800_TX_RANGE = 869993750;
    public static final int MIN_700_TX_RANGE = 762006250;
    public static final int MAX_700_TX_RANGE = 775993750;
    public static final int MIN_900_RX_RANGE = 896006250;
    public static final int MAX_900_RX_RANGE = 901993750;
    public static final int MIN_800_RX_RANGE = 806006250;
    public static final int MAX_800_RX_RANGE = 824993750;
    public static final int MIN_700_RX_RANGE = 792006250;
    public static final int MAX_700_RX_RANGE = 805993750;
    public static final int DISABLED = 2;
    public static final int ENABLED = 1;
    public static final String FALSE = "2";
    public static final String TRUE = "1";
    private static final int[] SPLINTER_FREQUENCIES = new int[]{154371250, 154463750, 154471250, 154478750, 169172000, 169807000, 173203750, 173396250, 173435700};
    public static final int[] SPLINTER_FREQUENCIES_CONVBR_3600 = new int[]{148082500, 152007500, 153007500, 153492500, 154371250, 154463750, 154471250, 154478750, 154502500, 169172000, 169807000, 173203750, 173396250, 173435700};
    public static final String BR_CHANNEL_WINDOW = "br_channel";
    public static final String BR_CONFIG_WINDOW = "br_configuration";
    public static final String BR_SYSTEM_ID = "brSystemID";
    public static final String BR_SITE_SYSTEM_ID = "site_brSystemID";
    public static final String BR_ACI_REQUESTED = "brAciRequested";
    public static final String BR_NAC = "brNAC";
    public static final int BR_PWR_AC_48VDC_BATTERY_CHARGER = 11;
    public static final int BR_PWR_AC_48VDC = 12;
    public static final int BR_PWR_48VDC = 13;
    public static final int BR_PWR_AUX = 15;
    public static final int BR_PWR_UNKN = 16;

    @Deprecated
    public boolean isFreqInVHFTxRange(int n) {
        LOG.enter("isFreqInVHFTxRange", new Object[]{new Integer(n)});
        boolean bl = 132000000 <= n && n <= 174000000;
        LOG.exit("isFreqInVHFTxRange", (Object)bl);
        return bl;
    }

    @Deprecated
    public boolean isFreqInVHFRxRange(int n) {
        LOG.enter("isFreqInVHFRxRange", new Object[]{new Integer(n)});
        boolean bl = 132000000 <= n && n <= 174000000;
        LOG.exit("isFreqInVHFRxRange", (Object)bl);
        return bl;
    }

    @Deprecated
    public boolean isFreqInUHFTxRange(int n) {
        LOG.enter("isFreqInUHFTxRange", new Object[]{new Integer(n)});
        boolean bl = 380000000 <= n && n <= 524000000;
        LOG.exit("isFreqInUHFTxRange", (Object)bl);
        return bl;
    }

    @Deprecated
    public boolean isFreqInUHFRxRange(int n) {
        LOG.enter("isFreqInUHFRxRange", new Object[]{new Integer(n)});
        boolean bl = 380000000 <= n && n <= 524000000;
        LOG.exit("isFreqInUHFRxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqInUHFRange(int n) {
        boolean bl = 380000000 <= n && n <= 524000000;
        return bl;
    }

    public boolean isFreqInVHFRange(int n) {
        boolean bl = 132000000 <= n && n <= 174000000;
        return bl;
    }

    public boolean isFreqInUHFRxR1Range(int n) {
        LOG.enter("isFreqInUHFRxR1Range", new Object[]{new Integer(n)});
        boolean bl = 380000000 <= n && n <= 434999999;
        LOG.exit("isFreqInUHFRxR1Range", (Object)bl);
        return bl;
    }

    public boolean isFreqInUHFRxR2Range(int n) {
        LOG.enter("isFreqInUHFRxR2Range", new Object[]{new Integer(n)});
        boolean bl = 435000000 <= n && n <= 524000000;
        LOG.exit("isFreqInUHFRxR2Range", (Object)bl);
        return bl;
    }

    public boolean isFreqIn900TxRange(int n) {
        LOG.enter("isFreqIn900TxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin900TxRange() <= n && n <= this.getMax900TxRange();
        LOG.exit("isFreqIn900TxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqIn900RxRange(int n) {
        LOG.enter("isFreqIn900RxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin900RxRange() <= n && n <= this.getMax900RxRange();
        LOG.exit("isFreqIn900RxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqIn800TxRange(int n) {
        LOG.enter("isFreqIn800TxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin800TxRange() <= n && n <= this.getMax800TxRange();
        LOG.exit("isFreqIn800TxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqIn800RxRange(int n) {
        LOG.enter("isFreqIn800RxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin800RxRange() <= n && n <= this.getMax800RxRange();
        LOG.exit("isFreqIn800RxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqIn700TxRange(int n) {
        LOG.enter("isFreqIn700TxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin700TxRange() <= n && n <= this.getMax700TxRange();
        LOG.exit("isFreqIn700TxRange", (Object)bl);
        return bl;
    }

    public boolean isFreqIn700RxRange(int n) {
        LOG.enter("isFreqIn700RxRange", new Object[]{new Integer(n)});
        boolean bl = this.getMin700RxRange() <= n && n <= this.getMax700RxRange();
        LOG.exit("isFreqIn700RxRange", (Object)bl);
        return bl;
    }

    public boolean isSplinterFreq(int n) {
        LOG.enter("isSplinterFreq", new Object[]{new Integer(n)});
        boolean bl = false;
        for (int i = 0; i < SPLINTER_FREQUENCIES.length; ++i) {
            if (SPLINTER_FREQUENCIES[i] != n) continue;
            bl = true;
            break;
        }
        LOG.exit("isSplinterFreq", (Object)bl);
        return bl;
    }

    protected int getMin900TxRange() {
        return 935006250;
    }

    protected int getMax900TxRange() {
        return 940993750;
    }

    protected int getMin800TxRange() {
        return 851006250;
    }

    protected int getMax800TxRange() {
        return 869993750;
    }

    protected int getMin700TxRange() {
        return 762006250;
    }

    protected int getMax700TxRange() {
        return 775993750;
    }

    protected int getMin900RxRange() {
        return 896006250;
    }

    protected int getMax900RxRange() {
        return 901993750;
    }

    protected int getMin800RxRange() {
        return 806006250;
    }

    protected int getMax800RxRange() {
        return 824993750;
    }

    protected int getMin700RxRange() {
        return 792006250;
    }

    protected int getMax700RxRange() {
        return 805993750;
    }
}

